<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  제목 없음
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">일요일</xsl:if>
  <xsl:if test=".='2'">월요일</xsl:if>
  <xsl:if test=".='3'">화요일</xsl:if>
  <xsl:if test=".='4'">수요일</xsl:if>
  <xsl:if test=".='5'">목요일</xsl:if>
  <xsl:if test=".='6'">금요일</xsl:if>
  <xsl:if test=".='7'">토요일</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">일</xsl:if>
  <xsl:if test="$downum='2'">월</xsl:if>
  <xsl:if test="$downum='3'">화</xsl:if>
  <xsl:if test="$downum='4'">수</xsl:if>
  <xsl:if test="$downum='5'">목</xsl:if>
  <xsl:if test="$downum='6'">금</xsl:if>
  <xsl:if test="$downum='7'">토</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1월</xsl:if>
  <xsl:if test=".='02'">2월</xsl:if>
  <xsl:if test=".='03'">3월</xsl:if>
  <xsl:if test=".='04'">4월</xsl:if>
  <xsl:if test=".='05'">5월</xsl:if>
  <xsl:if test=".='06'">6월</xsl:if>
  <xsl:if test=".='07'">7월</xsl:if>
  <xsl:if test=".='08'">8월</xsl:if>
  <xsl:if test=".='09'">9월</xsl:if>
  <xsl:if test=".='10'">10월</xsl:if>
  <xsl:if test=".='11'">11월</xsl:if>
  <xsl:if test=".='12'">12월</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1월</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2월</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3월</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4월</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5월</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6월</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7월</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8월</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9월</xsl:if>
  <xsl:if test="$MonthNum=10">10월</xsl:if>
  <xsl:if test="$MonthNum=11">11월</xsl:if>
  <xsl:if test="$MonthNum=12">12월</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1월</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2월</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3월</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4월</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5월</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6월</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7월</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8월</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9월</xsl:if>
  <xsl:if test="$MonthNum=10">10월</xsl:if>
  <xsl:if test="$MonthNum=11">11월</xsl:if>
  <xsl:if test="$MonthNum=12">12월</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      입력한 날짜와 시간이 유효하지 않습니다. 올바른 값을 입력하십시오.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      이 이름을 가진 달력이 이미 있습니다. 다른 이름을 선택하십시오.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      이 이름을 가진 그룹이 이미 있습니다. 다른 이름을 선택하십시오.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 대상 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      이 검색으로 인해 디렉토리 서버에 문제가 발생했습니다.&nbsp;      다른 검색 문자열을 입력하십시오.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      디렉토리 서버에 연결하지 못했습니다.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      디렉토리 서버에 연결하지 못했습니다.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      이 검색으로 인해 디렉토리 서버에 문제가 발생했습니다.&nbsp;      다른 검색 문자열을 입력하십시오.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 오류: 이벤트가 삭제되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 오류: 지원되지 않는 구현입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 오류: malloc이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 오류: GSE의 여러 인스턴스를 만들 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 오류: GSE 항목이 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 오류: 이벤트가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 오류: 전송 인터페이스를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 오류: 구성 도우미 달력에서 참석자를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 오류: lock, GDisp 등의 자원을 만들 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 오류: SMTP 사용자 대신 iCS 사용자를 불러올 것으로 예상됩니다.
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 오류: 구성 요소 메소드 및 상태가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 오류: 요청한 시간이 기존의 다른 회의 요청 시간과 충돌합니다.
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB 오류: 구성 요소를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB 오류: 입출력 오류입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB 오류: 하나 이상의 이벤트 값이 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB 오류: 함수 호출이 제공된 구성 요소에서 작동하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB 오류: 요청된 쿼리는 알 수 없거나 지원되지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB 오류: 필수 매개 변수가 NULL이거나 설정되지 않았거나 존재하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB 오류: 요청한 SequenceNo 상태 확인의 실패로 인해 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB 오류: 요청한 수정 시간 상태 확인의 실패로 인해 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB 오류: 달력에서 약속 중복을 허용하지 않으므로 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB 오류: ENS 알림이 오류를 반환했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB 오류: 필수 값이 null입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      초대 받은 사람 오류: 잘못된 인수입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      초대 받은 사람 오류: 달력을 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      초대 받은 사람 오류: 달력이 사용 불가능한 상태입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      초대 받은 사람 오류: 사용자가 달력에 액세스할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      초대 받은 사람 오류: 그룹이 삭제되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      초대 받은 사람 오류: 구성 도우미를 제거할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      달력 오류: 달력 작성이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      달력 오류: ID가 같은 달력이 이미 있습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      달력 오류: 이 작업을 수행하는 데 필요한 액세스 권한이 없습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      달력 오류: 액세스하려고 시도한 달력은 존재하지 않습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      달력 오류: 달력 ID가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      초대 받은 사람 오류: 초대할 사람을 이중으로 예약할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      달력 오류: 이 작업을 수행하는 데 필요한 액세스 권한이 없습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      달력 오류: 이 작업은 소유자 또는 공동 소유자만 수행할 수 있습니다.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      달력 오류: 읽기 전용 모드 데이터베이스입니다.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      사용 가능한 시간을 찾으려면 가용성 탭을 참조하십시오.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      그룹 오류: 그룹 ID가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      달력 오류: 개인 정보 또는 소유자 목록에 알 수 없는 사용자를 추가할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 오류: 메일 호스트가 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 오류: 연결이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 오류: 연결에 대한 예상 응답이 발생되지 않았습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 오류: 메시지의 주소를 지정하는 중 문제가 발생했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 오류: 수신자가 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      오류: 백엔드 데이터베이스에 연결하지 못했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      오류: 백엔드 데이터베이스에 대한 최대 연결 수에 도달했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      오류: 달력을 확인할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      오류: 연결할 수 없는 잘못된 데이터 백엔드 데이터베이스입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      오류: DWP 호스트 컨텍스트를 사용할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      오류: 확인할 수 없는 백엔드 호스트입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      오류: 데이터 없음 - 연결할 수 없는 백엔드 데이터베이스입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      오류: 백엔드 데이터베이스에 연결하지 못했습니다.
    </xsl:when>
    <xsl:otherwise>
      알 수 없음 오류 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      오류: 반복 이벤트의 한 인스턴스가 다른 인스턴스를 건너뛸 수 없습니다.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      오류: 반복 이벤트의 두 인스턴스가 같은 날 발생할 수 없습니다.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      오류: 한 인스턴스만 개인 정보를 변경할 수 없습니다.
    </xsl:when>
    <xsl:otherwise>
      알 수 없는 반복 오류 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">아메리카/에이덕</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">아메리카/앵커리지</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">아메리카/로스앤젤레스</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">아메리카/피닉스</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">아메리카/덴버</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">아메리카/코스타리카</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">아메리카/시카고</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">아메리카/인디애나폴리스</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">아메리카/뉴욕</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">아메리카/아바나</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">아메리카/포르토프랭스</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">아메리카/그랜드터크</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">아메리카/카라카스</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">아메리카/쿠이아바</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">아메리카/핼리팩스</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">아메리카/산티아고</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">대서양/스탠리</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">아메리카/세인트존스</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">아메리카/부에노스아이레스</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">아메리카/상파울루</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">아메리카/미클롱</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">아메리카/고드호프</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">대서양/사우스조지아</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">대서양/케이프베르데</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">대서양/아조레스</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">아프리카/카사블랑카</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">유럽/런던</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">아프리카/라고스</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">유럽/파리</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">아프리카/트리폴리</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">유럽/바르샤바</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">아프리카/요하네스버그</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">유럽/부쿠레슈티</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">유럽/이스탄불</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">아프리카/카이로</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">유럽/리가</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">아프리카/빈트후크</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">유럽/민스크</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">유럽/심페로폴</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">유럽/모스크바</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">유럽/사마라</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">아시아/베이루트</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">아시아/예루살렘</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">아시아/암만</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">아시아/리야드</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">아시아/테헤란</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">아시아/예레반</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">아시아/아크타우</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">아시아/바쿠</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">아시아/카불</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">아시아/카라치</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">아시아/악튜빈스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">아시아/비슈케크</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">아시아/예카테린부르크</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">아시아/캘커타</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">아시아/카트만두</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">아시아/다카</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">아시아/알마아타</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">아시아/노보시비르스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">아시아/랑군</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">아시아/방콕</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">아시아/크라스노야르스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">아시아/울란바토르</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">아시아/상하이</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">아시아/타이페이</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">아시아/이르쿠츠크</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">아시아/도쿄</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">아시아/서울</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">아시아/야쿠츠크</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">오스트레일리아/퍼스</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">오스트레일리아/다윈</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">오스트레일리아/애들레이드</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">오스트레일리아/브리즈번</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">오스트레일리아/시드니</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">오스트레일리아/호바트</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">아시아/블라디보스토크</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">오스트레일리아/로드하우</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">태평양/과달카날</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">태평양/누메아</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">아시아/마가단</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">태평양/노퍽</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">태평양/피지</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">태평양/오클랜드</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">아시아/캄차카</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">태평양/채텀</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">태평양/통가타푸</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">아시아/아나디르</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">태평양/키리티마티</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">태평양/아피아</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">태평양/호놀룰루</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">태평양/라로통가</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">태평양/마키저스</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">태평양/갬비어</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">태평양/핏케언</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">태평양/이스터</xsl:when> 
    <xsl:otherwise>
      알 수 없음 표준 시간대 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">종료 날짜 없음 </xsl:variable>
<xsl:variable name="cap_the_text">더 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 제거</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>환영합니다.  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>의 달력에 대한 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>태스크(</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>시작 시간 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1시간</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 분</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>2시간 이상</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 사용 가능)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 최대 수의 인스턴스 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 만들기</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>특정 지역의 하나 이상의 표준 시간대가 현재 달력과 연결될 수 있습니다. 일 보기와 같이 눈금이 표시된 보기에서, 달력과 연결된 모든 표준 시간대는 보기의 시간 단위의 일부가 됩니다. 이 달력에 지정한 표준 시간대가 없는 경우에는 기본 표준 시간대가 사용됩니다. 다음 표준 시간대가 사용 가능합니다. </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>특정 지역의 한 표준 시간대가 현재 달력과 연결될 수 있습니다. 일 보기와 같이 눈금이 표시된 보기에서, 달력과 연결된 표준 시간대는 보기의 시간 단위의 일부가 됩니다. 이 달력에 지정한 표준 시간대가 없는 경우에는 기본 표준 시간대가 사용됩니다. 다음 표준 시간대가 사용 가능합니다. </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>북아메리카/남아메리카 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>유럽/아프리카 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>아시아/태평양 연안 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>지역:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>다음 이벤트가 달력에 추가되었습니다. "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>" 아래의 회신에 대한 해당 옵션을 선택하여 이 초대를 받아들이거나 거절할 수 있습니다.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>파일을 선택하려면</xsl:text>&nbsp;
  <B><xsl:text>찾아보기...</xsl:text></B>&nbsp;
  <xsl:text>누릅니다.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>이 패널을 사용하여 이벤트에 대한 초대를 받아들이거나 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 거절하거나 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 미정 상태 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 이벤트에 대한 초대</xsl:text>
  <br/>
  <xsl:text>반복 이벤트의 경우 설정이 전체 시퀀스에 적용됩니다.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>검색 결과는 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 자 미만의 문자로 검색한 결과는 완료되지 않을 수 있습니다. 보다 나은 결과를 얻으려면 적어도 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 자 이하입니다.</xsl:text>

</xsl:template>


</xsl:stylesheet>
