<?xml version="1.0"  encoding="utf-8"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  タイトルなし
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">日曜日</xsl:if>
  <xsl:if test=".='2'">月曜日</xsl:if>
  <xsl:if test=".='3'">火曜日</xsl:if>
  <xsl:if test=".='4'">水曜日</xsl:if>
  <xsl:if test=".='5'">木曜日</xsl:if>
  <xsl:if test=".='6'">金曜日</xsl:if>
  <xsl:if test=".='7'">土曜日</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">月</xsl:if>
  <xsl:if test="$downum='3'">火</xsl:if>
  <xsl:if test="$downum='4'">水</xsl:if>
  <xsl:if test="$downum='5'">木</xsl:if>
  <xsl:if test="$downum='6'">金</xsl:if>
  <xsl:if test="$downum='7'">土</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      入力した日時は無効です。修正してください。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      すでに同じ名前のカレンダーがあります。別の名前を指定してください。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      すでに同じ名前のグループがあります。別の名前を指定してください。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> to </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      この検索でディレクトリサーバーに問題が発生しました。&nbsp;
      別の検索文字列を指定してください。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      ディレクトリサーバーに接続できませんでした。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      ディレクトリサーバーに接続できませんでした。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      この検索でディレクトリサーバーに問題が発生しました。&nbsp;
      別の検索文字列を指定してください。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE エラー: 予定が削除されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE エラー: 実装はサポートされていません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE エラー: malloc に失敗しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE エラー: GSE の複数インスタンスを作成できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE エラー: GSE エントリが無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE エラー: 予定が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE エラー: トランスポートインタフェースが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE エラー: 出席者または開催者のカレンダーに出席者が見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE エラー: lock、GDisp などのリソースを作成できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE エラー: iCS ユーザーが必要ですが SMTP ユーザーを受け取りました
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE エラー: コンポーネントメソッドおよび状態が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE エラー: 要求した時刻は、既存の会議要求と重複しています
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB エラー: コンポーネントが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB エラー: 入出力エラー
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB エラー: 予定の 1 つまたは複数の値が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB エラー: 機能呼び出しは、与えられたコンポーネントで使用できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB エラー: 要求したクエリーが不明であるか、サポートされていません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB エラー: 必要なパラメータが NULL であるか、設定されていないか、または存在しません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB エラー: 要求した SequenceNo の条件チェックが失敗したため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB エラー: 要求した変更時間の条件チェックが失敗したため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB エラー: カレンダーでは重複する予定は許可されないため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB エラー: ENS がエラーを返しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB エラー: 必要な値が NULL です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      出席依頼エラー: 引数が正しくありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      出席依頼エラー: カレンダーが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      出席依頼エラー: カレンダーを使用できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      出席依頼エラー: カレンダーへのアクセス権がユーザーにありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      出席依頼エラー: グループがクリップされました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      出席依頼エラー: 開催者を削除できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      カレンダーエラー: カレンダーを作成できませんでした
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      カレンダーエラー: すでに同じ識別子を持つカレンダーがあります
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      カレンダーエラー: この操作を実行するために必要なアクセス権がありません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      カレンダーエラー: アクセスしようとしているカレンダーが存在しません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      カレンダーエラー: 不正なカレンダー ID です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      出席依頼エラー: 出席予定者をダブルブッキングできません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      カレンダーエラー: この操作を実行するために必要なアクセス権がありません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      カレンダーエラー: 所有者または共同所有者でなければ、この操作は実行できません。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      カレンダーエラー: データベースは読み取り専用モードです。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      空き時間を確認するには、予定の確認タブを参照してください。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      グループエラー: 不正なグループ ID です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      カレンダーエラー: ユーザーが不明の場合はプライバシーまたは所有者リストには追加できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP エラー: メールホストがありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP エラー: 接続に失敗しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP エラー: 接続への応答がありませんでした
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP エラー: メッセージを配信できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP エラー: 受信者がいません
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      エラー: バックエンドデータベースに接続できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      エラー: バックエンドデータベースの最大接続数に達しました。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      エラー: カレンダーを解決できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      エラー: バックエンドデータベース中に不正なデータがあります。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      エラー: DWP ホストのコンテキストが存在しません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      エラー: バックエンドホストを解決できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      エラー: データがありません - バックエンドデータベースに到達できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      エラー: バックエンドデータベースに接続できません。
    </xsl:when>
    <xsl:otherwise>
      不明なエラー #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      エラー: 定期的な予定のある回が他の回を飛ばすことはできません。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      エラー: 定期的な予定の 2 つの回が同じ日に発生することはできません。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      エラー: 定期的な予定の 1 つの回だけについてプライバシーを変更できません。
    </xsl:when>
    <xsl:otherwise>
      不明な定期的予定のエラー #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">アメリカ/アダック</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">アメリカ/アンカレッジ</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">アメリカ/ロサンゼルス</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">アメリカ/フェニックス</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">アメリカ/デンバー</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">アメリカ/コスタリカ</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">アメリカ/シカゴ</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">アメリカ/インディアナポリス</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">アメリカ/ニューヨーク</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">アメリカ/ハバナ</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">アメリカ/ポルトープランス</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">アメリカ/グランドターク</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">アメリカ/カラカス</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">アメリカ/クヤバ</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">アメリカ/ハリファックス</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">アメリカ/サンチアゴ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋地域/スタンリー</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">アメリカ/セントジョンズ</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">アメリカ/ブエノスアイレス</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">アメリカ/サンパウロ</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">アメリカ/ミクロン</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">アメリカ/ゴッドホープ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋地域/サウスジョージア島</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋地域/カーボベルデ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋地域/アゾレス諸島</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">アフリカ/カサブランカ</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">ヨーロッパ/ロンドン</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">アフリカ/ラゴス</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">ヨーロッパ/パリ</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">アフリカ/トリポリ</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">ヨーロッパ/ワルシャワ</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">アフリカ/ヨハネスブルグ</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">ヨーロッパ/ブカレスト</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">ヨーロッパ/イスタンブール</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">アフリカ/カイロ</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">ヨーロッパ/リカ</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">アフリカ/ウィントフーク</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">ヨーロッパ/ミンスク</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">ヨーロッパ/シンフェロポリ</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">ヨーロッパ/モスクワ</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">ヨーロッパ/サマラ</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">アジア/ベイルート</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">アジア/エルサレム</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">アジア/アンマン</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">アジア/リヤド</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">アジア/テヘラン</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">アジア/イエレバン</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">アジア/シェフチェンコ</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">アジア/バクー</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">アジア/カブール</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">アジア/カラチ</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">アジア/アクチュビンスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">アジア/ビシュケク</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">アジア/スベルドロフスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">アジア/カルカッタ</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">アジア/カトマンズ</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">アジア/ダッカ</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">アジア/アルマアタ</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">アジア/ノボシビルスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">アジア/ラングーン</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">アジア/バンコク</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">アジア/クラスノヤルスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">アジア/ウランバートル</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">アジア/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">アジア/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">アジア/イルクーツク</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">アジア/東京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">アジア/ソウル</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">アジア/ヤクーツク</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">オーストラリア/パース</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">オーストラリア/ダーウィン</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">オーストラリア/アデレード</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">オーストラリア/ブリスベン</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">オーストラリア/シドニー</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">オーストラリア/ホバート</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">アジア/ウラジオストク</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">オーストラリア/ロードハウ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋地域/ガダルカナル島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋地域/ヌーメア</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">アジア/マガダン</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋地域/ノーフォーク島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋地域/フィジー</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋地域/オークランド</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">アジア/カムチャツカ</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋地域/チャタム</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋地域/トンガタプ</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">アジア/アナディル</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋地域/キリティマティ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋地域/アピア</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋地域/ホノルル</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋地域/ラロトンガ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋地域/マルケサス諸島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋地域/ガンビエル諸島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋地域/ピトケアン島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋地域/イースター島</xsl:when> 
    <xsl:otherwise>
      タイムゾーン番号が不明です<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">了解</xsl:variable>

<xsl:variable name="cancel_title">取消し</xsl:variable>
<xsl:variable name="close_title">閉じる</xsl:variable>
<xsl:variable name="help_title">ヘルプ</xsl:variable>
<xsl:variable name="apply_title">適用</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">予定は入っていません</xsl:variable>
<xsl:variable name="week_ahead_title">今後 1 週間</xsl:variable>
<xsl:variable name="alt_text_schedule">新しいアポイントのスケジュール設定</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">以下にユーザー名を入力して「OK」をクリックしてください。</xsl:variable>

<xsl:variable name="user_name_title">ユーザー名</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">前日に移動</xsl:variable>

<xsl:variable name="alt_jump_next_day">翌日に移動</xsl:variable>

<xsl:variable name="alt_jump_new_date">新しい日付に移動</xsl:variable>

<xsl:variable name="available_title">空き時間</xsl:variable>

<xsl:variable name="busy_title">予定あり</xsl:variable>

<xsl:variable name="hour_text">時間</xsl:variable>
<xsl:variable name="minutes_text">分</xsl:variable>

<xsl:variable name="show_availability_title">空き時間を表示</xsl:variable>

<xsl:variable name="error_cal_privacy">このカレンダーのプライバシー設定により表示できません。または、カレンダーが存在しません。</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">北米/南米</xsl:variable>

<xsl:variable name="europe_africa_title">ヨーロッパ/アフリカ</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">アジア/環太平洋</xsl:variable>

<xsl:variable name="time_zone_title">タイムゾーン</xsl:variable>

<xsl:variable name="gmt_offset_title">GMT (世界標準時) との差</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">グループ</xsl:variable>

<xsl:variable name="groups_msg">複数のカレンダーを同時に表示するにはカレンダーグループを使います。カレンダーグループを表示するには、グループ名のリンクをクリックします。グループにカレンダーを追加したり、グループからカレンダーを削除するには、そのカレンダーの「編集」リンクをクリックします。</xsl:variable>

<xsl:variable name="select_title">選択</xsl:variable>

<xsl:variable name="group_title">グループ</xsl:variable>

<xsl:variable name="group_colon_title">グループ:</xsl:variable>

<xsl:variable name="description_title">詳細</xsl:variable>

<xsl:variable name="properties_title">プロパティ</xsl:variable>

<xsl:variable name="error_cal_access">このカレンダーへのアクセス権がありません。</xsl:variable>

<xsl:variable name="error_cal_not_exist">このカレンダーは存在しません。</xsl:variable>

<xsl:variable name="edit_title">編集</xsl:variable>
<xsl:variable name="edit_calendar_title">カレンダーを編集</xsl:variable>

<xsl:variable name="remove_selected_title">削除</xsl:variable>

<xsl:variable name="calendars_title">カレンダー</xsl:variable>

<xsl:variable name="calendars_msg">所有しているか登録済みのカレンダーのリストが表示されます。カレンダーを表示するには、そのカレンダーの名前をクリックします。カレンダーを編集するには、「編集」をクリックします。</xsl:variable>

<xsl:variable name="calendar_title">カレンダー</xsl:variable>

<xsl:variable name="view_title">表示</xsl:variable>
<xsl:variable name="view_calendar_title">カレンダーを表示</xsl:variable>

<xsl:variable name="view_colon_title">表示:</xsl:variable>

<xsl:variable name="options_title">オプション</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">デフォルトのタイムゾーンの変更 : Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">概要</xsl:variable>

<xsl:variable name="day_tab_title">日別</xsl:variable>

<xsl:variable name="week_tab_title">週別</xsl:variable>

<xsl:variable name="month_tab_title">月別</xsl:variable>

<xsl:variable name="year_tab_title">年別</xsl:variable>

<xsl:variable name="comparison_tab_title">比較</xsl:variable>

<xsl:variable name="repeat_title">繰り返し</xsl:variable>

<xsl:variable name="change_repeat_title">繰り返しパターンの変更</xsl:variable>

<xsl:variable name="alt_jump_prev_month">前月に移動</xsl:variable>

<xsl:variable name="alt_jump_next_month">翌月に移動</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">今日の日付:</xsl:variable>

<xsl:variable name="alt_jump_this_date">この日付に移動</xsl:variable>

<xsl:variable name="action_items_title">アクション項目</xsl:variable>

<xsl:variable name="invitations_title">出席依頼</xsl:variable>

<xsl:variable name="no_invitations_msg">出席依頼なし</xsl:variable>

<xsl:variable name="tasks_title">作業</xsl:variable>

<xsl:variable name="overdue_msg">期限切れ</xsl:variable>

<xsl:variable name="no_tasks_msg">作業なし</xsl:variable>

<xsl:variable name="errors_title">エラー</xsl:variable>

<xsl:variable name="no_errors_msg">エラーなし</xsl:variable>

<xsl:variable name="daily_title">日ごと</xsl:variable>

<xsl:variable name="weekly_title">週ごと</xsl:variable>

<xsl:variable name="monthly_title">月ごと</xsl:variable>

<xsl:variable name="yearly_title">年ごと</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">繰り返しの選択 : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">今回のみ</xsl:variable>

<xsl:variable name="this_and_future_title">今回と今後の回</xsl:variable>

<xsl:variable name="all_instances_title">すべて</xsl:variable>

<xsl:variable name="repeating_selection_title">繰り返しの選択</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">今日が期限です。</xsl:variable>

<xsl:variable name="other_tasks_title">その他の作業</xsl:variable>

<xsl:variable name="overdue_tasks_title">期限を過ぎた作業</xsl:variable>

<xsl:variable name="all_day_events_title">終日予定</xsl:variable>

<xsl:variable name="conflict_msg">重複</xsl:variable>

<xsl:variable name="overdue_title">期限切れ</xsl:variable>

<xsl:variable name="due_at_title">期限</xsl:variable>

<xsl:variable name="untitled_task_title">タイトルなしの作業</xsl:variable>

<xsl:variable name="alt_view_this_task">この作業を表示</xsl:variable>

<xsl:variable name="alt_delete_this_task">この作業を削除</xsl:variable>

<xsl:variable name="untitled_event_title">タイトルなしの予定</xsl:variable>

<xsl:variable name="alt_delete_this_event">この予定を削除</xsl:variable>

<xsl:variable name="alt_view_this_event">この予定を表示</xsl:variable>

<xsl:variable name="all_day_title">終日</xsl:variable>

<xsl:variable name="overdue_from_title">期限の切れた日</xsl:variable>

<xsl:variable name="from_txt">&nbsp;</xsl:variable>

<xsl:variable name="due_on_title">期限日</xsl:variable>

<xsl:variable name="not_due_title">期限なし</xsl:variable>

<xsl:variable name="due_title">期限</xsl:variable>

<xsl:variable name="on_txt">&nbsp;</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">午前</xsl:variable>

<xsl:variable name="pm_txt">午後</xsl:variable>

<xsl:variable name="midnight_title">深夜 0 時</xsl:variable>

<xsl:variable name="noon_title">正午</xsl:variable>

<xsl:variable name="from_title">指定時刻</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">新しいアポイントのスケジュール設定</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">エラーリスト: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">このパネルには、未解決のスケジュールエラーが表示されています。</xsl:variable>

<xsl:variable name="organizer_title">開催者</xsl:variable>

<xsl:variable name="attendee_title">出席者</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">未解決のエラーはありません</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">定期的なスケジュールの設定: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">定期的なスケジュールの設定</xsl:variable>

<xsl:variable name="start_title">開始日</xsl:variable>

<xsl:variable name="end_title">終了日</xsl:variable>

<xsl:variable name="create_title">を作成</xsl:variable>

<xsl:variable name="events_text">予定</xsl:variable>

<xsl:variable name="alert_provide_valid_count">有効な回数を指定してください</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">以下の数を指定してください</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">この予定のアラームが予定開始後の時間に設定されています。前に戻って時間を変更する場合は、「キャンセル」をクリックしてください。</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">この作業のアラームが作業の期限後の時間に設定されています。前に戻って時間を変更する場合は、「キャンセル」をクリックしてください。</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">作成</xsl:variable>

<xsl:variable name="reminders_title">アラーム</xsl:variable>

<xsl:variable name="availability_title">空き時間</xsl:variable>

<xsl:variable name="preview_title">プレビュー</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">出席依頼リスト: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">削除</xsl:variable>

<xsl:variable name="recurring_event_msg">定期的な予定</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">保留中の出席依頼はありません</xsl:variable>

<xsl:variable name="all_title">すべて</xsl:variable>

<xsl:variable name="delete_all_title">すべて削除</xsl:variable>

<xsl:variable name="save_and_close_title">保存して閉じる</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">選択が空白です</xsl:variable>

<xsl:variable name="alert_min_year">1970 年より前の年は表示できません</xsl:variable>
<xsl:variable name="alert_max_year">2036 年より後の年は表示できません</xsl:variable>

<xsl:variable name="alert_invalid_date">日付が無効です。正しい日付を指定してください。</xsl:variable>

<xsl:variable name="january_title">1 月</xsl:variable>
<xsl:variable name="february_title">2 月</xsl:variable>
<xsl:variable name="march_title">3 月</xsl:variable>
<xsl:variable name="april_title">4 月</xsl:variable>
<xsl:variable name="may_title">5 月</xsl:variable>
<xsl:variable name="june_title">6 月</xsl:variable>
<xsl:variable name="july_title">7 月</xsl:variable>
<xsl:variable name="august_title">8 月</xsl:variable>
<xsl:variable name="september_title">9 月</xsl:variable>
<xsl:variable name="october_title">10 月</xsl:variable>
<xsl:variable name="november_title">11 月</xsl:variable>
<xsl:variable name="december_title">12 月</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">以下の月に対して有効な日付を入力してください:</xsl:variable>

<xsl:variable name="provide_good_date_msg">有効な日付を入力してください</xsl:variable>

<xsl:variable name="provide_good_month_msg">1 月から 12 月の間で入力してください</xsl:variable>

<xsl:variable name="provide_good_year_msg">有効な年を指定してください。\n\n年を 2 桁で表す場合、37 より小さい値は\n21 世紀の年と解釈されます。\n\nたとえば、03 は 2003 年です。</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">1971 年以降の年を入力してください</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">2036 年までの年を入力してください</xsl:variable>

<xsl:variable name="provide_good_hour_msg">12 時間モードでは、1 時から 12時の間で、24 時間モードでは、0 時 から 23 時の間で入力してください</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">0 時から 23 時の間で入力してください</xsl:variable>

<xsl:variable name="provide_good_minute_msg">0 分から 59 分の間で入力してください</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">終了日は開始日以降を指定してください</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">入力した日付が存在しません。\nもっとも近い有効な日付のカレンダーに設定します</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">日付に移動: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">前年に移動</xsl:variable>

<xsl:variable name="alt_jump_next_year">翌年に移動</xsl:variable>

<xsl:variable name="jump_to_date_title">日付に移動</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">このプライバシーエントリを削除してもよろしいですか。</xsl:variable>

<xsl:variable name="edit_calendar_page_title">カレンダーの編集: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">必要な情報を示します。</xsl:variable>

<xsl:variable name="calendar_name_msg">カレンダーに「baseball」などの短い名前をつけます (アスキー文字のみ使用できます。空白文字は使用できません)。</xsl:variable>

<xsl:variable name="display_name_title">表示名</xsl:variable>

<xsl:variable name="display_name_msg">このフィールドでは、カレンダーに「ビリーの野球スケジュール」などの名前をつけます (オプション)。</xsl:variable>

<xsl:variable name="include_in_availability_msg">空き時間を確認するときにこのカレンダーが参照されます</xsl:variable>

<xsl:variable name="calendar_address_title">カレンダーのアドレス</xsl:variable>

<xsl:variable name="calendar_address_msg">以下のリンクをほかの人に知らせることによって、このカレンダーにアクセスできるようになります。ほかの人にアクセス権を設定しておけば、その人が自分のブラウザでカレンダーを表示できるようになります。</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">カレンダーのアクセス権:</xsl:variable>

<xsl:variable name="cal_permissions_msg">アクセス権によって、自分以外の人がこのカレンダーの表示、変更ができるかどうかが決まります。すべてのユーザーに特定のアクセス権を与えるには、「全員」の横にあるアクセス権から該当するものを選択します。個人に特定のアクセス権を与えるには、ユーザーフィールドにユーザー ID を入力して、「ユーザー追加」ボタンをクリックします。次にユーザーの名前の横にあるアクセス権から該当するものを選択します。</xsl:variable>

<xsl:variable name="user_title">ユーザー</xsl:variable>
<xsl:variable name="user_title_with_colon">ユーザー:</xsl:variable>

<xsl:variable name="permissions_title">アクセス権</xsl:variable>

<xsl:variable name="invite_title">出席依頼</xsl:variable>

<xsl:variable name="read_title">読み込み</xsl:variable>

<xsl:variable name="modify_title">変更</xsl:variable>

<xsl:variable name="delete_selected_user_title">選択したユーザーを削除</xsl:variable>

<xsl:variable name="add_user_title">ユーザーの追加</xsl:variable>

<xsl:variable name="everybody_title">全員</xsl:variable>

<xsl:variable name="this_domain_title">このドメイン</xsl:variable>

<xsl:variable name="tip_cal_owners">カレンダーに所有者を割り当てるためのヒント :</xsl:variable>

<xsl:variable name="cal_owner_msg">このカレンダーには所有者を追加できます (複数も可)。所有者はあなたに代わって、出席依頼に返事を出し、予定を作成、変更、削除することができます。</xsl:variable>

<xsl:variable name="no_owners_msg">所有者がいません。</xsl:variable>

<xsl:variable name="delete_owner_title">所有者を削除</xsl:variable>

<xsl:variable name="add_owner_title">所有者の追加</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">このカレンダーを削除してよろしいですか?</xsl:variable>

<xsl:variable name="alert_supply_cal_name">カレンダー名を入力する必要があります</xsl:variable>

<xsl:variable name="owners_title">所有者</xsl:variable>

<xsl:variable name="time_zones_title">タイムゾーン</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">この予定を削除してよろしいですか?</xsl:variable>

<xsl:variable name="edit_event_page_title">予定の編集: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---クイック出席依頼---</xsl:variable>

<xsl:variable name="event_title_title">概要</xsl:variable>

<xsl:variable name="date_title">日付</xsl:variable>

<xsl:variable name="time_title">時刻</xsl:variable>

<xsl:variable name="all_day_msg">終日 (休暇や誕生日など)</xsl:variable>

<xsl:variable name="privacy_title">プライバシー</xsl:variable>

<xsl:variable name="public_event_title">公開予定</xsl:variable>

<xsl:variable name="confidential_event_title">日時のみ</xsl:variable>

<xsl:variable name="private_event_title">非公開予定</xsl:variable>

<xsl:variable name="location_title">開催場所</xsl:variable>

<xsl:variable name="invite_others_msg">他のユーザーの出席を依頼する:</xsl:variable>

<xsl:variable name="search_title">検索...</xsl:variable>

<xsl:variable name="inform_title">連絡</xsl:variable>

<xsl:variable name="invite_instructions_msg">(ユーザー ID、カレンダー ID、またはメールアドレスを入力します。名前が不明の場合は、「検索」をクリックします。)</xsl:variable>

<xsl:variable name="invitees_title">出席予定者</xsl:variable>

<xsl:variable name="no_invitees_msg">なし</xsl:variable>

<xsl:variable name="remove_title">削除</xsl:variable>

<xsl:variable name="inform_event_title">予定について連絡する人</xsl:variable>

<xsl:variable name="no_informees_msg">なし</xsl:variable>

<xsl:variable name="event_reminders_msg">この予定のアラームをメールで自分宛に送ることができます。下にメールアドレスを入力します (複数可)。複数のメールアドレスを入力する場合は、カンマ (,) またはセミコロン (;) で区切ってください。</xsl:variable>

<xsl:variable name="remind_title">アラーム</xsl:variable>

<xsl:variable name="alert_provide_valid_time">有効な時間を指定してください</xsl:variable>

<xsl:variable name="hours_text">時間</xsl:variable>

<xsl:variable name="days_text">日</xsl:variable>

<xsl:variable name="before_the_event_begins_text">予定開始前</xsl:variable>

<xsl:variable name="at_text">時刻</xsl:variable>

<xsl:variable name="text_reminder_msg">メールによるアラームではテキスト形式のメッセージを送ることができます。</xsl:variable>

<xsl:variable name="message_title">メッセージ</xsl:variable>

<xsl:variable name="title_title">タイトル</xsl:variable>

<xsl:variable name="attendees_title">出席者</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">削除してよろしいですか?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">カレンダーグループの編集: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---クイック追加---</xsl:variable>

<xsl:variable name="delete_calendar_text">このカレンダーを削除してよろしいですか?</xsl:variable>

<xsl:variable name="group_name_title">グループ名</xsl:variable>

<xsl:variable name="group_view_msg">日別ビューでグループを開きます (デフォルトでは、比較ビューで開きます)。</xsl:variable>

<xsl:variable name="calendar_id_title">カレンダー ID</xsl:variable>

<xsl:variable name="add_title">追加</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(カレンダー ID を入力します。ID が不明の場合は「検索」をクリックします。)</xsl:variable>

<xsl:variable name="group_members_title">グループメンバー</xsl:variable>

<xsl:variable name="group_description_msg">自分のグループの詳細をここに入力してください。このグループの日別ビューをカレンダーごとに表示するかどうかを選択することもできます。</xsl:variable>

<xsl:variable name="day_view_title">日別ビュー</xsl:variable>

<xsl:variable name="day_view_merge_msg">デフォルトでは、日別ビューのカレンダーはマージ表示されません。</xsl:variable>

<xsl:variable name="alert_group_name">グループの名前を入力してください</xsl:variable>

<xsl:variable name="calendar_group_title">カレンダーグループ</xsl:variable>

<xsl:variable name="details_title">詳細</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">この作業を削除してよろしいですか?</xsl:variable>

<xsl:variable name="edit_task_page_title">作業の編集: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">作業の作成</xsl:variable>

<xsl:variable name="task_title_title">作業名</xsl:variable>

<xsl:variable name="due_date_title">期限</xsl:variable>

<xsl:variable name="no_time_title">時刻指定なし</xsl:variable>

<xsl:variable name="public_task_title">公的な作業</xsl:variable>

<xsl:variable name="confidential_task_title">日時のみ</xsl:variable>

<xsl:variable name="private_task_title">私的な作業</xsl:variable>

<xsl:variable name="status_title">状況</xsl:variable>

<xsl:variable name="complete_title">完了</xsl:variable>

<xsl:variable name="task_reminder_msg">この作業のアラームをメールで自分宛に送ることができます。下にメールアドレスを入力します (複数可)。複数のメールアドレスを入力する場合は、カンマ (,) またはセミコロン (;) で区切ってください。</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">期限のない作業にアラームは設定できません</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">作業の期限前</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">表示</xsl:variable>

<xsl:variable name="settings_title">設定</xsl:variable>

<xsl:variable name="import_title">インポート</xsl:variable>

<xsl:variable name="export_title">エクスポート</xsl:variable>

<xsl:variable name="settings_msg">このフォームを使用して Calendar Express の動作を変更します。</xsl:variable>

<xsl:variable name="default_view_title">デフォルトの初期表示</xsl:variable>

<xsl:variable name="default_view_msg">ログイン後に次のビューを常に表示:</xsl:variable>

<xsl:variable name="default_group_title">デフォルトのカレンダーグループ</xsl:variable>

<xsl:variable name="default_group_msg">ログイン後に次のカレンダーグループを常に表示:</xsl:variable>

<xsl:variable name="no_cal_group_title">デフォルトでは表示しない</xsl:variable>

<xsl:variable name="date_format_msg">日付を次の順序で表示:</xsl:variable>

<xsl:variable name="m_d_y_format_text">月、日、年</xsl:variable>

<xsl:variable name="d_m_y_format_text">日、月、年</xsl:variable>

<xsl:variable name="y_m_d_format_text">年、月、日</xsl:variable>

<xsl:variable name="date_delimiter_msg">次の文字を使用して日付を区切る:</xsl:variable>

<xsl:variable name="use_12_clock_msg">12 時間制を使用する</xsl:variable>

<xsl:variable name="use_24_clock_msg">24 時間制を使用する</xsl:variable>

<xsl:variable name="day_title">日</xsl:variable>

<xsl:variable name="day_starts_msg">開始時刻:</xsl:variable>

<xsl:variable name="day_ends_msg">終了時刻:</xsl:variable>

<xsl:variable name="day_interval_msg">日の分割</xsl:variable>

<xsl:variable name="every_15_minutes_text">15 分ごと</xsl:variable>

<xsl:variable name="every_half_hour_text">30 分ごと</xsl:variable>

<xsl:variable name="every_hour_text">1 時間ごと</xsl:variable>

<xsl:variable name="every_2_hours_text">2 時間ごと</xsl:variable>

<xsl:variable name="every_four_hours_text">4 時間ごと</xsl:variable>

<xsl:variable name="first_dow_title">週の最初の曜日</xsl:variable>

<xsl:variable name="sunday_title">日曜日</xsl:variable>

<xsl:variable name="monday_title">月曜日</xsl:variable>

<xsl:variable name="tuesday_title">火曜日</xsl:variable>

<xsl:variable name="wednesday_title">水曜日</xsl:variable>

<xsl:variable name="thursday_title">木曜日</xsl:variable>

<xsl:variable name="friday_title">金曜日</xsl:variable>

<xsl:variable name="saturday_title">土曜日</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">週別ビューおよび月別ビューから土曜日と日曜日を除外する</xsl:variable>

<xsl:variable name="default_tz_msg">デフォルトでは、次のタイムゾーンを使用して日時が表示されます:</xsl:variable>

<xsl:variable name="none_selected_title">選択されていません</xsl:variable>

<xsl:variable name="single_tz_use_msg">1 つのカレンダーを表示するときに、そのカレンダーのタイムゾーンを使用する</xsl:variable>

<xsl:variable name="tz_timescales_msg">表示されている各タイムゾーンにタイムスケールを付ける</xsl:variable>

<xsl:variable name="event_task_reminders_title">予定 &amp; 作業のアラーム</xsl:variable>

<xsl:variable name="email_reminder_msg">各予定および作業の</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">アラーム送付の頻度に有効な値を指定してください</xsl:variable>

<xsl:variable name="before_every_event_task_text">前に自分宛にアラームをメールで送付</xsl:variable>

<xsl:variable name="note_title">注意:</xsl:variable>

<xsl:variable name="reminders_tip_msg">アラームを複数のメールアドレス (abc@company22.com と abc@sesta.com など) に送信する場合は、メールアドレスをコンマ (,) またはセミコロン (;) で区切ってください。</xsl:variable>

<xsl:variable name="event_notifications_title">予定の通知</xsl:variable>

<xsl:variable name="event_notifications_msg">自分のカレンダーに誰かが予定の予定を入れた場合にメールで自分に知らせる</xsl:variable>

<xsl:variable name="only_one_email_msg">送付先のメールアドレスは 1 つのみ指定可。</xsl:variable>

<xsl:variable name="alert_only_one_email">予定の通知先の指定は 1 つだけにしてください</xsl:variable>

<xsl:variable name="declined_events_delete_title">拒否された予定</xsl:variable>

<xsl:variable name="declined_events_delete_msg">拒否された予定を表示しない</xsl:variable>

<xsl:variable name="appearance_msg">このフォームを使用して Calendar Express の表示方法を変更します。</xsl:variable>

<xsl:variable name="color_scheme_title">配色</xsl:variable>

<xsl:variable name="toolbar_title">ツールバー</xsl:variable>

<xsl:variable name="icons_and_text_msg">アイコンとテキストを表示する</xsl:variable>

<xsl:variable name="icons_only_msg">アイコンだけを表示する</xsl:variable>

<xsl:variable name="text_only_msg">テキストだけを表示する</xsl:variable>

<xsl:variable name="display_font_title">表示フォント</xsl:variable>

<xsl:variable name="face_title">書体</xsl:variable>

<xsl:variable name="sans_serif_title">サンセリフ</xsl:variable>

<xsl:variable name="serif_title">セリフ</xsl:variable>

<xsl:variable name="mono_title">モノスペース</xsl:variable>

<xsl:variable name="size_title">サイズ</xsl:variable>

<xsl:variable name="larger_title">大</xsl:variable>

<xsl:variable name="default_title">標準</xsl:variable>

<xsl:variable name="smaller_title">小</xsl:variable>

<xsl:variable name="event_destination_title">予定の保存先</xsl:variable>

<xsl:variable name="session_expired_msg">セッションが期限切れです</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">有効なカレンダーを指定する必要があります</xsl:variable>

<xsl:variable name="add_events_to_text">予定を追加するカレンダー</xsl:variable>

<xsl:variable name="select_calendar_title">カレンダーを選択 :</xsl:variable>

<xsl:variable name="import_format_title">インポート形式</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook 形式</xsl:variable>

<xsl:variable name="source_file_invalid_error">指定したソースファイルは無効です</xsl:variable>

<xsl:variable name="format_file_mismatch_error">指定した形式はソースファイルに対応しません</xsl:variable>

<xsl:variable name="successful_import_msg">ファイルは正常にインポートされました</xsl:variable>

<xsl:variable name="source_file_title">ソースファイル</xsl:variable>

<xsl:variable name="date_range_title">期間</xsl:variable>

<xsl:variable name="import_all_msg">ファイルからすべての予定をインポートする</xsl:variable>

<xsl:variable name="invalid_date_range_error">指定した期間は無効です</xsl:variable>

<xsl:variable name="beginning_title">開始</xsl:variable>

<xsl:variable name="ending_title">終了</xsl:variable>

<xsl:variable name="calendars_to_export_title">予定のエクスポート</xsl:variable>

<xsl:variable name="addarrow_title">追加 >></xsl:variable>

<xsl:variable name="export_all_msg">すべての予定をエクスポートする</xsl:variable>

<xsl:variable name="export_format_title">エクスポート形式</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">日の終了時刻は日の開始時刻よりも遅くなければなりません</xsl:variable>

<xsl:variable name="save_changes_title">変更を保存</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">現在のカレンダー:</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">繰り返しパターン</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">繰り返しパターンが無効です: 繰り返す日を選択してください</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">定期的な予定の 1 つの回だけについて繰り返しパターンを変更できません。</xsl:variable>

<xsl:variable name="recurrence_skips_title">定期的な予定のある回が別の回を飛ばすことはできません。</xsl:variable>

<xsl:variable name="recurrence_same_day">定期的な予定の 2 つの回が同じ日に発生することはできません。</xsl:variable>

<xsl:variable name="recurrence_privacy">定期的な予定の 1 つの回だけについてプライバシーを変更できません。</xsl:variable>

<xsl:variable name="every_day_title">毎日</xsl:variable>

<xsl:variable name="every_weekday_title">平日に毎日</xsl:variable>

<xsl:variable name="every_title">ごと</xsl:variable>

<xsl:variable name="weekday_text">平日</xsl:variable>

<xsl:variable name="weekendday_text">週末</xsl:variable>

<xsl:variable name="m_w_f_text">月曜、水曜、および金曜</xsl:variable>

<xsl:variable name="t_th_text">火曜および木曜</xsl:variable>

<xsl:variable name="sat_sun_text">土曜および日曜</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">有効な頻度を設定してください</xsl:variable>

<xsl:variable name="every_week_title">毎週</xsl:variable>

<xsl:variable name="weeks_text">週間</xsl:variable>

<xsl:variable name="repeat_on_title">繰り返す日</xsl:variable>

<xsl:variable name="sunday_abbrev">日</xsl:variable>

<xsl:variable name="monday_abbrev">月</xsl:variable>

<xsl:variable name="tuesday_abbrev">火</xsl:variable>

<xsl:variable name="wednesday_abbrev">水</xsl:variable>

<xsl:variable name="thursday_abbrev">木</xsl:variable>

<xsl:variable name="friday_abbrev">金</xsl:variable>

<xsl:variable name="saturday_abbrev">土</xsl:variable>

<xsl:variable name="every_month_title">毎月</xsl:variable>

<xsl:variable name="months_text">か月</xsl:variable>

<!-- l10n_ja -->
<xsl:variable name="ordinal2_1">第 1</xsl:variable>
<xsl:variable name="ordinal2_2">第 2</xsl:variable>
<xsl:variable name="ordinal2_3">第 3</xsl:variable>
<xsl:variable name="ordinal2_4">第 4</xsl:variable>
<xsl:variable name="year_text">年</xsl:variable>
<xsl:variable name="day_text">日</xsl:variable>
<xsl:variable name="oclock_text">時</xsl:variable>
<xsl:variable name="before_the_event_begins_before_text">前</xsl:variable>
<xsl:variable name="before_the_event_begins_what_text">予定開始</xsl:variable>
<xsl:variable name="before_the_task_is_due_before_text">前</xsl:variable>
<xsl:variable name="before_the_task_is_due_what_text">作業の期限</xsl:variable>
<!-- end of l10n_ja -->

<xsl:variable name="ordinal_1">1 日</xsl:variable>
<xsl:variable name="ordinal_2">2 日</xsl:variable>
<xsl:variable name="ordinal_3">3 日</xsl:variable>
<xsl:variable name="ordinal_4">4 日</xsl:variable>
<xsl:variable name="ordinal_5">5 日</xsl:variable>
<xsl:variable name="ordinal_6">6 日</xsl:variable>
<xsl:variable name="ordinal_7">7 日</xsl:variable>
<xsl:variable name="ordinal_8">8 日</xsl:variable>
<xsl:variable name="ordinal_9">9 日</xsl:variable>
<xsl:variable name="ordinal_10">10 日</xsl:variable>
<xsl:variable name="ordinal_11">11 日</xsl:variable>
<xsl:variable name="ordinal_12">12 日</xsl:variable>
<xsl:variable name="ordinal_13">13 日</xsl:variable>
<xsl:variable name="ordinal_14">14 日</xsl:variable>
<xsl:variable name="ordinal_15">15 日</xsl:variable>
<xsl:variable name="ordinal_16">16 日</xsl:variable>
<xsl:variable name="ordinal_17">17 日</xsl:variable>
<xsl:variable name="ordinal_18">18 日</xsl:variable>
<xsl:variable name="ordinal_19">19 日</xsl:variable>
<xsl:variable name="ordinal_20">20 日</xsl:variable>
<xsl:variable name="ordinal_21">21 日</xsl:variable>
<xsl:variable name="ordinal_22">22 日</xsl:variable>
<xsl:variable name="ordinal_23">23 日</xsl:variable>
<xsl:variable name="ordinal_24">24 日</xsl:variable>
<xsl:variable name="ordinal_25">25 日</xsl:variable>
<xsl:variable name="ordinal_26">26 日</xsl:variable>
<xsl:variable name="ordinal_27">27 日</xsl:variable>
<xsl:variable name="ordinal_28">28 日</xsl:variable>
<xsl:variable name="ordinal_29">29 日</xsl:variable>
<xsl:variable name="ordinal_30">30 日</xsl:variable>
<xsl:variable name="ordinal_31">31 日</xsl:variable>

<xsl:variable name="day_of_month_text"></xsl:variable>
<xsl:variable name="cap_last_text">最終</xsl:variable>

<xsl:variable name="of_month_text"></xsl:variable>

<xsl:variable name="every_year_text">毎年</xsl:variable>

<xsl:variable name="years_text">年ごと</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">この予定は繰り返されます。今回だけを削除しますか、それともすべての回を削除しますか?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">この予定は繰り返されます。今回だけに変更を適用しますか、それともすべての回に変更を適用しますか?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">この作業は繰り返されます。今回だ~けを削除しますか、それともすべての回を削除しますか?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">この作業は繰り返されます。今回だけに変更を適用しますか、それともすべての回に変更を適用しますか?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">概要</xsl:variable>

<xsl:variable name="reply_title">返信</xsl:variable>

<xsl:variable name="will_attend_msg">出席します</xsl:variable>

<xsl:variable name="will_not_attend_msg">欠席します</xsl:variable>

<xsl:variable name="confirm_later_msg">後で確認します</xsl:variable>

<xsl:variable name="reply_reminders_msg">メールによるアラームのスケジュールをここで設定してください。メールアドレス (コンマまたはセミコロンで区切る) を入力し、配信する日時を選択します。</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">未確定の予定に予定開始前のアラームは設定できません</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">アラームに情報を追加するには以下のボックスを使用してください。すべてのアラームには、概要、日付、時刻、および開催場所が自動的に含まれます。</xsl:variable>

<xsl:variable name="cal_select_msg">予定を保存するカレンダーを選択してください</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">カレンダーの検索: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">カレンダーの検索</xsl:variable>

<xsl:variable name="cal_search_msg1">次の条件を満たすカレンダーを検索</xsl:variable>
        
<xsl:variable name="name_or_id_text">名前または ID が</xsl:variable>

<xsl:variable name="name_text">名前が</xsl:variable>

<xsl:variable name="primary_owner_text">主な所有者が</xsl:variable>

<xsl:variable name="id_text">ID が</xsl:variable>

<xsl:variable name="contains_text">次を含む</xsl:variable>

<xsl:variable name="begins_with_text">次で開始する</xsl:variable>

<xsl:variable name="search_plain_title">検索</xsl:variable>

<xsl:variable name="already_selected_cals_title">選択したカレンダー</xsl:variable>

<xsl:variable name="cal_id_title">カレンダー ID</xsl:variable>

<xsl:variable name="search_results_title">検索結果</xsl:variable>

<xsl:variable name="no_match_found_msg">一致するものが見つかりません</xsl:variable>

<xsl:variable name="owner_title">所有者</xsl:variable>

<xsl:variable name="owner_name_colon_title">所有者名:</xsl:variable>

<xsl:variable name="cal_name_title">カレンダー名</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">検索: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">次を含む予定と作業を検索</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">ユーザーの検索: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">ユーザーの検索</xsl:variable>

<xsl:variable name="search_local_msg">ローカルディレクトリの検索</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(名、姓、またはユーザー ID を入力します)</xsl:variable>

<xsl:variable name="legend_title">説明文:</xsl:variable>

<xsl:variable name="resource_title">リソース;</xsl:variable>

<xsl:variable name="already_selected_users_title">選択したユーザー</xsl:variable>

<xsl:variable name="name_userid_title">名前 (ユーザー ID)</xsl:variable>

<xsl:variable name="name_title">名前</xsl:variable>

<xsl:variable name="userid_title">ユーザー ID</xsl:variable>

<xsl:variable name="email_title">メール</xsl:variable>

<xsl:variable name="for_text">継続期間</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">作業リスト: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">このパネルを使用して、自分のすべての予定を追跡できます。「完了」フィールドのチェックボックスをオンにすることで、完了した作業にマークを付けることができます。変更を適用するには「保存して閉じる」をクリックします。</xsl:variable>

<xsl:variable name="done_title">完了</xsl:variable>

<xsl:variable name="task_title">作業</xsl:variable>

<xsl:variable name="select_all_title">すべて選択</xsl:variable>

<xsl:variable name="alert_processing">処理中です</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">作業</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">ヘルプ</xsl:variable>

<xsl:variable name="logout_text">ログアウト</xsl:variable>

<xsl:variable name="login_text">ログイン</xsl:variable>

<xsl:variable name="home_text">ホーム</xsl:variable>

<xsl:variable name="alt_schedule_msg">会議、誕生日、またはその他の予定などのスケジュールを設定</xsl:variable>

<xsl:variable name="new_event_title">新しい予定</xsl:variable>

<xsl:variable name="alt_todo_msg">予定リストにアイテムを追加</xsl:variable>

<xsl:variable name="new_task_title">新しい作業</xsl:variable>

<xsl:variable name="jump_to_title">移動</xsl:variable>

<xsl:variable name="alt_print_msg">印刷に適切なビューを開く</xsl:variable>

<xsl:variable name="printable_title">印刷用ページ</xsl:variable>

<xsl:variable name="alt_search_msg">予定および作業を検索</xsl:variable>

<xsl:variable name="alt_new_calendar">新しいカレンダーを作成</xsl:variable>

<xsl:variable name="new_cal_title">新しいカレンダー</xsl:variable>

<xsl:variable name="alt_new_group">新しいカレンダーグループを作成</xsl:variable>

<xsl:variable name="new_group_title">新しいグループ</xsl:variable>

<xsl:variable name="alt_search_cals">カレンダーを検索</xsl:variable>

<xsl:variable name="subscribe_title">登録</xsl:variable>

<xsl:variable name="paren_subscribed_title">(登録済み)</xsl:variable>

<xsl:variable name="alt_jump_next_week">翌週に移動</xsl:variable>

<xsl:variable name="alt_jump_prev_week">先週に移動</xsl:variable>

<xsl:variable name="sunday_letter_title">日</xsl:variable>
<xsl:variable name="monday_letter_title">月</xsl:variable>
<xsl:variable name="tuesday_letter_title">火</xsl:variable>
<xsl:variable name="wednesday_letter_title">水</xsl:variable>
<xsl:variable name="thursday_letter_title">木</xsl:variable>
<xsl:variable name="friday_letter_title">金</xsl:variable>
<xsl:variable name="saturday_letter_title">土</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">選択した予定がカレンダーから削除されます。定期的な予定の場合は、エラーが発生したインスタンスのみが削除されます。処理を続行する場合は「OK」をクリックしてください。</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">カレンダーグループの表示中に予定を作成するときに、グループのすべてのカレンダーに出席を依頼する</xsl:variable>

<xsl:variable name="invite_this_group_msg">このカレンダーグループの表示中に予定を作成するときに、グループのすべてのカレンダーに出席を依頼する</xsl:variable>

<xsl:variable name="group_invitations_title">グループの出席依頼</xsl:variable>

<xsl:variable name="starting_at_txt">開始時刻</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">不明</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">出席者なし</xsl:variable>

<xsl:variable name="today_title">今日</xsl:variable>

<xsl:variable name="confirm_event_delete_text">この予定を削除しますか?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">この作業を削除しますか?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">バックエンドデータベースに接続できません。</xsl:variable>
<xsl:variable name="dwp_max_connections_error">バックエンドデータベースの最大接続数に達しました。</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">バックエンドデータベース中に不正なデータがあります。</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">カレンダーを解決できません。</xsl:variable>
<xsl:variable name="dwp_down_error"> は機能停止しています</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP ホストコンテキストが存在しません。</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">バックエンドホストを解決できません。</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">データがありません - バックエンドデータベースに到達できません。</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">空き時間を確認する際にこの予定が参照されます</xsl:variable>
<xsl:variable name="freebusy_title">空き/予定あり</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">空き時間を確認する際に使用される終日予定を作成しています。この操作が適切でない場合は、「キャンセル」をクリックして前に戻り、「空き/予定あり」チェックボックスをオフにしてください。</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">空き時間を確認する際に使用される私的予定を作成しています。この操作が適切でない場合は、「キャンセル」をクリックして前に戻り、「空き/予定あり」チェックボックスをオフにしてください。</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">カレンダーデータベースが読み取り専用モードです。</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">終了日を指定しない </xsl:variable>
<xsl:variable name="cap_the_text"></xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 削除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>ようこそ </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>作業: </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>のカレンダー (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>開始時刻 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 時間</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>1 時間以上</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>の空き時間)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 作成できる最大数: </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 回</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>現在のカレンダーに、地域のタイムゾーンを 1 つ以上関連付けることができます。日別ビューなどのグリッド付きビューでは、カレンダーに関連付けられたすべてのタイムゾーンは、ビューの時間単位となります。カレンダーにタイムゾーンが関連付けられていない場合は、デフォルトのタイムゾーンが使用されます。次の地域では、以下のタイムゾーンが使用可能です。</xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>現在のカレンダーに、いずれかの地域のタイムゾーンを 1 つ関連付けることができます。日別ビューなどのグリッド付きビューでは、カレンダーに関連付けられたタイムゾーンは、ビューの時間単位となります。このカレンダーにタイムゾーンが関連付けられていない場合は、デフォルトのタイムゾーンが使用されます。次の地域では、以下のタイムゾーンが使用可能です。</xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北米/南米 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>ヨーロッパ/アフリカ </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>アジア/環太平洋 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>地域:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>以下の予定が "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>" によって自分のカレンダーに追加されました。適切なオプションを選択して返信すると、この依頼に対して出席、欠席を指定できます。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text></xsl:text>&nbsp;
  <B><xsl:text>「参照...」</xsl:text></B>&nbsp;
  <xsl:text>をクリックしてファイルを選択してください。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>このフォームを使用して予定の出席依頼に対して出席 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> するか、欠席 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text>するか、あるいは後で確認 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> のままにします。</xsl:text>
  <br/>
  <xsl:text>定期的な予定の場合は、この設定が予定全体に適用されます。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>検索文字数が </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 文字より少ないと、正しく検索が行われない場合があります。正しい結果を得るには </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 文字以上を指定するようにしてください。</xsl:text>

</xsl:template>


</xsl:stylesheet>
