<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common_view.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>検索: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="77,*,41">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='searchProperties'">
      <xsl:for-each select="group">
        <xsl:if test="@name='searchProperties'">
          <xsl:call-template name="searchProperties_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="searchResults_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (search_for_components.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="searchProperties_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">
  <xsl:attribute name="onload">
     window.focus();
     document.forms[0].what.focus();
  </xsl:attribute>


<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">
    document.forms[0]['find'].click();
    return false;
  </xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="myaction" value="find"/>

<CENTER>
  <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" height="100%">
    <TR>
      <TD align="center">
        <TABLE border="0" cellpadding="3" cellspacing="1">
          <TR>
<!-- this template contains TD's and provides form input whose layout can be l10n'd -->
            <xsl:call-template name="searchComponentsInputTemplate"/>
            <TD valign="baseline">
              <FONT size="{$font_size_big_2}" face="{$font_name}">
                <INPUT type="button" name="find" value="検索" width="72">
                  <xsl:attribute name="onClick">
                    var f = parent.frames[1].document.forms[0];
                    var localForm = document.forms[0];
                    f['what'].value = localForm['what'].value;
                    f['myaction'].value = 'find';
                    f.submit();
                  </xsl:attribute>
                </INPUT>
              </FONT>
            </TD>
          </TR>
        </TABLE>
      </TD>
    </TR>
  </TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="searchResults_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="what"/>

  <xsl:if test="(./compsearchresults/nomatch)">
    <!--print no match found -->
    一致するものが見つかりません
  </xsl:if> 

  <xsl:for-each select="(./compsearchresults/Event) | (./compsearchresults/Task)">
    <P>
      <xsl:if test="name(.)='Event'">
        <xsl:call-template name="List_Event">
          <xsl:with-param name="includeDate">true</xsl:with-param>
          <xsl:with-param name="delete">false</xsl:with-param>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="name(.)='Task'">
        <xsl:call-template name="List_Task">
          <xsl:with-param name="includeDate">true</xsl:with-param>
          <xsl:with-param name="delete">false</xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </P>
  </xsl:for-each>
</FORM>
</BODY>
</HTML>
</xsl:template>


<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="esc" value="閉じる" onClick="{./button[@name='cancel']}" width="72"/> 
        <INPUT type="button" name="help" value="ヘルプ" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
