<?xml version="1.0" encoding="UTF-8" ?>

<!-- <!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&amp;nbsp;">]> -->
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- However it is good for the text strings to be variables as defined in i18n.xsl -->
<!-- That way, for languages with similar layout format, this file will not need translation -->

<xsl:template name="min_short">
  <xsl:param name="hsMin"/>
      <xsl:value-of select="$hsMin"/>
</xsl:template>

<!-- simply print out the hour (13 or 1) according to the ceClock -->
<xsl:template name="hour_short">
  <xsl:param name="hsHour"/>
  <xsl:choose>
    <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">
      <xsl:value-of select="$hsHour"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="$hsHour = 0">12</xsl:when>
        <xsl:when test="$hsHour = 1">1</xsl:when>
        <xsl:when test="$hsHour = 2">2</xsl:when>
        <xsl:when test="$hsHour = 3">3</xsl:when>
        <xsl:when test="$hsHour = 4">4</xsl:when>
        <xsl:when test="$hsHour = 5">5</xsl:when>
        <xsl:when test="$hsHour = 6">6</xsl:when>
        <xsl:when test="$hsHour = 7">7</xsl:when>
        <xsl:when test="$hsHour = 8">8</xsl:when>
        <xsl:when test="$hsHour = 9">9</xsl:when>
        <xsl:when test="$hsHour =10">10</xsl:when>
        <xsl:when test="$hsHour =11">11</xsl:when>
        <xsl:when test="$hsHour =12">12</xsl:when>
        <xsl:when test="$hsHour =13">1</xsl:when>
        <xsl:when test="$hsHour =14">2</xsl:when>
        <xsl:when test="$hsHour =15">3</xsl:when>
        <xsl:when test="$hsHour =16">4</xsl:when>
        <xsl:when test="$hsHour =17">5</xsl:when>
        <xsl:when test="$hsHour =18">6</xsl:when>
        <xsl:when test="$hsHour =19">7</xsl:when>
        <xsl:when test="$hsHour =20">8</xsl:when>
        <xsl:when test="$hsHour =21">9</xsl:when>
        <xsl:when test="$hsHour =22">10</xsl:when>
        <xsl:when test="$hsHour =23">11</xsl:when>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--  print out 2 - separated hours according to ceClock -->
<!-- Ex: 13:29 - 14:34    or   1:29pm - 2:34 pm          -->
<xsl:template name="dur_short">
  <xsl:param name="date1"/>
  <xsl:param name="date2"/>

  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour">
      <xsl:apply-templates select="$date1/@hour"/>
    </xsl:with-param>
    <xsl:with-param name="ftMinute">
      <xsl:apply-templates select="$date1/@minute"/>
    </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour">
      <xsl:apply-templates select="$date2/@hour"/>
    </xsl:with-param>
    <xsl:with-param name="ftMinute">
      <xsl:apply-templates select="$date2/@minute"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- print out day of week and date                 -->
<!-- Ex: Wednesday 29                               -->
<xsl:template name="date_short">
  <xsl:param name="dateA"/>
<!-- l10n_ja -->
  <xsl:apply-templates select="$dateA/@date"/>
  <xsl:text>&nbsp;</xsl:text>
  日
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="$dateA/@dow"/>
<!-- end_of_l10n_ja -->
</xsl:template>

<!-- print out day of week + full date and range     -->
<!-- Ex: Wednesday, 29 July, 2000 from 12:34 - 13:49 -->
<xsl:template name="date_long">
  <xsl:param name="date_range"/>

<!-- l10n_ja -->
  <xsl:value-of select="$date_range/StartTime/@year"/>
  <xsl:text>&nbsp;</xsl:text>
  年
  <xsl:text> </xsl:text>
  <xsl:choose>
    <xsl:when test="$dateorder = 'D/M/Y'">
      <xsl:value-of select="$date_range/StartTime/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$date_range/StartTime/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="$date_range/StartTime/@dow"/>
  <xsl:text> </xsl:text>
<!-- end_of_l10n_ja -->
   指定時刻<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="dur_short">
    <xsl:with-param name="date1" select="$date_range/StartTime"/>
    <xsl:with-param name="date2" select="$date_range/EndTime"/>
  </xsl:call-template>
</xsl:template>

<!-- print out day of week + full date  -->
<!-- Ex: Wednesday, 29 July, 2000 -->
<xsl:template name="date_long_no_time">
  <xsl:param name="date_range"/>

<!-- l10n_ja -->
  <xsl:value-of select="$date_range/StartTime/@year"/>
  <xsl:text> </xsl:text>
  <xsl:choose>
    <xsl:when test="$dateorder = 'D/M/Y'">
      <xsl:value-of select="$date_range/StartTime/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$date_range/StartTime/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="$date_range/StartTime/@dow"/>
<!-- end_of_l10n_ja -->
</xsl:template>

<!-- print out date and time if dueTime=0 -->
<!-- Ex: July 29 at 1:34pm                -->
<xsl:template name="task_date_at_time">
  <xsl:param name="dateA"/>
  <xsl:param name="notime"/>

  <xsl:choose>
<!-- l10n_ja -->
    <xsl:when test="$dateorder='D/M/Y'">
      <xsl:apply-templates select="$dateA/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$dateA/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$dateA/@month"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$dateA/@date"/>
      <xsl:text>&nbsp;</xsl:text>
      日
    </xsl:otherwise>
<!-- end_of_l10n_ja -->
  </xsl:choose>
  <xsl:if test="not($notime='1')">
<!-- l10n_ja -->
    <xsl:text> </xsl:text>
<!-- end_of_l10n_ja -->
    <xsl:call-template name="formatTime">
      <xsl:with-param name="ftHour">
        <xsl:apply-templates select="$dateA/@hour"/>
      </xsl:with-param>
      <xsl:with-param name="ftMinute">
        <xsl:apply-templates select="$dateA/@minute"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<!-- print date like 29/07/2001 if year is present otherwise 29/07-->
<xsl:template name="brief_date">
  <xsl:param name="Month"/>
  <xsl:param name="Day"/>
  <xsl:param name="Year"/>

  <xsl:choose>
    <xsl:when test="$dateorder='M/D/Y'">
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:when>
    <xsl:when test="$dateorder='D/M/Y'">
      <xsl:value-of select="$Day"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Month"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:when>
    <xsl:when test="$dateorder='Y/M/D'">
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$Year"/>
        <xsl:value-of select="$dateseparator"/>
      </xsl:if>
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- print today if today, date with year if not current year -->
<!-- otherwise date without year                              -->
<!-- Ex: Today   or    12/28    or 12/28/2005                 -->
<xsl:template name="brief_date_or_today">
  <xsl:param name="TargetMonth"/>
  <xsl:param name="TargetDay"/>
  <xsl:param name="TargetYear"/>
  <xsl:param name="CurrentMonth"/>
  <xsl:param name="CurrentDay"/>
  <xsl:param name="CurrentYear"/>

  <xsl:choose>
    <xsl:when test="($TargetYear=$CurrentYear) and ($TargetDay=$CurrentDay) and ($TargetMonth=$CurrentMonth)">
      今日
    </xsl:when>
    <xsl:when test="$TargetYear = $CurrentYear">
      <xsl:call-template name="brief_date">
        <xsl:with-param name="Month" select="$TargetMonth"/>
        <xsl:with-param name="Day" select="$TargetDay"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="brief_date">
        <xsl:with-param name="Month" select="$TargetMonth"/>
        <xsl:with-param name="Day" select="$TargetDay"/>
        <xsl:with-param name="Year" select="$TargetYear"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
  
</xsl:template>


<!-- formatTime: output hour [minutes] according to the ceClock
     of the user -->
<!-- Hour: Mandatory                                     -->
<!-- Minute: optional parameter: show or not the minutes -->
<!-- In other languages, ie "ja", the am/pm must come first -->
<xsl:template name="formatTime">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>

<!-- In other languages, ie "ja", the am/pm must come first -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and (/calendar/usrctx/user/@language='ja')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:choose>
      <xsl:when test="$ftHour &lt; 12 ">
        午前
<!-- l10n_ja -->
        <xsl:text>&nbsp;</xsl:text>
<!-- end_of_l10n_ja -->
      </xsl:when>
      <xsl:when test="($ftHour &gt; 11) and ($ftHour &lt; 24)">
        午後
<!-- l10n_ja -->
        <xsl:text>&nbsp;</xsl:text>
<!-- end_of_l10n_ja -->
      </xsl:when>
      <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
    </xsl:choose>
    </FONT>
  </xsl:if>

  <xsl:call-template name="hour_short">
    <xsl:with-param name="hsHour" select="$ftHour"/>
  </xsl:call-template>

<!-- l10n_ja -->
  <xsl:choose>
    <xsl:when test="string-length($ftMinute) &gt; 0">
      <xsl:text>:</xsl:text>
      <xsl:value-of select="$ftMinute"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>&nbsp;</xsl:text>
      時
    </xsl:otherwise>
  </xsl:choose>
<!-- end_of_l10n_ja -->

<!-- In languages other than "ja", the am/pm must comes here -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and not(/calendar/usrctx/user/@language='ja')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:choose>
      <xsl:when test="$ftHour &lt; 12 ">
        午前
      </xsl:when>
      <xsl:when test="($ftHour &gt; 11) and ($ftHour &lt; 24)">
        午後
      </xsl:when>
      <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
    </xsl:choose>
    </FONT>
  </xsl:if>
</xsl:template>

<!-- formatLongTime: output hour according to the ceClock of the user -->
<!-- Hour: Mandatory (if 12 hour mode 12pm/am replaced by noon/midnight -->
<xsl:template name="formatLongTime">
  <xsl:param name="Hour"/>

  <xsl:choose>
    <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">
      <xsl:call-template name="formatTime">
            <xsl:with-param name="ftHour" select="$Hour"/>
            <xsl:with-param name="ftMinute" select="'00'"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$Hour = 0">
      深夜 0 時
    </xsl:when>
    <xsl:when test="$Hour = 12">
      正午
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="formatTime">
            <xsl:with-param name="ftHour" select="$Hour"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="date_selector">
  <xsl:param name="format" select="$dateorder"/>
  <xsl:param name="input_prefix"/>
  <xsl:param name="month"/>
  <xsl:param name="day"/>
  <xsl:param name="year"/>
  <xsl:param name="checkFunction" select="'dateCheck'" />

<!-- As we get to the end of the format, there is no more "/" -->
<!-- to use as a delineator. Just pick up the rest of the string -->
  <xsl:variable name="first">
    <xsl:choose>
    <xsl:when test="contains(($format),'/')">
      <xsl:value-of select="substring-before($format,'/')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$format"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="remain" select="substring-after($format,'/')"/>

  <xsl:choose>
    <xsl:when test="$first = 'M'">
      <INPUT type="text" maxlength="2" size="2" >
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>mm</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$month"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>mm';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'mm');
        </xsl:attribute>
      </INPUT>
    </xsl:when>
    <xsl:when test="$first = 'D'">
      <INPUT type="text" maxlength="2" size="2" >
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>dd</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$day"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>dd';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'dd');
        </xsl:attribute>
      </INPUT>
    </xsl:when>
    <xsl:otherwise>
      <INPUT type="text" maxlength="4" size="4">
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>ccyy</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$year"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>ccyy';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'ccyy');
        </xsl:attribute>
      </INPUT>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:if test="$remain">
    <xsl:value-of select="$dateseparator"/>
    <xsl:call-template name="date_selector">
      <xsl:with-param name="format" select="$remain"/>
      <xsl:with-param name="input_prefix" select="$input_prefix"/>
      <xsl:with-param name="month" select="$month"/>
      <xsl:with-param name="day" select="$day"/>
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="checkFunction" select="$checkFunction"/>
    </xsl:call-template>
  </xsl:if>

</xsl:template>

<xsl:template name="time_select">
  <xsl:param name="input_prefix"/>
  <xsl:param name="start_hour"/>
  <xsl:param name="start_min"/>

<!-- In other languages, ie "ja", the am/pm must come first -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and (/calendar/usrctx/user/@language='ja')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <SELECT>
      <!-- This text is an input name and shouldn't get translated -->
      <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>pm</xsl:attribute>
      <OPTION value="0">午前</OPTION>
      <OPTION value="1">
        <xsl:if test="$start_hour >= 12">
          <xsl:attribute name="selected"></xsl:attribute>
        </xsl:if>午後
      </OPTION>
    </SELECT>
    </FONT>
  </xsl:if>

  <INPUT type="text"  maxlength="2" size="2">
    <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>hr</xsl:attribute>
    <xsl:attribute name="value"><xsl:call-template name="hour_short"><xsl:with-param name="hsHour" select="$start_hour"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="onFocus">
      var entry = '<xsl:value-of select="$input_prefix"/>hr';
      valueSave(entry);
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var prefix = '<xsl:value-of select="$input_prefix"/>';
      <xsl:choose>
      <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">hourCheck(23, prefix);</xsl:when>
      <xsl:otherwise>hourCheck(12, prefix);</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <FONT face="{$font_name}" size="{$font_size_big_2}"> : </FONT>
  </INPUT>

  <INPUT type="text" maxlength="2" size="2">
    <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>mn</xsl:attribute>
    <xsl:attribute name="value"><xsl:call-template name="min_short"><xsl:with-param name="hsMin" select="$start_min"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="onFocus">
      var entry = '<xsl:value-of select="$input_prefix"/>mn';
      valueSave(entry);
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var prefix = '<xsl:value-of select="$input_prefix"/>';
      minuteCheck(prefix);
    </xsl:attribute>
  </INPUT>

<!-- if the language is not "ja" , then this menu goes here -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and not(/calendar/usrctx/user/@language='ja')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <SELECT>
      <!-- This text is an input name and shouldn't get translated -->
      <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>pm</xsl:attribute>
      <OPTION value="0">午前</OPTION>
      <OPTION value="1">
        <xsl:if test="$start_hour >= 12">
          <xsl:attribute name="selected"></xsl:attribute>
        </xsl:if>午後
      </OPTION>
    </SELECT>
    </FONT>
  </xsl:if>

</xsl:template>

<xsl:template name="duration_selector">
  <xsl:param name="ds_start_hour"/>
  <xsl:param name="ds_start_min"/>
  <xsl:param name="dur_hour"/>
  <xsl:param name="dur_min"/>

  <xsl:call-template name="time_select">
    <xsl:with-param name="start_hour" select="$ds_start_hour"/>
    <xsl:with-param name="start_min" select="$ds_start_min"/>
  </xsl:call-template>

  <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>継続期間<xsl:text>&nbsp;</xsl:text></FONT>
  <INPUT type="text" name="dhr" maxlength="2" size="2">
    <xsl:attribute name="value"><xsl:value-of select="$dur_hour"/></xsl:attribute>
    <xsl:attribute name="onFocus">
      valueSave('dhr');
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      durationHourCheck(23, 'd');
    </xsl:attribute>
  </INPUT>
  <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>時間</FONT>
  <INPUT type="text" name="dmn" maxlength="2" size="2">
    <xsl:attribute name="value"><xsl:value-of select="$dur_min"/></xsl:attribute>
    <xsl:attribute name="onFocus">
      valueSave('dmn');
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      minuteCheck('d');
    </xsl:attribute>
  </INPUT>
  <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>分</FONT>
</xsl:template>

<!-- In 'en' this shows up as "<date_selector> at <hr>:<min> <am/pm>" -->
<xsl:template name="absolute_datetime_selector">
  <xsl:param name="input_prefix"/>
  <xsl:param name="month"/>
  <xsl:param name="day"/>
  <xsl:param name="year"/>
  <xsl:param name="start_hour"/>
  <xsl:param name="start_min"/>

  <xsl:call-template  name="date_selector">
    <xsl:with-param name="input_prefix" select="$input_prefix"/>
    <xsl:with-param name="month" select="$month"/>
    <xsl:with-param name="day" select="$day"/>
    <xsl:with-param name="year" select="$year"/>
  </xsl:call-template>
<!-- l10n_ja -->
  <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT>
<!-- end_of_l10n_ja -->
  <xsl:call-template name="time_select">
    <xsl:with-param name="input_prefix" select="$input_prefix"/>
    <xsl:with-param name="start_hour" select="$start_hour"/>
    <xsl:with-param name="start_min" select="$start_min"/>
  </xsl:call-template>
</xsl:template>


<!-- In 'en' this shows up as "<15> <minutes> before the event begins>" -->
<xsl:template name="time_before_selector">
  <xsl:param name="time_offset"/>
  <xsl:param name="time_units"/>
<!-- l10n_ja: In 'en' these are "before" and "the event begins" -->
  <xsl:param name="before_text_before"/>
  <xsl:param name="before_text_what"/>

    <xsl:value-of select="$before_text_what"/>
    <xsl:text>&nbsp;</xsl:text>
<!-- end_of_l10n_ja -->
  <INPUT type="text" name="dur_time" size="{$font_size_big_2}">
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="string-length($time_offset) = 0">15</xsl:when>
      <xsl:otherwise><xsl:value-of select="$time_offset"/></xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['dur_time'].value;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
      f['dur_time'].value = '15';
      parent.date_error = '1';
      alert('有効な時間を指定してください');
      }
    </xsl:attribute>
  </INPUT>
  <SELECT name="before">
    <OPTION value="mns">
      <xsl:if test="$time_units=1">
        <xsl:attribute name="selected"/>
      </xsl:if>
      分
    </OPTION>
    <OPTION value="hrs">
      <xsl:if test="$time_units=2">
        <xsl:attribute name="selected"/>
      </xsl:if>
      時間
    </OPTION>
    <OPTION value="dys">
     <xsl:if test="$time_units=3">
       <xsl:attribute name="selected"/>
      </xsl:if>
      日
    </OPTION>
<!-- l10n_ja -->
    </SELECT>
    <xsl:text>&nbsp;</xsl:text>
    <xsl:value-of select="$before_text_before"/>
<!-- end_of_l10n_ja -->
</xsl:template>


<!-- Used in recurrence dialogs under "until" section -->
<!-- Create <numselector> events/tasks -->
<xsl:template name="until_count_selector">
  <xsl:param name="count_len"/>
  <xsl:param name="count_num"/>
  <xsl:param name="count_type"/>
  <xsl:param name="recur_bound"/>

<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
  <input type="text" name="COUNT">
    <xsl:attribute name="maxlength"><xsl:value-of select="$count_len"/></xsl:attribute> 
    <xsl:attribute name="size"><xsl:value-of select="$count_len"/></xsl:attribute> 
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="string-length($count_num) &gt; 0"><xsl:value-of select="$count_num"/></xsl:when>
      <xsl:otherwise>5</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['COUNT'].value;
      var max_limit = <xsl:value-of select="$recur_bound"/>;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
        f['COUNT'].value ='5';
	    parent.date_error = '1';
        alert('有効な回数を指定してください');
      } else if (checked_num &gt; max_limit) {
        f['COUNT'].value = max_limit;
	    parent.date_error = '1';
<!-- l10n_ja -->
          alert(max_limit + ' ' + '以下の数を指定してください');
<!-- end_of_l10n_ja -->
      }
    </xsl:attribute>
  </input>
  <xsl:choose>
  <xsl:when test="$count_type='TASK'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>作業</font>
<!-- l10n_ja: moved from line 635 -->
  <font size="{$font_size_big_2}" face="{$font_name}">を作成<xsl:text>&nbsp;&nbsp;</xsl:text></font>
<!-- end_of_l10n_ja -->
  </xsl:when>
  <xsl:otherwise>
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>予定</font>
<!-- l10n_ja: moved from line 635 -->
  <font size="{$font_size_big_2}" face="{$font_name}">を作成<xsl:text>&nbsp;&nbsp;</xsl:text></font>
<!-- end_of_l10n_ja -->
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- used in recurrence dialog for all recurrence types -->
<!-- Every <numselector> days, weeks, months, etc -->
<xsl:template name="interval_selector">
  <xsl:param name="interval_type"/>
  <xsl:param name="rrule_num"/>
  <xsl:param name="rrule_interval"/>

<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
  <input type="text" size="{$font_size_big_2}" maxlength="2" name="INTERVAL">
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="$rrule_num='3'"><xsl:value-of select="$rrule_interval"/></xsl:when>
      <xsl:otherwise><xsl:text>2</xsl:text></xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['INTERVAL'].value;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
	    f['INTERVAL'].value ='2';
        parent.date_error = 1;
        alert('有効な頻度を設定してください');
      }
    </xsl:attribute>
  </input>
  <xsl:choose>
  <xsl:when test="$interval_type='DAILY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>日</font>
  </xsl:when>
  <xsl:when test="$interval_type='MONTHLY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>か月</font>
  </xsl:when>
  <xsl:when test="$interval_type='YEARLY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>年ごと</font>
  </xsl:when>
  <xsl:otherwise>
<!-- WEEKLY -->
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>週間</font>
  </xsl:otherwise>
  </xsl:choose>
<!-- l10n_ja -->
  <font size="{$font_size_big_2}" face="{$font_name}">ごと</font>
<!-- end_of_l10n_ja -->
</xsl:template>              

<!-- Used in recurrence dialogs - when in "daily" mode -->
<!-- Every <menu - selector> -->
<xsl:template name="daily_byday_selector">
  <xsl:param name="rrule_daily"/>
  <xsl:param name="rrule_byday"/>

  <font size="{$font_size_big_2}" face="{$font_name}">
    ごと<xsl:text>&nbsp;</xsl:text>
  <select name="BYDAY" size="{$font_size_big}">
    <option value="BYDAY=MO,TU,WE,TH,FR">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='MO,TU,WE,TH,FR')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      平日
    </option>
    <option value="BYDAY=MO,WE,FR">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='MO,WE,FR')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      月曜、水曜、および金曜
    </option>
    <option value="BYDAY=TU,TH">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='TU,TH')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      火曜および木曜
    </option>
    <option value="BYDAY=SU,SA">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='SU,SA')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      土曜および日曜
    </option>
  </select>
  </font>
</xsl:template>


<!-- used in recurrence dialog, monthly or yearly mode -->
<!-- If MONTHLY = The <1st> day of the month -->
<!-- If YEARLY = The <1st> <January> -->
<xsl:template name="monthday_ordinal_selector">
  <xsl:param name="selector_type"/>
  <xsl:param name="rrule_bymonthday"/>
  <xsl:param name="rrule_bymonth"/>
            
  <font size="{$font_size_big_2}" face="{$font_name}">
<!-- l10n_ja -->
  <!--<xsl:text>&nbsp;</xsl:text><xsl:value-of select="$cap_the_text"/>-->
  <xsl:choose>
  <xsl:when test="$selector_type='MONTHLY'">
<!-- MONTHLY -->
    <!--<xsl:value-of select="$day_of_month_text"/>-->
  </xsl:when>
  <xsl:otherwise>
<!-- YEARLY -->    
    <xsl:call-template name="month_selector">
        <xsl:with-param name="selector_name">BYMONTH</xsl:with-param>
        <xsl:with-param name="rrule_month" select="$rrule_bymonth"/>
    </xsl:call-template>
  </xsl:otherwise>
  </xsl:choose>
<!-- end_of_l10n_ja -->
  <select name="BYMONTHDAY" size="{$font_size_big}">
    <option value="1">
      <xsl:if test="$rrule_bymonthday='1'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      1 日
     </option>
    <option value="2">
      <xsl:if test="$rrule_bymonthday='2'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      2 日
    </option>
    <option value="3">
      <xsl:if test="$rrule_bymonthday='3'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      3 日
    </option>
    <option value="4">
      <xsl:if test="$rrule_bymonthday='4'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      4 日
    </option>
    <option value="5">
      <xsl:if test="$rrule_bymonthday='5'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      5 日
    </option>
    <option value="6">
      <xsl:if test="$rrule_bymonthday='6'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      6 日
    </option>
    <option value="7">
      <xsl:if test="$rrule_bymonthday='7'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      7 日
    </option>
    <option value="8">
      <xsl:if test="$rrule_bymonthday='8'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      8 日
    </option>
    <option value="9">
      <xsl:if test="$rrule_bymonthday='9'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      9 日
    </option>
    <option value="10">
      <xsl:if test="$rrule_bymonthday='10'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      10 日
    </option>
    <option value="11">
      <xsl:if test="$rrule_bymonthday='11'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      11 日
    </option>
    <option value="12">
      <xsl:if test="$rrule_bymonthday='12'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      12 日
    </option>
    <option value="13">
      <xsl:if test="$rrule_bymonthday='13'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      13 日
    </option>
    <option value="14">
      <xsl:if test="$rrule_bymonthday='14'">
        <xsl:attribute name="selected"/>
      </xsl:if>
     14 日
    </option>
    <option value="15">
      <xsl:if test="$rrule_bymonthday='15'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      15 日
    </option>
    <option value="16">
      <xsl:if test="$rrule_bymonthday='16'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      16 日
    </option>
    <option value="17">
      <xsl:if test="$rrule_bymonthday='17'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      17 日
    </option>
    <option value="18">
      <xsl:if test="$rrule_bymonthday='18'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      18 日
    </option>
    <option value="19">
      <xsl:if test="$rrule_bymonthday='19'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      19 日
    </option>
    <option value="20">
      <xsl:if test="$rrule_bymonthday='20'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      20 日
    </option>
    <option value="21">
      <xsl:if test="$rrule_bymonthday='21'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      21 日
    </option>
    <option value="22">
      <xsl:if test="$rrule_bymonthday='22'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      22 日
    </option>
    <option value="23">
      <xsl:if test="$rrule_bymonthday='23'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      23 日
    </option>
    <option value="24">
      <xsl:if test="$rrule_bymonthday='24'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      24 日
    </option>
    <option value="25">
      <xsl:if test="$rrule_bymonthday='25'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      25 日
    </option>
    <option value="26">
      <xsl:if test="$rrule_bymonthday='26'">
        <xsl:attribute name="selected"/>
      </xsl:if>
     26 日
    </option>
    <option value="27">
      <xsl:if test="$rrule_bymonthday='27'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      27 日
    </option>
    <option value="28">
      <xsl:if test="$rrule_bymonthday='28'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      28 日
    </option>
    <option value="29">
      <xsl:if test="$rrule_bymonthday='29'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      29 日
    </option>
    <option value="30">
      <xsl:if test="$rrule_bymonthday='30'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      30 日
    </option>
    <option value="31">
      <xsl:if test="$rrule_bymonthday='31'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      31 日
    </option>
  </select>
<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
  </font>
</xsl:template>


<!-- Used in the recurrence dialog for both MONTHLY and YEARLY type selection -->
<!-- MONTHLY = The <1st> <Sunday> of the month -->
<!-- YEARLY = The <1st> <Sunday> <January> -->
<xsl:template name="month_byweekday_selector">
  <xsl:param name="selector_type"/>
  <xsl:param name="rrule_bysetpos"/>
  <xsl:param name="rrule_byday"/>
  <xsl:param name="rrule_bydaymonth"/>
  <xsl:param name="rrule_interval"/>
          
  <font size="{$font_size_big_2}" face="{$font_name}">
<!-- l10n_ja -->
  <!--<xsl:text>&nbsp;</xsl:text><xsl:value-of select="$cap_the_text"/>-->
    <xsl:choose>
    <xsl:when test="$selector_type='MONTHLY'">
<!-- MONTHLY -->
	<!--<xsl:value-of select="$of_month_text"/>-->

    </xsl:when>
    <xsl:otherwise>
<!-- YEARLY -->
    <xsl:call-template name="month_selector">
        <xsl:with-param name="selector_name">BYDAY_MONTH</xsl:with-param>
        <xsl:with-param name="rrule_month" select="$rrule_bydaymonth"/>
    </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
<!-- end_of_l10n_ja -->
    <select name="BYSETPOS" size="{$font_size_big}">
      <option value="1">
        <xsl:if test="$rrule_bysetpos='1'">
          <xsl:attribute name="selected"/>
        </xsl:if>
<!-- l10n_ja -->
        第 1
<!-- end_of_l10n_ja -->
      </option>
      <option value="2">
        <xsl:if test="$rrule_bysetpos='2'">
          <xsl:attribute name="selected"/>
        </xsl:if>
<!-- l10n_ja -->
        第 2
<!-- end_of_l10n_ja -->
      </option>
      <option value="3">
        <xsl:if test="$rrule_bysetpos='3'">
          <xsl:attribute name="selected"/>
        </xsl:if>
<!-- l10n_ja -->
        第 3
<!-- end_of_l10n_ja -->
      </option>
      <option value="4">
        <xsl:if test="$rrule_bysetpos='4'">
          <xsl:attribute name="selected"/>
        </xsl:if>
<!-- l10n_ja -->
        第 4
<!-- end_of_l10n_ja -->
      </option>
      <option value="-1">
        <xsl:if test="$rrule_bysetpos='-1'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        最終
      </option>
    </select> 
    <select name="BYDAY" size="{$font_size_big}">
      <option value="SU">
        <xsl:if test="$rrule_byday='SU'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        日曜日
      </option>
      <option value="MO">
        <xsl:if test="$rrule_byday='MO'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        月曜日
      </option>
      <option value="TU">
        <xsl:if test="$rrule_byday='TU'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        火曜日
      </option>
      <option value="WE">
        <xsl:if test="$rrule_byday='WE'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        水曜日
      </option>
      <option value="TH">
        <xsl:if test="$rrule_byday='TH'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        木曜日
      </option>
      <option value="FR">
        <xsl:if test="$rrule_byday='FR'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        金曜日
      </option>
      <option value="SA">
        <xsl:if test="$rrule_byday='SA'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        土曜日
      </option>

      <xsl:if test="$selector_type='MONTHLY' or $selector_type='YEARLY'">

	<option value="MO,TU,WE,TH,FR">
		<xsl:if test="$rrule_byday='MO,TU,WE,TH,FR'">
          		<xsl:attribute name="selected"/>
        	</xsl:if>
        	平日
 	</option>
	<option value="SU,SA">
		<xsl:if test="$rrule_byday='SU,SA'">
          		<xsl:attribute name="selected"/>
        	</xsl:if>
        	週末
 	</option>
       </xsl:if>
    </select>
<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
  </font>
</xsl:template>

<!-- Used in recurrence dialog with YEARLY mode -->
<!-- used defined selector name (depending on usage) and set up month menu -->
<!-- Used as part of two other selectors, eg -->
<!-- The <31st> <January> OR -->
<!-- The <1st> <Sunday> <January> -->
<xsl:template name="month_selector">
  <xsl:param name="selector_name"/>
  <xsl:param name="rrule_month"/>
  
  <select name="{$selector_name}" size="{$font_size_big}">
    <option value="1">
      <xsl:if test="$rrule_month='1'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      1 月
    </option>
    <option value="2">
      <xsl:if test="$rrule_month='2'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      2 月
    </option>
    <option value="3">
      <xsl:if test="$rrule_month='3'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      3 月
    </option>
    <option value="4">
      <xsl:if test="$rrule_month='4'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      4 月
    </option>
    <option value="5">
      <xsl:if test="$rrule_month='5'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      5 月
    </option>
    <option value="6">
      <xsl:if test="$rrule_month='6'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      6 月
    </option>
    <option value="7">
      <xsl:if test="$rrule_month='7'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      7 月
    </option>
    <option value="8">
      <xsl:if test="$rrule_month='8'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      8 月
    </option>
    <option value="9">
      <xsl:if test="$rrule_month='9'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      9 月
    </option>
    <option value="10">
      <xsl:if test="$rrule_month='10'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      10 月
    </option>
    <option value="11">
      <xsl:if test="$rrule_month='11'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      11 月
    </option>
    <option value="12">
      <xsl:if test="$rrule_month='12'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      12 月
    </option>
  </select>
</xsl:template>


            
<!-- This form input template is used in search_for_calendars_common.xsl -->
<!-- The layout of the elements may need to change to suit the grammar in l10n -->
<!-- Do NOT change the form element names or the form handling won't work. -->
<!-- You can change the order of the elements and the values as needed -->
<xsl:template name="cal_search_input_template">
<TR>
  <TD colspan="4"> <BR/>
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      次の条件を満たすカレンダーを検索
    </FONT>
  </TD>
</TR>
<TR>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <SELECT name="which">
        <OPTION value="name;calid">名前または ID が</OPTION>
        <OPTION value="name">名前が</OPTION>
        <OPTION value="primaryOwner">主な所有者が</OPTION>
        <OPTION value="calid">ID が</OPTION>
      </SELECT>
    </FONT>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <SELECT name="how">
        <OPTION value="0">次を含む</OPTION>
        <OPTION value="1">次で開始する</OPTION>
      </SELECT>
    </FONT>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
    <INPUT type="text" name="what"/>
    <INPUT type="hidden" name="selected_list" value=""/>
    </FONT>
    <xsl:text>&nbsp;</xsl:text>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <INPUT type="button" name="find" value="検索" width="72">
        <xsl:attribute name="onClick"><xsl:value-of select="./button[@name='find']"/></xsl:attribute>
      </INPUT>
    </FONT>
  </TD>
</TR>
</xsl:template>


<xsl:template name="event_date_time">
  <xsl:param name="includeDate"/>
  <xsl:param name="multiples"/>

  <xsl:if test="$includeDate='true'">
    <xsl:call-template name="brief_date">
      <xsl:with-param name="Month">
        <xsl:value-of select="StartTime/@month"/>
      </xsl:with-param>
      <xsl:with-param name="Day">
        <xsl:value-of select="StartTime/@date"/>
      </xsl:with-param>
      <xsl:with-param name="Year">
        <xsl:value-of select="StartTime/@year"/>
      </xsl:with-param>
    </xsl:call-template>
    ,<xsl:text>&nbsp;</xsl:text>
  </xsl:if>

  <xsl:choose>
    
    <xsl:when test="./@e_allday=1">
      <xsl:if test="$multiples!='TRUE'">
        終日
      </xsl:if>
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="dur_short">
        <xsl:with-param name="date1" select="StartTime"/>
        <xsl:with-param name="date2" select="EndTime"/>
      </xsl:call-template>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- due + [on + date] + at + time-->
<xsl:template name="due_task_date_time">
  <xsl:param name="includeDate"/>
  <xsl:param name="includeTime"/>

  期限<xsl:text>&nbsp;</xsl:text>
  <xsl:if test="$includeDate='true'">
    &nbsp;
    <xsl:call-template name="brief_date">
      <xsl:with-param name="Month" select="DueTime/@month"/>
      <xsl:with-param name="Day" select="DueTime/@date"/>
      <xsl:with-param name="Year" select="DueTime/@year"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$includeTime='true'">
<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
    <xsl:call-template name="formatTime">
      <xsl:with-param name="ftHour" select="DueTime/@hour"/>
      <xsl:with-param name="ftMinute" select="DueTime/@minute"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>
      
<!-- [overdue] + from + date + at + [time] -->
<!-- The font gets set outside -->
<xsl:template name="overdue_task_date_time">
  <xsl:param name="multiples"/> 
 <xsl:param name="notime"/>
  
  <xsl:if test="$multiples!='TRUE'">
    期限切れ<xsl:text>&nbsp;</xsl:text>
  </xsl:if>
  &nbsp;<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="task_date_at_time">
    <xsl:with-param name="dateA" select="DueTime"/>
    <xsl:with-param name="notime" select="$notime"/>
   </xsl:call-template>
</xsl:template>


<!-- called in singleDayTimeHeaderTemplate to output date in form -->
<!-- Friday -->
<!-- May 24, 2002 -->
<!-- The format will need changing for localization purposes -->
<xsl:template name="dayTimeHeader">

  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
<!-- l10n_ja -->
  <xsl:value-of select="timectx/StartTime/@year"/>
  <xsl:text>&nbsp;</xsl:text>
  年
  <xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="timectx/StartTime/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="timectx/StartTime/@date"/>
  <xsl:text>&nbsp;</xsl:text>
  日
  <br/>
  <b>
  <xsl:apply-templates select="timectx/StartTime/@dow"/>
  </b>
<!-- end_of_l10n_ja -->
  </font>
</xsl:template>          

<!-- Format is: -->
<!-- Month1 Day1[, Year1] - Month7 Day7, Year7 -->
<!-- Where the optional ", Year1" is only printed if different from Year2-->
<!-- This format can be changed for localization purposes -->
<xsl:template name="weekTimeHeader">

  <font face="{$font_name}" size="{$font_size_big_3}" color="#000000">
  <b>
<!-- l10n_ja -->
  <xsl:value-of select="weekcal/weekday[1]/@year"/>
  <xsl:text>&nbsp;</xsl:text>
  年
  <xsl:text> </xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="weekcal/weekday[1]/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="weekcal/weekday[1]/@date"/>
  <xsl:text>&nbsp;</xsl:text>
  日
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="$horiz_divider"/>
  <xsl:if test="weekcal/weekday[1]/@year!=weekcal/weekday[7]/@year">
    <xsl:text>&nbsp;</xsl:text>
    <xsl:value-of select="weekcal/weekday[7]/@year"/>
    <xsl:text>&nbsp;</xsl:text>
    年
    <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="weekcal/weekday[7]/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="weekcal/weekday[7]/@date"/>
  <xsl:text>&nbsp;</xsl:text>
  日
<!-- end_of_l10n_ja -->
  </b>
  </font>
</xsl:template>          

<!-- Of the format -->
<!-- May 2002 -->
<!-- This can be changed for localization purposes -->
<xsl:template name="monthTimeHeader">

  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
  <b>
<!-- l10n_ja -->
  <xsl:value-of select="timectx/StartTime/@year"/>
  <xsl:text>&nbsp;</xsl:text>
  年
  <xsl:text> </xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="timectx/StartTime/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
<!-- end_of_l10n_ja -->
  </b></font>
</xsl:template>          

<!-- Of the format -->
<!-- 2002 -->
<!-- this can be changed for localization purposes -->
<xsl:template name="yearTimeHeader">
  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
  <b>
<!-- l10n_ja -->
  <xsl:value-of select="timectx/StartTime/@year"/>
  <xsl:text>&nbsp;</xsl:text>
  年
<!-- end_of_l10n_ja -->
  </b>
  </font>
</xsl:template>          

<!-- This form input template is used in search_for_components.xsl -->
<!-- The layout of the elements may need to change to suit the grammar in l10n -->
<!-- Do NOT change the form element names or the form handling won't work. -->
<xsl:template name="searchComponentsInputTemplate">

  <TD colspan="4">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      次を含む予定と作業を検索
    </FONT>
  </TD>
  <TD valign="baseline">
    <INPUT type="text" name="what"/>
  </TD>
</xsl:template>

<!-- This needs to live here because it's format will change to be localized -->
<xsl:template name="emitRecurChangePatternLinkEvent">
  繰り返し
  <xsl:text> </xsl:text>
  <xsl:call-template name="recurrenceString">
    <xsl:with-param name="e_rrule_daily" select="../eventdata/Event/@e_rrule_daily"/>
    <xsl:with-param name="e_rrule_weekly" select="../eventdata/Event/@e_rrule_weekly"/>
    <xsl:with-param name="e_rrule_monthly" select="../eventdata/Event/@e_rrule_monthly"/>
    <xsl:with-param name="e_rrule_yearly" select="../eventdata/Event/@e_rrule_yearly"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  [<A>
     <xsl:attribute name="href"><xsl:value-of select="command[@name='recurrence']"/></xsl:attribute>
     繰り返しパターンの変更
  </A>]
</xsl:template>

<!-- This needs to live here because it's format will change to be localized -->
<xsl:template name="emitRecurChangePatternLinkTask">
  繰り返し
  <xsl:text> </xsl:text>
  <xsl:call-template name="recurrenceString">
    <xsl:with-param name="e_rrule_daily" select="../taskdata/Task/@e_rrule_daily"/>
    <xsl:with-param name="e_rrule_weekly" select="../taskdata/Task/@e_rrule_weekly"/>
    <xsl:with-param name="e_rrule_monthly" select="../taskdata/Task/@e_rrule_monthly"/>
    <xsl:with-param name="e_rrule_yearly" select="../taskdata/Task/@e_rrule_yearly"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  [<A>
     <xsl:attribute name="href"><xsl:value-of select="command[@name='recurrence']"/></xsl:attribute>
     繰り返しパターンの変更
  </A>]
</xsl:template>

<!-- This is set up here so that the layout can be changed for l10n -->
<!-- do not change the name of the elements or the form processing won't work -->
<!-- in 'en' this is beginning <month> <date><year> Ending <month><date><year> -->
<xsl:template name="importExportDateRangeInput">
<xsl:text>&nbsp;</xsl:text>
開始
<!-- l10n_ja -->
<!-- end_of_l10n_ja -->
<xsl:variable name="startYear">
<xsl:value-of select="./timectx/StartTime/@year"/>
</xsl:variable>

<xsl:variable name="endYear">
<xsl:value-of select="./timectx/EndTime/@year"/>
</xsl:variable>

<xsl:variable name="startMonth">
<xsl:value-of select="./timectx/StartTime/@month"/>
</xsl:variable>

<xsl:variable name="endMonth">
<xsl:value-of select="./timectx/EndTime/@month"/>
</xsl:variable>

<!-- l10n_ja -->
<INPUT type="text" name="ms_year" size="4" maxlength="4">
<xsl:attribute name="value"><xsl:value-of select="./timectx/StartTime/@year"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_yearCheck('ms', f);
</xsl:attribute>
</INPUT>
<xsl:text>&nbsp;</xsl:text>
年

<xsl:text>&nbsp;</xsl:text>
<SELECT name="mStart">
<!-- end_of_l10n_ja -->
<OPTION value="1">
<xsl:if test="$startMonth='01'"><xsl:attribute name="selected"/></xsl:if>
1 月</OPTION>
<OPTION value="2">
<xsl:if test="$startMonth='02'"><xsl:attribute name="selected"/></xsl:if>
2 月</OPTION>
<OPTION value="3">
<xsl:if test="$startMonth='03'"><xsl:attribute name="selected"/></xsl:if>
3 月</OPTION>
<OPTION value="4">
<xsl:if test="$startMonth='04'"><xsl:attribute name="selected"/></xsl:if>
4 月</OPTION>
<OPTION value="5">
<xsl:if test="$startMonth='05'"><xsl:attribute name="selected"/></xsl:if>
5 月</OPTION>
<OPTION value="6">
<xsl:if test="$startMonth='06'"><xsl:attribute name="selected"/></xsl:if>
6 月</OPTION>
<OPTION value="7">
<xsl:if test="$startMonth='07'"><xsl:attribute name="selected"/></xsl:if>
7 月</OPTION>
<OPTION value="8">
<xsl:if test="$startMonth='08'"><xsl:attribute name="selected"/></xsl:if>
8 月</OPTION>
<OPTION value="9">
<xsl:if test="$startMonth='09'"><xsl:attribute name="selected"/></xsl:if>
9 月</OPTION>
<OPTION value="10">
<xsl:if test="$startMonth='10'"><xsl:attribute name="selected"/></xsl:if>
10 月</OPTION>
<OPTION value="11">
<xsl:if test="$startMonth='11'"><xsl:attribute name="selected"/></xsl:if>
11 月</OPTION>
<OPTION value="12">
<xsl:if test="$startMonth='12'"><xsl:attribute name="selected"/></xsl:if>
12 月</OPTION>
</SELECT>
<INPUT type="text" name="ms_day" size="{$font_size_big_2}" maxlength="2">
<xsl:attribute name="value"><xsl:value-of select="./timectx/StartTime/@date"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_ddCheck('ms', f);
</xsl:attribute>
</INPUT>
<!-- l10n_ja -->
<xsl:text>&nbsp;</xsl:text>
日
<!-- end_of_l10n_ja -->
<xsl:text>&nbsp;</xsl:text>終了
<!-- l10n_ja -->
<INPUT type="text" name="me_year" size="4" maxlength="4">
<xsl:attribute name="value"><xsl:value-of select="./timectx/EndTime/@year"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_yearCheck('me', f);
</xsl:attribute>
</INPUT>
<xsl:text>&nbsp;</xsl:text>
年

<xsl:text>&nbsp;</xsl:text>
<!-- end_of_l10n_ja -->
<SELECT name="mEnd">
<OPTION value="1">
<xsl:if test="$endMonth='01'"><xsl:attribute name="selected"/></xsl:if>
1 月</OPTION>
<OPTION value="2">
<xsl:if test="$endMonth='02'"><xsl:attribute name="selected"/></xsl:if>
2 月</OPTION>
<OPTION value="3">
<xsl:if test="$endMonth='03'"><xsl:attribute name="selected"/></xsl:if>
3 月</OPTION>
<OPTION value="4">
<xsl:if test="$endMonth='04'"><xsl:attribute name="selected"/></xsl:if>
4 月</OPTION>
<OPTION value="5">
<xsl:if test="$endMonth='05'"><xsl:attribute name="selected"/></xsl:if>
5 月</OPTION>
<OPTION value="6">
<xsl:if test="$endMonth='06'"><xsl:attribute name="selected"/></xsl:if>
6 月</OPTION>
<OPTION value="7">
<xsl:if test="$endMonth='07'"><xsl:attribute name="selected"/></xsl:if>
7 月</OPTION>
<OPTION value="8">
<xsl:if test="$endMonth='08'"><xsl:attribute name="selected"/></xsl:if>
8 月</OPTION>
<OPTION value="9">
<xsl:if test="$endMonth='09'"><xsl:attribute name="selected"/></xsl:if>
9 月</OPTION>
<OPTION value="10">
<xsl:if test="$endMonth='10'"><xsl:attribute name="selected"/></xsl:if>
10 月</OPTION>
<OPTION value="11">
<xsl:if test="$endMonth='11'"><xsl:attribute name="selected"/></xsl:if>
11 月</OPTION>
<OPTION value="12">
<xsl:if test="$endMonth='12'"><xsl:attribute name="selected"/></xsl:if>
12 月</OPTION>
</SELECT>

<INPUT type="text" name="me_day" size="{$font_size_big_2}" maxlength="2">
<xsl:attribute name="value"><xsl:value-of select="./timectx/EndTime/@date"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_ddCheck('me', f);
</xsl:attribute>
</INPUT>
<!-- l10n_ja -->
<xsl:text>&nbsp;</xsl:text>
日
<!-- end_of_l10n_ja -->
</xsl:template>

<!-- Of the format -->
<!-- Sunday 19 -->
<!-- This can be changed for localization purposes -->
<xsl:template name="weekDayDate">
  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
<!-- l10n_ja -->
    <xsl:apply-templates select="@date"/>
    <xsl:text>&nbsp;</xsl:text>
    日
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="@dow"/>
<!-- end_of_l10n_ja -->
  </FONT>
</xsl:template>          

<!-- Of the format -->
<!-- 19  used in the month table to label each day box-->
<!-- This can be changed for localization purposes -->
<xsl:template name="monthDayDate">
  <xsl:param name="color"/> 

  <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="{$color}">
    <xsl:value-of select="@date"/>        
  </FONT>
</xsl:template>            



</xsl:stylesheet>



