<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output cdata-section-elements="HTMLSummary HTMLDescription"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="toolbar.xsl"/>
<xsl:include href="printview.xsl"/>

<!-- Added variable -Satya -->
<xsl:variable name="isGroupView">false</xsl:variable>
<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">     
    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Sun Java[tm] System Calendar Express</TITLE>
      <xsl:variable name="defCalendar">
        <xsl:value-of select="$usrctx/user/@name"/>
      </xsl:variable>

      <xsl:if test="/calendar/DWPErrorList">
        <xsl:for-each select="/calendar/DWPErrorList/DWPNode">
          <xsl:if test="@DWPCalID=$defCalendar">
            <script>
              jmain.newViewCommand('logout','','true','errorcode',
                '<xsl:value-of select="@DWPErrNo"/>', '0', 'false');
            </script>
          </xsl:if>
       </xsl:for-each>
      </xsl:if> 

    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="120,*">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="idx" frameborder="0" src="{$Frame2}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:call-template name="main_root"/>
    </xsl:when>

    <xsl:when test="@view='toolbar'">
      <xsl:call-template name="toolbar_root"/>      
    </xsl:when>
<!-- Commenting out dead code - Satya
    <xsl:when test="@view='dialog'">
      <xsl:call-template name="dialog_root"/>      
    </xsl:when>
-->
    <xsl:when test="@view='print'">
      <xsl:for-each select="group[@name='main']">
        <xsl:call-template name="print_root"/>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view?-<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="main_root">
  <HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
  
  <body bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
  <form name="form">
    <xsl:for-each select="group">

      <xsl:if test="(@name='main') and (@view!='yearview')">
        <xsl:call-template name="main_view"/>
      </xsl:if>

      <xsl:if test="(@name='main') and (@view='yearview')">
        <xsl:call-template name="main_view_year"/>
      </xsl:if>

    </xsl:for-each>
  </form></body>
  </HTML>
</xsl:template>

<xsl:template name="main_view">
  <TABLE border="0" cellpadding="2" cellspacing="8" width="100%">
    <TR>
<!-- Main data -->
      <TD valign="top">
        <xsl:apply-templates select="panel[1]"/>
      </TD>
<!-- minical, etc -->
      <TD nowrap="" valign="top" align="center">
        <xsl:apply-templates select="panel[2]"/>
      </TD>
    </TR>
  </TABLE>
</xsl:template>

<xsl:template name="main_view_year">
<CENTER>
  <xsl:apply-templates select="panel[1]"/>
</CENTER>
</xsl:template>

<!-- This is used by overview, dayview and groupview -->
<!-- weekview, monthview and yearview have similar equivs -->
<xsl:template name="singleDayTimeHeaderTemplate">
    <TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
      <TR>
        <TD width="1%" nowrap="">
        <A><xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute><IMG src="imx/ppage-1.gif" width="15" height="15" border="0" alt="前日に移動" align="left"/></A><BR/><A><xsl:attribute name="href"><xsl:value-of select="command[2]"/></xsl:attribute><IMG src="imx/npage-1.gif" width="15" height="15" border="0" alt="翌日に移動" align="left"/></A></TD>
        <TD nowrap="">
          <xsl:call-template name="dayTimeHeader"/>
       </TD>
<!--
       <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>
       </TD>
-->
     </TR>
   </TABLE>
</xsl:template>

<xsl:template name="ComponentGroup">
  <xsl:choose>
<!-- used for time blocks of events/tasks. the real data is one level lower -->
    <xsl:when test="(@ComponentGroupType='group')">
    <xsl:for-each select="ComponentGroup">
        <xsl:call-template name="ComponentGroupGuts">
          <xsl:with-param name="startinfo" select="../StartTime"/>
          <xsl:with-param name="endinfo" select="../EndTime"/>
        </xsl:call-template>
    </xsl:for-each>
    </xsl:when>
<xsl:otherwise>
        <xsl:call-template name="ComponentGroupGuts">
          <xsl:with-param name="startinfo" select="StartTime"/>
          <xsl:with-param name="endinfo" select="EndTime"/>
        </xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="ComponentGroupGuts">
<xsl:param name="startinfo"/>
<xsl:param name="endinfo"/>

<xsl:choose>
    <xsl:when test="(@ComponentGroupType='onday_tasks') or (@ComponentGroupType='nodate_tasks')">
      <xsl:if test="Task">
        <P/><FONT face="{$font_name}" size="{$font_size_big_2}"><B>
        <xsl:choose>
          <xsl:when test="@ComponentGroupType='onday_tasks'">
            今日が期限です。
          </xsl:when>
          <xsl:otherwise>
            その他の作業
          </xsl:otherwise>
        </xsl:choose>
        </B></FONT>
        <xsl:choose>
          <xsl:when test="count(Task) != 1">
            <UL>
            <xsl:for-each select="Task">
              <P/>
              <LI>
              <xsl:call-template name="List_Task"><xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
                <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
              </LI>
            </xsl:for-each>
            </UL>
          </xsl:when>
        
          <xsl:otherwise>
            <BR/>
            <xsl:for-each select="Task">
              <xsl:call-template name="List_Task"><xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
                <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      
    </xsl:when>
    <xsl:when test="@ComponentGroupType='overdue_tasks'">
      <xsl:if test="Task">
        <xsl:choose>
          <xsl:when test="count(Task) != 1">
            <P/><FONT face="{$font_name}" size="{$font_size_big_2}" color="{$color_overdue}"><B>期限を過ぎた作業</B></FONT><UL>
            <xsl:for-each select="Task">
              <P/>
              <LI>
              <xsl:call-template name="List_Task"><xsl:with-param name="multiple_overdues">TRUE</xsl:with-param>
              <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
              </LI>
            </xsl:for-each>
            </UL>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="Task">
              <P/>
              <xsl:call-template name="List_Task"><xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
              <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:when>
    <xsl:when test="@ComponentGroupType='allday_events'">
      <xsl:if test="Event|Busy">
        <xsl:choose>
          <xsl:when test="count(Event|Busy) != 1">
            <P/><FONT face="{$font_name}" size="{$font_size_big_2}"><B>終日予定</B></FONT><UL>
            <xsl:for-each select="Event|Busy">
              <xsl:if test="name(.)='Event'">
                <P/>
                <LI>
                <xsl:call-template name="List_Event">
                <xsl:with-param name="includeDate">FALSE</xsl:with-param>
                <xsl:with-param name="multiples">TRUE</xsl:with-param>
                <xsl:with-param name="delete">true</xsl:with-param>
                </xsl:call-template>
                </LI>
              </xsl:if>
              <xsl:if test="name(.)='Busy'">
                <P/>
                <LI>
                <xsl:call-template name="List_Busy">
                </xsl:call-template>
                </LI>
              </xsl:if>
            </xsl:for-each>
            </UL>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="Event|Busy">
            <xsl:if test="name(.)='Event'">
              <P/>
              <xsl:call-template name="List_Event">
              <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="name(.)='Busy'">
              <P/>
              <xsl:call-template name="List_Busy">
              </xsl:call-template>
            </xsl:if>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="not(Busy|Event|Task|ComponentGroup)"/>
        <xsl:when test="(count(Busy|Event|Task) = 1) and (count(ComponentGroup) = 0)">
          <xsl:for-each select="Busy|Event|Task">
            <xsl:if test="name(.)='Task'">
              <P/>
              <xsl:call-template name="List_Task"><xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
              <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="name(.)='Event'">
              <P/>
              <xsl:call-template name="List_Event">
              <xsl:with-param name="delete">true</xsl:with-param>
              </xsl:call-template>
            </xsl:if>
            <xsl:if test="name(.)='Busy'">
              <P/>
              <xsl:call-template name="List_Busy">
              </xsl:call-template>
            </xsl:if>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <P>
          	<FONT face="{$font_name}" size="{$font_size_big_2}">
          		<B>
            		<xsl:call-template name="dur_short">
              			<xsl:with-param name="date1" select="$startinfo"/>
              			<xsl:with-param name="date2" select="$endinfo"/>
            		</xsl:call-template>
          		</B>
          	</FONT>
          </P>
          <UL>
          	<xsl:for-each select="*">
            	<xsl:if test="name(.)='Task'">
              		<P/>
              		<LI>
              			<xsl:call-template name="List_Task">
              				<xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
                                        <xsl:with-param name="delete">true</xsl:with-param>
              			</xsl:call-template>
              		</LI>
            </xsl:if>
            <xsl:if test="name(.)='Event'">
              <P/>
              <LI>
              	<xsl:call-template name="List_Event">
              		<xsl:with-param name="delete">true</xsl:with-param>
              	</xsl:call-template>
              </LI>
            </xsl:if>
            <xsl:if test="name(.)='Busy'">
              <P/>
              <LI>
              	<xsl:call-template name="List_Busy">
              	</xsl:call-template>
              </LI>
            </xsl:if>

<!-- Nested ComponentGroups indicate conflicts -->
            <xsl:if test="name(.)='ComponentGroup'">
              <xsl:for-each select="*">
                <P/>
                <LI>
                	<xsl:if test="count(../Event) &gt; 1 and name(.)!='Task'">
                  		<FONT face="{$font_name}" size="{$font_size_big_2}" color="{$color_conflict}">
                  			重複 
                  		</FONT>
                	</xsl:if>
                	<xsl:if test="name(.)='Task'">
                  		<xsl:call-template name="List_Task">
                  			<xsl:with-param name="multiple_overdues">FALSE</xsl:with-param>
                                        <xsl:with-param name="delete">true</xsl:with-param>
                  		</xsl:call-template>
                	</xsl:if>
                	<xsl:if test="name(.)='Event'">
                  		<xsl:call-template name="List_Event">
                  			<xsl:with-param name="delete">true</xsl:with-param>
                  		</xsl:call-template>
                	</xsl:if>
                	<xsl:if test="name(.)='Busy'">
                  		<xsl:call-template name="List_Busy">
                  		</xsl:call-template>
                	</xsl:if>
                </LI>
              </xsl:for-each>
            </xsl:if>

          </xsl:for-each>
         </UL>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- simplified version of componentGroup for small views -->
<!-- like week/month slots -->
<xsl:template name="limitedComponentGroup">
  <xsl:choose>
    <xsl:when test="(@ComponentGroupType='onday_tasks') or (@ComponentGroupType='nodate_tasks')">
      <xsl:if test="count(Task) != 0">
        <xsl:for-each select="Task">
          <P/>
          <xsl:call-template name="smallList_Task"/>
        </xsl:for-each>
      </xsl:if>
    </xsl:when>

    <xsl:when test="@ComponentGroupType='overdue_tasks'">
        <xsl:for-each select="Task">
          <P/>
          <xsl:call-template name="smallList_Task"/>
        </xsl:for-each>
    </xsl:when>

    <xsl:when test="@ComponentGroupType='allday_events'">
            <xsl:for-each select="Event|Busy">
              <xsl:if test="name(.)='Event'">
                <P/>
                <xsl:call-template name="smallList_Event"/>
              </xsl:if>
              <xsl:if test="name(.)='Busy'">
                <P/>
                <xsl:call-template name="smallList_Busy"/>
              </xsl:if>
            </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="count(Busy|Event|Task|ComponentGroup) = 0"/>
        <xsl:otherwise>
          <xsl:for-each select="Busy|Event|Task|ComponentGroup">
            <xsl:if test="name(.)='Task'">
              <P/>
              <xsl:call-template name="smallList_Task"/>
            </xsl:if>
            <xsl:if test="name(.)='Event'">
              <P/>
              <xsl:call-template name="smallList_Event"/>
            </xsl:if>
            <xsl:if test="name(.)='Busy'">
              <P/>
              <xsl:call-template name="smallList_Busy"/>
            </xsl:if>
<!-- nested means there were conflicts -->
            <xsl:if test="name(.)='ComponentGroup'">
<!-- but it's only really a conflict if there are 2 or more EVENTS -->        
              <xsl:if test="count(Event) &gt; 1">
                <xsl:for-each select="*">
                  <xsl:if test="name(.)='Task'">
                  <P/>
                  <xsl:call-template name="smallList_Task"/>
                  </xsl:if>
                  <xsl:if test="name(.)='Event'">
                  <P/>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_conflict}">重複<br/></FONT>
                  <xsl:call-template name="smallList_Event"/>
                  </xsl:if>
                  <xsl:if test="name(.)='Busy'">
                  <P/>
                  <xsl:call-template name="smallList_Busy"/>
                  </xsl:if>
                </xsl:for-each>
              </xsl:if>
<!-- If there is only 1 or less event (regardless of tasks, there is no conflict -->
              <xsl:if test="count(Event)&lt;=1">
                <xsl:for-each select="*">
                  <xsl:if test="name(.)='Task'">
                  <P/>
                  <xsl:call-template name="smallList_Task"/>
                  </xsl:if>
                  <xsl:if test="name(.)='Event'">
                  <P/>
                  <xsl:call-template name="smallList_Event"/>
                  </xsl:if>
                  <xsl:if test="name(.)='Busy'">
                  <P/>
                  <xsl:call-template name="smallList_Busy"/>
                  </xsl:if>
                </xsl:for-each>
              </xsl:if>
            </xsl:if>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="smallList_Task">
<xsl:choose>
  <xsl:when test="@overdue='TRUE' and not(@e_dtcompleted)">
  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_overdue}">
    期限切れ
  </FONT>
  </xsl:when>
  <xsl:when test="@e_allday='1'">
    <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
    今日が期限です。
    </FONT>
  </xsl:when>
  <xsl:otherwise>
    <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
    <xsl:call-template name="due_task_date_time">
      <xsl:with-param name="includeDate">false</xsl:with-param>
      <xsl:with-param name="includeTime">true</xsl:with-param>
    </xsl:call-template>
    </FONT>
  </xsl:otherwise>
</xsl:choose>
<xsl:if test="(@e_displayCalendar='true') and ($isGroupView != 'true')">
  <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
  <FONT face="{$font_name}" size="{$font_size_big}">
    <xsl:call-template name="printCalendarName">
      <xsl:with-param name="name" select="@e_Calid"/>
    </xsl:call-template>
  </FONT>
</xsl:if>
<BR/>
<!-- Now print the SECOND line -->
<FONT face="{$font_name}" size="{$font_size_big}">
  <xsl:call-template name="Output_Task_Link_Line">
    <xsl:with-param name="full_listing">false</xsl:with-param>
    <xsl:with-param name="delete">true</xsl:with-param>
  </xsl:call-template>
</FONT>
<BR/>
</xsl:template>

<xsl:template name="smallList_Event">
<FONT face="{$font_name}" size="{$font_size_big}">
<xsl:choose>
  <xsl:when test="./@e_allday='1'">
<!--          All Day -->
  </xsl:when>
  <xsl:otherwise>
    <xsl:call-template name="dur_short">
      <xsl:with-param name="date1" select="StartTime"/>
      <xsl:with-param name="date2" select="EndTime"/>
    </xsl:call-template>
  </xsl:otherwise>
</xsl:choose>
</FONT>
  <xsl:if test="string-length(@e_Location)&gt;0">
    <xsl:if test="@e_allday!='1'">
      <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
    </xsl:if>
    <FONT face="{$font_name}" size="{$font_size_big}">
    <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="@e_Location"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
    </xsl:call-template></FONT>
  </xsl:if>
<xsl:if test="(@e_displayCalendar='true') and ($isGroupView != 'true')">
  <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
<!-- ViewCalids is the list of attendees whose calids are currently being viewed -->
<!-- TODO - figure out a way to limit the individual calids contained in line to some number of chars max -->
  <FONT face="{$font_name}" size="{$font_size_big}"><xsl:value-of select="@ViewCalids"/></FONT>
</xsl:if>
<BR/>

<!-- Now print the SECOND line -->
  <FONT face="{$font_name}" size="{$font_size_big}">

  <xsl:if test="$isGroupView = 'true'">
    <xsl:attribute name="color">#FFFFFF</xsl:attribute>
  </xsl:if>

  <xsl:call-template name="Output_Event_Link_Line">
    <xsl:with-param name="full_listing">false</xsl:with-param>
    <xsl:with-param name="delete">true</xsl:with-param>
  </xsl:call-template>

  </FONT>
  <BR/>
</xsl:template>



<xsl:template name="smallList_Busy">
    <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
    <xsl:choose>
    <xsl:when test="./@e_allday='1'">
<!--          All Day -->
    <xsl:call-template name="event_date_time">
      <xsl:with-param name="includeDate">FALSE</xsl:with-param>
      <xsl:with-param name="multiples">FALSE</xsl:with-param>
    </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
    <xsl:call-template name="dur_short">
      <xsl:with-param name="date1" select="StartTime"/>
      <xsl:with-param name="date2" select="EndTime"/>
    </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
    </FONT>
    <xsl:if test="(string-length(/calendar/usrctx/@selectedCalendar) = 0) and ($isGroupView != 'true')">
  	<FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
  	<FONT face="{$font_name}" size="{$font_size_big}">
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="@e_Calid"/>
      </xsl:call-template>
    </FONT>
    </xsl:if>
    <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
    <B>
    <xsl:text>&nbsp;&nbsp;</xsl:text>予定あり
    </B>
    </FONT>

<BR/>
</xsl:template>

<xsl:template name="List_Busy">
    <FONT face="{$font_name}" size="{$font_size_big_2}"><B>
    <xsl:choose>
    <xsl:when test="./@e_allday='1'">
<!--          All Day -->
    <xsl:call-template name="event_date_time">
      <xsl:with-param name="includeDate">FALSE</xsl:with-param>
      <xsl:with-param name="multiples">FALSE</xsl:with-param>
    </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="dur_short">
        <xsl:with-param name="date1" select="StartTime"/>
        <xsl:with-param name="date2" select="EndTime"/>
      </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
    </B></FONT>
    <xsl:if test="(string-length(/calendar/usrctx/@selectedCalendar) = 0) and ($isGroupView != 'true')">
  	<FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
  	<FONT face="{$font_name}" size="{$font_size_big}">
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="@e_Calid"/>
      </xsl:call-template>
    </FONT>
    </xsl:if>
    <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
    <B>
    <xsl:text>&nbsp;&nbsp;</xsl:text>予定あり
    </B>
    </FONT>

<BR/>
</xsl:template>

<xsl:template name="showGroupGlif">
<xsl:param name="curevent"/>
<xsl:param name="editcmd"/>

     <xsl:if test="$curevent/@AttendeeGroup = 'true'">
<!-- <xsl:if test="count($curevent/attendee) > 1"> -->
 
<!-- If there is an edit command, put it in anchors, otherwise just put out image-->
<xsl:choose>
<xsl:when test="$editcmd and (/calendar/@view != 'print')">
  <A>
    <xsl:attribute name="href"><xsl:value-of select="$editcmd"/></xsl:attribute>
    <xsl:attribute name="onmouseover">window.status='<xsl:value-of select="$curevent/@EncodedAttendeeStatus"/>';return true;</xsl:attribute>
    <IMG src="imx/group.gif" width="18" height="18" border="0" hspace="2" align="baseline">
      <xsl:attribute name="alt"><xsl:value-of select="$curevent/@AttendeeStatus"/></xsl:attribute>
    </IMG>        
  </A>
</xsl:when>
<xsl:otherwise>
    <IMG src="imx/group.gif" width="18" height="18" border="0" hspace="2" align="baseline">
      <xsl:attribute name="alt"><xsl:value-of select="$curevent/@AttendeeStatus"/></xsl:attribute>
    </IMG>        
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:template>


<xsl:template name="List_HTML_Field">
<xsl:param name="text_line"/>
<xsl:param name="url_line"/>
<xsl:param name="is_html"/>
<xsl:param name="partstat_style_start"/>
<xsl:param name="partstat_style_end"/>

  <xsl:choose>

    <xsl:when test="$is_html = 'true'">
      <A>
        <xsl:attribute name="href"><xsl:value-of select="$url_line"/></xsl:attribute>
        <IMG src="imx/event-edit.gif" width="13" height="12" border="0" alt="この予定を表示" />
      </A><xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="$partstat_style_start"/>
      <xsl:value-of select="string($text_line)" disable-output-escaping="yes"/>
      <xsl:value-of select="$partstat_style_end"/>
    </xsl:when>

    <xsl:otherwise>
      <A>
        <xsl:attribute name="href"><xsl:value-of select="$url_line"/></xsl:attribute>
        <xsl:value-of select="$partstat_style_start"/>
        <xsl:call-template name="truncatestring">
           <xsl:with-param name="thestring" select="$text_line"/>
           <xsl:with-param name="thelength">60</xsl:with-param>
        </xsl:call-template>
        <xsl:value-of select="$partstat_style_end"/>
      </A>
    </xsl:otherwise>

  </xsl:choose>

</xsl:template>

<!-- this is for a full view, eg not "minor -->
<xsl:template name="List_Event">
 <xsl:param name="includeDate"/>
 <xsl:param name="multiples"/>
 <xsl:param name="delete"/>

  <FONT face="{$font_name}" size="{$font_size_big_2}"><B>

  <xsl:call-template name="event_date_time">
    <xsl:with-param name="includeDate" select="$includeDate"/>
    <xsl:with-param name="multiples" select="$multiples"/>
  </xsl:call-template>

  </B></FONT>
  <xsl:if test="string-length(@e_Location)&gt;0">
    <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
    <FONT face="{$font_name}" size="{$font_size_big}">
    <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="@e_Location"/>
     <xsl:with-param name="thelength">60</xsl:with-param>
    </xsl:call-template></FONT>
  </xsl:if>
  <xsl:if test="(@e_displayCalendar='true') and ($isGroupView != 'true')">
    <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
<!-- ViewCalids is the list of attendees whose calids are currently being viewed -->
<!-- TODO - figure out a way to limit the individual calids contained in line to some number of chars max -->
    <FONT face="{$font_name}" size="{$font_size_big}"><xsl:value-of select="@ViewCalids"/></FONT>
  </xsl:if>

<!-- only put in line break if you printed something out -->
  <xsl:if test="$multiples!='TRUE'">
    <BR/>
  </xsl:if>

  <FONT face="{$font_name}" size="{$font_size_big_2}">

<!-- Now print the SECOND line -->
  <xsl:call-template name="Output_Event_Link_Line">
    <xsl:with-param name="full_listing">true</xsl:with-param>
    <xsl:with-param name="delete" select="$delete"/>
  </xsl:call-template>

  </FONT>
  <BR/>
</xsl:template>

<!-- This is for a full listing - eg not "minor" view, such as monthview cell -->
<xsl:template name="List_Task">
  <xsl:param name="multiple_overdues"/>
  <xsl:param name="includeDate"/>
  <xsl:param name="delete"/>

<!-- First print out the TOP line of information -->
  <xsl:choose>
    <xsl:when test="(@overdue='TRUE')">
      <xsl:choose>
        <xsl:when test="(@overdue='TRUE') and ($multiple_overdues!='TRUE')">
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="{$color_overdue}">
          <B>
          <xsl:call-template name="overdue_task_date_time">
            <xsl:with-param name="multiples" select="$multiple_overdues"/>
            <xsl:with-param name="notime" select="@e_allday"/>
          </xsl:call-template>
          </B>
          </FONT>
        </xsl:when>
        <xsl:otherwise>
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
          <B>
          <xsl:call-template name="overdue_task_date_time">
            <xsl:with-param name="multiples" select="$multiple_overdues"/>
            <xsl:with-param name="notime" select="@e_allday"/>
          </xsl:call-template>
          </B>
          </FONT>
      </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length(@e_Location)&gt;0">
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
        <FONT face="{$font_name}" size="{$font_size_big}">
        <xsl:call-template name="truncatestring">
          <xsl:with-param name="thestring" select="@e_Location"/>
          <xsl:with-param name="thelength">60</xsl:with-param>
        </xsl:call-template></FONT>
      </xsl:if>
      <xsl:if test="(@e_displayCalendar='true') and ($isGroupView != 'true')">
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
        <FONT face="{$font_name}" size="{$font_size_big}">
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="@e_Calid"/>
          </xsl:call-template>
        </FONT>
      </xsl:if>
      <BR/>
    </xsl:when>
<!-- ON DAY/NO TIME or NOTDUE-->
    <xsl:when test="./@e_allday='1'">
      <xsl:if test="$includeDate='true'">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
          <B>
          <xsl:call-template name="due_task_date_time">
            <xsl:with-param name="includeDate">true</xsl:with-param>
            <xsl:with-param name="includeTime">false</xsl:with-param>
          </xsl:call-template>
          </B>
        </FONT>
        <BR/>
      </xsl:if>
    </xsl:when>
    <xsl:when test="./@e_notdue='1'">
      <xsl:if test="$includeDate='true'">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
          <B>
          期限なし 
          </B>
        </FONT>
        <BR/>
      </xsl:if>
    </xsl:when>
<!-- WITH DAY/TIME -->
    <xsl:otherwise>
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
       <B>
        <xsl:call-template name="due_task_date_time">
          <xsl:with-param name="includeDate" select="$includeDate"/>
          <xsl:with-param name="includeTime">true</xsl:with-param>
         </xsl:call-template>
        </B>
        <xsl:if test="string-length(@e_Location)&gt;0">
          <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
          <FONT face="{$font_name}" size="{$font_size_big}">
           <xsl:call-template name="truncatestring">
            <xsl:with-param name="thestring" select="@e_Location"/>
            <xsl:with-param name="thelength">60</xsl:with-param>
           </xsl:call-template></FONT>
        </xsl:if>
        <xsl:if test="(@e_displayCalendar='true') and ($isGroupView != 'true')">
          <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_mid}"><xsl:value-of select="$vert_divider"/></FONT>
          <FONT face="{$font_name}" size="{$font_size_big}">
            <xsl:call-template name="printCalendarName">
              <xsl:with-param name="name" select="@e_Calid"/>
            </xsl:call-template>
          </FONT>
        </xsl:if>
      </FONT>
      <BR/>
    </xsl:otherwise>
  </xsl:choose>

<!-- NOW print out the SECOND line of information -->
  <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:call-template name="Output_Task_Link_Line">
      <xsl:with-param name="full_listing">true</xsl:with-param>
      <xsl:with-param name="delete" select="$delete"/>
    </xsl:call-template>
    <BR/>
  </FONT>
</xsl:template>


<!-- This template is used by both smallList_Task and List_Task -->
<!-- It prints the name (or untitled) as a link if appropriate, -->
<!-- then the description (if appropriate), then the delete icon (if appropriate -->
<!-- e.g. <taskname> - description X -->
<!-- The font is set outside of this template -->
<xsl:template name="Output_Task_Link_Line">
  <xsl:param name="full_listing"/>
  <xsl:param name="delete"/>

<xsl:choose>
<!-- if((edit_command > 0) & (!printing)) -->
  <xsl:when test="(string-length(edit_command) &gt; 0) and (/calendar/@view != 'print')">
    <xsl:choose>
<!--  if(e_summary == 0) -->
      <xsl:when test="string-length(string(@e_Summary)) = 0">
        <A><xsl:attribute name="href"><xsl:value-of select="edit_command"/></xsl:attribute>
            <xsl:choose>
            <xsl:when test="@e_dtcompleted">
              <STRIKE>
            タイトルなしの作業<xsl:text>&nbsp;</xsl:text>
              </STRIKE>
            </xsl:when>
            <xsl:otherwise>
             タイトルなしの作業<xsl:text>&nbsp;</xsl:text>
            </xsl:otherwise>
            </xsl:choose>
        </A>
      </xsl:when>
<!-- else /* e_summary != 0 */ -->
      <xsl:otherwise>
        <A><xsl:attribute name="href"><xsl:value-of select="edit_command"/></xsl:attribute>
            <xsl:choose>
            <xsl:when test="@e_dtcompleted">
              <STRIKE>
            <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Summary"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
            </xsl:call-template>
              </STRIKE>
            </xsl:when>
            <xsl:otherwise>
             <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Summary"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
            </xsl:call-template>
            </xsl:otherwise>
            </xsl:choose>
        </A>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
<!-- else /* edit_command == 0 OR we're printing */ -->
  <xsl:otherwise>
      <xsl:choose>
      <xsl:when test="@e_dtcompleted">
        <STRIKE>
      <xsl:choose>
        <xsl:when test="string-length(string(@e_Summary)) &gt; 0">
          <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Summary"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          タイトルなしの作業
        </xsl:otherwise>
      </xsl:choose>
       </STRIKE>
       </xsl:when>
       <xsl:otherwise>
         <xsl:choose>
        <xsl:when test="string-length(string(@e_Summary)) &gt; 0">
          <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Summary"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          タイトルなしの作業
        </xsl:otherwise>
      </xsl:choose>
       </xsl:otherwise>
       </xsl:choose>
  </xsl:otherwise>
</xsl:choose>

<!-- Output of description depends on whether this is short or full listing -->
<!-- This is full listing - put out the description -->
  <xsl:if test="$full_listing='true'">
    <xsl:if test="string-length(@e_Description)&gt;0">
      <xsl:choose>
<!-- when printing, don't truncate description -->
        <xsl:when test="(/calendar/@view = 'print')">
          <xsl:value-of select="$horiz_divider"/>
          <xsl:value-of select="string(@e_Description)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$horiz_divider"/>
          <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Description"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
            </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:if>

<!-- Now decide whether to put out a "delete" icon -->
<xsl:if test="(/calendar/@view != 'print') and (string-length(@e_uid) > 0) and (@e_deleteAccessAllowed = 'true') and (string-length(delete_command) > 0)">
<xsl:if test="($delete='true') and ((string-length(/calendar/usrctx/@selectedCalendar) > 0) or ((string-length(/calendar/usrctx/@selectedGroup) > 0) and (/calendar/@viewname = 'groupview')))">
  <xsl:text>&nbsp;</xsl:text>
  <A><xsl:attribute name="href"><xsl:value-of select="delete_command"/></xsl:attribute>
    <IMG src="imx/DeleteX.gif" width="11" height="11" border="0" alt="この作業を削除" />
  </A>
</xsl:if>
</xsl:if>
</xsl:template>

<!-- This template is used by both smallList_Event and List_Event -->
<!-- It prints the name (or untitled) as a link if appropriate, -->
<!-- then the description (if appropriate), then the delete icon (if appropriate -->
<!-- e.g. <eventname> - description X -->
<!-- The font is set outside of this template -->
<xsl:template name="Output_Event_Link_Line">
  <xsl:param name="full_listing"/>
  <xsl:param name="delete"/>

  <xsl:call-template name="showGroupGlif">
    <xsl:with-param name="curevent" select="."/>
    <xsl:with-param name="editcmd" select="edit_command"/>
  </xsl:call-template>

<!--
  Different character styles (color coding) for accepted/declined/new event:  
      Different character styles are shown in all cases except when it is a group and non comparison view.
-->

  <xsl:variable name="partstat_style_start">

  </xsl:variable>

  <xsl:variable name="partstat_style_end">

  </xsl:variable>

  <xsl:choose>

<!-- We ARE EDITABLE -->
      <xsl:when test="(string-length(edit_command) &gt; 0) and (/calendar/@view != 'print')">

<!-- Now decide what to put in the anchors -->        
        <xsl:choose>
          <xsl:when test="string-length(string(@e_Summary)) &gt; 0">
          <xsl:choose>
           <xsl:when test="string(@isHTML_Summary) = 'true'">
            <xsl:call-template name="List_HTML_Field">
              <xsl:with-param name="text_line" select="HTMLSummary"/>             
              <xsl:with-param name="url_line" select="edit_command"/>
              <xsl:with-param name="is_html" select="@isHTML_Summary"/>
              <xsl:with-param name="partstat_style_start" select="$partstat_style_start"/>
              <xsl:with-param name="partstat_style_end" select="$partstat_style_end"/>
            </xsl:call-template>
           </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="List_HTML_Field">
              <xsl:with-param name="text_line" select="@e_Summary"/>
              <xsl:with-param name="url_line" select="edit_command"/>
              <xsl:with-param name="is_html" select="@isHTML_Summary"/>
              <xsl:with-param name="partstat_style_start" select="$partstat_style_start"/>
              <xsl:with-param name="partstat_style_end" select="$partstat_style_end"/>
            </xsl:call-template>
           </xsl:otherwise>
          </xsl:choose>
          </xsl:when>

          <xsl:otherwise>
            <A>
              <xsl:attribute name="href"><xsl:value-of select="edit_command"/></xsl:attribute>
              <xsl:value-of select="$partstat_style_start"/>
              タイトルなしの予定
              <xsl:value-of select="$partstat_style_end"/>
            </A><xsl:text>&nbsp;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>

<!-- Not editable events: We'll just print information because we don't want anchors -->
      <xsl:otherwise>
        <xsl:value-of select="$partstat_style_start"/>
        <xsl:choose>
          <xsl:when test="string-length(string(@e_Summary)) &gt; 0">
          <xsl:choose>
           <xsl:when test="string(@isHTML_Summary) = 'true'">
            <xsl:value-of select="HTMLSummary" disable-output-escaping="yes"/>
           </xsl:when>
           <xsl:otherwise>
            <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Summary"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
            </xsl:call-template>
           </xsl:otherwise>
          </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            タイトルなしの予定
          </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="$partstat_style_end"/>
      </xsl:otherwise>
  </xsl:choose>

<!-- Output of description depends on whether this is short or full listing -->
  <xsl:choose>
<!-- This is s full listing - put out the description -->
  <xsl:when test="$full_listing='true'">
    <xsl:if test="string-length(@e_Description)&gt;0">
      <xsl:choose>

        <xsl:when test="string(@isHTML_Description) = 'true'">
          <xsl:value-of select="HTMLDescription" disable-output-escaping="yes"/>
        </xsl:when>

<!-- when printing, don't truncate description -->
        <xsl:when test="(/calendar/@view = 'print')">
          <xsl:value-of select="$horiz_divider"/>
          <xsl:value-of select="string(@e_Description)"/>
        </xsl:when>

        <xsl:otherwise>
          <xsl:value-of select="$horiz_divider"/>
          <xsl:call-template name="truncatestring">
              <xsl:with-param name="thestring" select="@e_Description"/>
              <xsl:with-param name="thelength">60</xsl:with-param>
            </xsl:call-template>
        </xsl:otherwise>

      </xsl:choose>
    </xsl:if>
  </xsl:when>
<!-- SHORT listing only output if htmlDescription AND no summary -->
  <xsl:otherwise>
    <xsl:if test="(string-length(string(@e_Summary)) = 0) and (string(@isHTML_Description) = 'true')">
      <xsl:value-of select="HTMLDescription" disable-output-escaping="yes"/>
    </xsl:if>
  </xsl:otherwise>
  </xsl:choose>

<!-- Now print out the delete icon if appropriate -->

    <xsl:if test="($delete='true') and (/calendar/@view != 'print') and (string-length(@e_uid) > 0) and (@e_deleteAccessAllowed = 'true') and (string-length(delete_command) > 0)">
     <xsl:if test="((string-length(/calendar/usrctx/@selectedCalendar) > 0) or ((string-length(/calendar/usrctx/@selectedGroup) > 0) and (/calendar/@viewname = 'groupview')))">
     <xsl:text>&nbsp;</xsl:text>
     <A><xsl:attribute name="href"><xsl:value-of select="delete_command"/></xsl:attribute>
       <IMG src="imx/DeleteX.gif" width="11" height="11" border="0" alt="この予定を削除" />
     </A>
    </xsl:if>
    </xsl:if>
  
</xsl:template>

<!-- This needs to live here because it's used by both overview and printview -->
<!-- it would be nice to remove this dependency from printview -->
<xsl:template name="weekaheadTemplate">
    <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
      <TR>
        <TD bgcolor="{$bgcolor_table_border}">
        <TABLE cellpadding="2" cellspacing="1" width="100%">
        <xsl:choose>
        <xsl:when test="/calendar/@view = 'print'">
           <xsl:attribute name="border">2</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
           <xsl:attribute name="border">0</xsl:attribute>
        </xsl:otherwise>
        </xsl:choose>
          <TR>
            <TD colspan="6" width="17%" nowrap="" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_3}" color="#FFFFFF"><B>
            今後 1 週間</B></FONT></TD>
          </TR>
    <TR>
    <xsl:for-each select="day">
      <TD width="17%" nowrap="" bgcolor="{$bgcolor_table_mid}">
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
              <xsl:call-template name="date_short">
                  <xsl:with-param name="dateA" select="timectx/StartTime"/>
                  </xsl:call-template>
            </FONT>
        </TD>
    </xsl:for-each>
    </TR>

    <TR height="100">
    <xsl:for-each select="day">
     <TD valign="bottom" height="100%" bgcolor="{$bgcolor_table_cell}" width="17%"><TABLE border="0" cellpadding="1" cellspacing="0" width="100%" height="100%">
     <tr><td height="90%" valign="top">
<!-- Much the same as componentlist, but for a minor view -->
     <xsl:for-each select="componentlist">
       <xsl:choose>
         <xsl:when test="not(./ComponentGroup)"><xsl:text>&nbsp;</xsl:text></xsl:when>
         <xsl:otherwise>
<!-- For Each ComponentGroup on this canvas, list appropriately -->
           <xsl:for-each select="./ComponentGroup">
             <xsl:call-template name="limitedComponentGroup"/>
           </xsl:for-each>
         </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
<!--        <xsl:apply-templates select="componentlist"/> -->
      </td></tr> 
      <tr><td height="10%">
         <xsl:attribute name="valign">bottom</xsl:attribute>
         <xsl:attribute name="bgcolor">
           <xsl:value-of select="$bgcolor_table_cell"/>
         </xsl:attribute>
       <xsl:if test="($username != 'anonymous') and ($view != 'print')">
<!-- This is complicated. We need to insert in two things to the -->
<!-- command string. The date needs to get pulled from CurrTime -->
<!-- and we need to put "roundtime" in the 'extraargs' slot -->
<!-- which will tell the server to round up when using the time -->

         <A>

          <xsl:attribute name="href">
            <xsl:value-of select="substring-before((componentlist/command[1]),'fillindate')"/>
            <xsl:value-of select="timectx/CurrTime/@iso"/>
            <xsl:value-of select="substring-before(substring-after((componentlist/command[1]),'fillindate'), 'extraargs')"/>
            <xsl:if test="(string-length(/calendar/usrctx/@selectedGroup) > 0) and (string-length(/calendar/usrctx/@selectedCalendar) = 0)">
              <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="$username"/>
            </xsl:if>
            <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
            <xsl:text>roundtime=1</xsl:text>
            <xsl:value-of select="substring-after((componentlist/command[1]),'extraargs')"/>
          </xsl:attribute>

         <IMG src="imx/new.gif" width="16" height="16" border="0" alt="新しいアポイントのスケジュール設定"/>
         </A>
       </xsl:if>
      </td></tr></TABLE>
    </TD>
    </xsl:for-each>
    </TR>
    </TABLE></TD>
    </TR>
    </TABLE>
</xsl:template>


</xsl:stylesheet>
