<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Sans titre
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Dimanche</xsl:if>
  <xsl:if test=".='2'">Lundi</xsl:if>
  <xsl:if test=".='3'">Mardi</xsl:if>
  <xsl:if test=".='4'">Mercredi</xsl:if>
  <xsl:if test=".='5'">Jeudi</xsl:if>
  <xsl:if test=".='6'">Vendredi</xsl:if>
  <xsl:if test=".='7'">Samedi</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">D</xsl:if>
  <xsl:if test="$downum='2'">L</xsl:if>
  <xsl:if test="$downum='3'">M</xsl:if>
  <xsl:if test="$downum='4'">M</xsl:if>
  <xsl:if test="$downum='5'">M</xsl:if>
  <xsl:if test="$downum='6'">V</xsl:if>
  <xsl:if test="$downum='7'">D</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">janv</xsl:if>
  <xsl:if test=".='02'">Fév</xsl:if>
  <xsl:if test=".='03'">Mars</xsl:if>
  <xsl:if test=".='04'">Avril</xsl:if>
  <xsl:if test=".='05'">Mai</xsl:if>
  <xsl:if test=".='06'">Juin</xsl:if>
  <xsl:if test=".='07'">Juillet</xsl:if>
  <xsl:if test=".='08'">août</xsl:if>
  <xsl:if test=".='09'">sept</xsl:if>
  <xsl:if test=".='10'">oct</xsl:if>
  <xsl:if test=".='11'">nov</xsl:if>
  <xsl:if test=".='12'">déc</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">janv</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Fév</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">mars</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">avr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">juin</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">juil</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">août</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">sept</xsl:if>
  <xsl:if test="$MonthNum=10">oct</xsl:if>
  <xsl:if test="$MonthNum=11">nov</xsl:if>
  <xsl:if test="$MonthNum=12">déc</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Janvier</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Février</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mars</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Avril</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juin</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juillet</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Août</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Septembre</xsl:if>
  <xsl:if test="$MonthNum=10">Octobre</xsl:if>
  <xsl:if test="$MonthNum=11">Novembre</xsl:if>
  <xsl:if test="$MonthNum=12">Décembre</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      La date et l'heure indiquées ne sont pas valides. Veuillez les modifier.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Il existe déjà un agenda portant ce nom. Choisissez-en un autre.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Il existe déjà un groupe portant ce nom. Choisissez-en un autre.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> jusqu\'au </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Cette recherche a généré un problème au niveau du serveur d'annuaires.&nbsp;      Indiquez une autre chaîne de recherche.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      Impossible d'établir la connexion au serveur d'annuaires.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      Impossible d'établir la connexion au serveur d'annuaires.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Cette recherche a généré un problème au niveau du serveur d'annuaires.&nbsp;      Indiquez une autre chaîne de recherche.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      Erreur GSE : l'événement a été supprimé.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      Erreur GSE : implémentation non prise en charge
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      Erreur GSE : échec de malloc
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      Erreur GSE : impossible de créer plusieurs instances de GSE.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      Erreur GSE : entrée GSE non valide
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      Erreur GSE : événement non valide
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      Erreur GSE : interface de transport introuvable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      Erreur GSE : participant introuvable dans l'agenda organisateur
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      Erreur GSE : impossible de créer une ressource telle que lock, GDisp, etc.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      Erreur GSE : utilisateur iCS attendu, utilisateur SMTP obtenu
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      Erreur GSE : méthode et état de composant non valides
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      Erreur GSE : heure de demande en conflit avec une autre demande de réunion existante
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      Erreur DB : composant introuvable
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      Erreur DB : erreur d\'E/S
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      Erreur DB : l\'événement comporte une ou plusieurs valeurs non valides
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      Erreur DB : l\'appel de fonction ne fonctionne pas sur le composant fourni
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      Erreur DB : requête demandée inconnue ou non prise en charge
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      Erreur de base de données : un paramètre requis est NULL, non défini ou absent.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      Erreur DB : écriture annulée car la vérification de numéro de séquence demandée a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      Erreur DB : écriture annulée car la vérification de condition horaire demandée a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      Erreur de base de données : l'écriture a été abandonnée, car l'agenda ne permet pas le chevauchement de rendez-vous.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      Erreur de base de données : l'avertissement ENS a renvoyé une erreur.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      Erreur DB : une valeur requise est nulle
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Erreur invité : argument incorrect
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Erreur invité : agenda introuvable
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Erreur invité : agenda désactivé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Erreur invité : utilisateur non autorisé à accéder à l\'agenda
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Erreur invité : groupe coupé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Erreur invité : suppression de l\'organisateur impossible
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Erreur d'agenda : la création de l'agenda a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Erreur d'agenda : agenda existant avec même identificateur
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Erreur d'agenda : l'utilisateur ne dispose pas des privilèges d'accès requis      pour effectuer cette opération.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Erreur d'agenda : l'utilisateur essaie d'accéder à un agenda qui n'existe pas.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Erreur d'agenda : identificateur d'agenda non autorisé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Erreur invité : impossible de réserver deux fois l'invité.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Erreur d'agenda : l'utilisateur ne dispose pas des privilèges d'accès requis      pour effectuer cette opération.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Erreur d'agenda : l'utilisateur doit être propriétaire ou copropriétaire      pour réaliser cette opération.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Erreur d'agenda : la base de données est en mode lecture seule.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Consultez l'onglet de disponibilité pour trouver du temps libre.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Erreur de groupe : identificateur de groupe non autorisé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Erreur d'agenda : impossible d'ajouter un utilisateur inconnu à la liste de confidentialité ou des propriétaires.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      Erreur SMTP : aucun hôte de messagerie
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      Erreur SMTP : échec de la connexion
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      Erreur SMTP : la réponse attendue pour la connexion n'a pas été obtenue.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      Erreur SMTP : problème lors de l'adressage du message
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      Erreur SMTP : aucun destinataire
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Erreur : échec de la connexion à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Erreur : nombre maximum de connexions à la base de données de système central atteint.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Erreur : impossible de résoudre l'agenda.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Erreur : données incorrectes. Impossible d'accéder à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Erreur : contexte d'hôte DWP non disponible.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Erreur : impossible de résoudre l'hôte de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Erreur : aucune donnée. Impossible d'accéder à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Erreur : échec de la connexion à la base de données de système central.
    </xsl:when>
    <xsl:otherwise>
      Inconnu erreur #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Erreur : une instance de récurrence ne doit pas en ignorer une autre.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Erreur : deux instances de récurrence ne doivent pas survenir le même jour.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Erreur : impossible de modifier la confidentialité d'une seule instance.
    </xsl:when>
    <xsl:otherwise>
      Erreur de récurrence inconnue #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">Amérique/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">Amérique/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">Amérique/Los_Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">Amérique/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">Amérique/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">Amérique/Costa_Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">Amérique/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">Amérique/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">Amérique/New_York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">Amérique/La_Havane</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">Amérique/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">Amérique/Grand_Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">Amérique/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">Amérique/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">Amérique/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">Amérique/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantique/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">Amérique/St_Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">Amérique/Buenos_Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">Amérique/Sao_Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">Amérique/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">Amérique/Nuuk</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantique/Géorgie_du_Sud</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantique/Cap_Vert</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantique/Açores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Afrique/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europe/Londres</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Afrique/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europe/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Afrique/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europe/Varsovie</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Afrique/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europe/Bucarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europe/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Afrique/Le_Caire</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europe/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Afrique/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europe/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europe/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europe/Moscou</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europe/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asie/Beyrouth</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asie/Jérusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asie/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asie/Riyad</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asie/Téhéran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asie/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asie/Aktaou</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asie/Bakou</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asie/Kaboul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asie/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asie/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asie/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asie/Iekaterinbourg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asie/Calcutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asie/Katmandou</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asie/Dacca</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asie/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asie/Novossibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asie/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asie/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asie/Krasnoïarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asie/Oulan_Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asie/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asie/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asie/Irkoutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asie/Tokyo</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asie/Séoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asie/Iakoutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australie/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australie/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australie/Adélaïde</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australie/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australie/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australie/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asie/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australie/Lord_Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacifique/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacifique/Nouméa</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asie/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacifique/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacifique/Fidji</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacifique/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asie/Kamtchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacifique/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacifique/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asie/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacifique/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacifique/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacifique/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacifique/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacifique/Marquises</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacifique/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacifique/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacifique/Pâques</xsl:when> 
    <xsl:otherwise>
      Inconnu Fuseau horaire #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">OK</xsl:variable>

<xsl:variable name="cancel_title">Annuler</xsl:variable>
<xsl:variable name="close_title">Fermer</xsl:variable>
<xsl:variable name="help_title">Aide</xsl:variable>
<xsl:variable name="apply_title">Appliquer</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">Aucun événement ou tâche</xsl:variable>
<xsl:variable name="week_ahead_title">La semaine à venir</xsl:variable>
<xsl:variable name="alt_text_schedule">Planifier un nouveau rendez-vous</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">Entrez un nom d'utilisateur ci-dessous ; cliquez sur le bouton OK.</xsl:variable>

<xsl:variable name="user_name_title">Nom d\'utilisateur</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">Passer au jour précédent</xsl:variable>

<xsl:variable name="alt_jump_next_day">Passer au jour suivant</xsl:variable>

<xsl:variable name="alt_jump_new_date">Atteindre une nouvelle date</xsl:variable>

<xsl:variable name="available_title">Disponible</xsl:variable>

<xsl:variable name="busy_title">Occupé</xsl:variable>

<xsl:variable name="hour_text">heure</xsl:variable>
<xsl:variable name="minutes_text">minutes</xsl:variable>

<xsl:variable name="show_availability_title">Afficher disponibilité</xsl:variable>

<xsl:variable name="error_cal_privacy">Vous ne pouvez pas consulter cet agenda. Soit il est privé, soit il n'existe pas.</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">Amérique du Nord/du Sud</xsl:variable>

<xsl:variable name="europe_africa_title">Europe/Afrique</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">Asie/Côte du Pacifique</xsl:variable>

<xsl:variable name="time_zone_title">Fuseau horaire</xsl:variable>

<xsl:variable name="gmt_offset_title">Décalage GMT</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">Groupes</xsl:variable>

<xsl:variable name="groups_msg">Utilisez un groupe d'agendas pour consulter plusieurs agendas simultanément. Pour afficher un groupe d'agendas, cliquez sur le lien portant le nom du groupe. Pour ajouter ou supprimer des agendas, cliquez sur le lien Modifier.</xsl:variable>

<xsl:variable name="select_title">Sélectionner</xsl:variable>

<xsl:variable name="group_title">Groupe</xsl:variable>

<xsl:variable name="group_colon_title">Groupe :</xsl:variable>

<xsl:variable name="description_title">Description</xsl:variable>

<xsl:variable name="properties_title">Propriétés</xsl:variable>

<xsl:variable name="error_cal_access">Vous n\'êtes pas autorisé à accéder à l\'agenda.</xsl:variable>

<xsl:variable name="error_cal_not_exist">Cet agenda n\'existe pas.</xsl:variable>

<xsl:variable name="edit_title">Modifier</xsl:variable>
<xsl:variable name="edit_calendar_title">Modification d\'agenda</xsl:variable>

<xsl:variable name="remove_selected_title">Supprimer la sélection</xsl:variable>

<xsl:variable name="calendars_title">Agendas</xsl:variable>

<xsl:variable name="calendars_msg">Liste des agendas qui vous appartiennent ou auxquels vous êtes abonné. Pour consulter un agenda, cliquez sur son nom. Pour le modifier, cliquez sur Modifier.</xsl:variable>

<xsl:variable name="calendar_title">Agenda</xsl:variable>

<xsl:variable name="view_title">Afficher</xsl:variable>
<xsl:variable name="view_calendar_title">Affichage de l\'agenda</xsl:variable>

<xsl:variable name="view_colon_title">Vue :</xsl:variable>

<xsl:variable name="options_title">Options</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">Modification du fuseau horaire par défaut : Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">aperçu</xsl:variable>

<xsl:variable name="day_tab_title">jour</xsl:variable>

<xsl:variable name="week_tab_title">semaine</xsl:variable>

<xsl:variable name="month_tab_title">mois</xsl:variable>

<xsl:variable name="year_tab_title">année</xsl:variable>

<xsl:variable name="comparison_tab_title">comparaison</xsl:variable>

<xsl:variable name="repeat_title">Répétition</xsl:variable>

<xsl:variable name="change_repeat_title">Modifier le schéma de répétition</xsl:variable>

<xsl:variable name="alt_jump_prev_month">Passer au mois précédent</xsl:variable>

<xsl:variable name="alt_jump_next_month">Passer au mois suivant</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">Nous sommes le : </xsl:variable>

<xsl:variable name="alt_jump_this_date">Atteindre cette date</xsl:variable>

<xsl:variable name="action_items_title">À faire</xsl:variable>

<xsl:variable name="invitations_title">Invitations</xsl:variable>

<xsl:variable name="no_invitations_msg">Aucune invitation</xsl:variable>

<xsl:variable name="tasks_title">Tâches</xsl:variable>

<xsl:variable name="overdue_msg">en retard</xsl:variable>

<xsl:variable name="no_tasks_msg">Aucune tâche</xsl:variable>

<xsl:variable name="errors_title">Erreurs</xsl:variable>

<xsl:variable name="no_errors_msg">Aucune erreur</xsl:variable>

<xsl:variable name="daily_title">Quotidienne</xsl:variable>

<xsl:variable name="weekly_title">Hebdomadaire</xsl:variable>

<xsl:variable name="monthly_title">Mensuelle</xsl:variable>

<xsl:variable name="yearly_title">Annuelle</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">Répétition de la sélection : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">Cet élément uniquement</xsl:variable>

<xsl:variable name="this_and_future_title">Cet élément et les futurs</xsl:variable>

<xsl:variable name="all_instances_title">Toutes les instances</xsl:variable>

<xsl:variable name="repeating_selection_title">Sélection récurrente</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">Échéance aujourd'hui</xsl:variable>

<xsl:variable name="other_tasks_title">Autres tâches</xsl:variable>

<xsl:variable name="overdue_tasks_title">Tâches en retard</xsl:variable>

<xsl:variable name="all_day_events_title">Événements d\'une journée complète</xsl:variable>

<xsl:variable name="conflict_msg">conflit</xsl:variable>

<xsl:variable name="overdue_title">En retard</xsl:variable>

<xsl:variable name="due_at_title">Échéance :</xsl:variable>

<xsl:variable name="untitled_task_title">Tâche sans titre</xsl:variable>

<xsl:variable name="alt_view_this_task">Afficher cette tâche</xsl:variable>

<xsl:variable name="alt_delete_this_task">Supprimer cette tâche</xsl:variable>

<xsl:variable name="untitled_event_title">Événement sans titre</xsl:variable>

<xsl:variable name="alt_delete_this_event">Supprimer l'événement</xsl:variable>

<xsl:variable name="alt_view_this_event">Afficher l'évément</xsl:variable>

<xsl:variable name="all_day_title">Toute la journée</xsl:variable>

<xsl:variable name="overdue_from_title">En retard depuis</xsl:variable>

<xsl:variable name="from_txt">depuis le</xsl:variable>

<xsl:variable name="due_on_title">Échéance :</xsl:variable>

<xsl:variable name="not_due_title">Non échu(e)</xsl:variable>

<xsl:variable name="due_title">Échéance</xsl:variable>

<xsl:variable name="on_txt">res</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">am</xsl:variable>

<xsl:variable name="pm_txt">pm</xsl:variable>

<xsl:variable name="midnight_title">Minuit</xsl:variable>

<xsl:variable name="noon_title">Midi</xsl:variable>

<xsl:variable name="from_title">De</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">Planifier un nouveau rendez-vous</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">Liste d'erreurs : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">Ce volet présente la liste des erreurs de planification en suspens.</xsl:variable>

<xsl:variable name="organizer_title">Organisateur</xsl:variable>

<xsl:variable name="attendee_title">Participant</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">Aucune erreur en suspens</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">Récurrence : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">Récurrence</xsl:variable>

<xsl:variable name="start_title">Démarrer</xsl:variable>

<xsl:variable name="end_title">Fin</xsl:variable>

<xsl:variable name="create_title">Créer</xsl:variable>

<xsl:variable name="events_text">événement(s)</xsl:variable>

<xsl:variable name="alert_provide_valid_count">Veuillez entrer un nombre valide</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">Veuillez fournir un nombre inférieur ou égal à</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">L\'heure du rappel de cet événement est postérieure à celle du début de l\'événement. Cliquez sur Annuler pour revenir en arrière et modifier l\'heure.</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">L\'heure du rappel de cette tâche est postérieure à celle du début de la tâche. Cliquez sur Annuler pour revenir en arrière et modifier l\'heure.</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">Rédiger</xsl:variable>

<xsl:variable name="reminders_title">Rappels</xsl:variable>

<xsl:variable name="availability_title">Disponibilité</xsl:variable>

<xsl:variable name="preview_title">Aperçu</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">Liste des invitations : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">Supprimer</xsl:variable>

<xsl:variable name="recurring_event_msg">Événement récurrent</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">Aucune invitation en attente</xsl:variable>

<xsl:variable name="all_title">Toutes les</xsl:variable>

<xsl:variable name="delete_all_title">Supprimer tout</xsl:variable>

<xsl:variable name="save_and_close_title">Enregistrer et fermer</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">Un champ obligatoire n\'a pas été renseigné</xsl:variable>

<xsl:variable name="alert_min_year">Vous ne pouvez pas consulter une année antérieure à 1970.</xsl:variable>
<xsl:variable name="alert_max_year">Vous ne pouvez pas consulter une année postérieure à 2036.</xsl:variable>

<xsl:variable name="alert_invalid_date">Date non valide. Veuillez la modifier.</xsl:variable>

<xsl:variable name="january_title">Janvier</xsl:variable>
<xsl:variable name="february_title">Février</xsl:variable>
<xsl:variable name="march_title">Mars</xsl:variable>
<xsl:variable name="april_title">Avril</xsl:variable>
<xsl:variable name="may_title">Mai</xsl:variable>
<xsl:variable name="june_title">Juin</xsl:variable>
<xsl:variable name="july_title">Juillet</xsl:variable>
<xsl:variable name="august_title">Août</xsl:variable>
<xsl:variable name="september_title">Septembre</xsl:variable>
<xsl:variable name="october_title">Octobre </xsl:variable>
<xsl:variable name="november_title">Novembre</xsl:variable>
<xsl:variable name="december_title">Décembre</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">Indiquez une date valide pour</xsl:variable>

<xsl:variable name="provide_good_date_msg">Indiquez une date valide.</xsl:variable>

<xsl:variable name="provide_good_month_msg">Indiquez un mois entre 1 et 12</xsl:variable>

<xsl:variable name="provide_good_year_msg">Indiquez une année valide.\n\nSi vous n\'entrez que deux chiffres, les valeurs inférieures à 37\ndésigneront des années du 21e siècle.\n\nPar exemple : 03 représente l\'année 2003.</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">Indiquez une année postérieure à 1970.</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">Indiquez une année antérieure à 2037.</xsl:variable>

<xsl:variable name="provide_good_hour_msg">Spécifiez une valeur horaire valide. (1-12) en format 12 heures ou (0-23) en format 24 heures</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">Indiquez une heure dans un format valide (0-23).</xsl:variable>

<xsl:variable name="provide_good_minute_msg">Indiquez une valeur représentant les minutes comprise en 0 et 59.</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">Choisissez une date de fin située après la date de début.</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">La date entrée n\'existe pas.\nConfiguration de l\'agenda en fonction de la date valide la plus proche dans</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">Atteindre la date : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">Passer à l\'année précédente</xsl:variable>

<xsl:variable name="alt_jump_next_year">Passer à l\'année suivante</xsl:variable>

<xsl:variable name="jump_to_date_title">Passer à une date</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">Êtes-vous sûr de vouloir supprimer cette entrée de confidentialité ?</xsl:variable>

<xsl:variable name="edit_calendar_page_title">Modifier l'agenda : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">Indique les informations requises.</xsl:variable>

<xsl:variable name="calendar_name_msg">Indiquez un nom court pour l'agenda, par exemple "football". (Les espaces ne sont pas autorisés.)</xsl:variable>

<xsl:variable name="display_name_title">Nom descriptif</xsl:variable>

<xsl:variable name="display_name_msg">Ceci est un champ facultatif pour donner à l'agenda un nom comme "Entraînement foot de Lionel".</xsl:variable>

<xsl:variable name="include_in_availability_msg">Inclure cet agenda lors de l'estimation de votre disponibilité</xsl:variable>

<xsl:variable name="calendar_address_title">Adresse de l'agenda</xsl:variable>

<xsl:variable name="calendar_address_msg">Vous pouvez accorder des autorisations d'accès à l'agenda à d'autres utilisateurs en leur fournissant le lien. Ils peuvent ensuite l'utiliser dans leur navigateur pour afficher l'agenda, à condition que les options de contrôle d'accès soient configurées de manière à leur autoriser l'accès.</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">Autorisations de l'agenda :</xsl:variable>

<xsl:variable name="cal_permissions_msg">Les autorisations déterminent dans quelle mesure les autres utilisateurs peuvent consulter et modifier l'agenda. Pour accorder certaines autorisations à tous les utilisateurs, sélectionnez-les dans les colonnes en regard de Tout le monde. Pour accorder certaines autorisations à un utilisateur particulier, entrez son ID utilisateur dans le champ Utilisateur et cliquez sur "Ajouter un utilisateur". Sélectionnez ensuite les autorisations appropriées dans les colonnes en regard du nom de l'utilisateur.</xsl:variable>

<xsl:variable name="user_title">Utilisateur</xsl:variable>
<xsl:variable name="user_title_with_colon">Utilisateur :</xsl:variable>

<xsl:variable name="permissions_title">Droits</xsl:variable>

<xsl:variable name="invite_title">Inviter</xsl:variable>

<xsl:variable name="read_title">Lire</xsl:variable>

<xsl:variable name="modify_title">Modifier</xsl:variable>

<xsl:variable name="delete_selected_user_title">Supprimer l'utilisateur sélectionné</xsl:variable>

<xsl:variable name="add_user_title">Ajouter un utilisateur</xsl:variable>

<xsl:variable name="everybody_title">Tout le monde</xsl:variable>

<xsl:variable name="this_domain_title">Ce domaine</xsl:variable>

<xsl:variable name="tip_cal_owners">Conseils pour affecter des propriétaires à l'agenda :</xsl:variable>

<xsl:variable name="cal_owner_msg">Vous pouvez ajouter un ou plusieurs propriétaires de l'agenda. Un propriétaire a la possibilité de répondre aux invitations et de créer, modifier et supprimer des événements en votre nom.</xsl:variable>

<xsl:variable name="no_owners_msg">Aucun propriétaire.</xsl:variable>

<xsl:variable name="delete_owner_title">Supprimer propriétaire</xsl:variable>

<xsl:variable name="add_owner_title">Ajouter un propriétaire</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">Souhaitez-vous réellement supprimer cet agenda ?</xsl:variable>

<xsl:variable name="alert_supply_cal_name">Vous devez fournir un nom d\'agenda</xsl:variable>

<xsl:variable name="owners_title">Propriétaires</xsl:variable>

<xsl:variable name="time_zones_title">Fuseaux horaires</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">Voulez-vous vraiment supprimer cet événement ?</xsl:variable>

<xsl:variable name="edit_event_page_title">Modifier l'événement : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---Invitation rapide---</xsl:variable>

<xsl:variable name="event_title_title">Titre de l'événement</xsl:variable>

<xsl:variable name="date_title">Date</xsl:variable>

<xsl:variable name="time_title">Heure</xsl:variable>

<xsl:variable name="all_day_msg">Toute la journée (par exemple, pour un congé ou un anniversaire)</xsl:variable>

<xsl:variable name="privacy_title">Confidentialité</xsl:variable>

<xsl:variable name="public_event_title">Événement public</xsl:variable>

<xsl:variable name="confidential_event_title">Heure et date uniquement</xsl:variable>

<xsl:variable name="private_event_title">Événement privé</xsl:variable>

<xsl:variable name="location_title">Emplacement</xsl:variable>

<xsl:variable name="invite_others_msg">Inviter d'autres utilisateurs ou ressources :</xsl:variable>

<xsl:variable name="search_title">Rechercher...</xsl:variable>

<xsl:variable name="inform_title">Informer</xsl:variable>

<xsl:variable name="invite_instructions_msg">(Entrez l'ID utilisateur, l'ID agenda ou l'adresse électronique. Si vous ne connaissez pas le nom, cliquez sur Rechercher.)</xsl:variable>

<xsl:variable name="invitees_title">Invités</xsl:variable>

<xsl:variable name="no_invitees_msg">Aucun invité</xsl:variable>

<xsl:variable name="remove_title">Supprimer</xsl:variable>

<xsl:variable name="inform_event_title">Informer de l'événement</xsl:variable>

<xsl:variable name="no_informees_msg">Aucune personne à informer</xsl:variable>

<xsl:variable name="event_reminders_msg">Vous pouvez vous envoyer un message de rappel pour cet événement. Entrez une ou plusieurs de vos adresses électroniques ci-dessous. Séparez chacune d'elles par une virgule (,) ou un point-virgule (;).</xsl:variable>

<xsl:variable name="remind_title">Rappeler</xsl:variable>

<xsl:variable name="alert_provide_valid_time">Indiquez une heure valide.</xsl:variable>

<xsl:variable name="hours_text">heures</xsl:variable>

<xsl:variable name="days_text">jours</xsl:variable>

<xsl:variable name="before_the_event_begins_text">avant le début de l'événement</xsl:variable>

<xsl:variable name="at_text">à</xsl:variable>

<xsl:variable name="text_reminder_msg">Vous pouvez envoyer un message texte avec le rappel par courrier électronique.</xsl:variable>

<xsl:variable name="message_title">Message</xsl:variable>

<xsl:variable name="title_title">Titre</xsl:variable>

<xsl:variable name="attendees_title">Participants</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">Supprimer ?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">Modifier le groupe d'agendas : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---Ajout rapide---</xsl:variable>

<xsl:variable name="delete_calendar_text">Êtes-vous sûr de vouloir supprimer cet agenda ?</xsl:variable>

<xsl:variable name="group_name_title">Nom du groupe</xsl:variable>

<xsl:variable name="group_view_msg">Ouvrir le groupe en vue Journée (Par défaut, le groupe s'ouvre en vue de comparaison.)</xsl:variable>

<xsl:variable name="calendar_id_title">ID agenda</xsl:variable>

<xsl:variable name="add_title">Ajouter</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(Entrez l'ID agenda. Si vous ne le connaissez pas, cliquez sur Rechercher.)</xsl:variable>

<xsl:variable name="group_members_title">Membres du groupe</xsl:variable>

<xsl:variable name="group_description_msg">Spécifiez ici une description de votre groupe. Vous pouvez également décider si la vue Journée de ce groupe présentera chacun des agendas séparément</xsl:variable>

<xsl:variable name="day_view_title">Vue Journée</xsl:variable>

<xsl:variable name="day_view_merge_msg">Par défaut, les agendas apparaissent non fusionnés dans la vue Journée.</xsl:variable>

<xsl:variable name="alert_group_name">Vous devez fournir un nom pour le groupe</xsl:variable>

<xsl:variable name="calendar_group_title">Groupe d'agendas</xsl:variable>

<xsl:variable name="details_title">Détails</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">Êtes-vous sûr de vouloir supprimer cette tâche ?</xsl:variable>

<xsl:variable name="edit_task_page_title">Modifier une tâche : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">Composer une tâche</xsl:variable>

<xsl:variable name="task_title_title">Titre de la tâche</xsl:variable>

<xsl:variable name="due_date_title">Date d'échéance</xsl:variable>

<xsl:variable name="no_time_title">Aucune heure</xsl:variable>

<xsl:variable name="public_task_title">Tâche publique</xsl:variable>

<xsl:variable name="confidential_task_title">Heure et date uniquement</xsl:variable>

<xsl:variable name="private_task_title">Tâche privée</xsl:variable>

<xsl:variable name="status_title">État</xsl:variable>

<xsl:variable name="complete_title">Achevé</xsl:variable>

<xsl:variable name="task_reminder_msg">Vous pouvez vous envoyer un message de rappel pour cette tâche. Entrez une ou plusieurs de vos adresses électroniques ci-dessous. Séparez chacune d'elles par une virgule (,) ou un point-virgule (;).</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">Il est impossible de définir une alarme pour une tâche non échue.</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">avant que la tâche ne soit échue</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">Aspect</xsl:variable>

<xsl:variable name="settings_title">Paramètres</xsl:variable>

<xsl:variable name="import_title">Importer</xsl:variable>

<xsl:variable name="export_title">Exporter</xsl:variable>

<xsl:variable name="settings_msg">Utilisez ce formulaire pour modifier le comportement de Calendar Express.</xsl:variable>

<xsl:variable name="default_view_title">Vue par défaut</xsl:variable>

<xsl:variable name="default_view_msg">Toujours afficher la vue suivante une fois la connexion établie :</xsl:variable>

<xsl:variable name="default_group_title">Groupe d'agendas par défaut</xsl:variable>

<xsl:variable name="default_group_msg">Toujours afficher le groupe d'agendas suivant une fois la connexion établie :</xsl:variable>

<xsl:variable name="no_cal_group_title">Aucun groupe d'agendas</xsl:variable>

<xsl:variable name="date_format_msg">Indiquer les dates courtes dans l'ordre suivant :</xsl:variable>

<xsl:variable name="m_d_y_format_text">Mois Jour Année</xsl:variable>

<xsl:variable name="d_m_y_format_text">Jour, Mois, Année</xsl:variable>

<xsl:variable name="y_m_d_format_text">Année, Mois, Jour</xsl:variable>

<xsl:variable name="date_delimiter_msg">Utiliser le caractère suivant pour délimiter les dates courtes :</xsl:variable>

<xsl:variable name="use_12_clock_msg">Format 12 heures</xsl:variable>

<xsl:variable name="use_24_clock_msg">Format 24 heures</xsl:variable>

<xsl:variable name="day_title">Jour</xsl:variable>

<xsl:variable name="day_starts_msg">La journée commence à :</xsl:variable>

<xsl:variable name="day_ends_msg">La journée se termine à :</xsl:variable>

<xsl:variable name="day_interval_msg">Fractionner les jours</xsl:variable>

<xsl:variable name="every_15_minutes_text">toutes les quinze minutes</xsl:variable>

<xsl:variable name="every_half_hour_text">toutes les 30 minutes</xsl:variable>

<xsl:variable name="every_hour_text">toutes les heures</xsl:variable>

<xsl:variable name="every_2_hours_text">toutes les deux heures</xsl:variable>

<xsl:variable name="every_four_hours_text">toutes les quatre heures</xsl:variable>

<xsl:variable name="first_dow_title">Premier jour de la semaine</xsl:variable>

<xsl:variable name="sunday_title">Dimanche</xsl:variable>

<xsl:variable name="monday_title">Lundi</xsl:variable>

<xsl:variable name="tuesday_title">Mardi</xsl:variable>

<xsl:variable name="wednesday_title">Mercredi</xsl:variable>

<xsl:variable name="thursday_title">Jeudi</xsl:variable>

<xsl:variable name="friday_title">Vendredi</xsl:variable>

<xsl:variable name="saturday_title">Samedi</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">Exclure le samedi et le dimanche des vues mensuelles et hebdomadaires</xsl:variable>

<xsl:variable name="default_tz_msg">Par défaut, afficher les dates et heures avec le fuseau horaire suivant :</xsl:variable>

<xsl:variable name="none_selected_title">Aucune sélection</xsl:variable>

<xsl:variable name="single_tz_use_msg">Lors de l'affichage d'un seul agenda, utiliser son fuseau horaire</xsl:variable>

<xsl:variable name="tz_timescales_msg">Afficher une échelle de temps pour chaque fuseau horaire des agendas affichés</xsl:variable>

<xsl:variable name="event_task_reminders_title">Rappels d'événements et de tâches</xsl:variable>

<xsl:variable name="email_reminder_msg">M'envoyer un rappel par courrier électronique</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">Indiquez un intervalle de temps valide pour les rappels.</xsl:variable>

<xsl:variable name="before_every_event_task_text">avant chaque événement et chaque tâche</xsl:variable>

<xsl:variable name="note_title"><strong>Remarque</strong> :</xsl:variable>

<xsl:variable name="reminders_tip_msg">Si vous souhaitez que le rappel soit envoyé à plusieurs adresses électroniques (par exemple, abc@société22.com, abc@sesta.com), séparez chacune d'elles par une virgule (,) ou un point-virgule (;).</xsl:variable>

<xsl:variable name="event_notifications_title">Notifications d'événement</xsl:variable>

<xsl:variable name="event_notifications_msg">M'informer par courrier électronique chaque fois qu'un utilisateur planifie un événement sur mon agenda</xsl:variable>

<xsl:variable name="only_one_email_msg">Une seule adresse électronique autorisée.</xsl:variable>

<xsl:variable name="alert_only_one_email">Veuillez entrer une seule adresse pour la notification d\'événement</xsl:variable>

<xsl:variable name="declined_events_delete_title">Événements refusés</xsl:variable>

<xsl:variable name="declined_events_delete_msg">Ne pas afficher les événements refusés</xsl:variable>

<xsl:variable name="appearance_msg">Utilisez ce formulaire pour modifier l'apparence de Calendar Express.</xsl:variable>

<xsl:variable name="color_scheme_title">Schéma de couleurs</xsl:variable>

<xsl:variable name="toolbar_title">Barre d'outils</xsl:variable>

<xsl:variable name="icons_and_text_msg">Afficher les icônes et le texte</xsl:variable>

<xsl:variable name="icons_only_msg">Afficher les icônes uniquement</xsl:variable>

<xsl:variable name="text_only_msg">Afficher le texte uniquement</xsl:variable>

<xsl:variable name="display_font_title">Police d'affichage</xsl:variable>

<xsl:variable name="face_title">Type de caractères</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">Taille</xsl:variable>

<xsl:variable name="larger_title">Grande</xsl:variable>

<xsl:variable name="default_title">Par défaut</xsl:variable>

<xsl:variable name="smaller_title">Petite</xsl:variable>

<xsl:variable name="event_destination_title">Destination de l'événement</xsl:variable>

<xsl:variable name="session_expired_msg">Votre session a expiré</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">Vous devez spécifier un agenda valide</xsl:variable>

<xsl:variable name="add_events_to_text">Ajouter les événements à</xsl:variable>

<xsl:variable name="select_calendar_title">Sélectionner l'agenda :</xsl:variable>

<xsl:variable name="import_format_title">Format cible</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Format Outlook</xsl:variable>

<xsl:variable name="source_file_invalid_error">Le fichier source spécifié n\'était pas valide</xsl:variable>

<xsl:variable name="format_file_mismatch_error">Le format indiqué ne correspond pas au fichier source.</xsl:variable>

<xsl:variable name="successful_import_msg">Le fichier a été correctement importé.</xsl:variable>

<xsl:variable name="source_file_title">Fichier source</xsl:variable>

<xsl:variable name="date_range_title">Plage de dates</xsl:variable>

<xsl:variable name="import_all_msg">Importer tous les événements du fichier</xsl:variable>

<xsl:variable name="invalid_date_range_error">La plage de dates spécifiée était incorrecte</xsl:variable>

<xsl:variable name="beginning_title">Début</xsl:variable>

<xsl:variable name="ending_title">Fin</xsl:variable>

<xsl:variable name="calendars_to_export_title">Agendas à exporter</xsl:variable>

<xsl:variable name="addarrow_title">Ajouter >></xsl:variable>

<xsl:variable name="export_all_msg">Exporter tous les événements</xsl:variable>

<xsl:variable name="export_format_title">Format cible</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">L\'heure de fin de la journée doit être postérieure à l\'heure de début.</xsl:variable>

<xsl:variable name="save_changes_title">Enregistrer les modifications</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">Agenda actuel :</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">Schéma de répétition</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">Schéma de répétition non valide. Sélectionnez un jour de répétition.</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">Impossible de modifier le schéma de répétition pour une seule instance</xsl:variable>

<xsl:variable name="recurrence_skips_title">Une instance d'un événement récurrent ne peut pas en ignorer une autre.</xsl:variable>

<xsl:variable name="recurrence_same_day">Deux instances d'un événement récurrent ne peuvent pas se produire le même jour.</xsl:variable>

<xsl:variable name="recurrence_privacy">Impossible de modifier la confidentialité d'une seule instance</xsl:variable>

<xsl:variable name="every_day_title">Chaque jour</xsl:variable>

<xsl:variable name="every_weekday_title">Tous les jours de la semaine</xsl:variable>

<xsl:variable name="every_title">Tou(te)s les</xsl:variable>

<xsl:variable name="weekday_text">jour de la semaine</xsl:variable>

<xsl:variable name="weekendday_text">jour du week-end</xsl:variable>

<xsl:variable name="m_w_f_text">lundi, mercredi et vendredi</xsl:variable>

<xsl:variable name="t_th_text">mardi et jeudi</xsl:variable>

<xsl:variable name="sat_sun_text">samedi et dimanche</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">Indiquez un intervalle valide.</xsl:variable>

<xsl:variable name="every_week_title">Chaque semaine</xsl:variable>

<xsl:variable name="weeks_text">semaines</xsl:variable>

<xsl:variable name="repeat_on_title">Répétition le</xsl:variable>

<xsl:variable name="sunday_abbrev">Sun</xsl:variable>

<xsl:variable name="monday_abbrev">Lun</xsl:variable>

<xsl:variable name="tuesday_abbrev">Mar</xsl:variable>

<xsl:variable name="wednesday_abbrev">Mer</xsl:variable>

<xsl:variable name="thursday_abbrev">Jeu</xsl:variable>

<xsl:variable name="friday_abbrev">Ven</xsl:variable>

<xsl:variable name="saturday_abbrev">Sam</xsl:variable>

<xsl:variable name="every_month_title">Chaque mois</xsl:variable>

<xsl:variable name="months_text">mois</xsl:variable>

<xsl:variable name="ordinal_1">1er</xsl:variable>
<xsl:variable name="ordinal_2">2</xsl:variable>
<xsl:variable name="ordinal_3">3</xsl:variable>
<xsl:variable name="ordinal_4">4</xsl:variable>
<xsl:variable name="ordinal_5">5</xsl:variable>
<xsl:variable name="ordinal_6">6</xsl:variable>
<xsl:variable name="ordinal_7">7</xsl:variable>
<xsl:variable name="ordinal_8">8</xsl:variable>
<xsl:variable name="ordinal_9">9</xsl:variable>
<xsl:variable name="ordinal_10">10</xsl:variable>
<xsl:variable name="ordinal_11">11</xsl:variable>
<xsl:variable name="ordinal_12">12</xsl:variable>
<xsl:variable name="ordinal_13">13</xsl:variable>
<xsl:variable name="ordinal_14">14</xsl:variable>
<xsl:variable name="ordinal_15">15</xsl:variable>
<xsl:variable name="ordinal_16">16</xsl:variable>
<xsl:variable name="ordinal_17">17</xsl:variable>
<xsl:variable name="ordinal_18">18</xsl:variable>
<xsl:variable name="ordinal_19">19</xsl:variable>
<xsl:variable name="ordinal_20">20</xsl:variable>
<xsl:variable name="ordinal_21">21</xsl:variable>
<xsl:variable name="ordinal_22">22</xsl:variable>
<xsl:variable name="ordinal_23">23</xsl:variable>
<xsl:variable name="ordinal_24">24</xsl:variable>
<xsl:variable name="ordinal_25">25</xsl:variable>
<xsl:variable name="ordinal_26">26</xsl:variable>
<xsl:variable name="ordinal_27">27</xsl:variable>
<xsl:variable name="ordinal_28">28</xsl:variable>
<xsl:variable name="ordinal_29">29</xsl:variable>
<xsl:variable name="ordinal_30">30</xsl:variable>
<xsl:variable name="ordinal_31">31</xsl:variable>

<xsl:variable name="day_of_month_text">jour(s) du mois</xsl:variable>
<xsl:variable name="cap_last_text">Dernier</xsl:variable>

<xsl:variable name="of_month_text">du mois</xsl:variable>

<xsl:variable name="every_year_text">Chaque année</xsl:variable>

<xsl:variable name="years_text">ans</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">Il s'agit d'un événement répété. Souhaitez-vous supprimer toutes les occurrences ou uniquement celle-là ?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">Il s'agit d'un événement répété. Souhaitez-vous modifier toutes les occurrences ou uniquement celle-là ?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">Il s'agit d'une tâche répétée. Souhaitez-vous supprimer toutes les occurrences ou uniquement celle-là ?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">Il s'agit d'une tâche répétée. Souhaitez-vous modifier toutes les occurrences ou uniquement celle-là ?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">Résumé</xsl:variable>

<xsl:variable name="reply_title">Répondre</xsl:variable>

<xsl:variable name="will_attend_msg">Je participerai</xsl:variable>

<xsl:variable name="will_not_attend_msg">Je NE participerai PAS</xsl:variable>

<xsl:variable name="confirm_later_msg">Je confirmerai plus tard</xsl:variable>

<xsl:variable name="reply_reminders_msg">Planifiez les rappels par courrier électronique en indiquant les adresses électroniques (séparées par une virgule ou un point-virgule) et en choisissant la date et l'heure de livraison du message.</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">Vous ne pouvez pas définir une alarme pour un événement non confirmé avant le début de l\'événement</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">Utilisez le champ suivant pour indiquer des informations supplémentaires  dans le rappel. Le titre, la date, l'heure et l'emplacement de l'événement sont automatiquement indiqués dans tous les messages de rappel.</xsl:variable>

<xsl:variable name="cal_select_msg">Sélectionnez l'agenda dans lequel placer l'événement.</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">Recherche d'agendas : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">Recherche d'agendas</xsl:variable>

<xsl:variable name="cal_search_msg1">Rechercher les agendas dans lesquels un agenda</xsl:variable>
        
<xsl:variable name="name_or_id_text">nom ou ID</xsl:variable>

<xsl:variable name="name_text">nom</xsl:variable>

<xsl:variable name="primary_owner_text">propriétaire principal</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">contient</xsl:variable>

<xsl:variable name="begins_with_text">commence par</xsl:variable>

<xsl:variable name="search_plain_title">Rechercher</xsl:variable>

<xsl:variable name="already_selected_cals_title">Agendas déjà sélectionnés</xsl:variable>

<xsl:variable name="cal_id_title">ID agenda</xsl:variable>

<xsl:variable name="search_results_title">Résultats de la recherche</xsl:variable>

<xsl:variable name="no_match_found_msg">La recherche n'a donné aucun résultat</xsl:variable>

<xsl:variable name="owner_title">Propriétaire</xsl:variable>

<xsl:variable name="owner_name_colon_title">Nom du propriétaire :</xsl:variable>

<xsl:variable name="cal_name_title">Nom de l'agenda</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">Rechercher : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">Rechercher les événements et les tâches qui contiennent</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">Rechercher un utilisateur : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">Rechercher un utilisateur</xsl:variable>

<xsl:variable name="search_local_msg">Rechercher dans un répertoire local</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(Entrez le prénom, le nom ou l'ID utilisateur.)</xsl:variable>

<xsl:variable name="legend_title">Légende :</xsl:variable>

<xsl:variable name="resource_title">Ressource ;</xsl:variable>

<xsl:variable name="already_selected_users_title">Utilisateurs déjà sélectionnés</xsl:variable>

<xsl:variable name="name_userid_title">Nom (ID utilisateur)</xsl:variable>

<xsl:variable name="name_title">Nom</xsl:variable>

<xsl:variable name="userid_title">ID utilisateur</xsl:variable>

<xsl:variable name="email_title">E-mail</xsl:variable>

<xsl:variable name="for_text">de</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">Liste des tâches : Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">Utilisez ce volet pour suivre toutes les tâches à effectuer. Vous pouvez marquer les tâches terminées en cliquant sur les cases à cocher de la colonne "Terminé". Cliquez sur "Enregistrer et fermer" pour valider les modifications.</xsl:variable>

<xsl:variable name="done_title">Terminé</xsl:variable>

<xsl:variable name="task_title">Tâche</xsl:variable>

<xsl:variable name="select_all_title">Tout sélectionner</xsl:variable>

<xsl:variable name="alert_processing">Traitement en cours</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">tâches</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">Aide</xsl:variable>

<xsl:variable name="logout_text">Déconnexion</xsl:variable>

<xsl:variable name="login_text">connexion</xsl:variable>

<xsl:variable name="home_text">Accueil</xsl:variable>

<xsl:variable name="alt_schedule_msg">Planifier une réunion, un anniversaire ou un autre événement</xsl:variable>

<xsl:variable name="new_event_title">Nouvel événement</xsl:variable>

<xsl:variable name="alt_todo_msg">Ajouter un élément à votre liste des tâches</xsl:variable>

<xsl:variable name="new_task_title">Nouvelle tâche</xsl:variable>

<xsl:variable name="jump_to_title">Passer à</xsl:variable>

<xsl:variable name="alt_print_msg">Ouvrir une version de la vue actuelle adaptée à l'impression</xsl:variable>

<xsl:variable name="printable_title">Imprimable</xsl:variable>

<xsl:variable name="alt_search_msg">Rechercher des événements et des tâches</xsl:variable>

<xsl:variable name="alt_new_calendar">Créer un agenda</xsl:variable>

<xsl:variable name="new_cal_title">Nouvel agenda</xsl:variable>

<xsl:variable name="alt_new_group">Créer un groupe d'agendas</xsl:variable>

<xsl:variable name="new_group_title">Nouveau groupe</xsl:variable>

<xsl:variable name="alt_search_cals">Rechercher des agendas</xsl:variable>

<xsl:variable name="subscribe_title">S'inscrire</xsl:variable>

<xsl:variable name="paren_subscribed_title">(Abonné)</xsl:variable>

<xsl:variable name="alt_jump_next_week">Passer à la semaine suivante</xsl:variable>

<xsl:variable name="alt_jump_prev_week">Passer à la semaine précédente</xsl:variable>

<xsl:variable name="sunday_letter_title">D</xsl:variable>
<xsl:variable name="monday_letter_title">L</xsl:variable>
<xsl:variable name="tuesday_letter_title">M</xsl:variable>
<xsl:variable name="wednesday_letter_title">M</xsl:variable>
<xsl:variable name="thursday_letter_title">M</xsl:variable>
<xsl:variable name="friday_letter_title">V</xsl:variable>
<xsl:variable name="saturday_letter_title">D</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">Les événements sélectionnés seront supprimés de l'agenda. Quant aux événements récurrents, seules les instances comportant des erreurs seront supprimées.  Cliquez sur OK pour continuer.</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">Lors de la création d'un événement pendant l'affichage d'un groupe d'agendas, envoyez une invitation pour tous les agendas du groupe.</xsl:variable>

<xsl:variable name="invite_this_group_msg">Lors de la création d\'un événement pendant l\'affichage de ce groupe d\'agendas, envoyez une invitation pour tous les agendas du groupe.</xsl:variable>

<xsl:variable name="group_invitations_title">Invitations de groupe</xsl:variable>

<xsl:variable name="starting_at_txt">Début à</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">inconnu</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">Aucun participant</xsl:variable>

<xsl:variable name="today_title">Aujourd'hui</xsl:variable>

<xsl:variable name="confirm_event_delete_text">Souhaitez-vous supprimer cet événement ?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">Souhaitez-vous supprimer cette tâche ?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">Échec de la connexion à la base de données de système central.</xsl:variable>
<xsl:variable name="dwp_max_connections_error">Nombre maximum de connexions à la base de données de système central atteint.</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">Données incorrectes. Impossible d'accéder à la base de données de système central.</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">Impossible de résoudre l'agenda.</xsl:variable>
<xsl:variable name="dwp_down_error">est défaillant</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">Contexte d'hôte DWP non disponible.</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">L'hôte de système central ne peut pas être résolu.</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">Aucune donnée : base de données de système central inaccessible.</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">Inclure cet événement dans le calcul de la disponibilité</xsl:variable>
<xsl:variable name="freebusy_title">Libre/Occupé</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">Vous créez un événement quotidien qui sera utilisé dans le calcul de votre disponibilité. Si cela ne vous convient pas, cliquez sur Annuler pour revenir en arrière et désactivez la case Libre/occupé.</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">Vous créez un événement privé qui sera utilisé dans le calcul de votre disponibilité. Si cela ne vous convient pas, cliquez sur Annuler pour revenir en arrière et désactivez la case Libre/occupé.</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">La base de données de l'agenda est en mode lecture seule.</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Aucune date de fin </xsl:variable>
<xsl:variable name="cap_the_text">Le </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Supprimer</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Bienvenue  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tâches de </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>,agenda personnel (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Début à </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 heure</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutes</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Plus de 1 heure</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> disponible)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Crée un maximum de </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instances</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Un ou plusieurs fuseaux horaires d\'une région peuvent être associés à l\'agenda actuel. Dans les vues en grille, comme la vue Journée, tous les fuseaux horaires associés à l\'agenda deviennent partie intégrante de l\'échelle de temps de la vue. Si aucun fuseau horaire n\'est spécifié avec cet agenda, le fuseau horaire par défaut est utilisé. Les fuseaux horaires suivants sont disponibles en </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Un fuseau horaire de n'importe quelle région peut être associé à l'agenda actuel. Dans les vues en grille, comme la vue Journée, le fuseau horaire associé à l'agenda devient partie intégrante de l'échelle de temps de la vue. Si aucun fuseau horaire n'est spécifié avec cet agenda, le fuseau horaire par défaut est utilisé. Les fuseaux horaires suivants sont disponibles en </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>Amérique du Nord/du Sud </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europe/Afrique </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asie/Côte du Pacifique </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>région :</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>L'événement suivant a été ajouté dans votre agenda par "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Vous pouvez accepter ou refuser cette invitation en sélectionnant l'option appropriée ci-dessous.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Cliquer</xsl:text>&nbsp;
  <B><xsl:text>Parcourir...</xsl:text></B>&nbsp;
  <xsl:text>pour sélectionner un fichier.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Utilisez ce volet pour accepter </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> ou refuser </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> ou laisser sans réponse </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> les invitations aux événements.</xsl:text>
  <br/>
  <xsl:text>Pour les événements récurrents, le paramètre sera appliqué à l'ensemble de la séquence.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Les résultats issus d\'une recherche comprenant moins de </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caractères peuvent ne pas être complets. Pour obtenir de meilleurs résultats, essayez d'utiliser au moins </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caractères.</xsl:text>

</xsl:template>


</xsl:stylesheet>
