<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Sans titre
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Dimanche</xsl:if>
  <xsl:if test=".='2'">Lundi</xsl:if>
  <xsl:if test=".='3'">Mardi</xsl:if>
  <xsl:if test=".='4'">Mercredi</xsl:if>
  <xsl:if test=".='5'">Jeudi</xsl:if>
  <xsl:if test=".='6'">Vendredi</xsl:if>
  <xsl:if test=".='7'">Samedi</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">D</xsl:if>
  <xsl:if test="$downum='2'">L</xsl:if>
  <xsl:if test="$downum='3'">M</xsl:if>
  <xsl:if test="$downum='4'">M</xsl:if>
  <xsl:if test="$downum='5'">M</xsl:if>
  <xsl:if test="$downum='6'">V</xsl:if>
  <xsl:if test="$downum='7'">D</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">janv</xsl:if>
  <xsl:if test=".='02'">Fév</xsl:if>
  <xsl:if test=".='03'">Mars</xsl:if>
  <xsl:if test=".='04'">Avril</xsl:if>
  <xsl:if test=".='05'">Mai</xsl:if>
  <xsl:if test=".='06'">Juin</xsl:if>
  <xsl:if test=".='07'">Juillet</xsl:if>
  <xsl:if test=".='08'">août</xsl:if>
  <xsl:if test=".='09'">sept</xsl:if>
  <xsl:if test=".='10'">oct</xsl:if>
  <xsl:if test=".='11'">nov</xsl:if>
  <xsl:if test=".='12'">déc</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">janv</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Fév</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">mars</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">avr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">juin</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">juil</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">août</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">sept</xsl:if>
  <xsl:if test="$MonthNum=10">oct</xsl:if>
  <xsl:if test="$MonthNum=11">nov</xsl:if>
  <xsl:if test="$MonthNum=12">déc</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Janvier</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Février</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mars</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Avril</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juin</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juillet</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Août</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Septembre</xsl:if>
  <xsl:if test="$MonthNum=10">Octobre</xsl:if>
  <xsl:if test="$MonthNum=11">Novembre</xsl:if>
  <xsl:if test="$MonthNum=12">Décembre</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      La date et l'heure indiquées ne sont pas valides. Veuillez les modifier.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Il existe déjà un agenda portant ce nom. Choisissez-en un autre.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Il existe déjà un groupe portant ce nom. Choisissez-en un autre.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> jusqu\'au </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Cette recherche a généré un problème au niveau du serveur d'annuaires.&nbsp;      Indiquez une autre chaîne de recherche.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      La recherche génère un trop grand nombre de résultats.&nbsp;      Indiquez une chaîne de recherche plus détaillée.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      Impossible d'établir la connexion au serveur d'annuaires.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      Impossible d'établir la connexion au serveur d'annuaires.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Cette recherche a généré un problème au niveau du serveur d'annuaires.&nbsp;      Indiquez une autre chaîne de recherche.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      Erreur GSE : l'événement a été supprimé.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      Erreur GSE : implémentation non prise en charge
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      Erreur GSE : échec de malloc
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      Erreur GSE : impossible de créer plusieurs instances de GSE.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      Erreur GSE : entrée GSE non valide
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      Erreur GSE : événement non valide
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      Erreur GSE : interface de transport introuvable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      Erreur GSE : participant introuvable dans l'agenda organisateur
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      Erreur GSE : impossible de créer une ressource telle que lock, GDisp, etc.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      Erreur GSE : utilisateur iCS attendu, utilisateur SMTP obtenu
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      Erreur GSE : méthode et état de composant non valides
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      Erreur GSE : heure de demande en conflit avec une autre demande de réunion existante
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      Erreur DB : composant introuvable
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      Erreur DB : erreur d\'E/S
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      Erreur DB : l\'événement comporte une ou plusieurs valeurs non valides
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      Erreur DB : l\'appel de fonction ne fonctionne pas sur le composant fourni
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      Erreur DB : requête demandée inconnue ou non prise en charge
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      Erreur de base de données : un paramètre requis est NULL, non défini ou absent.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      Erreur DB : écriture annulée car la vérification de numéro de séquence demandée a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      Erreur DB : écriture annulée car la vérification de condition horaire demandée a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      Erreur de base de données : l'écriture a été abandonnée, car l'agenda ne permet pas le chevauchement de rendez-vous.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      Erreur de base de données : l'avertissement ENS a renvoyé une erreur.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      Erreur DB : une valeur requise est nulle
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Erreur invité : argument incorrect
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Erreur invité : agenda introuvable
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Erreur invité : agenda désactivé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Erreur invité : utilisateur non autorisé à accéder à l\'agenda
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Erreur invité : groupe coupé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Erreur invité : suppression de l\'organisateur impossible
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Erreur d'agenda : la création de l'agenda a échoué
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Erreur d'agenda : agenda existant avec même identificateur
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Erreur d'agenda : l'utilisateur ne dispose pas des privilèges d'accès requis      pour effectuer cette opération.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Erreur d'agenda : l'utilisateur essaie d'accéder à un agenda qui n'existe pas.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Erreur d'agenda : identificateur d'agenda non autorisé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Erreur invité : impossible de réserver deux fois l'invité.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Erreur d'agenda : l'utilisateur ne dispose pas des privilèges d'accès requis      pour effectuer cette opération.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Erreur d'agenda : l'utilisateur doit être propriétaire ou copropriétaire      pour réaliser cette opération.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Erreur d'agenda : la base de données est en mode lecture seule.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Consultez l'onglet de disponibilité pour trouver du temps libre.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Erreur de groupe : identificateur de groupe non autorisé
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Erreur d'agenda : impossible d'ajouter un utilisateur inconnu à la liste de confidentialité ou des propriétaires.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      Erreur SMTP : aucun hôte de messagerie
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      Erreur SMTP : échec de la connexion
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      Erreur SMTP : la réponse attendue pour la connexion n'a pas été obtenue.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      Erreur SMTP : problème lors de l'adressage du message
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      Erreur SMTP : aucun destinataire
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Erreur : échec de la connexion à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Erreur : nombre maximum de connexions à la base de données de système central atteint.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Erreur : impossible de résoudre l'agenda.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Erreur : données incorrectes. Impossible d'accéder à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Erreur : contexte d'hôte DWP non disponible.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Erreur : impossible de résoudre l'hôte de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Erreur : aucune donnée. Impossible d'accéder à la base de données de système central.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Erreur : échec de la connexion à la base de données de système central.
    </xsl:when>
    <xsl:otherwise>
      Inconnu erreur #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Erreur : une instance de récurrence ne doit pas en ignorer une autre.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Erreur : deux instances de récurrence ne doivent pas survenir le même jour.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Erreur : impossible de modifier la confidentialité d'une seule instance.
    </xsl:when>
    <xsl:otherwise>
      Erreur de récurrence inconnue #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">Amérique/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">Amérique/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">Amérique/Los_Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">Amérique/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">Amérique/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">Amérique/Costa_Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">Amérique/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">Amérique/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">Amérique/New_York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">Amérique/La_Havane</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">Amérique/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">Amérique/Grand_Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">Amérique/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">Amérique/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">Amérique/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">Amérique/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantique/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">Amérique/St_Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">Amérique/Buenos_Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">Amérique/Sao_Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">Amérique/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">Amérique/Nuuk</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantique/Géorgie_du_Sud</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantique/Cap_Vert</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantique/Açores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Afrique/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europe/Londres</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Afrique/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europe/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Afrique/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europe/Varsovie</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Afrique/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europe/Bucarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europe/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Afrique/Le_Caire</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europe/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Afrique/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europe/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europe/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europe/Moscou</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europe/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asie/Beyrouth</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asie/Jérusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asie/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asie/Riyad</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asie/Téhéran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asie/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asie/Aktaou</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asie/Bakou</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asie/Kaboul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asie/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asie/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asie/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asie/Iekaterinbourg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asie/Calcutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asie/Katmandou</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asie/Dacca</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asie/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asie/Novossibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asie/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asie/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asie/Krasnoïarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asie/Oulan_Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asie/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asie/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asie/Irkoutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asie/Tokyo</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asie/Séoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asie/Iakoutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australie/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australie/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australie/Adélaïde</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australie/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australie/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australie/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asie/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australie/Lord_Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacifique/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacifique/Nouméa</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asie/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacifique/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacifique/Fidji</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacifique/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asie/Kamtchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacifique/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacifique/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asie/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacifique/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacifique/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacifique/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacifique/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacifique/Marquises</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacifique/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacifique/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacifique/Pâques</xsl:when> 
    <xsl:otherwise>
      Inconnu Fuseau horaire #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Aucune date de fin </xsl:variable>
<xsl:variable name="cap_the_text">Le </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Supprimer</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Bienvenue  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tâches de </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>,agenda personnel (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Début à </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 heure</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutes</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Plus de 1 heure</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> disponible)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Crée un maximum de </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instances</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Un ou plusieurs fuseaux horaires d\'une région peuvent être associés à l\'agenda actuel. Dans les vues en grille, comme la vue Journée, tous les fuseaux horaires associés à l\'agenda deviennent partie intégrante de l\'échelle de temps de la vue. Si aucun fuseau horaire n\'est spécifié avec cet agenda, le fuseau horaire par défaut est utilisé. Les fuseaux horaires suivants sont disponibles en </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Un fuseau horaire de n'importe quelle région peut être associé à l'agenda actuel. Dans les vues en grille, comme la vue Journée, le fuseau horaire associé à l'agenda devient partie intégrante de l'échelle de temps de la vue. Si aucun fuseau horaire n'est spécifié avec cet agenda, le fuseau horaire par défaut est utilisé. Les fuseaux horaires suivants sont disponibles en </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>Amérique du Nord/du Sud </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europe/Afrique </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asie/Côte du Pacifique </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>région :</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>L'événement suivant a été ajouté dans votre agenda par "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Vous pouvez accepter ou refuser cette invitation en sélectionnant l'option appropriée ci-dessous.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Cliquer</xsl:text>&nbsp;
  <B><xsl:text>Parcourir...</xsl:text></B>&nbsp;
  <xsl:text>pour sélectionner un fichier.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Utilisez ce volet pour accepter </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> ou refuser </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> ou laisser sans réponse </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> les invitations aux événements.</xsl:text>
  <br/>
  <xsl:text>Pour les événements récurrents, le paramètre sera appliqué à l'ensemble de la séquence.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Les résultats issus d\'une recherche comprenant moins de </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caractères peuvent ne pas être complets. Pour obtenir de meilleurs résultats, essayez d'utiliser au moins </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caractères.</xsl:text>

</xsl:template>


</xsl:stylesheet>
