<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>


<xsl:template name="timezoneTab">
  <xsl:param name="tabNum"/>
  <xsl:param name="zoneName"/>
  <xsl:param name="Action"/>

  <TD nowrap="" align="center">
    <xsl:if test="/calendar/@tab=$tabNum">
      <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_form_selected"/></xsl:attribute>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="/calendar/@tab=$tabNum">
        <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
          <B><xsl:text>&nbsp;</xsl:text><xsl:value-of select="$zoneName"/><xsl:text>&nbsp;</xsl:text></B>
        </FONT>
      </xsl:when>
      <xsl:otherwise>
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_wend_top}">
          <xsl:text>&nbsp;</xsl:text>
          <A href="{$Action}" style="text-decoration:none;">
            <FONT color="#FFFFFF"><xsl:value-of select="$zoneName"/></FONT>
          </A>
          <xsl:text>&nbsp;</xsl:text>
        </FONT>
      </xsl:otherwise>
    </xsl:choose>
  </TD>
</xsl:template>


<xsl:template name="outputTimezoneTabs">
<xsl:param name="timezone_tab"/>

<xsl:if test="/calendar/@tab >= $timezone_tab">
  <BR/>
  <CENTER>
    <TABLE border="0" cellpadding="0" cellspacing="0">
      <TR>
        <TD bgcolor="#000000">
          <TABLE border="0" cellpadding="2" cellspacing="1">
            <TR bgcolor="{$bgcolor_button}">
              <xsl:call-template name="timezoneTab">
                <xsl:with-param name="tabNum">number($timezone_tab)</xsl:with-param>
                <xsl:with-param name="zoneName">Amérique du Nord/du Sud</xsl:with-param>
                <xsl:with-param name="Action" select="./tabs/tab[number($timezone_tab)]"/>
              </xsl:call-template>
              <xsl:call-template name="timezoneTab">
                <xsl:with-param name="tabNum">number($timezone_tab) + 1</xsl:with-param>
                <xsl:with-param name="zoneName">Europe/Afrique</xsl:with-param>
                <xsl:with-param name="Action" select="./tabs/tab[number($timezone_tab)+1]"/>
              </xsl:call-template>
              <xsl:call-template name="timezoneTab">
                <xsl:with-param name="tabNum">number($timezone_tab) + 2</xsl:with-param>
                <xsl:with-param name="zoneName">Asie/Côte du Pacifique</xsl:with-param>
                <xsl:with-param name="Action" select="./tabs/tab[number($timezone_tab)+2]"/>
              </xsl:call-template>
            </TR>
          </TABLE>
        </TD>
      </TR>
    </TABLE>
  </CENTER>
</xsl:if>
</xsl:template>


<xsl:template name="timezones_America_root">

<xsl:param name="multiSelect"/>
<xsl:param name="selectedTZID"/>

<HTML>
<HEAD>
</HEAD>
<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="currSelection" />
  <INPUT type="hidden" name="targetGroup"/>
  <INPUT type="hidden" name="icsTimeZone"><xsl:attribute name="value"><xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/></xsl:attribute></INPUT>

<xsl:if test="$multiSelect=1">
  <SCRIPT>
    var f = document.forms[0];

    f['e_tzid'].value = '<xsl:for-each select="./timezone[@type='europeAfrica']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>
                         <xsl:for-each select="./timezone[@type='asiaPacific']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>';
  </SCRIPT>
</xsl:if>

  <TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
    <TR>
      <TD>
        <FONT face="{$font_name}" size="{$font_size_biggest}" color="#000000">
          <B>Amérique du Nord/du Sud</B>
          <BR/>
          <FONT size="{$font_size_big}">
            <xsl:call-template name="timezone_tab_msg">
                <xsl:with-param name="multiselect" select="$multiSelect"/>
                <xsl:with-param name="tz_area">NSAMERICA</xsl:with-param>
            </xsl:call-template>
          </FONT>
        </FONT>
      </TD>
    </TR>
    <TR>
      <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
    </TR>
  </TABLE>
  <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
    <TR>
      <TD width="1%" bgcolor="{$bgcolor_table_border}">
        <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
          <TR bgcolor="{$bgcolor_table_top}">
            <TD width="1%" nowrap="" align="center"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:text>&nbsp;</xsl:text></FONT></TD>
            <TD nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Fuseau horaire</FONT></TD>
            <TD width="1%" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Décalage GMT</FONT></TD>
          </TR>
          <xsl:for-each select="./timezone[@type='americas']">
            <xsl:call-template name="outputTimeZone">
              <xsl:with-param name="useCheckbox">
                <xsl:value-of select="$multiSelect"/>
              </xsl:with-param>
              <xsl:with-param name="displayName">
	        <xsl:call-template name="getDisplayNameOfTZID">
		  <xsl:with-param name="tzid">
		    <xsl:value-of select="@tzid"/>
                  </xsl:with-param>
		</xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="tzid">
                <xsl:value-of select="@tzid"/>
              </xsl:with-param>
              <xsl:with-param name="offset">
                <xsl:value-of select="@offset"/>
              </xsl:with-param>
              <xsl:with-param name="daylightOffset">
                <xsl:value-of select="@daylightOffset"/>
              </xsl:with-param>
              <xsl:with-param name="currTZID">
                <xsl:value-of select="$selectedTZID"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TABLE>
      </TD>
    </TR>
  </TABLE>
</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="timezones_EuropeAfrica_root">

<xsl:param name="multiSelect"/>
<xsl:param name="selectedTZID"/>

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="currSelection" />
  <INPUT type="hidden" name="targetGroup"/>
  <INPUT type="hidden" name="icsTimeZone"><xsl:attribute name="value"><xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/></xsl:attribute></INPUT>

<xsl:if test="$multiSelect=1">
  <SCRIPT>
    var f = document.forms[0];

    f['e_tzid'].value = '<xsl:for-each select="./timezone[@type='americas']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>
                         <xsl:for-each select="./timezone[@type='asiaPacific']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>';
  </SCRIPT>
</xsl:if>

  <TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
    <TR>
      <TD>
        <FONT face="{$font_name}" size="{$font_size_biggest}" color="#000000">
          <B>Europe/Afrique</B>
          <BR/>
          <FONT size="{$font_size_big}">
            <xsl:call-template name="timezone_tab_msg">
                <xsl:with-param name="multiselect" select="$multiSelect"/>
                <xsl:with-param name="tz_area">EUROPE</xsl:with-param>
            </xsl:call-template>
          </FONT>
        </FONT>
      </TD>
    </TR>
    <TR>
      <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
    </TR>
  </TABLE>
  <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
    <TR>
      <TD width="1%" bgcolor="{$bgcolor_table_border}">
        <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
          <TR bgcolor="{$bgcolor_table_top}">
            <TD width="1%" nowrap="" align="center"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:text>&nbsp;</xsl:text></FONT></TD>
            <TD nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Fuseau horaire</FONT></TD>
            <TD width="1%" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Décalage GMT</FONT></TD>
          </TR>
          <xsl:for-each select="./timezone[@type='europeAfrica']">
            <xsl:call-template name="outputTimeZone">
              <xsl:with-param name="useCheckbox">
                <xsl:value-of select="$multiSelect"/>
              </xsl:with-param>
              <xsl:with-param name="displayName">
	        <xsl:call-template name="getDisplayNameOfTZID">
		  <xsl:with-param name="tzid">
		    <xsl:value-of select="@tzid"/>
                  </xsl:with-param>
		</xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="tzid">
                <xsl:value-of select="@tzid"/>
              </xsl:with-param>
              <xsl:with-param name="offset">
                <xsl:value-of select="@offset"/>
              </xsl:with-param>
              <xsl:with-param name="daylightOffset">
                <xsl:value-of select="@daylightOffset"/>
              </xsl:with-param>
              <xsl:with-param name="currTZID">
                <xsl:value-of select="$selectedTZID"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TABLE>
      </TD>
    </TR>
  </TABLE>
</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="timezones_AsiaPacific_root">

<xsl:param name="multiSelect"/>
<xsl:param name="selectedTZID"/>

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="currSelection" />
  <INPUT type="hidden" name="targetGroup"/>
  <INPUT type="hidden" name="icsTimeZone"><xsl:attribute name="value"><xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/></xsl:attribute></INPUT>

<xsl:if test="$multiSelect=1">
  <SCRIPT>
    var f = document.forms[0];

    f['e_tzid'].value = '<xsl:for-each select="./timezone[@type='americas']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>
                         <xsl:for-each select="./timezone[@type='europeAfrica']">
                           <xsl:if test="contains(($selectedTZID), @tzid)">
                             <xsl:value-of select="@tzid"/>;
                           </xsl:if>
                         </xsl:for-each>';
  </SCRIPT>
</xsl:if>

  <TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>    
    <TR>
      <TD>
        <FONT face="{$font_name}" size="{$font_size_biggest}" color="#000000">
          <B>Asie/Côte du Pacifique</B>
          <BR/>
          <FONT size="{$font_size_big}">
            <xsl:call-template name="timezone_tab_msg">
                <xsl:with-param name="multiselect" select="$multiSelect"/>
                <xsl:with-param name="tz_area">ASIA</xsl:with-param>
            </xsl:call-template>
          </FONT>
        </FONT>
      </TD>
    </TR>
    <TR>
      <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
    </TR>
  </TABLE>
  <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
    <TR>
      <TD width="1%" bgcolor="{$bgcolor_table_border}">
        <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
          <TR bgcolor="{$bgcolor_table_top}">
            <TD width="1%" nowrap="" align="center"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:text>&nbsp;</xsl:text></FONT></TD>
            <TD nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Fuseau horaire</FONT></TD>
            <TD width="1%" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Décalage GMT</FONT></TD>
          </TR>
          <xsl:for-each select="./timezone[@type='asiaPacific']">
            <xsl:call-template name="outputTimeZone">
              <xsl:with-param name="useCheckbox">
                <xsl:value-of select="$multiSelect"/>
              </xsl:with-param>
              <xsl:with-param name="displayName">
	        <xsl:call-template name="getDisplayNameOfTZID">
		  <xsl:with-param name="tzid">
		    <xsl:value-of select="@tzid"/>
                  </xsl:with-param>
		</xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="tzid">
                <xsl:value-of select="@tzid"/>
              </xsl:with-param>
              <xsl:with-param name="offset">
                <xsl:value-of select="@offset"/>
              </xsl:with-param>
              <xsl:with-param name="daylightOffset">
                <xsl:value-of select="@daylightOffset"/>
              </xsl:with-param>
              <xsl:with-param name="currTZID">
                <xsl:value-of select="$selectedTZID"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TABLE>
      </TD>
    </TR>
  </TABLE>
</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="outputTimeZone">
  <xsl:param name="useCheckbox"/>
  <xsl:param name="displayName"/>
  <xsl:param name="tzid"/>
  <xsl:param name="offset"/>
  <xsl:param name="daylightOffset"/>
  <xsl:param name="currTZID"/>

  <TR bgcolor="{$bgcolor_table_top}">
    <TD width="1%" nowrap="" align="center">
      <xsl:choose>
        <xsl:when test="$useCheckbox=0">
          <INPUT type="radio" name="tzid" value="{$tzid}">
            <xsl:if test="$currTZID=$tzid">
              <xsl:attribute name="checked"/>
            </xsl:if>
            <xsl:attribute name="onClick">
              document.forms[0]['currSelection'].value = '<xsl:value-of select="$tzid"/>';
            </xsl:attribute>
          </INPUT>
        </xsl:when>
        <xsl:otherwise>
          <INPUT type="checkbox" name="tzid" value="{$tzid}">
            <xsl:if test="contains(($currTZID), $tzid)">
              <xsl:attribute name="checked"/>
            </xsl:if>
          </INPUT>
          <xsl:if test="contains(($currTZID), $tzid)">
            <SCRIPT>
              document.forms[0]['currSelection'].value = '<xsl:value-of select="$tzid"/>';
            </SCRIPT>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </TD>
    <TD nowrap="" bgcolor="#FFFFFF">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:value-of select="$displayName"/>
      </FONT>
    </TD>
    <TD width="1%" align="center" nowrap="" bgcolor="#FFFFFF">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:value-of select="$offset"/>
      </FONT>
    </TD>
  </TR>

</xsl:template>

</xsl:stylesheet>
