<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>	
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Lista de tareas: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (task_list.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0" onload="window.focus()">

<xsl:call-template name="load_tabs"/>

<xsl:variable name="TabName">
    <xsl:call-template name="task_tab_name">
      <xsl:with-param name="numtasks" select="./tabs/tasklist/@taskcount"/>
    </xsl:call-template>
</xsl:variable>

<FORM name="form" method="post">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item">
          <xsl:with-param name="Index">1</xsl:with-param>
          <xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param>
          <xsl:with-param name="Name">
            <xsl:value-of select="$TabName"/>
          </xsl:with-param>
          <xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param>
        </xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
  <TR>
    <TD colspan="2"><FONT face="Verdana,sans-serif" size="{$font_size_big}">Use este panel para realizar un seguimiento de todas las cosas que tiene que hacer. Puede marcar las tareas como completadas haciendo clic en las casillas de verificación de la columna "Hecho". Haga clic en "Guardar y cerrar" para confirmar los cambios.</FONT>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
</TABLE>

<TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}">
      <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">

<!-- Top row of the table -->
      <TR bgcolor="{$bgcolor_table_top}">
        <TD width="1%" align="right" nowrap=""><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">Vence</FONT></TD>
        <TD width="1%" nowrap="" align="center"><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">Realizada</FONT></TD>
        <TD><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">ar tarea</FONT></TD>
        <TD width="1%" nowrap="" align="center"><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">Borrar</FONT></TD>
      </TR>
      
<!-- For each task, print out a table row -->
  <xsl:for-each select="./tasklist/Task">
      <xsl:call-template name="Table_Task"></xsl:call-template>
 </xsl:for-each>
 <xsl:if test="count(./tasklist/Task) = 0">
 <TR>
   <TD colspan="4" align="left" valign="top" bgcolor="#FFFFFF">
     <FONT face="{$font_name}" size="{$font_size_big_2}">
      <CENTER>No hay tareas</CENTER>
     </FONT>
   </TD>
 </TR>
 </xsl:if>

<!-- Bottom row of the table -->
      <TR bgcolor="{$bgcolor_table_mid}">
        <TD width="1%" align="right" nowrap=""><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">Seleccionar todos</FONT></TD>
        <TD width="1%" align="center" nowrap="">
          <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">
            <INPUT type="checkbox" name="allcomplete">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 10) == 'informdone') {
                    (f.elements[i]).checked=1;
                  }
                }
                f['allcomplete'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
        <TD align="right"><FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">Seleccionar todos</FONT></TD>
        <TD width="1%" align="center" nowrap="">
          <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">
            <INPUT type="checkbox" name="alldelete">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 12) == 'informdelete') {
                    (f.elements[i]).checked=1;
                  }
                }
                f['alldelete'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="Table_Task">
  <TR bgcolor="#FFFFFF">

  <TD width="1%" nowrap="" align="right" valign="top">
    <P>
      <xsl:choose>
        <xsl:when test="@e_notdue='1'">
        <!-- doesn't matter what day you're on, this is still "not due" -->
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="{$bgcolor_wend_mid}">
            Sin vencimiento
          </FONT>
        </xsl:when>
        <xsl:otherwise>
          <FONT face="{$font_name}" size="{$font_size_big_2}">
            <xsl:choose>
              <xsl:when test="@overdue='TRUE'">
                <xsl:attribute name="color">#CC0000</xsl:attribute>
                <B>
                <xsl:call-template name="brief_date_or_today">
                <xsl:with-param name="TargetMonth" select="./DueTime/@month"/>
                <xsl:with-param name="TargetDay" select="./DueTime/@date"/>
                <xsl:with-param name="TargetYear" select="./DueTime/@year"/>
                <xsl:with-param name="CurrentMonth" select="../../timectx/CurrTime/@month"/>
                <xsl:with-param name="CurrentDay" select="../../timectx/CurrTime/@date"/>
                <xsl:with-param name="CurrentYear" select="../../timectx/CurrTime/@year"/>
              </xsl:call-template>
              <xsl:if test="@e_allday!='1'">
                <xsl:text>&nbsp;</xsl:text>tir<xsl:text>&nbsp;</xsl:text>
                <xsl:call-template name="formatTime">
                  <xsl:with-param name="ftHour" select="./DueTime/@hour"/>
                  <xsl:with-param name="ftMinute" select="./DueTime/@minute"/>
                </xsl:call-template>
              </xsl:if>
              </B>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="color">#000000</xsl:attribute>
                <xsl:call-template name="brief_date_or_today">
                <xsl:with-param name="TargetMonth" select="./DueTime/@month"/>
                <xsl:with-param name="TargetDay" select="./DueTime/@date"/>
                <xsl:with-param name="TargetYear" select="./DueTime/@year"/>
                <xsl:with-param name="CurrentMonth" select="../../timectx/CurrTime/@month"/>
                <xsl:with-param name="CurrentDay" select="../../timectx/CurrTime/@date"/>
                <xsl:with-param name="CurrentYear" select="../../timectx/CurrTime/@year"/>
              </xsl:call-template>
              <xsl:if test="@e_allday!='1'">
                <xsl:text>&nbsp;</xsl:text>tir<xsl:text>&nbsp;</xsl:text>
                <xsl:call-template name="formatTime">
                <xsl:with-param name="ftHour" select="./DueTime/@hour"/>
                <xsl:with-param name="ftMinute" select="./DueTime/@minute"/>
                </xsl:call-template>
              </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
          </FONT>
        </xsl:otherwise>
      </xsl:choose>
    </P>
  </TD>
  <TD width="1%" nowrap="" align="center" valign="top" bgcolor="{$bgcolor_table_mid}">
<!-- previous state -->
  <INPUT type="hidden">
    <xsl:attribute name="name">
      statedone_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="@e_rid"/>_<xsl:value-of select="@e_Calid_encoded"/>_
      <xsl:choose>
      <xsl:when test="string-length(@e_dtcompleted) > 0">
      on
     </xsl:when>
     <xsl:otherwise>
     off
    </xsl:otherwise>
    </xsl:choose>
  </xsl:attribute>
  </INPUT>      
<!-- pick up new state -->
  <INPUT type="checkbox">
    <xsl:attribute name="name">informdone_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="@e_rid"/>_<xsl:value-of select="@e_Calid_encoded"/></xsl:attribute>
    <xsl:if test="string-length(@e_dtcompleted) > 0">
      <xsl:attribute name="checked"/>
    </xsl:if>                 
    <xsl:attribute name="onClick">
    if (document.forms[0]['e_dtcompleted'] &amp;&amp; document.forms[0]['completed'].value) {
            document.forms[0]['e_dtcompleted'].value = '';
    }
    </xsl:attribute>
  </INPUT>
  </TD>
<TD>
  <FONT face="${font_name}" size="{$font_size_big_2}">
  <A>
    <xsl:choose>
    <xsl:when test ="string-length(string(@e_Summary)) = 0">
    <xsl:attribute name="href">
    <xsl:value-of select="edit_command"/>
    </xsl:attribute>
    Tarea sin título
    </xsl:when>
    <xsl:otherwise>
    <xsl:attribute name="href">
    <xsl:value-of select="edit_command"/>
    </xsl:attribute>
    <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="@e_Summary"/>
     <xsl:with-param name="thelength">60</xsl:with-param>
    </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
  </A>
    <xsl:if test="string-length(@e_Description) &gt; 0">
    <xsl:text>&nbsp;</xsl:text>-<xsl:text>&nbsp;</xsl:text>
    <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="@e_Description"/>
     <xsl:with-param name="thelength">60</xsl:with-param>
    </xsl:call-template>
    </xsl:if>
  </FONT>
</TD>
<TD width="1%" nowrap="" align="center" valign="top" bgcolor="{$bgcolor_table_mid}">
<!-- pick up new state -->
  <INPUT type="checkbox">
  <xsl:attribute name="name">informdelete_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="@e_rid"/>_<xsl:value-of select="@e_Calid_encoded"/></xsl:attribute>
  </INPUT>
</TD>
</TR>
</xsl:template>


<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="left" bgcolor="{$bgcolor_button}"></TD>
    <TD align="right" bgcolor="{$bgcolor_button}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="ok" value="Guardar y cerrar" width="72">
      <xsl:attribute name="onClick">
          if (form_submitted == '1') {
             alert('En proceso');
             return;
          }
          form_submitted = '1';
          <xsl:value-of select="./button[@name='ok']"/>
      </xsl:attribute>
      </INPUT>
      <INPUT type="button" name="esc" value="Cancelar" onClick="{./button[@name='cancel']}" width="72"/>
      <INPUT type="button" name="help" value="Ayuda" onClick="{./button[@name='help']}" width="72"/> </FONT> 
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML></xsl:template>



</xsl:stylesheet>





