<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Sin título
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Domingo</xsl:if>
  <xsl:if test=".='2'">Lunes</xsl:if>
  <xsl:if test=".='3'">Martes</xsl:if>
  <xsl:if test=".='4'">Miércoles</xsl:if>
  <xsl:if test=".='5'">Jueves</xsl:if>
  <xsl:if test=".='6'">Viernes</xsl:if>
  <xsl:if test=".='7'">Sábado</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">D</xsl:if>
  <xsl:if test="$downum='2'">L</xsl:if>
  <xsl:if test="$downum='3'">M</xsl:if>
  <xsl:if test="$downum='4'">Mi</xsl:if>
  <xsl:if test="$downum='5'">M</xsl:if>
  <xsl:if test="$downum='6'">V</xsl:if>
  <xsl:if test="$downum='7'">D</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Ene</xsl:if>
  <xsl:if test=".='02'">Feb</xsl:if>
  <xsl:if test=".='03'">Marzo</xsl:if>
  <xsl:if test=".='04'">Abril</xsl:if>
  <xsl:if test=".='05'">Mayo</xsl:if>
  <xsl:if test=".='06'">Junio</xsl:if>
  <xsl:if test=".='07'">Julio</xsl:if>
  <xsl:if test=".='08'">Ago</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Oct</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dic</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Ene</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Feb</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mar</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Abr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mayo</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Jun</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Jul</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Ago</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Oct</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dic</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Enero</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Febrero</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Marzo</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Abril</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mayo</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Junio</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Julio</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Agosto</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Septiembre</xsl:if>
  <xsl:if test="$MonthNum=10">Octubre</xsl:if>
  <xsl:if test="$MonthNum=11">Noviembre</xsl:if>
  <xsl:if test="$MonthNum=12">Diciembre</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      La fecha y la hora especificadas no son válidas. Corríjalas.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Ya existe un calendario con este nombre. Seleccione otro nombre.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Ya existe un grupo con este nombre. Seleccione otro nombre.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> hasta </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Se ha producido un problema en el servidor de directorios al realizar esta búsqueda.&nbsp; Especifique otra cadena de búsqueda.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp; Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp;      Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp; Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      No se ha podido establecer una conexión con el servidor de directorios.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      No se ha podido establecer una conexión con el servidor de directorios.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Se ha producido un problema en el servidor de directorios al realizar esta búsqueda.&nbsp; Especifique otra cadena de búsqueda.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      Error de GSE: se ha eliminado un evento.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      Error de GSE: la implementación no se admite.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      Error de GSE: error en la función de asignación de memoria (malloc).
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      Error de GSE: no se pueden crear varias instancias de GSE.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      Error de GSE: la entrada de GSE no es válida.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      Error de GSE: el evento no es válido.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      Error de GSE: no se encuentra la interfaz de transporte.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      Error de GSE: no se encuentra un asistente en el organizador del calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      Error de GSE: no se pueden crear recursos como, por ejemplo, lock, GDisp, etc.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      Error de GSE: se espera un usuario iCS, en lugar de uno SMTP.
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      Error de GSE: el método del componente y su estado no son válidos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      Error de GSE: la hora solicitada está en conflicto con otra solicitud de reunión existente.
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      Error de base de datos: no se encuentra el componente.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      Error de base de datos: error de E/S.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      Error de base de datos: uno o varios de los valores del evento no son válidos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      Error de base de datos: la funcion de llamada (call) no funciona en el componente proporcionado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      Error de base de datos: la consulta solicitada no se admite o es desconocida.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      Error de base de datos: un parámetro requerido es NULO, no está definido o no está presente.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      Error de base de datos: la escritura se anuló porque la condición SequenceNo solicitada ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      Error de base de datos: la escritura se anuló porque la condición de modificación de tiempo solicitada ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      Error de base de datos: la escritura se anuló porque el calendario no permite citas que se superpongan.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      Error de base de datos: la notificación ENS devolvió un error.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      Error de base de datos: un valor requerido es nulo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Error de invitado: el argumento es erróneo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Error de invitado: no se encuentra el calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Error de invitado: el calendario está deshabilitado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Error de invitado: el usuario no puede acceder al calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Error de invitado: el grupo está cortado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Error de invitado: no se puede eliminar el organizador.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Error de calendario: ha fallado la creación del calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Error de calendario: ya hay un calendario con el mismo identificador.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Error de calendario: el usuario no tiene los derechos de acceso necesarios para realizar esta operación.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Error de calendario: el usuario está intentando acceder a un calendario que no existe.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Error de calendario: el identficador del calendario es ilegal.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Error de invitado: no se pueden hacer dos reservas para un invitado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Error de calendario: el usuario no tiene los derechos de acceso necesarios para realizar esta operación.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Error de calendario: el usuario debe ser propietario o co-propietario para realizar esta acción.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Error de calendario: la base de datos está en modo de solo lectura.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Consulte la ficha de disponibilidad para buscar tiempo libre.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Error de grupo: el identificador del grupo es ilegal.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Error de calendario: no se puede agregar un usuario desconocido a la lista privada o a la lista del propietario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      Error de SMTP: no hay host de correo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      Error de SMTP: la conexión ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      Error de SMTP: no se ha producido la respuesta esperada de conexión.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      Error de SMTP: se ha producido un problema al enviar el mensaje.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      Error de SMTP: no hay destinatario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Error: ha fallado la conexión a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Error: se ha alcanzado el máximo de conexiones a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Error: no es posible resolver el calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Error: no se puede acceder a la base de datos de fondo (backend) con datos erróneos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Error: el contexto del host DWP no está disponible.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Error: el host de fondo (backend) no se puede resolver.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Error: no hay datos y no se puede acceder a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Error: ha fallado la conexión a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:otherwise>
      Desconocido error #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Error: una instancia recurrente no puede superponerse a otra.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Error: dos instancias recurrentes no pueden ocurrir en el mismo día.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Error: no se puede cambiar la privacidad de una instancia sola.
    </xsl:when>
    <xsl:otherwise>
      Error de recurrencia desconocido #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">América/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">América/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">América/Los Ángeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">América/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">América/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">América/Costa Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">América/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">América/Indianápolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">América/Nueva York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">América/La Habana</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">América/Puerto Príncipe</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">América/Grand Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">América/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">América/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">América/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">América/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlántico/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">América/St. Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">América/Buenos Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">América/Sao Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">América/Miquelón</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">América/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlántico/Georgia del Sur</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlántico/Cabo Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlántico/Azores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">África/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europa/Londres</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">África/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europa/París</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">África/Trípoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europa/Varsovia</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">África/Johannesburgo</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europa/Bucarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europa/Estambul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">África/El Cairo</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europa/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">África/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europa/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europa/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europa/Moscú</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europa/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asia/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asia/Jerusalén</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asia/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asia/Riyadh</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asia/Teherán</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asia/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asia/Aqtau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asia/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asia/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asia/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asia/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asia/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asia/Yekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asia/Calcuta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asia/Katmandú</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asia/Dhaka</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asia/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asia/Novosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asia/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asia/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asia/Krasnoyarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asia/Ulan Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asia/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asia/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asia/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asia/Tokio</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asia/Seúl</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asia/Yakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australia/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australia/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australia/Adelaida</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australia/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australia/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australia/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asia/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australia/Lord Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacífico/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacífico/Noumea</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asia/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacífico/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacífico/Fiyi</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacífico/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asia/Kamchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacífico/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacífico/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asia/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacífico/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacífico/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacífico/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacífico/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacífico/Marquesas</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacífico/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacífico/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacífico/Pascua</xsl:when> 
    <xsl:otherwise>
      Desconocido zona horaria #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">Aceptar</xsl:variable>

<xsl:variable name="cancel_title">Cancelar</xsl:variable>
<xsl:variable name="close_title">Cerrar</xsl:variable>
<xsl:variable name="help_title">Ayuda</xsl:variable>
<xsl:variable name="apply_title">Aplicar</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">No hay eventos ni tareas.</xsl:variable>
<xsl:variable name="week_ahead_title">La semana siguiente</xsl:variable>
<xsl:variable name="alt_text_schedule">Planificar una nueva cita</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">Escriba a continuación un nombre de usuario y haga clic en el botón "Aceptar".</xsl:variable>

<xsl:variable name="user_name_title">Nombre de usuario</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">Pasar al día anterior</xsl:variable>

<xsl:variable name="alt_jump_next_day">Pasar al día siguiente</xsl:variable>

<xsl:variable name="alt_jump_new_date">Pasar a nueva fecha</xsl:variable>

<xsl:variable name="available_title">Disponible</xsl:variable>

<xsl:variable name="busy_title">Ocupado</xsl:variable>

<xsl:variable name="hour_text">hora</xsl:variable>
<xsl:variable name="minutes_text">minutos</xsl:variable>

<xsl:variable name="show_availability_title">Mostrar disponibilidad</xsl:variable>

<xsl:variable name="error_cal_privacy">Es posible que las propiedades de privacidad de este calendario no le permitan verlo o que no exista el calendario.</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">América del Norte/América del Sur</xsl:variable>

<xsl:variable name="europe_africa_title">Europa/África</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">Asia/Pacífico Sur</xsl:variable>

<xsl:variable name="time_zone_title">Zona horaria</xsl:variable>

<xsl:variable name="gmt_offset_title">Variación respecto a GMT</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">Grupos</xsl:variable>

<xsl:variable name="groups_msg">Use un grupo de calendarios para ver varios calendarios de una vez. Para ver un grupo de calendarios, haga clic en el enlace del nombre del grupo. Para agregar o eliminar calendarios de un grupo, haga clic en el enlace "Editar".</xsl:variable>

<xsl:variable name="select_title">Seleccionar</xsl:variable>

<xsl:variable name="group_title">Grupo</xsl:variable>

<xsl:variable name="group_colon_title">Grupo:</xsl:variable>

<xsl:variable name="description_title">Descripción</xsl:variable>

<xsl:variable name="properties_title">Propiedades</xsl:variable>

<xsl:variable name="error_cal_access">No tiene permisos para acceder a este calendario.</xsl:variable>

<xsl:variable name="error_cal_not_exist">Este calendario no existe.</xsl:variable>

<xsl:variable name="edit_title">Editar</xsl:variable>
<xsl:variable name="edit_calendar_title">Editar calendario</xsl:variable>

<xsl:variable name="remove_selected_title">Eliminar la selección</xsl:variable>

<xsl:variable name="calendars_title">Calendarios</xsl:variable>

<xsl:variable name="calendars_msg">Lista de los calendarios que posee o de los calendarios a los que se ha suscrito. Para ver un calendario, haga clic en el nombre oportuno. Para editar un calendario, haga clic en "Editar".</xsl:variable>

<xsl:variable name="calendar_title">Calendario</xsl:variable>

<xsl:variable name="view_title">Ver</xsl:variable>
<xsl:variable name="view_calendar_title">Ver calendario</xsl:variable>

<xsl:variable name="view_colon_title">Ver:</xsl:variable>

<xsl:variable name="options_title">Opciones</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">Cambiar la zona horaria predeterminada: Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">visión general</xsl:variable>

<xsl:variable name="day_tab_title">día</xsl:variable>

<xsl:variable name="week_tab_title">semana</xsl:variable>

<xsl:variable name="month_tab_title">mes</xsl:variable>

<xsl:variable name="year_tab_title">año</xsl:variable>

<xsl:variable name="comparison_tab_title">comparación</xsl:variable>

<xsl:variable name="repeat_title">Repetir</xsl:variable>

<xsl:variable name="change_repeat_title">Cambiar el patrón de repeticiones</xsl:variable>

<xsl:variable name="alt_jump_prev_month">Pasar al mes anterior</xsl:variable>

<xsl:variable name="alt_jump_next_month">Pasar al mes siguiente</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">Hoy es: </xsl:variable>

<xsl:variable name="alt_jump_this_date">Pasar a esta fecha</xsl:variable>

<xsl:variable name="action_items_title">Elementos de acción</xsl:variable>

<xsl:variable name="invitations_title">Invitaciones</xsl:variable>

<xsl:variable name="no_invitations_msg">No hay invitaciones</xsl:variable>

<xsl:variable name="tasks_title">Tareas</xsl:variable>

<xsl:variable name="overdue_msg">vencidas</xsl:variable>

<xsl:variable name="no_tasks_msg">No hay tareas</xsl:variable>

<xsl:variable name="errors_title">Errores</xsl:variable>

<xsl:variable name="no_errors_msg">No hay errores</xsl:variable>

<xsl:variable name="daily_title">Diariamente</xsl:variable>

<xsl:variable name="weekly_title">Semanalmente</xsl:variable>

<xsl:variable name="monthly_title">Mensualmente</xsl:variable>

<xsl:variable name="yearly_title">Anualmente</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">Repetición de la selección: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">Sólo éste</xsl:variable>

<xsl:variable name="this_and_future_title">Éste y los futuros</xsl:variable>

<xsl:variable name="all_instances_title">Todas las instancias</xsl:variable>

<xsl:variable name="repeating_selection_title">Selección de repetición</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">Vence hoy</xsl:variable>

<xsl:variable name="other_tasks_title">Otras tareas</xsl:variable>

<xsl:variable name="overdue_tasks_title">Tareas vencidas</xsl:variable>

<xsl:variable name="all_day_events_title">Eventos de todo el día</xsl:variable>

<xsl:variable name="conflict_msg">conflicto</xsl:variable>

<xsl:variable name="overdue_title">Vencidas</xsl:variable>

<xsl:variable name="due_at_title">Vence el</xsl:variable>

<xsl:variable name="untitled_task_title">Tarea sin título</xsl:variable>

<xsl:variable name="alt_view_this_task">Ver esta tarea</xsl:variable>

<xsl:variable name="alt_delete_this_task">Borrar esta tarea</xsl:variable>

<xsl:variable name="untitled_event_title">Acontecimiento sin título</xsl:variable>

<xsl:variable name="alt_delete_this_event">Borrar este acontecimiento</xsl:variable>

<xsl:variable name="alt_view_this_event">Ver este evento</xsl:variable>

<xsl:variable name="all_day_title">Todo el día</xsl:variable>

<xsl:variable name="overdue_from_title">Vence desde</xsl:variable>

<xsl:variable name="from_txt">desde</xsl:variable>

<xsl:variable name="due_on_title">Vence el</xsl:variable>

<xsl:variable name="not_due_title">Sin vencimiento</xsl:variable>

<xsl:variable name="due_title">Vence</xsl:variable>

<xsl:variable name="on_txt">el</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">ombr</xsl:variable>

<xsl:variable name="pm_txt">pm</xsl:variable>

<xsl:variable name="midnight_title">Medianoche</xsl:variable>

<xsl:variable name="noon_title">Mediodía</xsl:variable>

<xsl:variable name="from_title">De</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">Planificar una nueva cita</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">Lista de errores: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">Este panel muestra una lista con los errores de programación más importantes.</xsl:variable>

<xsl:variable name="organizer_title">Organizador</xsl:variable>

<xsl:variable name="attendee_title">Participante</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">No hay errores importantes</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">Recurrencia: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">Repetición</xsl:variable>

<xsl:variable name="start_title">Inicio</xsl:variable>

<xsl:variable name="end_title">Fin</xsl:variable>

<xsl:variable name="create_title">Crear</xsl:variable>

<xsl:variable name="events_text">eventos</xsl:variable>

<xsl:variable name="alert_provide_valid_count">Especifique un número válido</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">Introduzca un número que sea menor o igual a</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">El recordatorio para este evento está definido para una hora posterior a su inicio. Pulse \'Cancelar\' para volver atrás y cambiar la hora.</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">El recordatorio para esta tarea está definido para una hora posterior a su vencimiento. Pulse \'Cancelar\' para volver atrás y cambiar la hora.</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">Redactar</xsl:variable>

<xsl:variable name="reminders_title">Recordatorios</xsl:variable>

<xsl:variable name="availability_title">Disponibilidad</xsl:variable>

<xsl:variable name="preview_title">Vista preliminar</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">Lista de invitaciones: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">Borrar</xsl:variable>

<xsl:variable name="recurring_event_msg">Acontecimiento periódico</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">No hay invitaciones destacables.</xsl:variable>

<xsl:variable name="all_title">Todos</xsl:variable>

<xsl:variable name="delete_all_title">Borrar todo</xsl:variable>

<xsl:variable name="save_and_close_title">Guardar y cerrar</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">Ha seleccionado una opción vacía</xsl:variable>

<xsl:variable name="alert_min_year">No es posible ver años anteriores a 1970.</xsl:variable>
<xsl:variable name="alert_max_year">No es posible ver años posteriores a 2036.</xsl:variable>

<xsl:variable name="alert_invalid_date">La fecha no es válida. Corríjala.</xsl:variable>

<xsl:variable name="january_title">Enero</xsl:variable>
<xsl:variable name="february_title">Febrero</xsl:variable>
<xsl:variable name="march_title">Marzo</xsl:variable>
<xsl:variable name="april_title">Abril</xsl:variable>
<xsl:variable name="may_title">Mayo</xsl:variable>
<xsl:variable name="june_title">Junio</xsl:variable>
<xsl:variable name="july_title">Julio</xsl:variable>
<xsl:variable name="august_title">Agosto</xsl:variable>
<xsl:variable name="september_title">Septiembre</xsl:variable>
<xsl:variable name="october_title">Octubre </xsl:variable>
<xsl:variable name="november_title">Noviembre</xsl:variable>
<xsl:variable name="december_title">Diciembre</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">Especifique una fecha válida para</xsl:variable>

<xsl:variable name="provide_good_date_msg">Especifique una fecha válida</xsl:variable>

<xsl:variable name="provide_good_month_msg">Especifique un mes entre el 1 y el 12.</xsl:variable>

<xsl:variable name="provide_good_year_msg">Especifique un año válido.\n\nSi usa dos dígitos para representar el año, los valores inferiores a 37\nse considerarán como pertenecientes al siglo XXI.\n\nPor ejemplo, 03 equivale a 2003.</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">Especifique un año posterior a 1970.</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">Especifique un año anterior a 2037.</xsl:variable>

<xsl:variable name="provide_good_hour_msg">Especifique un valor horario válido. (1-12) en formato de 12 horas o (0-23) para el formato de 24 horas</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">Especifique un valor que sea válido para las horas (0-23).</xsl:variable>

<xsl:variable name="provide_good_minute_msg">Especifique un valor que sea válido para los minutos (0-59).</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">Seleccione una fecha de finalización después de la fecha de inicio</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">La fecha especificada no existe.\nSe usará la fecha válida mas próxima en el calendario.</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">Ir a la fecha: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">Ir al año anterior</xsl:variable>

<xsl:variable name="alt_jump_next_year">Pasar al año siguiente</xsl:variable>

<xsl:variable name="jump_to_date_title">Pasar a una fecha</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">¿Seguro que desea eliminar esta entrada privada?</xsl:variable>

<xsl:variable name="edit_calendar_page_title">Editar el calendario: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">Indica que se trata de información obligatoria.</xsl:variable>

<xsl:variable name="calendar_name_msg">Proporcione un nombre abreviado para el calendario como, por ejemplo, "voleibol" (no se permiten los espacios).</xsl:variable>

<xsl:variable name="display_name_title">Nombre para mostrar</xsl:variable>

<xsl:variable name="display_name_msg">Campo opcional que le recuerda el propósito de este calendario, como "Planificación de partidos de voleibol de Miguel".</xsl:variable>

<xsl:variable name="include_in_availability_msg">Incluir este calendario cuando se calcule la disponibilidad</xsl:variable>

<xsl:variable name="calendar_address_title">Dirección del calendario</xsl:variable>

<xsl:variable name="calendar_address_msg">Puede proporcionar acceso a otras personas a este calendario con sólo poner a su disposición este enlace. Dichas personas podrán usar el enlace en sus navegadores para ver el calendario, siempre y cuando el control de acceso esté configurado para ello.</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">Permisos para el calendario:</xsl:variable>

<xsl:variable name="cal_permissions_msg">Los permisos determinan la forma en que los usuarios pueden ver y modificar este calendario. Para conceder ciertos permisos a todos los usuarios, seleccione los permisos adecuados en la columna que está junto a "Todos". Para conceder ciertos permisos a personas concretas, escriba el ID de usuario de las personas en cuestión en el campo del usuario y haga clic en "Agregar usuario". A continuación, seleccione los permisos que procedan en la columna que hay junto al nombre del usuario.</xsl:variable>

<xsl:variable name="user_title">Usuario</xsl:variable>
<xsl:variable name="user_title_with_colon">Usuario:</xsl:variable>

<xsl:variable name="permissions_title">Autorizaciones</xsl:variable>

<xsl:variable name="invite_title">Invitar</xsl:variable>

<xsl:variable name="read_title">Leer</xsl:variable>

<xsl:variable name="modify_title">Modificar</xsl:variable>

<xsl:variable name="delete_selected_user_title">Borrar usuario seleccionado</xsl:variable>

<xsl:variable name="add_user_title">Agregar usuario</xsl:variable>

<xsl:variable name="everybody_title">Todo el mundo</xsl:variable>

<xsl:variable name="this_domain_title">Este dominio</xsl:variable>

<xsl:variable name="tip_cal_owners">Sugerencias para asignar propietarios al calendario:</xsl:variable>

<xsl:variable name="cal_owner_msg">Puede agregar uno o varios propietarios a un calendario. Un propietario puede actuar en su nombre para responder a invitaciones, así como para crear, modificar y eliminar eventos.</xsl:variable>

<xsl:variable name="no_owners_msg">No hay propietarios.</xsl:variable>

<xsl:variable name="delete_owner_title">Borrar propietario</xsl:variable>

<xsl:variable name="add_owner_title">Agregar propietario</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">¿Está seguro de que desea borrar este calendario?</xsl:variable>

<xsl:variable name="alert_supply_cal_name">Debe proporcionar un nombre de calendario</xsl:variable>

<xsl:variable name="owners_title">Propietarios</xsl:variable>

<xsl:variable name="time_zones_title">Zonas horarias</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">¿Seguro que desea eliminar este acontecimiento?</xsl:variable>

<xsl:variable name="edit_event_page_title">Editar eventos: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---Invitación rápida---</xsl:variable>

<xsl:variable name="event_title_title">Título de acontecimiento</xsl:variable>

<xsl:variable name="date_title">Fecha</xsl:variable>

<xsl:variable name="time_title">Hora</xsl:variable>

<xsl:variable name="all_day_msg">Todo el día (por ejemplo, un día libre o un día de cumpleaños)</xsl:variable>

<xsl:variable name="privacy_title">Privacidad</xsl:variable>

<xsl:variable name="public_event_title">Acontecimiento público</xsl:variable>

<xsl:variable name="confidential_event_title">Sólo fecha y hora</xsl:variable>

<xsl:variable name="private_event_title">Acontecimiento privado</xsl:variable>

<xsl:variable name="location_title">Ubicación</xsl:variable>

<xsl:variable name="invite_others_msg">Invitar otros usuarios o recursos:</xsl:variable>

<xsl:variable name="search_title">Buscar...</xsl:variable>

<xsl:variable name="inform_title">Informar</xsl:variable>

<xsl:variable name="invite_instructions_msg">(Escriba el ID de usuario, el ID del calendario o la dirección de correo electrónico. Si no sabe el nombre, haga clic en "Buscar".)</xsl:variable>

<xsl:variable name="invitees_title">Invitados</xsl:variable>

<xsl:variable name="no_invitees_msg">No hay invitados.</xsl:variable>

<xsl:variable name="remove_title">Eliminar</xsl:variable>

<xsl:variable name="inform_event_title">Informar acerca del evento</xsl:variable>

<xsl:variable name="no_informees_msg">No hay informados.</xsl:variable>

<xsl:variable name="event_reminders_msg">Puede enviarse a sí mismo un correo electrónico que sirva como recordatorio de este evento. Escriba una o varias direcciones de correo electrónico abajo. Separe cada dirección con una coma (,) o un punto y coma (;).</xsl:variable>

<xsl:variable name="remind_title">Recordar</xsl:variable>

<xsl:variable name="alert_provide_valid_time">Especifique una hora válida.</xsl:variable>

<xsl:variable name="hours_text">horas</xsl:variable>

<xsl:variable name="days_text">días</xsl:variable>

<xsl:variable name="before_the_event_begins_text">antes de que comience el evento</xsl:variable>

<xsl:variable name="at_text">tir</xsl:variable>

<xsl:variable name="text_reminder_msg">Puede enviar un mensaje de texto con el correo electrónico de recordatorio.</xsl:variable>

<xsl:variable name="message_title">Mensaje</xsl:variable>

<xsl:variable name="title_title">Título</xsl:variable>

<xsl:variable name="attendees_title">Asistentes</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">¿Desea proceder con la eliminación?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">Editar grupo de calendarios: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---Adición rápida---</xsl:variable>

<xsl:variable name="delete_calendar_text">¿Seguro que desea eliminar este calendario?</xsl:variable>

<xsl:variable name="group_name_title">Nombre de grupo</xsl:variable>

<xsl:variable name="group_view_msg">Abrir el grupo en la vista de día (por defecto, los grupos se abren en la vista de comparación.)</xsl:variable>

<xsl:variable name="calendar_id_title">Id. de calendario</xsl:variable>

<xsl:variable name="add_title">Agregar</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(Escriba el ID del calendario. Si no conoce el ID, haga clic en "Buscar".)</xsl:variable>

<xsl:variable name="group_members_title">Miembros del grupo</xsl:variable>

<xsl:variable name="group_description_msg">Escriba aquí una descripción del grupo. También puede elegir si la vista de día de este grupo mostrará cada uno de los calendarios por separado.</xsl:variable>

<xsl:variable name="day_view_title">Vista del día</xsl:variable>

<xsl:variable name="day_view_merge_msg">Por defecto, los calendarios aparecen sin combinar en la vista de día.</xsl:variable>

<xsl:variable name="alert_group_name">Debe proporcionar un nombre para el grupo</xsl:variable>

<xsl:variable name="calendar_group_title">ar grupo de calendarios</xsl:variable>

<xsl:variable name="details_title">Detalles</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">¿Seguro que desea eliminar esta tarea?</xsl:variable>

<xsl:variable name="edit_task_page_title">Editar tarea: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">Elaborar tarea</xsl:variable>

<xsl:variable name="task_title_title">Título de la tarea</xsl:variable>

<xsl:variable name="due_date_title">Fecha de vencimiento</xsl:variable>

<xsl:variable name="no_time_title">Sin hora</xsl:variable>

<xsl:variable name="public_task_title">Tarea pública</xsl:variable>

<xsl:variable name="confidential_task_title">Sólo fecha y hora</xsl:variable>

<xsl:variable name="private_task_title">Tarea privada</xsl:variable>

<xsl:variable name="status_title">Estado</xsl:variable>

<xsl:variable name="complete_title">Finalizada</xsl:variable>

<xsl:variable name="task_reminder_msg">Puede enviarse a sí mismo un correo electrónico que sirva como recordatorio de esta tarea. Escriba una o varias direcciones de correo electrónico abajo. Separe cada dirección con una coma (,) o un punto y coma (;).</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">No puede establecer una alarma en una tarea que no haya vencido</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">antes de que venza la tarea</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">Aspecto</xsl:variable>

<xsl:variable name="settings_title">Configuración</xsl:variable>

<xsl:variable name="import_title">Importar</xsl:variable>

<xsl:variable name="export_title">Exportar</xsl:variable>

<xsl:variable name="settings_msg">Use este formulario para modificar el comportamiento de Calendar Express.</xsl:variable>

<xsl:variable name="default_view_title">Vista inicial predeterminada</xsl:variable>

<xsl:variable name="default_view_msg">Mostrar siempre la siguiente vista cuando se inicie sesión:</xsl:variable>

<xsl:variable name="default_group_title">Grupo de calendarios predeterminado</xsl:variable>

<xsl:variable name="default_group_msg">Mostrar siempre el siguiente grupo de calendarios cuando se inicie sesión:</xsl:variable>

<xsl:variable name="no_cal_group_title">No hay grupo de calendarios.</xsl:variable>

<xsl:variable name="date_format_msg">Mostrar fechas abreviadas en el siguiente orden:</xsl:variable>

<xsl:variable name="m_d_y_format_text">Mes, Día, Año</xsl:variable>

<xsl:variable name="d_m_y_format_text">Día, Mes, Año</xsl:variable>

<xsl:variable name="y_m_d_format_text">Año, Mes, Día</xsl:variable>

<xsl:variable name="date_delimiter_msg">Usar los siguientes caracteres para delimitar las fechas abreviadas:</xsl:variable>

<xsl:variable name="use_12_clock_msg">Formato de 12 horas</xsl:variable>

<xsl:variable name="use_24_clock_msg">Formato de 24 horas</xsl:variable>

<xsl:variable name="day_title">Día</xsl:variable>

<xsl:variable name="day_starts_msg">El día comienza a las:</xsl:variable>

<xsl:variable name="day_ends_msg">El día finaliza a las:</xsl:variable>

<xsl:variable name="day_interval_msg">Dividir días</xsl:variable>

<xsl:variable name="every_15_minutes_text">cada quince minutos</xsl:variable>

<xsl:variable name="every_half_hour_text">cada media hora</xsl:variable>

<xsl:variable name="every_hour_text">cada hora</xsl:variable>

<xsl:variable name="every_2_hours_text">cada dos horas</xsl:variable>

<xsl:variable name="every_four_hours_text">cada cuatro horas</xsl:variable>

<xsl:variable name="first_dow_title">Primer día de la semana</xsl:variable>

<xsl:variable name="sunday_title">Domingo</xsl:variable>

<xsl:variable name="monday_title">Lunes</xsl:variable>

<xsl:variable name="tuesday_title">Martes</xsl:variable>

<xsl:variable name="wednesday_title">Miércoles</xsl:variable>

<xsl:variable name="thursday_title">Jueves</xsl:variable>

<xsl:variable name="friday_title">Viernes</xsl:variable>

<xsl:variable name="saturday_title">Sábado</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">Excluir el sábado y el domingo de las vistas semanales y mensuales.</xsl:variable>

<xsl:variable name="default_tz_msg">De forma predeterminada, las fechas y las horas se muestran según la zona horaria siguiente:</xsl:variable>

<xsl:variable name="none_selected_title">Ninguno seleccionado</xsl:variable>

<xsl:variable name="single_tz_use_msg">Cuando se muestre un único calendario, utilizar su zona horaria</xsl:variable>

<xsl:variable name="tz_timescales_msg">Mostrar escala de tiempo para cada zona horaria del calendario visto</xsl:variable>

<xsl:variable name="event_task_reminders_title">Recordatorios de eventos y tareas</xsl:variable>

<xsl:variable name="email_reminder_msg">Enviarme un recordatorio por correo electrónico.</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">Especifique un intervalo de tiempo válido para los recordatorios.</xsl:variable>

<xsl:variable name="before_every_event_task_text">antes de todos los acontecimientos y tareas</xsl:variable>

<xsl:variable name="note_title">Nota:</xsl:variable>

<xsl:variable name="reminders_tip_msg">Si desea enviar recordatorios a varias direcciones de correo electrónico (por ejemplo, abc@empresa22.com, abc@sesta.com), separe las direcciones de correo electrónico con una coma (,) o con un punto y coma (;).</xsl:variable>

<xsl:variable name="event_notifications_title">Notificaciones de acontecimientos</xsl:variable>

<xsl:variable name="event_notifications_msg">Enviarme por correo electrónico una notificación cada vez que alguien programe eventos en mi calendario.</xsl:variable>

<xsl:variable name="only_one_email_msg">Sólo se permite una dirección de correo electrónico.</xsl:variable>

<xsl:variable name="alert_only_one_email">Especifique una sola dirección para la notificación de acontecimientos</xsl:variable>

<xsl:variable name="declined_events_delete_title">Eventos rechazados</xsl:variable>

<xsl:variable name="declined_events_delete_msg">No mostrar los eventos rechazados.</xsl:variable>

<xsl:variable name="appearance_msg">Use este formulario para modificar el aspecto de Calendar Express.</xsl:variable>

<xsl:variable name="color_scheme_title">Esquema de colores</xsl:variable>

<xsl:variable name="toolbar_title">Barra de herramientas</xsl:variable>

<xsl:variable name="icons_and_text_msg">Mostrar iconos y texto</xsl:variable>

<xsl:variable name="icons_only_msg">Mostrar sólo los iconos</xsl:variable>

<xsl:variable name="text_only_msg">Mostrar sólo texto</xsl:variable>

<xsl:variable name="display_font_title">Fuente de visualización</xsl:variable>

<xsl:variable name="face_title">Estilo</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">Tamaño</xsl:variable>

<xsl:variable name="larger_title">Más grande</xsl:variable>

<xsl:variable name="default_title">Predeterminado</xsl:variable>

<xsl:variable name="smaller_title">Más pequeño</xsl:variable>

<xsl:variable name="event_destination_title">Destino del acontecimiento</xsl:variable>

<xsl:variable name="session_expired_msg">Su sesión ha caducado</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">Debe especificar un calendario válido</xsl:variable>

<xsl:variable name="add_events_to_text">Agregar eventos a</xsl:variable>

<xsl:variable name="select_calendar_title">Seleccionar calendario:</xsl:variable>

<xsl:variable name="import_format_title">Formato de importación</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Formato de Outlook</xsl:variable>

<xsl:variable name="source_file_invalid_error">El archivo de origen especificado no era válido</xsl:variable>

<xsl:variable name="format_file_mismatch_error">El formato especificado no coincide con el del archivo de origen</xsl:variable>

<xsl:variable name="successful_import_msg">Archivo importado con éxito</xsl:variable>

<xsl:variable name="source_file_title">Archivo de origen</xsl:variable>

<xsl:variable name="date_range_title">Intervalo de fechas</xsl:variable>

<xsl:variable name="import_all_msg">Importar todos los eventos desde el archivo.</xsl:variable>

<xsl:variable name="invalid_date_range_error">El intervalo de fechas que ha especificado no es válido</xsl:variable>

<xsl:variable name="beginning_title">Empezando</xsl:variable>

<xsl:variable name="ending_title">Acabando</xsl:variable>

<xsl:variable name="calendars_to_export_title">Calendarios para exportar</xsl:variable>

<xsl:variable name="addarrow_title">Agregar >></xsl:variable>

<xsl:variable name="export_all_msg">Exportar todos los eventos.</xsl:variable>

<xsl:variable name="export_format_title">Formato de exportación</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">La hora de fin del día debe ser posterior a la hora de inicio del día</xsl:variable>

<xsl:variable name="save_changes_title">Guarda los cambios</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">Calendario actual:</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">Patrón de repetición</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">Modelo de repetición no válido: seleccione el día en el que se va a repetir</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">Modelo de repetición no válido: seleccione el día en el que se va a repetir</xsl:variable>

<xsl:variable name="recurrence_skips_title">No se puede omitir una instancia de un acontecimiento periódico sobre otra</xsl:variable>

<xsl:variable name="recurrence_same_day">No se pueden producir dos instancias de un acontecimiento periódico en el mismo día</xsl:variable>

<xsl:variable name="recurrence_privacy">No se puede cambiar la confidencialidad de sólo una instancia.</xsl:variable>

<xsl:variable name="every_day_title">Cada día</xsl:variable>

<xsl:variable name="every_weekday_title">Cada día de la semana</xsl:variable>

<xsl:variable name="every_title">Cada</xsl:variable>

<xsl:variable name="weekday_text">día de la semana</xsl:variable>

<xsl:variable name="weekendday_text">día de fin de semana</xsl:variable>

<xsl:variable name="m_w_f_text">lunes, miércoles y viernes</xsl:variable>

<xsl:variable name="t_th_text">martes y jueves</xsl:variable>

<xsl:variable name="sat_sun_text">sábado y domingo</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">Especifique un intervalo válido</xsl:variable>

<xsl:variable name="every_week_title">Cada semana</xsl:variable>

<xsl:variable name="weeks_text">semanas</xsl:variable>

<xsl:variable name="repeat_on_title">Repetir el</xsl:variable>

<xsl:variable name="sunday_abbrev">Dom</xsl:variable>

<xsl:variable name="monday_abbrev">Lun</xsl:variable>

<xsl:variable name="tuesday_abbrev">Mar</xsl:variable>

<xsl:variable name="wednesday_abbrev">Mié</xsl:variable>

<xsl:variable name="thursday_abbrev">Jue</xsl:variable>

<xsl:variable name="friday_abbrev">Vie</xsl:variable>

<xsl:variable name="saturday_abbrev">Sáb</xsl:variable>

<xsl:variable name="every_month_title">Cada mes</xsl:variable>

<xsl:variable name="months_text">meses</xsl:variable>

<xsl:variable name="ordinal_1">primer</xsl:variable>
<xsl:variable name="ordinal_2">segundo</xsl:variable>
<xsl:variable name="ordinal_3">tercer</xsl:variable>
<xsl:variable name="ordinal_4">cuarto</xsl:variable>
<xsl:variable name="ordinal_5">quinto</xsl:variable>
<xsl:variable name="ordinal_6">sexto</xsl:variable>
<xsl:variable name="ordinal_7">séptimo</xsl:variable>
<xsl:variable name="ordinal_8">octavo</xsl:variable>
<xsl:variable name="ordinal_9">noveno</xsl:variable>
<xsl:variable name="ordinal_10">décimo</xsl:variable>
<xsl:variable name="ordinal_11">undécimo</xsl:variable>
<xsl:variable name="ordinal_12">duodécimo</xsl:variable>
<xsl:variable name="ordinal_13">decimotercero</xsl:variable>
<xsl:variable name="ordinal_14">decimocuarto</xsl:variable>
<xsl:variable name="ordinal_15">decimoquinto</xsl:variable>
<xsl:variable name="ordinal_16">decimosexto</xsl:variable>
<xsl:variable name="ordinal_17">decimoséptimo</xsl:variable>
<xsl:variable name="ordinal_18">decimoctavo</xsl:variable>
<xsl:variable name="ordinal_19">decimonoveno</xsl:variable>
<xsl:variable name="ordinal_20">vigésimo</xsl:variable>
<xsl:variable name="ordinal_21">vigésimo primer</xsl:variable>
<xsl:variable name="ordinal_22">vigésimo segundo</xsl:variable>
<xsl:variable name="ordinal_23">vigésimo tercer</xsl:variable>
<xsl:variable name="ordinal_24">vigésimo cuarto</xsl:variable>
<xsl:variable name="ordinal_25">vigésimo quinto</xsl:variable>
<xsl:variable name="ordinal_26">vigésimo sexto</xsl:variable>
<xsl:variable name="ordinal_27">vigésimo séptimo</xsl:variable>
<xsl:variable name="ordinal_28">vigésimo octavo</xsl:variable>
<xsl:variable name="ordinal_29">vigésimo noveno</xsl:variable>
<xsl:variable name="ordinal_30">trigésimo</xsl:variable>
<xsl:variable name="ordinal_31">trigésimo primer</xsl:variable>

<xsl:variable name="day_of_month_text">día del mes</xsl:variable>
<xsl:variable name="cap_last_text">Último</xsl:variable>

<xsl:variable name="of_month_text">del mes</xsl:variable>

<xsl:variable name="every_year_text">Cada año</xsl:variable>

<xsl:variable name="years_text">años</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">Se trata de un evento que se repite. ¿Desea eliminar sólo este evento o desea eliminarlos todos?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">Se trata de un evento que se repite. ¿Desea aplicar el cambio sólo a este evento o a todos?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">Se trata de una tarea que se repite. ¿Desea eliminar sólo esta tarea o desea eliminarlas todas?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">Se trata de una tarea que se repite. ¿Desea aplicar el cambio sólo a esta tarea o a todas?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">Resumen</xsl:variable>

<xsl:variable name="reply_title">Responder</xsl:variable>

<xsl:variable name="will_attend_msg">Asistiré</xsl:variable>

<xsl:variable name="will_not_attend_msg">NO asistiré</xsl:variable>

<xsl:variable name="confirm_later_msg">Confirmaré más adelante</xsl:variable>

<xsl:variable name="reply_reminders_msg">Para programar el envío de recordatorios mediante correos electrónicos aquí, especifique las direcciones de correo electrónico (separadas por comas o por puntos y comas) y elija una fecha y una hora para su envío.</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">No se puede establecer una alarma para un acontecimiento sin confirmación antes de que comience el acontecimiento</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">Use el siguiente espacio para proporcionar información adicional con el recordatorio. El título, la fecha, la hora y la ubicación del evento se incluyen automáticamente en todos los recordatorios.</xsl:variable>

<xsl:variable name="cal_select_msg">Seleccione el calendario en el que desea almacenar el evento</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">Buscar calendarios: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">Búsqueda de calendarios</xsl:variable>

<xsl:variable name="cal_search_msg1">Buscar calendarios que</xsl:variable>
        
<xsl:variable name="name_or_id_text">nombre o ID</xsl:variable>

<xsl:variable name="name_text">nombre</xsl:variable>

<xsl:variable name="primary_owner_text">propietario principal</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">contiene</xsl:variable>

<xsl:variable name="begins_with_text">empieza por</xsl:variable>

<xsl:variable name="search_plain_title">Buscar</xsl:variable>

<xsl:variable name="already_selected_cals_title">Calendarios ya seleccionados</xsl:variable>

<xsl:variable name="cal_id_title">Id. de calendario</xsl:variable>

<xsl:variable name="search_results_title">Resultados de búsqueda</xsl:variable>

<xsl:variable name="no_match_found_msg">No se encuentran coincidencias</xsl:variable>

<xsl:variable name="owner_title">Propietario</xsl:variable>

<xsl:variable name="owner_name_colon_title">Nombre del propietario:</xsl:variable>

<xsl:variable name="cal_name_title">Nombre de calendario</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">Buscar: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">Buscar eventos y tareas que contengan</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">Buscar usuarios: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">Búsqueda de usuario</xsl:variable>

<xsl:variable name="search_local_msg">Buscar en directorio local</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(Especifique el nombre, el apellido o el ID de usuario.)</xsl:variable>

<xsl:variable name="legend_title">Leyenda:</xsl:variable>

<xsl:variable name="resource_title">Recurso:</xsl:variable>

<xsl:variable name="already_selected_users_title">Usuarios ya seleccionados</xsl:variable>

<xsl:variable name="name_userid_title">Nombre (ID de usuario)</xsl:variable>

<xsl:variable name="name_title">Nombre</xsl:variable>

<xsl:variable name="userid_title">Id. de usuario</xsl:variable>

<xsl:variable name="email_title">Correo electrónico</xsl:variable>

<xsl:variable name="for_text">para</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">Lista de tareas: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">Use este panel para realizar un seguimiento de todas las cosas que tiene que hacer. Puede marcar las tareas como completadas haciendo clic en las casillas de verificación de la columna "Hecho". Haga clic en "Guardar y cerrar" para confirmar los cambios.</xsl:variable>

<xsl:variable name="done_title">Realizada</xsl:variable>

<xsl:variable name="task_title">ar tarea</xsl:variable>

<xsl:variable name="select_all_title">Seleccionar todos</xsl:variable>

<xsl:variable name="alert_processing">En proceso</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">tareas</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">Ayuda</xsl:variable>

<xsl:variable name="logout_text">Cerrar sesión</xsl:variable>

<xsl:variable name="login_text">inicio de sesión</xsl:variable>

<xsl:variable name="home_text">Inicio</xsl:variable>

<xsl:variable name="alt_schedule_msg">Planificar una reunión, un cumpleaños u otro acontecimiento</xsl:variable>

<xsl:variable name="new_event_title">Nuevo acontecimiento</xsl:variable>

<xsl:variable name="alt_todo_msg">Agregar un elemento a la lista de cosas que tiene que hacer</xsl:variable>

<xsl:variable name="new_task_title">Nueva tarea</xsl:variable>

<xsl:variable name="jump_to_title">Pasar a</xsl:variable>

<xsl:variable name="alt_print_msg">Abrir una versión de la vista actual que se pueda imprimir</xsl:variable>

<xsl:variable name="printable_title">Imprimible</xsl:variable>

<xsl:variable name="alt_search_msg">Buscar eventos y tareas</xsl:variable>

<xsl:variable name="alt_new_calendar">Crear un calendario nuevo</xsl:variable>

<xsl:variable name="new_cal_title">Calendario nuevo</xsl:variable>

<xsl:variable name="alt_new_group">Crear un grupo nuevo de calendarios</xsl:variable>

<xsl:variable name="new_group_title">Nuevo grupo</xsl:variable>

<xsl:variable name="alt_search_cals">Buscar calendarios</xsl:variable>

<xsl:variable name="subscribe_title">Suscribirse</xsl:variable>

<xsl:variable name="paren_subscribed_title">(Suscrito)</xsl:variable>

<xsl:variable name="alt_jump_next_week">Pasar a la semana siguiente</xsl:variable>

<xsl:variable name="alt_jump_prev_week">Pasar a la semana anterior</xsl:variable>

<xsl:variable name="sunday_letter_title">D</xsl:variable>
<xsl:variable name="monday_letter_title">L</xsl:variable>
<xsl:variable name="tuesday_letter_title">M</xsl:variable>
<xsl:variable name="wednesday_letter_title">Mi</xsl:variable>
<xsl:variable name="thursday_letter_title">M</xsl:variable>
<xsl:variable name="friday_letter_title">V</xsl:variable>
<xsl:variable name="saturday_letter_title">D</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">Los eventos seleccionados se eliminarán del calendario. En el caso de los eventos recurrentes, sólo se eliminarán las instancias que presenten errores. Haga clic en "Aceptar" para continuar.</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">Al crear un acontecimiento mientras se muestra un grupo de calendarios, invitar a todos los calendarios del grupo</xsl:variable>

<xsl:variable name="invite_this_group_msg">Al crear un acontecimiento mientras se muestra este grupo de calendarios, invitar a todos los calendarios del grupo</xsl:variable>

<xsl:variable name="group_invitations_title">Invitaciones de grupo</xsl:variable>

<xsl:variable name="starting_at_txt">Empezando a las</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">desconocido</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">No hay participantes.</xsl:variable>

<xsl:variable name="today_title">Hoy</xsl:variable>

<xsl:variable name="confirm_event_delete_text">¿Desea eliminar este evento?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">¿Desea eliminar esta tarea?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">La conexión con la base de datos de fondo (backend) ha fallado.</xsl:variable>
<xsl:variable name="dwp_max_connections_error">Se ha alcanzado el máximo de conexiones a la base de datos de fondo (backend).</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">No se puede acceder a la base de datos de fondo (backend) con datos erróneos.</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">No se puede resolver el calendario.</xsl:variable>
<xsl:variable name="dwp_down_error">no está conectada</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">El contexto del host DWP no está disponible.</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">El host de fondo (backend) no se puede resolver.</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">No hay datos: no se puede acceder a la base de datos de fondo (backend).</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">Incluir este evento en el cálculo de la disponibilidad.</xsl:variable>
<xsl:variable name="freebusy_title">Libre/Ocupado</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">Está creando un evento de todo el día que se utilizará para calcular su disponibilidad. Si esto es correcto, pulse \'Cancelar\' para volver atrás y desactive la casilla que hace referencia al estado libre u ocupado.</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">Está creando un evento privado que se utilizará para calcular su disponibilidad. Si esto es correcto, pulse \'Cancelar\' para volver atrás y desactive la casilla que hace referencia al estado libre u ocupado.</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">La base de datos del calendario está en modo de sólo lectura.</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Sin fecha final </xsl:variable>
<xsl:variable name="cap_the_text">El </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Eliminar</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Bienvenido/a  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tareas para </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>el calendario de</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Iniciar a las </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 hora</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutos</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Más de 1 hora</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> (disponible)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Crea un máximo de </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instancias</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Se puede asociar una o más zonas horarias de cualquier región con el calendario actual. En vistas de rejilla como la vista del día, todas las zonas horarias asociadas con el calendario pasan a formar parte de la escala horaria de la vista. Si no se especifica ninguna zona horaria con este calendario, se utilizará la zona horaria predeterminada. Las zonas horarias siguientes están disponibles en la región </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Se puede asociar una zona horaria de cualquier región con el calendario actual. En vistas de rejilla como la vista del día, la zona horaria asociada con el calendario pasa a formar parte de la escala horaria de la vista. Si no se especifica ninguna zona horaria con este calendario, se utilizará la zona horaria predeterminada. Las zonas horarias siguientes están disponibles en la </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>América del Norte/América del Sur </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europa/África </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asia/Pacífico Sur </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>región:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>El siguiente evento lo ha agregado a su calendario "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Puede aceptar o rechazar esta invitación seleccionando la opción adecuada para responder.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Haga clic en</xsl:text>&nbsp;
  <B><xsl:text>Examinar...</xsl:text></B>&nbsp;
  <xsl:text>para seleccionar un archivo.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Use este panel para aceptar, </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> rechazar </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> o dejar sin respuesta </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> invitaciones a eventos.</xsl:text>
  <br/>
  <xsl:text>En el caso de los eventos recurrentes, la configuración se aplicará a toda la secuencia.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Los resultados de una búsqueda con menos de </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caracteres puede que no esté completo. Para obtener mejores resultados, use como mínimo </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caracteres.</xsl:text>

</xsl:template>


</xsl:stylesheet>
