<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<!--
<xsl:variable name="Delete_Text">
¿Seguro que desea eliminar esta tarea?
</xsl:variable>
-->

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>	
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Editar tarea: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 2">
              <xsl:call-template name="reminders_root"/>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 4">
              <xsl:call-template name="preview_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (new_task.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>

<FORM name="form" method="post">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Elaborar tarea</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Recordatorios</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">4</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Vista preliminar</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[4]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
 <xsl:attribute name="onload">
     window.focus();
     document.forms[0].summary.focus();
 </xsl:attribute>


<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isnotdue"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_notdue"/></xsl:attribute></INPUT>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <TD colspan="2"  align="right"><FONT face="{$font_name}" size="{$font_size_big_2}">
	<B>Calendario <xsl:text>&nbsp;</xsl:text></B>
     <xsl:variable name="selectedCalid">
       <xsl:value-of select="../taskdata/Task/@e_Calid"/>
     </xsl:variable>
     <xsl:choose>
     <xsl:when test="(../taskdata/Task/@e_isNewTask = 'true')">
     <SELECT name="new_calid">
       <xsl:for-each select="/calendar/usrctx/calendarList/calID">
	<xsl:if test="(string-length(@error) = 0) and (string-length(@permission) = 0)">
         <OPTION value="{@name}">
           <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="@name"/>
            <xsl:with-param name="printname" select="@printableName"/>
          </xsl:call-template>
           <xsl:if test="$selectedCalid = @name">
             <xsl:attribute name="selected"/>
           </xsl:if>
         </OPTION>
        </xsl:if>
       </xsl:for-each>

       <xsl:attribute name="onChange">
       var f = parent.frames[1].document.forms[0];
       f['myaction'].value='change_calendar';
       f.submit();
       </xsl:attribute>
     </SELECT>
     </xsl:when>
     <xsl:otherwise>
     <SELECT name="new_calid">
       <xsl:for-each select="/calendar/usrctx/calendarList/calID">
	<xsl:if test="(string-length(@error) = 0) and ((string-length(@permission) = 0) or ($selectedCalid = @name))">
         <OPTION value="{@name}">
           <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="@name"/>
            <xsl:with-param name="printname" select="@printableName"/>
          </xsl:call-template>
           <xsl:if test="$selectedCalid = @name">
             <xsl:attribute name="selected"/>
           </xsl:if>
         </OPTION>
        </xsl:if>
       </xsl:for-each>

       <xsl:attribute name="onChange">
       var f = parent.frames[1].document.forms[0];
       f['myaction'].value='change_calendar';
       f.submit();
       </xsl:attribute>
     </SELECT>
    </xsl:otherwise>
    </xsl:choose>
    </FONT>
    </TD>
    </TR>
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Título de la tarea</B></FONT></TD>
    <TD valign="baseline"><INPUT type="text" name="summary" size="42" >
    <xsl:attribute name="value">
      <xsl:choose>
        <xsl:when test="(../taskdata/Task/@e_isNewTask = 'true') and (string-length(../taskdata/Task/@e_Summary) = 0)">
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="../taskdata/Task/@e_Summary"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    </INPUT></TD>
  </TR>
  <TR>
    <TD colspan="2" align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">INVALID_STARTDATETIME</xsl:with-param>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Fecha de vencimiento</B></FONT></TD>
    <TD valign="baseline">
      <INPUT type="radio" name="notdue" value="isdue">
        <xsl:if test="../taskdata/Task/@e_notdue != '1'">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_notdue']) {
             document.forms[0]['e_notdue'].value = '0';
          }
        </xsl:attribute>
    </INPUT>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:choose>
      <xsl:when test="../taskdata/Task/@e_notdue = 1">
        <xsl:call-template name="date_selector">
        <xsl:with-param name="month" select="../timectx/CurrTime/@month" />
        <xsl:with-param name="day" select="../timectx/CurrTime/@date" />
        <xsl:with-param name="year" select="../timectx/CurrTime/@year" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
      <xsl:call-template name="date_selector">
        <xsl:with-param name="month" select="../taskdata/Task/DueTime/@month" />
        <xsl:with-param name="day" select="../taskdata/Task/DueTime/@date" />
        <xsl:with-param name="year" select="../taskdata/Task/DueTime/@year" />
        <xsl:with-param name="checkFunction" select="'allowEmptyDateCheck'" />
      </xsl:call-template>
      </xsl:otherwise>
      </xsl:choose>
      <A>
        <xsl:attribute name="href">
          <xsl:value-of select="command[@name='jump_to']"/>
        </xsl:attribute>
        <IMG src="imx/goto2.gif" width="24" height="24" align="absmiddle" border="0" alt="Pasar a nueva fecha"/>
      </A>
      <xsl:text>&nbsp;&nbsp;</xsl:text>
      <INPUT type="radio" name="notdue" value="notdue">
        <xsl:if test="../taskdata/Task/@e_notdue = 1"> 
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          var f = document.forms[0];
           if (f['e_notdue']) {
             f['e_notdue'].value = '1';
           }
           f.allday[1].checked = true;
           if (f['e_allday']) {
             f['e_allday'].value = '1';
           }
            f['mm'].value = '<xsl:value-of select="../timectx/CurrTime/@month"/>';
            f['dd'].value = '<xsl:value-of select="../timectx/CurrTime/@date"/>';
            f['ccyy'].value = '<xsl:value-of select="../timectx/CurrTime/@year"/>';
            <xsl:choose>
              <xsl:when test="/calendar/usrctx/userprefs/@ceClock='12'">
                  f['hr'].value = '12';
                  f['mn'].value = '00';
                  f['pm'].selectedIndex = 0;
                </xsl:when>
                <xsl:otherwise>
                  f['hr'].value = '00';
                  f['mn'].value = '00';
                </xsl:otherwise>
              </xsl:choose>
        </xsl:attribute>
      </INPUT>
    <FONT face="{$font_name}" size="{$font_size_big_2}">Sin vencimiento</FONT></TD>
  </TR>
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Hora</B></FONT></TD>
    <TD>
    <INPUT type="radio" name="allday" value="timed">
        <xsl:if test="../taskdata/Task/@e_allday != '1'">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_allday']) {
             document.forms[0]['e_allday'].value = '0';
          }
        </xsl:attribute>
    </INPUT>
      <xsl:text>&nbsp;</xsl:text>
    <xsl:choose>
      <xsl:when test="(../taskdata/Task/@e_allday='1') or (../taskdata/Task/@e_notdue='1')">
      <xsl:call-template name="time_select">
        <xsl:with-param name="start_hour">00</xsl:with-param>
        <xsl:with-param name="start_min">00</xsl:with-param>
      </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
      <xsl:call-template name="time_select">
        <xsl:with-param name="start_hour" select="../taskdata/Task/DueTime/@hour"/>
        <xsl:with-param name="start_min" select="../taskdata/Task/DueTime/@minute"/>
      </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>

      <xsl:text>&nbsp;&nbsp;</xsl:text>
        <INPUT type="radio" name="allday" value="allday">
          <xsl:if test="../taskdata/Task/@e_allday = 1"> 
            <xsl:attribute name="checked"/>
          </xsl:if>
          <xsl:attribute name="onClick">
             if (document.forms[0]['e_allday']) {
               document.forms[0]['e_allday'].value = '1';
             }
             <xsl:choose>
               <xsl:when test="/calendar/usrctx/userprefs/@ceClock='12'">
                  document.forms[0]['hr'].value = '12';
                  document.forms[0]['mn'].value = '00';
                  document.forms[0]['pm'].selectedIndex = 0;
                </xsl:when>
                <xsl:otherwise>
                  document.forms[0]['hr'].value = '00';
                  document.forms[0]['mn'].value = '00';
                </xsl:otherwise>
              </xsl:choose>
          </xsl:attribute>
        </INPUT>
        <FONT face="{$font_name}" size="{$font_size_big_2}">Sin hora</FONT>
        </TD>
      </TR>
  <TR>
    <TD></TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">

       <xsl:choose>
	  <xsl:when test="(string-length(../taskdata/Task/@e_uid) > 0) and (string-length(../taskdata/Task/@e_existingRRule) > 0)">
	    <xsl:call-template name="emitRecurChangePatternLinkTask">
            </xsl:call-template>
  	  </xsl:when>
          <xsl:otherwise>
            <INPUT type="checkbox" name="recurrence_enabled" value="repeat">
              <xsl:if test="string-length(../taskdata/Task/@e_existingRRule) > '0'"> 
                <xsl:attribute name="checked"/>
              </xsl:if>
              <xsl:attribute name="onClick">
                if (!(document.forms[0]['recurrence_enabled'].checked)) {
                  document.forms[0]['e_existingRRule'].value = '';
                  document.forms[0]['e_rruleChanged'].value = 'true';
                }
  	        <xsl:value-of select="command[@name='recurrence']"/>
              </xsl:attribute>
            </INPUT>
	    <xsl:call-template name="emitRecurChangePatternLinkTask">
            </xsl:call-template>
	  </xsl:otherwise>
	</xsl:choose>
      </FONT>
    </TD>
  </TR>
<!-- If the server is set up to handle event privacy -->
        <xsl:if test="../taskdata/@allowPrivacy">
       <TR>
   <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Privacidad</B></FONT></TD>
    <TD valign="baseline">
          <FONT face="{$font_name}" size="{$font_size_big_2}">
<!-- we ensure that confidential and private come out of the server in lower case -->
<!-- but they need to go back as upper case to be compliant with the standard -->
          <SELECT name="taskPrivacy">
            <OPTION value="PUBLIC">
            <xsl:if test="(not(../taskdata/Task/@e_Class)) or ((../taskdata/Task/@e_Class != 'confidential') and (../taskdata/Task/@e_Class != 'private'))">
              <xsl:attribute name="selected"/>
            </xsl:if>
            Tarea pública
           </OPTION>
           <OPTION value="CONFIDENTIAL">
           <xsl:if test="../taskdata/Task/@e_Class = 'confidential'">
             <xsl:attribute name="selected"/>
           </xsl:if>
           Sólo fecha y hora
           </OPTION>
           <OPTION value="PRIVATE">
           <xsl:if test="../taskdata/Task/@e_Class = 'private'">
             <xsl:attribute name="selected"/>
           </xsl:if>
           Tarea privada
           </OPTION>
         </SELECT>     
       </FONT>
     </TD>
   </TR>
   </xsl:if>
  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Ubicación</B>
      </FONT>
    </TD>
    <TD valign="baseline">
      <INPUT type="text" name="location" size="42">
        <xsl:attribute name="value">
          <xsl:value-of select="../taskdata/Task/@e_Location"/>
        </xsl:attribute>
      </INPUT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="top" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Descripción</B></FONT></TD>
    <TD colspan="2"><TEXTAREA cols="42" rows="5" name="description" wrap="virtual"><xsl:value-of select="../taskdata/Task/@e_Description"/></TEXTAREA></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
     <TD align="right" valign="baseline" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Estado</B></FONT></TD>
    <TD align="left" valign="baseline" nowrap="">
    <INPUT type="checkbox" name="completed">
      <xsl:if test="string-length(../taskdata/Task/@e_dtcompleted) > 0">
        <xsl:attribute name="checked"/>
      </xsl:if>                 
      <xsl:attribute name="onClick">
        if (document.forms[0]['e_dtcompleted'] &amp;&amp; document.forms[0]['completed'].value) {
          document.forms[0]['e_dtcompleted'].value = '';
        }
      </xsl:attribute>
    </INPUT>
    <FONT face="{$font_name}" size="{$font_size_big_2}">Finalizada</FONT></TD>
  </TR>
</TABLE>
</CENTER>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="reminders_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
 <xsl:attribute name="onload">
     window.focus();
     document.forms[0].Others.focus();
 </xsl:attribute>

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isnotdue"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_notdue"/></xsl:attribute></INPUT>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        Puede enviarse a sí mismo un correo electrónico que sirva como recordatorio de esta tarea. Escriba una o varias direcciones de correo electrónico abajo. Separe cada dirección con una coma (,) o un punto y coma (;).
    </FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>

  <!-- REMIND -->
  
  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Recordar</B>
      </FONT>
    </TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_3}">
      
      <INPUT type="checkbox" name="Remind">
        <xsl:if test="../taskdata/Task/@e_notdue=1">
          <xsl:attribute name="onClick">
            var f = document.forms[0];
            alert('No puede establecer una alarma en una tarea que no haya vencido');
            f['Remind'].checked = false;
          </xsl:attribute>
        </xsl:if>
        <xsl:if test="../taskdata/Task/@e_alarm_on = 1">
            <xsl:attribute name="checked"/>
        </xsl:if>
      </INPUT>
      
      <INPUT type="text" name="Others" size="35">
	<xsl:attribute name="value">
         <xsl:choose>
           <xsl:when test="string-length(../taskdata/Task/@e_alarm_emails) > 0">
            <xsl:value-of select="../taskdata/Task/@e_alarm_emails"/>
           </xsl:when>
           <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmEmail) > 0">
            <xsl:value-of select="/calendar/usrctx/userprefs/@ceDefaultAlarmEmail"/>
           </xsl:when>
           <xsl:when test="string-length(/calendar/usrctx/user/@mail) > 0">
            <xsl:value-of select="/calendar/usrctx/user/@mail"/>
           </xsl:when>
         </xsl:choose>
        </xsl:attribute>
        <xsl:choose>
         <xsl:when test="../taskdata/Task/@e_notdue=1">
          <xsl:attribute name="onChange">
            var f = document.forms[0];
            alert('No puede establecer una alarma en una tarea que no haya vencido');
            f['Others'].value = '';
            f['Remind'].checked = false;
          </xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
          <xsl:attribute name="onChange">
            var f = document.forms[0];
            if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
            } else {
              f['Remind'].checked = false;
            }
          </xsl:attribute>
         </xsl:otherwise>
        </xsl:choose>
      </INPUT>
      
      <!-- <xsl:value-of select="/calendar/usrctx/user/@fullName"/>&nbsp;
      &amp;lt;<xsl:value-of select="/calendar/usrctx/user/@mail"/>&amp;gt;
      -->

      </FONT>
     </TD>
  </TR>

  <!-- TRIGGER BEFORE TASK BEGINS -->

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B><xsl:text>&nbsp;</xsl:text></B>
      </FONT>
    </TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <INPUT type="radio" name="triggertype"  value="relative">
          <xsl:if test="../taskdata/Task/@e_alarm_absolute_trigger != 1">
            <xsl:attribute name="checked"/>
          </xsl:if>
          <xsl:choose>
           <xsl:when test="../taskdata/Task/@e_notdue=1">
            <xsl:attribute name="onChange">
             var f = document.forms[0];
             alert('No puede establecer una alarma en una tarea que no haya vencido');
             f['Others'].value = '';
             f['Remind'].checked = false;
            </xsl:attribute>
           </xsl:when>
          <xsl:otherwise>
	   <xsl:attribute name="onClick">
             var f = document.forms[0];
             if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
             } else {
              f['Remind'].checked = false;
             }
	   </xsl:attribute>
	  </xsl:otherwise>
         </xsl:choose>
        </INPUT>
        <xsl:call-template  name="time_before_selector">
          <xsl:with-param name="time_offset" select="../taskdata/Task/@e_alarm_offset"/>
          <xsl:with-param name="time_units" select="../taskdata/Task/@e_alarm_units"/>
          <xsl:with-param name="before_text">antes de que venza la tarea</xsl:with-param>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>

  <!-- ABSOLUTE TRIGGER TIME -->
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B><xsl:text>&nbsp;</xsl:text></B></FONT></TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <INPUT type="radio" name="triggertype" value="absolute">
        <xsl:if test="../taskdata/Task/@e_alarm_absolute_trigger = 1">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:choose>
           <xsl:when test="../taskdata/Task/@e_notdue=1">
            <xsl:attribute name="onChange">
             var f = document.forms[0];
             alert('No puede establecer una alarma en una tarea que no haya vencido');
             f['Others'].value = '';
             f['Remind'].checked = false;
            </xsl:attribute>
           </xsl:when>
          <xsl:otherwise>
	   <xsl:attribute name="onClick">
             var f = document.forms[0];
             if (f['Others'].value.length &gt; 0) {
              f['Remind'].checked = true;
             } else {
              f['Remind'].checked = false;
             }
	   </xsl:attribute>
	  </xsl:otherwise>
         </xsl:choose>
      </INPUT>
      </FONT>

<!-- Now allow the absoluate date/time selection -->
<!-- If we already have absolute date/time, use those values -->
<!-- If not then if it's not due, use currdate info with time as start of day -->
<!-- If it is due then use duedate and start of day for all day events or duetime if not -->
      <xsl:choose>
        <xsl:when test="../taskdata/Task/@e_alarm_absolute_trigger = 1">
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="../taskdata/Task/AbsoluteAlarmTime/@month"/>
            <xsl:with-param name="day" select="../taskdata/Task/AbsoluteAlarmTime/@date"/>
            <xsl:with-param name="year" select="../taskdata/Task/AbsoluteAlarmTime/@year"/>
            <xsl:with-param name="start_hour" select="../taskdata/Task/AbsoluteAlarmTime/@hour"/>
            <xsl:with-param name="start_min" select="../taskdata/Task/AbsoluteAlarmTime/@minute"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="../taskdata/Task/@e_notdue = 1">
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="../timectx/CurrTime/@month"/>
            <xsl:with-param name="day" select="../timectx/CurrTime/@date"/>
            <xsl:with-param name="year" select="../timectx/CurrTime/@year"/>
            <xsl:with-param name="start_hour" select="/calendar/usrctx/userprefs/@ceDayHead"/>
            <xsl:with-param name="start_min">00</xsl:with-param> 
          </xsl:call-template>
        </xsl:when>
        <xsl:when test="../taskdata/Task/@e_allday = 1">
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="../taskdata/Task/DueTime/@month"/>
            <xsl:with-param name="day" select="../taskdata/Task/DueTime/@date"/>
            <xsl:with-param name="year" select="../taskdata/Task/DueTime/@year"/>
            <xsl:with-param name="start_hour" select="/calendar/usrctx/userprefs/@ceDayHead"/>
            <xsl:with-param name="start_min">00</xsl:with-param> 
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="../taskdata/Task/DueTime/@month"/>
            <xsl:with-param name="day" select="../taskdata/Task/DueTime/@date"/>
            <xsl:with-param name="year" select="../taskdata/Task/DueTime/@year"/>
            <xsl:with-param name="start_hour" select="../taskdata/Task/DueTime/@hour"/>
            <xsl:with-param name="start_min" select="../taskdata/Task/DueTime/@minute"/>
<!-- This was in old version - is it still needed - why?? -->
<!--            <xsl:with-param name="checkFunction" select="'allowEmptyDateCheck'" /> -->
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </TD>
  </TR>

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        Puede enviar un mensaje de texto con el correo electrónico de recordatorio.
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="top" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>Mensaje</B>
      </FONT>
    </TD>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <TEXTAREA cols="42" rows="5" name="reminderMessage" wrap="virtual">
          <xsl:value-of select="../taskdata/Task/@e_alarm_description"/>
        </TEXTAREA>
      </FONT>
    </TD>
  </TR>
</TABLE>
</CENTER>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="preview_root">
<HTML>
<HEAD>
</HEAD>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/DueTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isnotdue"><xsl:attribute name="value"><xsl:value-of select="../taskdata/Task/@e_notdue"/></xsl:attribute></INPUT>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Título</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline" width="90%">
    <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text><xsl:value-of select="../taskdata/Task/@e_Summary"/></FONT></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Vence</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text>
        <xsl:choose>
          <xsl:when test="../taskdata/Task/@e_notdue='1'">
            Sin vencimiento
          </xsl:when>
          <xsl:when test="../taskdata/Task/@e_allday='1'">
            <xsl:call-template name="brief_date">
              <xsl:with-param name="Month" select="../taskdata/Task/DueTime/@month"/>
              <xsl:with-param name="Day" select="../taskdata/Task/DueTime/@date"/>
              <xsl:with-param name="Year" select="../taskdata/Task/DueTime/@year"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="task_date_at_time">
              <xsl:with-param name="dateA" select="../taskdata/Task/DueTime"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Ubicación</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT
face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text><xsl:value-of select="../taskdata/Task/@e_Location"/></FONT></TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Descripción</B></FONT></TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline"><FONT
face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text><xsl:value-of select="../taskdata/Task/@e_Description"/></FONT></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
  <xsl:call-template name="javascript_strings"/>
  <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>
  
<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <xsl:if test="(string-length(../taskdata/Task/@e_uid) > 0) and (../taskdata/Task/@e_writeAccessAllowed = 'true')">
      <TD align="left" bgcolor="{$bgcolor_button}">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
          <INPUT type="button" name="delete" width="72" value="Borrar">
            <xsl:attribute name="onClick">
              if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
               <xsl:value-of select="./command[@name='repeating_task_delete']"/>
              } else {
                <xsl:value-of select="./button[@name='delete']"/>
              }
            </xsl:attribute>
          </INPUT>
        </FONT>
      </TD>
    </xsl:if>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <xsl:choose>
          <xsl:when test="../taskdata/Task/@e_writeAccessAllowed = 'true'">
            <INPUT type="button" name="ok" width="72" value="Aceptar">
              <xsl:attribute name="onClick">
                if (parent.date_error == '1') {
                  parent.date_error = '0';
                  return;
                }
                <!-- Warn about absolute alarms if alarm is set to after the event -->
                var f = parent.frames[1].document.forms[0];
                var isampm = 0;
                var isalldaytask = 0;
             
                <!-- Does the time in the form have to be converted to 24 hour clock before comparison? -->
	        <xsl:if test="/calendar/usrctx/userprefs/@ceClock='12'">
                       isampm = 1;
                </xsl:if>

	        if((f['isallday'].value == 1) || (f['allday'] &amp;&amp; f['allday'][1].checked)) {
	  	  isalldaytask = 1;
    	        }

	        if ((f['isnotdue'].value != 1) || (f['notdue'] &amp;&amp; f['notdue'][0].checked)) {
	         <!-- Was absolute alarm set? -->
                 if ((f['absalarmset'].value == 1) || (f['triggertype'] &amp;&amp; f['triggertype'][1].checked)) {
                   if (comparetime(f, isampm, 'trig', isalldaytask) != 0) {
                    if(!confirm('El recordatorio para esta tarea está definido para una hora posterior a su vencimiento. Pulse \'Cancelar\' para volver atrás y cambiar la hora.')) {
                      return;
                    }
                   }
                 }
	        }
                if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
                  <xsl:value-of select="./command[@name='repeating_task_store']"/>
                } else {
                  <xsl:value-of select="./button[@name='ok']"/>
                }
              </xsl:attribute>
            </INPUT>
            <INPUT type="button" name="esc" width="72" value="Cancelar" onClick="{./button[@name='cancel']}"/>
          </xsl:when>
          <xsl:otherwise>
            <INPUT type="button" name="esc" width="72" value="Cerrar" onClick="{./button[@name='cancel']}"/>
          </xsl:otherwise>
        </xsl:choose>
        <INPUT type="button" name="help" width="72" value="Ayuda" onClick="{./button[@name='help']}"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
