<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<xsl:template match="panel">
  <xsl:choose>

    <xsl:when test="@name='singleYearTimeHeader'">
        <TR>
        <TD align="center" width="100%">
      <xsl:call-template name="singleYearTimeHeaderTemplate"/>
</TD>
</TR>
    </xsl:when>

    <xsl:when test="@name='singleYearView'">
<TR>
<TD align="center">
      <xsl:apply-templates select="yearcal"/>
</TD>
      </TR>
    </xsl:when>
 
    <xsl:otherwise>
<TABLE border="0" align="center">
      <xsl:apply-templates select="panel"/> 
</TABLE>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="yearcal">
  <xsl:for-each select="Row">
    <TABLE>
      <TR>
        <TD>
          <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
            <TR>
              <xsl:for-each select="yearminical">
                <TD bgcolor="{$bgcolor_table_border}" align="center" valign="top">
                  <xsl:call-template name="yearminical"/>        
                </TD>
                <TD align="center" valign="top" bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif">
                  <IMG src="imx/spacer.gif" width="1" height="1" hspace="3"/>
                </TD>
              </xsl:for-each>
            </TR>
          </TABLE>
        </TD>
      </TR>
    </TABLE>
  </xsl:for-each>
</xsl:template>

<!-- A simplified version of the minical -->
<xsl:template name="yearminical">
<!-- <TD width="1%" nowrap="" valign="top" align="center">-->
<TABLE border="0" cellpadding="1" cellspacing="0">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="2" cellspacing="1">
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
          <xsl:choose>
          <xsl:when test="$view='print'">
            <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
              <xsl:apply-templates select="@month"/>
            </FONT>
          </xsl:when>
          <xsl:otherwise>
            <A style="text-decoration:none;">
              <xsl:attribute name="href">
                <xsl:value-of select="command[1]"/>
              </xsl:attribute>
             <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
              <xsl:apply-templates select="@month"/>
             </FONT>
            </A>
          </xsl:otherwise>
          </xsl:choose>
        </TD>
      </TR>
      <TR>
        <xsl:for-each select="Row[1]/Time">
          <TD align="center">
            <xsl:attribute name="bgcolor">
              <xsl:choose>
                <xsl:when test="(@dow=1) or (@dow=7)">
                  <xsl:value-of select="$bgcolor_wend_top"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$bgcolor_table_top"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
              <xsl:call-template name="short_dow">
                <xsl:with-param name="downum" select="@dow"/>
              </xsl:call-template>
            </FONT>
          </TD>
       </xsl:for-each>
<!--
       <TD align="center" bgcolor="{$bgcolor_wend_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">S</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">M</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">D</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">M</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">D</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">f</FONT></TD>
       <TD align="center" bgcolor="{$bgcolor_wend_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">S</FONT></TD>
-->
      </TR>
      <xsl:for-each select="Row">
      <TR>
        <xsl:for-each select="Time">
          <TD align="right">
            <xsl:choose>
              <xsl:when test="../../@month!=@month">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_border"/>
                </xsl:attribute>

<!-- don't have link for a printout -->
        <xsl:choose>
        <xsl:when test="$view = 'print'">
                 <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}"><xsl:value-of select="@date"/>
                  </FONT>
        </xsl:when>
        <xsl:otherwise>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}"><xsl:value-of select="@date"/>
                  </FONT>
                </A>
        </xsl:otherwise>
        </xsl:choose>

              </xsl:when>
              <xsl:when test="(/calendar/timectx/SelectedTime/@month=@month) and (/calendar/timectx/SelectedTime/@date=@date)">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_selected"/>
                </xsl:attribute>
                <xsl:choose>
                  <xsl:when test="$view = 'print'">
                    <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_bold_text}">
                      <B><xsl:value-of select="@date"/></B>
                    </FONT>
                  </xsl:when>
                  <xsl:otherwise>
                    <A style="text-decoration:none;">
                      <xsl:attribute name="href">
                        <xsl:value-of select="command"/>
                      </xsl:attribute>
                      <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_bold_text}">
                        <B><xsl:value-of select="@date"/></B>
                      </FONT>
                    </A>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:when test="(@dow=1) or (@dow=7)">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_wend_mid"/>
                </xsl:attribute>

<!-- don't have link for a printout -->
        <xsl:choose>
        <xsl:when test="$view = 'print'">
                <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/>
                </FONT>
        </xsl:when>
        <xsl:otherwise>
              <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute>
                <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/>
                </FONT>
              </A>
        </xsl:otherwise>
        </xsl:choose>
              </xsl:when>

              <xsl:otherwise>
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_mid"/>
                </xsl:attribute>

<!-- don't have link for a printout -->
        <xsl:choose>
        <xsl:when test="$view = 'print'">
                  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/>
                  </FONT>
        </xsl:when>
        <xsl:otherwise>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/>
                  </FONT>
                </A>
        </xsl:otherwise>
<!-- the end of special case for printing -->
        </xsl:choose>

            </xsl:otherwise>
            </xsl:choose>
          </TD>
        </xsl:for-each>
      </TR>
      </xsl:for-each>
      <xsl:if test="count(Row)!=6">
        <TR>
          <TD colspan="7" align="center" bgcolor="{$bgcolor_table_border}" valign="top">
           <IMG src="imx/spacer.gif" width="1" height="1" hspace="3"></IMG>
          </TD>
        </TR>
      </xsl:if>
    </TABLE>
    </TD>
</TR>
</TABLE>
<TD bgcolor="{$bgcolor_table_border}" align="center" valign="top" background="imx/ltgrey.gif">
<IMG src="imx/spacer.gif" width="1" height="1" hspace="3"></IMG>
</TD>
</xsl:template>

<xsl:template name="singleYearTimeHeaderTemplate">
    <TABLE border="0" cellpadding="2" cellspacing="0" align="center">
    <TR>
      <TD width="1%" nowrap="">
      <A><xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute><IMG src="imx/ppage-1.gif" width="15" height="15" border="0" alt="Zum vorherigen Jahr wechseln" align="right"/></A><BR/><A><xsl:attribute name="href"><xsl:value-of select="command[2]"/></xsl:attribute><IMG src="imx/npage-1.gif" width="15" height="15" border="0" alt="Zum nächsten Jahr wechseln" align="right"/></A></TD>
      <TD nowrap="">
        <xsl:call-template name="yearTimeHeader"/>
      </TD>
<TD>&nbsp;</TD>
      <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>
      </TD>
    </TR>
    </TABLE>
</xsl:template>


</xsl:stylesheet>

