<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Ohne Titel
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Sonntag</xsl:if>
  <xsl:if test=".='2'">Montag</xsl:if>
  <xsl:if test=".='3'">Dienstag</xsl:if>
  <xsl:if test=".='4'">Mittwoch</xsl:if>
  <xsl:if test=".='5'">Donnerstag</xsl:if>
  <xsl:if test=".='6'">Freitag</xsl:if>
  <xsl:if test=".='7'">Samstag</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">S</xsl:if>
  <xsl:if test="$downum='2'">M</xsl:if>
  <xsl:if test="$downum='3'">D</xsl:if>
  <xsl:if test="$downum='4'">M</xsl:if>
  <xsl:if test="$downum='5'">D</xsl:if>
  <xsl:if test="$downum='6'">f</xsl:if>
  <xsl:if test="$downum='7'">S</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Jan</xsl:if>
  <xsl:if test=".='02'">Februar</xsl:if>
  <xsl:if test=".='03'">März</xsl:if>
  <xsl:if test=".='04'">April</xsl:if>
  <xsl:if test=".='05'">Mai</xsl:if>
  <xsl:if test=".='06'">Juni</xsl:if>
  <xsl:if test=".='07'">Juli</xsl:if>
  <xsl:if test=".='08'">Aug</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Okt</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dez</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Jan</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Februar</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">März</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Apr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juni</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juli</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Aug</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Okt</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dez</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Januar</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Februar</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">März</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">April</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juni</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juli</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">August</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">September</xsl:if>
  <xsl:if test="$MonthNum=10">Oktober</xsl:if>
  <xsl:if test="$MonthNum=11">November</xsl:if>
  <xsl:if test="$MonthNum=12">Dezember</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      Das eingegebene Datum und die Uhrzeit sind ungültig. Korrigieren Sie die
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Ein Kalender mit diesem Namen ist bereits vorhanden. Wählen Sie einen anderen Namen.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Eine Gruppe mit diesem Namen ist bereits vorhanden. Wählen Sie einen anderen Namen.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> bis </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Bei dieser Suche ist ein Problem mit dem Verzeichnisserver aufgetreten.&nbsp;      Geben Sie einen anderen Suchbegriff ein.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      Die Verbindung zum Verzeichnisserver konnte nicht aufgebaut werden.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      Die Verbindung zum Verzeichnisserver konnte nicht aufgebaut werden.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Bei dieser Suche ist ein Problem mit dem Verzeichnisserver aufgetreten.&nbsp;      Geben Sie einen anderen Suchbegriff ein.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE-Fehler: Ereignis wurde gelöscht
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE-Fehler: Nicht unterstützte Implementierung
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE-Fehler: malloc fehlgeschlagen
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE-Fehler: Erstellen mehrerer GSE-Instanzen nicht möglich
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE-Fehler: GSE-Eintrag ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE-Fehler: Ereignis ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE-Fehler: Transportschnittstelle nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE-Fehler: Teilnehmer im Organizer-Kalender nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE-Fehler: Erstellen der Ressource (z. B. lock, GDisp) nicht möglich
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE-Fehler: iCS-Benutzer erwartet, SMTP-Benutzer aufgefunden
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE-Fehler: Komponentenmethode und Status ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE-Fehler: Zeitkonflikt mit anderer Besprechungsanfrage
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB-Fehler: Komponente nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB-Fehler: E/A-Fehler
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB-Fehler: Mindestens ein Wert im Ereignis ist ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB-Fehler: Funktionsaufruf für die angegebene Komponente nicht zulässig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB-Fehler: Angeforderte Anfrage unbekannt oder nicht unterstützt
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB-Fehler: Ein erforderlicher Parameter ist NULL, nicht gesetzt oder nicht vorhanden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB-Fehler: Schreibvorgang abgebrochen, weil ein Fehler bei der angeforderten Bedingungsprüfung für die Folgenummer aufgetreten ist
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB-Fehler: Schreibvorgang abgebrochen, weil ein Fehler bei der angeforderten Bedingungsprüfung für die Bearbeitungszeit aufgetreten ist
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB-Fehler: Schreibvorgang wurde abgebrochen, weil überlappende Termine im Kalender nicht zulässig sind
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB-Fehler: ENS-Benachrichtigung hat einen Fehler zurückgegeben
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB-Fehler: Ein erforderlicher Wert ist NULL
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Teilnehmerfehler: Argument fehlerhaft
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Teilnehmerfehler: Kalender nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Teilnehmerfehler: Kalender deaktiviert
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Teilnehmerfehler: Benutzer besitzt keine Berechtigung zum Zugriff auf den Kalender
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Teilnehmerfehler: Gruppe wurde abgeschnitten
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Teilnehmerfehler: Organizer konnte nicht entfernt werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Kalenderfehler: Kalender konnte nicht erstellt werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Kalenderfehler: Kalender mit derselben ID bereits vorhanden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Kalenderfehler: Benutzer besitzt nicht die notwendige Zugriffsberechtigung für diesen Vorgang.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Kalenderfehler: Benutzer versucht, auf einen nicht vorhandenen Kalender zuzugreifen.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Kalenderfehler: Kalender-ID ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Teilnehmerfehler: Teilnehmer kann nicht doppelt eingeladen werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Kalenderfehler: Benutzer besitzt nicht die notwendige Zugriffsberechtigung für diesen Vorgang.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Kalenderfehler: Benutzer muss Besitzer oder Mitbesitzer sein, um diesen Vorgang ausführen zu können.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Kalenderfehler: Datenbank ist schreibgeschützt.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Ermitteln Sie die freien Zeiten auf der Registerkarte für die Verfügbarkeit.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Gruppenfehler: Gruppen-ID ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Kalenderfehler: Unbekannter Benutzer konnte nicht zur Privat- oder Besitzerliste hinzugefügt werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP-Fehler: Kein Mail-Host
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP-Fehler: Fehler bei Verbindung
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP-Fehler: Erwartete Reaktion auf Herstellung der Verbindung nicht erfolgt
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP-Fehler: Problem beim Adressieren der Nachricht
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP-Fehler: Kein Empfänger
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Fehler: Fehler bei Verbindung zur Back-End-Datenbank.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Fehler: Maximale Anzahl der Verbindungen zur Back-End-Datenbank erreicht.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Fehler: Kalender konnte nicht aufgelöst werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Fehler: Fehlerhafte Daten - Back-End-Datenbank ist nicht erreichbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Fehler: DWP-Host-Kontext nicht verfügbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Fehler: Back-End-Host konnte nicht aufgelöst werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Fehler: Keine Daten - Back-End-Datenbank ist nicht erreichbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Fehler: Fehler bei Verbindung zur Back-End-Datenbank.
    </xsl:when>
    <xsl:otherwise>
      Unbekannt Fehler #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Fehler: Eine Instanz einer Terminserie kann nicht eine andere Instanz überspringen.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Fehler: Zwei Instanzen einer Terminserie können nicht an demselben Tag eintreten.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Fehler: Kennzeichnung als privat für nur eine Instanz konnte nicht geändert werden.
    </xsl:when>
    <xsl:otherwise>
      Unbekannter Fehler bei Terminserie #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">Amerika/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">Amerika/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">Amerika/Los Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">Amerika/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">Amerika/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">Amerika/Costa Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">Amerika/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">Amerika/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">Amerika/New York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">Amerika/Havanna</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">Amerika/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">Amerika/Grand Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">Amerika/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">Amerika/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">Amerika/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">Amerika/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantik/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">Amerika/St. John's</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">Amerika/Buenos Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">Amerika/Sao Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">Amerika/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">Amerika/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantik/Südgeorgien</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantik/Kap Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantik/Azoren</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Afrika/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europa/London</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Afrika/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europa/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Afrika/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europa/Warschau</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Afrika/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europa/Bukarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europa/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Afrika/Kairo</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europa/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Afrika/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europa/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europa/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europa/Moskau</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europa/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asien/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asien/Jerusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asien/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asien/Riad</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asien/Teheran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asien/Eriwan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asien/Aktau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asien/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asien/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asien/Karatschi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asien/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asien/Bischkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asien/Jekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asien/Kalkutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asien/Katmandu</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asien/Dhaka</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asien/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asien/Nowosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asien/Rangun</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asien/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asien/Krasnojarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asien/Ulan-Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asien/Schanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asien/Taipeh</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asien/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asien/Tokio</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asien/Seoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asien/Jakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australien/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australien/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australien/Adelaide</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australien/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australien/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australien/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asien/Wladiwostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australien/Lord-Howe-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pazifik/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pazifik/Nouméa</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asien/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pazifik/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pazifik/Fidschi</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pazifik/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asien/Kamtschatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pazifik/Chatham-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pazifik/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asien/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pazifik/Weihnachtsinsel</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pazifik/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pazifik/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pazifik/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pazifik/Marquesas-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pazifik/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pazifik/Pitcairninseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pazifik/Osterinsel</xsl:when> 
    <xsl:otherwise>
      Unbekannt Zeitzone #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">OK</xsl:variable>

<xsl:variable name="cancel_title">Abbrechen</xsl:variable>
<xsl:variable name="close_title">Schließen</xsl:variable>
<xsl:variable name="help_title">Hilfe</xsl:variable>
<xsl:variable name="apply_title">Übernehmen</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">Keine Termine oder Aufgaben</xsl:variable>
<xsl:variable name="week_ahead_title">Die kommende Woche</xsl:variable>
<xsl:variable name="alt_text_schedule">Planen eines neuen Termins</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">Geben Sie im Folgenden einen Benutzernamen ein und klicken Sie auf "OK".</xsl:variable>

<xsl:variable name="user_name_title">Benutzername</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">Zum vorherigen Tag wechseln</xsl:variable>

<xsl:variable name="alt_jump_next_day">Zum nächsten Tag wechseln</xsl:variable>

<xsl:variable name="alt_jump_new_date">Zu einem neuen Datum wechseln</xsl:variable>

<xsl:variable name="available_title">Verfügbar</xsl:variable>

<xsl:variable name="busy_title">Belegt</xsl:variable>

<xsl:variable name="hour_text">Stunde</xsl:variable>
<xsl:variable name="minutes_text">Minuten</xsl:variable>

<xsl:variable name="show_availability_title">Freie Zeiten anzeigen</xsl:variable>

<xsl:variable name="error_cal_privacy">Sie können diesen Kalender nicht anzeigen lassen. Der Kalender ist als privat gekennzeichnet oder nicht vorhanden.</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">Nord-/Südamerika</xsl:variable>

<xsl:variable name="europe_africa_title">Europa/Afrika</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">Asien/Pazifische Randgebiete</xsl:variable>

<xsl:variable name="time_zone_title">Zeitzone</xsl:variable>

<xsl:variable name="gmt_offset_title">Abweichung von GMT</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">Gruppen</xsl:variable>

<xsl:variable name="groups_msg">Mit einer Kalendergruppe lassen Sie mehrere Kalender gleichzeitig anzeigen. Zum Öffnen einer Kalendergruppe klicken Sie auf den Link mit dem Gruppennamen. Um einen Kalender in eine Gruppe aufzunehmen oder daraus zu entfernen, klicken Sie auf den Link "Bearbeiten".</xsl:variable>

<xsl:variable name="select_title">Auswählen</xsl:variable>

<xsl:variable name="group_title">Gruppe</xsl:variable>

<xsl:variable name="group_colon_title">Gruppe:</xsl:variable>

<xsl:variable name="description_title">Beschreibung</xsl:variable>

<xsl:variable name="properties_title">Eigenschaften</xsl:variable>

<xsl:variable name="error_cal_access">Sie besitzen keine Berechtigung für den Zugriff auf diesen Kalender.</xsl:variable>

<xsl:variable name="error_cal_not_exist">Dieser Kalender ist nicht vorhanden.</xsl:variable>

<xsl:variable name="edit_title">Bearbeiten</xsl:variable>
<xsl:variable name="edit_calendar_title">Kalender bearbeiten</xsl:variable>

<xsl:variable name="remove_selected_title">Auswahl entfernen</xsl:variable>

<xsl:variable name="calendars_title">Kalender</xsl:variable>

<xsl:variable name="calendars_msg">Liste der Kalender, die Sie besitzen oder abonniert haben. Zum Öffnen eines Kalenders klicken Sie auf den Kalendernamen. Um einen Kalender zu bearbeiten, klicken Sie auf "Bearbeiten".</xsl:variable>

<xsl:variable name="calendar_title">Kalender-</xsl:variable>

<xsl:variable name="view_title">Ansicht</xsl:variable>
<xsl:variable name="view_calendar_title">Kalender anzeigen</xsl:variable>

<xsl:variable name="view_colon_title">Ansicht:</xsl:variable>

<xsl:variable name="options_title">Optionen</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">Standard-Zeitzone ändern: Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">Übersicht</xsl:variable>

<xsl:variable name="day_tab_title">Tag</xsl:variable>

<xsl:variable name="week_tab_title">Woche</xsl:variable>

<xsl:variable name="month_tab_title">Monat</xsl:variable>

<xsl:variable name="year_tab_title">Jahr</xsl:variable>

<xsl:variable name="comparison_tab_title">Vergleichsansicht</xsl:variable>

<xsl:variable name="repeat_title">Wiederholung</xsl:variable>

<xsl:variable name="change_repeat_title">Wiederholungsmuster ändern</xsl:variable>

<xsl:variable name="alt_jump_prev_month">Zum vorherigen Monat wechseln</xsl:variable>

<xsl:variable name="alt_jump_next_month">Zum nächsten Monat wechseln</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">Heute ist: </xsl:variable>

<xsl:variable name="alt_jump_this_date">Zum angegebenen Datum wechseln</xsl:variable>

<xsl:variable name="action_items_title">Tätigkeiten</xsl:variable>

<xsl:variable name="invitations_title">Einladungen</xsl:variable>

<xsl:variable name="no_invitations_msg">Keine Einladungen</xsl:variable>

<xsl:variable name="tasks_title">Aufgaben</xsl:variable>

<xsl:variable name="overdue_msg">Überfällig</xsl:variable>

<xsl:variable name="no_tasks_msg">Keine Aufgaben</xsl:variable>

<xsl:variable name="errors_title">Fehler</xsl:variable>

<xsl:variable name="no_errors_msg">Keine Fehler</xsl:variable>

<xsl:variable name="daily_title">Täglich</xsl:variable>

<xsl:variable name="weekly_title">Wöchentlich</xsl:variable>

<xsl:variable name="monthly_title">Monatlich</xsl:variable>

<xsl:variable name="yearly_title">Jährlich</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">Wiederkehrende Auswahl: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">Nur Auswahl</xsl:variable>

<xsl:variable name="this_and_future_title">Diese und zukünftige</xsl:variable>

<xsl:variable name="all_instances_title">Alle Instanzen</xsl:variable>

<xsl:variable name="repeating_selection_title">Auswahl wiederholen</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">Heute fällig</xsl:variable>

<xsl:variable name="other_tasks_title">Andere Aufgaben</xsl:variable>

<xsl:variable name="overdue_tasks_title">Überfällige Aufgaben</xsl:variable>

<xsl:variable name="all_day_events_title">Ganztägige Termine</xsl:variable>

<xsl:variable name="conflict_msg">Konflikt</xsl:variable>

<xsl:variable name="overdue_title">Überfällig</xsl:variable>

<xsl:variable name="due_at_title">Fällig um</xsl:variable>

<xsl:variable name="untitled_task_title">Unbenannte Aufgabe</xsl:variable>

<xsl:variable name="alt_view_this_task">Diese Aufgabe anzeigen</xsl:variable>

<xsl:variable name="alt_delete_this_task">Diese Aufgabe löschen</xsl:variable>

<xsl:variable name="untitled_event_title">Unbenannter Termin</xsl:variable>

<xsl:variable name="alt_delete_this_event">Dieses Ereignis löschen</xsl:variable>

<xsl:variable name="alt_view_this_event">Diesen Termin anzeigen</xsl:variable>

<xsl:variable name="all_day_title">Ganzer Tag</xsl:variable>

<xsl:variable name="overdue_from_title">Überfällig seit</xsl:variable>

<xsl:variable name="from_txt">seit</xsl:variable>

<xsl:variable name="due_on_title">Fällig am</xsl:variable>

<xsl:variable name="not_due_title">Nicht fällig</xsl:variable>

<xsl:variable name="due_title">Fällig</xsl:variable>

<xsl:variable name="on_txt">am</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">am</xsl:variable>

<xsl:variable name="pm_txt">pm</xsl:variable>

<xsl:variable name="midnight_title">Mitternacht</xsl:variable>

<xsl:variable name="noon_title">Mittag</xsl:variable>

<xsl:variable name="from_title">Von</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">Planen eines neuen Termins</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">Fehlerliste: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">Dieses Fenster zeigt eine Liste der noch nicht behobenen Planungsfehler.</xsl:variable>

<xsl:variable name="organizer_title">Organisator</xsl:variable>

<xsl:variable name="attendee_title">Teilnehmer</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">Keine ungelösten Fehler</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">Terminserie: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">Wiederholung</xsl:variable>

<xsl:variable name="start_title">Beginn</xsl:variable>

<xsl:variable name="end_title">Ende</xsl:variable>

<xsl:variable name="create_title">Erstellen</xsl:variable>

<xsl:variable name="events_text">Termine</xsl:variable>

<xsl:variable name="alert_provide_valid_count">Geben Sie eine zulässige Zahl ein</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">Geben Sie eine Zahl ein, die nicht größer ist als</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">Die Erinnerung für dieses Ereignis ist auf einen Zeitpunkt eingestellt, der nach dem Beginn des Ereignisses liegt. Klicken Sie auf \'Abbrechen\' und ändern Sie die Uhrzeit.</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">Die Erinnerung für diese Aufgabe ist auf einen Zeitpunkt eingestellt, der nach dem Fälligkeitstermin der Aufgabe liegt. Klicken Sie auf \'Abbrechen\' und ändern Sie die Uhrzeit.</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">Erstellen</xsl:variable>

<xsl:variable name="reminders_title">Erinnerungen</xsl:variable>

<xsl:variable name="availability_title">Freie Zeiten</xsl:variable>

<xsl:variable name="preview_title">Vorschau</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">Einladungsliste: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">Löschen</xsl:variable>

<xsl:variable name="recurring_event_msg">Wiederkehrender Termin</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">Keine ausstehenden Einladungen</xsl:variable>

<xsl:variable name="all_title">Alle</xsl:variable>

<xsl:variable name="delete_all_title">Alle löschen</xsl:variable>

<xsl:variable name="save_and_close_title">Speichern und schließen</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">Sie haben keine Eingabe vorgenommen.</xsl:variable>

<xsl:variable name="alert_min_year">Anzeige erst ab 1970 möglich</xsl:variable>
<xsl:variable name="alert_max_year">Anzeige nur bis 2036 möglich</xsl:variable>

<xsl:variable name="alert_invalid_date">Dieses Datum ist ungültig. Korrigieren Sie den Wert.</xsl:variable>

<xsl:variable name="january_title">Januar</xsl:variable>
<xsl:variable name="february_title">Februar</xsl:variable>
<xsl:variable name="march_title">März</xsl:variable>
<xsl:variable name="april_title">April</xsl:variable>
<xsl:variable name="may_title">Mai</xsl:variable>
<xsl:variable name="june_title">Juni</xsl:variable>
<xsl:variable name="july_title">Juli</xsl:variable>
<xsl:variable name="august_title">August</xsl:variable>
<xsl:variable name="september_title">September</xsl:variable>
<xsl:variable name="october_title">Oktober </xsl:variable>
<xsl:variable name="november_title">November</xsl:variable>
<xsl:variable name="december_title">Dezember</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">Geben Sie ein gültiges Datum ein für</xsl:variable>

<xsl:variable name="provide_good_date_msg">Geben Sie ein gültiges Datum an.</xsl:variable>

<xsl:variable name="provide_good_month_msg">Geben Sie einen Monat zwischen 1 und 12 an.</xsl:variable>

<xsl:variable name="provide_good_year_msg">Geben Sie ein gültiges Jahr ein.\n\nWenn Sie das Jahr zweistellig angeben, werden Zahlen kleiner 37\nals ein Jahr im 21. Jahrhundert interpretiert.\n\nBeispiel: 03 entspricht dem Jahr 2003.</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">Geben Sie eine höhere Jahreszahl als 1970 an.</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">Geben Sie eine niedrigere Jahreszahl als 2037 an.</xsl:variable>

<xsl:variable name="provide_good_hour_msg">Geben Sie eine gültige Stundenzahl an: (1-12) im 12-Stunden-Modus oder (0-23) im 24-Stunden-Modus.</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">Geben Sie einen gültigen Stundenwert an (0-23).</xsl:variable>

<xsl:variable name="provide_good_minute_msg">Geben Sie einen Minutenwert zwischen 0 und 59 an.</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">Wählen Sie für Bis einen Wert nach dem Anfangsdatum aus.</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">Das eingegebene Datum ist nicht vorhanden.\nKalender wird auf nächstmöglichen Termin gesetzt in</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">Zum Datum springen: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">Zum vorherigen Jahr wechseln</xsl:variable>

<xsl:variable name="alt_jump_next_year">Zum nächsten Jahr wechseln</xsl:variable>

<xsl:variable name="jump_to_date_title">Zu Datum wechseln</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">Soll dieser Privateintrag wirklich gelöscht werden?</xsl:variable>

<xsl:variable name="edit_calendar_page_title">Kalender bearbeiten: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">Kennzeichnet obligatorische Angaben.</xsl:variable>

<xsl:variable name="calendar_name_msg">Geben Sie einen kurzen Namen für den Kalender ein, z. B.  "Fussball" (Leerzeichen sind nicht zulässig).</xsl:variable>

<xsl:variable name="display_name_title">Anzeigename</xsl:variable>

<xsl:variable name="display_name_msg">In diesem optionalen Feld können Sie dem Kalender einen Namen wie "Toms Fußballplan" geben.</xsl:variable>

<xsl:variable name="include_in_availability_msg">Beziehen Sie diesen Kalender in die Berechnung Ihrer freien Zeiten ein.</xsl:variable>

<xsl:variable name="calendar_address_title">Kalenderadresse</xsl:variable>

<xsl:variable name="calendar_address_msg">Mit dem nachstehenden Link ermöglichen Sie anderen Benutzern den Zugriff auf diesen Kalender. Wenn die Benutzer über die entsprechenden Zugriffsberechtigungen verfügen, öffnen sie den Kalender einfach durch Eingeben des Links in den Browser.</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">Berechtigungen für Kalender:</xsl:variable>

<xsl:variable name="cal_permissions_msg">Berechtigungen bestimmen, wie andere Benutzer diesen Kalender anzeigen lassen und ändern können. Sollen alle Benutzer eine bestimmte Berechtigung erhalten, wählen Sie die gewünschten Berechtigungen in den Spalten neben "Alle" aus. Um bestimmte Berechtigungen für einzelne Benutzer festzulegen, geben Sie die entsprechende Benutzer-ID in das Feld "Benutzer" ein und klicken Sie auf "Benutzer hinzufügen". Wählen Sie anschließend die gewünschten Berechtigungen in den Spalten neben dem Namen des Benutzers aus.</xsl:variable>

<xsl:variable name="user_title">Benutzerattribute</xsl:variable>
<xsl:variable name="user_title_with_colon">Benutzer:</xsl:variable>

<xsl:variable name="permissions_title">Berechtigungen</xsl:variable>

<xsl:variable name="invite_title">Einladen</xsl:variable>

<xsl:variable name="read_title">Lesen</xsl:variable>

<xsl:variable name="modify_title">Ändern</xsl:variable>

<xsl:variable name="delete_selected_user_title">Ausgewählten Benutzer löschen</xsl:variable>

<xsl:variable name="add_user_title">Benutzer hinzufügen</xsl:variable>

<xsl:variable name="everybody_title">Alle</xsl:variable>

<xsl:variable name="this_domain_title">Diese Domäne</xsl:variable>

<xsl:variable name="tip_cal_owners">Tipp zum Zuweisen von Besitzern zu Kalendern:</xsl:variable>

<xsl:variable name="cal_owner_msg">Sie können einen oder auch mehrere Besitzer für diesen Kalender zuweisen. Ein Besitzer kann in Ihrem Namen auf Einladungen antworten sowie Ereignisse anlegen, ändern und löschen.</xsl:variable>

<xsl:variable name="no_owners_msg">Es sind keine Besitzer vorhanden.</xsl:variable>

<xsl:variable name="delete_owner_title">Eigentümer löschen</xsl:variable>

<xsl:variable name="add_owner_title">Eigentümer hinzufügen</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">Soll dieser Kalender wirklich gelöscht werden?</xsl:variable>

<xsl:variable name="alert_supply_cal_name">Sie müssen den Namen eines Kalenders angeben.</xsl:variable>

<xsl:variable name="owners_title">Eigentümer</xsl:variable>

<xsl:variable name="time_zones_title">Zeitzonen</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">Soll dieser Termin wirklich gelöscht werden?</xsl:variable>

<xsl:variable name="edit_event_page_title">Ereignis bearbeiten: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---Schnell-Einladung---</xsl:variable>

<xsl:variable name="event_title_title">Titel</xsl:variable>

<xsl:variable name="date_title">Datum</xsl:variable>

<xsl:variable name="time_title">Uhrzeit</xsl:variable>

<xsl:variable name="all_day_msg">Ganzer Tag (z. B. Urlaub oder Geburtstag)</xsl:variable>

<xsl:variable name="privacy_title">Vertraulichkeit</xsl:variable>

<xsl:variable name="public_event_title">Öffentlicher Termin</xsl:variable>

<xsl:variable name="confidential_event_title">Nur Datum und Uhrzeit</xsl:variable>

<xsl:variable name="private_event_title">Privater Termin</xsl:variable>

<xsl:variable name="location_title">Ort</xsl:variable>

<xsl:variable name="invite_others_msg">Andere Benutzer einladen oder Ressourcen buchen:</xsl:variable>

<xsl:variable name="search_title">Suchen...</xsl:variable>

<xsl:variable name="inform_title">Informieren</xsl:variable>

<xsl:variable name="invite_instructions_msg">(Geben Sie die Benutzer-ID, die Kalender-ID oder die E-Mail-Adresse ein. Falls Ihnen der Name nicht bekannt ist, klicken Sie auf "Suchen".)</xsl:variable>

<xsl:variable name="invitees_title">Eingeladene Personen</xsl:variable>

<xsl:variable name="no_invitees_msg">Keine Teilnehmer eingeladen</xsl:variable>

<xsl:variable name="remove_title">Entfernen</xsl:variable>

<xsl:variable name="inform_event_title">Über Termin informieren</xsl:variable>

<xsl:variable name="no_informees_msg">Keine Benutzer informiert</xsl:variable>

<xsl:variable name="event_reminders_msg">Sie können sich selbst eine E-Mail-Erinnerung für dieses Ereignis senden lassen. Geben Sie im Folgenden mindestens eine Ihrer E-Mail-Adressen ein. Trennen Sie die E-Mail-Adressen ggf. mit einem Komma (,) oder einem Semikolon (;).</xsl:variable>

<xsl:variable name="remind_title">Erinnern</xsl:variable>

<xsl:variable name="alert_provide_valid_time">Geben Sie eine gültige Uhrzeit ein.</xsl:variable>

<xsl:variable name="hours_text">Stunden</xsl:variable>

<xsl:variable name="days_text">Tage</xsl:variable>

<xsl:variable name="before_the_event_begins_text">vor Terminbeginn</xsl:variable>

<xsl:variable name="at_text">um</xsl:variable>

<xsl:variable name="text_reminder_msg">Die E-Mail-Erinnerung kann mit einer Nachricht ergänzt werden.</xsl:variable>

<xsl:variable name="message_title">Mitteilung</xsl:variable>

<xsl:variable name="title_title">Titel</xsl:variable>

<xsl:variable name="attendees_title">Teilnehmer</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">Löschen OK?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">Kalendergruppe bearbeiten: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---Schnell-Hinzufügen---</xsl:variable>

<xsl:variable name="delete_calendar_text">Soll dieser Kalender wirklich entfernt werden?</xsl:variable>

<xsl:variable name="group_name_title">Gruppenname</xsl:variable>

<xsl:variable name="group_view_msg">Gruppe in Tagesansicht öffnen (Standardmäßig werden Gruppen in der Vergleichsansicht geöffnet.)</xsl:variable>

<xsl:variable name="calendar_id_title">Kalender-ID</xsl:variable>

<xsl:variable name="add_title">Hinzufügen</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(Geben Sie die Kalender-ID ein. Falls Sie die ID nicht kennen, klicken Sie auf "Suchen".)</xsl:variable>

<xsl:variable name="group_members_title">Gruppenmitglieder</xsl:variable>

<xsl:variable name="group_description_msg">Geben Sie hier eine Beschreibung der Gruppe an. Sie können auch festlegen, dass die Kalender getrennt in der Tagesansicht dieser Gruppe angezeigt werden sollen.</xsl:variable>

<xsl:variable name="day_view_title">Tagesansicht</xsl:variable>

<xsl:variable name="day_view_merge_msg">In der Tagesansicht sind die Kalender standardmäßig nicht zusammengeführt.</xsl:variable>

<xsl:variable name="alert_group_name">Sie müssen einen Namen für die Gruppe angeben.</xsl:variable>

<xsl:variable name="calendar_group_title">Kalendergruppe</xsl:variable>

<xsl:variable name="details_title">Details</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">Soll diese Aufgabe wirklich gelöscht werden?</xsl:variable>

<xsl:variable name="edit_task_page_title">Aufgabe bearbeiten: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">Aufgabe erstellen</xsl:variable>

<xsl:variable name="task_title_title">Aufgabentitel</xsl:variable>

<xsl:variable name="due_date_title">Fällig</xsl:variable>

<xsl:variable name="no_time_title">Ohne Zeit</xsl:variable>

<xsl:variable name="public_task_title">Öffentliche Aufgabe</xsl:variable>

<xsl:variable name="confidential_task_title">Nur Datum und Uhrzeit</xsl:variable>

<xsl:variable name="private_task_title">Private Aufgabe</xsl:variable>

<xsl:variable name="status_title">Status</xsl:variable>

<xsl:variable name="complete_title">Erledigt</xsl:variable>

<xsl:variable name="task_reminder_msg">Sie können sich selbst eine E-Mail-Erinnerung für diese Aufgabe senden lassen. Geben Sie im Folgenden mindestens eine Ihrer E-Mail-Adressen ein. Trennen Sie die E-Mail-Adressen ggf. mit einem Komma (,) oder einem Semikolon (;).</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">Sie können keinen Alarm für eine Aufgabe einstellen, die nicht fällig ist.</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">bevor die Aufgabe fällig wird</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">Gesamtbild</xsl:variable>

<xsl:variable name="settings_title">Einstellungen</xsl:variable>

<xsl:variable name="import_title">Importieren</xsl:variable>

<xsl:variable name="export_title">Exportieren</xsl:variable>

<xsl:variable name="settings_msg">Mit diesem Formular bestimmen Sie das Verhalten von Calendar Express.</xsl:variable>

<xsl:variable name="default_view_title">Erste Ansicht (Standard)</xsl:variable>

<xsl:variable name="default_view_msg">Nach dem Anmelden immer die folgende Ansicht öffnen:</xsl:variable>

<xsl:variable name="default_group_title">Standardkalendergruppe</xsl:variable>

<xsl:variable name="default_group_msg">Nach dem Anmelden immer die folgende Kalendergruppe öffnen:</xsl:variable>

<xsl:variable name="no_cal_group_title">Keine Kalendergruppe</xsl:variable>

<xsl:variable name="date_format_msg">Kurzdatumsangaben in der folgenden Reihenfolge anzeigen:</xsl:variable>

<xsl:variable name="m_d_y_format_text">Monat, Tag, Jahr</xsl:variable>

<xsl:variable name="d_m_y_format_text">Tag, Monat, Jahr</xsl:variable>

<xsl:variable name="y_m_d_format_text">Jahr, Monat, Tag</xsl:variable>

<xsl:variable name="date_delimiter_msg">Kurzdatumsangaben mit dem folgenden Zeichen trennen:</xsl:variable>

<xsl:variable name="use_12_clock_msg">12-Stunden-Format verwenden</xsl:variable>

<xsl:variable name="use_24_clock_msg">24-Stunden-Format verwenden</xsl:variable>

<xsl:variable name="day_title">Tag</xsl:variable>

<xsl:variable name="day_starts_msg">Tag beginnt um:</xsl:variable>

<xsl:variable name="day_ends_msg">Tag endet um:</xsl:variable>

<xsl:variable name="day_interval_msg">Tag unterteilen</xsl:variable>

<xsl:variable name="every_15_minutes_text">alle fünfzehn Minuten</xsl:variable>

<xsl:variable name="every_half_hour_text">jede halbe Stunde</xsl:variable>

<xsl:variable name="every_hour_text">jede Stunde</xsl:variable>

<xsl:variable name="every_2_hours_text">alle zwei Stunden</xsl:variable>

<xsl:variable name="every_four_hours_text">alle vier Stunden</xsl:variable>

<xsl:variable name="first_dow_title">Erster Tag der Woche</xsl:variable>

<xsl:variable name="sunday_title">Sonntag</xsl:variable>

<xsl:variable name="monday_title">Montag</xsl:variable>

<xsl:variable name="tuesday_title">Dienstag</xsl:variable>

<xsl:variable name="wednesday_title">Mittwoch</xsl:variable>

<xsl:variable name="thursday_title">Donnerstag</xsl:variable>

<xsl:variable name="friday_title">Freitag</xsl:variable>

<xsl:variable name="saturday_title">Samstag</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">Samstag und Sonntag aus Wochen- und Monatsansicht ausschließen</xsl:variable>

<xsl:variable name="default_tz_msg">Datumsangaben und Uhrzeiten standardmäßig mit der folgenden Zeitzone anzeigen:</xsl:variable>

<xsl:variable name="none_selected_title">Keine Auswahl</xsl:variable>

<xsl:variable name="single_tz_use_msg">Für die Anzeige eines einzelnen Kalenders dessen Zeitzone verwenden</xsl:variable>

<xsl:variable name="tz_timescales_msg">Zeiteinteilung für jede im Kalender angezeigte Zeitzone anzeigen</xsl:variable>

<xsl:variable name="event_task_reminders_title">Ereignis- und Aufgabenerinnerungen</xsl:variable>

<xsl:variable name="email_reminder_msg">Erinnerung per E-Mail an mich senden</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">Geben Sie für Erinnerungen einen gültigen Zeitraum ein.</xsl:variable>

<xsl:variable name="before_every_event_task_text">vor jedem Termin und jeder Aufgabe</xsl:variable>

<xsl:variable name="note_title">Hinweis:</xsl:variable>

<xsl:variable name="reminders_tip_msg">Wenn eine Erinnerung an mehrere E-Mail-Adressen gesendet werden soll (z. B. an abc@Firma22.de, abc@blabla.de), trennen Sie die E-Mail-Adressen mit einem Komma (,) oder einem Semikolon(;).</xsl:variable>

<xsl:variable name="event_notifications_title">Terminbenachrichtungen</xsl:variable>

<xsl:variable name="event_notifications_msg">Benachrichtigung an mich schicken, wenn jemand einen Termin in meinen Kalender einträgt</xsl:variable>

<xsl:variable name="only_one_email_msg">Nur eine E-Mail-Adresse ist zulässig.</xsl:variable>

<xsl:variable name="alert_only_one_email">Geben Sie pro Terminbenachrichtigung nur eine Adresse ein.</xsl:variable>

<xsl:variable name="declined_events_delete_title">Abgelehnte Termine</xsl:variable>

<xsl:variable name="declined_events_delete_msg">Abgelehnte Termine nicht anzeigen</xsl:variable>

<xsl:variable name="appearance_msg">Mit diesem Formular bestimmen Sie das Erscheinungsbild von Calendar Express.</xsl:variable>

<xsl:variable name="color_scheme_title">Farbschema</xsl:variable>

<xsl:variable name="toolbar_title">Symbolleiste</xsl:variable>

<xsl:variable name="icons_and_text_msg">Symbole und Text anzeigen</xsl:variable>

<xsl:variable name="icons_only_msg">Nur Symbole anzeigen</xsl:variable>

<xsl:variable name="text_only_msg">Nur Text anzeigen</xsl:variable>

<xsl:variable name="display_font_title">Schriftart für Anzeige</xsl:variable>

<xsl:variable name="face_title">Schriftbild</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">Größe</xsl:variable>

<xsl:variable name="larger_title">Größer</xsl:variable>

<xsl:variable name="default_title">Standard</xsl:variable>

<xsl:variable name="smaller_title">Kleiner</xsl:variable>

<xsl:variable name="event_destination_title">Ereignisziel</xsl:variable>

<xsl:variable name="session_expired_msg">Ihre Sitzung ist abgelaufen.</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">Sie müssen einen gültigen Kalender angeben.</xsl:variable>

<xsl:variable name="add_events_to_text">Termine eintragen in</xsl:variable>

<xsl:variable name="select_calendar_title">Kalender auswählen:</xsl:variable>

<xsl:variable name="import_format_title">Importformat</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook-Format</xsl:variable>

<xsl:variable name="source_file_invalid_error">Die angegebene Quelldatei ist unzulässig.</xsl:variable>

<xsl:variable name="format_file_mismatch_error">Das angegebene Format stimmt nicht mit der Quelldatei überein.</xsl:variable>

<xsl:variable name="successful_import_msg">Dateiimport erfolgreich</xsl:variable>

<xsl:variable name="source_file_title">Quelldatei</xsl:variable>

<xsl:variable name="date_range_title">Datumsbereich</xsl:variable>

<xsl:variable name="import_all_msg">Alle Termine aus der Datei importieren</xsl:variable>

<xsl:variable name="invalid_date_range_error">Der angegebene Datumsbereich ist ungültig.</xsl:variable>

<xsl:variable name="beginning_title">Von</xsl:variable>

<xsl:variable name="ending_title">Bis</xsl:variable>

<xsl:variable name="calendars_to_export_title">Zu exportierende Kalender</xsl:variable>

<xsl:variable name="addarrow_title">Hinzufügen >></xsl:variable>

<xsl:variable name="export_all_msg">Alle Termine exportieren</xsl:variable>

<xsl:variable name="export_format_title">Exportformat</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">Das Tagesende muss zeitlich nach dem Tagesbeginn liegen.</xsl:variable>

<xsl:variable name="save_changes_title">Änderungen speichern</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">Aktueller Kalender:</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">Wiederholungsschema</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">Ungültiges Muster für Terminserie: Tag für Terminserie auswählen</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">Wiederholungsschema kann nicht für eine einzelne Instanz ausgetauscht werden.</xsl:variable>

<xsl:variable name="recurrence_skips_title">Eine Instanz eines wiederkehrenden Termins kann keine andere überspringen.</xsl:variable>

<xsl:variable name="recurrence_same_day">Zwei Instanzen eines wiederkehrenden Termins können nicht am gleichen Tag auftreten.</xsl:variable>

<xsl:variable name="recurrence_privacy">Die Vertraulichkeit nur einer einzelnen Instanz kann nicht geändert werden.</xsl:variable>

<xsl:variable name="every_day_title">Täglich</xsl:variable>

<xsl:variable name="every_weekday_title">Jeden Wochentag</xsl:variable>

<xsl:variable name="every_title">Jeden</xsl:variable>

<xsl:variable name="weekday_text">Wochentag</xsl:variable>

<xsl:variable name="weekendday_text">Wochenendtag</xsl:variable>

<xsl:variable name="m_w_f_text">Montag, Mittwoch und Freitag</xsl:variable>

<xsl:variable name="t_th_text">Dienstag und Donnerstag</xsl:variable>

<xsl:variable name="sat_sun_text">Samstag und Sonntag</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">Geben Sie einen gültigen Zeitraum ein.</xsl:variable>

<xsl:variable name="every_week_title">Wöchentlich</xsl:variable>

<xsl:variable name="weeks_text">Wochen</xsl:variable>

<xsl:variable name="repeat_on_title">Wiederholung am</xsl:variable>

<xsl:variable name="sunday_abbrev">So</xsl:variable>

<xsl:variable name="monday_abbrev">Mo</xsl:variable>

<xsl:variable name="tuesday_abbrev">Di</xsl:variable>

<xsl:variable name="wednesday_abbrev">Mi</xsl:variable>

<xsl:variable name="thursday_abbrev">Do</xsl:variable>

<xsl:variable name="friday_abbrev">Fr</xsl:variable>

<xsl:variable name="saturday_abbrev">Sa</xsl:variable>

<xsl:variable name="every_month_title">Monatlich</xsl:variable>

<xsl:variable name="months_text">Monate</xsl:variable>

<xsl:variable name="ordinal_1">1.</xsl:variable>
<xsl:variable name="ordinal_2">2.</xsl:variable>
<xsl:variable name="ordinal_3">3.</xsl:variable>
<xsl:variable name="ordinal_4">4.</xsl:variable>
<xsl:variable name="ordinal_5">5.</xsl:variable>
<xsl:variable name="ordinal_6">6.</xsl:variable>
<xsl:variable name="ordinal_7">7.</xsl:variable>
<xsl:variable name="ordinal_8">8.</xsl:variable>
<xsl:variable name="ordinal_9">9.</xsl:variable>
<xsl:variable name="ordinal_10">10.</xsl:variable>
<xsl:variable name="ordinal_11">11.</xsl:variable>
<xsl:variable name="ordinal_12">12.</xsl:variable>
<xsl:variable name="ordinal_13">13.</xsl:variable>
<xsl:variable name="ordinal_14">14.</xsl:variable>
<xsl:variable name="ordinal_15">15.</xsl:variable>
<xsl:variable name="ordinal_16">16.</xsl:variable>
<xsl:variable name="ordinal_17">17.</xsl:variable>
<xsl:variable name="ordinal_18">18.</xsl:variable>
<xsl:variable name="ordinal_19">19.</xsl:variable>
<xsl:variable name="ordinal_20">20.</xsl:variable>
<xsl:variable name="ordinal_21">21.</xsl:variable>
<xsl:variable name="ordinal_22">22.</xsl:variable>
<xsl:variable name="ordinal_23">23.</xsl:variable>
<xsl:variable name="ordinal_24">24.</xsl:variable>
<xsl:variable name="ordinal_25">25.</xsl:variable>
<xsl:variable name="ordinal_26">26.</xsl:variable>
<xsl:variable name="ordinal_27">27.</xsl:variable>
<xsl:variable name="ordinal_28">28.</xsl:variable>
<xsl:variable name="ordinal_29">29.</xsl:variable>
<xsl:variable name="ordinal_30">30.</xsl:variable>
<xsl:variable name="ordinal_31">31.</xsl:variable>

<xsl:variable name="day_of_month_text">Tag des Monats</xsl:variable>
<xsl:variable name="cap_last_text">letzten</xsl:variable>

<xsl:variable name="of_month_text">des Monats</xsl:variable>

<xsl:variable name="every_year_text">Jährlich</xsl:variable>

<xsl:variable name="years_text">Jahre</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">Dieses Ereignis gehört zu einer Terminserie. Nur dieses Ereignis löschen oder alle zugehörigen Ereignisse?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">Dieses Ereignis gehört zu einer Terminserie. Änderung nur für dieses Ereignis übernehmen oder für alle zugehörigen Ereignisse?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">Diese Aufgabe gehört zu einer Terminserie. Nur diese Aufgabe löschen oder alle zugehörigen Aufgaben?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">Diese Aufgabe gehört zu einer Terminserie. Änderung nur für diese Aufgabe übernehmen oder für alle zugehörigen Aufgaben?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">Zusammenfassung</xsl:variable>

<xsl:variable name="reply_title">Antwort</xsl:variable>

<xsl:variable name="will_attend_msg">Ich nehme teil</xsl:variable>

<xsl:variable name="will_not_attend_msg">Ich nehme NICHT teil</xsl:variable>

<xsl:variable name="confirm_later_msg">Meine Bestätigung folgt später</xsl:variable>

<xsl:variable name="reply_reminders_msg">Planen Sie hier die E-Mail-Erinerungen. Geben Sie die E-Mail-Adressen ein (getrennt durch Komma oder Semikolon) und bestimmen Sie das Datum und die Uhrzeit für das Versenden.</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">Sie können keinen Alarm für einen unbestätigten Termin vor Terminbeginn einstellen.</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">Im folgenden Feld können Sie weitere Informationen zur Erinnerung hinzufügen. Der Titel, das Datum, die Uhrzeit und der Ort eines Ereignisses werden automatisch in alle Erinnerungen aufgenommen.</xsl:variable>

<xsl:variable name="cal_select_msg">Wählen Sie den Kalender aus, in dem der Termin gespeichert werden soll.</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">Kalender suchen: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">Kalendersuche</xsl:variable>

<xsl:variable name="cal_search_msg1">Nach Kalender suchen, bei denen der Kalender</xsl:variable>
        
<xsl:variable name="name_or_id_text">Name oder ID</xsl:variable>

<xsl:variable name="name_text">-Name</xsl:variable>

<xsl:variable name="primary_owner_text">primärer Besitzer</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">enthält</xsl:variable>

<xsl:variable name="begins_with_text">beginnt mit</xsl:variable>

<xsl:variable name="search_plain_title">Suchen</xsl:variable>

<xsl:variable name="already_selected_cals_title">Bereits ausgewählte Kalender</xsl:variable>

<xsl:variable name="cal_id_title">Kalender-ID</xsl:variable>

<xsl:variable name="search_results_title">Suchergebnisse</xsl:variable>

<xsl:variable name="no_match_found_msg">Keine Übereinstimmung gefunden</xsl:variable>

<xsl:variable name="owner_title">Eigentümer</xsl:variable>

<xsl:variable name="owner_name_colon_title">Name des Besitzers:</xsl:variable>

<xsl:variable name="cal_name_title">Kalendername</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">Suche: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">Nach Ereignissen und Aufgaben suchen, die Folgendes enthalten:</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">Benutzer suchen: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">Benutzersuche</xsl:variable>

<xsl:variable name="search_local_msg">Lokales Verzeichnis durchsuchen</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(Vorname, Nachname oder Benutzer-ID eingeben)</xsl:variable>

<xsl:variable name="legend_title">Legende:</xsl:variable>

<xsl:variable name="resource_title">Ressource;</xsl:variable>

<xsl:variable name="already_selected_users_title">Bereits ausgewählte Benutzer</xsl:variable>

<xsl:variable name="name_userid_title">Name (Benutzer-ID)</xsl:variable>

<xsl:variable name="name_title">Name</xsl:variable>

<xsl:variable name="userid_title">Benutzerkennung</xsl:variable>

<xsl:variable name="email_title">E-Mail</xsl:variable>

<xsl:variable name="for_text">für</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">Aufgabenliste: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">In diesem Fenster behalten Sie alle Ihre Tätigkeiten im Auge. Mit den Kontrollkäschen in der Spalte "Fertig" können Sie Aufgaben als abgeschlossen markieren. Klicken Sie auf "Speichern und Schließen", um die Änderungen zu übermitteln.</xsl:variable>

<xsl:variable name="done_title">Erledigt</xsl:variable>

<xsl:variable name="task_title">Aufgabe</xsl:variable>

<xsl:variable name="select_all_title">Alle auswählen</xsl:variable>

<xsl:variable name="alert_processing">Verarbeitung läuft</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">Aufgaben</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Suche: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">Hilfe</xsl:variable>

<xsl:variable name="logout_text">Abmeldung</xsl:variable>

<xsl:variable name="login_text">Anmeldung</xsl:variable>

<xsl:variable name="home_text">Anfang</xsl:variable>

<xsl:variable name="alt_schedule_msg">Planen einer Besprechung, eines Geburtstags oder eines anderen Termins</xsl:variable>

<xsl:variable name="new_event_title">Neuer Termin</xsl:variable>

<xsl:variable name="alt_todo_msg">Hinzufügen eines Eintrags zur Liste mit anstehenden Aufgaben</xsl:variable>

<xsl:variable name="new_task_title">Neue Aufgabe</xsl:variable>

<xsl:variable name="jump_to_title">Wechseln</xsl:variable>

<xsl:variable name="alt_print_msg">Öffnen einer für den Ausdruck geeigneten Version der aktuellen Ansicht</xsl:variable>

<xsl:variable name="printable_title">Druckansicht</xsl:variable>

<xsl:variable name="alt_search_msg">Ereignisse und Aufgaben suchen</xsl:variable>

<xsl:variable name="alt_new_calendar">Erstellen eines neuen Kalenders</xsl:variable>

<xsl:variable name="new_cal_title">Neuer Kalender</xsl:variable>

<xsl:variable name="alt_new_group">Erstellen einer neuen Kalendergruppe</xsl:variable>

<xsl:variable name="new_group_title">Neue Gruppe</xsl:variable>

<xsl:variable name="alt_search_cals">Nach Kalendern suchen</xsl:variable>

<xsl:variable name="subscribe_title">Abonnieren</xsl:variable>

<xsl:variable name="paren_subscribed_title">(Abonniert)</xsl:variable>

<xsl:variable name="alt_jump_next_week">Zur nächsten Woche wechseln</xsl:variable>

<xsl:variable name="alt_jump_prev_week">Zur vorherigen Woche wechseln</xsl:variable>

<xsl:variable name="sunday_letter_title">S</xsl:variable>
<xsl:variable name="monday_letter_title">M</xsl:variable>
<xsl:variable name="tuesday_letter_title">D</xsl:variable>
<xsl:variable name="wednesday_letter_title">M</xsl:variable>
<xsl:variable name="thursday_letter_title">D</xsl:variable>
<xsl:variable name="friday_letter_title">f</xsl:variable>
<xsl:variable name="saturday_letter_title">S</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">Die ausgewählten Ereignisse werden aus dem Kalender entfernt. Bei Terminserien werden nur Instanzen mit Fehlern entfernt. Um den Vorgang fortzusetzen, klicken Sie auf "OK".</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">Beim Erstellen eines Ereignisses, während eine Kalendergruppe geöffnet ist, alle Kalender in der Gruppe einladen</xsl:variable>

<xsl:variable name="invite_this_group_msg">Beim Erstellen eines Ereignisses, während diese Kalendergruppe geöffnet ist, alle Kalender in der Gruppe einladen</xsl:variable>

<xsl:variable name="group_invitations_title">Gruppeneinladungen</xsl:variable>

<xsl:variable name="starting_at_txt">Beginn:</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">unbekannt</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">Keine Teilnehmer</xsl:variable>

<xsl:variable name="today_title">Heute</xsl:variable>

<xsl:variable name="confirm_event_delete_text">Soll dieses Ereignis wirklich gelöscht werden?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">Soll diese Aufgabe wirklich gelöscht werden?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">Fehler bei Verbindung zur Back-End-Datenbank.</xsl:variable>
<xsl:variable name="dwp_max_connections_error">Maximale Anzahl der Verbindungen zur Back-End-Datenbank erreicht.</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">Fehlerhafte Daten - Back-End-Datenbank ist nicht erreichbar.</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">Kalender konnte nicht aufgelöst werden.</xsl:variable>
<xsl:variable name="dwp_down_error">ist deaktiviert</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP-Host-Kontext nicht verfügbar.</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">Back-End-Host konnte nicht aufgelöst werden.</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">Keine Daten - Back-End-Datenbank ist nicht erreichbar.</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">Diesen Termin beim Berechnen der freien Zeit einbeziehen</xsl:variable>
<xsl:variable name="freebusy_title">Frei/Belegt</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">Sie erstellen einen Ganztagestermin, der bei der Berechnung Ihrer Verfügbarkeit herangezogen wird. Falls dies nicht richtig ist, klicken Sie auf \'Abbrechen\' und deaktivieren Sie das Kontrollkästchen \'Frei/Belegt\'.</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">Sie erstellen einen privaten Termin, der bei der Berechnung Ihrer Verfügbarkeit herangezogen wird. Falls dies nicht richtig ist, klicken Sie auf \'Abbrechen\' und deaktivieren Sie das Kontrollkästchen \'Frei/Belegt\'.</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">Kalender-Datenbank ist schreibgeschützt.</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Kein Enddatum </xsl:variable>
<xsl:variable name="cap_the_text">Der </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Entfernen</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Willkommen  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Aufgaben für </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>- Kalender (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Beginn um </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 Stunde</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> Minuten</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Über eine Stunde</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> verfügbar)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Erstellt maximal </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> e Instanzen</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Dem aktuellen Kalender können eine oder mehrere Zeitzonen einer beliebigen Region zugeordnet werden. In Tabellenansichten wie der Tagesansicht werden alle Zeitzonen des Kalenders in die Zeitskala der Ansicht integriert. Wenn diesem Kalender keine Zeitzone zugeordnet ist, wird die Standardzeitzone verwendet. Folgende Zeitzonen gibt es in der </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Dem aktuellen Kalender kann eine Zeitzone einer beliebigen Region zugeordnet werden. In Tabellenansichten wie der Tagesansicht wird die Zeitzone des Kalenders in die Zeitskala der Ansicht integriert. Wenn diesem Kalender keine Zeitzone zugeordnet ist, wird die Standardzeitzone verwendet. Folgende Zeitzonen gibt es in der </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>Nord-/Südamerika </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europa/Afrika </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asien/Pazifische Randgebiete </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>Region:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>Das folgende Ereignis wurde in Ihren Kalender aufgenommen durch "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Sie können diese Einladung annehmen oder ablehnen. Klicken Sie hierzu auf die gewünschte Option in der nachstehenden Antwort.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Klicken</xsl:text>&nbsp;
  <B><xsl:text>Durchsuchen...</xsl:text></B>&nbsp;
  <xsl:text>zum Auswählen einer Datei.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Dieses Fenster ermöglicht das Annehmen </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> oder Ablehnen </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> oder das Offenhalten </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> von Einladungen zu Ereignissen.</xsl:text>
  <br/>
  <xsl:text>Bei Terminserien wird die Einstellung für alle Termine in der Serie übernommen.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Die Ergebnisse einer Suche mit weniger als </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> Zeichen ist möglicherweise unvollständig. Bessere Ergebnisse erzielen Sie mit mindestens </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> Zeichen.</xsl:text>

</xsl:template>


</xsl:stylesheet>
