<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>
    <TITLE>Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="*,41">
      <FRAME name="main" frameborder="0" src="{$Frame1}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame2}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="main_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (add_people.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <TD colspan="2"><FONT face="{$font_name}" size="{$font_size_big}">
      Geben Sie im Folgenden einen Benutzernamen ein und klicken Sie auf "OK".
    </FONT></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD align="right" valign="baseline" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>
    Benutzername
    </B></FONT></TD>
    <TD valign="baseline">
      <INPUT type="text" name="userName" size="42" value="{$e_userName}"/>
    </TD>
  </TR>
</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>

</xsl:template>


<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0" onload="window.focus()">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="ok" value="OK" width="72">
          <xsl:attribute name="onClick">
            var f = parent.opener.document.forms[0];
            f['i_tabswitch'].value=2;
            f['myaction'].value='addPerson';
            f['newPerson'].value=parent.frames[0].document.forms[0]['userName'].value;
            f.submit();
            parent.close();
          </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="esc" value="Abbrechen" onClick="{./button[@name='cancel']}" width="72"/>
        <INPUT type="button" name="help" value="Hilfe" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>


</xsl:stylesheet>
