<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  未命名
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">星期日</xsl:if>
  <xsl:if test=".='2'">星期一</xsl:if>
  <xsl:if test=".='3'">星期二</xsl:if>
  <xsl:if test=".='4'">星期三</xsl:if>
  <xsl:if test=".='5'">星期四</xsl:if>
  <xsl:if test=".='6'">星期五</xsl:if>
  <xsl:if test=".='7'">星期六</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">一</xsl:if>
  <xsl:if test="$downum='3'">二</xsl:if>
  <xsl:if test="$downum='4'">三</xsl:if>
  <xsl:if test="$downum='5'">四</xsl:if>
  <xsl:if test="$downum='6'">五</xsl:if>
  <xsl:if test="$downum='7'">六</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10月</xsl:if>
  <xsl:if test="$MonthNum=11">11月</xsl:if>
  <xsl:if test="$MonthNum=12">12月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      无效的日期和时间。请进行修改。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      已存在使用此名称的日历。请选择其他名称。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      已存在使用此名称的组。请选择其他名称。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 到 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      执行此搜索时，目录服务器出错。&nbsp;      请提供其他搜索字符串。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      无法建立到目录服务器的连接。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      无法建立到目录服务器的连接。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      执行此搜索时，目录服务器出错。&nbsp;      请提供其他搜索字符串。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 错误：事件已被删除
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 错误：实现不受支持
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 错误：malloc 失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 错误：无法创建多个 GSE 实例
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 错误：GSE 条目无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 错误：事件无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 错误：无法找到传输接口
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 错误：无法在组织者日历中找到参与者
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 错误：无法创建资源，例如 lock、GDisp 等
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 错误：预期为 iCS 用户，但结果为 SMTP 用户
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 错误：组件方法和状态无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 错误：请求时间与另一个现有会议请求冲突
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      数据库错误：找不到组件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      数据库错误：IO 错误
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      数据库错误：事件的一个或多个值无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      数据库错误：函数调用无法在提供的组件上操作
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      数据库错误：请求查询未知或不被支持
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      数据库错误：一个必需参数为空、没有设置或者不存在
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      数据库错误：请求的 SequenceNo 条件检查失败，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      数据库错误：请求的修改时间条件检查失败，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      数据库错误：日历不允许覆盖约会，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      数据库错误：ENS 通知返回一个错误
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      数据库错误：一个必需值为空
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      被邀请人错误：参数不对
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      被邀请人错误：找不到日历
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      被邀请人错误：日历被禁用
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      被邀请人错误：不允许用户访问此日历
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      被邀请人错误：组被截断
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      被邀请人错误：无法移除组织者
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      日历错误：日历创建失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      日历错误：现有日历具有同一个标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      日历错误：用户没有执行该操作所需的访问权限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      日历错误：用户试图访问不存在的日历。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      日历错误: 非法的日历标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      被邀请人错误：无法双重预约被邀请人。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      日历错误：用户没有执行该操作所需的访问权限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      日历错误：用户必须是所有者或共同所有者才能执行该操作。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      日历错误：数据库处于只读模式。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      请查看“空闲时间”选项卡上的空闲时间。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      组错误：非法的组标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      日历错误：无法向保密性列表或所有者列表添加未知用户。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 错误：无邮件主机
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 错误：连接失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 错误：未出现预期的连接响应
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 错误：处理消息时出现问题
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 错误：无收件人
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      错误：连接后端数据库失败。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      错误：已达到后端数据库的最大连接数目。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      错误：无法解析日历。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      错误：错误的数据 - 无法访问后端数据库。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      错误：DWP 主机上下文不可用。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      错误：无法解析后端主机。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      错误：无数据 - 无法访问后端数据库。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      错误：连接后端数据库失败。
    </xsl:when>
    <xsl:otherwise>
      未知 错误 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      错误：一个重复发生的实例不能跳过另一个重复发生的实例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      错误：两个重复发生的实例不能在同一天发生。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      错误：不能只变更一个实例的保密性。
    </xsl:when>
    <xsl:otherwise>
      未知的重复发生错误 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">美洲/埃达克</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">美洲/安克雷奇</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">美洲/洛杉矶</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">美洲/菲尼克斯</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">美洲/丹佛</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">美洲/哥斯达黎加</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">美洲/芝加哥</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">美洲/印地安纳波利斯</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">美洲/纽约</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">美洲/哈瓦那</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">美洲/太子港</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">美洲/大特克岛</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">美洲/加纳加斯</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">美洲/库亚巴</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">美洲/哈里法克斯</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">美洲/圣地亚哥</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋地区/斯坦利</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">美洲/圣约翰斯</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">美洲/布宜诺斯艾利斯</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">美洲/圣保罗</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">美洲/密克隆</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">美洲/戈特霍布</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋地区/南乔治亚岛</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋地区/佛得角</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋地区/亚述尔群岛</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">非洲/卡萨布兰卡</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">欧洲/伦敦</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">非洲/拉各斯</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">欧洲/巴黎</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">非洲/的黎波里</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">欧洲/华沙</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">非洲/约翰内斯堡</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">欧洲/布加勒斯特</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">欧洲/伊斯坦布尔</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">非洲/开罗</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">欧洲/里加</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">非洲/温得和克</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">欧洲/明斯克</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">欧洲/辛菲罗波尔</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">欧洲/莫斯科</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">欧洲/萨马拉</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">亚洲/贝鲁特</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">亚洲/耶路撒冷</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">亚洲/安曼</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">亚洲/利雅得</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">亚洲/德黑兰</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">亚洲/埃里温</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">亚洲/阿克套</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">亚洲/巴库</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">亚洲/喀布尔</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">亚洲/卡拉齐</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">亚洲/阿克秋宾</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">亚洲/比什凯克</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">亚洲/叶卡捷琳堡</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">亚洲/加尔各答</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">亚洲/加德满都</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">亚洲/达卡</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">亚洲/阿拉木图</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">亚洲/新西伯利亚</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">亚洲/仰光</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">亚洲/曼谷</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">亚洲/克拉斯诺亚尔斯克</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">亚洲/乌兰巴托</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">亚洲/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">亚洲/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">亚洲/伊尔库次克</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">亚洲/东京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">亚洲/汉城</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">亚洲/雅库茨克</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">澳大利亚/佩斯</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">澳大利亚/达尔文</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">澳大利亚/阿德莱德</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">澳大利亚/布里斯班</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">澳大利亚/悉尼</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">澳大利亚/霍巴特</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">亚洲/符拉迪沃斯托克</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">澳大利亚/豪勋爵岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋地区/瓜达尔卡纳尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋地区/努美阿</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">亚洲/马加丹</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋地区/诺福克</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋地区/斐济</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋地区/奥克兰</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">亚洲/堪察加</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋地区/查塔姆</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋地区/汤加塔布</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">亚洲/阿纳德尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋地区/圣诞岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋地区/阿皮亚</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋地区/檀香山</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋地区/拉罗汤加岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋地区/马克萨斯群岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋地区/甘比尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋地区/皮特凯恩岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋地区/复活节岛</xsl:when> 
    <xsl:otherwise>
      未知 时区 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">确定</xsl:variable>

<xsl:variable name="cancel_title">取消</xsl:variable>
<xsl:variable name="close_title">关闭</xsl:variable>
<xsl:variable name="help_title">帮助</xsl:variable>
<xsl:variable name="apply_title">应用</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">无事件或任务</xsl:variable>
<xsl:variable name="week_ahead_title">未来一周</xsl:variable>
<xsl:variable name="alt_text_schedule">安排一个新约会</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">在下面输入用户名称，然后再按“确定”按钮。</xsl:variable>

<xsl:variable name="user_name_title">用户名称</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">跳至前一日</xsl:variable>

<xsl:variable name="alt_jump_next_day">跳至后一日</xsl:variable>

<xsl:variable name="alt_jump_new_date">跳至新日期</xsl:variable>

<xsl:variable name="available_title">空闲</xsl:variable>

<xsl:variable name="busy_title">已占用</xsl:variable>

<xsl:variable name="hour_text">小时</xsl:variable>
<xsl:variable name="minutes_text">分钟</xsl:variable>

<xsl:variable name="show_availability_title">显示空闲</xsl:variable>

<xsl:variable name="error_cal_privacy">日历的保密性不允许您查看，或该日历不存在。</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">北美/南美地区</xsl:variable>

<xsl:variable name="europe_africa_title">欧洲/非洲</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">亚洲/太平洋周边</xsl:variable>

<xsl:variable name="time_zone_title">时区</xsl:variable>

<xsl:variable name="gmt_offset_title">GMT 时差</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">组</xsl:variable>

<xsl:variable name="groups_msg">使用日历组一次查看多个日历。要查看日历组，请单击相应的组名称链接。要在组中添加或删除日历，请单击“编辑”链接。</xsl:variable>

<xsl:variable name="select_title">选择</xsl:variable>

<xsl:variable name="group_title">组</xsl:variable>

<xsl:variable name="group_colon_title">组：</xsl:variable>

<xsl:variable name="description_title">说明</xsl:variable>

<xsl:variable name="properties_title">属性</xsl:variable>

<xsl:variable name="error_cal_access">您不具备访问此日历的权限。</xsl:variable>

<xsl:variable name="error_cal_not_exist">此日历不存在。</xsl:variable>

<xsl:variable name="edit_title">编辑</xsl:variable>
<xsl:variable name="edit_calendar_title">编辑日历</xsl:variable>

<xsl:variable name="remove_selected_title">移除选取</xsl:variable>

<xsl:variable name="calendars_title">日历</xsl:variable>

<xsl:variable name="calendars_msg">您拥有或已预订的日历列表。要查看日历，请单击相应的日历名称。要编辑日历，请单击“编辑”。</xsl:variable>

<xsl:variable name="calendar_title">日历</xsl:variable>

<xsl:variable name="view_title">查看</xsl:variable>
<xsl:variable name="view_calendar_title">查看日历</xsl:variable>

<xsl:variable name="view_colon_title">查看:</xsl:variable>

<xsl:variable name="options_title">选项</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">更改缺省时区：Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">总览</xsl:variable>

<xsl:variable name="day_tab_title">日</xsl:variable>

<xsl:variable name="week_tab_title">周</xsl:variable>

<xsl:variable name="month_tab_title">月</xsl:variable>

<xsl:variable name="year_tab_title">年</xsl:variable>

<xsl:variable name="comparison_tab_title">比较</xsl:variable>

<xsl:variable name="repeat_title">重复</xsl:variable>

<xsl:variable name="change_repeat_title">更改重复模式</xsl:variable>

<xsl:variable name="alt_jump_prev_month">跳至上个月</xsl:variable>

<xsl:variable name="alt_jump_next_month">跳至下个月</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">今天是： </xsl:variable>

<xsl:variable name="alt_jump_this_date">跳至此日期</xsl:variable>

<xsl:variable name="action_items_title">操作项目</xsl:variable>

<xsl:variable name="invitations_title">邀请</xsl:variable>

<xsl:variable name="no_invitations_msg">无邀请</xsl:variable>

<xsl:variable name="tasks_title">任务</xsl:variable>

<xsl:variable name="overdue_msg">逾期</xsl:variable>

<xsl:variable name="no_tasks_msg">无任务</xsl:variable>

<xsl:variable name="errors_title">错误</xsl:variable>

<xsl:variable name="no_errors_msg">无错误</xsl:variable>

<xsl:variable name="daily_title">每天</xsl:variable>

<xsl:variable name="weekly_title">每周</xsl:variable>

<xsl:variable name="monthly_title">每月</xsl:variable>

<xsl:variable name="yearly_title">每年</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">重复选择：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">仅此一个</xsl:variable>

<xsl:variable name="this_and_future_title">这个和今后的</xsl:variable>

<xsl:variable name="all_instances_title">所有实例</xsl:variable>

<xsl:variable name="repeating_selection_title">重复选择</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">今日到期</xsl:variable>

<xsl:variable name="other_tasks_title">其他任务</xsl:variable>

<xsl:variable name="overdue_tasks_title">逾期任务</xsl:variable>

<xsl:variable name="all_day_events_title">全日事件</xsl:variable>

<xsl:variable name="conflict_msg">冲突</xsl:variable>

<xsl:variable name="overdue_title">逾期</xsl:variable>

<xsl:variable name="due_at_title">到期</xsl:variable>

<xsl:variable name="untitled_task_title">未命名的任务</xsl:variable>

<xsl:variable name="alt_view_this_task">查看此任务</xsl:variable>

<xsl:variable name="alt_delete_this_task">删除此任务</xsl:variable>

<xsl:variable name="untitled_event_title">未命名的事件</xsl:variable>

<xsl:variable name="alt_delete_this_event">删除此事件</xsl:variable>

<xsl:variable name="alt_view_this_event">查看此事件</xsl:variable>

<xsl:variable name="all_day_title">全日</xsl:variable>

<xsl:variable name="overdue_from_title">逾期 于</xsl:variable>

<xsl:variable name="from_txt">于</xsl:variable>

<xsl:variable name="due_on_title">到期</xsl:variable>

<xsl:variable name="not_due_title">无到期日期</xsl:variable>

<xsl:variable name="due_title">到期</xsl:variable>

<xsl:variable name="on_txt">于</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">上午</xsl:variable>

<xsl:variable name="pm_txt">下午</xsl:variable>

<xsl:variable name="midnight_title">午夜</xsl:variable>

<xsl:variable name="noon_title">中午</xsl:variable>

<xsl:variable name="from_title">从</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">安排一个新约会</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">错误列表：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">此面板显示了尚未解决的安排错误列表。</xsl:variable>

<xsl:variable name="organizer_title">组织者</xsl:variable>

<xsl:variable name="attendee_title">参与者</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">没有尚未解决的错误</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">周期：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">周期</xsl:variable>

<xsl:variable name="start_title">启动</xsl:variable>

<xsl:variable name="end_title">结束</xsl:variable>

<xsl:variable name="create_title">创建</xsl:variable>

<xsl:variable name="events_text">事件</xsl:variable>

<xsl:variable name="alert_provide_valid_count">请提供有效计数</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">请提供一个数字，该数字小于或等于</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">此事件的提醒已被设置为事件开始之后的某个时间。单击“取消”以返回并更改时间。</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">此任务的提醒已被设置为任务截止时间之后的某个时间。单击“取消”以返回并更改时间。</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">撰写</xsl:variable>

<xsl:variable name="reminders_title">提醒通知</xsl:variable>

<xsl:variable name="availability_title">空闲时间</xsl:variable>

<xsl:variable name="preview_title">预览</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">邀请列表：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">删除</xsl:variable>

<xsl:variable name="recurring_event_msg">周期事件</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">无重大邀请</xsl:variable>

<xsl:variable name="all_title">全部</xsl:variable>

<xsl:variable name="delete_all_title">删除全部</xsl:variable>

<xsl:variable name="save_and_close_title">保存并关闭</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">您选择了一个空白选项</xsl:variable>

<xsl:variable name="alert_min_year">您不能查看 1970 年之前的年份</xsl:variable>
<xsl:variable name="alert_max_year">您不能查看 2036 年之后的年份</xsl:variable>

<xsl:variable name="alert_invalid_date">该日期无效。请更正。</xsl:variable>

<xsl:variable name="january_title">1 月</xsl:variable>
<xsl:variable name="february_title">2 月</xsl:variable>
<xsl:variable name="march_title">3 月</xsl:variable>
<xsl:variable name="april_title">4 月</xsl:variable>
<xsl:variable name="may_title">5 月</xsl:variable>
<xsl:variable name="june_title">6 月</xsl:variable>
<xsl:variable name="july_title">7 月</xsl:variable>
<xsl:variable name="august_title">8 月</xsl:variable>
<xsl:variable name="september_title">9 月</xsl:variable>
<xsl:variable name="october_title">10 月 </xsl:variable>
<xsl:variable name="november_title">11 月</xsl:variable>
<xsl:variable name="december_title">12 月</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">请提供有效日期</xsl:variable>

<xsl:variable name="provide_good_date_msg">请提供有效日期</xsl:variable>

<xsl:variable name="provide_good_month_msg">请提供一个 1 月至 12 月之间的月份</xsl:variable>

<xsl:variable name="provide_good_year_msg">请提供有效年份。\n\n如果使用两位数表示年份，则小于 37 的值\n将被视为 21 世纪的年份。\n\n例如：03 相当于 2003</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">请提供大于 1970 年的年份</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">请提供小于 2037 年的年份</xsl:variable>

<xsl:variable name="provide_good_hour_msg">请提供有效的小时值。（1 至 12）12 小时制或（0 至 23）24 小时制</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">请提供 0 至 23 之间的有效小时值</xsl:variable>

<xsl:variable name="provide_good_minute_msg">请提供 0 至 59 之间的分钟值</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">请选择开始日期之后的截止日期</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">输入的日期不存在。\n系统正在以下位置将日历设置为最近的有效日期</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">跳至日期：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">跳至前一年</xsl:variable>

<xsl:variable name="alt_jump_next_year">跳至后一年</xsl:variable>

<xsl:variable name="jump_to_date_title">跳至日期</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">是否真想删除本保密项？</xsl:variable>

<xsl:variable name="edit_calendar_page_title">编辑日历：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">表示所需信息。</xsl:variable>

<xsl:variable name="calendar_name_msg">使用短日历名，例如“baseball”（不允许使用空格）</xsl:variable>

<xsl:variable name="display_name_title">显示名称</xsl:variable>

<xsl:variable name="display_name_msg">这是一个可选字段，用于提醒您此日历的目的，例如“比利的棒球赛程”。</xsl:variable>

<xsl:variable name="include_in_availability_msg">要看用户是否有空，请使用本日历</xsl:variable>

<xsl:variable name="calendar_address_title">日历地址</xsl:variable>

<xsl:variable name="calendar_address_msg">要让别人访问本日历，需要将以下链接提供给他们。如果已设置相应访问控制允许他们访问，他们即可在浏览器中使用该链接查看本日历。</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">日历的权限：</xsl:variable>

<xsl:variable name="cal_permissions_msg">其他人是否可以查看和更改日历皆取决于权限的设置。若要将某些权限授予全部用户，请在“每人”旁边的列中选择适当的权限。若要将某些权限授予某些人，请在“用户”字段中输入他们的用户 ID ，并单击“添加用户”按钮，然后在用户名称旁的列中选择适当的权限。</xsl:variable>

<xsl:variable name="user_title">用户</xsl:variable>
<xsl:variable name="user_title_with_colon">用户：</xsl:variable>

<xsl:variable name="permissions_title">权限</xsl:variable>

<xsl:variable name="invite_title">邀请&nbsp;&nbsp;</xsl:variable>

<xsl:variable name="read_title">阅读</xsl:variable>

<xsl:variable name="modify_title">修改</xsl:variable>

<xsl:variable name="delete_selected_user_title">删除选取的用户</xsl:variable>

<xsl:variable name="add_user_title">添加用户</xsl:variable>

<xsl:variable name="everybody_title">每人</xsl:variable>

<xsl:variable name="this_domain_title">此域</xsl:variable>

<xsl:variable name="tip_cal_owners">指定日历所有者的提示：</xsl:variable>

<xsl:variable name="cal_owner_msg">您可以为日历添加一个或多个所有者。所有者能够以主要所有者的名义采取行动，即回复邀请、创建、修改和删除事件。</xsl:variable>

<xsl:variable name="no_owners_msg">无所有者。</xsl:variable>

<xsl:variable name="delete_owner_title">删除所有者</xsl:variable>

<xsl:variable name="add_owner_title">添加所有者</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">是否确实要删除本日历？</xsl:variable>

<xsl:variable name="alert_supply_cal_name">您必须提供日历名称</xsl:variable>

<xsl:variable name="owners_title">所有者</xsl:variable>

<xsl:variable name="time_zones_title">时区</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">是否确实要删除本事件？</xsl:variable>

<xsl:variable name="edit_event_page_title">编辑事件：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---快速邀请---</xsl:variable>

<xsl:variable name="event_title_title">事件标题</xsl:variable>

<xsl:variable name="date_title">日期</xsl:variable>

<xsl:variable name="time_title">时间</xsl:variable>

<xsl:variable name="all_day_msg">全日（例如，假期或生日）</xsl:variable>

<xsl:variable name="privacy_title">保密</xsl:variable>

<xsl:variable name="public_event_title">公用事件</xsl:variable>

<xsl:variable name="confidential_event_title">仅时间与日期</xsl:variable>

<xsl:variable name="private_event_title">私人事件</xsl:variable>

<xsl:variable name="location_title">地点</xsl:variable>

<xsl:variable name="invite_others_msg">邀请其他用户或资源：</xsl:variable>

<xsl:variable name="search_title">搜索(S)...</xsl:variable>

<xsl:variable name="inform_title">通知</xsl:variable>

<xsl:variable name="invite_instructions_msg">（输入用户 ID、日历 ID 或电子邮件地址。若您不知道名称，请单击“搜索”。）</xsl:variable>

<xsl:variable name="invitees_title">被邀请人</xsl:variable>

<xsl:variable name="no_invitees_msg">无被邀请人</xsl:variable>

<xsl:variable name="remove_title">移除</xsl:variable>

<xsl:variable name="inform_event_title">通知事件情况</xsl:variable>

<xsl:variable name="no_informees_msg">无被邀请人</xsl:variable>

<xsl:variable name="event_reminders_msg">您可为该事件发送电子邮件通知给自己。请在下方输入一个或多个您的电子邮件地址。并以逗号 (,) 或分号 (;) 分隔电子邮件地址。</xsl:variable>

<xsl:variable name="remind_title">提醒</xsl:variable>

<xsl:variable name="alert_provide_valid_time">请提供有效的时间</xsl:variable>

<xsl:variable name="hours_text">小时</xsl:variable>

<xsl:variable name="days_text">天</xsl:variable>

<xsl:variable name="before_the_event_begins_text">在事件开始之前的</xsl:variable>

<xsl:variable name="at_text">于</xsl:variable>

<xsl:variable name="text_reminder_msg">您可以发送带有文本信息的电子邮件提醒通知。</xsl:variable>

<xsl:variable name="message_title">邮件</xsl:variable>

<xsl:variable name="title_title">标题</xsl:variable>

<xsl:variable name="attendees_title">参与者</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">确定要删除吗？</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">编辑日历组：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---快速添加---</xsl:variable>

<xsl:variable name="delete_calendar_text">是否确实要删除本日历？</xsl:variable>

<xsl:variable name="group_name_title">组名称</xsl:variable>

<xsl:variable name="group_view_msg">在日视图中打开组（默认情况下，组会在比较视图中打开。）</xsl:variable>

<xsl:variable name="calendar_id_title">日历 ID</xsl:variable>

<xsl:variable name="add_title">添加</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">（输入日历 ID。若您不知道 ID，请单击“搜索”。）</xsl:variable>

<xsl:variable name="group_members_title">组成员</xsl:variable>

<xsl:variable name="group_description_msg">此处提供有关组的说明。也可以确定本组的日视图是否分别显示各个日历</xsl:variable>

<xsl:variable name="day_view_title">日视图</xsl:variable>

<xsl:variable name="day_view_merge_msg">默认情况下，日视图中的日历分开显示。</xsl:variable>

<xsl:variable name="alert_group_name">您必须为组提供一个名称</xsl:variable>

<xsl:variable name="calendar_group_title">日历组</xsl:variable>

<xsl:variable name="details_title">详细资料</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">是否真想删除本任务？</xsl:variable>

<xsl:variable name="edit_task_page_title">编辑任务：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">撰写任务</xsl:variable>

<xsl:variable name="task_title_title">任务标题</xsl:variable>

<xsl:variable name="due_date_title">到期日期</xsl:variable>

<xsl:variable name="no_time_title">无到期时间</xsl:variable>

<xsl:variable name="public_task_title">公用任务</xsl:variable>

<xsl:variable name="confidential_task_title">仅时间与日期</xsl:variable>

<xsl:variable name="private_task_title">私人任务</xsl:variable>

<xsl:variable name="status_title">状态</xsl:variable>

<xsl:variable name="complete_title">完成</xsl:variable>

<xsl:variable name="task_reminder_msg">您可为该任务发送电子邮件通知给自己。请在下方输入一个或多个您的电子邮件地址。并以逗号 (,) 或分号 (;) 分隔电子邮件地址。</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">您不能为无到期日期的任务设置警告</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">在任务到期之前的</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">外观</xsl:variable>

<xsl:variable name="settings_title">设置</xsl:variable>

<xsl:variable name="import_title">导入</xsl:variable>

<xsl:variable name="export_title">导出</xsl:variable>

<xsl:variable name="settings_msg">使用该表单来修改 Calendar Express 的行为。</xsl:variable>

<xsl:variable name="default_view_title">默认初始视图</xsl:variable>

<xsl:variable name="default_view_msg">登录之后始终显示以下视图：</xsl:variable>

<xsl:variable name="default_group_title">默认日历组</xsl:variable>

<xsl:variable name="default_group_msg">登录之后始终显示以下日历组：</xsl:variable>

<xsl:variable name="no_cal_group_title">无日历组</xsl:variable>

<xsl:variable name="date_format_msg">按以下顺序显示简短日期：</xsl:variable>

<xsl:variable name="m_d_y_format_text">月/日/年</xsl:variable>

<xsl:variable name="d_m_y_format_text">日/月/年</xsl:variable>

<xsl:variable name="y_m_d_format_text">年/月/日</xsl:variable>

<xsl:variable name="date_delimiter_msg">使用以下字符分隔简短日期：</xsl:variable>

<xsl:variable name="use_12_clock_msg">使用 12 小时时钟</xsl:variable>

<xsl:variable name="use_24_clock_msg">使用 24 小时时钟</xsl:variable>

<xsl:variable name="day_title">日</xsl:variable>

<xsl:variable name="day_starts_msg">日开始时间：</xsl:variable>

<xsl:variable name="day_ends_msg">日结束时间：</xsl:variable>

<xsl:variable name="day_interval_msg">拆分日为</xsl:variable>

<xsl:variable name="every_15_minutes_text">每十五分钟</xsl:variable>

<xsl:variable name="every_half_hour_text">每半小时</xsl:variable>

<xsl:variable name="every_hour_text">每小时</xsl:variable>

<xsl:variable name="every_2_hours_text">每两小时</xsl:variable>

<xsl:variable name="every_four_hours_text">每四小时</xsl:variable>

<xsl:variable name="first_dow_title">每星期开始于</xsl:variable>

<xsl:variable name="sunday_title">星期日</xsl:variable>

<xsl:variable name="monday_title">星期一</xsl:variable>

<xsl:variable name="tuesday_title">星期二</xsl:variable>

<xsl:variable name="wednesday_title">星期三</xsl:variable>

<xsl:variable name="thursday_title">星期四</xsl:variable>

<xsl:variable name="friday_title">星期五</xsl:variable>

<xsl:variable name="saturday_title">星期六</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">从周视图与月视图中排除星期六与星期日</xsl:variable>

<xsl:variable name="default_tz_msg">默认情况下，利用以下时区显示日期和时间：</xsl:variable>

<xsl:variable name="none_selected_title">未做选择</xsl:variable>

<xsl:variable name="single_tz_use_msg">显示单个日历时采用该日历的时区</xsl:variable>

<xsl:variable name="tz_timescales_msg">显示每个日历时区的时标</xsl:variable>

<xsl:variable name="event_task_reminders_title">事件与任务提醒通知</xsl:variable>

<xsl:variable name="email_reminder_msg">以电子邮件方式给我发送提醒通知</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">请提供提醒通知的有效时间间隔</xsl:variable>

<xsl:variable name="before_every_event_task_text">在每个事件与任务之前的</xsl:variable>

<xsl:variable name="note_title">备注：</xsl:variable>

<xsl:variable name="reminders_tip_msg">若要将提醒通知发送到多个电子邮件地址（例如：abc@company22.com 和 abc@sesta.com），请以逗号 (,) 或分号 (;) 分隔电子邮件地址。</xsl:variable>

<xsl:variable name="event_notifications_title">事件通知</xsl:variable>

<xsl:variable name="event_notifications_msg">每当有人在我的日历上安排事件时，以电子邮件方式给我发送通知</xsl:variable>

<xsl:variable name="only_one_email_msg">只允许提供一个电子邮件地址。</xsl:variable>

<xsl:variable name="alert_only_one_email">请仅提供一个用于事件通知的电子邮件地址</xsl:variable>

<xsl:variable name="declined_events_delete_title">已拒绝的事件</xsl:variable>

<xsl:variable name="declined_events_delete_msg">不显示已拒绝的事件</xsl:variable>

<xsl:variable name="appearance_msg">使用此表单修改 Calendar Express 的外观。</xsl:variable>

<xsl:variable name="color_scheme_title">颜色模式</xsl:variable>

<xsl:variable name="toolbar_title">工具栏</xsl:variable>

<xsl:variable name="icons_and_text_msg">显示图标和文本</xsl:variable>

<xsl:variable name="icons_only_msg">只显示图标</xsl:variable>

<xsl:variable name="text_only_msg">只显示文本</xsl:variable>

<xsl:variable name="display_font_title">显示字体</xsl:variable>

<xsl:variable name="face_title">字型</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">大小</xsl:variable>

<xsl:variable name="larger_title">较大</xsl:variable>

<xsl:variable name="default_title">默认</xsl:variable>

<xsl:variable name="smaller_title">较小</xsl:variable>

<xsl:variable name="event_destination_title">事件的目标</xsl:variable>

<xsl:variable name="session_expired_msg">您的会话已过期</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">您必须指定一个有效的日历</xsl:variable>

<xsl:variable name="add_events_to_text">添加事件到</xsl:variable>

<xsl:variable name="select_calendar_title">选择日历：</xsl:variable>

<xsl:variable name="import_format_title">导入格式</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook 格式</xsl:variable>

<xsl:variable name="source_file_invalid_error">指定的源文件无效</xsl:variable>

<xsl:variable name="format_file_mismatch_error">指定的格式与源文件不匹配</xsl:variable>

<xsl:variable name="successful_import_msg">文件导入成功</xsl:variable>

<xsl:variable name="source_file_title">源文件</xsl:variable>

<xsl:variable name="date_range_title">日期范围</xsl:variable>

<xsl:variable name="import_all_msg">从文件导入所有事件</xsl:variable>

<xsl:variable name="invalid_date_range_error">您指定的日期范围无效</xsl:variable>

<xsl:variable name="beginning_title">开始于</xsl:variable>

<xsl:variable name="ending_title">结束于</xsl:variable>

<xsl:variable name="calendars_to_export_title">要导出的日历</xsl:variable>

<xsl:variable name="addarrow_title">添加 &gt;&gt;</xsl:variable>

<xsl:variable name="export_all_msg">导出所有事件</xsl:variable>

<xsl:variable name="export_format_title">导出格式</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">日结束时间应晚于日开始时间</xsl:variable>

<xsl:variable name="save_changes_title">保存更改</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">当前日历：</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">重复模式</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">无效的重复模式: 请选择重复发生的日期</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">不能对单一实例变更重复模式</xsl:variable>

<xsl:variable name="recurrence_skips_title">一个重复发生的事件的实例不能跳过另一个重复发生的事件的实例</xsl:variable>

<xsl:variable name="recurrence_same_day">两个重复发生的事件的实例不能在同一天发生</xsl:variable>

<xsl:variable name="recurrence_privacy">不能只变更一个实例的保密性</xsl:variable>

<xsl:variable name="every_day_title">每日</xsl:variable>

<xsl:variable name="every_weekday_title">每工作日</xsl:variable>

<xsl:variable name="every_title">每</xsl:variable>

<xsl:variable name="weekday_text">工作日</xsl:variable>

<xsl:variable name="weekendday_text">周末</xsl:variable>

<xsl:variable name="m_w_f_text">星期一、星期三和星期五</xsl:variable>

<xsl:variable name="t_th_text">星期二和星期四</xsl:variable>

<xsl:variable name="sat_sun_text">星期六和星期日</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">请提供有效的间隔</xsl:variable>

<xsl:variable name="every_week_title">每星期</xsl:variable>

<xsl:variable name="weeks_text">星期</xsl:variable>

<xsl:variable name="repeat_on_title">按以下方式重复</xsl:variable>

<xsl:variable name="sunday_abbrev">星期日</xsl:variable>

<xsl:variable name="monday_abbrev">星期一</xsl:variable>

<xsl:variable name="tuesday_abbrev">星期二</xsl:variable>

<xsl:variable name="wednesday_abbrev">星期三</xsl:variable>

<xsl:variable name="thursday_abbrev">星期四</xsl:variable>

<xsl:variable name="friday_abbrev">星期五</xsl:variable>

<xsl:variable name="saturday_abbrev">星期六</xsl:variable>

<xsl:variable name="every_month_title">每月</xsl:variable>

<xsl:variable name="months_text">月</xsl:variable>

<xsl:variable name="ordinal_1">1 日</xsl:variable>
<xsl:variable name="ordinal_2">2 日</xsl:variable>
<xsl:variable name="ordinal_3">3 日</xsl:variable>
<xsl:variable name="ordinal_4">4 日</xsl:variable>
<xsl:variable name="ordinal_5">5 日</xsl:variable>
<xsl:variable name="ordinal_6">6 日</xsl:variable>
<xsl:variable name="ordinal_7">7 日</xsl:variable>
<xsl:variable name="ordinal_8">8 日</xsl:variable>
<xsl:variable name="ordinal_9">9 日</xsl:variable>
<xsl:variable name="ordinal_10">10 日</xsl:variable>
<xsl:variable name="ordinal_11">11 日</xsl:variable>
<xsl:variable name="ordinal_12">12 日</xsl:variable>
<xsl:variable name="ordinal_13">13 日</xsl:variable>
<xsl:variable name="ordinal_14">14 日</xsl:variable>
<xsl:variable name="ordinal_15">15 日</xsl:variable>
<xsl:variable name="ordinal_16">16 日</xsl:variable>
<xsl:variable name="ordinal_17">17 日</xsl:variable>
<xsl:variable name="ordinal_18">18 日</xsl:variable>
<xsl:variable name="ordinal_19">19 日</xsl:variable>
<xsl:variable name="ordinal_20">20 日</xsl:variable>
<xsl:variable name="ordinal_21">21 日</xsl:variable>
<xsl:variable name="ordinal_22">22 日</xsl:variable>
<xsl:variable name="ordinal_23">23 日</xsl:variable>
<xsl:variable name="ordinal_24">24 日</xsl:variable>
<xsl:variable name="ordinal_25">25 日</xsl:variable>
<xsl:variable name="ordinal_26">26 日</xsl:variable>
<xsl:variable name="ordinal_27">27 日</xsl:variable>
<xsl:variable name="ordinal_28">28 日</xsl:variable>
<xsl:variable name="ordinal_29">29 日</xsl:variable>
<xsl:variable name="ordinal_30">30 日</xsl:variable>
<xsl:variable name="ordinal_31">31 日</xsl:variable>

<xsl:variable name="ordinal2_1">第一个</xsl:variable>
<xsl:variable name="ordinal2_2">第二个</xsl:variable>
<xsl:variable name="ordinal2_3">第三个</xsl:variable>
<xsl:variable name="ordinal2_4">第四个</xsl:variable>

<xsl:variable name="day_of_month_text">日</xsl:variable>
<xsl:variable name="cap_last_text">最后一个</xsl:variable>

<xsl:variable name="of_month_text">月</xsl:variable>

<xsl:variable name="every_year_text">每年</xsl:variable>

<xsl:variable name="years_text">年</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">这是一个重复事件。仅删除此事件，还是删除所有事件？</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">这是一个重复事件。仅将更改应用到此事件，还是应用到所有事件？</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">这是一个重复任务。仅删除此任务，还是删除所有任务？</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">这是一个重复任务。仅将更改应用到此任务，还是应用到所有任务？</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">汇总</xsl:variable>

<xsl:variable name="reply_title">回复</xsl:variable>

<xsl:variable name="will_attend_msg">我要加入</xsl:variable>

<xsl:variable name="will_not_attend_msg">我不参加</xsl:variable>

<xsl:variable name="confirm_later_msg">我将会在以后确认。</xsl:variable>

<xsl:variable name="reply_reminders_msg">请在此处提供电子邮件地址（以逗号或分号分隔）并选择发送日期和时间，以安排电子邮件提醒。</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">您无法在事件开始之前为尚未确认的事件设置警报</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">使用以下空间提供提醒的附加信息。所有提醒中将自动包括事件的标题、日期、时间和位置。</xsl:variable>

<xsl:variable name="cal_select_msg">选择要在其中保存事件的日历</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">日历搜索：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">搜索日历</xsl:variable>

<xsl:variable name="cal_search_msg1">搜索日历，其中</xsl:variable>
        
<xsl:variable name="name_or_id_text">名称或 ID</xsl:variable>

<xsl:variable name="name_text">名称</xsl:variable>

<xsl:variable name="primary_owner_text">主要所有者</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">包含</xsl:variable>

<xsl:variable name="begins_with_text">开头为</xsl:variable>

<xsl:variable name="search_plain_title">搜索</xsl:variable>

<xsl:variable name="already_selected_cals_title">已选择的日历</xsl:variable>

<xsl:variable name="cal_id_title">日历 ID</xsl:variable>

<xsl:variable name="search_results_title">搜索结果</xsl:variable>

<xsl:variable name="no_match_found_msg">找不到匹配项目</xsl:variable>

<xsl:variable name="owner_title">所有者</xsl:variable>

<xsl:variable name="owner_name_colon_title">所有者名称</xsl:variable>

<xsl:variable name="cal_name_title">日历名称</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">搜索：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">搜索包含以下内容的事件和任务</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">用户搜索：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">搜索用户</xsl:variable>

<xsl:variable name="search_local_msg">搜索本地目录</xsl:variable>

<xsl:variable name="search_user_instruct_msg">（输入名字、姓氏或用户 ID）</xsl:variable>

<xsl:variable name="legend_title">图例：</xsl:variable>

<xsl:variable name="resource_title">资源；</xsl:variable>

<xsl:variable name="already_selected_users_title">已选取的用户</xsl:variable>

<xsl:variable name="name_userid_title">名称（用户 ID）</xsl:variable>

<xsl:variable name="name_title">名称</xsl:variable>

<xsl:variable name="userid_title">用户 ID</xsl:variable>

<xsl:variable name="email_title">电子邮件</xsl:variable>

<xsl:variable name="for_text">后的</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">任务列表：Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">利用该窗格来跟踪您全部的待办事件。您可以通过单击“完成”列中复选框的办法，将任务标记为“已完成”。单击“保存与关闭”来完成修改。</xsl:variable>

<xsl:variable name="done_title">完成</xsl:variable>

<xsl:variable name="task_title">任务</xsl:variable>

<xsl:variable name="select_all_title">选择全部</xsl:variable>

<xsl:variable name="alert_processing">处理中</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">任务</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">帮助</xsl:variable>

<xsl:variable name="logout_text">注销</xsl:variable>

<xsl:variable name="login_text">登录</xsl:variable>

<xsl:variable name="home_text">主页</xsl:variable>

<xsl:variable name="alt_schedule_msg">安排会议、生日或其他事件</xsl:variable>

<xsl:variable name="new_event_title">新建事件</xsl:variable>

<xsl:variable name="alt_todo_msg">向您的待办事件列表中添加项目</xsl:variable>

<xsl:variable name="new_task_title">新建任务</xsl:variable>

<xsl:variable name="jump_to_title">跳至</xsl:variable>

<xsl:variable name="alt_print_msg">打开当前视图适合打印的版本</xsl:variable>

<xsl:variable name="printable_title">打印专用</xsl:variable>

<xsl:variable name="alt_search_msg">搜索事件和任务</xsl:variable>

<xsl:variable name="alt_new_calendar">新建一个日历</xsl:variable>

<xsl:variable name="new_cal_title">新建日历</xsl:variable>

<xsl:variable name="alt_new_group">新创建一个日历分组</xsl:variable>

<xsl:variable name="new_group_title">新建组</xsl:variable>

<xsl:variable name="alt_search_cals">搜索日历</xsl:variable>

<xsl:variable name="subscribe_title">预定</xsl:variable>

<xsl:variable name="paren_subscribed_title">（已预定）</xsl:variable>

<xsl:variable name="alt_jump_next_week">跳至下星期</xsl:variable>

<xsl:variable name="alt_jump_prev_week">跳至上星期</xsl:variable>

<xsl:variable name="sunday_letter_title">日</xsl:variable>
<xsl:variable name="monday_letter_title">一</xsl:variable>
<xsl:variable name="tuesday_letter_title">二</xsl:variable>
<xsl:variable name="wednesday_letter_title">三</xsl:variable>
<xsl:variable name="thursday_letter_title">四</xsl:variable>
<xsl:variable name="friday_letter_title">五</xsl:variable>
<xsl:variable name="saturday_letter_title">六</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">选取的事件将从您的日历中删除。对于周期事件，仅删除带有错误的实例。单击“确定”继续。</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">如果在显示日历组的同时创建事件，将邀请组内的所有日历</xsl:variable>

<xsl:variable name="invite_this_group_msg">如果在显示此日历组的同时创建事件，将邀请组内的所有日历</xsl:variable>

<xsl:variable name="group_invitations_title">组邀请</xsl:variable>

<xsl:variable name="starting_at_txt">开始于</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">未知</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">无参与者</xsl:variable>

<xsl:variable name="today_title">今日</xsl:variable>

<xsl:variable name="confirm_event_delete_text">要删除此事件吗？</xsl:variable>
<xsl:variable name="confirm_task_delete_text">要删除此任务吗？</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">无法连接到后端 DWP。</xsl:variable>
<xsl:variable name="dwp_max_connections_error">由于已达后端连接最大值，所以无法进行提取。</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">自后端 DWP 提取日历时发现错误的数据。</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">无法解析后端 DWP。</xsl:variable>
<xsl:variable name="dwp_down_error">已关闭</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP 主机环境不可用。</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">无法解析 DWP 主机。</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">无数据 - 无法访问后端数据库。</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">在计算可用性时包括此事件</xsl:variable>
<xsl:variable name="freebusy_title">空闲/忙</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">您正在创建一个“全天”事件，此事件将在计算可用性时使用。如果 此事件不正确，请点击“取消”返回并取消选择“空闲/忙”复选框。</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">您正在创建一个专用事件，此事件将在计算可用性时使用。如果此事件不正确，请点击“取消”返回并取消选择“空闲/忙”复选框。</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">日历数据库处于只读模式。</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">没有结束日期 </xsl:variable>
<xsl:variable name="cap_the_text">第 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 移除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) >0)) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>欢迎  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>日历上 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>的日历 (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>开始于 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 小时</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分钟</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>1 小时以上</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 空闲）</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 最多创建 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 个实例</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>任何地区的一个或多个时区都可以与当前日历相关联。在带网格的视图（如日视图）中，与日历关联的所有时区 都成为视图时标的一部分。如果没有为此日历指定时区，则使用默认时区。可用的时区如下： </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>任何地区的一个时区都可以与当前日历相关联。在带网格的视图（如日视图）中，与日历关联的时区成为视图时 标的一部分。如果没有为此日历指定时区，则使用默认时区。可用的时区如下： </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北美/南美地区 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>欧洲/非洲 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>亚洲/太平洋周边 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>区域：</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>下列事件已由“</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>”添加到您的日历中。通过选择您认为合适的回复，您就可以接受或谢绝该邀请。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>单击</xsl:text>&nbsp;
  <B><xsl:text>浏览...</xsl:text></B>&nbsp;
  <xsl:text>来选择文件。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>使用此窗口接受 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 或拒绝 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 邀请，或保留未决定 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 对参加某事件的邀请。</xsl:text>
  <br/>
  <xsl:text>对于周期事件，设置将应用于整个序列。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>搜索少于 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 个字符，结果可能不完整。若要改进搜索结果，请尝试使用至少 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 个字符。　</xsl:text>

</xsl:template>


</xsl:stylesheet>
