<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<!-- The parameters get passed in because it could be and event or a task -->
<xsl:template name="recurrence_root">
<xsl:param name="e_rrule_byMonthRule"/>
<xsl:param name="e_rrule_freq"/>
<xsl:param name="e_rrule_interval"/>
<xsl:param name="e_rrule_byDay"/>
<xsl:param name="e_rrule_byMonthDay"/>
<xsl:param name="e_rrule_byMonth"/>
<xsl:param name="e_rrule_bySetPos"/>
<xsl:param name="e_rrule_daily"/>
<xsl:param name="e_rrule_weekly"/>
<xsl:param name="e_rrule_monthly"/>
<xsl:param name="e_rrule_yearly"/>
<xsl:param name="e_rrule_SU"/>
<xsl:param name="e_rrule_MO"/>
<xsl:param name="e_rrule_TU"/>
<xsl:param name="e_rrule_WE"/>
<xsl:param name="e_rrule_TH"/>
<xsl:param name="e_rrule_FR"/>
<xsl:param name="e_rrule_SA"/>
<xsl:param name="e_rrule_notset"/>
<xsl:param name="e_existingRRule"/>
<xsl:param name="durHour"/>
<xsl:param name="durMinute"/>
<xsl:param name="allDay"/>
<xsl:param name="typeSelection"/>

<html>

  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<body bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="12">
 <xsl:attribute name="onload">
    var today='<xsl:value-of select="/calendar/timectx/SelectedTime/@dow"/>';
    var currDayOfWeek = parseInt(today);
    var localForm = parent.frames[1].document.forms[0];
    if(localForm['REPEATER'][1].checked) {
        if (currDayOfWeek == 1) {
	  	localForm['BYDAY_1'].checked = true; 
	} else if (currDayOfWeek == 2) {
	  	localForm['BYDAY_2'].checked = true; 
	} else if (currDayOfWeek == 3) {
	  	localForm['BYDAY_3'].checked = true; 
	} else if (currDayOfWeek == 4) {
	  	localForm['BYDAY_4'].checked = true;
	} else if (currDayOfWeek == 5) {
	  	localForm['BYDAY_5'].checked = true; 
	} else if (currDayOfWeek == 6) {
	  	localForm['BYDAY_6'].checked = true; 
	} else if (currDayOfWeek == 7) {
	  	localForm['BYDAY_7'].checked = true;
	} else ;

    }  
    window.focus()
  </xsl:attribute>

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<xsl:variable name="repeat_type_value">
<!-- If we're reloading this page due to type switch, use that value -->
<xsl:choose>
  <xsl:when test="$typeSelection">
    <xsl:value-of select="$typeSelection"/>
  </xsl:when>
  <xsl:otherwise>
<!-- Otherwise use the event's original value -->
    <xsl:choose>
      <xsl:when test="string-length($e_rrule_daily) &gt; 0">1</xsl:when>
      <xsl:when test="string-length($e_rrule_monthly) &gt; 0">3</xsl:when>
      <xsl:when test="string-length($e_rrule_yearly) &gt; 0">4</xsl:when>
      <xsl:otherwise>2</xsl:otherwise>
    </xsl:choose>
  </xsl:otherwise>
</xsl:choose>
</xsl:variable>

  <table border="0" cellpadding="3" cellspacing="1" width="100%">
    <tr>
      <td colspan="2"><font size="{$font_size_big_2}" face="{$font_name}"><b>重复模式</b></font></td>
    </tr>
    <tr>
<!-- The column holding the radio buttons to select the type of repeat -->
      <td>
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="REPEATER" value="1">
                <xsl:if test="($repeat_type_value = '1')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
            <xsl:attribute name="onClick">
              var f = document.forms[0];
              f['myaction'].value='update_recurrence';
              if (untilddCheck('until',f) != 0) {
                return;
              }
              if (ddCheck('',f) != 0) {
                return;
              }
              f.submit();
            </xsl:attribute>
              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每天</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="REPEATER" value="2">
                <xsl:if test="($repeat_type_value = '2')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
            <xsl:attribute name="onClick">
              var f = document.forms[0];
              f['myaction'].value='update_recurrence';
              if (untilddCheck('until',f) != 0) {
                return;
              }
              if (ddCheck('',f) != 0) {
                return;
              }
              f.submit();
            </xsl:attribute>

              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每周</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="REPEATER" value="3">
                <xsl:if test="($repeat_type_value = '3')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
            <xsl:attribute name="onClick">
              var f = document.forms[0];
              f['myaction'].value='update_recurrence';
              if (untilddCheck('until',f) != 0) {
                return;
              }
              if (ddCheck('',f) != 0) {
                return;
              }
              f.submit();
            </xsl:attribute>
              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每月</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="REPEATER" value="4">
                <xsl:if test="($repeat_type_value = '4')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
            <xsl:attribute name="onClick">
              var f = document.forms[0];
              f['myaction'].value='update_recurrence';
              if (untilddCheck('until',f) != 0) {
                return;
              }
              if (ddCheck('',f) != 0) {
                return;
              }
              f.submit();
            </xsl:attribute>
              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每年</font>
            </td>
          </tr>
        </table>
      </td>
<!-- The variable portion of the table depending on which radio button was selected -->
      <td>
<!-- this table is just inserted to outline this block of information -->
<table border="2" cellspacing="3">
<tr>
<td>
<!-- Choose which type of repeat we're doing to provide appropriate controls -->
<!-- This could be broken in to a separate template but that would require much parameter passing -->
   <xsl:choose>
<!-- daily repeat options -->
   <xsl:when test="($repeat_type_value = '1')">
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="DAILY" value="1">
                <xsl:if test="(string-length($e_rrule_daily) = 0) or ($e_rrule_daily = '1')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每日</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="DAILY" value="2">
                <xsl:if test="$e_rrule_daily = '2'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
	    <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每工作日</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="DAILY" value="3">
                <xsl:if test="$e_rrule_daily='3'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td valign="baseline">
              <xsl:call-template name="interval_selector">
                <xsl:with-param name="interval_type">DAILY</xsl:with-param>           
                <xsl:with-param name="rrule_num" select="$e_rrule_daily"/>
                <xsl:with-param name="rrule_interval" select="$e_rrule_interval"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
<!-- end daily repeat options -->
   </xsl:when>
<!-- weekly repeat options -->
   <xsl:when test="($repeat_type_value = '2')">
    <table border="0">
     <tr>
      <td>
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="WEEKLY" value="1">
                <xsl:if test="($e_rrule_weekly != '3')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td valign="baseline">
              <font size="{$font_size_big_2}" face="{$font_name}">每星期</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="WEEKLY" value="3">
                <xsl:if test="$e_rrule_weekly = '3'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td valign="baseline">
              <xsl:call-template name="interval_selector">
                <xsl:with-param name="interval_type">WEEKLY</xsl:with-param>           
                <xsl:with-param name="rrule_num" select="$e_rrule_weekly"/>
                <xsl:with-param name="rrule_interval" select="$e_rrule_interval"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td><font size="{$font_size_big_2}" face="{$font_name}"><b>按以下方式重复</b></font></td>
    </tr>
    <tr>
      <td>
        <table border="0" cellspacing="0">
          <tr>
            <td>
<!-- argv elements cannot have the same name, so each BYDAY gets a differentiating number -->
              <input type="checkbox" name="BYDAY_1" value="SU">
                <xsl:if test="$e_rrule_SU='SU'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期日 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_2" value="MO">
                <xsl:if test="$e_rrule_MO='MO'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期一 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_3" value="TU">
                <xsl:if test="$e_rrule_TU='TU'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期二 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_4" value="WE">
                <xsl:if test="$e_rrule_WE='WE'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期三 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_5" value="TH">
                <xsl:if test="$e_rrule_TH='TH'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期四 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_6" value="FR">
                <xsl:if test="$e_rrule_FR='FR'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期五 </font></td>
            <td>
              <input type="checkbox" name="BYDAY_7" value="SA">
                <xsl:if test="$e_rrule_SA='SA'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td><font size="{$font_size_big_2}" face="{$font_name}">星期六 </font></td>
          </tr>
        </table>
        </td>
        </tr>
        </table>
<!-- end weekly repeat options -->
   </xsl:when>
<!-- monthly repeat options -->
   <xsl:when test="($repeat_type_value = '3')">
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="MONTHLY" value="1">
                <xsl:if test="($e_rrule_monthly != '3')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
              <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>每月</font>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="MONTHLY" value="3">
                <xsl:if test="$e_rrule_monthly = '3'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
              <xsl:call-template name="interval_selector">
                <xsl:with-param name="interval_type">MONTHLY</xsl:with-param>           
                <xsl:with-param name="rrule_num" select="$e_rrule_monthly"/>
                <xsl:with-param name="rrule_interval" select="$e_rrule_interval"/>
              </xsl:call-template>
            </td>
          </tr>
          <tr>
            <td>
              <font size="{$font_size_big_2}" face="{$font_name}"><b>按以下方式重复</b></font>
            </td>
         </tr>
         <tr>
           <td>
             <table border="0" cellspacing="0">
            <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="bymonthrule" value="BYMONTHDAY">
                <xsl:if test="($e_rrule_byMonthRule='BYMONTHDAY') or ($e_rrule_notset='true')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td>
              <xsl:call-template name="monthday_ordinal_selector">
                <xsl:with-param name="selector_type">MONTHLY</xsl:with-param>
                <xsl:with-param name="rrule_bymonthday" select="$e_rrule_byMonthDay"/>
              </xsl:call-template>
           </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="bymonthrule" value="BYDAY">
                <xsl:if test="$e_rrule_byMonthRule='BYDAY'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td>
              <xsl:call-template name="month_byweekday_selector">
                <xsl:with-param name="selector_type">MONTHLY</xsl:with-param>
                <xsl:with-param name="rrule_bysetpos" select="$e_rrule_bySetPos"/>
                <xsl:with-param name="rrule_byday" select="$e_rrule_byDay"/>
		<xsl:with-param name="rrule_interval" select="$e_rrule_interval"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        </td>
        </tr>
       </table>
<!-- end monthly repeat options -->
   </xsl:when>
<!-- yearly repeat options -->
   <xsl:when test="($repeat_type_value = '4')">
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="YEARLY" value="1">
                <xsl:if test="($e_rrule_yearly != '3')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
              <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>每年</font>
            </td>
          </tr>
    <tr>
      <td><font size="{$font_size_big_2}" face="{$font_name}"><b>按以下方式重复</b></font></td>
    </tr>
    <tr>
      <td>
        <table border="0" cellspacing="0">
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="bymonthrule" value="BYMONTHDAY">
                <xsl:if test="($e_rrule_byMonthRule='BYMONTHDAY') or ($e_rrule_notset='true')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td>
             <xsl:call-template name="monthday_ordinal_selector">
               <xsl:with-param name="selector_type">YEARLY</xsl:with-param>           
               <xsl:with-param name="rrule_bymonthday" select="$e_rrule_byMonthDay"/>
               <xsl:with-param name="rrule_bymonth" select="$e_rrule_byMonth"/>
             </xsl:call-template>
            </td>
          </tr>
          <tr>
            <td valign="baseline" width="1%">
              <input type="radio" name="bymonthrule" value="BYDAY">
                <xsl:if test="$e_rrule_byMonthRule='BYDAY'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
            </td>
            <td>
              <xsl:call-template name="month_byweekday_selector">
                <xsl:with-param name="selector_type">YEARLY</xsl:with-param>
                <xsl:with-param name="rrule_bysetpos" select="$e_rrule_bySetPos"/>
                <xsl:with-param name="rrule_byday" select="$e_rrule_byDay"/>
                <xsl:with-param name="rrule_bydaymonth" select="$e_rrule_byMonth"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        </td>
        </tr>
        </table>
<!-- end yearly repeat options -->
   </xsl:when>
   </xsl:choose>
      </td>
    </tr>
  </table>
<!-- end the table that causes the border -->
</td>
</tr>
</table>

  <hr size="{$font_size_big}"/>
  <xsl:call-template name="recurrenceTimeTable"/>

</FORM>
</body>
</html>

</xsl:template>


<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">每天</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">每周</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">3</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">每月</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[3]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">4</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">yearly_title</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[4]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="ok" value="确定" width="72">
          <xsl:attribute name="onClick">
            var openerForm = parent.opener.parent.frames[1].document.forms[0];
            var localForm = parent.frames[1].document.forms[0];

            if (parent.date_error == '1') {
               parent.date_error = '0';
               return;
            }
            
            if (openerForm &amp;&amp; localForm)
            {
<!-- If first radio button ("UNTIL") is checked, check only until date field -->     
              if(localForm['range'][1].checked) { 
                if (untilddCheck('until',localForm) != 0) {
                  return;
                 }
              }
		
	      if(localForm['REPEATER'][1].checked) {
                if (localForm['BYDAY_1'].checked ||
		    localForm['BYDAY_2'].checked ||
                    localForm['BYDAY_3'].checked ||
                    localForm['BYDAY_4'].checked ||
                    localForm['BYDAY_5'].checked ||
                    localForm['BYDAY_6'].checked ||
		    localForm['BYDAY_7'].checked)
		    ;
      		else {
		   alert(invalid_recurrence_pattern_msg);
		   return;
                }
              } 
              openerForm['mm'].value = localForm['mm'].value;
              openerForm['dd'].value = localForm['dd'].value;
              openerForm['ccyy'].value = localForm['ccyy'].value;
        
              if (!(localForm['notime'])) {
              openerForm['hr'].value = localForm['hr'].value;
              openerForm['mn'].value = localForm['mn'].value;
              if (localForm['pm'])
                openerForm['pm'].selectedIndex = localForm['pm'].selectedIndex;
              if (openerForm['dhr'])
              {
                openerForm['dhr'].value = localForm['dhr'].value;
              }
              if (openerForm['dmn'])
              {
                openerForm['dmn'].value = localForm['dmn'].value;
              }
              openerForm['allday'].checked = localForm['allday'].checked;
              openerForm['e_allday'].value = localForm['allday'].checked;
              }
            }
            <xsl:value-of select="./button[@name='ok']"/>
          </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="esc" value="取消" width="72">
          <xsl:attribute name="onClick">
            var openerForm = parent.opener.parent.frames[1].document.forms[0];
            if (openerForm &amp;&amp; (openerForm['recurrence_enabled'] != null))
            {
<!-- The checkbox only exists for "new" event creation -->
<!-- We weren't already repeating and we're cancelling, so uncheck the checkbox -->        
<!-- e_rruleChanged would have been set if we had already done a successful repeat selection -->
                if(openerForm['e_rruleChanged'].value != 'true') {
                  openerForm['recurrence_enabled'].checked=false;
                }
            }
            <xsl:value-of select="./button[@name='cancel']"/>
          </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="help" value="帮助" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
