<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common_view.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>	
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>邀请列表：Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="list_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>
        </xsl:if>
      </xsl:for-each>      
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (invitations_list.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0" onload="window.focus">

<xsl:call-template name="load_tabs"/>

<FORM name="form" method="post">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item">
          <xsl:with-param name="Index">1</xsl:with-param>
          <xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param>
          <xsl:with-param name="Name">
            邀请<xsl:text> </xsl:text>
            (
            <xsl:value-of select="count(/calendar/invitationslist/invitation)"/>
            )
          </xsl:with-param>
          <xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param>
        </xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="list_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
  <TR>
    <TD colspan="2"><FONT face="{$font_name}" size="{$font_size_big}">
      <xsl:call-template name="invitations_msg_template"/>
    </FONT></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
</TABLE>
<TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
      <TR bgcolor="{$bgcolor_table_top}">
        <TD width="1%" nowrap="" align="center"><FONT face="mono" size="{$font_size_big_2}" color="#FFFFFF">+</FONT></TD>
        <TD width="1%" align="center" nowrap=""><FONT face="mono" size="{$font_size_big_2}" color="#FFFFFF">-</FONT></TD>
        <TD width="1%" align="center" nowrap=""><FONT face="mono" size="{$font_size_big_2}" color="#FFFFFF">?</FONT></TD>
        <TD><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">事件标题</FONT></TD>
        <TD width="1%" nowrap="" align="left"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">组织者</FONT></TD>
        <TD width="1%" nowrap="" align="center"><FONT face="mono" size="{$font_size_big_2}" color="#FFFFFF">删除</FONT></TD>
      </TR>
      <xsl:for-each select="/calendar/invitationslist/invitation">
        <TR bgcolor="{$bgcolor_table_mid}">
          <xsl:for-each select="Event">
            <TD width="1%" nowrap="" align="center">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
<!-- If this is a compressed recurring event, set the return rid to be "all" -->
               <xsl:variable name="the_rid">
                <xsl:choose>
                  <xsl:when test="@compresscount &gt; 1">
<!-- don't translate this it's part of name sent back to server-->
                  <xsl:text>all</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@e_rid"/>
                  </xsl:otherwise>
                </xsl:choose>
               </xsl:variable>
                <INPUT type="radio">
                 <xsl:attribute name="name">invitation_response-<xsl:value-of select="@e_uid_encoded"/>-<xsl:value-of select="$the_rid"/>-<xsl:value-of select="@e_Calid_encoded"/>_irname</xsl:attribute>
<!-- don't translate this -->
                  <xsl:attribute name="value">response_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="$the_rid"/>_<xsl:value-of select="@e_Calid_encoded"/>_accept</xsl:attribute>
                </INPUT>
              </FONT>
            </TD>
            <TD width="1%" align="center" nowrap="">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                <INPUT type="radio">
                  <xsl:attribute name="name">invitation_response-<xsl:value-of select="@e_uid_encoded"/>-<xsl:value-of select="$the_rid"/>-<xsl:value-of select="@e_Calid_encoded"/>_irname</xsl:attribute>
<!-- don't translate this -->
                  <xsl:attribute name="value">response_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="$the_rid"/>_<xsl:value-of select="@e_Calid_encoded"/>_decline</xsl:attribute>
                </INPUT>
              </FONT>
            </TD>
            <TD width="1%" nowrap="" align="center">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                <INPUT type="radio">
                  <xsl:attribute name="name">invitation_response-<xsl:value-of select="@e_uid_encoded"/>-<xsl:value-of select="$the_rid"/>-<xsl:value-of select="@e_Calid_encoded"/>_irname</xsl:attribute>
<!-- don't translate this -->
                  <xsl:attribute name="value">response_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="$the_rid"/>_<xsl:value-of select="@e_Calid_encoded"/>_undecided</xsl:attribute>
                <xsl:attribute name="checked"/>
                </INPUT>
              </FONT>
            </TD>
            <TD bgcolor="#FFFFFF">
              <xsl:if test="@compresscount &gt; 1">
                 周期事件 (<xsl:value-of select="@compresscount"/>):<xsl:text>&nbsp;</xsl:text>
<!--
                 <A>
                  <xsl:attribute name="href">
                    <xsl:value-of select="expand_command"/>
                  </xsl:attribute>
                  (Expand)
                 </A>
-->                               
                 <br/>
              </xsl:if>
              <xsl:call-template name="List_Event">
                <xsl:with-param name="includeDate">true</xsl:with-param>
                <xsl:with-param name="delete">false</xsl:with-param>
              </xsl:call-template>
            </TD>
            <TD width="1%" nowrap="" align="left" valign="top" bgcolor="#FFFFFF">
              <FONT face="{$font_name}" size="{$font_size_big_2}">
                <A>
                  <xsl:attribute name="href">mailto:<xsl:value-of select="@e_OrganizerEmail"/></xsl:attribute>
                  <xsl:value-of select="@e_Organizer"/>
                </A>
              </FONT>
            </TD>
            <TD width="1%" nowrap="" align="center" valign="top" bgcolor="{$bgcolor_table_mid}">
           <INPUT type="checkbox">
            <xsl:attribute name="name">invitedelete_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="@e_rid"/>_<xsl:value-of select="@e_Calid_encoded"/></xsl:attribute>
          </INPUT>
          </TD>
          </xsl:for-each>
        </TR>
      </xsl:for-each>
      <xsl:if test="count(/calendar/invitationslist/invitation) = 0">
        <TR>
          <TD colspan="5" align="left" valign="top" bgcolor="#FFFFFF">
            <FONT face="{$font_name}" size="{$font_size_big_2}">
              <CENTER>无重大邀请</CENTER>
            </FONT>
          </TD>
        </TR>
      </xsl:if>
<!-- Accept All/Decline All row of the table -->
<!--
     Set up the action on the radio button to cycle through all the
     other form elements.
     If the NAME is of the form "invitation_response-<uid>-<rid>-<calid>_irname"
     then check if the value ends in (as appropriate) "accept" or "decline". If
     it matches what we're trying to do, then "check" it.
-->
      <TR bgcolor="{$bgcolor_table_mid}">
        <TD width="1%" align="center" nowrap="">
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            + 全部<br/>
            <INPUT type="checkbox" name="accept_all">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 19) == 'invitation_response') {
                    if ((f.elements[i]).value.search(/accept/) &gt; -1) {
                      (f.elements[i]).checked=1;
                    }
                  }
                }
              f['accept_all'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
        <TD width="1%" align="center" nowrap="">
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            - 全部<br/>
            <INPUT type="checkbox" name="decline_all">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 19) == 'invitation_response') {
                    if ((f.elements[i]).value.search(/decline/) &gt; -1) {
                      (f.elements[i]).checked=1;
                    }
                  }
                }
              f['decline_all'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
        <TD width="1%" align="center" nowrap="">
          <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            ? 全部<br/>
            <INPUT type="checkbox" name="unknown_all">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 19) == 'invitation_response') {
                    if ((f.elements[i]).value.search(/undecided/) &gt; -1) {
                      (f.elements[i]).checked=1;
                    }
                  }
                }
              f['unknown_all'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" align="center" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            删除全部<br/>
            <INPUT type="checkbox" name="alldelete">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                for (i = 0; i &lt; f.elements.length; i++) {
                  if (f.elements[i].name.substr(0, 12) == 'invitedelete') {
                    (f.elements[i]).checked=1;
                  }
                }
                f['alldelete'].checked=0;
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
      </TR>
      <TR bgcolor="{$bgcolor_table_mid}">
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
         <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>       
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>


</FORM>
</BODY>
</HTML>
</xsl:template>


<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="ok" value="保存并关闭" width="72">
      <xsl:attribute name="onClick">
          if (form_submitted == '1') {
             alert('处理中');
             return;
          }
          form_submitted = '1';
          var x=parent.frames[1].document.forms[0].submit();
      </xsl:attribute>
      </INPUT>
      <INPUT type="button" name="esc" value="取消" onClick="parent.close();" width="72"/>
      <INPUT type="button" name="help" value="帮助" onClick="{button[@name='help']}" width="72"/>
    </FONT> </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML></xsl:template>



</xsl:stylesheet>

