<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  未命名
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">星期日</xsl:if>
  <xsl:if test=".='2'">星期一</xsl:if>
  <xsl:if test=".='3'">星期二</xsl:if>
  <xsl:if test=".='4'">星期三</xsl:if>
  <xsl:if test=".='5'">星期四</xsl:if>
  <xsl:if test=".='6'">星期五</xsl:if>
  <xsl:if test=".='7'">星期六</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">一</xsl:if>
  <xsl:if test="$downum='3'">二</xsl:if>
  <xsl:if test="$downum='4'">三</xsl:if>
  <xsl:if test="$downum='5'">四</xsl:if>
  <xsl:if test="$downum='6'">五</xsl:if>
  <xsl:if test="$downum='7'">六</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10月</xsl:if>
  <xsl:if test="$MonthNum=11">11月</xsl:if>
  <xsl:if test="$MonthNum=12">12月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      无效的日期和时间。请进行修改。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      已存在使用此名称的日历。请选择其他名称。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      已存在使用此名称的组。请选择其他名称。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 到 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      执行此搜索时，目录服务器出错。&nbsp;      请提供其他搜索字符串。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      与此搜索相匹配的结果过多。&nbsp;      请提供更详细的搜索字符串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      无法建立到目录服务器的连接。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      无法建立到目录服务器的连接。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      执行此搜索时，目录服务器出错。&nbsp;      请提供其他搜索字符串。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 错误：事件已被删除
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 错误：实现不受支持
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 错误：malloc 失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 错误：无法创建多个 GSE 实例
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 错误：GSE 条目无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 错误：事件无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 错误：无法找到传输接口
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 错误：无法在组织者日历中找到参与者
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 错误：无法创建资源，例如 lock、GDisp 等
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 错误：预期为 iCS 用户，但结果为 SMTP 用户
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 错误：组件方法和状态无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 错误：请求时间与另一个现有会议请求冲突
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      数据库错误：找不到组件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      数据库错误：IO 错误
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      数据库错误：事件的一个或多个值无效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      数据库错误：函数调用无法在提供的组件上操作
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      数据库错误：请求查询未知或不被支持
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      数据库错误：一个必需参数为空、没有设置或者不存在
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      数据库错误：请求的 SequenceNo 条件检查失败，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      数据库错误：请求的修改时间条件检查失败，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      数据库错误：日历不允许覆盖约会，导致写操作被中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      数据库错误：ENS 通知返回一个错误
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      数据库错误：一个必需值为空
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      被邀请人错误：参数不对
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      被邀请人错误：找不到日历
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      被邀请人错误：日历被禁用
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      被邀请人错误：不允许用户访问此日历
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      被邀请人错误：组被截断
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      被邀请人错误：无法移除组织者
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      日历错误：日历创建失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      日历错误：现有日历具有同一个标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      日历错误：用户没有执行该操作所需的访问权限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      日历错误：用户试图访问不存在的日历。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      日历错误: 非法的日历标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      被邀请人错误：无法双重预约被邀请人。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      日历错误：用户没有执行该操作所需的访问权限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      日历错误：用户必须是所有者或共同所有者才能执行该操作。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      日历错误：数据库处于只读模式。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      请查看“空闲时间”选项卡上的空闲时间。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      组错误：非法的组标识符
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      日历错误：无法向保密性列表或所有者列表添加未知用户。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 错误：无邮件主机
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 错误：连接失败
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 错误：未出现预期的连接响应
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 错误：处理消息时出现问题
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 错误：无收件人
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      错误：连接后端数据库失败。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      错误：已达到后端数据库的最大连接数目。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      错误：无法解析日历。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      错误：错误的数据 - 无法访问后端数据库。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      错误：DWP 主机上下文不可用。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      错误：无法解析后端主机。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      错误：无数据 - 无法访问后端数据库。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      错误：连接后端数据库失败。
    </xsl:when>
    <xsl:otherwise>
      未知 错误 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      错误：一个重复发生的实例不能跳过另一个重复发生的实例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      错误：两个重复发生的实例不能在同一天发生。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      错误：不能只变更一个实例的保密性。
    </xsl:when>
    <xsl:otherwise>
      未知的重复发生错误 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">美洲/埃达克</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">美洲/安克雷奇</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">美洲/洛杉矶</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">美洲/菲尼克斯</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">美洲/丹佛</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">美洲/哥斯达黎加</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">美洲/芝加哥</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">美洲/印地安纳波利斯</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">美洲/纽约</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">美洲/哈瓦那</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">美洲/太子港</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">美洲/大特克岛</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">美洲/加纳加斯</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">美洲/库亚巴</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">美洲/哈里法克斯</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">美洲/圣地亚哥</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋地区/斯坦利</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">美洲/圣约翰斯</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">美洲/布宜诺斯艾利斯</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">美洲/圣保罗</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">美洲/密克隆</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">美洲/戈特霍布</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋地区/南乔治亚岛</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋地区/佛得角</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋地区/亚述尔群岛</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">非洲/卡萨布兰卡</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">欧洲/伦敦</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">非洲/拉各斯</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">欧洲/巴黎</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">非洲/的黎波里</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">欧洲/华沙</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">非洲/约翰内斯堡</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">欧洲/布加勒斯特</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">欧洲/伊斯坦布尔</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">非洲/开罗</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">欧洲/里加</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">非洲/温得和克</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">欧洲/明斯克</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">欧洲/辛菲罗波尔</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">欧洲/莫斯科</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">欧洲/萨马拉</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">亚洲/贝鲁特</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">亚洲/耶路撒冷</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">亚洲/安曼</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">亚洲/利雅得</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">亚洲/德黑兰</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">亚洲/埃里温</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">亚洲/阿克套</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">亚洲/巴库</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">亚洲/喀布尔</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">亚洲/卡拉齐</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">亚洲/阿克秋宾</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">亚洲/比什凯克</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">亚洲/叶卡捷琳堡</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">亚洲/加尔各答</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">亚洲/加德满都</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">亚洲/达卡</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">亚洲/阿拉木图</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">亚洲/新西伯利亚</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">亚洲/仰光</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">亚洲/曼谷</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">亚洲/克拉斯诺亚尔斯克</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">亚洲/乌兰巴托</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">亚洲/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">亚洲/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">亚洲/伊尔库次克</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">亚洲/东京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">亚洲/汉城</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">亚洲/雅库茨克</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">澳大利亚/佩斯</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">澳大利亚/达尔文</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">澳大利亚/阿德莱德</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">澳大利亚/布里斯班</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">澳大利亚/悉尼</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">澳大利亚/霍巴特</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">亚洲/符拉迪沃斯托克</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">澳大利亚/豪勋爵岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋地区/瓜达尔卡纳尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋地区/努美阿</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">亚洲/马加丹</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋地区/诺福克</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋地区/斐济</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋地区/奥克兰</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">亚洲/堪察加</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋地区/查塔姆</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋地区/汤加塔布</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">亚洲/阿纳德尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋地区/圣诞岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋地区/阿皮亚</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋地区/檀香山</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋地区/拉罗汤加岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋地区/马克萨斯群岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋地区/甘比尔</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋地区/皮特凯恩岛</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋地区/复活节岛</xsl:when> 
    <xsl:otherwise>
      未知 时区 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">没有结束日期 </xsl:variable>
<xsl:variable name="cap_the_text">第 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 移除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) >0)) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>欢迎  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>日历上 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>的日历 (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>开始于 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 小时</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分钟</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>1 小时以上</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 空闲）</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 最多创建 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 个实例</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>任何地区的一个或多个时区都可以与当前日历相关联。在带网格的视图（如日视图）中，与日历关联的所有时区 都成为视图时标的一部分。如果没有为此日历指定时区，则使用默认时区。可用的时区如下： </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>任何地区的一个时区都可以与当前日历相关联。在带网格的视图（如日视图）中，与日历关联的时区成为视图时 标的一部分。如果没有为此日历指定时区，则使用默认时区。可用的时区如下： </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北美/南美地区 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>欧洲/非洲 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>亚洲/太平洋周边 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>区域：</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>下列事件已由“</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>”添加到您的日历中。通过选择您认为合适的回复，您就可以接受或谢绝该邀请。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>单击</xsl:text>&nbsp;
  <B><xsl:text>浏览...</xsl:text></B>&nbsp;
  <xsl:text>来选择文件。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>使用此窗口接受 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 或拒绝 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 邀请，或保留未决定 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 对参加某事件的邀请。</xsl:text>
  <br/>
  <xsl:text>对于周期事件，设置将应用于整个序列。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>搜索少于 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 个字符，结果可能不完整。若要改进搜索结果，请尝试使用至少 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 个字符。　</xsl:text>

</xsl:template>


</xsl:stylesheet>
