<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  未命名
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">星期日</xsl:if>
  <xsl:if test=".='2'">星期一</xsl:if>
  <xsl:if test=".='3'">星期二</xsl:if>
  <xsl:if test=".='4'">星期三</xsl:if>
  <xsl:if test=".='5'">星期四</xsl:if>
  <xsl:if test=".='6'">星期五</xsl:if>
  <xsl:if test=".='7'">星期六</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">一</xsl:if>
  <xsl:if test="$downum='3'">二</xsl:if>
  <xsl:if test="$downum='4'">三</xsl:if>
  <xsl:if test="$downum='5'">四</xsl:if>
  <xsl:if test="$downum='6'">五</xsl:if>
  <xsl:if test="$downum='7'">六</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      您輸入的日期與時間無效。請修正。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      已有同名稱的行事曆存在。請選擇其他名稱。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      已有同名稱的群組存在。請選擇其他名稱。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 至 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      執行此搜尋時，目錄伺服器出現問題。&nbsp;      請提供其他搜尋字串。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      不能建立至目錄伺服器的連線。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      不能建立至目錄伺服器的連線。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      執行此搜尋時，目錄伺服器出現問題。&nbsp;      請提供其他搜尋字串。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 錯誤： 已刪除事件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 錯誤： 不支援實施
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 錯誤： malloc 失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 錯誤： 無法建立 GSE 的多重實例
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 錯誤： GSE 項目無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 錯誤： 事件無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 錯誤： 找不到傳輸介面
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 錯誤： 在組織者的行事曆中找不到與會人員
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 錯誤： 無法建立資源，如鎖定、Gdisp 等
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 錯誤： 預期為 iCS 使用者，結果卻是 SMTP 使用者
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 錯誤： 元件方法和狀態無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 錯誤： 請求時間與另一個現有會議請求衝突
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      資料庫錯誤：找不到元件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      資料庫錯誤：IO 錯誤
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      資料庫錯誤：事件的一個或多個值無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      資料庫錯誤：函式呼叫並未在提供的元件上操作
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      資料庫錯誤：未知或不支援的請求查詢
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      資料庫錯誤：所需的參數為空值，沒有設定，或是不存在
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      資料庫錯誤：因為請求的 SequenceNo 條件檢查失敗，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      資料庫錯誤：因為請求的修改時間條件檢查失敗，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      資料庫錯誤：因為行事曆不允許重疊的約會，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      資料庫錯誤：ENS 通知傳回一個錯誤
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      資料庫錯誤：要求的值為空值
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      受邀人錯誤：錯誤的引數
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      受邀人錯誤：找不到行事曆
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      受邀人錯誤：行事曆停用
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      受邀人錯誤：使用者不允許存取行事曆
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      受邀人錯誤：群組被切掉
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      受邀人錯誤：無法移除召集人
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      行事曆錯誤：行事曆建立失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      行事曆錯誤：與現有的行事曆具有相同識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      行事曆錯誤：使用者沒有執行這項操作所需的存取權限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      行事曆錯誤：使用者嘗試存取不存在的行事曆。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      行事曆錯誤：不合法的行事曆識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      受邀人錯誤：無法重複預約受邀人。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      行事曆錯誤：使用者沒有執行這項操作所需的存取權限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      行事曆錯誤：使用者必須是所有者或是共同所有者才能執行這項操作。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      行事曆錯誤： 資料庫處於唯讀模式。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      請利用 [空閒時間] 頁籤尋找可用的時間。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      群組錯誤：不合法的群組識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      行事曆錯誤：無法加入未知的使用者至私密性清單或所有人清單。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 錯誤： 沒有郵件主機
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 錯誤： 連線失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 錯誤： 沒有發生對連線的預期回應
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 錯誤： 定址郵件時出現問題
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 錯誤： 沒有收信人
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      錯誤：連線至後端資料庫失敗。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      錯誤：後端資料庫的連線數已達最大。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      錯誤：無法解析行事曆。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      錯誤：無法使用資料有誤的後端資料庫。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      錯誤：DWP 主機環境不可用。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      錯誤：無法解析後端主機。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      錯誤：無資料 – 無法使用後端資料庫。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      錯誤：連線至後端資料庫失敗。
    </xsl:when>
    <xsl:otherwise>
      不明 錯誤 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      錯誤：一個週期性實例無法跳過另一個週期性實例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      錯誤：不能在同一天出現兩個週期性實例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      錯誤：不能只變更一個實例的私密性。
    </xsl:when>
    <xsl:otherwise>
      未知的週期性錯誤 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">美洲/艾達克</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">美洲/安克拉治</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">美洲/洛杉磯</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">美洲/鳳凰城</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">美洲/丹佛</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">美洲/哥斯大黎加</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">美洲/芝加哥</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">美洲/印第安那波里</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">美洲/紐約</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">美洲/哈瓦那</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">美洲/太子港</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">美洲/大特克島</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">美洲/卡拉卡斯</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">美洲/古雅巴</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">美洲/哈利法克斯</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">美洲/聖地牙哥</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋/史坦萊</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">美洲/聖約翰斯</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">美洲/布宜諾斯艾利斯</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">美洲/聖保羅</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">美洲/麥克隆</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">美洲/哥特哈布</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋/南喬治亞</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋/維德角</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋/亞述群島</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">非洲/卡薩布蘭卡</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">歐洲/倫敦</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">非洲/拉哥斯</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">歐洲/巴黎</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">非洲/的黎波里</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">歐洲/華沙</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">非洲/約翰尼斯堡</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">歐洲/布加勒斯特</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">歐洲/伊斯坦堡</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">非洲/開羅</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">歐洲/里加</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">非洲/溫吐克</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">歐洲/明斯克</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">歐洲/欣佛洛普</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">歐洲/莫斯科</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">歐洲/沙馬拉</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">亞洲/貝魯特</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">亞洲/耶路撒冷</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">亞洲/安曼</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">亞洲/利雅德</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">亞洲/德黑蘭</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">亞洲/葉里溫</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">亞洲/阿克陶</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">亞洲/巴庫</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">亞洲/喀布爾</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">亞洲/喀拉蚩</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">亞洲/阿克托比</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">亞洲/比斯凱克</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">亞洲/耶卡特寧伯格</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">亞洲/加爾各答</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">亞洲/加德滿都</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">亞洲/達卡</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">亞洲/阿拉木圖</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">亞洲/新西伯利亞</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">亞洲/仰光</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">亞洲/曼谷</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">亞洲/克拉斯諾雅</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">亞洲/庫倫</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">亞洲/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">亞洲/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">亞洲/伊爾庫次克</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">亞洲/東京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">亞洲/漢城</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">亞洲/雅庫次克</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">澳大利亞/伯斯</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">澳大利亞/達爾文</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">澳大利亞/阿得雷德</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">澳大利亞/布里斯本</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">澳大利亞/雪梨</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">澳大利亞/霍巴特</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">亞洲/海參崴</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">澳大利亞/羅德豪島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋/瓜達康納爾島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋/諾米亞</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">亞洲/馬加丹</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋/諾福克島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋/斐濟</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋/奧克蘭</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">亞洲/堪察加</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋/查坦</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋/東加塔普</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">亞洲/阿那底</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋/刻里提瑪斯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋/阿比亞</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋/火奴魯魯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋/拉洛東加島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋/馬克沙斯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋/甘比爾</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋/皮特康</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋/伊斯特</xsl:when> 
    <xsl:otherwise>
      不明 時區 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">確定</xsl:variable>

<xsl:variable name="cancel_title">取消</xsl:variable>
<xsl:variable name="close_title">關閉</xsl:variable>
<xsl:variable name="help_title">說明</xsl:variable>
<xsl:variable name="apply_title">套用</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">沒有事件或工作</xsl:variable>
<xsl:variable name="week_ahead_title">未來一週</xsl:variable>
<xsl:variable name="alt_text_schedule">排程新的約會</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">在下面輸入使用者名稱，然後按一下 [確定] 按鈕。</xsl:variable>

<xsl:variable name="user_name_title">使用者名稱</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">跳躍至前一天</xsl:variable>

<xsl:variable name="alt_jump_next_day">跳躍至次日</xsl:variable>

<xsl:variable name="alt_jump_new_date">跳躍至新日期</xsl:variable>

<xsl:variable name="available_title">可用</xsl:variable>

<xsl:variable name="busy_title">忙碌</xsl:variable>

<xsl:variable name="hour_text">小時</xsl:variable>
<xsl:variable name="minutes_text">分鐘</xsl:variable>

<xsl:variable name="show_availability_title">顯示空閒時間</xsl:variable>

<xsl:variable name="error_cal_privacy">行事曆的私密性不允許您檢視它，或是此行事曆不存在。</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">北/南美洲</xsl:variable>

<xsl:variable name="europe_africa_title">歐洲/非洲</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">亞洲/環太平洋區</xsl:variable>

<xsl:variable name="time_zone_title">時區</xsl:variable>

<xsl:variable name="gmt_offset_title">GMT 偏移量</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">群組</xsl:variable>

<xsl:variable name="groups_msg">利用行事曆群組同時看多個行事曆。若要檢視行事曆群組，請按群組名稱連結。若要從群組中增加或移除行事曆，請按一下 [編輯] 連結。</xsl:variable>

<xsl:variable name="select_title">選取</xsl:variable>

<xsl:variable name="group_title">群組</xsl:variable>

<xsl:variable name="group_colon_title">群組：</xsl:variable>

<xsl:variable name="description_title">說明</xsl:variable>

<xsl:variable name="properties_title">屬性</xsl:variable>

<xsl:variable name="error_cal_access">您沒有存取這個行事曆的權限。</xsl:variable>

<xsl:variable name="error_cal_not_exist">這個行事曆不存在。</xsl:variable>

<xsl:variable name="edit_title">編輯</xsl:variable>
<xsl:variable name="edit_calendar_title">編輯行事曆</xsl:variable>

<xsl:variable name="remove_selected_title">移除選取</xsl:variable>

<xsl:variable name="calendars_title">行事曆</xsl:variable>

<xsl:variable name="calendars_msg">您擁有的或已訂閱的行事曆清單。若要檢視行事曆，請按一下行事曆名稱。若要編輯行事曆，請按一下 [編輯]。</xsl:variable>

<xsl:variable name="calendar_title">行事曆</xsl:variable>

<xsl:variable name="view_title">檢視</xsl:variable>
<xsl:variable name="view_calendar_title">檢視行事曆</xsl:variable>

<xsl:variable name="view_colon_title">檢視︰</xsl:variable>

<xsl:variable name="options_title">選項</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">變更預設時區： Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">總覽</xsl:variable>

<xsl:variable name="day_tab_title">日</xsl:variable>

<xsl:variable name="week_tab_title">週</xsl:variable>

<xsl:variable name="month_tab_title">月</xsl:variable>

<xsl:variable name="year_tab_title">年</xsl:variable>

<xsl:variable name="comparison_tab_title">比較</xsl:variable>

<xsl:variable name="repeat_title">重複</xsl:variable>

<xsl:variable name="change_repeat_title">變更重複模式</xsl:variable>

<xsl:variable name="alt_jump_prev_month">跳至上一月</xsl:variable>

<xsl:variable name="alt_jump_next_month">跳至下一月</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">今天是： </xsl:variable>

<xsl:variable name="alt_jump_this_date">跳至此日期</xsl:variable>

<xsl:variable name="action_items_title">動作項目</xsl:variable>

<xsl:variable name="invitations_title">邀請</xsl:variable>

<xsl:variable name="no_invitations_msg">無邀請</xsl:variable>

<xsl:variable name="tasks_title">工作</xsl:variable>

<xsl:variable name="overdue_msg">逾期</xsl:variable>

<xsl:variable name="no_tasks_msg">無工作</xsl:variable>

<xsl:variable name="errors_title">錯誤</xsl:variable>

<xsl:variable name="no_errors_msg">無錯誤</xsl:variable>

<xsl:variable name="daily_title">每天</xsl:variable>

<xsl:variable name="weekly_title">每週</xsl:variable>

<xsl:variable name="monthly_title">每月</xsl:variable>

<xsl:variable name="yearly_title">每年</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">重複選取： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">只限此項</xsl:variable>

<xsl:variable name="this_and_future_title">此項和後來者</xsl:variable>

<xsl:variable name="all_instances_title">所有實例</xsl:variable>

<xsl:variable name="repeating_selection_title">重複選取</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">今天到期</xsl:variable>

<xsl:variable name="other_tasks_title">其他工作</xsl:variable>

<xsl:variable name="overdue_tasks_title">逾期的工作</xsl:variable>

<xsl:variable name="all_day_events_title">整日事件</xsl:variable>

<xsl:variable name="conflict_msg">衝突</xsl:variable>

<xsl:variable name="overdue_title">逾期</xsl:variable>

<xsl:variable name="due_at_title">到期</xsl:variable>

<xsl:variable name="untitled_task_title">未命名的工作</xsl:variable>

<xsl:variable name="alt_view_this_task">檢視這個工作</xsl:variable>

<xsl:variable name="alt_delete_this_task">刪除這個工作</xsl:variable>

<xsl:variable name="untitled_event_title">未命名的事件</xsl:variable>

<xsl:variable name="alt_delete_this_event">刪除這個事件</xsl:variable>

<xsl:variable name="alt_view_this_event">檢視此事件</xsl:variable>

<xsl:variable name="all_day_title">整日</xsl:variable>

<xsl:variable name="overdue_from_title">逾期 於</xsl:variable>

<xsl:variable name="from_txt">於</xsl:variable>

<xsl:variable name="due_on_title">到期</xsl:variable>

<xsl:variable name="not_due_title">無到期日期</xsl:variable>

<xsl:variable name="due_title">到期</xsl:variable>

<xsl:variable name="on_txt">於</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">上午</xsl:variable>

<xsl:variable name="pm_txt">下午</xsl:variable>

<xsl:variable name="midnight_title">午夜</xsl:variable>

<xsl:variable name="noon_title">中午</xsl:variable>

<xsl:variable name="from_title">從</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">排程新的約會</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">錯誤清單： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">此面板顯示未解決的排程錯誤之清單。</xsl:variable>

<xsl:variable name="organizer_title">組織者</xsl:variable>

<xsl:variable name="attendee_title">與會人員</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">沒有未解決的錯誤</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">週期性： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">週期性</xsl:variable>

<xsl:variable name="start_title">啟動</xsl:variable>

<xsl:variable name="end_title">結束</xsl:variable>

<xsl:variable name="create_title">建立</xsl:variable>

<xsl:variable name="events_text">事件</xsl:variable>

<xsl:variable name="alert_provide_valid_count">請提供有效計數</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">請提供小於或等於下列數的數</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">傳送此事件的提醒通知時間設定為在事件開始之後。按一下 [取消] 以返回，然後變更時間。</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">傳送此工作的提醒通知時間設定為在工作到期時間之後。按一下 [取消] 以返回，然後變更時間。</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">撰寫</xsl:variable>

<xsl:variable name="reminders_title">提醒</xsl:variable>

<xsl:variable name="availability_title">可用性</xsl:variable>

<xsl:variable name="preview_title">預覽</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">邀請清單： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">刪除</xsl:variable>

<xsl:variable name="recurring_event_msg">週期性的事件</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">無重大的邀請</xsl:variable>

<xsl:variable name="all_title">全部</xsl:variable>

<xsl:variable name="delete_all_title">刪除全部</xsl:variable>

<xsl:variable name="save_and_close_title">儲存後關閉</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">您選取了一個空白的選項</xsl:variable>

<xsl:variable name="alert_min_year">您無法檢視 1970 年之前的某一年</xsl:variable>
<xsl:variable name="alert_max_year">您無法檢視 2036 年之後的某一年</xsl:variable>

<xsl:variable name="alert_invalid_date">這是一個無效日期。請更正它。</xsl:variable>

<xsl:variable name="january_title">1 月</xsl:variable>
<xsl:variable name="february_title">2 月</xsl:variable>
<xsl:variable name="march_title">3 月</xsl:variable>
<xsl:variable name="april_title">4 月</xsl:variable>
<xsl:variable name="may_title">5 月</xsl:variable>
<xsl:variable name="june_title">6 月</xsl:variable>
<xsl:variable name="july_title">7 月</xsl:variable>
<xsl:variable name="august_title">8 月</xsl:variable>
<xsl:variable name="september_title">9 月</xsl:variable>
<xsl:variable name="october_title">10 月 </xsl:variable>
<xsl:variable name="november_title">11 月</xsl:variable>
<xsl:variable name="december_title">12 月</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">請提供有效日期</xsl:variable>

<xsl:variable name="provide_good_date_msg">請提供有效日期</xsl:variable>

<xsl:variable name="provide_good_month_msg">請提供 1 月至 12 月之間的某個月份</xsl:variable>

<xsl:variable name="provide_good_year_msg">請提供有效年份。\n\n如果您使用兩位數表示年份，小於 37 的值\n均會被解譯為屬於 21 世紀。\n\n例如： 03 相當於 2003</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">請提供大於 1970 的年份</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">請提供小於 2037 的年份</xsl:variable>

<xsl:variable name="provide_good_hour_msg">請提供有效的小時值。(1-12) 十二小時制或 (0-23) 二十四小時制</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">請提供有效的小時值 (0 - 23)</xsl:variable>

<xsl:variable name="provide_good_minute_msg">請提供介於 0 和 59 之間的分鐘值</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">請選擇一個在開始日期之後的到期日期</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">輸入的日期不存在。\n設定行事曆至最近有效日期</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">跳躍至日期： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">跳至前一年</xsl:variable>

<xsl:variable name="alt_jump_next_year">跳至下一年</xsl:variable>

<xsl:variable name="jump_to_date_title">跳至日期</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">您確定要刪除這個私密性項目？</xsl:variable>

<xsl:variable name="edit_calendar_page_title">編輯行事曆： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">指定需要的資訊。</xsl:variable>

<xsl:variable name="calendar_name_msg">請提供行事曆的簡稱，例如 &quot;baseball&quot; (不允許空格)。</xsl:variable>

<xsl:variable name="display_name_title">顯示名稱</xsl:variable>

<xsl:variable name="display_name_msg">這是選擇性的欄位，提醒您這個行事曆的用途，例如「比爾的棒球比賽時間表」。</xsl:variable>

<xsl:variable name="include_in_availability_msg">當計算您的空閒時間時，包括這個行事曆在內</xsl:variable>

<xsl:variable name="calendar_address_title">行事曆地址</xsl:variable>

<xsl:variable name="calendar_address_msg">您可以提供他人此處的連結，讓其他人存取這個行事曆。他們就可以在瀏覽器內使用這些連結，但是前提是您已經在「權限」內設定給予他們權限。</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">行事曆的權限：</xsl:variable>

<xsl:variable name="cal_permissions_msg">「權限」決定其他人能不能看見或變更這個行事曆。若要給全部使用者某些權限，請在 [全部使用者] 旁邊的欄位內選擇適當的權限。若要給個人某些權限，請在 [使用者] 欄位內輸入他們的使用者 ID，按一下 [新增使用者]，然後在使用者名稱旁邊的欄位內選擇適當的權限。</xsl:variable>

<xsl:variable name="user_title">使用者</xsl:variable>
<xsl:variable name="user_title_with_colon">使用者：</xsl:variable>

<xsl:variable name="permissions_title">許可權</xsl:variable>

<xsl:variable name="invite_title">邀請</xsl:variable>

<xsl:variable name="read_title">讀取</xsl:variable>

<xsl:variable name="modify_title">修改</xsl:variable>

<xsl:variable name="delete_selected_user_title">刪除所選使用者</xsl:variable>

<xsl:variable name="add_user_title">加入使用者</xsl:variable>

<xsl:variable name="everybody_title">所有使用者</xsl:variable>

<xsl:variable name="this_domain_title">此網域</xsl:variable>

<xsl:variable name="tip_cal_owners">關於為行事曆指定所有者的提示：</xsl:variable>

<xsl:variable name="cal_owner_msg">您可以為此行事曆增加一個或多個所有者。所有者可以代表您回覆邀請，以及建立、修改和刪除事件。</xsl:variable>

<xsl:variable name="no_owners_msg">沒有所有者。</xsl:variable>

<xsl:variable name="delete_owner_title">刪除所有者</xsl:variable>

<xsl:variable name="add_owner_title">新增所有者</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">您是否確定要刪除此行事曆</xsl:variable>

<xsl:variable name="alert_supply_cal_name">您必須提供行事曆名稱</xsl:variable>

<xsl:variable name="owners_title">所有者</xsl:variable>

<xsl:variable name="time_zones_title">時區</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">是否要刪除此事件？</xsl:variable>

<xsl:variable name="edit_event_page_title">編輯事件： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---快速邀請---</xsl:variable>

<xsl:variable name="event_title_title">事件標題</xsl:variable>

<xsl:variable name="date_title">日期</xsl:variable>

<xsl:variable name="time_title">時間</xsl:variable>

<xsl:variable name="all_day_msg">整日 (例如，假日或生日)</xsl:variable>

<xsl:variable name="privacy_title">私密性</xsl:variable>

<xsl:variable name="public_event_title">公開事件</xsl:variable>

<xsl:variable name="confidential_event_title">只有時間與日期</xsl:variable>

<xsl:variable name="private_event_title">私人事件</xsl:variable>

<xsl:variable name="location_title">位置</xsl:variable>

<xsl:variable name="invite_others_msg">邀請其他使用者或資源：</xsl:variable>

<xsl:variable name="search_title">搜尋(S)...</xsl:variable>

<xsl:variable name="inform_title">通知</xsl:variable>

<xsl:variable name="invite_instructions_msg">(輸入使用者 ID、行事曆 ID 或電子郵件地址。如果您不知道名稱，則按一下 [搜尋]。)</xsl:variable>

<xsl:variable name="invitees_title">受邀人</xsl:variable>

<xsl:variable name="no_invitees_msg">沒有被邀請者</xsl:variable>

<xsl:variable name="remove_title">移除</xsl:variable>

<xsl:variable name="inform_event_title">通知事件</xsl:variable>

<xsl:variable name="no_informees_msg">沒有被通知者</xsl:variable>

<xsl:variable name="event_reminders_msg">您可以給自己傳送一則關於此事件的電子郵件提醒通知。在下面輸入您的一個或多個電子郵件地址。使用逗號 (,) 或分號 (;) 分隔每個電子郵件地址。</xsl:variable>

<xsl:variable name="remind_title">提醒</xsl:variable>

<xsl:variable name="alert_provide_valid_time">請提供有效時間</xsl:variable>

<xsl:variable name="hours_text">小時</xsl:variable>

<xsl:variable name="days_text">日</xsl:variable>

<xsl:variable name="before_the_event_begins_text">在事件開始之前</xsl:variable>

<xsl:variable name="at_text">於</xsl:variable>

<xsl:variable name="text_reminder_msg">您可以在電子郵件提醒通知中傳送文字訊息。</xsl:variable>

<xsl:variable name="message_title">訊息</xsl:variable>

<xsl:variable name="title_title">標題</xsl:variable>

<xsl:variable name="attendees_title">與會人員</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">確定要刪除？</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">編輯行事曆群組： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---快速新增---</xsl:variable>

<xsl:variable name="delete_calendar_text">您是否確定要移除此行事曆？</xsl:variable>

<xsl:variable name="group_name_title">群組名稱</xsl:variable>

<xsl:variable name="group_view_msg">在 [日] 檢視中開啟群組 (依預設，在 [比較] 檢視中開啟群組。)</xsl:variable>

<xsl:variable name="calendar_id_title">行事曆 ID</xsl:variable>

<xsl:variable name="add_title">新增</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(輸入行事曆 ID。如果您不知道 ID，則按一下 [搜尋]。)</xsl:variable>

<xsl:variable name="group_members_title">群組成員</xsl:variable>

<xsl:variable name="group_description_msg">在此處提供群組的說明。您還可以決定此群組的 [日] 檢視是否分別顯示各行事曆</xsl:variable>

<xsl:variable name="day_view_title">[日] 檢視</xsl:variable>

<xsl:variable name="day_view_merge_msg">依預設，[日] 檢視中的行事曆為非合併狀態。</xsl:variable>

<xsl:variable name="alert_group_name">您必須提供此群組的名稱</xsl:variable>

<xsl:variable name="calendar_group_title">行事曆群組</xsl:variable>

<xsl:variable name="details_title">詳細資訊</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">您確定要刪除這個工作？</xsl:variable>

<xsl:variable name="edit_task_page_title">編輯工作： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">撰寫工作</xsl:variable>

<xsl:variable name="task_title_title">工作標題</xsl:variable>

<xsl:variable name="due_date_title">到期日期</xsl:variable>

<xsl:variable name="no_time_title">無到期時間</xsl:variable>

<xsl:variable name="public_task_title">公開的工作</xsl:variable>

<xsl:variable name="confidential_task_title">只有時間與日期</xsl:variable>

<xsl:variable name="private_task_title">私人的工作</xsl:variable>

<xsl:variable name="status_title">狀態</xsl:variable>

<xsl:variable name="complete_title">完成</xsl:variable>

<xsl:variable name="task_reminder_msg">您可以傳送一封這個工作的電子郵件提醒通知給自己。在下方輸入一個或多個您的電子郵件地址，用逗號 (,) 或分號 (;) 分隔每個電子郵件地址。</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">您不能為無到期日期的工作設定警告。</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">在工作到期之前的</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">顯示</xsl:variable>

<xsl:variable name="settings_title">設定</xsl:variable>

<xsl:variable name="import_title">匯入</xsl:variable>

<xsl:variable name="export_title">匯出</xsl:variable>

<xsl:variable name="settings_msg">使用此表單來修改 Calendar Express 的運作方式。</xsl:variable>

<xsl:variable name="default_view_title">預設初始檢視</xsl:variable>

<xsl:variable name="default_view_msg">登入後，自動顯示下列檢視：</xsl:variable>

<xsl:variable name="default_group_title">預設行事曆群組</xsl:variable>

<xsl:variable name="default_group_msg">登入後，自動顯示下列行事曆群組：</xsl:variable>

<xsl:variable name="no_cal_group_title">沒有行事曆群組</xsl:variable>

<xsl:variable name="date_format_msg">以下列順序顯示簡短日期：</xsl:variable>

<xsl:variable name="m_d_y_format_text">月, 日, 年</xsl:variable>

<xsl:variable name="d_m_y_format_text">日, 月, 年</xsl:variable>

<xsl:variable name="y_m_d_format_text">年, 月, 日</xsl:variable>

<xsl:variable name="date_delimiter_msg">使用下列字元來分隔簡短日期：</xsl:variable>

<xsl:variable name="use_12_clock_msg">使用 12 小時時制</xsl:variable>

<xsl:variable name="use_24_clock_msg">使用 24 小時時制</xsl:variable>

<xsl:variable name="day_title">日</xsl:variable>

<xsl:variable name="day_starts_msg">日開始於：</xsl:variable>

<xsl:variable name="day_ends_msg">日結束於：</xsl:variable>

<xsl:variable name="day_interval_msg">日分割單位</xsl:variable>

<xsl:variable name="every_15_minutes_text">每十五分鐘</xsl:variable>

<xsl:variable name="every_half_hour_text">每半小時</xsl:variable>

<xsl:variable name="every_hour_text">每小時</xsl:variable>

<xsl:variable name="every_2_hours_text">每兩小時</xsl:variable>

<xsl:variable name="every_four_hours_text">每四小時</xsl:variable>

<xsl:variable name="first_dow_title">一週的第一天</xsl:variable>

<xsl:variable name="sunday_title">星期日</xsl:variable>

<xsl:variable name="monday_title">星期一</xsl:variable>

<xsl:variable name="tuesday_title">星期二</xsl:variable>

<xsl:variable name="wednesday_title">星期三</xsl:variable>

<xsl:variable name="thursday_title">星期四</xsl:variable>

<xsl:variable name="friday_title">星期五</xsl:variable>

<xsl:variable name="saturday_title">星期六</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">週與月檢視不包含星期六與星期日</xsl:variable>

<xsl:variable name="default_tz_msg">依預設，使用下列時區顯示日期和時間：</xsl:variable>

<xsl:variable name="none_selected_title">未選取任何項目</xsl:variable>

<xsl:variable name="single_tz_use_msg">當顯示單一行事曆時，使用該行事曆的時區</xsl:variable>

<xsl:variable name="tz_timescales_msg">顯示已顯示的各行事曆時區之時間刻度</xsl:variable>

<xsl:variable name="event_task_reminders_title">事件與工作提醒通知</xsl:variable>

<xsl:variable name="email_reminder_msg">以電子郵件方式寄提醒通知給我</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">請為提醒通知提供有效的時間間隔</xsl:variable>

<xsl:variable name="before_every_event_task_text">在每個事件與工作之前</xsl:variable>

<xsl:variable name="note_title">備註：</xsl:variable>

<xsl:variable name="reminders_tip_msg">如果要將提醒通知傳送至多個電子郵件地址 (如 abc@company22.com、abc@sesta.com)，請以逗號 (,) 或分號 (;) 分隔電子郵件地址。</xsl:variable>

<xsl:variable name="event_notifications_title">事件通知</xsl:variable>

<xsl:variable name="event_notifications_msg">每當有人在我的行事曆上排程事件時，請以電子郵件方式通知我</xsl:variable>

<xsl:variable name="only_one_email_msg">僅允許有一個電子郵件地址。</xsl:variable>

<xsl:variable name="alert_only_one_email">請僅提供一個事件通知地址</xsl:variable>

<xsl:variable name="declined_events_delete_title">遭拒絕的事件</xsl:variable>

<xsl:variable name="declined_events_delete_msg">不顯示遭拒絕的事件</xsl:variable>

<xsl:variable name="appearance_msg">使用此表單來修改 Calendar Express 的外觀。</xsl:variable>

<xsl:variable name="color_scheme_title">色彩組合</xsl:variable>

<xsl:variable name="toolbar_title">工具列</xsl:variable>

<xsl:variable name="icons_and_text_msg">顯示圖示和文字</xsl:variable>

<xsl:variable name="icons_only_msg">只顯示圖示</xsl:variable>

<xsl:variable name="text_only_msg">只顯示文字</xsl:variable>

<xsl:variable name="display_font_title">顯示字型</xsl:variable>

<xsl:variable name="face_title">字體</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">大小</xsl:variable>

<xsl:variable name="larger_title">較大</xsl:variable>

<xsl:variable name="default_title">預設值</xsl:variable>

<xsl:variable name="smaller_title">較小</xsl:variable>

<xsl:variable name="event_destination_title">事件的目的地</xsl:variable>

<xsl:variable name="session_expired_msg">您的工作階段已逾期</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">您必須指定一個有效的行事曆</xsl:variable>

<xsl:variable name="add_events_to_text">新增事件至</xsl:variable>

<xsl:variable name="select_calendar_title">選取行事曆：</xsl:variable>

<xsl:variable name="import_format_title">匯入格式</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook 格式</xsl:variable>

<xsl:variable name="source_file_invalid_error">指定的來源檔案無效</xsl:variable>

<xsl:variable name="format_file_mismatch_error">指定的格式與來源檔案不符</xsl:variable>

<xsl:variable name="successful_import_msg">檔案匯入成功</xsl:variable>

<xsl:variable name="source_file_title">來源檔案</xsl:variable>

<xsl:variable name="date_range_title">日期範圍</xsl:variable>

<xsl:variable name="import_all_msg">從檔案匯入全部事件</xsl:variable>

<xsl:variable name="invalid_date_range_error">您指定的日期範圍無效</xsl:variable>

<xsl:variable name="beginning_title">開始日期</xsl:variable>

<xsl:variable name="ending_title">結束日期</xsl:variable>

<xsl:variable name="calendars_to_export_title">匯出行事曆</xsl:variable>

<xsl:variable name="addarrow_title">新增 &gt;&gt;</xsl:variable>

<xsl:variable name="export_all_msg">匯出所有的事件</xsl:variable>

<xsl:variable name="export_format_title">匯出格式</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">日結束時間應晚於日開始時間</xsl:variable>

<xsl:variable name="save_changes_title">儲存變更</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">目前的行事曆：</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">重複模式</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">無效的重複模式：請選取要於哪一天重複</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">不能對單一實例變更重複模式</xsl:variable>

<xsl:variable name="recurrence_skips_title">一個週期性事件實例無法跳過另一個週期性事件實例</xsl:variable>

<xsl:variable name="recurrence_same_day">不能在同一天出現兩個週期性事件實例</xsl:variable>

<xsl:variable name="recurrence_privacy">不能只變更一個實例的私密性</xsl:variable>

<xsl:variable name="every_day_title">每一天</xsl:variable>

<xsl:variable name="every_weekday_title">每工作日</xsl:variable>

<xsl:variable name="every_title">每</xsl:variable>

<xsl:variable name="weekday_text">工作日</xsl:variable>

<xsl:variable name="weekendday_text">週末</xsl:variable>

<xsl:variable name="m_w_f_text">星期一、星期三與星期五</xsl:variable>

<xsl:variable name="t_th_text">星期二與星期四</xsl:variable>

<xsl:variable name="sat_sun_text">星期六與星期日</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">請提供有效的間隔</xsl:variable>

<xsl:variable name="every_week_title">每一週</xsl:variable>

<xsl:variable name="weeks_text">星期</xsl:variable>

<xsl:variable name="repeat_on_title">重複</xsl:variable>

<xsl:variable name="sunday_abbrev">星期日</xsl:variable>

<xsl:variable name="monday_abbrev">星期一</xsl:variable>

<xsl:variable name="tuesday_abbrev">星期二</xsl:variable>

<xsl:variable name="wednesday_abbrev">星期三</xsl:variable>

<xsl:variable name="thursday_abbrev">星期四</xsl:variable>

<xsl:variable name="friday_abbrev">星期五</xsl:variable>

<xsl:variable name="saturday_abbrev">星期六</xsl:variable>

<xsl:variable name="every_month_title">每一個月</xsl:variable>

<xsl:variable name="months_text">個月</xsl:variable>

<xsl:variable name="ordinal_1">1 日</xsl:variable>
<xsl:variable name="ordinal_2">2 日</xsl:variable>
<xsl:variable name="ordinal_3">3 日</xsl:variable>
<xsl:variable name="ordinal_4">4 日</xsl:variable>
<xsl:variable name="ordinal_5">5 日</xsl:variable>
<xsl:variable name="ordinal_6">6 日</xsl:variable>
<xsl:variable name="ordinal_7">7 日</xsl:variable>
<xsl:variable name="ordinal_8">8 日</xsl:variable>
<xsl:variable name="ordinal_9">9 日</xsl:variable>
<xsl:variable name="ordinal_10">10 日</xsl:variable>
<xsl:variable name="ordinal_11">11 日</xsl:variable>
<xsl:variable name="ordinal_12">12 日</xsl:variable>
<xsl:variable name="ordinal_13">13 日</xsl:variable>
<xsl:variable name="ordinal_14">14 日</xsl:variable>
<xsl:variable name="ordinal_15">15 日</xsl:variable>
<xsl:variable name="ordinal_16">16 日</xsl:variable>
<xsl:variable name="ordinal_17">17 日</xsl:variable>
<xsl:variable name="ordinal_18">18 日</xsl:variable>
<xsl:variable name="ordinal_19">19 日</xsl:variable>
<xsl:variable name="ordinal_20">20 日</xsl:variable>
<xsl:variable name="ordinal_21">21 日</xsl:variable>
<xsl:variable name="ordinal_22">22 日</xsl:variable>
<xsl:variable name="ordinal_23">23 日</xsl:variable>
<xsl:variable name="ordinal_24">24 日</xsl:variable>
<xsl:variable name="ordinal_25">25 日</xsl:variable>
<xsl:variable name="ordinal_26">26 日</xsl:variable>
<xsl:variable name="ordinal_27">27 日</xsl:variable>
<xsl:variable name="ordinal_28">28 日</xsl:variable>
<xsl:variable name="ordinal_29">29 日</xsl:variable>
<xsl:variable name="ordinal_30">30 日</xsl:variable>
<xsl:variable name="ordinal_31">31 日</xsl:variable>

<xsl:variable name="ordinal2_1">第一個</xsl:variable>
<xsl:variable name="ordinal2_2">第二個</xsl:variable>
<xsl:variable name="ordinal2_3">第三個</xsl:variable>
<xsl:variable name="ordinal2_4">第四個</xsl:variable>

<xsl:variable name="day_of_month_text">日</xsl:variable>
<xsl:variable name="cap_last_text">最後一個</xsl:variable>

<xsl:variable name="of_month_text">月</xsl:variable>

<xsl:variable name="every_year_text">每年</xsl:variable>

<xsl:variable name="years_text">年</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">這是重複事件。僅刪除這一個事件，還是所有事件？</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">這是重複事件。僅將變更套用至這一個事件，還是所有事件？</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">這是重複工作。僅刪除這一項工作，還是所有工作？</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">這是重複工作。僅將變更套用至這一項工作，還是所有工作？</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">摘要</xsl:variable>

<xsl:variable name="reply_title">回覆</xsl:variable>

<xsl:variable name="will_attend_msg">我將會參加</xsl:variable>

<xsl:variable name="will_not_attend_msg">我將不參加</xsl:variable>

<xsl:variable name="confirm_later_msg">我將於稍後確認</xsl:variable>

<xsl:variable name="reply_reminders_msg">透過提供電子郵件地址 (以逗號或分號分隔) 並選擇傳送的日期與時間，在此處排程電子郵件提醒通知。</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">在事件開始之前，您無法為未確認的事件設定警示</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">使用下列空間，為附加資訊提供提醒通知。事件的標題、日期、時間與位置將自動納入所有提醒通知。</xsl:variable>

<xsl:variable name="cal_select_msg">選取要用來儲存事件的行事曆</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">行事曆搜尋： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">行事曆搜尋</xsl:variable>

<xsl:variable name="cal_search_msg1">在儲存行事曆的位置搜尋行事曆</xsl:variable>
        
<xsl:variable name="name_or_id_text">名稱或 ID</xsl:variable>

<xsl:variable name="name_text">名稱</xsl:variable>

<xsl:variable name="primary_owner_text">主要所有者</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">包含</xsl:variable>

<xsl:variable name="begins_with_text">開頭為</xsl:variable>

<xsl:variable name="search_plain_title">搜尋</xsl:variable>

<xsl:variable name="already_selected_cals_title">已選取的行事曆</xsl:variable>

<xsl:variable name="cal_id_title">行事曆 ID</xsl:variable>

<xsl:variable name="search_results_title">搜尋結果</xsl:variable>

<xsl:variable name="no_match_found_msg">找不到相符的項目</xsl:variable>

<xsl:variable name="owner_title">所有者</xsl:variable>

<xsl:variable name="owner_name_colon_title">所有者名稱：</xsl:variable>

<xsl:variable name="cal_name_title">行事曆名稱</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">搜尋： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">搜尋事件與工作，其中包含</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">使用者搜尋： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">搜尋使用者</xsl:variable>

<xsl:variable name="search_local_msg">搜尋本地目錄</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(輸入名字、姓氏或使用者 ID)</xsl:variable>

<xsl:variable name="legend_title">圖例：</xsl:variable>

<xsl:variable name="resource_title">資源；</xsl:variable>

<xsl:variable name="already_selected_users_title">已選取的使用者</xsl:variable>

<xsl:variable name="name_userid_title">名稱 (使用者 ID)</xsl:variable>

<xsl:variable name="name_title">名稱</xsl:variable>

<xsl:variable name="userid_title">使用者 ID</xsl:variable>

<xsl:variable name="email_title">電子郵件</xsl:variable>

<xsl:variable name="for_text">後的</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">工作清單： Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">使用此面板可記錄所有要執行的作業。您可以按一下 [完成] 欄中的核取方塊來標記已完成的工作。按一下 [儲存並關閉] 來確定變更。</xsl:variable>

<xsl:variable name="done_title">完成</xsl:variable>

<xsl:variable name="task_title">工作</xsl:variable>

<xsl:variable name="select_all_title">全選</xsl:variable>

<xsl:variable name="alert_processing">處理</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">工作</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">輔助說明</xsl:variable>

<xsl:variable name="logout_text">登出</xsl:variable>

<xsl:variable name="login_text">登入</xsl:variable>

<xsl:variable name="home_text">首頁</xsl:variable>

<xsl:variable name="alt_schedule_msg">排程會議、生日或其他事件</xsl:variable>

<xsl:variable name="new_event_title">新增事件</xsl:variable>

<xsl:variable name="alt_todo_msg">新增項目至您的待辦事項清單</xsl:variable>

<xsl:variable name="new_task_title">新增工作</xsl:variable>

<xsl:variable name="jump_to_title">跳至</xsl:variable>

<xsl:variable name="alt_print_msg">開啟目前檢視適合列印的版本</xsl:variable>

<xsl:variable name="printable_title">列印專用</xsl:variable>

<xsl:variable name="alt_search_msg">搜尋事件與工作</xsl:variable>

<xsl:variable name="alt_new_calendar">建立新的行事曆</xsl:variable>

<xsl:variable name="new_cal_title">新增行事曆</xsl:variable>

<xsl:variable name="alt_new_group">建立行事曆的新群組</xsl:variable>

<xsl:variable name="new_group_title">新增群組</xsl:variable>

<xsl:variable name="alt_search_cals">搜尋行事曆</xsl:variable>

<xsl:variable name="subscribe_title">訂閱</xsl:variable>

<xsl:variable name="paren_subscribed_title">(已訂閱)</xsl:variable>

<xsl:variable name="alt_jump_next_week">跳至下一星期</xsl:variable>

<xsl:variable name="alt_jump_prev_week">跳至上一星期</xsl:variable>

<xsl:variable name="sunday_letter_title">日</xsl:variable>
<xsl:variable name="monday_letter_title">一</xsl:variable>
<xsl:variable name="tuesday_letter_title">二</xsl:variable>
<xsl:variable name="wednesday_letter_title">三</xsl:variable>
<xsl:variable name="thursday_letter_title">四</xsl:variable>
<xsl:variable name="friday_letter_title">五</xsl:variable>
<xsl:variable name="saturday_letter_title">六</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">選取的事件將從您的行事曆中移除。若是週期性事件，只有含有錯誤的事件會被移除。按一下 [確定] 繼續。</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">當顯示行事曆群組並建立事件時，在群組內所有行事曆上建立邀請</xsl:variable>

<xsl:variable name="invite_this_group_msg">當顯示這個行事曆群組並建立事件時，在群組內所有行事曆上建立邀請</xsl:variable>

<xsl:variable name="group_invitations_title">群組邀請</xsl:variable>

<xsl:variable name="starting_at_txt">開始於</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">未知的</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">無與會人員</xsl:variable>

<xsl:variable name="today_title">今天</xsl:variable>

<xsl:variable name="confirm_event_delete_text">您是否要刪除此事件？</xsl:variable>
<xsl:variable name="confirm_task_delete_text">您是否要刪除此工作？</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">連線至後端資料庫失敗。</xsl:variable>
<xsl:variable name="dwp_max_connections_error">後端資料庫的連線數已達最大。</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">無法連線資料有誤的後端資料庫。</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">無法解析行事曆。</xsl:variable>
<xsl:variable name="dwp_down_error">中斷</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP 主機環境不可用。</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">無法解析後端主機。</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">沒有資料 - 無法連線後端資料庫。</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">計算空閒時間時包含此事件</xsl:variable>
<xsl:variable name="freebusy_title">空閒/忙碌</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">您正在建立的整日事件將用於計算空閒時間。如果不正確，請按一下 [取消] 以返回，然後取消核取 [空閒/忙碌] 核取方塊。</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">您正在建立的私人事件將用於計算空閒時間。如果不正確，請按一下 [取消] 以返回，然後取消核取 [空閒/忙碌] 核取方塊。</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">行事曆資料庫處於唯讀模式。</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">無結束日期 </xsl:variable>
<xsl:variable name="cap_the_text">第 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 移除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0) ) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>歡迎  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>工作 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>行事曆 (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>開始於 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>一小時</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分鐘</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>超過一小時</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 可用)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 建立最多的 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 實例</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>任何地區內的一個或多個時區都可套用到目前的行事曆。在格狀檢視中 (如日檢視)，所有與行事曆相關聯的時區變成檢視時間刻度的一部份。如果這個行事曆沒有指定時區，則使用預設的時區。以下列出可使用的時區： </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>任何地區內的時區都可套用到目前的行事曆。在格狀檢視中 (如日檢視)，與行事曆相關聯的時區變成檢視時間刻度的一部份。如果這個行事曆沒有指定時區，則使用預設的時區。以下列出可使用的時區： </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北/南美洲 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>歐洲/非洲 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>亞洲/環太平洋區 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>地區：</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>下列事件已由下列使用者新增至您的行事曆「</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>」。您可以接受或拒絕這個邀請，選取下列適當的選項作為您的回覆。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>按一下</xsl:text>&nbsp;
  <B><xsl:text>瀏覽...</xsl:text></B>&nbsp;
  <xsl:text>選取檔案。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>利用這個窗格接受 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 或拒絕 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 或保持未決定 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 事件的邀請。</xsl:text>
  <br/>
  <xsl:text>關於週期性的事件，設定值將會套用至整個序列。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>搜尋少於 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 字元，結果可能不完整。若要較好的結果，請嘗試使用至少 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 字元。</xsl:text>

</xsl:template>


</xsl:stylesheet>
