<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  未命名
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">星期日</xsl:if>
  <xsl:if test=".='2'">星期一</xsl:if>
  <xsl:if test=".='3'">星期二</xsl:if>
  <xsl:if test=".='4'">星期三</xsl:if>
  <xsl:if test=".='5'">星期四</xsl:if>
  <xsl:if test=".='6'">星期五</xsl:if>
  <xsl:if test=".='7'">星期六</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">一</xsl:if>
  <xsl:if test="$downum='3'">二</xsl:if>
  <xsl:if test="$downum='4'">三</xsl:if>
  <xsl:if test="$downum='5'">四</xsl:if>
  <xsl:if test="$downum='6'">五</xsl:if>
  <xsl:if test="$downum='7'">六</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      您輸入的日期與時間無效。請修正。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      已有同名稱的行事曆存在。請選擇其他名稱。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      已有同名稱的群組存在。請選擇其他名稱。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 至 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      執行此搜尋時，目錄伺服器出現問題。&nbsp;      請提供其他搜尋字串。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      符合此搜尋的結果太多。&nbsp;      請提供更詳細的搜尋字串。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      不能建立至目錄伺服器的連線。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      不能建立至目錄伺服器的連線。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      執行此搜尋時，目錄伺服器出現問題。&nbsp;      請提供其他搜尋字串。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 錯誤： 已刪除事件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 錯誤： 不支援實施
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 錯誤： malloc 失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 錯誤： 無法建立 GSE 的多重實例
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 錯誤： GSE 項目無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 錯誤： 事件無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 錯誤： 找不到傳輸介面
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 錯誤： 在組織者的行事曆中找不到與會人員
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 錯誤： 無法建立資源，如鎖定、Gdisp 等
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 錯誤： 預期為 iCS 使用者，結果卻是 SMTP 使用者
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 錯誤： 元件方法和狀態無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 錯誤： 請求時間與另一個現有會議請求衝突
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      資料庫錯誤：找不到元件
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      資料庫錯誤：IO 錯誤
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      資料庫錯誤：事件的一個或多個值無效
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      資料庫錯誤：函式呼叫並未在提供的元件上操作
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      資料庫錯誤：未知或不支援的請求查詢
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      資料庫錯誤：所需的參數為空值，沒有設定，或是不存在
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      資料庫錯誤：因為請求的 SequenceNo 條件檢查失敗，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      資料庫錯誤：因為請求的修改時間條件檢查失敗，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      資料庫錯誤：因為行事曆不允許重疊的約會，寫入中止
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      資料庫錯誤：ENS 通知傳回一個錯誤
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      資料庫錯誤：要求的值為空值
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      受邀人錯誤：錯誤的引數
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      受邀人錯誤：找不到行事曆
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      受邀人錯誤：行事曆停用
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      受邀人錯誤：使用者不允許存取行事曆
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      受邀人錯誤：群組被切掉
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      受邀人錯誤：無法移除召集人
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      行事曆錯誤：行事曆建立失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      行事曆錯誤：與現有的行事曆具有相同識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      行事曆錯誤：使用者沒有執行這項操作所需的存取權限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      行事曆錯誤：使用者嘗試存取不存在的行事曆。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      行事曆錯誤：不合法的行事曆識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      受邀人錯誤：無法重複預約受邀人。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      行事曆錯誤：使用者沒有執行這項操作所需的存取權限。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      行事曆錯誤：使用者必須是所有者或是共同所有者才能執行這項操作。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      行事曆錯誤： 資料庫處於唯讀模式。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      請利用 [空閒時間] 頁籤尋找可用的時間。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      群組錯誤：不合法的群組識別項
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      行事曆錯誤：無法加入未知的使用者至私密性清單或所有人清單。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 錯誤： 沒有郵件主機
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 錯誤： 連線失敗
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 錯誤： 沒有發生對連線的預期回應
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 錯誤： 定址郵件時出現問題
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 錯誤： 沒有收信人
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      錯誤：連線至後端資料庫失敗。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      錯誤：後端資料庫的連線數已達最大。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      錯誤：無法解析行事曆。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      錯誤：無法使用資料有誤的後端資料庫。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      錯誤：DWP 主機環境不可用。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      錯誤：無法解析後端主機。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      錯誤：無資料 – 無法使用後端資料庫。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      錯誤：連線至後端資料庫失敗。
    </xsl:when>
    <xsl:otherwise>
      不明 錯誤 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      錯誤：一個週期性實例無法跳過另一個週期性實例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      錯誤：不能在同一天出現兩個週期性實例。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      錯誤：不能只變更一個實例的私密性。
    </xsl:when>
    <xsl:otherwise>
      未知的週期性錯誤 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">美洲/艾達克</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">美洲/安克拉治</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">美洲/洛杉磯</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">美洲/鳳凰城</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">美洲/丹佛</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">美洲/哥斯大黎加</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">美洲/芝加哥</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">美洲/印第安那波里</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">美洲/紐約</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">美洲/哈瓦那</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">美洲/太子港</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">美洲/大特克島</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">美洲/卡拉卡斯</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">美洲/古雅巴</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">美洲/哈利法克斯</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">美洲/聖地牙哥</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋/史坦萊</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">美洲/聖約翰斯</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">美洲/布宜諾斯艾利斯</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">美洲/聖保羅</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">美洲/麥克隆</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">美洲/哥特哈布</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋/南喬治亞</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋/維德角</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋/亞述群島</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">非洲/卡薩布蘭卡</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">歐洲/倫敦</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">非洲/拉哥斯</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">歐洲/巴黎</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">非洲/的黎波里</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">歐洲/華沙</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">非洲/約翰尼斯堡</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">歐洲/布加勒斯特</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">歐洲/伊斯坦堡</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">非洲/開羅</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">歐洲/里加</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">非洲/溫吐克</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">歐洲/明斯克</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">歐洲/欣佛洛普</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">歐洲/莫斯科</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">歐洲/沙馬拉</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">亞洲/貝魯特</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">亞洲/耶路撒冷</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">亞洲/安曼</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">亞洲/利雅德</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">亞洲/德黑蘭</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">亞洲/葉里溫</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">亞洲/阿克陶</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">亞洲/巴庫</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">亞洲/喀布爾</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">亞洲/喀拉蚩</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">亞洲/阿克托比</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">亞洲/比斯凱克</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">亞洲/耶卡特寧伯格</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">亞洲/加爾各答</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">亞洲/加德滿都</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">亞洲/達卡</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">亞洲/阿拉木圖</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">亞洲/新西伯利亞</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">亞洲/仰光</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">亞洲/曼谷</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">亞洲/克拉斯諾雅</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">亞洲/庫倫</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">亞洲/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">亞洲/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">亞洲/伊爾庫次克</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">亞洲/東京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">亞洲/漢城</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">亞洲/雅庫次克</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">澳大利亞/伯斯</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">澳大利亞/達爾文</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">澳大利亞/阿得雷德</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">澳大利亞/布里斯本</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">澳大利亞/雪梨</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">澳大利亞/霍巴特</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">亞洲/海參崴</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">澳大利亞/羅德豪島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋/瓜達康納爾島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋/諾米亞</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">亞洲/馬加丹</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋/諾福克島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋/斐濟</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋/奧克蘭</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">亞洲/堪察加</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋/查坦</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋/東加塔普</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">亞洲/阿那底</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋/刻里提瑪斯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋/阿比亞</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋/火奴魯魯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋/拉洛東加島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋/馬克沙斯</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋/甘比爾</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋/皮特康</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋/伊斯特</xsl:when> 
    <xsl:otherwise>
      不明 時區 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">無結束日期 </xsl:variable>
<xsl:variable name="cap_the_text">第 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 移除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0) ) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>歡迎  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>工作 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>行事曆 (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>開始於 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>一小時</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分鐘</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>超過一小時</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 可用)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 建立最多的 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 實例</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>任何地區內的一個或多個時區都可套用到目前的行事曆。在格狀檢視中 (如日檢視)，所有與行事曆相關聯的時區變成檢視時間刻度的一部份。如果這個行事曆沒有指定時區，則使用預設的時區。以下列出可使用的時區： </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>任何地區內的時區都可套用到目前的行事曆。在格狀檢視中 (如日檢視)，與行事曆相關聯的時區變成檢視時間刻度的一部份。如果這個行事曆沒有指定時區，則使用預設的時區。以下列出可使用的時區： </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北/南美洲 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>歐洲/非洲 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>亞洲/環太平洋區 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>地區：</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>下列事件已由下列使用者新增至您的行事曆「</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>」。您可以接受或拒絕這個邀請，選取下列適當的選項作為您的回覆。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>按一下</xsl:text>&nbsp;
  <B><xsl:text>瀏覽...</xsl:text></B>&nbsp;
  <xsl:text>選取檔案。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>利用這個窗格接受 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 或拒絕 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 或保持未決定 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 事件的邀請。</xsl:text>
  <br/>
  <xsl:text>關於週期性的事件，設定值將會套用至整個序列。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>搜尋少於 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 字元，結果可能不完整。若要較好的結果，請嘗試使用至少 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 字元。</xsl:text>

</xsl:template>


</xsl:stylesheet>
