<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  제목 없음
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">일요일</xsl:if>
  <xsl:if test=".='2'">월요일</xsl:if>
  <xsl:if test=".='3'">화요일</xsl:if>
  <xsl:if test=".='4'">수요일</xsl:if>
  <xsl:if test=".='5'">목요일</xsl:if>
  <xsl:if test=".='6'">금요일</xsl:if>
  <xsl:if test=".='7'">토요일</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">일</xsl:if>
  <xsl:if test="$downum='2'">월</xsl:if>
  <xsl:if test="$downum='3'">화</xsl:if>
  <xsl:if test="$downum='4'">수</xsl:if>
  <xsl:if test="$downum='5'">목</xsl:if>
  <xsl:if test="$downum='6'">금</xsl:if>
  <xsl:if test="$downum='7'">토</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1월</xsl:if>
  <xsl:if test=".='02'">2월</xsl:if>
  <xsl:if test=".='03'">3월</xsl:if>
  <xsl:if test=".='04'">4월</xsl:if>
  <xsl:if test=".='05'">5월</xsl:if>
  <xsl:if test=".='06'">6월</xsl:if>
  <xsl:if test=".='07'">7월</xsl:if>
  <xsl:if test=".='08'">8월</xsl:if>
  <xsl:if test=".='09'">9월</xsl:if>
  <xsl:if test=".='10'">10월</xsl:if>
  <xsl:if test=".='11'">11월</xsl:if>
  <xsl:if test=".='12'">12월</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1월</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2월</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3월</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4월</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5월</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6월</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7월</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8월</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9월</xsl:if>
  <xsl:if test="$MonthNum=10">10월</xsl:if>
  <xsl:if test="$MonthNum=11">11월</xsl:if>
  <xsl:if test="$MonthNum=12">12월</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1월</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2월</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3월</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4월</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5월</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6월</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7월</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8월</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9월</xsl:if>
  <xsl:if test="$MonthNum=10">10월</xsl:if>
  <xsl:if test="$MonthNum=11">11월</xsl:if>
  <xsl:if test="$MonthNum=12">12월</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      입력한 날짜와 시간이 유효하지 않습니다. 올바른 값을 입력하십시오.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      이 이름을 가진 달력이 이미 있습니다. 다른 이름을 선택하십시오.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      이 이름을 가진 그룹이 이미 있습니다. 다른 이름을 선택하십시오.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> 대상 </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      이 검색으로 인해 디렉토리 서버에 문제가 발생했습니다.&nbsp;      다른 검색 문자열을 입력하십시오.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      이 검색과 일치하는 결과가 너무 많습니다.&nbsp;      검색 문자열을 자세히 입력하십시오.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      디렉토리 서버에 연결하지 못했습니다.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      디렉토리 서버에 연결하지 못했습니다.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      이 검색으로 인해 디렉토리 서버에 문제가 발생했습니다.&nbsp;      다른 검색 문자열을 입력하십시오.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE 오류: 이벤트가 삭제되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE 오류: 지원되지 않는 구현입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE 오류: malloc이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE 오류: GSE의 여러 인스턴스를 만들 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE 오류: GSE 항목이 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE 오류: 이벤트가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE 오류: 전송 인터페이스를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE 오류: 구성 도우미 달력에서 참석자를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE 오류: lock, GDisp 등의 자원을 만들 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE 오류: SMTP 사용자 대신 iCS 사용자를 불러올 것으로 예상됩니다.
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE 오류: 구성 요소 메소드 및 상태가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE 오류: 요청한 시간이 기존의 다른 회의 요청 시간과 충돌합니다.
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB 오류: 구성 요소를 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB 오류: 입출력 오류입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB 오류: 하나 이상의 이벤트 값이 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB 오류: 함수 호출이 제공된 구성 요소에서 작동하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB 오류: 요청된 쿼리는 알 수 없거나 지원되지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB 오류: 필수 매개 변수가 NULL이거나 설정되지 않았거나 존재하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB 오류: 요청한 SequenceNo 상태 확인의 실패로 인해 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB 오류: 요청한 수정 시간 상태 확인의 실패로 인해 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB 오류: 달력에서 약속 중복을 허용하지 않으므로 쓰기가 중단되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB 오류: ENS 알림이 오류를 반환했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB 오류: 필수 값이 null입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      초대 받은 사람 오류: 잘못된 인수입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      초대 받은 사람 오류: 달력을 찾을 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      초대 받은 사람 오류: 달력이 사용 불가능한 상태입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      초대 받은 사람 오류: 사용자가 달력에 액세스할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      초대 받은 사람 오류: 그룹이 삭제되었습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      초대 받은 사람 오류: 구성 도우미를 제거할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      달력 오류: 달력 작성이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      달력 오류: ID가 같은 달력이 이미 있습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      달력 오류: 이 작업을 수행하는 데 필요한 액세스 권한이 없습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      달력 오류: 액세스하려고 시도한 달력은 존재하지 않습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      달력 오류: 달력 ID가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      초대 받은 사람 오류: 초대할 사람을 이중으로 예약할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      달력 오류: 이 작업을 수행하는 데 필요한 액세스 권한이 없습니다.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      달력 오류: 이 작업은 소유자 또는 공동 소유자만 수행할 수 있습니다.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      달력 오류: 읽기 전용 모드 데이터베이스입니다.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      사용 가능한 시간을 찾으려면 가용성 탭을 참조하십시오.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      그룹 오류: 그룹 ID가 유효하지 않습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      달력 오류: 개인 정보 또는 소유자 목록에 알 수 없는 사용자를 추가할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP 오류: 메일 호스트가 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP 오류: 연결이 실패했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP 오류: 연결에 대한 예상 응답이 발생되지 않았습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP 오류: 메시지의 주소를 지정하는 중 문제가 발생했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP 오류: 수신자가 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      오류: 백엔드 데이터베이스에 연결하지 못했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      오류: 백엔드 데이터베이스에 대한 최대 연결 수에 도달했습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      오류: 달력을 확인할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      오류: 연결할 수 없는 잘못된 데이터 백엔드 데이터베이스입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      오류: DWP 호스트 컨텍스트를 사용할 수 없습니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      오류: 확인할 수 없는 백엔드 호스트입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      오류: 데이터 없음 - 연결할 수 없는 백엔드 데이터베이스입니다.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      오류: 백엔드 데이터베이스에 연결하지 못했습니다.
    </xsl:when>
    <xsl:otherwise>
      알 수 없음 오류 #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      오류: 반복 이벤트의 한 인스턴스가 다른 인스턴스를 건너뛸 수 없습니다.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      오류: 반복 이벤트의 두 인스턴스가 같은 날 발생할 수 없습니다.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      오류: 한 인스턴스만 개인 정보를 변경할 수 없습니다.
    </xsl:when>
    <xsl:otherwise>
      알 수 없는 반복 오류 #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">아메리카/에이덕</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">아메리카/앵커리지</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">아메리카/로스앤젤레스</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">아메리카/피닉스</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">아메리카/덴버</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">아메리카/코스타리카</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">아메리카/시카고</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">아메리카/인디애나폴리스</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">아메리카/뉴욕</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">아메리카/아바나</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">아메리카/포르토프랭스</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">아메리카/그랜드터크</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">아메리카/카라카스</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">아메리카/쿠이아바</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">아메리카/핼리팩스</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">아메리카/산티아고</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">대서양/스탠리</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">아메리카/세인트존스</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">아메리카/부에노스아이레스</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">아메리카/상파울루</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">아메리카/미클롱</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">아메리카/고드호프</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">대서양/사우스조지아</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">대서양/케이프베르데</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">대서양/아조레스</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">아프리카/카사블랑카</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">유럽/런던</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">아프리카/라고스</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">유럽/파리</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">아프리카/트리폴리</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">유럽/바르샤바</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">아프리카/요하네스버그</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">유럽/부쿠레슈티</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">유럽/이스탄불</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">아프리카/카이로</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">유럽/리가</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">아프리카/빈트후크</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">유럽/민스크</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">유럽/심페로폴</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">유럽/모스크바</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">유럽/사마라</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">아시아/베이루트</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">아시아/예루살렘</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">아시아/암만</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">아시아/리야드</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">아시아/테헤란</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">아시아/예레반</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">아시아/아크타우</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">아시아/바쿠</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">아시아/카불</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">아시아/카라치</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">아시아/악튜빈스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">아시아/비슈케크</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">아시아/예카테린부르크</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">아시아/캘커타</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">아시아/카트만두</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">아시아/다카</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">아시아/알마아타</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">아시아/노보시비르스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">아시아/랑군</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">아시아/방콕</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">아시아/크라스노야르스크</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">아시아/울란바토르</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">아시아/상하이</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">아시아/타이페이</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">아시아/이르쿠츠크</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">아시아/도쿄</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">아시아/서울</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">아시아/야쿠츠크</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">오스트레일리아/퍼스</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">오스트레일리아/다윈</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">오스트레일리아/애들레이드</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">오스트레일리아/브리즈번</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">오스트레일리아/시드니</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">오스트레일리아/호바트</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">아시아/블라디보스토크</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">오스트레일리아/로드하우</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">태평양/과달카날</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">태평양/누메아</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">아시아/마가단</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">태평양/노퍽</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">태평양/피지</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">태평양/오클랜드</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">아시아/캄차카</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">태평양/채텀</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">태평양/통가타푸</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">아시아/아나디르</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">태평양/키리티마티</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">태평양/아피아</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">태평양/호놀룰루</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">태평양/라로통가</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">태평양/마키저스</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">태평양/갬비어</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">태평양/핏케언</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">태평양/이스터</xsl:when> 
    <xsl:otherwise>
      알 수 없음 표준 시간대 #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- PARSE_VARIABLES_BEGIN -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- Commonly used stuff -->
<xsl:variable name="ok_title">확인</xsl:variable>

<xsl:variable name="cancel_title">취소</xsl:variable>
<xsl:variable name="close_title">닫기</xsl:variable>
<xsl:variable name="help_title">도움말</xsl:variable>
<xsl:variable name="apply_title">적용</xsl:variable>

<!-- overview.xsl -->
<xsl:variable name="no_components_msg">이벤트 또는 작업 없음</xsl:variable>
<xsl:variable name="week_ahead_title">다음 주</xsl:variable>
<xsl:variable name="alt_text_schedule">새 약속 예약</xsl:variable>

<!-- add_people.xsl -->
<xsl:variable name="enter_user_name_msg">아래에 사용자 이름을 입력한 다음 확인 버튼을 누르십시오.</xsl:variable>

<xsl:variable name="user_name_title">사용자 이름</xsl:variable>

<!-- availability.xsl and groupview.xsl -->
<xsl:variable name="alt_jump_prev_day">이전 날짜로 이동</xsl:variable>

<xsl:variable name="alt_jump_next_day">다음 날짜로 이동</xsl:variable>

<xsl:variable name="alt_jump_new_date">새 날짜로 이동</xsl:variable>

<xsl:variable name="available_title">사용 가능</xsl:variable>

<xsl:variable name="busy_title">사용 중</xsl:variable>

<xsl:variable name="hour_text">시간</xsl:variable>
<xsl:variable name="minutes_text">분</xsl:variable>

<xsl:variable name="show_availability_title">가용성 표시</xsl:variable>

<xsl:variable name="error_cal_privacy">이 달력의 개인 정보를 사용자가 볼 수 없거나 이 달력이 없습니다.</xsl:variable>

<!-- cal_timezones.xsl -->
<xsl:variable name="north_south_americas_title">북아메리카/남아메리카</xsl:variable>

<xsl:variable name="europe_africa_title">유럽/아프리카</xsl:variable>

<xsl:variable name="asia_pacific_rim_title">아시아/태평양 연안</xsl:variable>

<xsl:variable name="time_zone_title">표준 시간대</xsl:variable>

<xsl:variable name="gmt_offset_title">GMT 오프셋</xsl:variable>

<!-- calendar_groupview.xsl  and calendars.xsl -->
<xsl:variable name="calendar_express_page_title">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="groups_title">그룹</xsl:variable>

<xsl:variable name="groups_msg">한 번에 여러 개의 달력을 보려면 달력 그룹을 사용합니다. 달력 그룹을 보려면 그룹 이름 링크를 누르십시오. 달력을 그룹에 추가하거나 그룹에서 제거하려면 편집 링크를 누르십시오.</xsl:variable>

<xsl:variable name="select_title">선택</xsl:variable>

<xsl:variable name="group_title">그룹</xsl:variable>

<xsl:variable name="group_colon_title">그룹:</xsl:variable>

<xsl:variable name="description_title">설명</xsl:variable>

<xsl:variable name="properties_title">등록 정보</xsl:variable>

<xsl:variable name="error_cal_access">이 달력에 액세스할 수 있는 권한이 없습니다.</xsl:variable>

<xsl:variable name="error_cal_not_exist">이 달력이 없습니다.</xsl:variable>

<xsl:variable name="edit_title">편집</xsl:variable>
<xsl:variable name="edit_calendar_title">달력 편집</xsl:variable>

<xsl:variable name="remove_selected_title">선택한 항목 제거</xsl:variable>

<xsl:variable name="calendars_title">달력</xsl:variable>

<xsl:variable name="calendars_msg">소유 또는 가입한 달력의 목록입니다. 달력을 보려면 달력 이름을 누르십시오. 달력을 편집하려면 편집을 누르십시오.</xsl:variable>

<xsl:variable name="calendar_title">달력</xsl:variable>

<xsl:variable name="view_title">보기</xsl:variable>
<xsl:variable name="view_calendar_title">달력 보기</xsl:variable>

<xsl:variable name="view_colon_title">보기:</xsl:variable>

<xsl:variable name="options_title">옵션</xsl:variable>

<!-- change_timezones.xsl -->
<xsl:variable name="change_timezone_page_title">기본 표준 시간대 변경: Sun Java[tm] System Calendar Express</xsl:variable>

<!-- common.xsl -->
<xsl:variable name="overview_tab_title">개요</xsl:variable>

<xsl:variable name="day_tab_title">일</xsl:variable>

<xsl:variable name="week_tab_title">주</xsl:variable>

<xsl:variable name="month_tab_title">월</xsl:variable>

<xsl:variable name="year_tab_title">연도</xsl:variable>

<xsl:variable name="comparison_tab_title">비교</xsl:variable>

<xsl:variable name="repeat_title">반복</xsl:variable>

<xsl:variable name="change_repeat_title">반복 패턴 변경</xsl:variable>

<xsl:variable name="alt_jump_prev_month">이전 달로 이동</xsl:variable>

<xsl:variable name="alt_jump_next_month">다음 달로 이동</xsl:variable>

<!-- add space here -->
<xsl:variable name="today_is_msg">오늘: </xsl:variable>

<xsl:variable name="alt_jump_this_date">이 날짜로 이동</xsl:variable>

<xsl:variable name="action_items_title">작업 항목</xsl:variable>

<xsl:variable name="invitations_title">초대</xsl:variable>

<xsl:variable name="no_invitations_msg">초대 없음</xsl:variable>

<xsl:variable name="tasks_title">작업</xsl:variable>

<xsl:variable name="overdue_msg">기한 지남</xsl:variable>

<xsl:variable name="no_tasks_msg">작업 없음</xsl:variable>

<xsl:variable name="errors_title">오류</xsl:variable>

<xsl:variable name="no_errors_msg">오류 없음</xsl:variable>

<xsl:variable name="daily_title">매일</xsl:variable>

<xsl:variable name="weekly_title">매주</xsl:variable>

<xsl:variable name="monthly_title">매월</xsl:variable>

<xsl:variable name="yearly_title">매년</xsl:variable>

<!--- common_repeating.xsl -->

<xsl:variable name="repeating_selection_page_title">선택 반복: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="this_only_title">이 인스턴스만</xsl:variable>

<xsl:variable name="this_and_future_title">이 이벤트 및 나중에 발생하는 이벤트</xsl:variable>

<xsl:variable name="all_instances_title">모든 인스턴스</xsl:variable>

<xsl:variable name="repeating_selection_title">선택 항목 반복</xsl:variable>

<!-- common_view.xsl -->
<xsl:variable name="due_today_title">기한: 오늘까지</xsl:variable>

<xsl:variable name="other_tasks_title">다른 작업</xsl:variable>

<xsl:variable name="overdue_tasks_title">기한이 지난 작업</xsl:variable>

<xsl:variable name="all_day_events_title">하루 종일 이벤트</xsl:variable>

<xsl:variable name="conflict_msg">충돌</xsl:variable>

<xsl:variable name="overdue_title">기한 지남</xsl:variable>

<xsl:variable name="due_at_title">기한</xsl:variable>

<xsl:variable name="untitled_task_title">제목이 없는 작업</xsl:variable>

<xsl:variable name="alt_view_this_task">이 작업 보기</xsl:variable>

<xsl:variable name="alt_delete_this_task">이 작업 삭제</xsl:variable>

<xsl:variable name="untitled_event_title">제목이 없는 이벤트</xsl:variable>

<xsl:variable name="alt_delete_this_event">이 이벤트 삭제</xsl:variable>

<xsl:variable name="alt_view_this_event">이 이벤트 보기</xsl:variable>

<xsl:variable name="all_day_title">하루 종일</xsl:variable>

<xsl:variable name="overdue_from_title">기한 지남</xsl:variable>

<xsl:variable name="from_txt">부터</xsl:variable>

<xsl:variable name="due_on_title">기한</xsl:variable>

<xsl:variable name="not_due_title">기한 없음</xsl:variable>

<xsl:variable name="due_title">기한</xsl:variable>

<xsl:variable name="on_txt">설정</xsl:variable>

<!-- date_format.xsl -->
<xsl:variable name="am_txt">오전</xsl:variable>

<xsl:variable name="pm_txt">오후</xsl:variable>

<xsl:variable name="midnight_title">자정</xsl:variable>

<xsl:variable name="noon_title">정오</xsl:variable>

<xsl:variable name="from_title">부터</xsl:variable>

<!-- dayview.xsl -->
<xsl:variable name="alt_schedule_new_appt">새 약속 예약</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_list_page_title">오류 목록: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="errors_msg">이 패널에는 해결되지 않은 예약 오류 목록이 표시됩니다.</xsl:variable>

<xsl:variable name="organizer_title">구성 도우미</xsl:variable>

<xsl:variable name="attendee_title">참석자</xsl:variable>

<xsl:variable name="no_outstanding_errors_msg">해결되지 않은 오류 없음</xsl:variable>

<!-- event_recurrence.xsl and task_recurrence.xsl -->
<xsl:variable name="recurrence_page_title">반복: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="recurrence_title">반복</xsl:variable>

<xsl:variable name="start_title">시작</xsl:variable>

<xsl:variable name="end_title">종료</xsl:variable>

<xsl:variable name="create_title">만들기</xsl:variable>

<xsl:variable name="events_text">이벤트</xsl:variable>

<xsl:variable name="alert_provide_valid_count">올바른 수를 입력하십시오.</xsl:variable>

<xsl:variable name="alert_provide_number_lt_or_eq_to">다음 수보다 작거나 같은 수를 입력하십시오.</xsl:variable>

<xsl:variable name="confirm_event_absolute_alarm">이 이벤트에 대한 미리 알림은 이벤트 시작 후 시간으로 설정됩니다. 이전으로 돌아가서 시간을 변경하려면 취소를 누르십시오.</xsl:variable>

<xsl:variable name="confirm_task_absolute_alarm">이 태스크에 대한 미리 알림은 작업 만료 시간 후로 설정됩니다. 이전으로 돌아가서 시간을 변경하려면 취소를 누르십시오.</xsl:variable>

<!-- event_tabs.xsl -->
<xsl:variable name="compose_title">구성</xsl:variable>

<xsl:variable name="reminders_title">미리 알림</xsl:variable>

<xsl:variable name="availability_title">가용성</xsl:variable>

<xsl:variable name="preview_title">미리 보기</xsl:variable>

<!-- invitations_list.xsl -->
<xsl:variable name="invitations_list_page_title">초대 목록: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="delete_title">삭제</xsl:variable>

<xsl:variable name="recurring_event_msg">반복 이벤트</xsl:variable>

<xsl:variable name="no_outstanding_invitations_msg">해결되지 않은 초대 없음</xsl:variable>

<xsl:variable name="all_title">모두</xsl:variable>

<xsl:variable name="delete_all_title">모두 삭제</xsl:variable>

<xsl:variable name="save_and_close_title">저장 후 닫기</xsl:variable>

<!-- javascript.xsl -->
<xsl:variable name="alert_selected_blank_choice">선택 항목에서 빈 문자열을 선택했습니다.</xsl:variable>

<xsl:variable name="alert_min_year">1970년 이전의 연도는 볼 수 없습니다.</xsl:variable>
<xsl:variable name="alert_max_year">2036년 이후의 연도는 볼 수 없습니다.</xsl:variable>

<xsl:variable name="alert_invalid_date">잘못된 날짜입니다. 올바른 날짜를 입력하십시오.</xsl:variable>

<xsl:variable name="january_title">1월</xsl:variable>
<xsl:variable name="february_title">2월</xsl:variable>
<xsl:variable name="march_title">3월</xsl:variable>
<xsl:variable name="april_title">4월</xsl:variable>
<xsl:variable name="may_title">5월</xsl:variable>
<xsl:variable name="june_title">6월</xsl:variable>
<xsl:variable name="july_title">7월</xsl:variable>
<xsl:variable name="august_title">8월</xsl:variable>
<xsl:variable name="september_title">9월</xsl:variable>
<xsl:variable name="october_title">10월 </xsl:variable>
<xsl:variable name="november_title">11월</xsl:variable>
<xsl:variable name="december_title">12월</xsl:variable>

<xsl:variable name="provide_good_date_for_msg">올바른 날짜를 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_date_msg">올바른 날짜를 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_month_msg">1-12월 중 하나를 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_year_msg">올바른 연도를 입력하십시오.\n\n두 자릿수를 사용하여 연도를 표현하는 경우 37보다 작은 값은\n21세기로 해석됩니다.\n\n예를 들어, 03은 2003과 같습니다.</xsl:variable>

<xsl:variable name="provide_good_min_year_msg">1970년 이후 연도를 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_max_year_msg">2037년 이전 연도를 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_hour_msg">유효한 시간 값을 입력하십시오. 12시간 모드에서는 (1-12)이 유효한 값이고 24시간 모드에서는 (0-23)이 유효한 값입니다.</xsl:variable>

<xsl:variable name="provide_good_duration_hour_msg">유효한 시간 값(0-23)을 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_minute_msg">분 값(0-59)을 입력하십시오.</xsl:variable>

<xsl:variable name="provide_good_until_date_msg">시작 날짜 이후의 날짜를 선택하십시오.</xsl:variable>

<xsl:variable name="provide_adjusting_date_msg">입력한 날짜가 존재하지 않습니다.\n유효한 날짜 중 가장 가까운 날짜로 달력을 설정하고 있습니다.</xsl:variable>

<!-- jump_to.xsl -->
<xsl:variable name="jump_to_page_title">날짜로 이동: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="alt_jump_prev_year">이전 연도로 이동</xsl:variable>

<xsl:variable name="alt_jump_next_year">다음 연도로 이동</xsl:variable>

<xsl:variable name="jump_to_date_title">날짜로 이동</xsl:variable>

<!-- new_cal.xsl -->
<xsl:variable name="delete_privacy_text">이 개인 정보 항목을 삭제하겠습니까?</xsl:variable>

<xsl:variable name="edit_calendar_page_title">달력 편집: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="required_info_msg">필수 정보를 나타냅니다.</xsl:variable>

<xsl:variable name="calendar_name_msg">"baseball"과 같이 달력의 약식 이름을 입력하십시오(공백은 허용되지 않음).</xsl:variable>

<xsl:variable name="display_name_title">표시 이름</xsl:variable>

<xsl:variable name="display_name_msg">"찬호의 야구 일정"과 같이 이 달력의 목적을 알려주는 선택 필드입니다.</xsl:variable>

<xsl:variable name="include_in_availability_msg">가용성 계산 시 이 달력을 포함합니다.</xsl:variable>

<xsl:variable name="calendar_address_title">달력 주소</xsl:variable>

<xsl:variable name="calendar_address_msg">여기에 링크를 제공하여 다른 사용자에게 이 달력에 대한 액세스 권한을 제공할 수 있습니다. 다른 사용자에게 액세스 권한이 제공되도록 액세스 제어를 설정하면 다른 사용자가 브라우저에서 해당 링크를 사용하여 달력을 볼 수 있습니다.</xsl:variable>

<xsl:variable name="cal_permissions_colon_title">달력에 대한 권한:</xsl:variable>

<xsl:variable name="cal_permissions_msg">권한은 다른 사용자가 이 달력을 보고 변경할 수 있는 방법을 결정합니다. 모든 사용자에게 특정 권한을 부여하려면 모든 사용자 옆의 열에서 해당 권한을 선택하십시오. 개인에게 특정 권한을 부여하려면 사용자 필드에 사용자 아이디를 입력하고 "사용자 추가"를 누르십시오. 그런 다음 사용자 이름 옆의 열에서 해당 권한을 선택하십시오.</xsl:variable>

<xsl:variable name="user_title">사용자</xsl:variable>
<xsl:variable name="user_title_with_colon">사용자:</xsl:variable>

<xsl:variable name="permissions_title">권한</xsl:variable>

<xsl:variable name="invite_title">초대</xsl:variable>

<xsl:variable name="read_title">읽기</xsl:variable>

<xsl:variable name="modify_title">수정</xsl:variable>

<xsl:variable name="delete_selected_user_title">선택한 사용자 삭제</xsl:variable>

<xsl:variable name="add_user_title">사용자 추가</xsl:variable>

<xsl:variable name="everybody_title">모든 사용자</xsl:variable>

<xsl:variable name="this_domain_title">이 도메인</xsl:variable>

<xsl:variable name="tip_cal_owners">달력 소유자 지정에 대한 팁:</xsl:variable>

<xsl:variable name="cal_owner_msg">이 달력의 소유자를 한 명 이상 추가할 수 있습니다. 소유자는 초대에 대해 회신을 보낼 수 있으며 이벤트를 만들고, 수정하고 삭제할 수 있습니다.</xsl:variable>

<xsl:variable name="no_owners_msg">소유자가 없습니다.</xsl:variable>

<xsl:variable name="delete_owner_title">소유자 삭제</xsl:variable>

<xsl:variable name="add_owner_title">소유자 추가</xsl:variable>

<xsl:variable name="confirm_cal_delete_msg">이 달력을 삭제하시겠습니까?</xsl:variable>

<xsl:variable name="alert_supply_cal_name">달력 이름을 지정해야 합니다.</xsl:variable>

<xsl:variable name="owners_title">소유자</xsl:variable>

<xsl:variable name="time_zones_title">표준 시간대</xsl:variable>

<!-- new_event.xsl and lots of new_task.xsl -->
<xsl:variable name="delete_event_text">이 이벤트를 삭제하시겠습니까?</xsl:variable>

<xsl:variable name="edit_event_page_title">이벤트 편집: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_invite_title">---빠른 초대---</xsl:variable>

<xsl:variable name="event_title_title">이벤트 제목</xsl:variable>

<xsl:variable name="date_title">날짜</xsl:variable>

<xsl:variable name="time_title">시간</xsl:variable>

<xsl:variable name="all_day_msg">하루 종일(예를 들어, 휴가 또는 생일)</xsl:variable>

<xsl:variable name="privacy_title">개인 정보</xsl:variable>

<xsl:variable name="public_event_title">공개 이벤트</xsl:variable>

<xsl:variable name="confidential_event_title">시간 및 날짜만</xsl:variable>

<xsl:variable name="private_event_title">개인 이벤트</xsl:variable>

<xsl:variable name="location_title">위치</xsl:variable>

<xsl:variable name="invite_others_msg">다른 사용자나 자원 초대:</xsl:variable>

<xsl:variable name="search_title">검색(S)...</xsl:variable>

<xsl:variable name="inform_title">정보 제공</xsl:variable>

<xsl:variable name="invite_instructions_msg">(사용자 아이디, 달력 아이디 또는 전자 메일 주소를 입력하십시오. 이름을 모르는 경우 검색을 누르십시오.)</xsl:variable>

<xsl:variable name="invitees_title">초대 받은 사람</xsl:variable>

<xsl:variable name="no_invitees_msg">초대 받은 사람 없음</xsl:variable>

<xsl:variable name="remove_title">제거</xsl:variable>

<xsl:variable name="inform_event_title">이벤트에 대한 정보 제공</xsl:variable>

<xsl:variable name="no_informees_msg">정보를 제공 받은 사람이 없음</xsl:variable>

<xsl:variable name="event_reminders_msg">이 이벤트에 대한 미리 알림을 전자 메일로 자신에게 보낼 수 있습니다. 하나 이상의 본인의 전자 메일 주소를 아래에 입력하십시오. 쉼표(,) 또는 세미콜론(;)을 사용하여 각 전자 메일 주소를 구분하십시오.</xsl:variable>

<xsl:variable name="remind_title">미리 알림</xsl:variable>

<xsl:variable name="alert_provide_valid_time">유효한 시간을 입력하십시오.</xsl:variable>

<xsl:variable name="hours_text">시간</xsl:variable>

<xsl:variable name="days_text">일</xsl:variable>

<xsl:variable name="before_the_event_begins_text">이벤트 시작 전</xsl:variable>

<xsl:variable name="at_text">시</xsl:variable>

<xsl:variable name="text_reminder_msg">전자 메일 미리 알림을 통해 텍스트 메시지를 보낼 수 있습니다.</xsl:variable>

<xsl:variable name="message_title">메시지</xsl:variable>

<xsl:variable name="title_title">제목</xsl:variable>

<xsl:variable name="attendees_title">참석자</xsl:variable>

<!-- Adding variable to avoid syntax error - Satya -->
<xsl:variable name="delete_text">삭제하겠습니까?</xsl:variable>

<!-- new_group.xsl -->
<xsl:variable name="edit_group_page_title">달력 그룹 편집: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="quick_add_title">---빠른 추가---</xsl:variable>

<xsl:variable name="delete_calendar_text">이 달력을 제거하겠습니까?</xsl:variable>

<xsl:variable name="group_name_title">그룹 이름</xsl:variable>

<xsl:variable name="group_view_msg">일 보기에서 그룹 열기(기본적으로 그룹은 비교 보기에서 열림)</xsl:variable>

<xsl:variable name="calendar_id_title">달력 아이디</xsl:variable>

<xsl:variable name="add_title">추가</xsl:variable>

<xsl:variable name="cal_add_instructions_msg">(달력 아이디를 입력하십시오. 아이디를 모르는 경우 검색을 누르십시오.)</xsl:variable>

<xsl:variable name="group_members_title">그룹 구성원</xsl:variable>

<xsl:variable name="group_description_msg">여기에 그룹에 대한 설명을 입력하십시오. 이 그룹의 일 보기에 각 달력을 개별적으로 표시할지 여부를 결정할 수도 있습니다.</xsl:variable>

<xsl:variable name="day_view_title">일 보기</xsl:variable>

<xsl:variable name="day_view_merge_msg">기본적으로 일 보기에서는 달력이 병합되지 않은 상태로 표시됩니다.</xsl:variable>

<xsl:variable name="alert_group_name">그룹 이름을 지정해야 합니다.</xsl:variable>

<xsl:variable name="calendar_group_title">달력 그룹</xsl:variable>

<xsl:variable name="details_title">세부 정보</xsl:variable>

<!-- more new_task.xsl -->
<xsl:variable name="delete_task_text">이 태스크를 삭제하겠습니까?</xsl:variable>

<xsl:variable name="edit_task_page_title">태스크 편집: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="compose_task_title">작업 구성</xsl:variable>

<xsl:variable name="task_title_title">작업 제목</xsl:variable>

<xsl:variable name="due_date_title">기한</xsl:variable>

<xsl:variable name="no_time_title">시간 제한 없음</xsl:variable>

<xsl:variable name="public_task_title">공개 작업</xsl:variable>

<xsl:variable name="confidential_task_title">시간 및 날짜만</xsl:variable>

<xsl:variable name="private_task_title">개인 작업</xsl:variable>

<xsl:variable name="status_title">상태</xsl:variable>

<xsl:variable name="complete_title">완료</xsl:variable>

<xsl:variable name="task_reminder_msg">이 태스크에 대한 미리 알림을 전자 메일로 자신에게 보낼 수 있습니다. 하나 이상의 본인의 전자 메일 주소를 아래에 입력하십시오. 쉼표(,) 또는 세미콜론(;)을 사용하여 각 전자 메일 주소를 구분하십시오.</xsl:variable>

<xsl:variable name="alert_remind_task_must_be_due">기한이 없는 작업에 대한 경보를 설정할 수 없습니다.</xsl:variable>

<xsl:variable name="before_the_task_is_due_text">태스크 기한 전</xsl:variable>

<!-- options.xsl -->

<xsl:variable name="appearance_title">모양</xsl:variable>

<xsl:variable name="settings_title">설정</xsl:variable>

<xsl:variable name="import_title">가져오기</xsl:variable>

<xsl:variable name="export_title">내보내기</xsl:variable>

<xsl:variable name="settings_msg">이 양식을 사용하여 Calendar Express의 동작을 수정할 수 있습니다.</xsl:variable>

<xsl:variable name="default_view_title">기본 초기화 보기</xsl:variable>

<xsl:variable name="default_view_msg">로그인 후 항상 다음 보기를 표시:</xsl:variable>

<xsl:variable name="default_group_title">기본 달력 그룹</xsl:variable>

<xsl:variable name="default_group_msg">로그인 후 항상 다음 달력 그룹을 표시:</xsl:variable>

<xsl:variable name="no_cal_group_title">달력 그룹 없음</xsl:variable>

<xsl:variable name="date_format_msg">다음 순서로 날짜를 간단하게 표시:</xsl:variable>

<xsl:variable name="m_d_y_format_text">월, 일, 년</xsl:variable>

<xsl:variable name="d_m_y_format_text">일, 월, 년</xsl:variable>

<xsl:variable name="y_m_d_format_text">년, 월, 일</xsl:variable>

<xsl:variable name="date_delimiter_msg">다음 문자를 날짜 분리자로 사용:</xsl:variable>

<xsl:variable name="use_12_clock_msg">12시간제 사용</xsl:variable>

<xsl:variable name="use_24_clock_msg">24시간제 사용</xsl:variable>

<xsl:variable name="day_title">날짜</xsl:variable>

<xsl:variable name="day_starts_msg">시작 날짜:</xsl:variable>

<xsl:variable name="day_ends_msg">종료 날짜:</xsl:variable>

<xsl:variable name="day_interval_msg">시간 간격</xsl:variable>

<xsl:variable name="every_15_minutes_text">15분마다</xsl:variable>

<xsl:variable name="every_half_hour_text">30분마다</xsl:variable>

<xsl:variable name="every_hour_text">1시간마다</xsl:variable>

<xsl:variable name="every_2_hours_text">2시간마다</xsl:variable>

<xsl:variable name="every_four_hours_text">4시간마다</xsl:variable>

<xsl:variable name="first_dow_title">한 주의 첫날</xsl:variable>

<xsl:variable name="sunday_title">일요일</xsl:variable>

<xsl:variable name="monday_title">월요일</xsl:variable>

<xsl:variable name="tuesday_title">화요일</xsl:variable>

<xsl:variable name="wednesday_title">수요일</xsl:variable>

<xsl:variable name="thursday_title">목요일</xsl:variable>

<xsl:variable name="friday_title">금요일</xsl:variable>

<xsl:variable name="saturday_title">토요일</xsl:variable>

<xsl:variable name="exclude_sat_sun_msg">주 보기 및 월 보기에서 토요일과 일요일 제외</xsl:variable>

<xsl:variable name="default_tz_msg">기본적으로 다음 표준 시간대를 사용하여 날짜와 시간 표시:</xsl:variable>

<xsl:variable name="none_selected_title">선택 항목 없음</xsl:variable>

<xsl:variable name="single_tz_use_msg">단일 달력을 표시할 때 해당 표준 시간대 사용</xsl:variable>

<xsl:variable name="tz_timescales_msg">표시된 각 달력 표준 시간대에 대한 시간 단위 표시</xsl:variable>

<xsl:variable name="event_task_reminders_title">이벤트 &amp; 작업 미리 알림</xsl:variable>

<xsl:variable name="email_reminder_msg">전자 우편으로 미리 알림</xsl:variable>

<xsl:variable name="alert_valid_reminder_interval">미리 알림에 대한 유효한 시간 간격을 입력하십시오.</xsl:variable>

<xsl:variable name="before_every_event_task_text">각 이벤트 및 작업 전</xsl:variable>

<xsl:variable name="note_title">주:</xsl:variable>

<xsl:variable name="reminders_tip_msg">여러 전자 메일 주소(예: abc@company22.com, abc@sesta.com)로 미리 알림을 보내는 경우 쉼표(,) 또는 세미콜론(;)을 사용하여 전자 메일 주소를 구분하십시오.</xsl:variable>

<xsl:variable name="event_notifications_title">이벤트 알림</xsl:variable>

<xsl:variable name="event_notifications_msg">다른 사용자가 내 달력에 대해 이벤트를 예약할 때마다 알림 메시지를 전자 우편으로 받습니다.</xsl:variable>

<xsl:variable name="only_one_email_msg">하나의 전자 메일 주소만 허용됩니다.</xsl:variable>

<xsl:variable name="alert_only_one_email">이벤트 알림 메시지를 받을 주소를 하나만 입력하십시오.</xsl:variable>

<xsl:variable name="declined_events_delete_title">거절한 이벤트</xsl:variable>

<xsl:variable name="declined_events_delete_msg">거절한 이벤트를 표시하지 않습니다.</xsl:variable>

<xsl:variable name="appearance_msg">이 양식을 사용하여 Calendar Express의 모양을 수정합니다.</xsl:variable>

<xsl:variable name="color_scheme_title">색 구성표</xsl:variable>

<xsl:variable name="toolbar_title">도구 모음</xsl:variable>

<xsl:variable name="icons_and_text_msg">아이콘 및 텍스트 표시</xsl:variable>

<xsl:variable name="icons_only_msg">아이콘만 표시</xsl:variable>

<xsl:variable name="text_only_msg">텍스트만 표시</xsl:variable>

<xsl:variable name="display_font_title">표시 글꼴</xsl:variable>

<xsl:variable name="face_title">글꼴 이름</xsl:variable>

<xsl:variable name="sans_serif_title">Sans Serif</xsl:variable>

<xsl:variable name="serif_title">Serif</xsl:variable>

<xsl:variable name="mono_title">Mono</xsl:variable>

<xsl:variable name="size_title">글꼴 크기</xsl:variable>

<xsl:variable name="larger_title">큰 글꼴</xsl:variable>

<xsl:variable name="default_title">보통 크기</xsl:variable>

<xsl:variable name="smaller_title">작은 글꼴</xsl:variable>

<xsl:variable name="event_destination_title">이벤트 대상</xsl:variable>

<xsl:variable name="session_expired_msg">세션이 만료되었습니다.</xsl:variable>

<xsl:variable name="need_valid_calendar_msg">유효한 달력을 지정해야 합니다.</xsl:variable>

<xsl:variable name="add_events_to_text">이벤트를 추가할 대상</xsl:variable>

<xsl:variable name="select_calendar_title">달력 선택:</xsl:variable>

<xsl:variable name="import_format_title">가져오기 형식</xsl:variable>

<xsl:variable name="ical_title">iCal</xsl:variable>

<xsl:variable name="xml_title">xml</xsl:variable>

<xsl:variable name="outlook_title">Outlook 형식</xsl:variable>

<xsl:variable name="source_file_invalid_error">지정된 소스 파일이 유효하지 않습니다.</xsl:variable>

<xsl:variable name="format_file_mismatch_error">지정된 형식이 소스 파일과 일치하지 않습니다.</xsl:variable>

<xsl:variable name="successful_import_msg">파일을 성공적으로 가져왔습니다.</xsl:variable>

<xsl:variable name="source_file_title">소스 파일</xsl:variable>

<xsl:variable name="date_range_title">날짜 범위</xsl:variable>

<xsl:variable name="import_all_msg">파일에서 모든 이벤트 가져오기</xsl:variable>

<xsl:variable name="invalid_date_range_error">지정한 날짜 범위가 유효하지 않습니다.</xsl:variable>

<xsl:variable name="beginning_title">시작</xsl:variable>

<xsl:variable name="ending_title">종료</xsl:variable>

<xsl:variable name="calendars_to_export_title">내보낼 달력</xsl:variable>

<xsl:variable name="addarrow_title">추가(A) >></xsl:variable>

<xsl:variable name="export_all_msg">모든 이벤트 내보내기</xsl:variable>

<xsl:variable name="export_format_title">내보내기 형식</xsl:variable>

<xsl:variable name="need_valid_end_start_msg">날짜 종료 시간은 날짜 시작 시간 이후여야 합니다.</xsl:variable>

<xsl:variable name="save_changes_title">변경 내용 저장</xsl:variable>

<!-- printview.xsl -->
<xsl:variable name="current_calendar_title">현재 달력:</xsl:variable>

<!-- recurrence.xsl -->
<xsl:variable name="repeat_pattern_title">반복 패턴</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_title">유효하지 않은 반복 패턴: 반복할 날짜 선택</xsl:variable>

<xsl:variable name="invalid_repeat_pattern_change">반복 패턴은 인스턴스에 대해 변경될 수 없습니다.</xsl:variable>

<xsl:variable name="recurrence_skips_title">반복 이벤트의 한 인스턴스가 다른 인스턴스를 건너뛸 수 없습니다.</xsl:variable>

<xsl:variable name="recurrence_same_day">반복 이벤트의 두 인스턴스가 같은 날 발생할 수 없습니다.</xsl:variable>

<xsl:variable name="recurrence_privacy">한 인스턴스만 개인 정보를 변경할 수 없습니다.</xsl:variable>

<xsl:variable name="every_day_title">매일</xsl:variable>

<xsl:variable name="every_weekday_title">매주 평일</xsl:variable>

<xsl:variable name="every_title">매번</xsl:variable>

<xsl:variable name="weekday_text">평일</xsl:variable>

<xsl:variable name="weekendday_text">주말</xsl:variable>

<xsl:variable name="m_w_f_text">월요일, 수요일 및 금요일</xsl:variable>

<xsl:variable name="t_th_text">화요일 및 목요일</xsl:variable>

<xsl:variable name="sat_sun_text">토요일 및 일요일</xsl:variable>

<xsl:variable name="alert_valid_repeat_interval">유효한 간격을 입력하십시오.</xsl:variable>

<xsl:variable name="every_week_title">매주</xsl:variable>

<xsl:variable name="weeks_text">주</xsl:variable>

<xsl:variable name="repeat_on_title">다음 날짜에 반복</xsl:variable>

<xsl:variable name="sunday_abbrev">일</xsl:variable>

<xsl:variable name="monday_abbrev">월</xsl:variable>

<xsl:variable name="tuesday_abbrev">화</xsl:variable>

<xsl:variable name="wednesday_abbrev">수</xsl:variable>

<xsl:variable name="thursday_abbrev">목</xsl:variable>

<xsl:variable name="friday_abbrev">금</xsl:variable>

<xsl:variable name="saturday_abbrev">토</xsl:variable>

<xsl:variable name="every_month_title">매월</xsl:variable>

<xsl:variable name="months_text">개월</xsl:variable>

<xsl:variable name="ordinal_1">1일</xsl:variable>
<xsl:variable name="ordinal_2">2일</xsl:variable>
<xsl:variable name="ordinal_3">3일</xsl:variable>
<xsl:variable name="ordinal_4">4일</xsl:variable>
<xsl:variable name="ordinal_5">5일</xsl:variable>
<xsl:variable name="ordinal_6">6일</xsl:variable>
<xsl:variable name="ordinal_7">7일</xsl:variable>
<xsl:variable name="ordinal_8">8일</xsl:variable>
<xsl:variable name="ordinal_9">9일</xsl:variable>
<xsl:variable name="ordinal_10">10일</xsl:variable>
<xsl:variable name="ordinal_11">11일</xsl:variable>
<xsl:variable name="ordinal_12">12일</xsl:variable>
<xsl:variable name="ordinal_13">13일</xsl:variable>
<xsl:variable name="ordinal_14">14일</xsl:variable>
<xsl:variable name="ordinal_15">15일</xsl:variable>
<xsl:variable name="ordinal_16">16일</xsl:variable>
<xsl:variable name="ordinal_17">17일</xsl:variable>
<xsl:variable name="ordinal_18">18일</xsl:variable>
<xsl:variable name="ordinal_19">19일</xsl:variable>
<xsl:variable name="ordinal_20">20일</xsl:variable>
<xsl:variable name="ordinal_21">21일</xsl:variable>
<xsl:variable name="ordinal_22">22일</xsl:variable>
<xsl:variable name="ordinal_23">23일</xsl:variable>
<xsl:variable name="ordinal_24">24일</xsl:variable>
<xsl:variable name="ordinal_25">25일</xsl:variable>
<xsl:variable name="ordinal_26">26일</xsl:variable>
<xsl:variable name="ordinal_27">27일</xsl:variable>
<xsl:variable name="ordinal_28">28일</xsl:variable>
<xsl:variable name="ordinal_29">29일</xsl:variable>
<xsl:variable name="ordinal_30">30일</xsl:variable>
<xsl:variable name="ordinal_31">31일</xsl:variable>

<xsl:variable name="ordinal2_1">첫 번째</xsl:variable>
<xsl:variable name="ordinal2_2">두 번째</xsl:variable>
<xsl:variable name="ordinal2_3">세 번째</xsl:variable>
<xsl:variable name="ordinal2_4">네 번째</xsl:variable>

<xsl:variable name="day_of_month_text">일</xsl:variable>
<xsl:variable name="cap_last_text">월의 마지막 날짜</xsl:variable>
<!-- <xsl:variable name="cap_last_text">마지막 거래가</xsl:variable> -->


<xsl:variable name="of_month_text">달</xsl:variable>

<xsl:variable name="every_year_text">매년</xsl:variable>

<xsl:variable name="years_text">년</xsl:variable>

<!-- repeating_event_delete.xsl -->
<xsl:variable name="repeating_event_delete_msg">반복되는 이벤트입니다. 이 이벤트만 삭제하거나 모든 이벤트를 삭제하겠습니까?</xsl:variable>

<!-- repeating_event_store.xsl -->
<xsl:variable name="repeating_event_store_msg">반복되는 이벤트입니다. 변경 사항을 이 이벤트에만 적용하거나 모든 이벤트에 적용하겠습니까?</xsl:variable>

<!-- repeating_task_delete.xsl -->
<xsl:variable name="repeating_task_delete_msg">반복되는 태스크입니다. 이 태스크만 삭제하거나 모든 태스크를 삭제하겠습니까?</xsl:variable>

<!-- repeating_task_store.xsl -->
<xsl:variable name="repeating_task_store_msg">반복되는 태스크입니다. 변경 사항을 이 태스크에만 적용하거나 모든 태스크에게 적용하겠습니까?</xsl:variable>

<!-- reply_event.xsl -->
<xsl:variable name="summary_title">요약</xsl:variable>

<xsl:variable name="reply_title">응답</xsl:variable>

<xsl:variable name="will_attend_msg">참석함</xsl:variable>

<xsl:variable name="will_not_attend_msg">참석 안 함</xsl:variable>

<xsl:variable name="confirm_later_msg">나중에 확인</xsl:variable>

<xsl:variable name="reply_reminders_msg">여기서 쉼표 또는 세미콜론으로 구분된 전자 메일 주소를 입력하고 전달 날짜와 시간을 선택하여 전자 메일 미리 알림을 예약합니다.</xsl:variable>

<xsl:variable name="alert_remind_unconfirmed_event">이벤트가 시작되기 전에 확인되지 않은 이벤트에 대한 경보를 설정할 수 없습니다.</xsl:variable>

<xsl:variable name="reply_remind_tips_msg">다음 빈 칸을 사용하여 미리 알림의 추가 정보를 제공합니다. 이벤트의 제목, 날짜, 시간 및 위치가 모든 미리 알림에 자동으로 포함됩니다.</xsl:variable>

<xsl:variable name="cal_select_msg">이벤트를 저장할 달력을 선택하십시오.</xsl:variable>

<!-- search_for_calendars_common.xsl -->
<xsl:variable name="calendars_search_page_title">달력 검색: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="calendars_search_title">달력 검색</xsl:variable>

<xsl:variable name="cal_search_msg1">달력 위치 검색</xsl:variable>
        
<xsl:variable name="name_or_id_text">이름 또는 아이디</xsl:variable>

<xsl:variable name="name_text">이름</xsl:variable>

<xsl:variable name="primary_owner_text">주 소유자</xsl:variable>

<xsl:variable name="id_text">ID</xsl:variable>

<xsl:variable name="contains_text">다음 포함</xsl:variable>

<xsl:variable name="begins_with_text">시작 문자</xsl:variable>

<xsl:variable name="search_plain_title">검색</xsl:variable>

<xsl:variable name="already_selected_cals_title">이미 선택한 달력</xsl:variable>

<xsl:variable name="cal_id_title">달력 아이디</xsl:variable>

<xsl:variable name="search_results_title">검색 결과</xsl:variable>

<xsl:variable name="no_match_found_msg">일치하는 항목 없음</xsl:variable>

<xsl:variable name="owner_title">소유자</xsl:variable>

<xsl:variable name="owner_name_colon_title">소유자 이름:</xsl:variable>

<xsl:variable name="cal_name_title">달력 이름</xsl:variable>

<!-- search_for_components.xsl -->
<xsl:variable name="search_components_page_title">검색: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="search_components_msg">다음을 포함하는 이벤트 및 작업 검색</xsl:variable>

<!-- search_for_users_common.xsl -->
<xsl:variable name="user_search_page_title">사용자 검색: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="user_search_title">사용자 검색</xsl:variable>

<xsl:variable name="search_local_msg">로컬 디렉토리 검색</xsl:variable>

<xsl:variable name="search_user_instruct_msg">(성, 이름 또는 사용자 아이디 입력)</xsl:variable>

<xsl:variable name="legend_title">범례:</xsl:variable>

<xsl:variable name="resource_title">자원;</xsl:variable>

<xsl:variable name="already_selected_users_title">이미 선택한 사용자</xsl:variable>

<xsl:variable name="name_userid_title">이름(사용자 아이디)</xsl:variable>

<xsl:variable name="name_title">이름</xsl:variable>

<xsl:variable name="userid_title">아이디</xsl:variable>

<xsl:variable name="email_title">전자 우편</xsl:variable>

<xsl:variable name="for_text">동안</xsl:variable>

<!-- task_list.xsl -->
<xsl:variable name="task_list_page_title">태스크 목록: Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="task_list_msg">이 패널을 사용하여 모든 할 일을 추적할 수 있습니다. "완료" 열의 확인란을 눌러 완료된 태스크를 표시할 수 있습니다. "저장 및 닫기"를 눌러 변경 사항을 완결합니다.</xsl:variable>

<xsl:variable name="done_title">완료</xsl:variable>

<xsl:variable name="task_title">작업</xsl:variable>

<xsl:variable name="select_all_title">모두 선택</xsl:variable>

<xsl:variable name="alert_processing">진행 중</xsl:variable>

<!-- task_recurrence.xsl -->
<xsl:variable name="tasks_text">작업</xsl:variable>

<!-- toolbar.xsl -->
<xsl:variable name="cal_name">Sun Java[tm] System Calendar Express</xsl:variable>

<xsl:variable name="help_text">도움말</xsl:variable>

<xsl:variable name="logout_text">로그아웃</xsl:variable>

<xsl:variable name="login_text">로그인</xsl:variable>

<xsl:variable name="home_text">홈</xsl:variable>

<xsl:variable name="alt_schedule_msg">회의, 생일 또는 다른 이벤트 예약</xsl:variable>

<xsl:variable name="new_event_title">새 이벤트</xsl:variable>

<xsl:variable name="alt_todo_msg">수행할 작업 목록에 항목 추가</xsl:variable>

<xsl:variable name="new_task_title">새 작업</xsl:variable>

<xsl:variable name="jump_to_title">이동</xsl:variable>

<xsl:variable name="alt_print_msg">인쇄에 적합한 현재 보기의 버전 열기</xsl:variable>

<xsl:variable name="printable_title">인쇄 가능</xsl:variable>

<xsl:variable name="alt_search_msg">이벤트 및 작업 검색</xsl:variable>

<xsl:variable name="alt_new_calendar">새 달력 만들기</xsl:variable>

<xsl:variable name="new_cal_title">새 달력</xsl:variable>

<xsl:variable name="alt_new_group">달력의 새 그룹 만들기</xsl:variable>

<xsl:variable name="new_group_title">새 그룹</xsl:variable>

<xsl:variable name="alt_search_cals">달력 검색</xsl:variable>

<xsl:variable name="subscribe_title">가입</xsl:variable>

<xsl:variable name="paren_subscribed_title">(가입)</xsl:variable>

<xsl:variable name="alt_jump_next_week">다음 주로 이동</xsl:variable>

<xsl:variable name="alt_jump_prev_week">이전 주로 이동</xsl:variable>

<xsl:variable name="sunday_letter_title">일</xsl:variable>
<xsl:variable name="monday_letter_title">월</xsl:variable>
<xsl:variable name="tuesday_letter_title">화</xsl:variable>
<xsl:variable name="wednesday_letter_title">수</xsl:variable>
<xsl:variable name="thursday_letter_title">화</xsl:variable>
<xsl:variable name="friday_letter_title">금</xsl:variable>
<xsl:variable name="saturday_letter_title">일</xsl:variable>

<!-- errors_list.xsl -->
<xsl:variable name="errors_delete_confirm">선택한 이벤트가 달력에서 제거됩니다. 반복 이벤트인 경우에는 오류가 있는 인스턴스만 제거됩니다. 계속하려면 확인을 누르십시오.</xsl:variable>

<!-- for new ability to invite all members of group -->
<xsl:variable name="invite_group_msg">달력 그룹을 표시한 상태에서 이벤트를 만드는 경우 해당 그룹의 모든 달력을 초대합니다.</xsl:variable>

<xsl:variable name="invite_this_group_msg">이 달력 그룹을 표시한 상태에서 이벤트를 만드는 경우 해당 그룹의 모든 달력을 초대합니다.</xsl:variable>

<xsl:variable name="group_invitations_title">그룹 초대</xsl:variable>

<xsl:variable name="starting_at_txt">시작 시간</xsl:variable>

<!-- missed from availability.xsl -->
<xsl:variable name="unknown_text">알 수 없음</xsl:variable>

<!-- missed from common.xsl -->
<xsl:variable name="no_attendees_title">참석자 없음</xsl:variable>

<xsl:variable name="today_title">오늘</xsl:variable>

<xsl:variable name="confirm_event_delete_text">이 이벤트를 삭제하겠습니까?</xsl:variable>
<xsl:variable name="confirm_task_delete_text">이 태스크를 삭제하겠습니까?</xsl:variable>

<!-- dwp errors -->
<xsl:variable name="dwp_unable_to_connect_error">백엔드 데이터베이스에 연결하지 못했습니다.</xsl:variable>
<xsl:variable name="dwp_max_connections_error">백엔드 데이터베이스에 대한 최대 연결 수에 도달했습니다.</xsl:variable>
<xsl:variable name="dwp_bad_data_fetch_error">연결할 수 없는 잘못된 데이터 백엔드 데이터베이스입니다.</xsl:variable>
<xsl:variable name="dwp_unable_to_resolve_error">달력을 확인할 수 없습니다.</xsl:variable>
<xsl:variable name="dwp_down_error">다운되었습니다.</xsl:variable>
<xsl:variable name="dwp_host_ctx_error">DWP 호스트 컨텍스트를 사용할 수 없습니다.</xsl:variable>
<xsl:variable name="dwp_host_not_resolvable_error">확인할 수 없는 백엔드 호스트입니다.</xsl:variable>                     
<xsl:variable name="dwp_no_data_fetch_error">데이터 없음 - 연결할 수 없는 백엔드 데이터베이스입니다.</xsl:variable>

<xsl:variable name="semi_divider">;</xsl:variable>
<xsl:variable name="open_paren">(</xsl:variable>
<xsl:variable name="close_paren">)</xsl:variable>
<xsl:variable name="event_in_freebusy_msg">가용성 계산 시 이 이벤트를 포함합니다.</xsl:variable>
<xsl:variable name="freebusy_title">사용 가능/사용 중</xsl:variable>

<xsl:variable name="confirm_alldayevent_opaque">일정을 나타내는 All Day 이벤트를 설정하고 있습니다. 잘못된 경우, 취소 버튼을 누른 후 되돌아 가서 Free/Busy란의 표시를 취소하십시오.</xsl:variable>

<xsl:variable name="confirm_privateevent_opaque">가용성을 계산하는 데 사용될 개인 이벤트를 만듭니다. 잘못된 경우에는 취소를 눌러 되돌아가서 사용 가능/사용 중 확인란의 선택을 취소하십시오.</xsl:variable>

<!-- JES3 additions -->
<xsl:variable name="readonly_db">읽기 전용 모드 달력 데이터베이스입니다.</xsl:variable>
<!-- end JES3 additions -->
<!-- You must keep these labels variables BEGIN and variables END in this file -->
<!-- These labels are used by xslvarparser.pl to merge the variable values into the xsl templates -->
<!-- Variables and its values must be declared in one line.   If you have a multiline value for a variables, then dont include -->
<!-- them in this segment of the file. -->
<!-- PARSE_VARIABLES_END -->

<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">종료 날짜 없음 </xsl:variable>
<xsl:variable name="cap_the_text">더 </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 제거</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="((string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>환영합니다.  </xsl:text>
    <xsl:choose>
    <xsl:when test="(string-length(/calendar/usrctx/user/@lastName) > 0) and (string-length(/calendar/usrctx/user/@firstName) > 0)">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>의 달력에 대한 </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>태스크(</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>시작 시간 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1시간</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 분</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>2시간 이상</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> 사용 가능)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 최대 수의 인스턴스 </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 만들기</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>특정 지역의 하나 이상의 표준 시간대가 현재 달력과 연결될 수 있습니다. 일 보기와 같이 눈금이 표시된 보기에서, 달력과 연결된 모든 표준 시간대는 보기의 시간 단위의 일부가 됩니다. 이 달력에 지정한 표준 시간대가 없는 경우에는 기본 표준 시간대가 사용됩니다. 다음 표준 시간대가 사용 가능합니다. </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>특정 지역의 한 표준 시간대가 현재 달력과 연결될 수 있습니다. 일 보기와 같이 눈금이 표시된 보기에서, 달력과 연결된 표준 시간대는 보기의 시간 단위의 일부가 됩니다. 이 달력에 지정한 표준 시간대가 없는 경우에는 기본 표준 시간대가 사용됩니다. 다음 표준 시간대가 사용 가능합니다. </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>북아메리카/남아메리카 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>유럽/아프리카 </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>아시아/태평양 연안 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>지역:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>다음 이벤트가 달력에 추가되었습니다. "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>" 아래의 회신에 대한 해당 옵션을 선택하여 이 초대를 받아들이거나 거절할 수 있습니다.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>파일을 선택하려면</xsl:text>&nbsp;
  <B><xsl:text>찾아보기...</xsl:text></B>&nbsp;
  <xsl:text>누릅니다.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>이 패널을 사용하여 이벤트에 대한 초대를 받아들이거나 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> 거절하거나 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> 미정 상태 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> 이벤트에 대한 초대</xsl:text>
  <br/>
  <xsl:text>반복 이벤트의 경우 설정이 전체 시퀀스에 적용됩니다.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>검색 결과는 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 자 미만의 문자로 검색한 결과는 완료되지 않을 수 있습니다. 보다 나은 결과를 얻으려면 적어도 </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 자 이하입니다.</xsl:text>

</xsl:template>


</xsl:stylesheet>
