<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
    <TITLE>날짜로 이동: Sun Java[tm] System Calendar Express</TITLE>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    </HEAD>
    <FRAMESET border="0" frameborder="1" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" marginheight="9" marginwidth="9" src="{$Frame2}"/>
      <FRAME name="button" marginheight="1" marginwidth="1" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="main_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (jump_to.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="monthBoxbold">
  <xsl:param name="Month"/>

  <TD align="center">
   <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_selected"/></xsl:attribute>
   <B>
   <FONT face="$font_name" size="{$font_size_big}" color="#000000">
   <xsl:text>&nbsp;</xsl:text>
   <xsl:call-template name="monthName">
      <xsl:with-param name="MonthNum" select="$Month"/>
   </xsl:call-template>
   <xsl:text>&nbsp;</xsl:text>
   </FONT>
   </B>
  </TD>

</xsl:template>

<xsl:template name="monthBoxlink">
  <xsl:param name="Month"/>

  <TD align="center">
   <xsl:variable name="minicalcommand"><xsl:value-of select="minical/command[@month = $Month]"/></xsl:variable>
   <A href="{$minicalcommand}" style="text-decoration:none;">
   <FONT face="$font_name" size="{$font_size_big}" color="#FFFFFF">
   <xsl:text>&nbsp;</xsl:text>
   <xsl:call-template name="monthName">
      <xsl:with-param name="MonthNum" select="$Month"/>
   </xsl:call-template>
   <xsl:text>&nbsp;</xsl:text>
   </FONT>
   </A>
  </TD>

</xsl:template>

<xsl:template name="monthBox">
  <xsl:param name="Month"/>

    <xsl:choose>
      <xsl:when test="(./timectx/StartTime/@month=$Month) or (./timectx/StartTime/@month=concat('0',$Month))">
       <xsl:call-template name="monthBoxbold"><xsl:with-param name="Month" select="$Month"/></xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="monthBoxlink"><xsl:with-param name="Month" select="$Month"/></xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

</xsl:template>

<xsl:template name="main_root">
  <HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

  <BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
  <xsl:attribute name="onload">
     window.focus();
     document.forms[0].mm.focus();
 </xsl:attribute>

  <FORM name="form" method="post">
    <CENTER><TABLE border="0" cellpadding="1" cellspacing="0"><TR>

<!-- The list of months -->
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="2" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">1</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">2</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">3</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">4</xsl:with-param></xsl:call-template>
      </TR>
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">5</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">6</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">7</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">8</xsl:with-param></xsl:call-template>
      </TR>
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">9</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">10</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">11</xsl:with-param></xsl:call-template>
        <xsl:call-template name="monthBox"><xsl:with-param name="Month">12</xsl:with-param></xsl:call-template>
      </TR>
    </TABLE></TD></TR><TR>    

<!-- The calendar portion -->
    <TD bgcolor="{$bgcolor_table_border}"><TABLE width="100%" border="0" cellpadding="2" cellspacing="1">
      <TR>
        <xsl:for-each select="minical/Row[1]/Time">
          <TD align="center">
            <xsl:attribute name="bgcolor">
              <xsl:choose>
                <xsl:when test="(@dow=1) or (@dow=7)"><xsl:value-of select="$bgcolor_wend_top"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$bgcolor_table_top"/></xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
              <xsl:call-template name="short_dow">
                <xsl:with-param name="downum" select="@dow"/>
              </xsl:call-template>
            </FONT>
          </TD>
       </xsl:for-each>
      </TR>
      <xsl:for-each select="minical/Row">
      <TR>
        <xsl:for-each select="Time">
          <TD align="right">
            <xsl:choose>
              <xsl:when test="../../../timectx/SelectedTime/@month!=@month">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_table_border"/></xsl:attribute>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}"><xsl:value-of select="@date"/></FONT></A>
              </xsl:when>
              <xsl:when test="../../../timectx/SelectedTime/@date=@date">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_selected"/></xsl:attribute>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute><FONT face="{$font_name}" size="{$font_size_big}" color="#000000"><B><xsl:value-of select="@date"/></B></FONT></A>
              </xsl:when>
              <xsl:when test="(@dow=1) or (@dow=7)">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:attribute>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/></FONT></A></xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor"><xsl:value-of select="$bgcolor_table_mid"/></xsl:attribute>
                <A style="text-decoration:none;"><xsl:attribute name="href"><xsl:value-of select="command"/></xsl:attribute><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="@date"/></FONT></A></xsl:otherwise>
            </xsl:choose>
          </TD>
        </xsl:for-each>
      </TR>
      </xsl:for-each>
    </TABLE></TD>
  </TR>
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="2" cellspacing="1">
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
          <A>
            <xsl:attribute name="href"><xsl:value-of select="minical/command[1]"/></xsl:attribute>
            <IMG src="imx/prev_month.gif" width="11" height="11" border="0" alt="이전 연도로 이동" align="left"/>
          </A>
          <A>
            <xsl:attribute name="href"><xsl:value-of select="minical/command[2]"/></xsl:attribute>
            <IMG src="imx/next_month.gif" width="11" height="11" border="0" alt="다음 연도로 이동" align="right"/>
          </A>
          <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
            <xsl:value-of select="./timectx/StartTime/@year"/>
          </FONT>
        </TD>
      </TR>
    </TABLE>
    </TD></TR></TABLE>
  
  <BR/>
  <NOBR>
   <xsl:choose>
    <xsl:when test="(./timectx/CurrTime/@year = ./timectx/StartTime/@year) and (./timectx/CurrTime/@month = ./timectx/StartTime/@month) and (./timectx/CurrTime/@date = ./timectx/StartTime/@date) ">
      <xsl:call-template  name="date_selector">
       <xsl:with-param name="month"/>
        <xsl:with-param name="day"/>
        <xsl:with-param name="year"/>
        <xsl:with-param name="checkFunction" select="'allowEmptyDateCheck'" />     
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="date_selector">
        <xsl:with-param name="month" select="./timectx/StartTime/@month"/>
        <xsl:with-param name="day" select="./timectx/StartTime/@date"/>
        <xsl:with-param name="year" select="./timectx/StartTime/@year"/>  
      </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </NOBR>


  </CENTER>
  </FORM></BODY>
  </HTML>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">날짜로 이동</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="jump_to_javascript"/> -->
  <SCRIPT SRC="js_jump_to.js">alert('NOTFOUND!');</SCRIPT>
<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="3" cellspacing="1">
  <TR>
    <TD align="center" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="today" value="확인" width="72">
          <xsl:attribute name="onClick">
                if (parent.date_error == '1') {
                    parent.date_error = '0';
                    return;
                } 
                jumpto_return_to_main_window();
           </xsl:attribute>
        </INPUT>
        <INPUT type="button" name="esc" value="취소" onClick="parent.close();" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
