<?xml version="1.0" encoding="UTF-8" ?>

<!-- <!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&amp;nbsp;">]> -->
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- However it is good for the text strings to be variables as defined in i18n.xsl -->
<!-- That way, for languages with similar layout format, this file will not need translation -->

<xsl:template name="min_short">
  <xsl:param name="hsMin"/>
      <xsl:value-of select="$hsMin"/>
</xsl:template>

<!-- simply print out the hour (13 or 1) according to the ceClock -->
<xsl:template name="hour_short">
  <xsl:param name="hsHour"/>
  <xsl:choose>
    <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">
      <xsl:value-of select="$hsHour"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="$hsHour = 0">12</xsl:when>
        <xsl:when test="$hsHour = 1">1</xsl:when>
        <xsl:when test="$hsHour = 2">2</xsl:when>
        <xsl:when test="$hsHour = 3">3</xsl:when>
        <xsl:when test="$hsHour = 4">4</xsl:when>
        <xsl:when test="$hsHour = 5">5</xsl:when>
        <xsl:when test="$hsHour = 6">6</xsl:when>
        <xsl:when test="$hsHour = 7">7</xsl:when>
        <xsl:when test="$hsHour = 8">8</xsl:when>
        <xsl:when test="$hsHour = 9">9</xsl:when>
        <xsl:when test="$hsHour =10">10</xsl:when>
        <xsl:when test="$hsHour =11">11</xsl:when>
        <xsl:when test="$hsHour =12">12</xsl:when>
        <xsl:when test="$hsHour =13">1</xsl:when>
        <xsl:when test="$hsHour =14">2</xsl:when>
        <xsl:when test="$hsHour =15">3</xsl:when>
        <xsl:when test="$hsHour =16">4</xsl:when>
        <xsl:when test="$hsHour =17">5</xsl:when>
        <xsl:when test="$hsHour =18">6</xsl:when>
        <xsl:when test="$hsHour =19">7</xsl:when>
        <xsl:when test="$hsHour =20">8</xsl:when>
        <xsl:when test="$hsHour =21">9</xsl:when>
        <xsl:when test="$hsHour =22">10</xsl:when>
        <xsl:when test="$hsHour =23">11</xsl:when>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--  print out 2 - separated hours according to ceClock -->
<!-- Ex: 13:29 - 14:34    or   1:29pm - 2:34 pm          -->
<xsl:template name="dur_short">
  <xsl:param name="date1"/>
  <xsl:param name="date2"/>

  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour">
      <xsl:apply-templates select="$date1/@hour"/>
    </xsl:with-param>
    <xsl:with-param name="ftMinute">
      <xsl:apply-templates select="$date1/@minute"/>
    </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour">
      <xsl:apply-templates select="$date2/@hour"/>
    </xsl:with-param>
    <xsl:with-param name="ftMinute">
      <xsl:apply-templates select="$date2/@minute"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- print out day of week and date                 -->
<!-- Ex: Wednesday 29                               -->
<xsl:template name="date_short">
  <xsl:param name="dateA"/>
<!-- l10n_ko -->
  <xsl:apply-templates select="$dateA/@date"/>
  <xsl:text>&nbsp;</xsl:text>
  일
  <xsl:apply-templates select="$dateA/@dow"/>
  <xsl:text> </xsl:text>
<!-- end_of_l10n_ko -->
</xsl:template>

<!-- print out day of week + full date and range     -->
<!-- Ex: Wednesday, 29 July, 2000 from 12:34 - 13:49 -->
<!-- korean: 2000 July 29 Wednesday 12:34 - 13:49 from -->
<xsl:template name="date_long">
  <xsl:param name="date_range"/>

<xsl:value-of select="$date_range/StartTime/@year"/>
년<xsl:text>&nbsp;</xsl:text>
  <xsl:choose>
    <xsl:when test="$dateorder = 'D/M/Y'">
      <xsl:value-of select="$date_range/StartTime/@date"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$date_range/StartTime/@date"/>
    </xsl:otherwise>
  </xsl:choose>
일<xsl:text>&nbsp;</xsl:text>
<xsl:apply-templates select="$date_range/StartTime/@dow"/>
<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="dur_short">
    <xsl:with-param name="date1" select="$date_range/StartTime"/>
    <xsl:with-param name="date2" select="$date_range/EndTime"/>
  </xsl:call-template>
<xsl:text>&nbsp;</xsl:text>
</xsl:template>

<!-- print out day of week + full date  -->
<!-- Ex: Wednesday, 29 July, 2000 -->
<xsl:template name="date_long_no_time">
  <xsl:param name="date_range"/>
  <xsl:value-of select="$date_range/StartTime/@year"/>
  년<xsl:text>&nbsp;</xsl:text>
  <xsl:choose>
    <xsl:when test="$dateorder = 'D/M/Y'">
      <xsl:value-of select="$date_range/StartTime/@date"/>
      일
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$date_range/StartTime/@month"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$date_range/StartTime/@date"/>
      일
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, </xsl:text>
  <xsl:apply-templates select="$date_range/StartTime/@dow"/>
</xsl:template>

<!-- print out date and time if dueTime=0 -->
<!-- Ex: July 29 at 1:34pm                -->
<xsl:template name="task_date_at_time">
  <xsl:param name="dateA"/>
  <xsl:param name="notime"/>

  <xsl:choose>
    <xsl:when test="$dateorder='D/M/Y'">
      <xsl:apply-templates select="$dateA/@date"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$dateA/@month"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="$dateA/@month"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$dateA/@date"/>
    일<xsl:text>&nbsp;</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="not($notime='1')">
    <xsl:call-template name="formatTime">
      <xsl:with-param name="ftHour">
        <xsl:apply-templates select="$dateA/@hour"/>
      </xsl:with-param>
      <xsl:with-param name="ftMinute">
        <xsl:apply-templates select="$dateA/@minute"/>
      </xsl:with-param>
    </xsl:call-template>
    시<xsl:text>&nbsp;</xsl:text> 
  </xsl:if>
</xsl:template>

<!-- print date like 29/07/2001 if year is present otherwise 29/07-->
<xsl:template name="brief_date">
  <xsl:param name="Month"/>
  <xsl:param name="Day"/>
  <xsl:param name="Year"/>

  <xsl:choose>
    <xsl:when test="$dateorder='M/D/Y'">
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:when>
    <xsl:when test="$dateorder='D/M/Y'">
      <xsl:value-of select="$Day"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Month"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:when>
    <xsl:when test="$dateorder='Y/M/D'">
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$Year"/>
        <xsl:value-of select="$dateseparator"/>
      </xsl:if>
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$Month"/>
      <xsl:value-of select="$dateseparator"/>
      <xsl:value-of select="$Day"/>
      <xsl:if test="string-length($Year) &gt; 0">
        <xsl:value-of select="$dateseparator"/>
        <xsl:value-of select="$Year"/>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- print today if today, date with year if not current year -->
<!-- otherwise date without year                              -->
<!-- Ex: Today   or    12/28    or 12/28/2005                 -->
<!-- korean : Today or 12.28  or 2005.12.28                   -->
<xsl:template name="brief_date_or_today">
  <xsl:param name="TargetMonth"/>
  <xsl:param name="TargetDay"/>
  <xsl:param name="TargetYear"/>
  <xsl:param name="CurrentMonth"/>
  <xsl:param name="CurrentDay"/>
  <xsl:param name="CurrentYear"/>

  <xsl:choose>
    <xsl:when test="($TargetYear=$CurrentYear) and ($TargetDay=$CurrentDay) and ($TargetMonth=$CurrentMonth)">
      오늘
    </xsl:when>
    <xsl:when test="$TargetYear = $CurrentYear">
      <xsl:call-template name="brief_date">
        <xsl:with-param name="Month" select="$TargetMonth"/>
        <xsl:with-param name="Day" select="$TargetDay"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="brief_date">
        <xsl:with-param name="Year" select="$TargetYear"/>
        <xsl:with-param name="Month" select="$TargetMonth"/>
        <xsl:with-param name="Day" select="$TargetDay"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
  
</xsl:template>


<!-- formatTime: output hour [minutes] according to the ceClock
     of the user -->
<!-- Hour: Mandatory                                     -->
<!-- Minute: optional parameter: show or not the minutes -->
<!-- In other languages, ie "ko", the am/pm must come first -->
<xsl:template name="formatTime">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>

<!-- In other languages, ie "ko", the am/pm must come first -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and (/calendar/usrctx/user/@language='ko')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:choose>
      <xsl:when test="$ftHour &lt; 12 ">
        오전
      </xsl:when>
      <xsl:when test="($ftHour &gt; 11) and ($ftHour &lt; 24)">
        오후
      </xsl:when>
      <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
    </xsl:choose>
    </FONT>
  </xsl:if>

  <xsl:call-template name="hour_short">
    <xsl:with-param name="hsHour" select="$ftHour"/>
  </xsl:call-template>

  <xsl:if test="string-length($ftMinute) &gt; 0">
    <xsl:text>:</xsl:text>
    <xsl:value-of select="$ftMinute"/>
  </xsl:if>

<!-- In languages other than "ko", the am/pm must comes here -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and not(/calendar/usrctx/user/@language='ko')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:choose>
      <xsl:when test="$ftHour &lt; 12 ">
        오전
      </xsl:when>
      <xsl:when test="($ftHour &gt; 11) and ($ftHour &lt; 24)">
        오후
      </xsl:when>
      <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
    </xsl:choose>
    </FONT>
  </xsl:if>
</xsl:template>

<!-- formatLongTime: output hour according to the ceClock of the user -->
<!-- Hour: Mandatory (if 12 hour mode 12pm/am replaced by noon/midnight -->
<xsl:template name="formatLongTime">
  <xsl:param name="Hour"/>

  <xsl:choose>
    <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">
      <xsl:call-template name="formatTime">
            <xsl:with-param name="ftHour" select="$Hour"/>
            <xsl:with-param name="ftMinute" select="'00'"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$Hour = 0">
      자정
    </xsl:when>
    <xsl:when test="$Hour = 12">
      정오
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="formatTime">
            <xsl:with-param name="ftHour" select="$Hour"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="date_selector">
  <xsl:param name="format" select="$dateorder"/>
  <xsl:param name="input_prefix"/>
  <xsl:param name="month"/>
  <xsl:param name="day"/>
  <xsl:param name="year"/>
  <xsl:param name="checkFunction" select="'dateCheck'" />

<!-- As we get to the end of the format, there is no more "/" -->
<!-- to use as a delineator. Just pick up the rest of the string -->
  <xsl:variable name="first">
    <xsl:choose>
    <xsl:when test="contains(($format),'/')">
      <xsl:value-of select="substring-before($format,'/')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$format"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="remain" select="substring-after($format,'/')"/>

  <xsl:choose>
    <xsl:when test="$first = 'M'">
      <INPUT type="text" maxlength="2" size="2" >
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>mm</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$month"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>mm';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'mm');
        </xsl:attribute>
      </INPUT>
    </xsl:when>
    <xsl:when test="$first = 'D'">
      <INPUT type="text" maxlength="2" size="2" >
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>dd</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$day"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>dd';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'dd');
        </xsl:attribute>
      </INPUT>
    </xsl:when>
    <xsl:otherwise>
      <INPUT type="text" maxlength="4" size="4">
        <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>ccyy</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$year"/></xsl:attribute>
        <xsl:attribute name="onFocus">
          var entry = '<xsl:value-of select="$input_prefix"/>ccyy';
          valueSave(entry);
        </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
        <xsl:attribute name="onBlur">
          var prefix = '<xsl:value-of select="$input_prefix"/>';
          <xsl:value-of select="$checkFunction"/>(prefix,'ccyy');
        </xsl:attribute>
      </INPUT>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:if test="$remain">
    <xsl:value-of select="$dateseparator"/>
    <xsl:call-template name="date_selector">
      <xsl:with-param name="format" select="$remain"/>
      <xsl:with-param name="input_prefix" select="$input_prefix"/>
      <xsl:with-param name="month" select="$month"/>
      <xsl:with-param name="day" select="$day"/>
      <xsl:with-param name="year" select="$year"/>
      <xsl:with-param name="checkFunction" select="$checkFunction"/>
    </xsl:call-template>
  </xsl:if>

</xsl:template>

<xsl:template name="time_select">
  <xsl:param name="input_prefix"/>
  <xsl:param name="start_hour"/>
  <xsl:param name="start_min"/>

<!-- In other languages, ie "ko", the am/pm must come first -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and (/calendar/usrctx/user/@language='ko')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <SELECT>
      <!-- This text is an input name and shouldn't get translated -->
      <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>pm</xsl:attribute>
      <OPTION value="0">오전</OPTION>
      <OPTION value="1">
        <xsl:if test="$start_hour >= 12">
          <xsl:attribute name="selected"></xsl:attribute>
        </xsl:if>오후
      </OPTION>
    </SELECT>
    </FONT>
  </xsl:if>

  <INPUT type="text"  maxlength="2" size="2">
    <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>hr</xsl:attribute>
    <xsl:attribute name="value"><xsl:call-template name="hour_short"><xsl:with-param name="hsHour" select="$start_hour"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="onFocus">
      var entry = '<xsl:value-of select="$input_prefix"/>hr';
      valueSave(entry);
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var prefix = '<xsl:value-of select="$input_prefix"/>';
      <xsl:choose>
      <xsl:when test="/calendar/usrctx/userprefs/@ceClock='24'">hourCheck(23, prefix);</xsl:when>
      <xsl:otherwise>hourCheck(12, prefix);</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <FONT face="{$font_name}" size="{$font_size_big_2}"> : </FONT>
  </INPUT>

  <INPUT type="text" maxlength="2" size="2">
    <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>mn</xsl:attribute>
    <xsl:attribute name="value"><xsl:call-template name="min_short"><xsl:with-param name="hsMin" select="$start_min"/>
      </xsl:call-template>
    </xsl:attribute>
    <xsl:attribute name="onFocus">
      var entry = '<xsl:value-of select="$input_prefix"/>mn';
      valueSave(entry);
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var prefix = '<xsl:value-of select="$input_prefix"/>';
      minuteCheck(prefix);
    </xsl:attribute>
  </INPUT>

<!-- if the language is not "ko" , then this menu goes here -->
  <xsl:if test="(/calendar/usrctx/userprefs/@ceClock='12') and not(/calendar/usrctx/user/@language='ko')">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <SELECT>
      <!-- This text is an input name and shouldn't get translated -->
      <xsl:attribute name="name"><xsl:value-of select="$input_prefix"/>pm</xsl:attribute>
      <OPTION value="0">오전</OPTION>
      <OPTION value="1">
        <xsl:if test="$start_hour >= 12">
          <xsl:attribute name="selected"></xsl:attribute>
        </xsl:if>오후
      </OPTION>
    </SELECT>
    </FONT>
  </xsl:if>

</xsl:template>

<xsl:template name="duration_selector">
  <xsl:param name="ds_start_hour"/>
  <xsl:param name="ds_start_min"/>
  <xsl:param name="dur_hour"/>
  <xsl:param name="dur_min"/>

  <xsl:call-template name="time_select">
    <xsl:with-param name="start_hour" select="$ds_start_hour"/>
    <xsl:with-param name="start_min" select="$ds_start_min"/>
  </xsl:call-template>

  <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>,&nbsp;</xsl:text><xsl:text>&nbsp;</xsl:text></FONT>
  <INPUT type="text" name="dhr" maxlength="2" size="2">
    <xsl:attribute name="value"><xsl:value-of select="$dur_hour"/></xsl:attribute>
    <xsl:attribute name="onFocus">
      valueSave('dhr');
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      durationHourCheck(23, 'd');
    </xsl:attribute>
  </INPUT>
  <FONT face="{$font_name}" size="{$font_size_big_2}">시간<xsl:text>&nbsp;</xsl:text></FONT>
  <INPUT type="text" name="dmn" maxlength="2" size="2">
    <xsl:attribute name="value"><xsl:value-of select="$dur_min"/></xsl:attribute>
    <xsl:attribute name="onFocus">
      valueSave('dmn');
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      minuteCheck('d');
    </xsl:attribute>
  </INPUT>
  <FONT face="{$font_name}" size="{$font_size_big_2}">분</FONT>
<FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>동안</FONT>
</xsl:template>

<!-- In 'en' this shows up as "<date_selector> at <hr>:<min> <am/pm>" -->
<xsl:template name="absolute_datetime_selector">
  <xsl:param name="input_prefix"/>
  <xsl:param name="month"/>
  <xsl:param name="day"/>
  <xsl:param name="year"/>
  <xsl:param name="start_hour"/>
  <xsl:param name="start_min"/>

  <xsl:call-template  name="date_selector">
    <xsl:with-param name="input_prefix" select="$input_prefix"/>
    <xsl:with-param name="month" select="$month"/>
    <xsl:with-param name="day" select="$day"/>
    <xsl:with-param name="year" select="$year"/>
  </xsl:call-template>
  <FONT face="{$font_name}" size="{$font_size_big_2}">&nbsp;&nbsp;</FONT>
  <xsl:call-template name="time_select">
    <xsl:with-param name="input_prefix" select="$input_prefix"/>
    <xsl:with-param name="start_hour" select="$start_hour"/>
    <xsl:with-param name="start_min" select="$start_min"/>
  </xsl:call-template>
</xsl:template>


<!-- In 'en' this shows up as "<15> <minutes> before the event begins>" -->
<xsl:template name="time_before_selector">
  <xsl:param name="time_offset"/>
  <xsl:param name="time_units"/>
  <xsl:param name="before_text"/>

  <xsl:value-of select="$before_text"/>
  <INPUT type="text" name="dur_time" size="{$font_size_big_2}">
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="string-length($time_offset) = 0">15</xsl:when>
      <xsl:otherwise><xsl:value-of select="$time_offset"/></xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['dur_time'].value;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
      f['dur_time'].value = '15';
      parent.date_error = '1';
      alert('유효한 시간을 입력하십시오.');
      }
    </xsl:attribute>
  </INPUT>
  <SELECT name="before">
    <OPTION value="mns">
      <xsl:if test="$time_units=1">
        <xsl:attribute name="selected"/>
      </xsl:if>
      분
    </OPTION>
    <OPTION value="hrs">
      <xsl:if test="$time_units=2">
        <xsl:attribute name="selected"/>
      </xsl:if>
      시간
    </OPTION>
    <OPTION value="dys">
     <xsl:if test="$time_units=3">
       <xsl:attribute name="selected"/>
      </xsl:if>
      일
    </OPTION>
    </SELECT><xsl:text>&nbsp;</xsl:text>
</xsl:template>


<!-- Used in recurrence dialogs under "until" section -->
<!-- Create <numselector> events/tasks -->
<xsl:template name="until_count_selector">
  <xsl:param name="count_len"/>
  <xsl:param name="count_num"/>
  <xsl:param name="count_type"/>
  <xsl:param name="recur_bound"/>

<!-- l10n_ko -->
<!-- end_of_l10n_ko -->
  <input type="text" name="COUNT">
    <xsl:attribute name="maxlength"><xsl:value-of select="$count_len"/></xsl:attribute> 
    <xsl:attribute name="size"><xsl:value-of select="$count_len"/></xsl:attribute> 
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="string-length($count_num) &gt; 0"><xsl:value-of select="$count_num"/></xsl:when>
      <xsl:otherwise>5</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
<!-- use onBlur instead of onChange to prevent IE from accepting invalid values on trying again -->
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['COUNT'].value;
      var max_limit = <xsl:value-of select="$recur_bound"/>;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
        f['COUNT'].value ='5';
	    parent.date_error = '1';
        alert('올바른 수를 입력하십시오.');
      } else if (checked_num &gt; max_limit) {
        f['COUNT'].value = max_limit;
	    parent.date_error = '1';
          alert('다음 수보다 작거나 같은 수를 입력하십시오.'+ ' ' + max_limit);
      }
    </xsl:attribute>
  </input>
  <xsl:choose>
  <xsl:when test="$count_type='TASK'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>작업</font>
<!-- l10n_ko: moved from line 635 -->
  <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>만들기<xsl:text>&nbsp;&nbsp;</xsl:text></font>
<!-- end_of_l10n_ko -->
  </xsl:when>
  <xsl:otherwise>
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>이벤트</font>
<!-- l10n_ko: moved from line 635 -->
  <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>만들기<xsl:text>&nbsp;&nbsp;</xsl:text></font>
<!-- end_of_l10n_ko -->
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- used in recurrence dialog for all recurrence types -->
<!-- Every <numselector> days, weeks, months, etc -->
<xsl:template name="interval_selector">
  <xsl:param name="interval_type"/>
  <xsl:param name="rrule_num"/>
  <xsl:param name="rrule_interval"/>

  <font size="{$font_size_big_2}" face="{$font_name}">매번<xsl:text>&nbsp;</xsl:text></font>
  <input type="text" size="{$font_size_big_2}" maxlength="2" name="INTERVAL">
    <xsl:attribute name="value">
      <xsl:choose>
      <xsl:when test="$rrule_num='3'"><xsl:value-of select="$rrule_interval"/></xsl:when>
      <xsl:otherwise><xsl:text>2</xsl:text></xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:attribute name="onBlur">
      var f = document.forms[0];
      var input_num = f['INTERVAL'].value;
      var checked_num = checkNumberStringInput(input_num);
      if (checked_num == '-1') {
	    f['INTERVAL'].value ='2';
        parent.date_error = 1;
        alert('유효한 간격을 입력하십시오.');
      }
    </xsl:attribute>
  </input>
  <xsl:choose>
  <xsl:when test="$interval_type='DAILY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>일</font>
  </xsl:when>
  <xsl:when test="$interval_type='MONTHLY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>개월</font>
  </xsl:when>
  <xsl:when test="$interval_type='YEARLY'">
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>년</font>
  </xsl:when>
  <xsl:otherwise>
<!-- WEEKLY -->
    <font size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>주</font>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>              

<!-- Used in recurrence dialogs - when in "daily" mode -->
<!-- Every <menu - selector> -->
<xsl:template name="daily_byday_selector">
  <xsl:param name="rrule_daily"/>
  <xsl:param name="rrule_byday"/>

  <font size="{$font_size_big_2}" face="{$font_name}">
    매번<xsl:text>&nbsp;</xsl:text>
  <select name="BYDAY" size="{$font_size_big}">
    <option value="BYDAY=MO,TU,WE,TH,FR">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='MO,TU,WE,TH,FR')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      평일
    </option>
    <option value="BYDAY=MO,WE,FR">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='MO,WE,FR')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      월요일, 수요일 및 금요일
    </option>
    <option value="BYDAY=TU,TH">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='TU,TH')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      화요일 및 목요일
    </option>
    <option value="BYDAY=SU,SA">
      <xsl:if test="($rrule_daily='2') and ($rrule_byday='SU,SA')">
        <xsl:attribute name="selected"/>
      </xsl:if>
      토요일 및 일요일
    </option>
  </select>
  </font>
</xsl:template>


<!-- used in recurrence dialog, monthly or yearly mode -->
<!-- If MONTHLY = The <1st> day of the month -->
<!-- If YEARLY = The <1st> <January> -->
<xsl:template name="monthday_ordinal_selector">
  <xsl:param name="selector_type"/>
  <xsl:param name="rrule_bymonthday"/>
  <xsl:param name="rrule_bymonth"/>
            
  <font size="{$font_size_big_2}" face="{$font_name}">
<!-- <xsl:text>&nbsp;</xsl:text><xsl:value-of select="$cap_the_text"/> -->
<!-- l10n_ko -->
  <xsl:choose>
  <xsl:when test="$selector_type='MONTHLY'">
<!-- MONTHLY -->
    <!--일-->
  </xsl:when>
  <xsl:otherwise>
<!-- YEARLY -->
    <xsl:call-template name="month_selector">
        <xsl:with-param name="selector_name">BYMONTH</xsl:with-param>
        <xsl:with-param name="rrule_month" select="$rrule_bymonth"/>
    </xsl:call-template>
  </xsl:otherwise>
  </xsl:choose>
<!-- end_of_l10n_ko -->
  <select name="BYMONTHDAY" size="{$font_size_big}">
    <option value="1">
      <xsl:if test="$rrule_bymonthday='1'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      1일
     </option>
    <option value="2">
      <xsl:if test="$rrule_bymonthday='2'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      2일
    </option>
    <option value="3">
      <xsl:if test="$rrule_bymonthday='3'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      3일
    </option>
    <option value="4">
      <xsl:if test="$rrule_bymonthday='4'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      4일
    </option>
    <option value="5">
      <xsl:if test="$rrule_bymonthday='5'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      5일
    </option>
    <option value="6">
      <xsl:if test="$rrule_bymonthday='6'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      6일
    </option>
    <option value="7">
      <xsl:if test="$rrule_bymonthday='7'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      7일
    </option>
    <option value="8">
      <xsl:if test="$rrule_bymonthday='8'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      8일
    </option>
    <option value="9">
      <xsl:if test="$rrule_bymonthday='9'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      9일
    </option>
    <option value="10">
      <xsl:if test="$rrule_bymonthday='10'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      10일
    </option>
    <option value="11">
      <xsl:if test="$rrule_bymonthday='11'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      11일
    </option>
    <option value="12">
      <xsl:if test="$rrule_bymonthday='12'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      12일
    </option>
    <option value="13">
      <xsl:if test="$rrule_bymonthday='13'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      13일
    </option>
    <option value="14">
      <xsl:if test="$rrule_bymonthday='14'">
        <xsl:attribute name="selected"/>
      </xsl:if>
     14일
    </option>
    <option value="15">
      <xsl:if test="$rrule_bymonthday='15'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      15일
    </option>
    <option value="16">
      <xsl:if test="$rrule_bymonthday='16'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      16일
    </option>
    <option value="17">
      <xsl:if test="$rrule_bymonthday='17'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      17일
    </option>
    <option value="18">
      <xsl:if test="$rrule_bymonthday='18'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      18일
    </option>
    <option value="19">
      <xsl:if test="$rrule_bymonthday='19'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      19일
    </option>
    <option value="20">
      <xsl:if test="$rrule_bymonthday='20'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      20일
    </option>
    <option value="21">
      <xsl:if test="$rrule_bymonthday='21'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      21일
    </option>
    <option value="22">
      <xsl:if test="$rrule_bymonthday='22'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      22일
    </option>
    <option value="23">
      <xsl:if test="$rrule_bymonthday='23'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      23일
    </option>
    <option value="24">
      <xsl:if test="$rrule_bymonthday='24'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      24일
    </option>
    <option value="25">
      <xsl:if test="$rrule_bymonthday='25'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      25일
    </option>
    <option value="26">
      <xsl:if test="$rrule_bymonthday='26'">
        <xsl:attribute name="selected"/>
      </xsl:if>
     26일
    </option>
    <option value="27">
      <xsl:if test="$rrule_bymonthday='27'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      27일
    </option>
    <option value="28">
      <xsl:if test="$rrule_bymonthday='28'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      28일
    </option>
    <option value="29">
      <xsl:if test="$rrule_bymonthday='29'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      29일
    </option>
    <option value="30">
      <xsl:if test="$rrule_bymonthday='30'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      30일
    </option>
    <option value="31">
      <xsl:if test="$rrule_bymonthday='31'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      31일
    </option>
  </select>
  </font>
</xsl:template>


<!-- Used in the recurrence dialog for both MONTHLY and YEARLY type selection -->
<!-- MONTHLY = The <1st> <Sunday> of the month -->
<!-- YEARLY = The <1st> <Sunday> <January> -->
<xsl:template name="month_byweekday_selector">
  <xsl:param name="selector_type"/>
  <xsl:param name="rrule_bysetpos"/>
  <xsl:param name="rrule_byday"/>
  <xsl:param name="rrule_bydaymonth"/>
  <xsl:param name="rrule_interval"/>
          
  <font size="{$font_size_big_2}" face="{$font_name}">
<!-- <xsl:text>&nbsp;</xsl:text><xsl:value-of select="$cap_the_text"/> -->
<!-- l10n_ko -->
    <xsl:choose>
    <xsl:when test="$selector_type='MONTHLY'">
<!-- MONTHLY -->
        <!--달-->

    </xsl:when>
    <xsl:otherwise>
<!-- YEARLY -->
    <xsl:call-template name="month_selector">
        <xsl:with-param name="selector_name">BYDAY_MONTH</xsl:with-param>
        <xsl:with-param name="rrule_month" select="$rrule_bydaymonth"/>
    </xsl:call-template>
    </xsl:otherwise>
    </xsl:choose>
<!-- end_of_l10n_ko -->

    <select name="BYSETPOS" size="{$font_size_big}">
      <option value="1">
        <xsl:if test="$rrule_bysetpos='1'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        첫 번째
      </option>
      <option value="2">
        <xsl:if test="$rrule_bysetpos='2'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        두 번째
      </option>
      <option value="3">
        <xsl:if test="$rrule_bysetpos='3'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        세 번째
      </option>
      <option value="4">
        <xsl:if test="$rrule_bysetpos='4'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        네 번째
      </option>
      <option value="-1">
        <xsl:if test="$rrule_bysetpos='-1'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        월의 마지막 날짜
      </option>
    </select> 
    <select name="BYDAY" size="{$font_size_big}">
      <option value="SU">
        <xsl:if test="$rrule_byday='SU'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        일요일
      </option>
      <option value="MO">
        <xsl:if test="$rrule_byday='MO'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        월요일
      </option>
      <option value="TU">
        <xsl:if test="$rrule_byday='TU'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        화요일
      </option>
      <option value="WE">
        <xsl:if test="$rrule_byday='WE'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        수요일
      </option>
      <option value="TH">
        <xsl:if test="$rrule_byday='TH'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        목요일
      </option>
      <option value="FR">
        <xsl:if test="$rrule_byday='FR'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        금요일
      </option>
      <option value="SA">
        <xsl:if test="$rrule_byday='SA'">
          <xsl:attribute name="selected"/>
        </xsl:if>
        토요일
      </option>

      <xsl:if test="$selector_type='MONTHLY' or $selector_type='YEARLY'">

	<option value="MO,TU,WE,TH,FR">
		<xsl:if test="$rrule_byday='MO,TU,WE,TH,FR'">
          		<xsl:attribute name="selected"/>
        	</xsl:if>
        	평일
 	</option>
	<option value="SU,SA">
		<xsl:if test="$rrule_byday='SU,SA'">
          		<xsl:attribute name="selected"/>
        	</xsl:if>
        	주말
 	</option>
       </xsl:if>
    </select>
  </font>
</xsl:template>

<!-- Used in recurrence dialog with YEARLY mode -->
<!-- used defined selector name (depending on usage) and set up month menu -->
<!-- Used as part of two other selectors, eg -->
<!-- The <31st> <January> OR -->
<!-- The <1st> <Sunday> <January> -->
<xsl:template name="month_selector">
  <xsl:param name="selector_name"/>
  <xsl:param name="rrule_month"/>
  
  <select name="{$selector_name}" size="{$font_size_big}">
    <option value="1">
      <xsl:if test="$rrule_month='1'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      1월
    </option>
    <option value="2">
      <xsl:if test="$rrule_month='2'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      2월
    </option>
    <option value="3">
      <xsl:if test="$rrule_month='3'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      3월
    </option>
    <option value="4">
      <xsl:if test="$rrule_month='4'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      4월
    </option>
    <option value="5">
      <xsl:if test="$rrule_month='5'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      5월
    </option>
    <option value="6">
      <xsl:if test="$rrule_month='6'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      6월
    </option>
    <option value="7">
      <xsl:if test="$rrule_month='7'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      7월
    </option>
    <option value="8">
      <xsl:if test="$rrule_month='8'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      8월
    </option>
    <option value="9">
      <xsl:if test="$rrule_month='9'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      9월
    </option>
    <option value="10">
      <xsl:if test="$rrule_month='10'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      10월 
    </option>
    <option value="11">
      <xsl:if test="$rrule_month='11'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      11월
    </option>
    <option value="12">
      <xsl:if test="$rrule_month='12'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      12월
    </option>
  </select>
</xsl:template>


            
<!-- This form input template is used in search_for_calendars_common.xsl -->
<!-- The layout of the elements may need to change to suit the grammar in l10n -->
<!-- Do NOT change the form element names or the form handling won't work. -->
<!-- You can change the order of the elements and the values as needed -->
<xsl:template name="cal_search_input_template">
<TR>
  <TD colspan="4"> <BR/>
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      달력 위치 검색
    </FONT>
  </TD>
</TR>
<TR>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <SELECT name="which">
        <OPTION value="name;calid">이름 또는 아이디</OPTION>
        <OPTION value="name">이름</OPTION>
        <OPTION value="primaryOwner">주 소유자</OPTION>
        <OPTION value="calid">ID</OPTION>
      </SELECT>
    </FONT>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <SELECT name="how">
        <OPTION value="0">다음 포함</OPTION>
        <OPTION value="1">시작 문자</OPTION>
      </SELECT>
    </FONT>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
    <INPUT type="text" name="what"/>
    <INPUT type="hidden" name="selected_list" value=""/>
    </FONT>
    <xsl:text>&nbsp;</xsl:text>
  </TD>
  <TD valign="baseline">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <INPUT type="button" name="find" value="검색" width="72">
        <xsl:attribute name="onClick"><xsl:value-of select="./button[@name='find']"/></xsl:attribute>
      </INPUT>
    </FONT>
  </TD>
</TR>
</xsl:template>


<xsl:template name="event_date_time">
  <xsl:param name="includeDate"/>
  <xsl:param name="multiples"/>

  <xsl:if test="$includeDate='true'">
    <xsl:call-template name="brief_date">
      <xsl:with-param name="Month">
        <xsl:value-of select="StartTime/@month"/>
      </xsl:with-param>
      <xsl:with-param name="Day">
        <xsl:value-of select="StartTime/@date"/>
      </xsl:with-param>
      <xsl:with-param name="Year">
        <xsl:value-of select="StartTime/@year"/>
      </xsl:with-param>
    </xsl:call-template>
    ,<xsl:text>&nbsp;</xsl:text>
  </xsl:if>

  <xsl:choose>
    
    <xsl:when test="./@e_allday=1">
      <xsl:if test="$multiples!='TRUE'">
        하루 종일
      </xsl:if>
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="dur_short">
        <xsl:with-param name="date1" select="StartTime"/>
        <xsl:with-param name="date2" select="EndTime"/>
      </xsl:call-template>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- due + [on + date] + at + time-->
<!-- korean : [date] + time + at + [on] + due -->
<xsl:template name="due_task_date_time">
  <xsl:param name="includeDate"/>
  <xsl:param name="includeTime"/>

  <xsl:if test="$includeDate='true'">
    <xsl:call-template name="brief_date">
      <xsl:with-param name="Year" select="DueTime/@year"/>
      <xsl:with-param name="Month" select="DueTime/@month"/>
      <xsl:with-param name="Day" select="DueTime/@date"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$includeTime='true'">
    <xsl:call-template name="formatTime">
      <xsl:with-param name="ftHour" select="DueTime/@hour"/>
      <xsl:with-param name="ftMinute" select="DueTime/@minute"/>
    </xsl:call-template>
    시<xsl:text>&nbsp;</xsl:text>
  </xsl:if>
  기한<xsl:text>&nbsp;</xsl:text>
</xsl:template>
      
<!-- [overdue] + from + date + at + [time] -->
<!-- The font gets set outside -->
<!-- Korean : date + at + [time] + from + [overdue] -->
<xsl:template name="overdue_task_date_time">
  <xsl:param name="multiples"/> 
 <xsl:param name="notime"/>
  
  <xsl:call-template name="task_date_at_time">
    <xsl:with-param name="dateA" select="DueTime"/>
    <xsl:with-param name="notime" select="$notime"/>
   </xsl:call-template>
   <!-- 부터 -->
   <xsl:text>&nbsp;</xsl:text>
   <xsl:if test="$multiples!='TRUE'">
     기한 지남<xsl:text>&nbsp;</xsl:text>
   </xsl:if>
</xsl:template>


<!-- called in singleDayTimeHeaderTemplate to output date in form -->
<!-- Friday -->
<!-- May 24, 2002 -->
<!-- The format will need changing for localization purposes -->
<!-- For korean : 2002 May 24 -->
<xsl:template name="dayTimeHeader">

  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
  <xsl:value-of select="timectx/StartTime/@year"/>
  년<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="timectx/StartTime/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="timectx/StartTime/@date"/>
  일<xsl:text>&nbsp;</xsl:text>
  <br/>
  <b>
  <xsl:apply-templates select="timectx/StartTime/@dow"/>
  </b>
  </font>
</xsl:template>          

<!-- Format is: -->
<!-- Month1 Day1[, Year1] - Month7 Day7, Year7 -->
<!-- Where the optional ", Year1" is only printed if different from Year2-->
<!-- This format can be changed for localization purposes -->
<!-- korean : Year1 Month1 Day1 - Month7 Day7 -->
<xsl:template name="weekTimeHeader">

  <font face="{$font_name}" size="{$font_size_big_3}" color="#000000">
  <b>
  <xsl:value-of select="weekcal/weekday[7]/@year"/>
  년<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="weekcal/weekday[1]/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="weekcal/weekday[1]/@date"/>
  일 <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="$horiz_divider"/>
  <xsl:if test="weekcal/weekday[1]/@year!=weekcal/weekday[7]/@year">
     <xsl:text>&nbsp;</xsl:text> <xsl:value-of select="weekcal/weekday[1]/@year"/>
     년<xsl:text>&nbsp;</xsl:text>
  </xsl:if>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="weekcal/weekday[7]/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  <xsl:value-of select="weekcal/weekday[7]/@date"/>
  일<xsl:text>&nbsp;</xsl:text>
  </b>
  </font>
</xsl:template>          

<!-- Of the format -->
<!-- May 2002 -->
<!-- This can be changed for localization purposes -->
<!-- korean 2002 May -->
<xsl:template name="monthTimeHeader">

  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
  <b>
  <xsl:value-of select="timectx/StartTime/@year"/>
  년<xsl:text>&nbsp;</xsl:text>
  <xsl:call-template name="longMonthName">
    <xsl:with-param name="MonthNum" select="timectx/StartTime/@month"/>
  </xsl:call-template>
  <xsl:text>&nbsp;</xsl:text>
  </b></font>
</xsl:template>          

<!-- Of the format -->
<!-- 2002 -->
<!-- this can be changed for localization purposes -->
<xsl:template name="yearTimeHeader">
  <font face="{$font_name}" size="{$font_size_biggest}" color="#000000">
  <b>
  <xsl:value-of select="timectx/StartTime/@year"/>
  년
  </b>
  </font>
</xsl:template>          

<!-- This form input template is used in search_for_components.xsl -->
<!-- The layout of the elements may need to change to suit the grammar in l10n -->
<!-- Do NOT change the form element names or the form handling won't work. -->
<xsl:template name="searchComponentsInputTemplate">

  <TD colspan="4">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      다음을 포함하는 이벤트 및 작업 검색
    </FONT>
  </TD>
  <TD valign="baseline">
    <INPUT type="text" name="what"/>
  </TD>
</xsl:template>

<!-- This needs to live here because it's format will change to be localized -->
<xsl:template name="emitRecurChangePatternLinkEvent">
  <xsl:call-template name="recurrenceString">
    <xsl:with-param name="e_rrule_daily" select="../eventdata/Event/@e_rrule_daily"/>
    <xsl:with-param name="e_rrule_weekly" select="../eventdata/Event/@e_rrule_weekly"/>
    <xsl:with-param name="e_rrule_monthly" select="../eventdata/Event/@e_rrule_monthly"/>
    <xsl:with-param name="e_rrule_yearly" select="../eventdata/Event/@e_rrule_yearly"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  반복
  <xsl:text>&nbsp;</xsl:text>
  [<A>
     <xsl:attribute name="href"><xsl:value-of select="command[@name='recurrence']"/></xsl:attribute>
     반복 패턴 변경
  </A>]
</xsl:template>

<!-- This needs to live here because it's format will change to be localized -->
<xsl:template name="emitRecurChangePatternLinkTask">
  <xsl:call-template name="recurrenceString">
    <xsl:with-param name="e_rrule_daily" select="../taskdata/Task/@e_rrule_daily"/>
    <xsl:with-param name="e_rrule_weekly" select="../taskdata/Task/@e_rrule_weekly"/>
    <xsl:with-param name="e_rrule_monthly" select="../taskdata/Task/@e_rrule_monthly"/>
    <xsl:with-param name="e_rrule_yearly" select="../taskdata/Task/@e_rrule_yearly"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  반복
  <xsl:text>&nbsp;</xsl:text>
  [<A>
     <xsl:attribute name="href"><xsl:value-of select="command[@name='recurrence']"/></xsl:attribute>
     반복 패턴 변경
  </A>]
</xsl:template>

<!-- This is set up here so that the layout can be changed for l10n -->
<!-- do not change the name of the elements or the form processing won't work -->
<!-- in 'en' this is beginning <month> <date><year> Ending <month><date><year> -->
<xsl:template name="importExportDateRangeInput">
<xsl:text>&nbsp;</xsl:text>
시작 <SELECT name="mStart">

<xsl:variable name="startYear">
<xsl:value-of select="./timectx/StartTime/@year"/>
</xsl:variable>

<xsl:variable name="endYear">
<xsl:value-of select="./timectx/EndTime/@year"/>
</xsl:variable>

<xsl:variable name="startMonth">
<xsl:value-of select="./timectx/StartTime/@month"/>
</xsl:variable>

<xsl:variable name="endMonth">
<xsl:value-of select="./timectx/EndTime/@month"/>
</xsl:variable>

<OPTION value="1">
<xsl:if test="$startMonth='01'"><xsl:attribute name="selected"/></xsl:if>
1월</OPTION>
<OPTION value="2">
<xsl:if test="$startMonth='02'"><xsl:attribute name="selected"/></xsl:if>
2월</OPTION>
<OPTION value="3">
<xsl:if test="$startMonth='03'"><xsl:attribute name="selected"/></xsl:if>
3월</OPTION>
<OPTION value="4">
<xsl:if test="$startMonth='04'"><xsl:attribute name="selected"/></xsl:if>
4월</OPTION>
<OPTION value="5">
<xsl:if test="$startMonth='05'"><xsl:attribute name="selected"/></xsl:if>
5월</OPTION>
<OPTION value="6">
<xsl:if test="$startMonth='06'"><xsl:attribute name="selected"/></xsl:if>
6월</OPTION>
<OPTION value="7">
<xsl:if test="$startMonth='07'"><xsl:attribute name="selected"/></xsl:if>
7월</OPTION>
<OPTION value="8">
<xsl:if test="$startMonth='08'"><xsl:attribute name="selected"/></xsl:if>
8월</OPTION>
<OPTION value="9">
<xsl:if test="$startMonth='09'"><xsl:attribute name="selected"/></xsl:if>
9월</OPTION>
<OPTION value="10">
<xsl:if test="$startMonth='10'"><xsl:attribute name="selected"/></xsl:if>
10월 </OPTION>
<OPTION value="11">
<xsl:if test="$startMonth='11'"><xsl:attribute name="selected"/></xsl:if>
11월</OPTION>
<OPTION value="12">
<xsl:if test="$startMonth='12'"><xsl:attribute name="selected"/></xsl:if>
12월</OPTION>
</SELECT>
<INPUT type="text" name="ms_day" size="{$font_size_big_2}" maxlength="2">
<xsl:attribute name="value"><xsl:value-of select="./timectx/StartTime/@date"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_ddCheck('ms', f);
</xsl:attribute>
</INPUT>
<INPUT type="text" name="ms_year" size="4" maxlength="4">
<xsl:attribute name="value"><xsl:value-of select="./timectx/StartTime/@year"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_yearCheck('ms', f);
</xsl:attribute>
</INPUT>
<xsl:text>&nbsp;</xsl:text>종료
<SELECT name="mEnd">
<OPTION value="1">
<xsl:if test="$endMonth='01'"><xsl:attribute name="selected"/></xsl:if>
1월</OPTION>
<OPTION value="2">
<xsl:if test="$endMonth='02'"><xsl:attribute name="selected"/></xsl:if>
2월</OPTION>
<OPTION value="3">
<xsl:if test="$endMonth='03'"><xsl:attribute name="selected"/></xsl:if>
3월</OPTION>
<OPTION value="4">
<xsl:if test="$endMonth='04'"><xsl:attribute name="selected"/></xsl:if>
4월</OPTION>
<OPTION value="5">
<xsl:if test="$endMonth='05'"><xsl:attribute name="selected"/></xsl:if>
5월</OPTION>
<OPTION value="6">
<xsl:if test="$endMonth='06'"><xsl:attribute name="selected"/></xsl:if>
6월</OPTION>
<OPTION value="7">
<xsl:if test="$endMonth='07'"><xsl:attribute name="selected"/></xsl:if>
7월</OPTION>
<OPTION value="8">
<xsl:if test="$endMonth='08'"><xsl:attribute name="selected"/></xsl:if>
8월</OPTION>
<OPTION value="9">
<xsl:if test="$endMonth='09'"><xsl:attribute name="selected"/></xsl:if>
9월</OPTION>
<OPTION value="10">
<xsl:if test="$endMonth='10'"><xsl:attribute name="selected"/></xsl:if>
10월 </OPTION>
<OPTION value="11">
<xsl:if test="$endMonth='11'"><xsl:attribute name="selected"/></xsl:if>
11월</OPTION>
<OPTION value="12">
<xsl:if test="$endMonth='12'"><xsl:attribute name="selected"/></xsl:if>
12월</OPTION>
</SELECT>

<INPUT type="text" name="me_day" size="{$font_size_big_2}" maxlength="2">
<xsl:attribute name="value"><xsl:value-of select="./timectx/EndTime/@date"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_ddCheck('me', f);
</xsl:attribute>
</INPUT>
<INPUT type="text" name="me_year" size="4" maxlength="4">
<xsl:attribute name="value"><xsl:value-of select="./timectx/EndTime/@year"/></xsl:attribute>
<xsl:attribute name="onBlur">
  var f = document.forms[0];
  importexport_yearCheck('me', f);
</xsl:attribute>
</INPUT>
</xsl:template>

<!-- Of the format -->
<!-- Sunday 19 -->
<!-- This can be changed for localization purposes -->
<xsl:template name="weekDayDate">
  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
    <xsl:apply-templates select="@date"/>
    <xsl:text>&nbsp;</xsl:text>
    일
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="@dow"/>
  </FONT>
</xsl:template>          

<!-- Of the format -->
<!-- 19  used in the month table to label each day box-->
<!-- This can be changed for localization purposes -->
<xsl:template name="monthDayDate">
  <xsl:param name="color"/> 

  <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="{$color}">
    <xsl:value-of select="@date"/>        
  </FONT>
</xsl:template>            



</xsl:stylesheet>



