<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>ユーザーの検索: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="155,*,60">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='searchProperties'">
      <xsl:for-each select="group">
        <xsl:if test="@name='searchProperties'">
          <xsl:call-template name="search_toolbar"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="main"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (search_for_users.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="search_toolbar">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0" onload="window.focus();parent.frames[0].document.forms[0].what.focus()">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">
    document.forms[0]['search'].click();
    return false;
  </xsl:attribute>
  <xsl:apply-templates select="formdata"/>

  <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" height="10">
    <TR>
      <TD bgcolor="#000000" colspan="3"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
        <TR bgcolor="{$bgcolor_table_mid}"><TD width="1%" nowrap="" align="center" bgcolor="#FFCC00"><FONT face="{$font_name}" size="{$font_size_big_2}"><b><xsl:text>&nbsp;</xsl:text>ユーザーの検索<xsl:text>&nbsp;</xsl:text></b></FONT></TD>
           <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
        </TR>
      </TABLE></TD>
    </TR>
    <TR>
     <TD colspan="3" align="left">
      <FONT size="{$font_size_big}" face="{$font_name}">
        <xsl:text>&nbsp;</xsl:text>
      </FONT>
      </TD>
    </TR>
    <TR>
     <TD colspan="3" align="left">
      <FONT size="{$font_size_big_2}" face="{$font_name}">
        <xsl:text>&nbsp;</xsl:text><b>ローカルディレクトリの検索</b> <BR/> 
      </FONT>
      </TD>
    </TR>
 
    <TR>
      <TD>
       <xsl:text>&nbsp;&nbsp;&nbsp;</xsl:text>
      </TD>
      <TD valign="left" align="left" colspan="2">
       <INPUT type="hidden" name="selected_list" value=""/>
       <INPUT type="text" name="what"/><xsl:text>&nbsp;</xsl:text>
        <FONT size="{$font_size_big_2}" face="{$font_name}">
          <INPUT type="button" name="search" value="検索" width="52">
            <xsl:attribute name="onClick"><xsl:value-of select="./button[@name='search']"/></xsl:attribute>
          </INPUT>
        </FONT>
      </TD>
    </TR>

    <TR>
      <TD>
       <xsl:text>&nbsp;&nbsp;&nbsp;</xsl:text>
      </TD>
     <TD nowrap="" >
      <FONT size="{$font_size_big}" face="{$font_name}">
        (名、姓、またはユーザー ID を入力します)
      </FONT>
     </TD>
     <TD><xsl:text>&nbsp;</xsl:text></TD>
   </TR>
   <TR>
     <TD>
     <xsl:text>&nbsp;&nbsp;&nbsp;</xsl:text>
     </TD>
     <TD> 
       <FONT size="{$font_size_big}" face="{$font_name}"> 説明文:&nbsp; </FONT>
       <img src="imx/32-conference.gif" width="16" height="16"/> 
       <FONT size="{$font_size_big}" face="{$font_name}"> リソース;&nbsp; </FONT> 
       <img src="imx/group.gif" width="16" height="18"/> 
       <FONT size="{$font_size_big}" face="{$font_name}"> グループ </FONT>
     </TD> 
     <TD><xsl:text>&nbsp;</xsl:text>
     </TD>
   </TR>

<!--
    <TR>
     <TD>
       <HR ALIGN="LEFT" SIZE="1" NOSHADE="" WIDTH="75%"/>
     </TD>
    </TR>
-->

  </TABLE>

</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="output_table_cell">
  <xsl:param name="cell_text"/>

  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:choose>
        <xsl:when test="string($cell_text) = ''"><xsl:text>&nbsp;</xsl:text></xsl:when>
        <xsl:otherwise><xsl:value-of select="$cell_text"/></xsl:otherwise>
      </xsl:choose>
    </FONT>
  </TD>
</xsl:template>

<xsl:template name="output_person_cell">
  <xsl:param name="cell_gif"/>
  <xsl:param name="cell_text"/>

  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <xsl:if test="string($cell_gif) != ''"><img src="{$cell_gif}" width="18" height="18" /><xsl:text>&nbsp;</xsl:text></xsl:if>
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:choose>
        <xsl:when test="string($cell_text) = ''"><xsl:text>&nbsp;</xsl:text></xsl:when>
        <xsl:otherwise><xsl:value-of select="$cell_text"/></xsl:otherwise>
      </xsl:choose>
    </FONT>
  </TD>
</xsl:template>

<xsl:template name="output_selected_user">
<xsl:param name="usernode"/>
<xsl:param name="currpos"/>
<xsl:param name="nextpos"/>

  <xsl:if test="($currpos mod 2) > 0">
  <TR>
<!--  First Column -->
  <xsl:if test="string-length(@calid) > 0">
  <TD align="center" bgcolor="{$bgcolor_form_selected}">
    <INPUT type="checkbox">
      <xsl:attribute name="checked"/>
      <xsl:attribute name="name">
        <xsl:value-of select="@calid"/>,<xsl:value-of select="@cn_size" />,<xsl:value-of select="@cn"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="@calid"/>
      </xsl:attribute>
    </INPUT>
  </TD>
  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:value-of select="@cn"/><xsl:text>&nbsp;</xsl:text>(<xsl:value-of select="@calid"/>)
    </FONT>
  </TD>
  </xsl:if>
<!--  Second Column -->
  <xsl:if test="string-length(../calID[$nextpos]/@calid) > 0">
  <TD align="center" bgcolor="{$bgcolor_form_selected}">
    <INPUT type="checkbox">
      <xsl:attribute name="checked"/>
      <xsl:attribute name="name">
        <xsl:value-of select="../calID[$nextpos]/@calid"/>,<xsl:value-of select="../calID[$nextpos]/@cn_size"/>,<xsl:value-of select="../calID[$nextpos]/@cn"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="../calID[$nextpos]/@calid"/>
      </xsl:attribute>
    </INPUT>
  </TD>
  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:value-of select="../calID[$nextpos]/@cn"/><xsl:text>&nbsp;</xsl:text>(<xsl:value-of select="../calID[$nextpos]/@calid"/>)
    </FONT>
  </TD>
  </xsl:if>

  </TR>
  </xsl:if>

</xsl:template>

<xsl:template name="output_already_selected">
  <xsl:if test="string-length(./directory_search/@selected_list) > 0">
  <BR/>
  <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
  <TR>
    <TD align="left" width="100%" colspan="4"><FONT size="{$font_size_big_2}" face="{$font_name}"><B>選択したユーザー</B></FONT></TD>
  </TR>
  <TR>
    <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
    <TD align="left"   width="49%"><FONT size="{$font_size_big_2}" face="{$font_name}">名前 (ユーザー ID)</FONT></TD>
    <xsl:choose>
      <xsl:when test="count(./directory_search/calID) > 1 ">
        <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
        <TD align="left"   width="49%"><FONT size="{$font_size_big_2}" face="{$font_name}">名前 (ユーザー ID)</FONT></TD>
      </xsl:when>
      <xsl:otherwise>
        <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
        <TD align="left"   width="49%"><FONT size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </xsl:otherwise>
    </xsl:choose>
  </TR>
  
  <xsl:for-each select="./directory_search/calID">
    <xsl:call-template name="output_selected_user">
      <xsl:with-param name="usernode" select="."/>
      <xsl:with-param name="currpos" select="position()"/>
      <xsl:with-param name="nextpos" select="position()+1"/>
    </xsl:call-template>
  </xsl:for-each>

  </TABLE>
  </xsl:if>
</xsl:template>

<xsl:template name="main">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="what" value=""/>
  <INPUT type="hidden" name="selected_list" value=""/>

  <xsl:choose>

    <xsl:when test="string-length(string(./directory_search/@error)) = 0">
    <!-- First Time -->
    </xsl:when> 

    <xsl:when test="./directory_search/@error != 0">
      <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
        <TR>
          <TD align="left" width="100%" colspan="5"><FONT size="{$font_size_big_2}" face="{$font_name}"><B>検索結果</B></FONT></TD>
        </TR>
        <TR>
          <TD align="left" width="100%" colspan="5">
            <FONT size="{$font_size_big_2}" face="{$font_name}">
              <xsl:text>&nbsp;&nbsp;</xsl:text>
              <xsl:call-template name="outputDirectoryLookupError">
                 <xsl:with-param name="directoryErrNum" select="./directory_search/@error"/>
	      </xsl:call-template>
            </FONT>
          </TD>
        </TR>
      </TABLE>
    </xsl:when> 

    <xsl:when test="./directory_search/@count > 0">
      <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
        <TR>
          <TD align="left" width="100%" colspan="5"><FONT size="{$font_size_big_2}" face="{$font_name}"><B>検索結果</B></FONT></TD>
        </TR>
        <xsl:if test="./directory_search/@limitedsearch">
          <TR>
            <TD align="left"   width="100%" colspan="5">
              <FONT size="{$font_size_big_2}" face="{$font_name}">
                <xsl:call-template name="limitedSearchMsg">
                  <xsl:with-param name="limit" select="./directory_search/@limitedsearch"/>
                </xsl:call-template>
                <BR/>
              </FONT>
            </TD>
          </TR>
        </xsl:if>
        <TR>
          <TD align="center" width="5"><FONT size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
          <TD align="left"   width="40%"><FONT size="{$font_size_big_2}" face="{$font_name}">名前</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_2}" face="{$font_name}">ユーザー ID</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_2}" face="{$font_name}">カレンダー ID</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_2}" face="{$font_name}">メール</FONT></TD>
        </TR>
        <xsl:for-each select="./directory_search/user">
         <TR>
          <TD align="center" bgcolor="{$bgcolor_form_selected}">
          <!-- type values
              USERTYPE_UNKNOWN  0
              USERTYPE_PERSON   1
              USERTYPE_RESOURCE 2
              USERTYPE_GROUP    3
          -->
            <FONT size="{$font_size_big}" face="{$font_name}">
              <xsl:choose>
              <xsl:when test="@selected = 1">
                <img src="imx/checkmark_skinny.gif"  width="13" height="21" />
              </xsl:when>
              <xsl:otherwise>
              <INPUT type="checkbox" >
                <xsl:choose>
                  <xsl:when test="@type = 3">
                    <xsl:attribute name="name"><xsl:value-of select="@groupname"/>,<xsl:value-of select="@cn_size"/>,<xsl:value-of select="@cn"/></xsl:attribute>
                  </xsl:when>
  
                  <xsl:when test="@type = 2">
                    <xsl:attribute name="name"><xsl:value-of select="@cn"/>,<xsl:value-of select="@cn_size"/>,<xsl:value-of select="@cn"/></xsl:attribute>
                  </xsl:when>
  
                  <xsl:otherwise>
                    <xsl:attribute name="name"><xsl:value-of select="@uid"/>,<xsl:value-of select="@cn_size"/>,<xsl:value-of select="@cn"/></xsl:attribute>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="@type = 3">
                    <xsl:attribute name="value"><xsl:value-of select="@groupname"/></xsl:attribute>
                  </xsl:when>
 
                  <xsl:when test="@type = 2">
                    <xsl:attribute name="value"><xsl:value-of select="@cn"/></xsl:attribute>
                  </xsl:when>
 
                  <xsl:otherwise>
                    <xsl:attribute name="value"><xsl:value-of select="@uid"/></xsl:attribute>
                  </xsl:otherwise>
                </xsl:choose>
              </INPUT>
              </xsl:otherwise>
              </xsl:choose>
            </FONT>
          </TD>
          <xsl:call-template name="output_person_cell">
            <xsl:with-param name="cell_gif">
              <xsl:choose>
                <xsl:when test="@type = 3">imx/group.gif</xsl:when>
                
                <xsl:when test="@type = 2">imx/32-conference.gif</xsl:when>

                <xsl:otherwise></xsl:otherwise>
              </xsl:choose>
             </xsl:with-param>
            <xsl:with-param name="cell_text"><xsl:value-of select="@cn"/></xsl:with-param>
           </xsl:call-template>
          <xsl:call-template name="output_table_cell"><xsl:with-param name="cell_text" select="@uid"/></xsl:call-template>
          <xsl:call-template name="output_table_cell"><xsl:with-param name="cell_text" select="@calid"/></xsl:call-template>
          <xsl:call-template name="output_table_cell"><xsl:with-param name="cell_text" select="@emailaddress"/></xsl:call-template>
         </TR>
        </xsl:for-each>
      </TABLE>
    </xsl:when> 
  
    <xsl:otherwise>
      <!--print no match found -->
      <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
        <TR>
          <TD align="left" width="100%"><FONT size="{$font_size_big_2}" face="{$font_name}"><B>検索結果</B></FONT></TD>
        </TR>
      <xsl:if test="./directory_search/@limitedsearch">
        <TR>
        <TD align="left" width="100%">
        <FONT size="{$font_size_big_2}" face="{$font_name}">
          <xsl:call-template name="limitedSearchMsg">
            <xsl:with-param name="limit" select="./directory_search/@limitedsearch"/>
          </xsl:call-template>
        <BR/>
        </FONT>
         </TD>
        </TR>
      </xsl:if>
        <TR>
        <TD align="left" width="100%">
<!-- l10n_ja -->
      <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:value-of select="./directory_search/@search"/>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:value-of select="$no_match_found_for_msg"/>
      </FONT>
<!-- end_of_l10n_ja -->
         </TD>
        </TR>
      </TABLE>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="output_already_selected"></xsl:call-template>
</FORM>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

