<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Include common printing XSL templates -->
<xsl:include href="common_printview.xsl"/>

<!-- We're sitting at the group[@name=main] level -->
<!-- regardless of the view type -->
<xsl:template name="print_root">
  <xsl:variable name="theview">
    <xsl:value-of select="/calendar/@viewname"/>
  </xsl:variable>

<HTML>
<HEAD>
  <TITLE>Sun Java[tm] System Calendar Express</TITLE>
</HEAD>
<BODY bgcolor="{$bgcolor_background}" marginwidth="9" marginheight="9">
<xsl:choose>
<xsl:when test="$theview='yearview'">
<CENTER>
  <TABLE border="0" cellpadding="2" cellspacing="8" width="100%">
    <TR>
<!-- Main data -->
      <TD valign="top">        
            <xsl:call-template name="print_yearview"/>
     </TD>
    </TR>
  </TABLE>
</CENTER>
</xsl:when>
<xsl:otherwise>
 <TABLE border="0" cellpadding="2" cellspacing="8" width="100%">
    <TR>
<!-- Main data -->
      <TD valign="top">
        <xsl:choose>
          <xsl:when test="$theview='overview'">
            <xsl:call-template name="print_overview"/>
          </xsl:when>
          <xsl:when test="$theview='dayview'">
            <xsl:call-template name="print_dayview"/>
          </xsl:when>
          <xsl:when test="$theview='weekview'">
            <xsl:call-template name="print_weekview"/>
          </xsl:when>
          <xsl:when test="$theview='monthview'">
            <xsl:call-template name="print_monthview"/>
          </xsl:when>
          <xsl:when test="$theview='groupview'">
            <xsl:call-template name="print_groupview"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="print_overview"/>
          </xsl:otherwise>
        </xsl:choose>
     </TD>
<!-- minical, except for yearview -->
       <TD nowrap="" valign="middle" align="center">
         <xsl:for-each select="panel/panel[@name='minical']/minical">
          <xsl:call-template name="printMinical"/>
         </xsl:for-each>
       </TD>
    </TR>
  </TABLE>
</xsl:otherwise>
</xsl:choose>

</BODY>
</HTML>
</xsl:template>


<xsl:template name="print_overview">
<!-- TABLE that holds 3 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleDayTimeHeader) -->
<!-- ROW2 = overview (uses panel[1]/panel/@name=singleDayView) -->
<!-- ROW3 = weekahead (uses panel[1]/panel/@name=weekahead) -->
<xsl:for-each select="panel[@name='overview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleDayTimeHeader']">
            <xsl:call-template name="printDateHeader"/>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='singleDayView']">
      <TR>
      <TD colspan="2">
       <TABLE border="2" bordercolor="#000000" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <xsl:apply-templates select="componentlist"/>
        </TR>
      </TABLE>
     </TD>
     </TR>
     </xsl:for-each>
     <xsl:for-each select="panel[@name='weekahead']">
      <TR>
      <TD colspan="2">
       <xsl:call-template name="weekaheadTemplate"/>        
      </TD>
      </TR>
     </xsl:for-each>

  </TABLE>
</xsl:for-each>
</xsl:template>

<xsl:template name="print_dayview">
<!-- TABLE that holds 2 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleDayTimeHeader) -->
<!-- ROW2 = dayview (uses panel[1]/panel/@name=singleDayView) -->
<xsl:for-each select="panel[@name='dayview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleDayTimeHeader']">
            <xsl:call-template name="printDateHeader"/>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='singleDayView']">
      <TR>
      <TD colspan="2">
       <TABLE border="2" bordercolor="#000000" cellpadding="3" cellspacing="1" width="100%">
        <TR>
          <xsl:apply-templates select="componentlist"/>
        </TR>
      </TABLE>
     </TD>
     </TR>
     </xsl:for-each>
  </TABLE>
</xsl:for-each>
</xsl:template>

<xsl:template name="print_weekview">
<!-- TABLE that holds 2 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleWeekTimeHeader) -->
<!-- ROW2 = dayview (uses panel[1]/panel/@name=weekgrid) -->
<xsl:for-each select="panel[@name='weekview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleWeekTimeHeader']">
            <xsl:call-template name="printDateHeader">
            <xsl:with-param name="format">weekview</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='weekgrid']">
      <TR>
        <TD colspan="2">
          <xsl:apply-templates select="weekcal"/>
        </TD>
      </TR>
     </xsl:for-each>
  </TABLE>
</xsl:for-each>
</xsl:template>

<xsl:template name="print_monthview">
<!-- TABLE that holds 2 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleMonthTimeHeader) -->
<!-- ROW2 = dayview (uses panel[1]/panel/@name=singleMonthView) -->
<xsl:for-each select="panel[@name='monthview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleMonthTimeHeader']">
            <xsl:call-template name="printDateHeader">
            <xsl:with-param name="format">monthview</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='singleMonthView']">
      <TR>
        <TD colspan="2" width="100%">
      <xsl:apply-templates select="monthcal"/>
        </TD>
      </TR>
     </xsl:for-each>
  </TABLE>
</xsl:for-each>
</xsl:template>

<xsl:template name="print_yearview">
<!-- TABLE that holds 2 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleYearTimeHeader) -->
<!-- ROW2 = dayview (uses panel[1]/panel/@name=singleYearView) -->
<xsl:for-each select="panel[@name='yearview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleYearTimeHeader']">
            <xsl:call-template name="printDateHeader">
            <xsl:with-param name="format">yearview</xsl:with-param>
            </xsl:call-template>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='singleYearView']">
      <TR>
        <TD colspan="2" align="center">
          <xsl:apply-templates select="yearcal"/>
         </TD>
      </TR>
     </xsl:for-each>

  </TABLE>
</xsl:for-each>
</xsl:template>

<xsl:template name="print_groupview">
<!-- TABLE that holds 2 rows -->
<!-- ROW1 = header info (uses panel[1]/panel/@name=singleDayTimeHeader) -->
<!-- ROW2 = dayview (uses panel[1]/panel/@name=singleDayView) -->
<xsl:for-each select="panel[@name='groupview-panel']">
  <TABLE border="0">
      <TR>
        <TD nowrap="">
          <xsl:for-each select="panel[@name='singleDayTimeHeader']">
            <xsl:call-template name="printDateHeader"/>
          </xsl:for-each>
        </TD>
        <TD align="right" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>現在のカレンダー:<xsl:text> </xsl:text></B>
           <xsl:choose>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedGroup"/>
             </xsl:when>
             <xsl:when test="(string-length(/calendar/usrctx/@selectedCalendar) > 0)">
               <xsl:value-of select="/calendar/usrctx/@selectedCalendar"/>
             </xsl:when>
           </xsl:choose>
         </FONT>
        </TD>
      </TR>

      <xsl:for-each select="panel[@name='singleDayView']">
    <TR>
    <TD colspan="2">
       <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
          <xsl:apply-templates select="availabilitylist"/>
       </TABLE>
    </TD>
    </TR>
     </xsl:for-each>
  </TABLE>
</xsl:for-each>
</xsl:template>



</xsl:stylesheet>
