<?xml version="1.0"  encoding="utf-8"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  タイトルなし
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">日曜日</xsl:if>
  <xsl:if test=".='2'">月曜日</xsl:if>
  <xsl:if test=".='3'">火曜日</xsl:if>
  <xsl:if test=".='4'">水曜日</xsl:if>
  <xsl:if test=".='5'">木曜日</xsl:if>
  <xsl:if test=".='6'">金曜日</xsl:if>
  <xsl:if test=".='7'">土曜日</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">日</xsl:if>
  <xsl:if test="$downum='2'">月</xsl:if>
  <xsl:if test="$downum='3'">火</xsl:if>
  <xsl:if test="$downum='4'">水</xsl:if>
  <xsl:if test="$downum='5'">木</xsl:if>
  <xsl:if test="$downum='6'">金</xsl:if>
  <xsl:if test="$downum='7'">土</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">1 月</xsl:if>
  <xsl:if test=".='02'">2 月</xsl:if>
  <xsl:if test=".='03'">3 月</xsl:if>
  <xsl:if test=".='04'">4 月</xsl:if>
  <xsl:if test=".='05'">5 月</xsl:if>
  <xsl:if test=".='06'">6 月</xsl:if>
  <xsl:if test=".='07'">7 月</xsl:if>
  <xsl:if test=".='08'">8 月</xsl:if>
  <xsl:if test=".='09'">9 月</xsl:if>
  <xsl:if test=".='10'">10 月</xsl:if>
  <xsl:if test=".='11'">11 月</xsl:if>
  <xsl:if test=".='12'">12 月</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">1 月</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">2 月</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">3 月</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">4 月</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">5 月</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">6 月</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">7 月</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">8 月</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">9 月</xsl:if>
  <xsl:if test="$MonthNum=10">10 月</xsl:if>
  <xsl:if test="$MonthNum=11">11 月</xsl:if>
  <xsl:if test="$MonthNum=12">12 月</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      入力した日時は無効です。修正してください。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      すでに同じ名前のカレンダーがあります。別の名前を指定してください。
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      すでに同じ名前のグループがあります。別の名前を指定してください。
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> to </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      この検索でディレクトリサーバーに問題が発生しました。&nbsp;
      別の検索文字列を指定してください。
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      一致した件数が多過ぎます。&nbsp;
      検索文字列をもっと詳しく指定してください。
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      ディレクトリサーバーに接続できませんでした。
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      ディレクトリサーバーに接続できませんでした。
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      この検索でディレクトリサーバーに問題が発生しました。&nbsp;
      別の検索文字列を指定してください。
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE エラー: 予定が削除されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE エラー: 実装はサポートされていません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE エラー: malloc に失敗しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE エラー: GSE の複数インスタンスを作成できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE エラー: GSE エントリが無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE エラー: 予定が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE エラー: トランスポートインタフェースが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE エラー: 出席者または開催者のカレンダーに出席者が見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE エラー: lock、GDisp などのリソースを作成できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE エラー: iCS ユーザーが必要ですが SMTP ユーザーを受け取りました
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE エラー: コンポーネントメソッドおよび状態が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE エラー: 要求した時刻は、既存の会議要求と重複しています
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB エラー: コンポーネントが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB エラー: 入出力エラー
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB エラー: 予定の 1 つまたは複数の値が無効です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB エラー: 機能呼び出しは、与えられたコンポーネントで使用できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB エラー: 要求したクエリーが不明であるか、サポートされていません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB エラー: 必要なパラメータが NULL であるか、設定されていないか、または存在しません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB エラー: 要求した SequenceNo の条件チェックが失敗したため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB エラー: 要求した変更時間の条件チェックが失敗したため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB エラー: カレンダーでは重複する予定は許可されないため、書き込みは中止されました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB エラー: ENS がエラーを返しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB エラー: 必要な値が NULL です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      出席依頼エラー: 引数が正しくありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      出席依頼エラー: カレンダーが見つかりません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      出席依頼エラー: カレンダーを使用できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      出席依頼エラー: カレンダーへのアクセス権がユーザーにありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      出席依頼エラー: グループがクリップされました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      出席依頼エラー: 開催者を削除できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      カレンダーエラー: カレンダーを作成できませんでした
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      カレンダーエラー: すでに同じ識別子を持つカレンダーがあります
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      カレンダーエラー: この操作を実行するために必要なアクセス権がありません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      カレンダーエラー: アクセスしようとしているカレンダーが存在しません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      カレンダーエラー: 不正なカレンダー ID です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      出席依頼エラー: 出席予定者をダブルブッキングできません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      カレンダーエラー: この操作を実行するために必要なアクセス権がありません。
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      カレンダーエラー: 所有者または共同所有者でなければ、この操作は実行できません。
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      カレンダーエラー: データベースは読み取り専用モードです。
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      空き時間を確認するには、予定の確認タブを参照してください。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      グループエラー: 不正なグループ ID です
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      カレンダーエラー: ユーザーが不明の場合はプライバシーまたは所有者リストには追加できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP エラー: メールホストがありません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP エラー: 接続に失敗しました
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP エラー: 接続への応答がありませんでした
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP エラー: メッセージを配信できません
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP エラー: 受信者がいません
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      エラー: バックエンドデータベースに接続できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      エラー: バックエンドデータベースの最大接続数に達しました。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      エラー: カレンダーを解決できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      エラー: バックエンドデータベース中に不正なデータがあります。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      エラー: DWP ホストのコンテキストが存在しません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      エラー: バックエンドホストを解決できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      エラー: データがありません - バックエンドデータベースに到達できません。
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      エラー: バックエンドデータベースに接続できません。
    </xsl:when>
    <xsl:otherwise>
      不明なエラー #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      エラー: 定期的な予定のある回が他の回を飛ばすことはできません。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      エラー: 定期的な予定の 2 つの回が同じ日に発生することはできません。
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      エラー: 定期的な予定の 1 つの回だけについてプライバシーを変更できません。
    </xsl:when>
    <xsl:otherwise>
      不明な定期的予定のエラー #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">アメリカ/アダック</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">アメリカ/アンカレッジ</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">アメリカ/ロサンゼルス</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">アメリカ/フェニックス</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">アメリカ/デンバー</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">アメリカ/コスタリカ</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">アメリカ/シカゴ</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">アメリカ/インディアナポリス</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">アメリカ/ニューヨーク</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">アメリカ/ハバナ</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">アメリカ/ポルトープランス</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">アメリカ/グランドターク</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">アメリカ/カラカス</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">アメリカ/クヤバ</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">アメリカ/ハリファックス</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">アメリカ/サンチアゴ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">大西洋地域/スタンリー</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">アメリカ/セントジョンズ</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">アメリカ/ブエノスアイレス</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">アメリカ/サンパウロ</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">アメリカ/ミクロン</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">アメリカ/ゴッドホープ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">大西洋地域/サウスジョージア島</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">大西洋地域/カーボベルデ</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">大西洋地域/アゾレス諸島</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">アフリカ/カサブランカ</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">ヨーロッパ/ロンドン</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">アフリカ/ラゴス</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">ヨーロッパ/パリ</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">アフリカ/トリポリ</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">ヨーロッパ/ワルシャワ</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">アフリカ/ヨハネスブルグ</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">ヨーロッパ/ブカレスト</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">ヨーロッパ/イスタンブール</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">アフリカ/カイロ</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">ヨーロッパ/リカ</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">アフリカ/ウィントフーク</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">ヨーロッパ/ミンスク</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">ヨーロッパ/シンフェロポリ</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">ヨーロッパ/モスクワ</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">ヨーロッパ/サマラ</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">アジア/ベイルート</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">アジア/エルサレム</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">アジア/アンマン</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">アジア/リヤド</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">アジア/テヘラン</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">アジア/イエレバン</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">アジア/シェフチェンコ</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">アジア/バクー</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">アジア/カブール</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">アジア/カラチ</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">アジア/アクチュビンスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">アジア/ビシュケク</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">アジア/スベルドロフスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">アジア/カルカッタ</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">アジア/カトマンズ</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">アジア/ダッカ</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">アジア/アルマアタ</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">アジア/ノボシビルスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">アジア/ラングーン</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">アジア/バンコク</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">アジア/クラスノヤルスク</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">アジア/ウランバートル</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">アジア/上海</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">アジア/台北</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">アジア/イルクーツク</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">アジア/東京</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">アジア/ソウル</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">アジア/ヤクーツク</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">オーストラリア/パース</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">オーストラリア/ダーウィン</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">オーストラリア/アデレード</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">オーストラリア/ブリスベン</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">オーストラリア/シドニー</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">オーストラリア/ホバート</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">アジア/ウラジオストク</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">オーストラリア/ロードハウ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">太平洋地域/ガダルカナル島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">太平洋地域/ヌーメア</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">アジア/マガダン</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">太平洋地域/ノーフォーク島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">太平洋地域/フィジー</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">太平洋地域/オークランド</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">アジア/カムチャツカ</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">太平洋地域/チャタム</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">太平洋地域/トンガタプ</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">アジア/アナディル</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">太平洋地域/キリティマティ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">太平洋地域/アピア</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">太平洋地域/ホノルル</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">太平洋地域/ラロトンガ島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">太平洋地域/マルケサス諸島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">太平洋地域/ガンビエル諸島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">太平洋地域/ピトケアン島</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">太平洋地域/イースター島</xsl:when> 
    <xsl:otherwise>
      タイムゾーン番号が不明です<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">終了日を指定しない </xsl:variable>
<xsl:variable name="cap_the_text"></xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> 削除</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>ようこそ </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>作業: </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@lastName"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>のカレンダー (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>開始時刻 </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 時間</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> 分</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>1 時間以上</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>の空き時間)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> 作成できる最大数: </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> 回</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>現在のカレンダーに、地域のタイムゾーンを 1 つ以上関連付けることができます。日別ビューなどのグリッド付きビューでは、カレンダーに関連付けられたすべてのタイムゾーンは、ビューの時間単位となります。カレンダーにタイムゾーンが関連付けられていない場合は、デフォルトのタイムゾーンが使用されます。次の地域では、以下のタイムゾーンが使用可能です。</xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>現在のカレンダーに、いずれかの地域のタイムゾーンを 1 つ関連付けることができます。日別ビューなどのグリッド付きビューでは、カレンダーに関連付けられたタイムゾーンは、ビューの時間単位となります。このカレンダーにタイムゾーンが関連付けられていない場合は、デフォルトのタイムゾーンが使用されます。次の地域では、以下のタイムゾーンが使用可能です。</xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>北米/南米 </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>ヨーロッパ/アフリカ </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>アジア/環太平洋 </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>地域:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>以下の予定が "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>" によって自分のカレンダーに追加されました。適切なオプションを選択して返信すると、この依頼に対して出席、欠席を指定できます。</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text></xsl:text>&nbsp;
  <B><xsl:text>「参照...」</xsl:text></B>&nbsp;
  <xsl:text>をクリックしてファイルを選択してください。</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>このフォームを使用して予定の出席依頼に対して出席 </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> するか、欠席 </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text>するか、あるいは後で確認 </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> のままにします。</xsl:text>
  <br/>
  <xsl:text>定期的な予定の場合は、この設定が予定全体に適用されます。</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>検索文字数が </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 文字より少ないと、正しく検索が行われない場合があります。正しい結果を得るには </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> 文字以上を指定するようにしてください。</xsl:text>

</xsl:template>


</xsl:stylesheet>
