<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Recherche d'agendas : Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="120,*,41">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='searchProperties'">
      <xsl:for-each select="group">
        <xsl:if test="@name='searchProperties'">
          <xsl:call-template name="search_toolbar"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="main"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (search_for_cals.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="search_toolbar">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0" onload="window.focus();parent.frames[0].document.forms[0].what.focus()">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:attribute name="onSubmit">
    document.forms[0]['find'].click();
    return false;
  </xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<CENTER>
  <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" height="10">
    <TR>
      <TD bgcolor="#000000"> 
        <TABLE width="100%"  border="0" cellpadding="3" cellspacing="1">
          <TR bgcolor="{$bgcolor_table_mid}"><TD width="1%" nowrap="" align="center" bgcolor="#FFCC00"><FONT face="{$font_name}" size="{$font_size_big_2}"><b><xsl:text>&nbsp;</xsl:text>Recherche d'agendas<xsl:text>&nbsp;</xsl:text></b></FONT></TD>
          <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
          </TR>
        </TABLE>
      </TD>
    </TR>

    <TR>
      <TD align="center">
        <TABLE border="0" cellpadding="0" cellspacing="1"> 
<!-- use a template for input so the elements can be moved around if req'd by localization -->          
          <xsl:call-template name="cal_search_input_template"/>
        </TABLE>
      </TD>
    </TR>
  </TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template name="output_selected_user">
<xsl:param name="usernode"/>
<xsl:param name="currpos"/>
<xsl:param name="nextpos"/>

  <xsl:if test="($currpos mod 2) > 0">
  <TR>
<!--  First Column -->
  <xsl:if test="string-length(@calid) > 0">
  <TD align="center" bgcolor="{$bgcolor_form_selected}">
    <INPUT type="checkbox">
      <xsl:attribute name="checked"/>
      <xsl:attribute name="name"><xsl:value-of select="@calid"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="@calid"/></xsl:attribute>
    </INPUT>
  </TD>
  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="@calid"/>
      </xsl:call-template>
    </FONT>
  </TD>
  </xsl:if>
<!--  Second Column -->
  <xsl:if test="string-length(../calID[$nextpos]/@calid) > 0">
  <TD align="center" bgcolor="{$bgcolor_form_selected}">
    <INPUT type="checkbox">
      <xsl:attribute name="checked"/>
      <xsl:attribute name="name"><xsl:value-of select="../calID[$nextpos]/@calid"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="../calID[$nextpos]/@calid"/></xsl:attribute>
    </INPUT>
  </TD>
  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:call-template name="printCalendarName">
        <xsl:with-param name="name" select="../calID[$nextpos]/@calid"/>
      </xsl:call-template>
    </FONT>
  </TD>
  </xsl:if>

  </TR>
  </xsl:if>

</xsl:template>


<xsl:template name="output_already_selected">
  <xsl:if test="string-length(./calsearchresults/@selected_list) > 0">
  <BR/>
  <BR/>
  <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
  <TR>
    <TD align="left" width="100%" colspan="4"><FONT size="{$font_size_big_3}" face="{$font_name}"><B>Agendas déjà sélectionnés</B></FONT></TD>
  </TR>
  <TR>
    <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
    <TD align="left"   width="49%"><FONT size="{$font_size_big_3}" face="{$font_name}">ID agenda</FONT></TD>
    <xsl:choose>
      <xsl:when test="count(./calsearchresults/calID) > 1 ">
        <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
        <TD align="left"   width="49%"><FONT size="{$font_size_big_3}" face="{$font_name}">ID agenda</FONT></TD>
      </xsl:when>
      <xsl:otherwise>
        <TD align="center" width="5"><xsl:text>&nbsp;</xsl:text></TD>
        <TD align="left"   width="49%"><FONT size="{$font_size_big_3}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </xsl:otherwise>
    </xsl:choose>
  </TR>

  <xsl:for-each select="./calsearchresults/calID">
    <xsl:call-template name="output_selected_user">
      <xsl:with-param name="usernode" select="."/>
      <xsl:with-param name="currpos" select="position()"/>
      <xsl:with-param name="nextpos" select="position()+1"/>
    </xsl:call-template>
  </xsl:for-each>

  </TABLE>
  </xsl:if>
</xsl:template>

<xsl:template name="output_table_cell">
  <xsl:param name="cell_text"/>
  <xsl:param name="view_command"/>
  <xsl:param name="show_status" select='0'/>

  <TD align="left" bgcolor="{$bgcolor_form_selected}">
    <FONT size="{$font_size_big_2}" face="{$font_name}">
      <xsl:choose>
        <xsl:when test="string($cell_text) = ''"><xsl:text>&nbsp;</xsl:text></xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="string-length($view_command) > 0">
              <A target="_blank">
                <xsl:attribute name="href">
                  <xsl:value-of select="$view_command"/>
                </xsl:attribute>
                <xsl:value-of select="$cell_text"/>
              </A>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$cell_text"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="(/calendar/group[@name='main']/formdata/@prevView = 'calendars') and ($show_status = 1) and (@subscribed='true')">
            <xsl:text>&nbsp;</xsl:text>(Subscribed)              
          </xsl:if>

        </xsl:otherwise>
      </xsl:choose>
    </FONT>
  </TD>
</xsl:template>


<xsl:template name="main">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="how" value="0"/>
  <INPUT type="hidden" name="which" value="name;calid"/>
  <INPUT type="hidden" name="what" value=""/>
  <INPUT type="hidden" name="selectedGroup"/>
  <INPUT type="hidden" name="selected_list" value=""/>

  <xsl:choose>
  <xsl:when test="(./calsearchresults/nomatch)">
    <!--print no match found -->
      <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
        <TR>
          <TD align="left" width="100%"><FONT size="{$font_size_big_3}" face="{$font_name}"><BR/><B>Résultats de la recherche</B></FONT></TD>
        </TR>
        <TR>
        <TD align="left" width="100%">
      <FONT size="{$font_size_big_2}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text>La recherche n'a donné aucun résultat</FONT>
         </TD>
        </TR>
      </TABLE>
  </xsl:when> 
  
  <xsl:otherwise>

    <TABLE border="0" align="center" cellpadding="1" cellspacing="2" width="99%">
    <xsl:if test="count(./calsearchresults/searchresultcal) > 0 ">
        <TR>
          <TD align="left" width="100%" colspan="5"><FONT size="{$font_size_big_3}" face="{$font_name}"><BR/><B>Résultats de la recherche</B></FONT></TD>
        </TR>
        <TR>
          <TD align="center" width="5"><FONT size="{$font_size_big_3}" face="{$font_name}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
          <TD align="left"   width="40%"><FONT size="{$font_size_big_3}" face="{$font_name}">ID agenda</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_3}" face="{$font_name}">Propriétaire</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_3}" face="{$font_name}">Nom de l'agenda</FONT></TD>
          <TD align="left"   width="20%"><FONT size="{$font_size_big_3}" face="{$font_name}">Description</FONT></TD>
        </TR>
    </xsl:if> 

    <xsl:for-each select="./calsearchresults/searchresultcal">
        <TR>
          <TD align="center" bgcolor="{$bgcolor_form_selected}">
            <FONT size="{$font_size_big}" face="{$font_name}">
              <xsl:choose>
                <xsl:when test="@selected = 1">
                  <img src="imx/checkmark_skinny.gif" width="13" height="21" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="(/calendar/group[@name='main']/formdata/@prevView = 'calendars') and (@subscribed='true')">
                      <img src="imx/checkmark_skinny.gif" width="13" height="21" />
                    </xsl:when>
                    <xsl:otherwise>
                      <INPUT type="checkbox" >
                        <xsl:attribute name="name">
                          <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="value">
                          <xsl:value-of select="@id"/>
                        </xsl:attribute>
                      </INPUT>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
            </FONT>
          </TD>

          <xsl:call-template name="output_table_cell">
            <xsl:with-param name="cell_text">
              <xsl:call-template name="printLimitedName">
                <xsl:with-param name="name" select="@id"/>
              </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="view_command" select="@viewCommand"/>
            <xsl:with-param name="show_status">1</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="output_table_cell"><xsl:with-param name="cell_text" select="@owner"/></xsl:call-template>
          <xsl:call-template name="output_table_cell">
            <xsl:with-param name="cell_text">
              <xsl:call-template name="printLimitedName">
                <xsl:with-param name="name" select="@name"/>
              </xsl:call-template>
            </xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="output_table_cell"><xsl:with-param name="cell_text" select="@description"/></xsl:call-template>
        </TR>
    </xsl:for-each> 
    </TABLE>
  </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="output_already_selected"></xsl:call-template>

</FORM>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>

