<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>
<xsl:include href="cal_timezones.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Modifier le groupe d'agendas : Sun Java[tm] System Calendar Express</TITLE>
    <!-- <script>window.resizeTo(700, 550);</script> -->
 
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="71,*,41">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>
<!--
            <xsl:when test="/calendar/@tab = 2">
              <xsl:call-template name="details_root"/>
            </xsl:when>
-->
            <xsl:when test="/calendar/@tab = 2">
              <xsl:call-template name="timezones_America_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./groupdata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 3">
              <xsl:call-template name="timezones_EuropeAfrica_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./groupdata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="/calendar/@tab = 4">
              <xsl:call-template name="timezones_AsiaPacific_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="./groupdata/@tzid"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (new_group.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="CreateGroupCalendarQuickAdd">
  <FONT face="{$font_name}" size="{$font_size_big_2}">
  <SELECT name="calgroup">
    <xsl:attribute name="onChange">return parent.CreateGroupQuickAdd(this.options, this.selectedIndex, this);</xsl:attribute>

    <OPTION value="">---Ajout rapide---<xsl:attribute name="selected"/></OPTION>
    <xsl:if test="(not(/calendar/usrctx/calendarList/calID[@name=/calendar/usrctx/@selectedCalendar])) and (not(/calendar/usrctx/usergroup[@name=/calendar/usrctx/@selectedGroup]))">
      <OPTION value="temporary" selected="" >
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="/calendar/usrctx/@selectedCalendar"/>
          </xsl:call-template>
      </OPTION>
    </xsl:if>
    <xsl:for-each select="/calendar/usrctx/calendarList/calID">
      <xsl:if test="not(@error)">
        <OPTION>
          <xsl:attribute name="value"><xsl:value-of select="./@name"/></xsl:attribute>
<!--
          <xsl:if test="/calendar/usrctx/@selectedCalendar = ./@name"><xsl:attribute name="selected"/></xsl:if>
-->
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="./@name"/>
            <xsl:with-param name="printname" select="./@printableName"/>
          </xsl:call-template>
        </OPTION>
      </xsl:if>
    </xsl:for-each>
    <OPTION value=""><xsl:text>________________________</xsl:text></OPTION>

    <xsl:for-each select="/calendar/usrctx/usergroup">
      <OPTION>
        <xsl:attribute name="value"><xsl:value-of select="./@members"/></xsl:attribute>
        <xsl:if test="../@selectedGroup = ./@name"><xsl:attribute name="selected"/></xsl:if>
         Groupe :<xsl:text> </xsl:text>
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
      </OPTION>
    </xsl:for-each>
  </SELECT>
  </FONT>
</xsl:template>

<xsl:template name="main_root">
<!--
  <xsl:variable name="Delete_Text">
    Êtes-vous sûr de vouloir supprimer cet agenda ?
  </xsl:variable>
-->

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
 <xsl:attribute name="onload">
    window.focus();
    <xsl:choose>
     <xsl:when test="string-length(./groupdata/@displayName) &gt; 0">
       document.forms[0].member.focus();
     </xsl:when>
     <xsl:otherwise>
       document.forms[0].displayName.focus();
     </xsl:otherwise>
    </xsl:choose>
  </xsl:attribute>

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="newCalDisplayName" />
  <INPUT type="hidden" name="newCalAddr" />
  <INPUT type="hidden" name="editOffset" />
  <INPUT type="hidden" name="calid_list" />
  <xsl:if test="./groupdata/@e_isNew = 1">
     <INPUT type="hidden" name="e_isNew" value="1"/>
  </xsl:if>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <TD><xsl:text>&nbsp;</xsl:text>
    </TD>
    <TD><xsl:text>&nbsp;</xsl:text>
    </TD>
  </TR>

  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>

  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Nom du groupe * <xsl:text>&nbsp;</xsl:text></B></FONT></TD>
    <TD valign="baseline"> <FONT face="{$font_name}" size="{$font_size_big_2}"> <INPUT type="text" name="displayName" size="38" >
        <xsl:choose>
          <xsl:when test="string-length(./groupdata/@displayName) &gt; 0">
            <xsl:attribute name="value">
              <xsl:value-of select="./groupdata/@displayName"/>
            </xsl:attribute>
          </xsl:when>
        </xsl:choose>
    </INPUT></FONT></TD>
  </TR>

  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"></FONT></TD>
    <TD valign="baseline">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <INPUT type="checkbox" name="dayViewUnmerged" align="left">
      <xsl:if test="./groupdata/@dayViewUnmerged=1">
        <xsl:attribute name="checked"/>
      </xsl:if>
      <xsl:attribute name="onClick">
        if (document.forms[0]['e_dayViewUnmerged']) {
          if (document.forms[0]['dayViewUnmerged'].value) {
            document.forms[0]['e_dayViewUnmerged'].value = '0';
          } else {
            document.forms[0]['e_dayViewUnmerged'].value = '1';
          }
        }
      </xsl:attribute>
    </INPUT>
    </FONT>
    <FONT face="{$font_name}" size="{$font_size_big_2}">
    <xsl:text>&nbsp;</xsl:text>Ouvrir le groupe en vue Journée (Par défaut, le groupe s'ouvre en vue de comparaison.)
    </FONT>
    </TD>  
  </TR>

    <TR>
      <TD colspan="1" align="right" valign="baseline" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <B>ID agenda</B><xsl:text>&nbsp;</xsl:text>
        </FONT>
      </TD>
      <TD colspan="1" align="left" valign="baseline" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <INPUT type="text" name="member" size="20"/> <xsl:text>&nbsp;&nbsp;</xsl:text>
          <INPUT type="button" name="Calid_add" value="Ajouter" width="52"  onClick="{button[@name='add_cal']}" />
        </FONT>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
         <INPUT type="button" name="Search" value="Rechercher..." width="52">
              <xsl:attribute name="onClick">
                <xsl:value-of select="command[@name='find_calendars']"/>
              </xsl:attribute>
         </INPUT>
         </FONT>
        <BR/>
        <FONT face="{$font_name}" size="{$font_size_big}">
          (Entrez l'ID agenda. Si vous ne le connaissez pas, cliquez sur Rechercher.)
        </FONT>
      </TD>
     </TR>

    <!--  Show the subscribed calendars and local groups(aliases) in a pulldown menu -->
    <TR>
      <TD align="right" valign="baseline"><xsl:text>&nbsp;</xsl:text></TD>
      <TD>
        <xsl:call-template name="CreateGroupCalendarQuickAdd"/>
      </TD>
     </TR>

    <TR>
      <TD align="right" valign="top"><FONT face="{$font_name}" size="{$font_size_big_2}"><b>Membres du groupe</b></FONT></TD>
      <TD valign="center"> 
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <select size="6" name="Group_Member_list" multiple="">
       <xsl:attribute name="onChange">
           var dialog = 'NewGroup';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
         <xsl:attribute name="onFocus">
           var dialog = 'NewGroup';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
         <xsl:for-each select="./groupdata/groupcal">
           <OPTION value="{@address}">
             <xsl:call-template name="printCalendarName">
               <xsl:with-param name="name" select="@address"/>
             </xsl:call-template>
           </OPTION>
         </xsl:for-each>
         <!-- To ensure the width of the field, add a blank, no value spacer item (30 underbars since &nbsp doesn't work) -->
         <!-- The value must be set to "" or the value is automatically set to the display name -->
        <OPTION value="">______________________________</OPTION>
        </select> <xsl:text>&nbsp;&nbsp;</xsl:text>
        <input type="button" name="Calid_Remove" value="Supprimer" onClick="{button[@name='remove_cal']}" width="52"/>
        </FONT>
      </TD>
    </TR>

    <TR>
      <TD align="left" colspan="2" >
        <FONT face="{$font_name}" size="{$font_size_big}" align="left">*&nbsp;Indique les informations requises.</FONT>
      </TD>
    </TR>

</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>

</xsl:template>

<xsl:template name="details_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
  <!-- Insert errors here-->
  <xsl:call-template name="emit_new_cal_or_group_errors"/>
  <TR>
    <TD colspan="2"><FONT face="{$font_name}" size="{$font_size_big}">
    Spécifiez ici une description de votre groupe. Vous pouvez également décider si la vue Journée de ce groupe présentera chacun des agendas séparément.</FONT></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD align="right" valign="top"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Description</B></FONT></TD>
    <TD valign="baseline">
      <TEXTAREA cols="42" rows="5" name="description" wrap="virtual">
        <xsl:value-of select="./groupdata/@description"/>
      </TEXTAREA>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD width="1%" align="right" valign="baseline" nowrap=""><FONT face="{$font_name}" size="{$font_size_big_2}"><B>Vue Journée</B></FONT></TD>
    <TD valign="baseline">
      <INPUT type="checkbox" name="dayViewUnmerged">
        <xsl:if test="./groupdata/@dayViewUnmerged=1">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_dayViewUnmerged']) {
            if (document.forms[0]['dayViewUnmerged'].value) {
              document.forms[0]['e_dayViewUnmerged'].value = '0';
            } else {
              document.forms[0]['e_dayViewUnmerged'].value = '1';
            }
          }
        </xsl:attribute>
      </INPUT>
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        Par défaut, les agendas apparaissent non fusionnés dans la vue Journée.
      </FONT>
    </TD>
  </TR>
</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>

</xsl:template>


<xsl:template name="button_root">

<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="ok" value="OK" width="72">
        <xsl:attribute name="onClick">

          var f = parent.frames[1].document.forms[0];

          if( ((f['i_tab'].value == '1') &amp;&amp; (f['displayName'].value == '')) ||
              ((f['i_tab'].value != '1') &amp;&amp; (f['e_displayName'].value == '')))  
          {
            alert('Vous devez fournir un nom pour le groupe');
          } else {
            f['myaction'].value='store';
            var x=f.submit();
          }

          jmain.close_child_windows(); 

        </xsl:attribute>
      </INPUT>
       <INPUT type="button" name="esc" value="Annuler" onClick="{./button[@name='cancel']}" width="72"/>
        <INPUT type="button" name="help" value="Aide" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000">
      <TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
        <TR bgcolor="{$bgcolor_table_mid}">
          <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Groupe d'agendas</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
          <!-- <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Détails</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template> -->
          <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:choose><xsl:when test="/calendar/@tab &gt;= 2">2</xsl:when><xsl:otherwise><xsl:value-of select="/calendar/@tab"/></xsl:otherwise></xsl:choose></xsl:with-param><xsl:with-param name="Name">Fuseaux horaires</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
          <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}">&nbsp;</FONT></TD>
        </TR>
      </TABLE>
    </TD>
  </TR>
</TABLE>

<xsl:call-template name="outputTimezoneTabs">
  <xsl:with-param name="timezone_tab">2</xsl:with-param>
</xsl:call-template>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
