<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"> <!ENTITY bullet "&#x2022;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:include href="javascript.xsl"/>

<xsl:variable name="usrctx" select="/calendar/usrctx"/>
<xsl:variable name="userprefs" select="$usrctx/userprefs"/>
<xsl:variable name="timectx" select="/calendar/group[@name='main']/panel[@name='miniview']/panel[@name='minical']/timectx"/>
<xsl:variable name="selectedTime" select="$timectx/SelectedTime"/>
<xsl:variable name="tzid" select="/calendar/timectx/@tzid"/>
<xsl:variable name="view" select="/calendar/@view"/>
<xsl:variable name="username" select="$usrctx/user/@name"/>

<xsl:variable name="display_string_cap">
 60 
</xsl:variable>

<xsl:variable name="font_name">
  <xsl:value-of select="$userprefs/@ceFontFace"/>
</xsl:variable>

<xsl:variable name="dateorder">
  <xsl:value-of select="$userprefs/@ceDateOrder"/>
</xsl:variable>
<xsl:variable name="dateseparator">
  <xsl:value-of select="$userprefs/@ceDateSeparator"/>
</xsl:variable>


<xsl:variable name="attendee_error_bgcolor">
#FFFF00
</xsl:variable>
<xsl:variable name="attendee_error_fgcolor">
#000000
</xsl:variable>

<xsl:variable name="ceColorSet">
  <xsl:value-of select="$userprefs/@pref_group_set"/>
</xsl:variable>
<xsl:variable name="ceFontSizeDelta">
  <xsl:value-of select="$userprefs/@ceFontSizeDelta"/>
</xsl:variable>
<xsl:variable name="bgcolor_brand">
  <xsl:value-of select="$userprefs/@ceBgColorBrand"/>
</xsl:variable>
<xsl:variable name="bgcolor_selected">
  <xsl:value-of select="$userprefs/@ceBgColorSelected"/>
</xsl:variable>
<xsl:variable name="bgcolor_table_border">
  <xsl:value-of select="$userprefs/@ceBgColorTableBorder"/>
</xsl:variable>
<xsl:variable name="bgcolor_table_top">
  <xsl:value-of select="$userprefs/@ceBgColorTableTop"/>
</xsl:variable>
<xsl:variable name="bgcolor_table_mid">
  <xsl:value-of select="$userprefs/@ceBgColorTableMid"/>
</xsl:variable>
<xsl:variable name="bgcolor_table_cell">
  <xsl:value-of select="$userprefs/@ceBgColorTableCell"/>
</xsl:variable>
<xsl:variable name="bgcolor_wend_top">
  <xsl:value-of select="$userprefs/@ceBgColorWendTop"/>
</xsl:variable>
<xsl:variable name="bgcolor_wend_mid">
  <xsl:value-of select="$userprefs/@ceBgColorWendMid"/>
</xsl:variable>
<xsl:variable name="bgcolor_wend_cell">
  <xsl:value-of select="$userprefs/@ceBgColorWendCell"/>
</xsl:variable>
<xsl:variable name="bgcolor_button">
  <xsl:value-of select="$userprefs/@ceBgColorButton"/>
</xsl:variable>
<xsl:variable name="bgcolor_form_selected">
  <xsl:value-of select="$userprefs/@ceBgColorFormSelected"/>
</xsl:variable>
<xsl:variable name="bgcolor_background">
  <xsl:value-of select="$userprefs/@ceBgColorBackground"/>
</xsl:variable>

<xsl:variable name="color_conflict">
  <xsl:value-of select="$userprefs/@color_conflict"/>
</xsl:variable>
<xsl:variable name="color_overdue">
  <xsl:value-of select="$userprefs/@color_overdue"/>
</xsl:variable>
<xsl:variable name="color_minical_text">
  <xsl:value-of select="$userprefs/@color_minical_text"/>
</xsl:variable>
<xsl:variable name="color_minical_shadow_text">
  <xsl:value-of select="$userprefs/@color_minical_shadow_text"/>
</xsl:variable>
<xsl:variable name="color_minical_bold_text">
  <xsl:value-of select="$userprefs/@color_minical_bold_text"/>
</xsl:variable>

<xsl:variable name="ErrorColor1">
  <xsl:value-of select="$userprefs/@ceErrorColor1"/>
</xsl:variable>
<xsl:variable name="ErrorColor2">
  <xsl:value-of select="$userprefs/@ceErrorColor2"/>
</xsl:variable>

<xsl:variable name="font_size_smaller">
  <xsl:value-of select="$userprefs/@font_size_smaller"/>
</xsl:variable>

<xsl:variable name="font_size_small">
  <xsl:value-of select="$userprefs/@font_size_small"/>
</xsl:variable>

<xsl:variable name="font_size_normal">
  <xsl:value-of select="$userprefs/@font_size_normal"/>
</xsl:variable>

<xsl:variable name="font_size_big">
  <xsl:value-of select="$userprefs/@font_size_big"/>
</xsl:variable>

<xsl:variable name="font_size_big_2">
  <xsl:value-of select="$userprefs/@font_size_big_2"/>
</xsl:variable>

<xsl:variable name="font_size_big_3">
  <xsl:value-of select="$userprefs/@font_size_big_3"/>
</xsl:variable>

<xsl:variable name="font_size_biggest">
  <xsl:value-of select="$userprefs/@font_size_biggest"/>
</xsl:variable>

<xsl:variable name="font_monospace">
  <xsl:value-of select="$userprefs/@font_monospace"/>
</xsl:variable>

<xsl:variable name="error_font_color">#FF0000</xsl:variable>

<xsl:template name="viewtabs">
<xsl:variable name="TabView">
  <xsl:value-of select="ancestor::group/@view"/>
</xsl:variable>

<TABLE border="0" cellpadding="0" cellspacing="0">
<TR>
<TD valign="top" align="center">
<xsl:call-template name="refreshtab"/>
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">
Vue :
</font><xsl:text>&nbsp;&nbsp;</xsl:text></TD>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="0">
  <TR>
  <TD nowrap="">
  <xsl:choose>
    <xsl:when test="$TabView='overview'">
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>aperçu</B><xsl:value-of select="$vert_divider"/></font>
      <xsl:call-template name="daytab"/>
      <xsl:call-template name="weektab"/>
      <xsl:call-template name="monthtab"/>
    </xsl:when>
    <xsl:when test="$TabView='dayview'">
      <xsl:call-template name="overtab"/>
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>jour</B><xsl:value-of select="$vert_divider"/></font>
      <xsl:call-template name="weektab"/>
      <xsl:call-template name="monthtab"/>
    </xsl:when>
    <xsl:when test="$TabView='weekview'">
      <xsl:call-template name="overtab"/>
      <xsl:call-template name="daytab"/>
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>semaine</B><xsl:value-of select="$vert_divider"/></font>
      <xsl:call-template name="monthtab"/>
    </xsl:when>
    <xsl:when test="$TabView='monthview'">
      <xsl:call-template name="overtab"/>
      <xsl:call-template name="daytab"/>
      <xsl:call-template name="weektab"/>
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>mois</B></font>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="overtab"/>
      <xsl:call-template name="daytab"/>
      <xsl:call-template name="weektab"/>
      <xsl:call-template name="monthtab"/>
    </xsl:otherwise>
  </xsl:choose>
  </TD>
  </TR>
  <TR>
  <TD nowrap="">
  <xsl:choose>
    <xsl:when test="$TabView='groupview'">
      <xsl:call-template name="yeartab"/>
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>comparaison</B></font>
    </xsl:when>
    <xsl:when test="$TabView='yearview'">
      <font face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B>année</B><xsl:value-of select="$vert_divider"/></font>
      <xsl:call-template name="comparison_tab"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="yeartab"/>
      <xsl:call-template name="comparison_tab"/>
    </xsl:otherwise>
  </xsl:choose>
  </TD>
  </TR>
</TABLE>
</TD>
</TR>
</TABLE>
</xsl:template>

<xsl:template name="overtab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='overview']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">aperçu</font></A>
<xsl:value-of select="$vert_divider"/>
</xsl:template>


<xsl:template name="refreshtab">
<xsl:if test="(string-length(command[@name='refresh']) > 0)">
  <A><xsl:attribute name="href"><xsl:value-of select="command[@name='refresh']"/></xsl:attribute>
  <font face="{$font_name}" size="{$font_size_big_2}" color="#000000">Refresh View</font></A>
  <xsl:text>&nbsp;&nbsp;</xsl:text>
</xsl:if>
</xsl:template>

<xsl:template name="daytab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='dayview']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">jour</font></A>
<xsl:value-of select="$vert_divider"/>
</xsl:template>

<xsl:template name="weektab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='weekview']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">semaine</font></A>
<xsl:value-of select="$vert_divider"/>
</xsl:template>

<xsl:template name="monthtab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='monthview']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">mois</font></A>
</xsl:template>

<xsl:template name="yeartab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='yearview']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">année</font></A>
<xsl:value-of select="$vert_divider"/>
</xsl:template>

<xsl:template name="comparison_tab">
<A><xsl:attribute name="href"><xsl:value-of select="command[@name='sidebyside']"/></xsl:attribute> 
<font face="{$font_name}" size="{$font_size_big_2}" color="#000000">comparaison</font></A>
</xsl:template>

<xsl:template match="minical">
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<TABLE border="0" cellpadding="1" cellspacing="0">
  <xsl:if test="$tzid != ''">
    <TR>
      <TD align="center">
        <font face="{$font_name}" size="{$font_size_big}"
	color="#000000">
	  <xsl:call-template name="getDisplayNameOfTZID">
	     <xsl:with-param name="tzid">
		 <xsl:value-of select="$tzid"/>
             </xsl:with-param>
          </xsl:call-template>
	</font><br />
      </TD>
    </TR>
  </xsl:if>
  <TR>
    <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="2" cellspacing="1" width="100%">
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
        <A><xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute>
        <IMG src="imx/prev_month.gif" width="11" height="11" border="0" alt="Passer au mois précédent" align="left"/>
        </A>
        <A><xsl:attribute name="href"><xsl:value-of select="command[2]"/></xsl:attribute>
        <IMG src="imx/next_month.gif" width="11" height="11" border="0" alt="Passer au mois suivant" align="right"/>
        </A>
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}"><xsl:apply-templates select="$timectx/StartTime/@month"/></FONT>
        </TD>
      </TR>
      <TR>
        <xsl:for-each select="Row[1]/Time">
          <TD align="center">
            <xsl:attribute name="bgcolor">
              <xsl:choose>
                <xsl:when test="(@dow=1) or (@dow=7)">
                  <xsl:value-of select="$bgcolor_wend_top"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$bgcolor_table_top"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
              <xsl:call-template name="short_dow">
                <xsl:with-param name="downum" select="@dow"/>
              </xsl:call-template>
            </FONT>
          </TD>
       </xsl:for-each>
      </TR>
      <xsl:for-each select="Row">
      <TR>
        <xsl:for-each select="Time">
          <TD align="right">
            <xsl:choose>
              <xsl:when test="$selectedTime/@month!=@month">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_border"/> 
                </xsl:attribute>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href">
                    <xsl:value-of select="command"/>
                  </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_shadow_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
                </A>
              </xsl:when>
              <xsl:when test="$selectedTime/@date=@date">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_selected"/> 
                </xsl:attribute>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href">
                    <xsl:value-of select="command"/>
                  </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_bold_text}">
                    <B><xsl:value-of select="@date"/></B>
                  </FONT>
                </A>
              </xsl:when>
              <xsl:when test="(@dow=1) or (@dow=7)">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_wend_mid"/>
                </xsl:attribute>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href">
                    <xsl:value-of select="command"/>
                  </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
                </A>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_mid"/>
                </xsl:attribute>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href">
                    <xsl:value-of select="command"/>
                  </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
                </A>
              </xsl:otherwise>
            </xsl:choose>
          </TD>
        </xsl:for-each>
      </TR>
      </xsl:for-each>
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
          <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
            Nous sommes le : <xsl:text>&nbsp;</xsl:text>
            <A>
              <xsl:attribute name="href">
                <xsl:value-of select="command[@name='today']"/>
              </xsl:attribute>
              <FONT color="{$color_minical_text}">
                <xsl:call-template name="brief_date">
                  <xsl:with-param name="Month">

                    <xsl:value-of select="$timectx/CurrTime/@month"/>
                  </xsl:with-param>
                  <xsl:with-param name="Day">
                    <xsl:value-of select="$timectx/CurrTime/@date"/>
                  </xsl:with-param>
                  <xsl:with-param name="Year">
                    <xsl:value-of select="$timectx/CurrTime/@year"/>
                  </xsl:with-param>
                </xsl:call-template>
              </FONT>
            </A>
          </FONT>
        </TD>
      </TR>
      <TR>
        <TD colspan="7" align="right" bgcolor="{$bgcolor_table_top}" nowrap="1">
        <TABLE border="0" cellpadding="2" cellspacing="1">
        <TR><TD nowrap="1">
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
        <xsl:call-template name="date_selector">
        <xsl:with-param name="month"/>
        <xsl:with-param name="day"/>
        <xsl:with-param name="year"/>
        <xsl:with-param name="checkFunction" select="'allowEmptyDateCheck'"/>
        </xsl:call-template>
        </FONT>
        <xsl:text>&nbsp;</xsl:text>
        <A href="javascript:jumpto_newdate();">
        <IMG src="imx/GoArrow13.gif" width="12" height="12" align="absmiddle" border="0" alt="Atteindre cette date"/>
        </A>
        </TD></TR>
        </TABLE>
        </TD>
      </TR>
    </TABLE>
    </TD>
</TR>
<TR>
  <TD>
    <IMG src="imx/spacer.gif" width="1" height="1" vspace="4"/>
  </TD>
</TR>
</TABLE>
</xsl:template>

<xsl:template name="tasktable">
    <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
      <TR>
        <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="2" cellspacing="1" width="100%">
          <TR>
            <TD colspan="2" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">À faire</FONT></TD>
          </TR>
          <TR>
            <xsl:choose>
              <xsl:when test="/calendar/group[@name='main']/invitationslist/@compresscount > 0">
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:text>&bullet;</xsl:text></FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}">
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}">
                    <A>
                      <xsl:attribute name="href">
                        <xsl:value-of select="command[@name='invitations_list']"/>
                      </xsl:attribute>
                      Invitations<xsl:text>&nbsp;</xsl:text>(<xsl:value-of select="/calendar/group[@name='main']/invitationslist/@compresscount"/>)
                    </A>
                  </FONT>
                </TD>
              </xsl:when>
              <xsl:otherwise>
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_cell}"><xsl:text>&bullet;</xsl:text></FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}">Aucune invitation</FONT></TD>
              </xsl:otherwise>
            </xsl:choose>
          </TR>
          <TR>
            <xsl:choose>
              <xsl:when test="./tasklist/@taskcount > 0">
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:text>&bullet;</xsl:text></FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}">
                  <FONT face="{$font_name}" size="{$font_size_big}">
                    <A>
                      <xsl:attribute name="href">
                        <xsl:value-of select="command[@name='task_list']"/>
                      </xsl:attribute>
                      Tâches<xsl:text> </xsl:text>
                      (
                      <xsl:value-of select="./tasklist/@taskcount"/>
                      )
                      <xsl:text> </xsl:text>
                    </A>
                    <xsl:text>&nbsp;</xsl:text>
                    <xsl:value-of select="./tasklist/@overduetaskcount"/><xsl:text>&nbsp;</xsl:text>en retard
                  </FONT>
                </TD>
              </xsl:when>
              <xsl:otherwise>
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_cell}">*</FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}">Aucune tâche</FONT></TD>
              </xsl:otherwise>
            </xsl:choose>
          </TR>
          <TR>
            <xsl:choose>
              <xsl:when test="/calendar/group[@name='main']/errorslist/@count > 0">
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:text>&bullet;</xsl:text></FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}">
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}">
                    <A>
                      <xsl:attribute name="href">
                        <xsl:value-of select="command[@name='errors_list']"/>
                      </xsl:attribute>
                      Erreurs<xsl:text>&nbsp;</xsl:text>(<xsl:value-of select="/calendar/group[@name='main']/errorslist/@count"/>)
                    </A>
                  </FONT>
                </TD>
              </xsl:when>
              <xsl:otherwise>
                <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_cell}"><xsl:text>&bullet;</xsl:text></FONT></TD>
                <TD bgcolor="{$bgcolor_table_cell}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_mid}">Aucune erreur</FONT></TD>
              </xsl:otherwise>
            </xsl:choose>
          </TR>
            <xsl:if test="(string-length($usrctx/@selectedGroup) > 0)">
              <xsl:if test="count($usrctx/usergroup[@name=$usrctx/@selectedGroup]/calID) > 0">
                <xsl:for-each select="$usrctx/usergroup[@name=$usrctx/@selectedGroup]/calID">
                <xsl:variable name="calName">
                  <xsl:value-of select="@name"/>
                </xsl:variable>
                <xsl:for-each select="/calendar/DWPErrorList/DWPNode">
                  <xsl:if test="$calName=@DWPCalID">
                   <TR>
                    <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_cell}"><xsl:text>&bullet;</xsl:text></FONT></TD>
                    <TD bgcolor="{$bgcolor_table_cell}">
                      <FONT face="{$font_name}" size="{$font_size_big}" color="{$ErrorColor1}">
                        <xsl:value-of select="$calName"/><xsl:text>&nbsp;</xsl:text>
                        est défaillant<xsl:text>&nbsp;</xsl:text>
                      </FONT>
                    </TD>
                   </TR>
                  </xsl:if>
                </xsl:for-each>
                </xsl:for-each>
              </xsl:if>
            </xsl:if>
            
            <xsl:if test="(string-length($usrctx/@selectedCalendar) > 0)">
              <xsl:if test="count(/calendar/DWPErrorList/DWPNode) > 0">
                <xsl:for-each select="/calendar/DWPErrorList/DWPNode">
                 <TR>
                  <TD align="center" bgcolor="{$bgcolor_table_mid}"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_table_cell}"><xsl:text>&bullet;</xsl:text></FONT></TD>
                  <TD bgcolor="{$bgcolor_table_cell}">
                    <FONT face="{$font_name}" size="{$font_size_big}" color="{$ErrorColor1}">
                      <xsl:value-of select="@DWPCalID"/><xsl:text>&nbsp;</xsl:text>
                      est défaillant<xsl:text>&nbsp;</xsl:text>
                    </FONT>
                  </TD>
                 </TR>
                </xsl:for-each>
              </xsl:if>
            </xsl:if>
        </TABLE></TD>
      </TR>
      <TR>
        <TD>
          <IMG src="imx/spacer.gif" width="1" height="1" vspace="4"/>
        </TD>
      </TR>
    </TABLE>
</xsl:template>


<xsl:template name="load_tabs">
<script>
function loadtab(i, u, newView)
{
  var f = parent.frames[1].document.forms[0];
  f['i_tabswitch'].value = i;
  f['type'].value = newView;
  f.submit();
  window.location = u;
}
</script>
</xsl:template>

<xsl:template name="attendee_long_item">
  <xsl:param name="attendee"/>
  <td width="1%" valign="baseline">
    <FONT face="{$font_monospace}" size="{$font_size_big_2}">
      <xsl:if test="$attendee/@RSVP = 'TRUE'">
        <xsl:choose>
          <xsl:when test="$attendee/@partstat='1'">?</xsl:when>
          <xsl:when test="$attendee/@partstat='2'">+</xsl:when>
          <xsl:when test="$attendee/@partstat='3'">-</xsl:when>
          <xsl:when test="$attendee/@partstat='4'">?</xsl:when>
          <xsl:otherwise>*</xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:if test="$attendee/@RSVP != 'TRUE'"><xsl:text>&nbsp;</xsl:text></xsl:if>
    </FONT>
  </td>
  <td width="49%" valign="baseline">
    <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="$attendee/@CN"/>
          <xsl:with-param name="printname" select="$attendee/@userid"/>
        </xsl:call-template>
    </FONT>
  </td>
</xsl:template>

<xsl:template name="attendee_long">
  <xsl:param name="event"/>
  <xsl:if test="count($event/attendee) = 0">Aucun participant</xsl:if>
  <xsl:if test="count($event/attendee) > 0">
    <table border="0" cellpadding="0" cellspacing="1">
      <xsl:for-each select="$event/attendee[@RSVP = 'TRUE']">
        <tr>
          <xsl:call-template name="attendee_long_item"><xsl:with-param name="attendee" select="."/></xsl:call-template>
        </tr>
      </xsl:for-each>

      <tr><td><xsl:text>&nbsp;</xsl:text></td></tr>

      <xsl:for-each select="$event/attendee[@RSVP != 'TRUE']">
        <tr>
          <xsl:call-template name="attendee_long_item"><xsl:with-param name="attendee" select="."/></xsl:call-template>
        </tr>
      </xsl:for-each>
    </table>
   </xsl:if>
</xsl:template>

<xsl:template match="formdata">
  <xsl:for-each select="@*">
    <input>
      <xsl:attribute name="type">hidden</xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="name(.)"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
    </input>
  </xsl:for-each>
</xsl:template>

<xsl:template name="outputErrorString">
  <xsl:param name="ErrorString"/>

  <xsl:if test="string-length($ErrorString) > 0">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}"><xsl:value-of select="$ErrorString"/></FONT><BR/>
  </xsl:if>
</xsl:template>

<xsl:template name="outputSpecificError">
  <xsl:param name="Type"/>

  <xsl:call-template name="outputErrorString">
    <xsl:with-param name="ErrorString">
      <xsl:call-template name="findErrorString">
        <xsl:with-param name="ErrorType">
          <xsl:value-of select="/calendar/error[@type=$Type]/@type"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="recurrenceString">
  <xsl:param name="e_rrule_daily"/>
  <xsl:param name="e_rrule_weekly"/>
  <xsl:param name="e_rrule_monthly"/>
  <xsl:param name="e_rrule_yearly"/>

  <xsl:choose>
    <xsl:when test="string-length($e_rrule_daily) &gt; 0">
      Quotidienne
    </xsl:when>
    <xsl:when test="string-length($e_rrule_weekly) &gt; 0">
      Hebdomadaire
    </xsl:when>
    <xsl:when test="string-length($e_rrule_monthly) &gt; 0">
      Mensuelle
    </xsl:when>
    <xsl:when test="string-length($e_rrule_yearly) &gt; 0">
      Annuelle
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="CalendarGroupSelector">
  <FONT face="{$font_name}" size="{$font_size_big}">
  <SELECT name="calgroup">
    <xsl:attribute name="onChange">return parent.GroupSelect(this.options, this.selectedIndex, this);</xsl:attribute>

    <xsl:if test="(not($usrctx/calendarList/calID[@name=$usrctx/@selectedCalendar])) and (not($usrctx/usergroup[@name=$usrctx/@selectedGroup]))">
      <OPTION value="temporary" selected="" >
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="$usrctx/@selectedCalendar"/>
            <xsl:with-param name="printname" select="/calendar/usrctx/@printableName"/>
          </xsl:call-template>
      </OPTION>
    </xsl:if>
    <xsl:for-each select="$usrctx/calendarList/calID">
      <xsl:if test="(not(@error)) and (not(@displaypermission))">
        <OPTION>
          <xsl:attribute name="value">cal-<xsl:value-of select="./@name"/>;<xsl:value-of select="./@modtime"/></xsl:attribute>
          <xsl:if test="$usrctx/@selectedCalendar = ./@name"><xsl:attribute name="selected"/></xsl:if>
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="./@name"/>
            <xsl:with-param name="printname" select="./@printableName"/>
          </xsl:call-template>
        </OPTION>
      </xsl:if>
    </xsl:for-each>
    <OPTION value=""><xsl:text>________________________</xsl:text></OPTION>

    <xsl:for-each select="$usrctx/usergroup">
      <OPTION>
        <xsl:attribute name="value">group-<xsl:value-of select="./@name"/>;<xsl:value-of select="./@modtime"/></xsl:attribute>
        <xsl:if test="../@selectedGroup = ./@name"><xsl:attribute name="selected"/></xsl:if>
        Groupe :<xsl:text> </xsl:text>
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="./@name"/>
        </xsl:call-template>
      </OPTION>
    </xsl:for-each>
  </SELECT>
  </FONT>
</xsl:template>

<xsl:template name="emit_frame_head_tag">
<HEAD>
<SCRIPT> 
var jmain = parent; 
var form_submitted = '0';

function imagesoff() {
  if (document.images)
  {
    document.homepage.src = homepageoff.src;
    document.documentation.src = documentationoff.src;
    document.userlogout.src = userlogoutoff.src;
  }
}

function imageon(imgName) {
  if (document.images) {
    document[imgName].src = eval(imgName + "on.src");
  }
}

function over(imgName) {
  document[imgName].src= eval(imgName + "over.src");
}

function out(imgName) {
  document[imgName].src= eval(imgName + "off.src");
}

</SCRIPT>

<!-- <xsl:call-template name="javascript"/> -->
<SCRIPT SRC="javascript.js">alert('NotFound!');</SCRIPT>
<BASE><xsl:attribute name="href"><xsl:value-of select="/calendar/@staticBaseURL" /><xsl:text>/</xsl:text></xsl:attribute></BASE>
</HEAD>
</xsl:template>

</xsl:stylesheet>
