<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Sin título
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Domingo</xsl:if>
  <xsl:if test=".='2'">Lunes</xsl:if>
  <xsl:if test=".='3'">Martes</xsl:if>
  <xsl:if test=".='4'">Miércoles</xsl:if>
  <xsl:if test=".='5'">Jueves</xsl:if>
  <xsl:if test=".='6'">Viernes</xsl:if>
  <xsl:if test=".='7'">Sábado</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">D</xsl:if>
  <xsl:if test="$downum='2'">L</xsl:if>
  <xsl:if test="$downum='3'">M</xsl:if>
  <xsl:if test="$downum='4'">Mi</xsl:if>
  <xsl:if test="$downum='5'">M</xsl:if>
  <xsl:if test="$downum='6'">V</xsl:if>
  <xsl:if test="$downum='7'">D</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Ene</xsl:if>
  <xsl:if test=".='02'">Feb</xsl:if>
  <xsl:if test=".='03'">Marzo</xsl:if>
  <xsl:if test=".='04'">Abril</xsl:if>
  <xsl:if test=".='05'">Mayo</xsl:if>
  <xsl:if test=".='06'">Junio</xsl:if>
  <xsl:if test=".='07'">Julio</xsl:if>
  <xsl:if test=".='08'">Ago</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Oct</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dic</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Ene</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Feb</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mar</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Abr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mayo</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Jun</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Jul</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Ago</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Oct</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dic</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Enero</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Febrero</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Marzo</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Abril</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mayo</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Junio</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Julio</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Agosto</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Septiembre</xsl:if>
  <xsl:if test="$MonthNum=10">Octubre</xsl:if>
  <xsl:if test="$MonthNum=11">Noviembre</xsl:if>
  <xsl:if test="$MonthNum=12">Diciembre</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      La fecha y la hora especificadas no son válidas. Corríjalas.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Ya existe un calendario con este nombre. Seleccione otro nombre.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Ya existe un grupo con este nombre. Seleccione otro nombre.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> hasta </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Se ha producido un problema en el servidor de directorios al realizar esta búsqueda.&nbsp; Especifique otra cadena de búsqueda.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp; Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp;      Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Esta búsqueda ha obtenido demasiados resultados.&nbsp; Especifique otra cadena de búsqueda más detallada.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      No se ha podido establecer una conexión con el servidor de directorios.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      No se ha podido establecer una conexión con el servidor de directorios.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Se ha producido un problema en el servidor de directorios al realizar esta búsqueda.&nbsp; Especifique otra cadena de búsqueda.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      Error de GSE: se ha eliminado un evento.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      Error de GSE: la implementación no se admite.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      Error de GSE: error en la función de asignación de memoria (malloc).
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      Error de GSE: no se pueden crear varias instancias de GSE.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      Error de GSE: la entrada de GSE no es válida.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      Error de GSE: el evento no es válido.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      Error de GSE: no se encuentra la interfaz de transporte.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      Error de GSE: no se encuentra un asistente en el organizador del calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      Error de GSE: no se pueden crear recursos como, por ejemplo, lock, GDisp, etc.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      Error de GSE: se espera un usuario iCS, en lugar de uno SMTP.
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      Error de GSE: el método del componente y su estado no son válidos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      Error de GSE: la hora solicitada está en conflicto con otra solicitud de reunión existente.
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      Error de base de datos: no se encuentra el componente.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      Error de base de datos: error de E/S.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      Error de base de datos: uno o varios de los valores del evento no son válidos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      Error de base de datos: la funcion de llamada (call) no funciona en el componente proporcionado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      Error de base de datos: la consulta solicitada no se admite o es desconocida.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      Error de base de datos: un parámetro requerido es NULO, no está definido o no está presente.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      Error de base de datos: la escritura se anuló porque la condición SequenceNo solicitada ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      Error de base de datos: la escritura se anuló porque la condición de modificación de tiempo solicitada ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      Error de base de datos: la escritura se anuló porque el calendario no permite citas que se superpongan.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      Error de base de datos: la notificación ENS devolvió un error.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      Error de base de datos: un valor requerido es nulo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Error de invitado: el argumento es erróneo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Error de invitado: no se encuentra el calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Error de invitado: el calendario está deshabilitado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Error de invitado: el usuario no puede acceder al calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Error de invitado: el grupo está cortado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Error de invitado: no se puede eliminar el organizador.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Error de calendario: ha fallado la creación del calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Error de calendario: ya hay un calendario con el mismo identificador.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Error de calendario: el usuario no tiene los derechos de acceso necesarios para realizar esta operación.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Error de calendario: el usuario está intentando acceder a un calendario que no existe.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Error de calendario: el identficador del calendario es ilegal.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Error de invitado: no se pueden hacer dos reservas para un invitado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Error de calendario: el usuario no tiene los derechos de acceso necesarios para realizar esta operación.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Error de calendario: el usuario debe ser propietario o co-propietario para realizar esta acción.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Error de calendario: la base de datos está en modo de solo lectura.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Consulte la ficha de disponibilidad para buscar tiempo libre.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Error de grupo: el identificador del grupo es ilegal.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Error de calendario: no se puede agregar un usuario desconocido a la lista privada o a la lista del propietario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      Error de SMTP: no hay host de correo.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      Error de SMTP: la conexión ha fallado.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      Error de SMTP: no se ha producido la respuesta esperada de conexión.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      Error de SMTP: se ha producido un problema al enviar el mensaje.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      Error de SMTP: no hay destinatario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Error: ha fallado la conexión a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Error: se ha alcanzado el máximo de conexiones a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Error: no es posible resolver el calendario.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Error: no se puede acceder a la base de datos de fondo (backend) con datos erróneos.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Error: el contexto del host DWP no está disponible.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Error: el host de fondo (backend) no se puede resolver.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Error: no hay datos y no se puede acceder a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Error: ha fallado la conexión a la base de datos de fondo (backend).
    </xsl:when>
    <xsl:otherwise>
      Desconocido error #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Error: una instancia recurrente no puede superponerse a otra.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Error: dos instancias recurrentes no pueden ocurrir en el mismo día.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Error: no se puede cambiar la privacidad de una instancia sola.
    </xsl:when>
    <xsl:otherwise>
      Error de recurrencia desconocido #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">América/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">América/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">América/Los Ángeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">América/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">América/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">América/Costa Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">América/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">América/Indianápolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">América/Nueva York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">América/La Habana</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">América/Puerto Príncipe</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">América/Grand Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">América/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">América/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">América/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">América/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlántico/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">América/St. Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">América/Buenos Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">América/Sao Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">América/Miquelón</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">América/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlántico/Georgia del Sur</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlántico/Cabo Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlántico/Azores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">África/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europa/Londres</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">África/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europa/París</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">África/Trípoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europa/Varsovia</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">África/Johannesburgo</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europa/Bucarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europa/Estambul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">África/El Cairo</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europa/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">África/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europa/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europa/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europa/Moscú</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europa/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asia/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asia/Jerusalén</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asia/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asia/Riyadh</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asia/Teherán</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asia/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asia/Aqtau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asia/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asia/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asia/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asia/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asia/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asia/Yekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asia/Calcuta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asia/Katmandú</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asia/Dhaka</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asia/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asia/Novosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asia/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asia/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asia/Krasnoyarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asia/Ulan Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asia/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asia/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asia/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asia/Tokio</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asia/Seúl</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asia/Yakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australia/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australia/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australia/Adelaida</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australia/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australia/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australia/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asia/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australia/Lord Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacífico/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacífico/Noumea</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asia/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacífico/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacífico/Fiyi</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacífico/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asia/Kamchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacífico/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacífico/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asia/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacífico/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacífico/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacífico/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacífico/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacífico/Marquesas</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacífico/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacífico/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacífico/Pascua</xsl:when> 
    <xsl:otherwise>
      Desconocido zona horaria #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Sin fecha final </xsl:variable>
<xsl:variable name="cap_the_text">El </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Eliminar</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Bienvenido/a  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tareas para </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>el calendario de</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Iniciar a las </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 hora</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutos</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Más de 1 hora</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> (disponible)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Crea un máximo de </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instancias</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Se puede asociar una o más zonas horarias de cualquier región con el calendario actual. En vistas de rejilla como la vista del día, todas las zonas horarias asociadas con el calendario pasan a formar parte de la escala horaria de la vista. Si no se especifica ninguna zona horaria con este calendario, se utilizará la zona horaria predeterminada. Las zonas horarias siguientes están disponibles en la región </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Se puede asociar una zona horaria de cualquier región con el calendario actual. En vistas de rejilla como la vista del día, la zona horaria asociada con el calendario pasa a formar parte de la escala horaria de la vista. Si no se especifica ninguna zona horaria con este calendario, se utilizará la zona horaria predeterminada. Las zonas horarias siguientes están disponibles en la </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>América del Norte/América del Sur </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europa/África </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asia/Pacífico Sur </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>región:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>El siguiente evento lo ha agregado a su calendario "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Puede aceptar o rechazar esta invitación seleccionando la opción adecuada para responder.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Haga clic en</xsl:text>&nbsp;
  <B><xsl:text>Examinar...</xsl:text></B>&nbsp;
  <xsl:text>para seleccionar un archivo.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Use este panel para aceptar, </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> rechazar </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> o dejar sin respuesta </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> invitaciones a eventos.</xsl:text>
  <br/>
  <xsl:text>En el caso de los eventos recurrentes, la configuración se aplicará a toda la secuencia.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Los resultados de una búsqueda con menos de </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caracteres puede que no esté completo. Para obtener mejores resultados, use como mínimo </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> caracteres.</xsl:text>

</xsl:template>


</xsl:stylesheet>
