<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>
<xsl:include href="cal_timezones.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

  <xsl:choose>
    <xsl:when test="@top='true'">
      <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
      <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
      <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

      <HTML>
      <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>
      <TITLE>Cambiar la zona horaria predeterminada: Sun Java[tm] System Calendar Express</TITLE>
      </HEAD>
      <FRAMESET border="0" frameborder="0" rows="40,*,40">
        <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
        <FRAME name="main" frameborder="0" src="{$Frame2}"/>
        <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
      </FRAMESET>
      </HTML>
    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group[@name='tabs']">
        <xsl:call-template name="tabs_root"/>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">

          <xsl:choose>

            <xsl:when test="$tab_value = 1">
              <xsl:call-template name="timezones_America_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="$tab_value = 2">
              <xsl:call-template name="timezones_EuropeAfrica_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:when test="$tab_value = 3">
              <xsl:call-template name="timezones_AsiaPacific_root">
                <xsl:with-param name="multiSelect">0</xsl:with-param>
                <xsl:with-param name="selectedTZID">
                  <xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (change_timezone.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">

<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <INPUT type="button" name="ok" value="Aceptar" width="72">
          <xsl:attribute name="onClick">submitTimeZoneChange();</xsl:attribute>
        </INPUT>
        <INPUT type="button" name="esc" value="Cancelar" onClick="{./button[@name='cancel']}" width="72"/> 
        <INPUT type="button" name="help" value="Ayuda" onClick="{./button[@name='help']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">América del Norte/América del Sur</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">2</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name">Europa/África</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[2]"/></xsl:with-param></xsl:call-template>
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">3</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:choose><xsl:when test="/calendar/@tab &gt;= 3">3</xsl:when><xsl:otherwise><xsl:value-of select="/calendar/@tab"/></xsl:otherwise></xsl:choose></xsl:with-param><xsl:with-param name="Name">Asia/Pacífico Sur</xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[3]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}">
          <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>
          </FONT>
        </TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
