<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Ohne Titel
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Sonntag</xsl:if>
  <xsl:if test=".='2'">Montag</xsl:if>
  <xsl:if test=".='3'">Dienstag</xsl:if>
  <xsl:if test=".='4'">Mittwoch</xsl:if>
  <xsl:if test=".='5'">Donnerstag</xsl:if>
  <xsl:if test=".='6'">Freitag</xsl:if>
  <xsl:if test=".='7'">Samstag</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">S</xsl:if>
  <xsl:if test="$downum='2'">M</xsl:if>
  <xsl:if test="$downum='3'">D</xsl:if>
  <xsl:if test="$downum='4'">M</xsl:if>
  <xsl:if test="$downum='5'">D</xsl:if>
  <xsl:if test="$downum='6'">f</xsl:if>
  <xsl:if test="$downum='7'">S</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Jan</xsl:if>
  <xsl:if test=".='02'">Februar</xsl:if>
  <xsl:if test=".='03'">März</xsl:if>
  <xsl:if test=".='04'">April</xsl:if>
  <xsl:if test=".='05'">Mai</xsl:if>
  <xsl:if test=".='06'">Juni</xsl:if>
  <xsl:if test=".='07'">Juli</xsl:if>
  <xsl:if test=".='08'">Aug</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Okt</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dez</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Jan</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Februar</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">März</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Apr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juni</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juli</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Aug</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Okt</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dez</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Januar</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Februar</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">März</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">April</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">Mai</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Juni</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Juli</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">August</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">September</xsl:if>
  <xsl:if test="$MonthNum=10">Oktober</xsl:if>
  <xsl:if test="$MonthNum=11">November</xsl:if>
  <xsl:if test="$MonthNum=12">Dezember</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      Das eingegebene Datum und die Uhrzeit sind ungültig. Korrigieren Sie die
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      Ein Kalender mit diesem Namen ist bereits vorhanden. Wählen Sie einen anderen Namen.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      Eine Gruppe mit diesem Namen ist bereits vorhanden. Wählen Sie einen anderen Namen.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> bis </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      Bei dieser Suche ist ein Problem mit dem Verzeichnisserver aufgetreten.&nbsp;      Geben Sie einen anderen Suchbegriff ein.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Zu viele Suchergebnisse für diesen Suchbegriff.&nbsp;      Geben Sie einen genaueren Suchbegriff ein.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      Die Verbindung zum Verzeichnisserver konnte nicht aufgebaut werden.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      Die Verbindung zum Verzeichnisserver konnte nicht aufgebaut werden.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      Bei dieser Suche ist ein Problem mit dem Verzeichnisserver aufgetreten.&nbsp;      Geben Sie einen anderen Suchbegriff ein.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE-Fehler: Ereignis wurde gelöscht
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE-Fehler: Nicht unterstützte Implementierung
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE-Fehler: malloc fehlgeschlagen
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE-Fehler: Erstellen mehrerer GSE-Instanzen nicht möglich
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE-Fehler: GSE-Eintrag ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE-Fehler: Ereignis ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE-Fehler: Transportschnittstelle nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE-Fehler: Teilnehmer im Organizer-Kalender nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE-Fehler: Erstellen der Ressource (z. B. lock, GDisp) nicht möglich
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE-Fehler: iCS-Benutzer erwartet, SMTP-Benutzer aufgefunden
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE-Fehler: Komponentenmethode und Status ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE-Fehler: Zeitkonflikt mit anderer Besprechungsanfrage
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB-Fehler: Komponente nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB-Fehler: E/A-Fehler
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB-Fehler: Mindestens ein Wert im Ereignis ist ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB-Fehler: Funktionsaufruf für die angegebene Komponente nicht zulässig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB-Fehler: Angeforderte Anfrage unbekannt oder nicht unterstützt
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB-Fehler: Ein erforderlicher Parameter ist NULL, nicht gesetzt oder nicht vorhanden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB-Fehler: Schreibvorgang abgebrochen, weil ein Fehler bei der angeforderten Bedingungsprüfung für die Folgenummer aufgetreten ist
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB-Fehler: Schreibvorgang abgebrochen, weil ein Fehler bei der angeforderten Bedingungsprüfung für die Bearbeitungszeit aufgetreten ist
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB-Fehler: Schreibvorgang wurde abgebrochen, weil überlappende Termine im Kalender nicht zulässig sind
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB-Fehler: ENS-Benachrichtigung hat einen Fehler zurückgegeben
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB-Fehler: Ein erforderlicher Wert ist NULL
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Teilnehmerfehler: Argument fehlerhaft
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Teilnehmerfehler: Kalender nicht gefunden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Teilnehmerfehler: Kalender deaktiviert
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Teilnehmerfehler: Benutzer besitzt keine Berechtigung zum Zugriff auf den Kalender
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Teilnehmerfehler: Gruppe wurde abgeschnitten
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Teilnehmerfehler: Organizer konnte nicht entfernt werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Kalenderfehler: Kalender konnte nicht erstellt werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Kalenderfehler: Kalender mit derselben ID bereits vorhanden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Kalenderfehler: Benutzer besitzt nicht die notwendige Zugriffsberechtigung für diesen Vorgang.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Kalenderfehler: Benutzer versucht, auf einen nicht vorhandenen Kalender zuzugreifen.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Kalenderfehler: Kalender-ID ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Teilnehmerfehler: Teilnehmer kann nicht doppelt eingeladen werden
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Kalenderfehler: Benutzer besitzt nicht die notwendige Zugriffsberechtigung für diesen Vorgang.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Kalenderfehler: Benutzer muss Besitzer oder Mitbesitzer sein, um diesen Vorgang ausführen zu können.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Kalenderfehler: Datenbank ist schreibgeschützt.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Ermitteln Sie die freien Zeiten auf der Registerkarte für die Verfügbarkeit.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Gruppenfehler: Gruppen-ID ungültig
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Kalenderfehler: Unbekannter Benutzer konnte nicht zur Privat- oder Besitzerliste hinzugefügt werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP-Fehler: Kein Mail-Host
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP-Fehler: Fehler bei Verbindung
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP-Fehler: Erwartete Reaktion auf Herstellung der Verbindung nicht erfolgt
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP-Fehler: Problem beim Adressieren der Nachricht
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP-Fehler: Kein Empfänger
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Fehler: Fehler bei Verbindung zur Back-End-Datenbank.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Fehler: Maximale Anzahl der Verbindungen zur Back-End-Datenbank erreicht.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Fehler: Kalender konnte nicht aufgelöst werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Fehler: Fehlerhafte Daten - Back-End-Datenbank ist nicht erreichbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Fehler: DWP-Host-Kontext nicht verfügbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Fehler: Back-End-Host konnte nicht aufgelöst werden.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Fehler: Keine Daten - Back-End-Datenbank ist nicht erreichbar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Fehler: Fehler bei Verbindung zur Back-End-Datenbank.
    </xsl:when>
    <xsl:otherwise>
      Unbekannt Fehler #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Fehler: Eine Instanz einer Terminserie kann nicht eine andere Instanz überspringen.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Fehler: Zwei Instanzen einer Terminserie können nicht an demselben Tag eintreten.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Fehler: Kennzeichnung als privat für nur eine Instanz konnte nicht geändert werden.
    </xsl:when>
    <xsl:otherwise>
      Unbekannter Fehler bei Terminserie #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">Amerika/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">Amerika/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">Amerika/Los Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">Amerika/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">Amerika/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">Amerika/Costa Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">Amerika/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">Amerika/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">Amerika/New York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">Amerika/Havanna</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">Amerika/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">Amerika/Grand Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">Amerika/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">Amerika/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">Amerika/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">Amerika/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantik/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">Amerika/St. John's</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">Amerika/Buenos Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">Amerika/Sao Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">Amerika/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">Amerika/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantik/Südgeorgien</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantik/Kap Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantik/Azoren</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Afrika/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europa/London</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Afrika/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europa/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Afrika/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europa/Warschau</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Afrika/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europa/Bukarest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europa/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Afrika/Kairo</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europa/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Afrika/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europa/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europa/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europa/Moskau</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europa/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asien/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asien/Jerusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asien/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asien/Riad</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asien/Teheran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asien/Eriwan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asien/Aktau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asien/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asien/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asien/Karatschi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asien/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asien/Bischkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asien/Jekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asien/Kalkutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asien/Katmandu</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asien/Dhaka</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asien/Almaty</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asien/Nowosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asien/Rangun</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asien/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asien/Krasnojarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asien/Ulan-Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asien/Schanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asien/Taipeh</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asien/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asien/Tokio</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asien/Seoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asien/Jakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australien/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australien/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australien/Adelaide</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australien/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australien/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australien/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asien/Wladiwostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australien/Lord-Howe-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pazifik/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pazifik/Nouméa</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asien/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pazifik/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pazifik/Fidschi</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pazifik/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asien/Kamtschatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pazifik/Chatham-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pazifik/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asien/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pazifik/Weihnachtsinsel</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pazifik/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pazifik/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pazifik/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pazifik/Marquesas-Inseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pazifik/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pazifik/Pitcairninseln</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pazifik/Osterinsel</xsl:when> 
    <xsl:otherwise>
      Unbekannt Zeitzone #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">Kein Enddatum </xsl:variable>
<xsl:variable name="cap_the_text">Der </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Entfernen</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Willkommen  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Aufgaben für </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>- Kalender (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Beginn um </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 Stunde</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> Minuten</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>Über eine Stunde</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> verfügbar)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Erstellt maximal </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> e Instanzen</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>Dem aktuellen Kalender können eine oder mehrere Zeitzonen einer beliebigen Region zugeordnet werden. In Tabellenansichten wie der Tagesansicht werden alle Zeitzonen des Kalenders in die Zeitskala der Ansicht integriert. Wenn diesem Kalender keine Zeitzone zugeordnet ist, wird die Standardzeitzone verwendet. Folgende Zeitzonen gibt es in der </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>Dem aktuellen Kalender kann eine Zeitzone einer beliebigen Region zugeordnet werden. In Tabellenansichten wie der Tagesansicht wird die Zeitzone des Kalenders in die Zeitskala der Ansicht integriert. Wenn diesem Kalender keine Zeitzone zugeordnet ist, wird die Standardzeitzone verwendet. Folgende Zeitzonen gibt es in der </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>Nord-/Südamerika </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europa/Afrika </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asien/Pazifische Randgebiete </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>Region:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>Das folgende Ereignis wurde in Ihren Kalender aufgenommen durch "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". Sie können diese Einladung annehmen oder ablehnen. Klicken Sie hierzu auf die gewünschte Option in der nachstehenden Antwort.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Klicken</xsl:text>&nbsp;
  <B><xsl:text>Durchsuchen...</xsl:text></B>&nbsp;
  <xsl:text>zum Auswählen einer Datei.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Dieses Fenster ermöglicht das Annehmen </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> oder Ablehnen </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> oder das Offenhalten </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> von Einladungen zu Ereignissen.</xsl:text>
  <br/>
  <xsl:text>Bei Terminserien wird die Einstellung für alle Termine in der Serie übernommen.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>Die Ergebnisse einer Suche mit weniger als </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> Zeichen ist möglicherweise unvollständig. Bessere Ergebnisse erzielen Sie mit mindestens </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> Zeichen.</xsl:text>

</xsl:template>


</xsl:stylesheet>
