<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="toolbar.xsl"/>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>
    <TITLE>Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="125,*">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="tabs" marginheight="0" marginwidth="0" src="{$Frame2}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='toolbar'">
      <xsl:call-template name="calendars_toolbar_root"/>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:call-template name="calendars_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (calendars.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- Output Calendars main frame -->
<xsl:template name="calendars_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">

<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="isAllGroup" value="true"/>
  
<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <TR>
    <TD width="1%" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_biggest}" color="#000000"><B>Gruppen</B></FONT>
    </TD>
    <TD width="99%" >
      <FONT face="{$font_name}" size="{$font_size_normal}" color="#000000">
      <xsl:text>&nbsp;&nbsp;&nbsp;</xsl:text>Mit einer Kalendergruppe lassen Sie mehrere Kalender gleichzeitig anzeigen. Zum Öffnen einer Kalendergruppe klicken Sie auf den Link mit dem Gruppennamen. Um einen Kalender in eine Gruppe aufzunehmen oder daraus zu entfernen, klicken Sie auf den Link "Bearbeiten".</FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2" width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
  </TR>
</TABLE>
<TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
  <TR>
    <TD>
      <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <TD bgcolor="{$bgcolor_table_border}">
            <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
              <TR bgcolor="{$bgcolor_table_top}">
                <TD nowrap="" width="1%" align="">
                  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Auswählen</FONT>
                </TD>
                <TD nowrap="" align="left">
                  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Gruppe</FONT>
                </TD>
<!-- 
                <TD nowrap="" align="left">
                  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Beschreibung</FONT>
                </TD>
-->
                <TD nowrap="" width="1%" align="left">
                  <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">Eigenschaften<xsl:text>&nbsp;&nbsp;</xsl:text></FONT>
                </TD>
              </TR>
              <xsl:for-each select="/calendar/usrctx/usergroup">
                <TR bgcolor="#FFFFFF">
               <!-- Select Col -->
                <TD nowrap="" align="center">
                  <input type="checkbox">
                    <xsl:attribute name="name">remove_group_<xsl:value-of select="@name"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
                  </input>
                </TD>

               <!-- Group Name Col -->
                  <TD nowrap="" align="left">
                    <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
                      <IMG src="imx/cal.gif" width="16" height="16" border="0"></IMG>
                      <xsl:choose>
                        <xsl:when test="string-length(/calendar/group[2]/command[@name='groupview']) > 0">
                          <xsl:text>&nbsp;</xsl:text>
                          <A onmouseout="window.status=''; return true;">
		        <!-- javascript:jmain.navto_calid='<xsl:value-of select="@name"/>'; -->
                            <xsl:attribute name="href"><xsl:value-of select="@viewCommand"/></xsl:attribute>
                            <xsl:call-template name="printLimitedName">
                              <xsl:with-param name="name" select="@name"/>
                            </xsl:call-template>
                          </A>
		        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="alt">
                              <xsl:call-template name="printLimitedName">
                                <xsl:with-param name="name" select="@name"/>
                              </xsl:call-template>
                            </xsl:attribute>
                          <xsl:text>&nbsp;</xsl:text>
                          <xsl:call-template name="printLimitedName">
                            <xsl:with-param name="name" select="@name"/>
                          </xsl:call-template>
                          <xsl:text>&nbsp;</xsl:text>
                          <xsl:choose>
                            <xsl:when test="@error='READ_PERMISSIONS_ERROR'">
                              <FONT color="{$ErrorColor2}"><I>Sie besitzen keine Berechtigung für den Zugriff auf diesen Kalender.</I></FONT>
                            </xsl:when>
                            <xsl:when test="@error='CALENDAR_DOES_NOT_EXIST_ERROR'">
                              <FONT color="{$ErrorColor1}"><I>Dieser Kalender ist nicht vorhanden.</I></FONT>
                            </xsl:when>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                    </FONT>
                  </TD>

                <!-- Description -->
<!--
                  <TD nowrap="" align="left">
                    <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
                      <xsl:choose>
                        <xsl:when test="string-length(@description) > 0">
                          <xsl:value-of select="@description"/>
                        </xsl:when>
                        <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
                      </xsl:choose>
                    </FONT>
                  </TD>
-->
                <!-- Edit -->
                  <TD nowrap="" align="left">
                    <FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000">
                      <xsl:text>&nbsp;</xsl:text>
                      <xsl:if test="string-length(@editCommand) > 0">
                        <xsl:text>&nbsp;</xsl:text>
                        <A onmouseout="window.status=''; return true;">
                          <xsl:attribute name="href">javascript:var x=window.open('<xsl:value-of select="@editCommand"/>','Edit','height=550,width=650');</xsl:attribute>
                           <xsl:attribute name="alt">Bearbeiten<xsl:text>&nbsp;</xsl:text><xsl:call-template name="printLimitedName"><xsl:with-param name="name" select="@name"/></xsl:call-template></xsl:attribute>
                          Bearbeiten</A>
                      </xsl:if>
                    </FONT>
                  </TD>
                </TR>
              </xsl:for-each>
            </TABLE>
          </TD>
        </TR>
      </TABLE>
    </TD>
  </TR>
  <xsl:if test="string-length(button[@name='delete_calendar_group']) > 0">
  <TR>
    <TD nowrap="" align="left">
      <FONT face="{$font_name}" size="{$font_size_big_2}"> 
      <input type="button" name="Remove_Selected" value="Auswahl entfernen" width="72">
      <xsl:attribute name="onClick">
       var fr = parent.frames[1];
       var f = fr.document.forms[0];
       if (f['myaction']) {
         f['myaction'].value = 'delete_calendar_group';
         void f.submit();
       }
      </xsl:attribute>
      </input>
      </FONT>
    </TD>
  </TR>
  </xsl:if>
</TABLE>
</FORM>

</BODY>
</HTML>

</xsl:template>


<!-- Output the toolbar for the Calendars view -->
<xsl:template name="calendars_toolbar_root">
  <html>
  <xsl:call-template name="emit_frame_head_tag"/>

  <body bgcolor="{$bgcolor_background}" marginwidth="0" marginheight="0">
  <xsl:text></xsl:text><!--DIV style="position:absolute;z-index:1;"-->
  <form name="form">
    <xsl:for-each select="group">
      <xsl:if test="@name='toolbar'">
        <xsl:call-template name="brand"/>
        <xsl:call-template name="toolbar-tabs"/>
        <xsl:call-template name="calendar-toolbar-icons"/>
      </xsl:if>
    </xsl:for-each>
  </form>
  <xsl:text></xsl:text><!--/DIV-->
  <xsl:text></xsl:text><!--DIV id="tabBG" style="position:absolute;z-index:0;"><IMG src="imx/tbg.gif"></DIV-->
  </body>
  </html>
</xsl:template>

</xsl:stylesheet>
