/*  
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to license terms. 
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved. 
 */
 

var danameEnabled = false;
var algoDefault = false;

function initializeAll() {
	setSelectedAlgos(); // Select the algorithms for the current rule name
	setalgoState(); // set the algorithm state (Default/Other)
	setdanameState(); // set the state for download applet text field 
	initPhplist(); // Select the first entry in the PHP list
}

function setalgoState() {
	var algotype = document.forms[formName].algotype[0].checked;
	if(algotype == true){
		algoDefault = true;
		document.forms[formName].elements[algorithms].disabled = true;
		var algosize = document.forms[formName].elements[algorithms].options.length;
		for(var i=0; i < algosize; i++) {
			document.forms[formName].elements[algorithms].options[i].selected = false;
		}
	} else {
		algoDefault = false;
		document.forms[formName].elements[algorithms].disabled = false;
	}
}
		
function setdanameState() {
	var dacb = document.forms[formName].elements[downloadappletcb].checked;
	if(dacb == false) {
		danameEnabled = false;
		document.forms[formName].elements[downloadappletname].disabled = true;
	} else {
		danameEnabled = true;
		document.forms[formName].elements[downloadappletname].disabled = false;
	}
}
		
function setSelectedAlgos() {
	var nameandalgo = document.forms[formName].elements[selectedAlgos].value;
	var nameandalgos = nameandalgo.split("^");
	if(nameandalgos.length == 1) {
		document.forms[formName].algotype[0].checked = true;
        } else if(nameandalgos.length == 2) {
		document.forms[formName].algotype[1].checked = true; 	
		for(var i = 0; i < document.forms[formName].elements[algorithms].options.length; i++)
		{
			var opt = document.forms[formName].elements[algorithms].options[i];
			if(opt.value == nameandalgos[1]) {
				document.forms[formName].elements[algorithms].options[i].selected = true;
				break;
			}
		}
	} else {
		document.forms[formName].algotype[1].checked = true; 	
		var algos = nameandalgos[2].split("+");
		for(var j = 0; j < algos.length; j++) {
		  for(var i = 0; i < document.forms[formName].elements[algorithms].options.length; i++)
		  {
		  	  var opt = document.forms[formName].elements[algorithms].options[i];
			  if(opt.value == algos[j]) {
				document.forms[formName].elements[algorithms].options[i].selected = true;
				break;
			  }
		  }
		}
	}
}

function selectListBoxes() {
	addToSelBeforeSubmitArray(formName,phplist);
	selBeforeSubmit();
}

function _isDigit (c) {
        return ((c >= "0") && (c <= "9"));
}

function _isLetter (c) {
        return ( ((c >= "a") && (c <= "z")) || ((c >= "A") && (c <= "Z")) )
}


function _isInteger(s) {
            for (var i = 0; i < s.length; i++) {
                var c = s.charAt(i);
                if (!_isDigit(c))
                        return false;
            }
            return true;
}

function _isDuplicateClientPort(sport) {
    for(var i = 0; i < document.forms[formName].elements[phplist].options.length; i++) {
        var opt = document.forms[formName].elements[phplist].options[i];
        var selectedphp = opt.value;
        var selectedphps = selectedphp.split(" ");
        var cport = selectedphps[0];
        if(sport == cport) {
            return true;
        }
    }
    return false;
}

function _isValidHost (thost) {
    for (var i = 0; i < thost.length; i++) {
        var c = thost.charAt(i);
        if (!_isDigit(c) && !_isLetter(c) && c != "." && c != "+") {
            return false;
        }
    }
    return true;
}

function validatePhpvalues() {
        var sport = document.forms[formName].elements[sourceport].value;
        var thost = document.forms[formName].elements[targethost].value;
        var tport = document.forms[formName].elements[targetport].value;
        var numofthosts = 0; // Used only for static rules

        if(sport.length == 0 || thost.length == 0 || tport.length == 0) {
		alert(errorMessages['emptyFields']);
                return false;
        }

        if(!_isInteger(sport)) {
                alert(errorMessages['invalidclientport']);
                return false;
        }

	if(_isDuplicateClientPort(sport)) {
		alert(errorMessages['duplicateclientport']);
		return false;
	}

        if(!_isValidHost(thost)) {
                alert(errorMessages['invalidtargethost']);
                return false;
        }

        if(document.forms[formName].elements[targethost].value == "TARGET") {
                if(tport.indexOf("-") >= 0) {
                        alert(errorMessages['dynamictargetport']);
                        return false;
                }

                var tports = tport.split("+");

                for(var i = 0; i < tports.length; i++) {
                        if(tports[i] == "" || !_isInteger(tports[i])) {
                                alert(errorMessages['invalidtargetport']);
                                return false;
                        }
                }
        } else{
                var thosts = thost.split("+");
                numofthosts = thosts.length;

                for(var i = 0; i < thosts.length; i++) {
                        if(thosts[i] == "" || !_isValidHost(thosts[i])) {
                                alert(errorMessages['invalidtargethost']);
                                return false;
                        }
                }

                var tportlist = tport.split("-");

                if( (tportlist.length != 1) && (tportlist.length != numofthosts) ) {
                        alert(errorMessages['targetportlist']);
                        return false;
                }

                for(var i = 0; i < tportlist.length; i++) {
                        var tports = tportlist[i].split("+");
                        for(var j = 0; j < tports.length; j++) {
                                if(tports[j] == "" || !_isInteger(tports[j])) {
                                        alert(errorMessages['invalidtargetport']);
                                        return false;
                                }
                        }
                }
        }

        return true;
}

function addToPhplist() {
                var entry = document.forms[formName].elements[sourceport].value + " " +
                                        document.forms[formName].elements[targethost].value + " " +
                                        document.forms[formName].elements[targetport].value;

                /*
                 * Check for duplicates before invoking _validatePhpvalues()
                 * as _validatePhpvalues() is heavy weight
                 */

                for(var i = 0; i < document.forms[formName].elements[phplist].options.length; i++) {
                        var cur = document.forms[formName].elements[phplist].options[i];

                        if(cur.value == entry) {
                                alert(errorMessages['duplicatetargets']);
                                return;
                        }
                }

                if(validatePhpvalues()) {
                                var phplistlength = document.forms[formName].elements[phplist].length;
                                var opt = new Option(entry,entry);
                                document.forms[formName].elements[phplist].options[phplistlength] = opt;
                                document.forms[formName].elements[sourceport].value = "";
                                document.forms[formName].elements[targethost].value = "";
                                document.forms[formName].elements[targetport].value= "";
                }
}

/*
 * Deletes the selected entries from the Source port, Target host &
 * Target port list
 */

function deleteFromPhplist() {
        for(var i = 0; i < document.forms[formName].elements[phplist].length; i++) {
                var opt = document.forms[formName].elements[phplist].options[i];

                if( (opt.selected) && (opt.value != "") ) {
                        document.forms[formName].elements[phplist].options[i] = null;
                        if (document.forms[formName].elements[phplist].length > 0) {
                                i--;
                        }
                }
        }
}

/*
 * Put the selected Source port, Target host, and Target port
 * into the appropriate input widgets
 */

function editPhpselected() {
        var selectedphp = "";

        for(var i = 0; i < document.forms[formName].elements[phplist].options.length; i++) {
                var opt = document.forms[formName].elements[phplist].options[i];
                if(opt.selected) {
                        selectedphp = opt.value;
                }
        }
	if( (selectedphp == null) || (selectedphp == "") ) {
        	document.forms[formName].elements[sourceport].value = "";
        	document.forms[formName].elements[targethost].value = "";
        	document.forms[formName].elements[targetport].value = "";
		return;
	}
        var selectedphps = selectedphp.split(" ");

        document.forms[formName].elements[sourceport].value = selectedphps[0];
        document.forms[formName].elements[targethost].value = selectedphps[1];
        document.forms[formName].elements[targetport].value = selectedphps[2];
}

function initPhplist() {
	for(var i=0; i < document.forms[formName].elements[phplist].options.length; i++) {
		document.forms[formName].elements[phplist].options[i].selected = false;
	}
	if(document.forms[formName].elements[phplist].options[0] != null &&
	   document.forms[formName].elements[phplist].options[0].value != "" ) {
		document.forms[formName].elements[phplist].options[0].selected = true;
		editPhpselected();
	}
}

/*
 * Checks whether the given field exists in the form or not
 */
function fieldExists(fieldName) {
	var field = document.forms[formName].elements[fieldName];
	if( field == null || (typeof field == "undefined"))
		return false;
	return true;
}
/*
 * Returns false if the value in the given field is empty
 */
function checkField(fieldName) {
	var fieldValue = document.forms[formName].elements[fieldName].value;
	if(fieldValue == null || fieldValue.length == 0) {
		return false;
	}
	return true;
}

/*
 * Functionality:
 * 1. Throws error message and returns false if none of the rules are selected for deletion.
 * 2. Returns false if the user doesnot give confirmation for deletion of selected rules.
 */
function checkBeforeDelete() {
	var netletRulesTiledViewName = "NetletRulesTiledView";
	var netletRuleSelectCBName = "cbSelectRule";
	var netletRuleFieldName = "ruleName";
	var netletRulesCountField = formName + "." + "netletRulesCount"; 
	var netletRulesCount = document.forms[formName].elements[netletRulesCountField].value; 
	var noSelection = true;
	var selectedRules = new Array();

	for(var i=0, j=0; i < netletRulesCount; i++) {
		var checkBox = formName + "." + netletRulesTiledViewName + "[" + i + "]." + netletRuleSelectCBName;
		var ruleName = formName + "." + netletRulesTiledViewName + "[" + i + "]." + netletRuleFieldName;
		if(document.forms[formName].elements[checkBox].checked) {
			noSelection = false;
			var selectedRuleName = document.forms[formName].elements[ruleName].value;
			selectedRules[j++] = selectedRuleName;
		}
	}
	if(noSelection) {
		alert(noRuleSelection);
		return false;
	}
	
	var confirmMsg = confirmRuleDelete + "\n\n";
	for(var i=0; i < selectedRules.length; i++) {
		confirmMsg = confirmMsg + "\t"+ selectedRules[i] + "\n";
	}
	var cf = confirm(confirmMsg);
	if(cf == true) 
		return true;
	return false;
}

