#!/bin/ksh
# Author: Anurag Gupta
# Date  : Sep 2nd, 2002

###############################################
# Defines
###############################################
AWK=/usr/bin/awk
BASENAME=/usr/bin/basename
CAT=/usr/bin/cat
CD=/usr/bin/cd
CHMOD=/usr/bin/chmod
CP=/usr/bin/cp
DATE=/usr/bin/date
DIRNAME=/usr/bin/dirname
DOMAINNAME=/usr/bin/domainname
ECHO=/usr/bin/echo
HOSTNAME=/usr/bin/hostname
ID=/usr/bin/id
GREP=/usr/bin/grep
LS=/usr/bin/ls
MKDIR=/usr/bin/mkdir
MV=/usr/bin/mv
PKGINFO=/usr/bin/pkginfo
PS=/usr/bin/ps
PWD=/usr/bin/pwd
RM=/usr/bin/rm
SED=/usr/bin/sed
SHOWREV=/usr/bin/showrev
UNAME=/usr/bin/uname 
UNIQ=/usr/bin/uniq
WC=/usr/bin/wc

###############################################
# Global variables
###############################################
STR=""

BASE_PRESENT=""
SRA_SUPPORT_PRESENT=""
SRA_PRESENT=""

SHOOTERDIR=""
PERLSCRIPT=""
GW_PROFILE=""
IDSAME_BASEDIR=""
WS_HOST=""

GW_BASEDIR=""
GW_IDSAME_BASEDIR=""
GW_JAVA_HOME=""
GW_JAVA_CP=""

WORK_DIR="/tmp/troubleshooter.$$"
FILE="$WORK_DIR/data.txt"
TMPFILE="$WORK_DIR/tempfile.tmp"

###############################################
# Check for root user
###############################################
CheckRootUser() {
  if [ `$ID | $AWK '{print $1}'` != "uid=0(root)" ]; then
    $ECHO "ERROR: You must be root user."
    exit 1
  fi
}

###############################################
# Initialize directories
###############################################
DirInit() {
  if [ -d $WORK_DIR ]; then
    $RM -rf $WORK_DIR
  fi
  $MKDIR -p $WORK_DIR
}

###############################################
# Is base present
###############################################
SRA_BasePresent() {
  $PKGINFO -q "SUNWps"
  if [ $? -eq 0 ]; then
    return 0
  else
    return 1
  fi
}

###############################################
# Is SRA support present
###############################################
SRA_SupportPresent() {
  $PKGINFO -q "SUNWpsgwa"
  if [ $? -eq 0 ]; then
    return 0
  else
    return 1
  fi
}

###############################################
# Is SRA present
###############################################
SRA_Present() {
  $PKGINFO -q "SUNWpsgw"
  if [ $? -eq 0 ]; then
    return 0
  else
    return 1
  fi
}

###############################################
# Set Global Variables 
###############################################
SetGlobals() {
  SHOOTERDIR=`dirname $STR`
  PERLSCRIPT="$SHOOTERDIR/uniq.pl"
 
  SRA_BasePresent
  if [ $? -eq 0 ]; then
    BASE_PRESENT="y"
  else
    BASE_PRESENT="n"
  fi

  SRA_SupportPresent
  if [ $? -eq 0 ]; then
    SRA_SUPPORT_PRESENT="y"
  else
    SRA_SUPPORT_PRESENT="n"
  fi

  SRA_Present
  if [ $? -eq 0 ]; then
    SRA_PRESENT="y"
  else
    SRA_PRESENT="n"
  fi

  if [ $SRA_PRESENT = "y" ]; then
    GW_PROFILE=`$GREP "^GW_PROFILE=" /var/sadm/pkg/SUNWpsgw/pkginfo | $UNIQ | $SED -e "s/GW_PROFILE=//"`
  fi

  if [ $SRA_SUPPORT_PRESENT = "y" ]; then
    IDSAME_BASEDIR=`$GREP "^BASEDIR=" /var/sadm/pkg/SUNWamsvc/pkginfo | $UNIQ | $SED -e "s/BASEDIR=//"`
    WS_HOST=`$GREP "^WS_INSTANCE=" /var/sadm/pkg/SUNWamsvc/pkginfo | $UNIQ | $SED -e "s/WS_INSTANCE=//"`
  fi
}

###############################################
# Write Header
###############################################
Write_Header() {
  $ECHO "--------------------------------------------------------------" > $FILE
  $ECHO "           SRA Troubleshooting Analysis Data" >> $FILE
  $ECHO "--------------------------------------------------------------" >> $FILE

  $ECHO "" >> $FILE
  STR=`$DATE | $AWK '{print $0}'`
  $ECHO "Dated: " $STR >> $FILE
}

###############################################
# Write PS:SRA Installation
###############################################
Write_PS_SRA() {
  $ECHO "" >> $FILE
  STR="Portal Present        : "
  if [ "$BASE_PRESENT" = "y" ]; then
    STR=$STR"Yes"
  else
    STR=$STR"No"
  fi
  $ECHO $STR >> $FILE

  STR="SRA Support Present   : "
  if [ "$SRA_SUPPORT_PRESENT" = "y" ]; then
    STR=$STR"Yes"
  else
    STR=$STR"No"
  fi
  $ECHO $STR >> $FILE

  STR="SRA Present           : "
  if [ "$SRA_PRESENT" = "y" ]; then
    STR=$STR"Yes"
  else
    STR=$STR"No"
  fi
  $ECHO $STR >> $FILE
}

###############################################
# Write Innstallation Versions
###############################################
Write_Versions() {
local BASEDIR=""

  if [ "$SRA_SUPPORT_PRESENT" = "y" ]; then
    STR=`$IDSAME_BASEDIR/SUNWam/bin/amserver version`
    $ECHO "" >> $FILE
    $ECHO "iDSAME Version: $STR" >> $FILE
    BASEDIR=`$GREP "^BASEDIR=" /var/sadm/pkg/SUNWps/pkginfo | $UNIQ | $SED -e "s/BASEDIR=//"`
    STR=`$BASEDIR/SUNWps/bin/version`
    $ECHO "Portal Version: $STR" >> $FILE
  fi
  if [ "$SRA_PRESENT" = "y" ]; then
    BASEDIR=`$GREP "^BASEDIR=" /var/sadm/pkg/SUNWpsgw/pkginfo | $UNIQ | $SED -e "s/BASEDIR=//"`
    STR=`$BASEDIR/SUNWps/bin/gateway version`
    $ECHO "" >> $FILE
    $ECHO "SRA Version: $STR" >> $FILE
  fi
}

###############################################
# Write System Configuration
###############################################
Write_System_Conf() {
  local PLAT=""
  local CMD=""

  $ECHO "" >> $FILE
  $ECHO "System Information: " >> $FILE
  $SHOWREV >> $FILE

  STR=`$UNAME  -a | $AWK '{print $0}'`
  PLAT=`$ECHO $STR | $AWK '{print $7}'`
  
  $ECHO "" >> $FILE
  $ECHO "Platform: $PLAT" >> $FILE

  $ECHO "" >> $FILE
  CMD="/usr/platform/$PLAT/sbin/prtdiag -v"
  $CMD > $TMPFILE
  $GREP "System Configuration:" $TMPFILE >> $FILE
  $GREP "System clock frequency:" $TMPFILE >> $FILE
  $GREP "Memory size:" $TMPFILE >> $FILE
  $RM $TMPFILE
}

###############################################
# Write Processor and Processor Set Info
###############################################
Write_Processor_Info() {
  $ECHO "" >> $FILE
  $ECHO "Processor Info: " >> $FILE
  psrinfo  >> $FILE

  $ECHO "" >> $FILE
  $ECHO "Processor Sets: " >> $FILE
  psrset -i >> $FILE

  $ECHO "" >> $FILE
  $ECHO "Processor bound processes: " >> $FILE
  pbind -q | $AWK '{print $3,$4}' >> $FILE
  $ECHO "Processes:" >> $FILE
  STR=`pbind -q | $AWK '{print $3}' | $SED -e "s/:.*//"`
  for PID in $STR;
  do
    $PS -ef | $AWK '{print $2,$8}' | $GREP $PID >> $FILE
  done

  $ECHO "" >> $FILE
  $ECHO "Processor Set bound processes: " >> $FILE
  psrset -q | $AWK '{print $3,$4}' >> $FILE
  $ECHO "Processes:" >> $FILE
  STR=`psrset -q | $AWK '{print $3}' | $SED -e "s/:.*//"`
  for PID in $STR;
  do
    $PS -ef | $AWK '{print $2,$8}' | $GREP $PID >> $FILE
  done
}

###############################################
# Write Installation Log
###############################################
Write_Install_Log() {
  STR="n"
  if [ $BASE_PRESENT = "y" ]; then STR="y"; fi
  if [ $SRA_SUPPORT_PRESENT = "y" ]; then STR="y"; fi
  if [ $SRA_PRESENT = "y" ]; then STR="y"; fi

  if [ $STR = "y" ]; then
    $ECHO "" >> $FILE
    STR=`$LS -lt /var/sadm/install/logs/ | $GREP "pssetup" | head -1 | $AWK '{print $9}'`
    STR="/var/sadm/install/logs/$STR/setup.log"
    if [ -e $STR ]; then
      $CP $STR $WORK_DIR
      $ECHO "Installation Log file: $WORK_DIR/setup.log" >> $FILE
    else
      $ECHO "Installation Log file: ERROR - Does not Exist!" >> $FILE
    fi
  fi
}

###############################################
# Write Platform Conf
###############################################
Write_Platform_Conf() {
  if [ $SRA_PRESENT = "y" ]; then
    $ECHO "" >> $FILE
    STR="/etc/opt/SUNWps/platform.conf.$GW_PROFILE"

    if [ -e $STR ]; then
      $CP $STR $WORK_DIR
      $ECHO "Platform configuration file: $WORK_DIR/platform.conf.$GW_PROFILE" >> $FILE
    else
      $ECHO "Platform configuration file: ERROR - Does not Exist!" >> $FILE
    fi
  fi
}

###############################################
# Write Gateway Script Info
###############################################
Write_Gateway_Script() {
  local BASEDIR=""
  local SCRIPT=""

  if [ $SRA_PRESENT = "y" ]; then
    $ECHO "" >> $FILE
    BASEDIR=`$GREP "^BASEDIR=" /var/sadm/pkg/SUNWpsgw/pkginfo | $UNIQ | $SED -e "s/BASEDIR=//"`
    GW_BASEDIR="$BASEDIR/SUNWps"
    SCRIPT="$GW_BASEDIR/bin/gateway"
    $ECHO "Gateway Script: $SCRIPT" >> $FILE
    $ECHO "Settings:" >> $FILE

    GW_JAVA_HOME=`$GREP "^gateway.jdk.dir=" /etc/opt/SUNWps/platform.conf.$GW_PROFILE | $UNIQ | $SED -e "s/gateway.jdk.dir=//"`
    STR="JAVA_HOME=$GW_JAVA_HOME" 
    $ECHO $STR | $SED -e "s/JAVA_HOME=/    JAVA_HOME=/" >> $FILE

    $GREP "LD_LIBRARY_PATH=" $SCRIPT | $SED -e "s/.*LD_LIBRARY_PATH=/    LD_LIBRARY_PATH=/" >> $FILE

    GW_IDSAME_BASEDIR=`$GREP "IDSAME_HOME=" $SCRIPT | $SED -e "s/.*IDSAME_HOME=//"`
    STR="IDSAME_HOME=$GW_IDSAME_BASEDIR" 
    $ECHO $STR | $SED -e "s/IDSAME_HOME=/    IDSAME_HOME=/" >> $FILE
    
    GW_JAVA_CP=`$GREP "IPS_CLASSES=" $SCRIPT | $SED -e "s/.*IPS_CLASSES=//"`
    $ECHO "$GW_JAVA_CP" > $TMPFILE
    $SED -e "s#\$IDSAME_HOME#${GW_IDSAME_BASEDIR}#g" \
         -e "s#:lib\/#:${GW_BASEDIR}\/lib\/#g" \
         $TMPFILE > $TMPFILE.new 

    GW_JAVA_CP=`$GREP "jar" $TMPFILE.new | $SED -e "s/^\"/\".:/"`
    $RM $TMPFILE $TMPFILE.new 

    $GREP "IPS_CLASSES=" $SCRIPT | $SED -e "s/.*IPS_CLASSES=/    IPS_CLASSES=/" >> $FILE
    $GREP "CLASSPATH=" $SCRIPT | $SED -e "s/.*CLASSPATH=/    CLASSPATH=/" >> $FILE

    $GREP "^    CMD=" $SCRIPT >> $FILE
  fi
}

###############################################
# Write Gateway Admin Console Settings
###############################################
Write_Gateway_Admin_Console() {
  local CURRDIR=""

  if [ $SRA_PRESENT = "y" ]; then
    CURRDIR=`$PWD`
    $CD $SHOOTERDIR
    $ECHO "$GW_JAVA_HOME/bin/java -cp $GW_JAVA_CP GWDump" > $TMPFILE
    $CHMOD +x $TMPFILE
    $TMPFILE >> $WORK_DIR/adminconsole.txt
    $RM $TMPFILE
    $CD $CURRDIR

    $ECHO "" >> $FILE
    $ECHO "Gateway Admin Console Settings: $WORK_DIR/adminconsole.txt" >> $FILE
  fi    
}

###############################################
# System Tuning Writer
###############################################
SystemTuningWriter() {
  $ECHO "/etc/system - " >> $FILE
  $GREP "rlim_fd_max=" /etc/system | $SED -e "s/.*rlim_fd_max=/    rlim_fd_max=/" >> $FILE
  $GREP "rlim_fd_cur=" /etc/system | $SED -e "s/.*rlim_fd_cur=/    rlim_fd_cur=/" >> $FILE
  $GREP "sq_max_size=" /etc/system | $SED -e "s/.*sq_max_size=/    sq_max_size=/" >> $FILE
  $GREP "tcp:tcp_conn_hash_size=" /etc/system | $SED -e "s/.*tcp:tcp_conn_hash_size=/    tcp:tcp_conn_hash_size=/" >> $FILE
}

###############################################
# TCP/IP Tuning Writer
###############################################
TCPIPTuningWriter() {
  $ECHO "TCP/IP Params - " >> $FILE
  STR=`ndd -get /dev/tcp tcp_time_wait_interval`
  STR="tcp_time_wait_interval=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE
  
  STR=`ndd -get /dev/tcp tcp_fin_wait_2_flush_interval`
  STR="tcp_fin_wait_2_flush_interval=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_conn_req_max_q`
  STR="tcp_conn_req_max_q=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_conn_req_max_q0`
  STR="tcp_conn_req_max_q0=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_ip_abort_interval`
  STR="tcp_ip_abort_interval=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_keepalive_interval`
  STR="tcp_keepalive_interval=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_rexmit_interval_max`
  STR="tcp_rexmit_interval_max=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_rexmit_interval_min`
  STR="tcp_rexmit_interval_min=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_rexmit_interval_initial`
  STR="tcp_rexmit_interval_initial=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_smallest_anon_port`
  STR="tcp_smallest_anon_port=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_slow_start_initial`
  STR="tcp_slow_start_initial=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_xmit_hiwat`
  STR="tcp_xmit_hiwat=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE

  STR=`ndd -get /dev/tcp tcp_recv_hiwat`
  STR="tcp_recv_hiwat=$STR"
  $ECHO $STR | $SED -e "s/.*tcp_/    tcp_/" >> $FILE
}

###############################################
# Web Server Tuning Writer
###############################################
WSTuningWriter() {
  local CONFFILE=""

  $ECHO "JVM Tuning - " >> $FILE
  CONFFILE=$IDSAME_BASEDIR/SUNWam/servers/https-$WS_HOST/config/jvm12.conf
  $GREP "^jvm" $CONFFILE | $GREP "HeapSize=" | $SED -e "s/jvm/    jvm/" >> $FILE
  $GREP "^jvm.option=" $CONFFILE | $SED -e "s/jvm/    jvm/" >> $FILE 

  $ECHO "" >> $FILE
  $ECHO "magnus.conf - " >> $FILE
  CONFFILE=$IDSAME_BASEDIR/SUNWam/servers/https-$WS_HOST/config/magnus.conf
  $GREP "^RqThrottle" $CONFFILE | $SED -e "s/RqThrottle/    RqThrottle/" >> $FILE
  $GREP "^StackSize" $CONFFILE | $SED -e "s/StackSize/    StackSize/" >> $FILE
  $GREP "^ThreadIncrement" $CONFFILE | $SED -e "s/ThreadIncrement/    ThreadIncrement/" >> $FILE
  $GREP "^ConnQueueSize" $CONFFILE | $SED -e "s/ConnQueueSize/    ConnQueueSize/" >> $FILE
  $GREP "^ListenQ" $CONFFILE | $SED -e "s/ListenQ/    ListenQ/" >> $FILE

  $ECHO "" >> $FILE
  $ECHO "server.xml - " >> $FILE
  $GREP "<LS id=\"ls1\" ip=" $IDSAME_BASEDIR/SUNWam/servers/https-$WS_HOST/config/server.xml >> $FILE

  $ECHO "" >> $FILE
  $ECHO "start-jvm - " >> $FILE
  $GREP "^NSES_JRE_RUNTIME_LIBPATH=" $IDSAME_BASEDIR/SUNWam/servers/https-admserv/start-jvm | $SED -e "s/NSES_JRE_RUNTIME_LIBPATH=/    NSES_JRE_RUNTIME_LIBPATH=/" >> $FILE
}

###############################################
# DSAME Tuning Writer
###############################################
DSAMETuningWriter() {
  local CONFFILE=""

  $ECHO "AMConfig.properties - " >> $FILE
  CONFFILE="/etc/opt/SUNWam/config/AMConfig.properties"
  $GREP "^com.iplanet.am.session.maxSessions=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.am.stats.interval=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.services.stats.state=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.services.stats.directory=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.am.session.httpSession.enabled=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.am.logstatus=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE
  $GREP "^com.iplanet.am.sdk.cache.maxSize=" $CONFFILE | $SED -e "s/com.iplanet/    com.iplanet/" >> $FILE

  $ECHO "" >> $FILE
  $ECHO "serverconfig.xml - " >> $FILE
  $GREP "<ServerGroup name=" $IDSAME_BASEDIR/SUNWam/config/ums/serverconfig.xml | $GREP "minConnPool=" | $SED -e "s/</    </" >> $FILE
}

###############################################
# Portal Tuning Writer
###############################################
PortalTuningWriter() {
  $ECHO "desktopconfig.properties - " >> $FILE
  $GREP "^callerPool" /etc/opt/SUNWps/desktop/desktopconfig.properties | $SED -e "s/caller/    caller/" >> $FILE
  $GREP "^templateScanInterval" /etc/opt/SUNWps/desktop/desktopconfig.properties | $SED -e "s/template/    template/" >> $FILE
}

###############################################
# Directory Server Tuning Writer
###############################################
DSTuningWriter() {
  local LDAPDIR=""
  local DS_HOSTNAME=""
  local CONFFILE=""

  LDAPDIR=`$GREP "^LDAPDIR=" /var/sadm/pkg/SUNWamds/pkginfo | $UNIQ | $SED -e "s/LDAPDIR=//"`
  DS_HOSTNAME=`$GREP "^DS_HOSTNAME=" /var/sadm/pkg/SUNWamds/pkginfo | $UNIQ | $SED -e "s/DS_HOSTNAME=//"`
  CONFFILE=$LDAPDIR/slapd-$DS_HOSTNAME/config/dse.ldif
  
  $ECHO "dse.ldif - " >> $FILE
  $GREP "nsslapd-threadnumber:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
  $GREP "nsslapd-accesslog-logging-enabled:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
  $GREP "nsslapd-db-home-directory:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
  $GREP "nsslapd-maxthreadsperconn:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
  $GREP "nsslapd-dbcachesize:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
  $GREP "nsslapd-cachememsize:" $CONFFILE | $SED -e "s/ns/    ns/" >> $FILE
}

###############################################
# Write Tuning Info
###############################################
Write_Tuning_Info() {

  if [ $SRA_SUPPORT_PRESENT = "y" ]; then
    $ECHO "" >> $FILE 
    $ECHO "Portal Tuning:" >> $FILE

    SystemTuningWriter

    $ECHO "" >> $FILE
    TCPIPTuningWriter

    $ECHO "" >> $FILE
    WSTuningWriter

    $ECHO "" >> $FILE
    DSAMETuningWriter
   
    $ECHO "" >> $FILE 
    PortalTuningWriter

    $PKGINFO -q "SUNWamds"
    if [ $? -eq 0 ]; then
      $ECHO "" >> $FILE
      DSTuningWriter
    fi
  elif [ $SRA_PRESENT = "y" ]; then
    $ECHO "" >> $FILE
    $ECHO "Gateway Tuning:" >> $FILE

    SystemTuningWriter

    $ECHO "" >> $FILE

    TCPIPTuningWriter
  fi
}

###############################################
# Write Java Garbage Collection Output
###############################################
Write_GC_Output() {
  local GCFILE="/tmp/gcoutput.txt"

  $ECHO "" >> $FILE
  if [ -e $GCFILE ]; then
    $CP $GCFILE $WORK_DIR
    $ECHO "GC Output file: $WORK_DIR/gcoutput.txt" >> $FILE
  else
    $ECHO "GC Output file: ERROR - Does not Exist!" >> $FILE
  fi
}

###############################################
# Write Memory Footprint
###############################################
Write_Memory_Footprint() {
  local FOOTFILE="/tmp/memfoot.txt"

  $ECHO "" >> $FILE
  if [ -e $FOOTFILE ]; then
    $CP $FOOTFILE $WORK_DIR
    $ECHO "Memory Footprint file: $WORK_DIR/memfoot.txt" >> $FILE
  else
    $ECHO "Memory Footprint file: ERROR - Does not Exist!" >> $FILE
  fi  
}

###############################################
# Write Debug and Error Logs
###############################################
Write_Logs() {
  local COUNT=""

  if [ $SRA_SUPPORT_PRESENT = "y" ]; then
    $MKDIR $WORK_DIR/amlogs
    $CP /var/opt/SUNWam/debug/* $WORK_DIR/amlogs/
    $CP /var/opt/SUNWam/logs/* $WORK_DIR/amlogs/
    $CP $IDSAME_BASEDIR/SUNWam/servers/https-$WS_HOST/logs/errors $WORK_DIR/amlogs/
    $ECHO "" >> $FILE
    $ECHO "Log Files: $WORK_DIR/amlogs/" >> $FILE
    COUNT=`$GREP "xception" $WORK_DIR/amlogs/errors | $WC -l`
    $ECHO "Total $COUNT exception(s) in webserver" | $SED -e "s/Total/    Total/" >> $FILE
    $GREP "xception" $WORK_DIR/amlogs/errors | $SED -e "s/^.*] failure/    failure/" | $PERLSCRIPT >> $FILE
  fi
}

###############################################
# Write Rewriter Ruleset
###############################################
Write_Rewriter_Ruleset() {
  local BASEDIR=""
  local CONFFILE=""
  local ADMIN_DN=""
  local PASSWORD=""
  local TEMP=""

  if [ $SRA_SUPPORT_PRESENT = "y" ]; then
    BASEDIR=`$GREP "^BASEDIR=" //var/sadm/pkg/SUNWpsrw/pkginfo | $SED -e "s/BASEDIR=//"`
    CONFFILE="/etc/opt/SUNWam/config/AMConfig.properties"
    ADMIN_DN=`$GREP "^com.iplanet.authentication.super.user=" $CONFFILE | $SED -e "s/com.iplanet.authentication.super.user=//"`
    PASSWORD=`$GREP "^ADMINPASSWD=" /var/sadm/pkg/SUNWamsvc/pkginfo | $SED -e "s/ADMINPASSWD=//"`
    STR=`$BASEDIR/SUNWps/bin/rwadmin list --runasdn "$ADMIN_DN" --password "$PASSWORD"`

    $MKDIR $WORK_DIR/rwrulesets
    for RULE in $STR; do
      TEMP=`$BASEDIR/SUNWps/bin/rwadmin get --rulesetid "$RULE" --runasdn "$ADMIN_DN" --password "$PASSWORD" $WORK_DIR/rwrulesets/$RULE.xml`
    done

    $ECHO "" >> $FILE
    $ECHO "Rewriter Rulesets: $WORK_DIR/rwrulesets" >> $FILE
  fi
}

###############################################
# Write Footer
###############################################
Write_Footer() {
  $ECHO "" >> $FILE
  $ECHO "" >> $FILE
  $ECHO "--------------------------------------------------------------" >> $FILE
  $ECHO "--------------------------------------------------------------" >> $FILE
}

###############################################
# Main 
###############################################

STR=$0

CheckRootUser

DirInit

SetGlobals

Write_Header

Write_PS_SRA

Write_Versions

Write_System_Conf

Write_Processor_Info

Write_Install_Log

Write_Platform_Conf

Write_Gateway_Script

Write_Gateway_Admin_Console

Write_Tuning_Info

Write_GC_Output

Write_Memory_Footprint

Write_Logs

Write_Rewriter_Ruleset

Write_Footer

$ECHO ""
$ECHO "The troubleshooting data is available in folder $WORK_DIR"
