/*
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * "%Z%%M%    %I%    %E%    SMI"
 */

package com.sun.netstorage.array.mgmt.cfg.ui.business.ws;

import com.sun.netstorage.array.mgmt.cfg.cli.server.*;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.*;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import java.util.*;
import java.io.*;
import java.lang.*;
import org.apache.soap.rpc.SOAPContext;

// sccs list alerts

public class RasAdmin extends CommandProcessorBase  {

    String RASADMIN;
    String CONFIG;
    String SYSADMIN;
    String REVISION;
    String REVISION_DOWN;
    String REVISION_UPGRADE;
    String REVISION_DOWNGRADE;

    public RasAdmin() {
      RASADMIN = "/opt/SUNWstade/bin/ras_admin";
      CONFIG   = "/opt/SUNWstade/sysbin/config_solution";
      SYSADMIN = "/opt/SUNWstade/sysbin/sys_admin";
      REVISION = "/opt/SUNWstade/bin/ras_patchlist";
      REVISION_DOWN = "/opt/SUNWstade/bin/ras_patchdowngrade";
      REVISION_UPGRADE = "/opt/SUNWstade/bin/ras_upgrade";
      REVISION_DOWNGRADE = "/opt/SUNWstade/bin/ras_downgrade";
    }

    protected CommandResult doList(Locale locale,
      ParsedCommandLine pcl, SOAPContext argContext) throws Exception {

      CommandResult cr = new CommandResult();
      String args = getArgs(pcl, cr);

      Resource res = pcl.getResource();
      CommandResult result = new CommandResult();
      String command;
      String buffer;

      if (res.getType().equals("alarms")) {
         command = RASADMIN + " alert_list" + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("alarm")) {

         if (findOption(args, "-a"))  {
            args = replaceOption(args, "-a","");
            command = RASADMIN + " alert_list" + args;
            buffer = exec(command);
            buffer = runWithAdvisor (buffer);
            cr.setResult(command + "\n" + buffer.toString() );
         } else {
            command = RASADMIN + " alert_list" + args;
            buffer = exec(command);
            cr.setResult(command + "\n" + buffer.toString() );
         }


      } else if (res.getType().equals("advisor")) {
         command = RASADMIN + " advisor" + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("devices")) {
         command = RASADMIN + " device_list" + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("device")) {
         command = RASADMIN + " device_detail" +args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("notification")) {
         command = RASADMIN + " email_list " + args;
         buffer = exec(command);
         command = RASADMIN + " provider_list " + args;
         buffer = buffer +"\n"+exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      }  else if (res.getType().equals("site")) {
         command = RASADMIN + " site_info " + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("ethers")) {
         command = RASADMIN + " ethers_list " + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("ethers")) {
         command = RASADMIN + " ethers_list " + args;
         buffer = exec(command);
         cr.setResult(command + "\n" + buffer.toString() );

      } else if (res.getType().equals("revision")) {

         if (findOption(args, "-u"))  {
           command = REVISION_DOWN + " -S storade " + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );
         } else  {
           command = REVISION + " -S storade ";
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );
         }

      }
      return cr;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl,
        SOAPContext argContext) throws Exception {

        CommandResult cr = new CommandResult();
        String args = getArgs(pcl, cr);

        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        String command;
        String buffer;

        if (res.getType().equals("notification")) {

           if (args.startsWith(" -e")) {
             command = RASADMIN + " email_add" + args;
             buffer = exec(command);
             cr.setResult(command + "\n" + buffer.toString() );
           } else {
             String firstOption = res.getFirstValue();

             if ("local_email".equalsIgnoreCase(firstOption))  {
                cr.setResult ("\nUsage : sscs add -e <email_address> notification local_email");
                return cr;
             } else if ("sae".equalsIgnoreCase(firstOption) )  {
                if ((args == null) || (!args.startsWith(" -i"))) {
                  cr.setResult ("\nUsage : sscs add -i <ip_address> notification sae");
                  return cr;
                }
                command = RASADMIN + " provider_on -p " + firstOption + args;
             } else if ("trap".equalsIgnoreCase(firstOption))  {
                if ((args == null) || (!args.startsWith(" -i"))) {
                  cr.setResult ("\nUsage : sscs add -i <ip_address> -t <trap_level> -l <warning|error|down> notification trap"+
                                "\n\t -t trap number for trap provider. Valid numbers are 1 through 5."+
                                "\n\t -l warning:error:down trap level for trap provider.");
                  return cr;
                }
                command = RASADMIN + " provider_on -p " + firstOption + args;
             } else {

                command = RASADMIN + " provider_on -p " + firstOption;
             }

             buffer = exec(command);
             cr.setResult(command + "\n" + buffer.toString() );
           }

        } else if (res.getType().equals("ethers")) {

           command = RASADMIN + " ethers_add" + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        }

        return cr;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl,
        SOAPContext argContext) throws Exception {

        CommandResult cr = new CommandResult();

        String args = getArgs(pcl, cr);

        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        String command;
        String buffer;

        if (res.getType().equals("notification")) {

           if (args.startsWith(" -e")) {
             command = RASADMIN + " email_delete" + args;
             buffer = exec(command);
             cr.setResult(command + "\n" + buffer.toString() );
           } else {
             String firstOption = res.getFirstValue();

             if ("local_email".equalsIgnoreCase(firstOption))  {
                cr.setResult ("\nUsage : sscs remove -e <email_address> notification local_email");
                return cr;
             } else if ("trap".equalsIgnoreCase(firstOption))  {
                if ((args == null) || (!args.startsWith(" -t"))) {
                  cr.setResult ("\nUsage : sscs remove -t <trap_number> notification trap"+
                                "\n\t -t trap number for trap provider. Valid numbers are 1 through 5.");
                  return cr;
                }
                command = RASADMIN + " provider_off -p " + firstOption + args;
             } else {
                command = RASADMIN + " provider_off -p " + firstOption;
             }

             buffer = exec(command);
             cr.setResult(command + "\n" + buffer.toString() );

           }

        } else if (res.getType().equals("alarm")) {
           command = RASADMIN + " alert_delete" + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        } else if (res.getType().equals("ethers")) {
           command = RASADMIN + " ethers_delete" + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        } else if (res.getType().equals("revision")) {
           command = REVISION_DOWNGRADE +" -S storade -U -b";
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );
        }

        return cr;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl,
        SOAPContext argContext) throws Exception {

        CommandResult cr = new CommandResult();
        String args = getArgs(pcl, cr);

        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        String command;
        String buffer;

        if (res.getType().equals("countrycode")) {
           command = SYSADMIN + " set_countrycode" + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        } else if (res.getType().equals("site")) {
           command = RASADMIN + " site_info_upd" + args;
           buffer = exec(command);
           command = RASADMIN + " site_info";
           buffer = "Site info. updated ! \n"+exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        } else if (res.getType().equals("inventory")) {
           command = CONFIG + args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );

        } else if (res.getType().equals("revision")) {
           command = REVISION_UPGRADE + " -S storade "+ args;
           buffer = exec(command);
           cr.setResult(command + "\n" + buffer.toString() );
        }

        return cr;
    }

    protected String getArgs(ParsedCommandLine pcl, CommandResult cr1) {

      List options = pcl.getOptions();
      StringBuffer args = new StringBuffer("");

      for (int i = 0; i < options.size(); i++) {
        Option option = (Option)options.get(i);
        String optionName = stripToShortName(option.getName());
        args.append(" " + optionName);
        if (option.getFirstValue() != null) {
           args.append(" " + option.getFirstValue());
        }
      }

      return args.toString();
    }

    protected boolean findOption(String originalString, String oldStr) {

      StringTokenizer strToken = new StringTokenizer (originalString, " ");

      while (strToken.hasMoreTokens()) {
        String currentToken = (String) strToken.nextToken();
        if (oldStr.equalsIgnoreCase(currentToken)) {
           return true;
        }
      }

      return false;
    }

    protected String replaceOption(String originalString, String oldStr,
                                                              String newStr) {

      StringTokenizer strToken = new StringTokenizer (originalString, " ");
      StringBuffer returnString = new StringBuffer();
      while (strToken.hasMoreTokens()) {
        String currentToken = (String) strToken.nextToken();
        if (oldStr.equalsIgnoreCase(currentToken))
          returnString.append(newStr);
        else
          returnString.append(" "+currentToken);
      }

      return returnString.toString();
    }

    private String runWithAdvisor(String originalString) {

      StringTokenizer strToken = new StringTokenizer (originalString, "\n");
      String eventCode = null;
      StringBuffer newstring = new StringBuffer();
      while (strToken.hasMoreTokens()) {
        String currentToken = (String) strToken.nextToken();
        if (currentToken.startsWith("Event Code")) {
           eventCode = currentToken.substring
                       (currentToken.indexOf(":")+1, currentToken.length());
           String command = RASADMIN + " advisor -e " + eventCode.trim();
           String newbuf = exec(command);
           if (newbuf != null)
              newstring.append("\nSERVICE ADVISOR\n" + newbuf);
        } else {
          newstring.append(currentToken+"\n");
        }
      }

      return newstring.toString();
    }

    protected String stripToShortName(String optionName)  {
      if (optionName.startsWith("--")) {
        char firstChar = optionName.charAt(2);
        return "-"+firstChar;
      }
      return optionName;
    }

    protected String exec(String commandLine) {
      String output;
      String errorOutput;
      try {
        output = Exec.exec(commandLine).toString();
      } catch(SecurityException se) {

        return se.getMessage();
      } catch (NullPointerException npe) {

        return npe.getMessage();
      } catch (IllegalArgumentException iae) {

        return iae.getMessage();
      } catch (Exception e) {

        return e.getMessage();
      }
      return output;
    }
}


