/************************************<+>*************************************
 ****************************************************************************
 *
 *   FILE:           ModPriv.h
 *
 *   COMPONENT_NAME: Desktop File Manager
 *
 *   DESCRIPTION:    Public include file for the modify file attributes dialog.
 *
 *   (c) Copyright 1993, 1994, 1995 Hewlett-Packard Company
 *   (c) Copyright 1993, 1994, 1995 International Business Machines Corp.
 *   (c) Copyright 1993, 1994, 1995, 1996 by Sun Microsystems, Inc.
 *   (c) Copyright 1993, 1994, 1995 Novell, Inc.
 *
 ****************************************************************************
 ************************************<+>*************************************/

#pragma ident	"@(#)ModPriv.h	1.5	97/11/06 SMI; TSOL 2.x"


#ifndef _ModPriv_h
#define _ModPriv_h

#include <stdio.h> /* for FILENAME_MAX */
#include <tsol/priv.h>

#define FRAME_OFFSET    13              /* margin around frames */
#define SIDE_OFFSET      3              /* gap between widgets & frame */
#define WIDGET_OFFSET    7              /* gap between widgets & labels */
#define SCROLLBAR_WIDTH 25
#define ARROW_WIDTH     25

typedef enum {
	PRIV_SHOW	= 1,
	PRIV_USERFIELD	= 2,
	PRIV_INC_PRIVS	= 3,
	PRIV_EXC_PRIVS	= 4,
	PRIV_TITLE	= 5
} Priv_attributes;

typedef struct pv_private {
	Bool		show;
	Bool		initialized;
	Position	x;
	Position	y;
	Dimension	width;
	Dimension	height;
	void            (*event_handler)();
	priv_set_t	exc_priv_set;
	priv_set_t	inc_priv_set;
	int		num_privs;
	char		plist[TSOL_MAX_PRIV][64];
	char		*ptext[TSOL_MAX_PRIV];
	char		*name_field;
	char		*priv_title;
	int		plist_id[TSOL_MAX_PRIV];
	int             plist_cnt[TSOL_MAX_PRIV];
	int		ain_list[TSOL_MAX_PRIV];
	int		aex_list[TSOL_MAX_PRIV];
	int		ain_count;
	int		aex_count;
	Widget	priv_dialog;
	Widget	priv_lbl;
	Widget	excluded_lbl;
	Widget	included_lbl;
	Widget	ex_list;
	Widget	ex_horscroll;
	Widget	ex_vertbar;
	Widget	ex_list2;
	Widget	toparrow;
	Widget	bottomarrow;
	Widget	in_list;
	Widget	in_horscroll;
	Widget	in_vertscroll;
	Widget	in_list2;
	Widget	selectall;
	Widget	clearall;
	Widget	reset;
	Widget	desc_lbl;
	Widget	name_lbl;
	Widget	desc_scroll;
	Widget	desc_horscroll;
	Widget	desc_vertscroll;
	Widget	desc_text;
	Widget	ok;
	Widget	cancel;
	Widget	help;
	Widget	priv_frame;
	Widget	priv_form;
	Widget	privL;
	Widget	separator;
} ModPrivData;

#endif /* _ModPriv_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */

