$control: 1
lex:
{
    define: ALNUM "[A-Za-z0-9\x80-\x9B\x9D\xA0-\xA7\xB5-\xB7\xC6\xC7\xD0-\xD8\xE0-\xED]"  #support other Western European locales
    define: W "[ \t\f\r\v]"     # Valid whitespace characters
    define: OTHER "[#$%&*_+|~`./]"      # note that '.' will allow for version2.1
                                        # and '/' will pick up OS/2 (but also filepaths)

    token: WORD "{ALNUM}({OTHER}*{ALNUM})*"
    token: WORD "{ALNUM}+[+]+"  # pick up things like tools++, c++
    token: WORD "@{ALNUM}+"     # pick up things like @home

    token: EOS "[.?!][.?! \t]*"
    token: EOP "{W}*\n({W}*\n)+"

    token: NEWLINE "{W}*\n"
    token: TAB "\t"
    token: WHITE "{W}+"
    token: PUNCT "."
}
$$
