#
# Sample charset file for VDK 2.0.
#
$control: 1
charset:
{
  #
  # Description: Name another character set from which to inherit the 
  # initial set of attributes. Any settings in this file will overwrite 
  # that initial set of attributes.
  #
  # Default: 850
  #
  # This keyword is optional
  inherit: charset-name

  #
  # Description: This gives the major and minor version number of the
  #   the current charset. This information is stamped into collections
  #   when they are created so that you can tell which version of a
  #   charset the collection is created with.
  #
  # Default: The default version is 1.0
  #
  # These keywords are optional
  Major-Version: number
  Minor-Version: number

  #
  # Description: Load in a library of routines to implement functional 
  # callbacks for this character set. Fill in a normal DDA spec for a library 
  #
  # Example:  
  #  driver: "DLL:/usr/verity/bin/8859.so:Init8859"
  #
  # This keyword is optional
  driver: dda-spec

  #
  # Description: What type of character set is this?
  #
  # This keyword is required
  type: "singlebyte" or "multibyte"

  #
  # Description: list shift-in and shift-out characters if this is a 
  # shifted multibyte character set.
  #
  # Note: the type keyword must be set to multibyte. A multibyte
  # charset is flagged as shifted multibyte by putting in one of these 
  # shift keywords.
  #
  # This keyword is required
  shift: "shift-in-char" "shift-out-char"

  #
  # Description: If there is a character that is defined to be invalid 
  # put it here.
  #
  # Default: none
  #
  # This keyword is optional
  invalid: "char"

  #
  # Description: Define an 8 bit character set mapping tables. 
  #
  # Note: It may only be used for an 8bit to 8bit mapping.  
  # These are the same format as in the old vdk10.cmp files, but
  # the difference is that these tables show how to EXPORT from this 
  # character set to an external character set, whereas the old .cmp files 
  # showed how to import.
  #
  # You can specify 0 or more tables, one for each external charset you 
  # wish to support.
  table: name
  {
    text: 0  "\x00\x01\x02 ..."
    text: 16 "\x00\x01\x02 ..."
    ...
  }

  #
  # Description: Multibyte character set mapping table.
  # any charset (8bit, multibyte) -> any external charset (8bit, multibyte)
  #
  # Note: If this character set is a multibyte character set, you can only 
  # use this type of mapping and not the 8bit table above.
  #
  # You can specify 0 or more tables, one for each external charset you 
  # wish to support.
  mtable: name type
  {
    # invalid char for the external char set
    invalid: "char"
    # shift characters for the external char set
    shift: "shift-in-char" "shift-out-char"

    map: "src-char" "dest-char"
    map: "src-char" "dest-char"
    ...
    map: "src-char" "dest-char"
  }

  #
  # Description: List of all valid characters in this charset to generate 
  # a "next char" table for non-shifted multibyte charsets. This table 
  # is used to iterate through and manipulate multibyte strings.
  #
  # This keyword is required for non-shifted multibyte character sets only.
  nextchar:
  {
    char: "char"
    char: "char"
    char: "char"
    ...
  }
}
