#!/bin/sh
# \
	exec tclsh "$0" ${1+"$@"}

#
# Copyright C 2001-2003 Sun Microsystems, Inc. Some preexisting portions Copyright
# C 1998-2000 Innosoft International Inc. All rights reserved.
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#



proc cmd { x } {
    global tcl_platform

    if [string equal $tcl_platform(platform) "unix"] {
    } else {
	append x ".exe"
    }
    return $x
}

proc escape { x } {
    regsub -all {\\} $x {\\&} x
    return $x
}

proc dsRoot { xName } {
    upvar $xName x

    set rc [expr 0]

    if [regexp -nocase -- "^ldap://(\[^:\]+):(\[0-9]+)" $x(url) a host port] {
	set ldapsearch [file join $x(currentinstalldirectory) bin/dps/server/bin [cmd ldapsearch]]
	if [file isfile $ldapsearch] {
	    set cmd [list exec $ldapsearch -p $port -h $host -b o=netscaperoot -s subtree -D [subst $x(bind_dn)] -w $x(bind_pw) "(&(nsserverid=slapd-$x(hostname))(serverroot=[escape [file nativename $x(root)]])(objectclass=nsdirectoryserver)(serverhostname=$host)(nsserverport=$port)(cn=slapd-$x(hostname)))" dn]

	    if [catch $cmd result] {
	    } else {
		if [regexp -nocase -- "slapd-$x(hostname)" $result] {
		    set rc [expr 1]
		}
	    }
	}
    }
    return $rc
}

proc popDpsInf { xName } {
    upvar $xName x
    set infFile [file join $x(root) setup/dps/dps.inf]
    set iFile [open $infFile r]

    while {[gets $iFile line] >= 0} {
	if [regexp -nocase -- "^dependencies=" $line] {
	    lappend y "$line,slapd/5.2"
	} else {
	    lappend y $line
	}
    }

    close $iFile

    set oFile [open $infFile w]

    foreach i $y {
	puts $oFile $i
    }

    close $oFile
}

proc create { name oName xName {aName ""}} {
    upvar $xName x
    set oFile [open $oName w]
    if [string length $aName] {
	set aFile [open $aName w]
	$name $oFile x $aFile
	close $aFile
    } else {
	$name $oFile x
    }
    close $oFile
}

proc emit { oFile xName } {
    upvar $xName x

    puts $oFile "dn: [lindex $x(dn) 0]"

    foreach j [lsort $x(objectclass)] {
	puts $oFile "objectclass: [string tolower $j]"
    }

    foreach i [lsort [array names x]] {
	if [string equal "dn" $i] {
	} else {
	    if [string equal "objectclass" $i] {
	    } else {
		foreach j $x($i) {
		    puts $oFile "[string tolower $i]: $j"
		}
	    }
	}
    }

    puts $oFile ""

    unset x
}

proc emitBase { oFile pName aFile} {
    upvar $pName p
    
    set dn "cn=$p(host), ou=$p(domain), o=NetscapeRoot"
    set child "cn=$p(server), $dn"
    
    set x(dn) [list $dn]
    set x(cn) [list $p(host)]
    set x(objectclass) [list nsHost groupOfUniqueNames]
    set x(uniqueMember) [list $child]
    
    if {0} {
	emit $oFile x
    } else {
	unset x
    }
    
    set dn $child
    set x(dn) [list $dn]
    set x(cn) [list $p(server)]
    set x(objectclass) [list nsAdminGroup groupOfUniqueNames nsDirectoryInfo top]
    set x(nsAdminGroupName) $x(cn)
    set x(nsConfigRoot) [list [file nativename $p(root)]]
    set child "cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"
    set x(uniqueMember) [list $child]

    if {0} {
	emit $oFile x
    } else {
	puts $aFile "dn: $dn"
	puts $aFile "changetype: modify"
	puts $aFile "add: uniqueMember"
	puts $aFile "uniqueMember: $child"
	unset x
    }

    set dn $child
    set x(dn) [list $dn]
    set x(cn) [list "Sun ONE Directory Proxy Server"]
    set x(description) [list "An LDAP application layer protocol gateway."]
    set x(nsVendor) [list "Sun Microsystems, Inc."]
    set x(nsServerID) [list "dps"]
    set x(nsRevisionNumber) [list "$p(revision)"]
    set x(nsProductVersion) [list "$p(version)"]
    set x(nsProductName) [list "Sun Java(TM) System Directory Proxy Server"]
    set x(nsInstalledLocation) [list [file nativename $p(root)]]
    set x(nsNickName) [list "dps"]
    set child "cn=$p(belongs-to), $dn"
    # set x(uniqueMember) [list $child]
    set x(nsBuildNumber) [list "$p(build)"]
    set x(nsBuildSecurity) [list "$p(security)"]
    set x(installationTimeStamp) [list $p(timestamp)]
    set x(objectclass) [list "nsApplication" "groupOfUniqueNames" "nsadminserver"]

    emit $oFile x
    
    set dn $child
    set x(dn) [list $dn]
    set x(cn) [list "$p(belongs-to)"]
    set x(ids-proxy-con-Server-Name) [list "$p(belongs-to)"]
    set x(description) [list "An instance of a Sun Java(TM) System Directory Proxy Server"]
    set x(nsServerID) [list "$p(belongs-to)"]
    set x(serverProductName) [list "Directory Proxy Server ($p(belongs-to))"]
    set x(ids-proxy-sch-Global-Config-Dn) [list "ids-proxy-con-config-name=$p(config), ou=system, ou=dar-config, o=NetscapeRoot"]
    set x(serverRoot) [list [file nativename $p(root)]]
    set x(installationTimeStamp) [list $p(timestamp)]
    set x(serverHostName) [list $p(host)]
    set x(ids-proxy-sch-Group-Base) [list "ou=groups, cn=$p(config), ou=dar-config, o=NetscapeRoot"]
    set x(ids-proxy-sch-Rule-Base) [list "ou=rules, cn=$p(config), ou=dar-config, o=NetscapeRoot"]
    set x(ids-proxy-sch-Property-Base) [list "ou=properties, cn=$p(config), ou=dar-config, o=NetscapeRoot"]
    set x(ids-proxy-sch-Action-Base) [list "ou=actions, cn=$p(config), ou=dar-config, o=NetscapeRoot"]
    set x(objectclass) [list "netscapeServer" "groupOfUniqueNames" "nsdarserver" "ids-proxy-sch-ldapproxy"]

    emit $oFile x
    
    set dn "cn=configuration, $dn"
    set x(dn) [list $dn]
    set x(cn) [list "configuration"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.IDARServer@dps524.jar$p(sie)"]
    set x(objectclass) [list "nsConfig" "nsAdminObject"]

    emit $oFile x
}

proc emitDefault { oFile pName} {
    upvar $pName p
    global tcl_platform

    set dn "ou=dar-config, o=NetscapeRoot"
    set x(dn) [list $dn]
    set x(ou) [list "dar-config"]
    set x(objectclass) [list "ids-proxy-top"]

    emit $oFile x

    set dn "ou=system, ou=dar-config, o=NetscapeRoot"
    set x(dn) [list $dn]
    set x(objectclass) [list "ids-proxy-top"]

    emit $oFile x
    
    set x(dn) [list "ids-proxy-con-config-name=$p(config), $dn"]
    set x(ids-proxy-con-listen-port) [list "$p(listen)"]
    set x(ids-proxy-con-include-logproperty) [list $p(config)]
    set x(ids-proxy-con-config-name) [list $p(config)]

    if [string equal "unix" $tcl_platform(platform)] {
	catch {
	    set iName [file join $p(root) admin-serv config magnus.conf]
	    set iFile [open $iName r]
	    while {[gets $iFile line] >= 0} {
		if [regexp -nocase "^user " $line] {
		    set x(ids-proxy-con-userid) [list [string range $line 5 end]]
		}
	    }
	    close $iFile
	} result
    }

    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(ids-proxy-sch-global-base) [list "ou=properties, $dn"]
    set x(objectclass) [list "ids-proxy-sch-GlobalConfiguration" "ids-proxy-top"]

    emit $oFile x

    set dn "ou=properties, $dn"
    set x(dn) [list $dn]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(objectclass) [list "ids-proxy-top"]

    emit $oFile x

    set x(dn) [list "ids-proxy-con-Name=$p(config), $dn"]
    set x(ids-proxy-con-name) [list $p(config)]
    set x(ids-proxy-sch-enable) [list "true"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(ids-proxy-con-log-file) [list [file nativename [file join $p(root) "$p(instance)" "logs/fwd.log"]]]
    if [file exists [file join $p(root) bin/dps/install/build_DBG.txt]] {
	set x(ids-proxy-con-stat-level) [list "mods|op|conn|stat|audit|acl"]
	set x(ids-proxy-con-log-level) [list "detail_trace"]
    } else {
	set x(ids-proxy-con-stat-level) [list "none"]
	set x(ids-proxy-con-log-level) [list "warning"]
    }
    set x(ids-proxy-con-Priority) [list "0"]
    set x(objectclass) [list "ids-proxy-sch-logproperty"]

    emit $oFile x
    
    set dn "cn=$p(config), ou=dar-config, o=NetscapeRoot"
    set x(dn) [list $dn]
    set x(cn) [list "$p(config)"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(objectclass) [list "nsdarconfiguration"]

    emit $oFile x
    
    set x(dn) [list "ou=actions, $dn"]
    set x(ou) [list "actions"]
    set x(objectclass) [list "ids-proxy-top"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]

    emit $oFile x
        
    set x(dn) [list "ou=groups, $dn"]
    set x(ou) [list "groups"]
    set x(objectclass) [list "ids-proxy-top"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]

    emit $oFile x
    
    set x(dn) [list "ids-proxy-con-name=network-group-1, ou=groups, $dn"]
    set x(ids-proxy-con-client) [list "0.0.0.0"]
    set x(ids-proxy-con-name) [list "network-group-1"]
    set x(ids-proxy-con-include-property) [list "load-balancing-1"]
    set x(ids-proxy-sch-enable) [list "true"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(ids-proxy-con-bind-name) [list ""]
    set x(ids-proxy-con-Priority) [list "0"]
    set x(objectclass) [list "ids-proxy-sch-NetworkGroup"]

    emit $oFile x

    set x(dn) [list "ou=properties, $dn"]
    set x(ou) [list "properties"]
    set x(objectclass) [list "ids-proxy-top"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]

    emit $oFile x
    
    set x(dn) [list "ids-proxy-con-name=ldap-server-1, ou=properties, $dn"]
    set x(ids-proxy-con-link-security-policy) [list "ssl_optional"]
    set x(ids-proxy-con-supported-version) [list "23"]
    set x(ids-proxy-con-name) [list "ldap-server-1"]
    set x(ids-proxy-con-port) [list $p(repositoryport)]
    set x(ids-proxy-con-use-version) [list "23"]
    set x(ids-proxy-sch-enable) [list "true"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(ids-proxy-con-host) [list $p(repositoryhost)]
    set x(ids-proxy-con-Priority) [list "0"]
    set x(objectclass) [list "ids-proxy-sch-LDAPServer"]

    emit $oFile x

    set x(dn) [list "ids-proxy-con-name=load-balancing-1, ou=properties, $dn"]
    set x(ids-proxy-con-Name) [list "load-balancing-1" ]
    set x(ids-proxy-con-server) [list "ldap-server-1#100"]
    set x(ids-proxy-sch-Enable) [list "true"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]
    set x(ids-proxy-con-Priority) [list "0"]
    set x(objectclass) [list "ids-proxy-sch-loadbalanceproperty"]

    emit $oFile x

    set x(dn) [list "ou=rules, $dn"]
    set x(ou) [list "rules"]
    set x(objectclass) [list "ids-proxy-top"]
    set x(ids-proxy-sch-belongs-to) [list $p(belongs-to)]

    emit $oFile x
}

proc emitTask { oFile pName } {
    upvar $pName p
    global tcl_platform
   
    set x(dn) [list "cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "Tasks"]
    set x(objectclass) [list "nsResourceRef"]

    emit $oFile x

    set x(dn) [list "cn=XTL, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "XTL"]
    set x(nsExecRef) [list "java:XtlAdmin@xtl-admin-engine.jar?xtl.base.dir=[file join $p(currentinstalldirectory) bin/dps/admin/servlets]"]
    set x(objectclass) [list "nsadminobject" "nstask"]

    emit $oFile x

    set x(dn) [list "cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "Operation"]
    set x(nsTaskLabel) [list "Operation Tasks Group"]
    set x(objectclass) [list "nstaskgroup"]

    emit $oFile x

    set x(dn) [list "cn=KeyCert, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "KeyCert"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.task.KeyCert@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x

    set x(dn) [list "cn=ConfigureLoadBalancing, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "ConfigureLoadBalancing"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.task.ConfigureLoadBalancing@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x
    
    set x(dn) [list "cn=Start, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "Start"]
    set x(nsExecRef) [list "java:com.iplanet.idar.task.StartServlet@dps-server52.jar"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.task.Start@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x
    
    set x(dn) [list "cn=Stop, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "Stop"]
    set x(nsExecRef) [list "java:com.iplanet.idar.task.StopServlet@dps-server52.jar"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.task.Stop@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x
    
    set x(dn) [list "cn=ViewLogFile, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "ViewLogFile"]
    set x(nsExecRef) [list "java:com.iplanet.idar.task.ViewLogFileServlet@dps-server52.jar"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x
    
    set x(dn) [list "cn=Restart, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "Restart"]
    set x(nsExecRef) [list "java:com.iplanet.idar.task.RestartServlet@dps-server52.jar"]
    set x(nsClassname) [list "com.iplanet.idar.ui.server.task.Restart@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstask" "nsAdminObject"]

    emit $oFile x
    
    set x(dn) [list "cn=ServerStatus, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "ServerStatus"]
    set x(nsExecRef) [list "java:com.iplanet.idar.task.StatusServlet@dps-server52.jar"]
    set x(objectclass) [list "nstask"]

    emit $oFile x

    if [string equal "unix" $tcl_platform(platform)] {

	set x(dn) [list "cn=Ping, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
	set x(cn) [list "Ping"]
	set x(nsExecRef) [list "java:com.iplanet.idar.task.PingServlet@dps-server52.jar"]
	set x(objectclass) [list "nstask"]

	emit $oFile x

	set x(dn) [list "cn=ReloadConfiguration, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
	set x(nsClassname) [list "com.iplanet.idar.ui.server.task.ReloadConfiguration@dps524.jar$p(sie)"]
	set x(cn) [list "ReloadConfiguration"]
	set x(nsExecRef) [list "java:com.iplanet.idar.task.ReloadConfigurationServlet@dps-server52.jar"]
	set x(objectclass) [list "nstask" "nsAdminObject"]

    } else {

	set x(dn) [list "cn=Ping, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
	set x(cn) [list "Ping"]
	set x(nsExecRef) [list "status"]
	set x(objectclass) [list "nstask"]
	
	emit $oFile x

	set x(dn) [list "cn=startnt, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
	set x(cn) [list "startnt"]
	set x(nsExecRef) [list "start"]
	set x(objectclass) [list "nstask"]
	
	emit $oFile x

	set x(dn) [list "cn=stopnt, cn=Operation, cn=Tasks, cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"]
	set x(cn) [list "stopnt"]
	set x(nsExecRef) [list "shutdown"]
	set x(objectclass) [list "nstask"]
    }
    
    emit $oFile x
}

proc emitTopology { oFile pName } {
    upvar $pName p

    set x(dn) [list "cn=dpsconfigplugin, cn=topologyplugin, ou=4.0, ou=Admin, ou=Global Preferences, ou=$p(domain), o=NetscapeRoot"]
    set x(cn) [list "dpsconfigplugin"]
    set x(nsclassname) [list "com.iplanet.idar.ui.configurator.ConfiguratorTopologyPlugin@dps524.jar$p(sie)"]
    set x(objectclass) [list "nstopologyplugin"]

    emit $oFile x
}

proc emitNickname { oFile pName } {
    upvar $pName p

    set x(dn) [list "cn=Client, ou=Admin, ou=Global Preferences, ou=$p(domain), o=NetscapeRoot"]
    set x(nsnickname) [list "dps, Sun ONE Directory Proxy Server"]
    set x(objectclass) [list "nsAdminGlobalParameters" "nsResourceRef" "extensibleObject"]

    emit $oFile x
}

proc fetchServer { root } {
    set iName [file join $root admin-serv/config/adm.conf]

    set iFile [open $iName r]

    set server "Server Group"

    while {[gets $iFile line] >= 0} {
	if [regexp -nocase "^isie\:" $line] {
	    regexp -nocase "(\[^,\]+),(\[^,\]+)," $line a b c
	    regexp -nocase "(\[^=\]+)=(.+)" $c d e server
	}
    }

    close $iFile

    return $server
}

proc fetchSIE { root } {
    set iName [file join $root admin-serv/config/adm.conf]

    set iFile [open $iName r]

    set sie ""

    while {[gets $iFile line] >= 0} {
	if [regexp -nocase "^sie\:" $line] {
	    regexp -nocase "^sie\:\[ \t\]*(.+)" $line a sie
	}
    }

    close $iFile

    if [string length $sie] {
	set sie "@$sie"
    }

    return $sie
}

proc required { xName value eName } {
    upvar $xName x
    upvar $eName errmsg

    if [string length $x($value)] {
    } else {
	lappend errmsg [list "The required option -$value wasn't given."]
    }
}

proc tailor { pName } {
    upvar $pName p
    global tcl_platform

    set oName [file join $p(root) $p(instance)/etc/tailor.txt]

    if [string equal $tcl_platform(platform) "unix"] {
	set oFile [open $oName w 0600]
    } else {
	set oFile [open $oName w]
    }

    if [regexp -nocase "(ldap://\[^/\]+)/" $p(url) a url] {
    } else {
	set url $p(url)
    }

    puts $oFile "Begin"
    puts $oFile "configuration_url: $url/cn=$p(belongs-to), cn=Sun ONE Directory Proxy Server, cn=$p(server), cn=$p(host), ou=$p(domain), o=NetscapeRoot"
    puts $oFile "configuration_bind_dn: $p(bind_dn)"
    puts $oFile "configuration_bind_pw: $p(bind_pw)"
    puts $oFile "End"

    close $oFile
}

set mode ""
set errmsg [list]
set usage 0

#
# x(host) is the fully qualifed name
# x(hostname) is the name only, i.e. everything to the left of the first "."
#

set x(bind_dn) ""
set x(bind_pw) ""
set x(build) ""
set x(config) ""
set x(currentinstalldirectory) ""
set x(domain) ""
set x(host) ""
set x(hostname) ""
set x(instance) ""
set x(listen) ""
set x(repositoryhost) ""
set x(repositoryport) ""
set x(revision) "0"
set x(root) ""
set x(security) ""
set x(server) ""
set x(sie) ""
set x(url) ""
set x(version) "5.2.4"

foreach i $argv {
    switch -exact -- $mode {
	"" {
	    set j [string tolower $i]
	    set mode [string range $j 1 end]
	    switch -exact -- $j {
		-? {
		    set usage 1
		    set mode ""
		}
		-bind_dn { }
		-bind_pw { }
		-build { }
		-config { }
		-currentinstalldirectory { }
		-domain { }
		-help {
		    set usage 1
		    set mode ""
		}
		-host { }
		-hostname { }
		-instance { }
		-listen { }
		-repositoryhost { }
		-repositoryport { }
		-revision { }
		-root { }
		-security { }
		-server { }
		-sie { }
		-url { }
		-version { }
		default {
		    lappend errmsg [list "Unknown option $mode"]
		    set mode ""
		}
	    }
	}
	default {
	    set x($mode) $i
	    set mode ""
	}
    }    
}

if { $usage } {
    set errmsg [list]
} else {
    if [string length $mode] {
	lappend errmsg [list "$mode wasn't supplied a parameter."]
    }
    if [string length $x(root)] {
	if [file exists $x(root)] {
	    if [file isdirectory $x(root)] {
	    } else {
		lappend errmsg [list "$x(root) is not a directory."]
	    }
	} else {
	    lappend errmsg [list "$x(root) does not exist."]
	}
    }
    if [string length $x(currentinstalldirectory)] {
	if [file exists $x(currentinstalldirectory)] {
	    if [file isdirectory $x(currentinstalldirectory)] {
	    } else {
		lappend errmsg [list "$x(currentinstalldirectory) is not a directory."]
	    }
	} else {
	    lappend errmsg [list "$x(currentinstalldirectory) does not exist."]
	}
    } else {
	set x(currentinstalldirectory) $x(root)
    }
    if [string length $x(host)] {
	if [regexp "\[\.\]" $x(host)] {
	} else {
	    # lappend errmsg [list "The -host value ($x(host)) doesn't appear to be fully qualified."]
	}
    }
    foreach i [list bind_dn bind_pw build currentinstalldirectory domain host instance listen root security url] {
	required x $i errmsg
    }
}

if [llength $errmsg] {
    foreach i $errmsg {
	foreach j $i {
	    puts stderr $j
	}
    }
    set usage 1
}

if {$usage} {
    puts stderr "Usage:"
    puts stderr "./dpsInitLdif.tcl -listen portNbr -root NETSITE_ROOT -config configName"
    puts stderr "\t\t   -host fqHostname -domain dName -security \[export|domestic\]"
    puts stderr "\t\t   -bind_dn bindName -bind_pw bindPass -url configURL"
    puts stderr "\t\t   -build buildNumber -instance dirPath \[-version version\]"
    puts stderr "\t\t    \[-server isie\] \[-revision revision\] \[-sie sieDN\]"
    puts stderr "\t\t    \[-hostname hostname\] \[-repositoryhost hostname\]"
    puts stderr "\t\t    \[-repositoryport port\] \[-currentinstalldirectory path\]"
    puts stderr ""
    exit 1
}

if [string length $x(server)] {
} else {
    set x(server) [fetchServer $x(root)]
}

if [string length $x(sie)] {
} else {
    set x(sie) [fetchSIE $x(root)]
}

if [string length $x(hostname)] {
} else {
    if [regexp "(\[^\.\]+)." $x(host) a x(hostname)] {
    } else {
	set x(hostname) $x(host)
    }
}

if [string length $x(repositoryhost)] {
} else {
    set x(repositoryhost) $x(host)
}

if [string length $x(repositoryport)] {
} else {
    set x(repositoryport) "389"
}

set x(timestamp,raw) [clock seconds]

set x(timestamp) [clock format $x(timestamp,raw) -format "%Y%m%d%H%M%SZ" -gmt 1]

if [string length $x(config)] {
} else {
    set x(config) [clock format $x(timestamp,raw) -format "%Y.%j.%H.%M.%S" -gmt 1]
}

set x(belongs-to) $x(instance)

create emitBase [file join $x(root) $x(instance) etc/dpsBase.ldif] x [file join $x(root) $x(instance) etc/dpsISIE.ldif]
create emitDefault [file join $x(root) $x(instance) etc/dpsDefaultConfiguration.ldif] x
create emitTopology [file join $x(root) $x(instance) etc/dpsTopologyPlugin.ldif] x
create emitNickname [file join $x(root) $x(instance) etc/dpsNickname.ldif] x
create emitTask [file join $x(root) $x(instance) etc/dpsTask.ldif] x

tailor x

if [string equal $tcl_platform(os) AIX] {
    set fName [file join $x(root) start-admin]
    set iFile [open $fName r]
    set sa [list]
    
    if  {[gets $iFile line] >= 0} {
	lappend sa $line
	if  {[gets $iFile line] >= 0} {
	    lappend sa $line
	    lappend sa "#"
	    lappend sa "# The admin server on AIX is broken. Specifically it"
	    lappend sa "# only supports LANG=C. See 527654."
	    lappend sa "# This is DPS' work around via dpsInitLdif.tcl"
	    lappend sa "#"
	    lappend sa "LANG=C;export LANG"
	    
	    while {[gets $iFile line] >= 0} {
		lappend sa $line
	    }

	    close $iFile
	    set oFile [open $fName w 0755]
	    
	    foreach i $sa {
		puts $oFile $i
	    }
	    
	    close $oFile
	} else {
	    close $iFile
	}
    } else {
	close $iFile
    }
}

exit 0
