/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rsc.internal.pages;

import com.sun.rsc.internal.pages.AlertInfo;
import com.sun.rsc.internal.pages.PagingDialog;
import com.sun.rsc.internal.ssp.SSPDeviceManager;
import com.sun.rsc.internal.util.ColumnLayout;
import com.sun.rsc.internal.util.FilteredTextField;
import com.sun.rsc.internal.util.LAYOUT_ALIGNMENT;
import com.sun.rsc.internal.util.RSCException;
import com.sun.rsc.internal.util.RSCExceptionHandler;
import com.sun.rsc.internal.util.RSCFrame;
import com.sun.rsc.internal.util.RSCMessages;
import com.sun.rsc.internal.util.RSCProperties;
import com.sun.rsc.internal.util.RSCUtilities;
import com.sun.rsc.internal.util.RowLayout;
import com.sun.rsc.internal.util.TextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlertFrame
extends RSCFrame
implements ActionListener,
ItemListener,
ChangeListener,
KeyListener {
    public static String sccs_id = "@(#)AlertFrame.java 1.32 03/10/24 SMI";
    protected AlertInfo origInfo = null;
    protected AlertInfo newInfo = null;
    private JPanel general;
    private JPanel pager;
    private JPanel email;
    private Component oldtab = null;
    protected Vector pagingFields;
    protected Vector emailFields;
    protected JTextField customer;
    protected JTextField hostname;
    protected JCheckBox pagingOn;
    protected JCheckBox emailOn;
    protected JCheckBox pagingVerbose;
    protected JTextField p1num;
    protected JTextField p2num;
    protected JTextField p1pw;
    protected JTextField p2pw;
    protected JTextField p1pin;
    protected JTextField p2pin;
    protected JButton p1adv;
    protected JButton p2adv;
    protected JTextField emailAddr;
    protected FilteredTextField smtp1;
    protected FilteredTextField smtp2;
    protected boolean supportLongNames = false;
    protected JButton ok;
    protected JButton cancel;
    protected JButton help;
    protected SSPDeviceManager dm;

    public AlertFrame(SSPDeviceManager sSPDeviceManager) throws RSCException {
        this(null, sSPDeviceManager);
    }

    public AlertFrame(Component component, SSPDeviceManager sSPDeviceManager) throws RSCException {
        super(RSCUtilities.getWindowTitle((SSPDeviceManager)sSPDeviceManager, (String)RSCMessages.getMessage((String)"Alert Settings")));
        Serializable serializable;
        this.dm = sSPDeviceManager;
        if (sSPDeviceManager.getPlatformSupport(sSPDeviceManager).isLongNamesSupported()) {
            this.supportLongNames = true;
        }
        this.setResizable(false);
        this.addKeyListener((KeyListener)this);
        this.origInfo = new AlertInfo(sSPDeviceManager, this);
        this.newInfo = (AlertInfo)this.origInfo.clone();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.general = new JPanel();
        this.general.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 10));
        TextPanel textPanel = new TextPanel();
        int n = RSCProperties.getInt((String)"rsc.alert.textwidth");
        textPanel.setMaxWidth(n);
        textPanel.addText(RSCMessages.getMessage((String)"The information on this page will be included in any alerts that are generated for this server, to differentiate them from RSC alerts from other servers."));
        textPanel.addBreak();
        textPanel.addText(RSCMessages.getMessage((String)"Use the customer information field to identify the server's service contract number, location, server admin, server owner, or other information."));
        textPanel.addBreak();
        textPanel.addText(RSCMessages.getMessage((String)"The server name and customer information fields may contain up to forty characters, including alphanumeric characters and hyphen."));
        this.general.add((Component)textPanel);
        Dimension dimension = RSCProperties.getSize((String)"rsc.alert.general.labelsize");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        JLabel jLabel = new JLabel(RSCMessages.getMessage((String)"Server Name:"), 4);
        dimension.height = jLabel.getPreferredSize().height;
        jLabel.setPreferredSize(dimension);
        jPanel2.add(jLabel);
        this.hostname = this.supportLongNames ? new FilteredTextField(this.newInfo.getHostname(), 15, 40, -1, "-", "") : new FilteredTextField(this.newInfo.getHostname(), 15, 8, 7, "-", "");
        jPanel2.add(this.hostname);
        jLabel.setLabelFor(this.hostname);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel, (String)"rsc.mnemonic.alertsettings.servername");
        this.general.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        JLabel jLabel2 = new JLabel(RSCMessages.getMessage((String)"Customer Information:"), 4);
        dimension.height = jLabel2.getPreferredSize().height;
        jLabel2.setPreferredSize(dimension);
        jPanel2.add(jLabel2);
        this.customer = this.supportLongNames ? new FilteredTextField(this.newInfo.getCustomerInfo(), 15, 40, -1, "-", "") : new FilteredTextField(this.newInfo.getCustomerInfo(), 15, 8, 7, "-", "");
        jPanel2.add(this.customer);
        jLabel2.setLabelFor(this.customer);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.customerinformation");
        this.general.add(jPanel2);
        this.general.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        jTabbedPane.addTab(RSCMessages.getMessage((String)"General"), this.general);
        this.pager = new JPanel();
        this.pager.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 15));
        this.pagingFields = new Vector(9);
        this.pagingOn = new JCheckBox(RSCMessages.getMessage((String)"Send RSC alerts to pagers"), this.newInfo.getPagingStatus());
        this.pagingOn.addItemListener((ItemListener)this);
        RSCUtilities.setMnemonicForComponent((JComponent)this.pagingOn, (String)"rsc.mnemonic.alertsettings.sendrscalertstopagers");
        this.pager.add(this.pagingOn);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 15, 0));
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(RSCMessages.getMessage((String)"Pager 1")));
        jPanel5.setBorder(BorderFactory.createTitledBorder(RSCMessages.getMessage((String)"Pager 2")));
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel6.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.RIGHT, 0, 10));
        jPanel7.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.RIGHT, 0, 10));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 35));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 35));
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"Number:"), 4);
        jPanel2.add(jLabel2);
        this.p1num = new FilteredTextField(this.newInfo.getPrimaryPagerNumber(), 12, 39, 4, "*#,-", "");
        this.p1num.setEnabled(this.newInfo.getPagingStatus());
        this.pagingFields.addElement(this.p1num);
        jPanel2.add(this.p1num);
        jPanel6.add(jPanel2);
        jLabel2.setLabelFor(this.p1num);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.number");
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"Number:"), 4);
        jPanel2.add(jLabel2);
        this.p2num = new FilteredTextField(this.newInfo.getSecondaryPagerNumber(), 12, 39, 4, "*#,-", "");
        this.p2num.setEnabled(this.newInfo.getPagingStatus());
        this.pagingFields.addElement(this.p2num);
        jPanel2.add(this.p2num);
        jLabel2.setLabelFor(this.p2num);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.number2");
        jPanel7.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"PIN:"), 4);
        jPanel2.add(jLabel2);
        this.p1pin = new FilteredTextField(this.newInfo.getPrimaryPagerPIN(), 12, 39, 4, "", "");
        jLabel2.setLabelFor(this.p1pin);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.pin");
        this.p1pin.setEnabled(this.newInfo.getPagingStatus());
        this.pagingFields.addElement(this.p1pin);
        jPanel2.add(this.p1pin);
        jPanel6.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"PIN:"), 4);
        jPanel2.add(jLabel2);
        this.p2pin = new FilteredTextField(this.newInfo.getSecondaryPagerPIN(), 12, 39, 4, "", "");
        this.p2pin.setEnabled(this.newInfo.getPagingStatus());
        jLabel2.setLabelFor(this.p2pin);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.pin2");
        this.pagingFields.addElement(this.p2pin);
        jPanel2.add(this.p2pin);
        jPanel7.add(jPanel2);
        jPanel6.add(new JLabel());
        jPanel7.add(new JLabel());
        this.p1adv = new JButton(RSCMessages.getMessage((String)"Advanced..."));
        RSCUtilities.setMnemonicForComponent((JComponent)this.p1adv, (String)"rsc.mnemonic.alertsettings.advanced");
        this.p2adv = new JButton(RSCMessages.getMessage((String)"Advanced..."));
        RSCUtilities.setMnemonicForComponent((JComponent)this.p2adv, (String)"rsc.mnemonic.alertsettings.advanced2");
        this.p1adv.addActionListener((ActionListener)this);
        this.p2adv.addActionListener((ActionListener)this);
        this.p1adv.setEnabled(this.newInfo.getPagingStatus());
        this.p2adv.setEnabled(this.newInfo.getPagingStatus());
        this.pagingFields.addElement(this.p1adv);
        this.pagingFields.addElement(this.p2adv);
        jPanel6.add(this.p1adv);
        jPanel7.add(this.p2adv);
        jPanel4.add("Center", jPanel6);
        jPanel5.add("Center", jPanel7);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        this.pager.add(jPanel3);
        this.pager.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        this.pagingVerbose = new JCheckBox(RSCMessages.getMessage((String)"Use 78 character message length"), !this.newInfo.getPagerVerboseActive());
        this.pagingVerbose.setEnabled(this.newInfo.getPagingStatus());
        this.pagingFields.addElement(this.pagingVerbose);
        textPanel = new TextPanel();
        int n2 = RSCProperties.getInt((String)"rsc.alert.textwidth");
        textPanel.setMaxWidth(n2);
        textPanel.addText(RSCMessages.getMessage((String)"Use the 78 character message length if your pager or paging service does not support long messages."));
        if (sSPDeviceManager.getPlatformSupport(sSPDeviceManager).isSerialPagerVerboseSupported()) {
            RSCUtilities.setMnemonicForComponent((JComponent)this.pagingVerbose, (String)"rsc.mnemonic.alertsettings.use78charactermessagelength");
            serializable = new JPanel();
            serializable.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 5));
            serializable.add(this.pagingVerbose);
            serializable.add((Component)textPanel);
            this.pager.add((Component)serializable);
        }
        if (sSPDeviceManager.getPlatformSupport(sSPDeviceManager).isPCCardModemSupported()) {
            jTabbedPane.addTab(RSCMessages.getMessage((String)"Pager"), this.pager);
        }
        this.email = new JPanel();
        this.email.setLayout((LayoutManager)new ColumnLayout());
        this.emailFields = new Vector(3);
        this.emailOn = new JCheckBox(RSCMessages.getMessage((String)"Send RSC alerts by E-mail"), this.newInfo.getEmailStatus());
        this.emailOn.addItemListener((ItemListener)this);
        RSCUtilities.setMnemonicForComponent((JComponent)this.emailOn, (String)"rsc.mnemonic.alertsettings.sendrscalertsbye-mail");
        this.email.add(this.emailOn);
        jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 10));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 15, 15, 15));
        textPanel = new TextPanel();
        textPanel.setMaxWidth(n);
        textPanel.addText(RSCMessages.getMessage((String)"You must specify an e-mail address and SMTP mail server."));
        textPanel.addBreak();
        textPanel.addText(RSCMessages.getMessage((String)"The backup SMTP mail server is optional, and will be used only if the first server does not respond."));
        jPanel3.add((Component)textPanel);
        dimension = RSCProperties.getSize((String)"rsc.alert.email.labelsize");
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"E-mail address:"), 4);
        dimension.height = jLabel2.getPreferredSize().height;
        jLabel2.setPreferredSize(dimension);
        jPanel2.add(jLabel2);
        this.emailAddr = new FilteredTextField(this.newInfo.getEmailAddress(), 15, 40);
        this.emailAddr.setEnabled(this.newInfo.getEmailStatus());
        this.emailFields.addElement(this.emailAddr);
        jPanel2.add(this.emailAddr);
        jLabel2.setLabelFor(this.emailAddr);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.e-mailaddress");
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"SMTP mail server:"), 4);
        dimension.height = jLabel2.getPreferredSize().height;
        jLabel2.setPreferredSize(dimension);
        jPanel2.add(jLabel2);
        this.smtp1 = new FilteredTextField(this.newInfo.getPrimarySMTPHost(), 15, 15, 4);
        this.smtp1.addAllowableCharacters(".");
        this.smtp1.setEnabled(this.newInfo.getEmailStatus());
        this.emailFields.addElement(this.smtp1);
        jPanel2.add((Component)this.smtp1);
        jLabel2.setLabelFor((Component)this.smtp1);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.smtpmailserver");
        jPanel3.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new RowLayout());
        jLabel2 = new JLabel(RSCMessages.getMessage((String)"Backup SMTP mail server:"), 4);
        dimension.height = jLabel2.getPreferredSize().height;
        jLabel2.setPreferredSize(dimension);
        jPanel2.add(jLabel2);
        this.smtp2 = new FilteredTextField(this.newInfo.getSecondarySMTPHost(), 15, 15, 4);
        this.smtp2.addAllowableCharacters(".");
        this.smtp2.setEnabled(this.newInfo.getEmailStatus());
        this.emailFields.addElement(this.smtp2);
        jPanel2.add((Component)this.smtp2);
        jLabel2.setLabelFor((Component)this.smtp2);
        RSCUtilities.setMnemonicForComponent((JComponent)jLabel2, (String)"rsc.mnemonic.alertsettings.backupsmtpmailserver");
        jPanel3.add(jPanel2);
        this.email.add(jPanel3);
        this.email.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        jTabbedPane.addTab(RSCMessages.getMessage((String)"E-mail"), this.email);
        serializable = sSPDeviceManager.getPlatformSupport(sSPDeviceManager).isSerialPagerVerboseSupported() ? RSCProperties.getSize((String)"rsc.alert.tabsize2") : RSCProperties.getSize((String)"rsc.alert.tabsize");
        jTabbedPane.setPreferredSize((Dimension)serializable);
        jPanel.add("Center", jTabbedPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15));
        container.add("Center", jPanel);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 3, 10, 0));
        this.ok = new JButton(RSCMessages.getMessage((String)"OK"));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(RSCMessages.getMessage((String)"Cancel"));
        this.help = new JButton(RSCMessages.getMessage((String)"Help"));
        RSCUtilities.setMnemonicForComponent((JComponent)this.help, (String)"rsc.mnemonic.alertsettings.help");
        this.ok.addActionListener((ActionListener)this);
        this.cancel.addActionListener((ActionListener)this);
        this.help.addActionListener((ActionListener)this);
        jPanel8.add(this.ok);
        jPanel8.add(this.cancel);
        jPanel8.add(this.help);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 0, 15, 15));
        jPanel3.add("East", jPanel8);
        container.add("South", jPanel3);
        this.pack();
        RSCUtilities.positionWindow((Window)this, (Component)component);
        jTabbedPane.getSelectedComponent().requestFocus();
        this.setVisible(true);
        this.oldtab = this.general;
        jTabbedPane.addChangeListener((ChangeListener)this);
        this.setDefaultCloseOperation(2);
    }

    protected boolean checkChanges() {
        return this.checkGeneralSettings() && this.checkPagerSettings() && this.checkEmailSettings();
    }

    protected boolean checkGeneralSettings() {
        boolean bl = true;
        boolean bl2 = true;
        String string = this.hostname.getText();
        String string2 = this.customer.getText();
        if (this.supportLongNames) {
            if (string.length() > 40) {
                bl = false;
            }
            if (string2.length() > 40) {
                bl2 = false;
            }
        } else {
            int n;
            if (string.length() > 8) {
                bl = false;
            }
            if (string2.length() > 8) {
                bl2 = false;
            }
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if (!Character.isLetterOrDigit((char)n) && n != 45) {
                    bl = false;
                }
                ++n2;
            }
            n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (!Character.isLetterOrDigit(c) && c != '-') {
                    bl2 = false;
                }
                ++n;
            }
        }
        if (!bl2 || !bl) {
            TextPanel textPanel = new TextPanel();
            textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
            if (this.supportLongNames) {
                if (!bl2 && !bl) {
                    textPanel.addText(RSCMessages.getMessage((String)"The hostname and customer information specified on this screen must be strings of 40 characters or less."));
                    textPanel.addBreak();
                    textPanel.addText(RSCMessages.getMessage((String)"If your server hostname is longer than 40 characters, you should use a shorter value that will specify the server uniquely."));
                } else if (!bl) {
                    textPanel.addText(RSCMessages.getMessage((String)"The hostname specified on this screen must be a string of 40 characters or less."));
                    textPanel.addBreak();
                    textPanel.addText(RSCMessages.getMessage((String)"If your server hostname is longer than 40 characters, you should use a shorter value that will specify the server uniquely."));
                } else if (!bl2) {
                    textPanel.addText(RSCMessages.getMessage((String)"The customer information specified on this screen must be a string of 40 characters or less."));
                }
            } else if (!bl2 && !bl) {
                textPanel.addText(RSCMessages.getMessage((String)"The hostname and customer information specified on this screen must be alphanumeric strings of 8 characters or less."));
                textPanel.addBreak();
                textPanel.addText(RSCMessages.getMessage((String)"If your server hostname contains other characters or is longer than 8 characters, you should use a different value that meets the above criteria and will specify the server uniquely."));
            } else if (!bl) {
                textPanel.addText(RSCMessages.getMessage((String)"The hostname specified on this screen must be an alphanumeric string of 8 characters or less."));
                textPanel.addBreak();
                textPanel.addText(RSCMessages.getMessage((String)"If your server hostname contains other characters or is longer than 8 characters, you should use a different value that meets the above criteria and will specify the server uniquely."));
            } else if (!bl2) {
                textPanel.addText(RSCMessages.getMessage((String)"The customer information specified on this screen must be an alphanumeric string of 8 characters or less."));
            }
            RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Invalid Entry"), (int)0);
            return false;
        }
        this.newInfo.setHostname(this.hostname.getText());
        this.newInfo.setCustomerInfo(this.customer.getText());
        return true;
    }

    protected boolean checkPagerSettings() {
        if (this.pagingOn.isSelected()) {
            int n;
            if (this.p1num.getText().trim().length() == 0 && this.p2num.getText().trim().length() == 0) {
                RSCUtilities.showMessageDialog((Component)this, (Object)RSCMessages.getMessage((String)"You must enter at least one pager number in order to continue."), (String)RSCMessages.getMessage((String)"No Pager Number Entered"), (int)0);
                return false;
            }
            String string = this.p1num.getText();
            String string2 = this.p2num.getText();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = true;
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if (Character.isDigit((char)n) || n == 64 || n == 42 || n == 35 || n == 44) {
                    stringBuffer.append((char)n);
                } else if (n != 45) {
                    bl = false;
                }
                ++n2;
            }
            n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (Character.isDigit(c) || c == '@' || c == '*' || c == '#' || c == ',') {
                    stringBuffer2.append(c);
                } else if (c != '-') {
                    bl2 = false;
                }
                ++n;
            }
            if (!bl || !bl2) {
                TextPanel textPanel = new TextPanel();
                textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
                if (!bl && !bl2) {
                    textPanel.addText(RSCMessages.getMessage((String)"The pager numbers entered are invalid.  Pager numbers may only contain numeric characters and the characters '*', '#', '.' and '@'."));
                } else if (!bl) {
                    textPanel.addText(RSCMessages.getMessage((String)"The first pager number entered is invalid.  Pager numbers may only contain numeric characters and the characters '*', '#', '.' and '@'."));
                } else if (!bl2) {
                    textPanel.addText(RSCMessages.getMessage((String)"The second pager number entered is invalid.  Pager numbers may only contain numeric characters and the characters '*', '#', '.' and '@'."));
                }
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Invalid Entry"), (int)0);
                return false;
            }
            TextPanel textPanel = new TextPanel();
            textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
            if (stringBuffer.toString().length() + this.p1pin.getText().length() > 39) {
                textPanel.addText(RSCMessages.getMessage((String)"The combined number and PIN for a pager cannot exceed 39 characters."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Entry To Long"), (int)0);
                return false;
            }
            if (stringBuffer2.toString().length() + this.p2pin.getText().length() > 39) {
                textPanel.addText(RSCMessages.getMessage((String)"The combined number and PIN for a pager cannot exceed 39 characters."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Entry To Long"), (int)0);
                return false;
            }
            this.p1num.setText(stringBuffer.toString());
            this.p2num.setText(stringBuffer2.toString());
            this.newInfo.setPrimaryPagerNumber(this.p1num.getText());
            this.newInfo.setSecondaryPagerNumber(this.p2num.getText());
            this.newInfo.setPrimaryPagerPIN(this.p1pin.getText());
            this.newInfo.setSecondaryPagerPIN(this.p2pin.getText());
        }
        this.newInfo.setPagerVerboseActive(!this.pagingVerbose.isSelected());
        this.newInfo.setPagingStatus(this.pagingOn.isSelected());
        return true;
    }

    protected boolean checkEmailSettings() {
        if (this.emailOn.isSelected()) {
            TextPanel textPanel;
            if (this.smtp1.getText().trim().length() == 0 || this.emailAddr.getText().trim().length() == 0) {
                RSCUtilities.showMessageDialog((Component)this, (Object)RSCMessages.getMessage((String)"You must enter at least an e-mail address and the first SMTP host in order to continue."), (String)RSCMessages.getMessage((String)"Information Incomplete"), (int)0);
                return false;
            }
            if (this.emailAddr.getText().length() > 40) {
                TextPanel textPanel2 = new TextPanel();
                textPanel2.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
                textPanel2.addText(RSCMessages.getMessage((String)"The e-mail address field cannot excede 40 characters."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel2, (String)RSCMessages.getMessage((String)"E-Mail Address Too Long"), (int)0);
                return false;
            }
            String string = this.smtp1.getText().trim();
            String string2 = this.smtp2.getText().trim();
            String string3 = null;
            String string4 = null;
            boolean bl = true;
            boolean bl2 = true;
            if (string.length() != 0 && !RSCUtilities.checkIPAddr((String)string)) {
                if (Character.isDigit(string.charAt(0))) {
                    bl = false;
                } else {
                    try {
                        string3 = InetAddress.getByName(string).getHostAddress();
                        this.smtp1.setText(string3);
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl = false;
                    }
                }
            }
            if (string2.length() != 0 && !RSCUtilities.checkIPAddr((String)string2)) {
                if (Character.isDigit(string2.charAt(0))) {
                    bl2 = false;
                } else {
                    try {
                        string4 = InetAddress.getByName(string2).getHostAddress();
                        this.smtp2.setText(string4);
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl2 = false;
                    }
                }
            }
            if (!bl && !bl2) {
                textPanel = new TextPanel();
                textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
                textPanel.addText(RSCMessages.getMessage((String)"The values entered for SMTP hosts are invalid.  You either entered an invalid IP address or a hostname that could not be resolved.  If the hostname cannot be resolved, you must enter the IP address."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Unknown Hosts"), (int)0);
                return false;
            }
            if (!bl) {
                textPanel = new TextPanel();
                textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
                textPanel.addText(RSCMessages.getMessage((String)"The value entered for the first SMTP host is invalid.  You either entered an invalid IP address or a hostname that could not be resolved.  If the hostname cannot be resolved, you must enter the IP address."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Unknown Host"), (int)0);
                return false;
            }
            if (!bl2) {
                textPanel = new TextPanel();
                textPanel.setMaxWidth(RSCProperties.getInt((String)"rsc.dialog.defaulttextwidth"));
                textPanel.addText(RSCMessages.getMessage((String)"The value entered for the backup SMTP host is invalid.  You either entered an invalid IP address or a hostname that could not be resolved.  If the hostname cannot be resolved, you must enter the IP address."));
                RSCUtilities.showMessageDialog((Component)this, (Object)textPanel, (String)RSCMessages.getMessage((String)"Unknown Host"), (int)0);
                return false;
            }
            this.newInfo.setEmailAddress(this.emailAddr.getText());
            this.newInfo.setPrimarySMTPHost(this.smtp1.getText());
            this.newInfo.setSecondarySMTPHost(this.smtp2.getText());
        }
        this.newInfo.setEmailStatus(this.emailOn.isSelected());
        return true;
    }

    protected boolean applyChanges() {
        block5: {
            if (!this.origInfo.equals((Object)this.newInfo)) {
                try {
                    this.newInfo.applyChanges(this, this.origInfo);
                }
                catch (RSCException rSCException) {
                    int n = rSCException.getSeverity();
                    if (n == 1 || n == 2) {
                        return false;
                    }
                    if (n <= 2) break block5;
                    this.dispose();
                    RSCExceptionHandler rSCExceptionHandler = RSCUtilities.findRSCExceptionHandler((int)n);
                    if (rSCExceptionHandler != null) {
                        rSCExceptionHandler.handleRSCException(rSCException);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void showAdvancedDialog(int n) {
        String string = RSCMessages.getFormattedMessage((String)"Pager {0} Advanced Settings", (Object)new Integer(n));
        new PagingDialog((JFrame)this, string, this.newInfo, n);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancel.doClick();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.p1adv) {
            this.showAdvancedDialog(1);
        } else if (object == this.p2adv) {
            this.showAdvancedDialog(2);
        } else if (object == this.cancel) {
            this.dispose();
        } else if (object == this.help) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            RSCUtilities.showHelp((String)RSCProperties.getProperty((String)"rsc.doc.alerthelp"));
            this.setCursor(Cursor.getDefaultCursor());
        } else if (object == this.ok) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.checkChanges() && this.applyChanges()) {
                this.setCursor(Cursor.getDefaultCursor());
                this.dispose();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Vector vector = null;
        Object object = itemEvent.getSource();
        if (object == this.pagingOn) {
            vector = this.pagingFields;
        } else if (object == this.emailOn) {
            vector = this.emailFields;
        }
        if (vector != null) {
            boolean bl = itemEvent.getStateChange() == 1;
            int n = 0;
            while (n < vector.size()) {
                ((Component)vector.elementAt(n)).setEnabled(bl);
                ++n;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane;
        if (changeEvent.getSource() instanceof JTabbedPane && this.oldtab != (jTabbedPane = (JTabbedPane)changeEvent.getSource()).getSelectedComponent()) {
            boolean bl = true;
            if (this.oldtab == this.general) {
                bl = this.checkGeneralSettings();
            } else if (this.oldtab == this.pager) {
                bl = this.checkPagerSettings();
            } else if (this.oldtab == this.email) {
                bl = this.checkEmailSettings();
            }
            if (!bl) {
                jTabbedPane.setSelectedComponent(this.oldtab);
            }
            this.oldtab = jTabbedPane.getSelectedComponent();
        }
    }
}

