#!/bin/sh 
#set -x
# Copyright 08/22/03 Sun Microsystems, Inc. All Rights Reserved.
#
# pragma ident  "@(#)es-setup.sh	1.18  03/08/22 Sun Microsystems"
#


#
#Check to see if the host is serengeti domain. If the host
#is serengeti domain then returns 0 else returns nonzero.
#
check_serengeti_domain_platform()
{
   PLAT_NAME=`/usr/bin/uname -i`
   CLASS_NAME=`/usr/bin/uname -m`
   SER_MODELS="3800 4800 4810 6800"
   SERENGETI_PLATFORM="Sun Fire"

   if [ -f /usr/platform/"$PLAT_NAME"/sbin/prtdiag ] ; then
      SERENGETI_PRTOUT=`/usr/platform/"$PLAT_NAME"/sbin/prtdiag | /usr/bin/head -1 | /usr/bin/cut -f2 -d:`
   else
      if [ -f /usr/platform/"$CLASS_NAME"/sbin/prtdiag ] ; then
         SERENGETI_PRTOUT=`/usr/platform/"$CLASS_NAME"/sbin/prtdiag | /usr/bin/head -1 | /usr/bin/cut -f2 -d:`
      fi
   fi

   echo "$SERENGETI_PRTOUT" | /usr/bin/grep "$SERENGETI_PLATFORM" >/dev/null 2>&1
   if [ $? -eq 0 ] ; then

      for each_model in $SER_MODELS
      do
         echo "$SERENGETI_PRTOUT" | /usr/bin/grep "$each_model" >/dev/null 2>&1
         if [ $? -eq 0 ] ; then
            return 0
         fi
      done

   fi

   return 1
}

#
#Adds a module into the module file. Arguments are
#1. Module Name 2. Module File 3. Module File Entry 4.Position
#Position=0 for start of the file, 1 for end of the file.
#

add_module () 
{

    module_name=${1}
    module_args=${3}
    module_file=${2}
    module_position=${4}
    module_file_name=`/usr/bin/basename $module_file`
    tmp_file=${TMP_DIR}/$module_file_name.${PID}
    tmp_uncomment_file=${TMP_DIR}/$module_file_name.${PID}.uncomment

    if [ ! -r ${module_file} ] ; then
        echolog '$2 does not exist' "${module_file}"
        return 1;
    fi

    if [ -r ${tmp_file} ] ; then
        /usr/bin/rm -f ${tmp_file}
    fi
    if [ -r ${tmp_uncomment_file} ] ; then
        /usr/bin/rm -f ${tmp_uncomment_file}
    fi

    /usr/bin/egrep  "^[       ]*#.*" ${module_file} > ${tmp_file}
    /usr/bin/egrep -v  "^[       ]*#.*" ${module_file} > ${tmp_uncomment_file}


    if [ $module_position -eq 0 ] ; then
	echo "${module_args}" >> ${tmp_file} 
	/usr/bin/egrep -v "^[       ]*${module_name}[       ]*=" ${tmp_uncomment_file} >> ${tmp_file}
    else
	/usr/bin/egrep -v "^[       ]*${module_name}[       ]*=" ${tmp_uncomment_file} >> ${tmp_file}
	echo "${module_args}" >> ${tmp_file} 
    fi
    if [ -r ${tmp_file} ] ; then
	/usr/bin/mv ${module_file} ${module_file}.old 
	/usr/bin/mv ${tmp_file} ${module_file} 
	echologverbose 'Added module $2 to $3.' "${module_name}" "${module_file}"
	/usr/bin/rm -f ${tmp_file}
	/usr/bin/rm -f ${tmp_uncomment_file}
	return 0
    else
	echolog 'Could not add the module $2' "$module_name"
	return 1
    fi

}


setup_event_module () {


  if [ ${OSVERS} = 2.9 ] ; then

      #
      # Remove the em_slm.so file and send HUP signal to related process.
      #
      if [ -f "/usr/lib/sysevent/modules/em_slm.so" ] ; then
	/usr/bin/rm -f /usr/lib/sysevent/modules/em_slm.so > /dev/null 2>&1
	kill_all_processes "/usr/lib/sysevent/syseventd" "HUP"
      fi

  else

    #
    #Copy the library
    #

    if [ -f "$BASEDIR/base/lib/sparc-sun-solaris${OSVERS}/em_slm.so" ] ; then
	if [ -f "/usr/lib/sysevent/modules/em_slm.so" ] ; then
		/usr/bin/rm -f /usr/lib/sysevent/modules/em_slm.so
		kill_all_processes "/usr/lib/sysevent/syseventd" "HUP"
	fi
	/usr/bin/cp "$BASEDIR/base/lib/sparc-sun-solaris${OSVERS}/em_slm.so" /usr/lib/sysevent/modules/em_slm.so 
	if [ $? -ne 0 ] ; then
	    echolog 'Could not copy library $2' "em_slm.so"
	    return 1
        fi
    else
	return 1
    fi

  fi

    #
    #Add events module
    #

    add_module "em" "$VARDIR"/base-modules-d.dat  "em = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.em sun em {module = \\\"em\\\"; enterprise = \\\"sun\\\"; moduleType = \\\"serverSupport\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.em\\\"; moduleName = \\\"Event Module\\\"; console = \\\"em\\\"; version = \\\"1.0\\\";  instance = \\\"\\\"; }\"" 0
    if [ $? -ne 0 ] ; then
        return 1
    fi


    #
    #Send SIGHUP to process with string /usr/lib/sysevent/syseventd
    #
    lcnt=0
    lcnt=`/usr/ucb/ps -ww -gax | /usr/bin/grep -i "/usr/lib/sysevent/syseventd" |  /usr/bin/grep -v "grep" | /usr/bin/wc -l`
    if [ $lcnt -gt 0 ] 
    then 
	kill_all_processes "/usr/lib/sysevent/syseventd" "HUP"
    fi
    return 0
}

setup_config_reader () {

    #
    #Add ConfigReader module
    #
    add_module "Config-Reader-Serengeti" "$VARDIR"/base-modules-d.dat  "Config-Reader-Serengeti = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.hardware.Config.ReaderSerengeti sun Config-Reader-Serengeti {module = \\\"Config-Reader-Serengeti\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.Config-Reader-Serengeti:moduleType\\\"; moduleType = \\\"hardware\\\"; i18nModuleName = \\\"base.modules.Config-Reader-Serengeti:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.hardware.Config.ReaderSerengeti\\\"; moduleName = \\\"Config Reader Serengeti\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.Config-Reader-Serengeti:moduleDesc\\\"; console = \\\"Config-Reader-Serengeti\\\"; instance = \\\"\\\"; }\"" 1
    if [ $? -ne 0 ] ; then
        return 1
    fi
    return 0
}

setup_rules_module () {

    #
    #Add Rules module
    #
    add_module "serengeti-rules" "$VARDIR"/base-modules-d.dat  "serengeti-rules = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.serengeti-rules sun serengeti-rules {module = \\\"serengeti-rules\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.serengeti-rules:moduleType\\\"; moduleType = \\\"hardware\\\"; oid = \\\"1.3.6.1.4.1.42.2.12.2.2.101\\\"; i18nModuleName = \\\"base.modules.serengeti-rules:moduleName\\\"; desc = \\\"Serengeti Rule Module\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.serengeti-rules\\\"; moduleName = \\\"Serengeti Rule Module\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.serengeti-rules:moduleDesc\\\"; console = \\\"serengeti-rules\\\"; instance = \\\"\\\"; }\"" 1

    if [ $? -ne 0 ] ; then
        return 1
    fi
    return 0
}

do_domain_setup()
{
   
    #Check to see if the domain package is installed. If not then return 1.
    #TASK: The package name has to be changed

    /usr/bin/pkginfo -qi SUNWessda  > /dev/null 2>&1
    if [ $? -ne 0 ] ; then
        echolog "Sun Fire 6800-3800 Domain Agent Package is not installed, Can not setup domain."
        return 1
    fi

    #
    #Make the correct base-modules-d.dat available in /var/opt/SUNWsymon/cfg directory
    #

    if [ ! -f "$VARDIR/base-modules-d.dat" ] ; then
        /usr/bin/sed s/"^Config-Reader4u"/"# Config-Reader4u"/ \
            "$BASEDIR"/base/cfg/base-modules-d.dat > "$VARDIR"/base-modules-d.dat
    else
        /usr/bin/sed s/"^Config-Reader4u"/"# Config-Reader4u"/ \
            "$VARDIR"/base-modules-d.dat > $TMP_DIR/base-modules-d.dat.$PID
        /usr/bin/mv "$VARDIR"/base-modules-d.dat "$VARDIR"/base-modules-d.dat.old
        /usr/bin/mv $TMP_DIR/base-modules-d.dat.$PID  "$VARDIR"/base-modules-d.dat
    fi
    
    SETUP_FAILED=0
    #
    #Setup the event module
    #

    setup_event_module
    if [ $? -ne 0 ] ; then
        SETUP_FAILED=1
    fi

    #
    #Setup config reader module
    #

    setup_config_reader
    if [ $? -ne 0 ] ; then
        SETUP_FAILED=1
    fi

    #
    #Setup rules module
    #

    setup_rules_module
    if [ $? -ne 0 ] ; then
        SETUP_FAILED=1
    fi

    if [ $SETUP_FAILED -eq 1 ] ; then
	return 1
    fi

    return 0
}


remove_serengeti_device ()
{
  if [ -f "$VARDIR"/serengeti-modeling-d.dat ] ; then

    # Remove serengeti-modeling-d.dat
    /usr/bin/rm -f "$VARDIR"/serengeti-modeling-d.dat

    # Remove device modeling
    /usr/bin/cat "$BASEDIR"/classes/base/console/cfg/sun-fire-6800-device.cfg | /usr/bin/sed -e "s|##BASEDIR##|$BASEDIR|g" > "$TMP_DIR"/sun-fire-6800-device.cfg
    /usr/bin/cat "$BASEDIR"/classes/base/console/cfg/sun-fire-4800-device.cfg | /usr/bin/sed -e "s|##BASEDIR##|$BASEDIR|g" > "$TMP_DIR"/sun-fire-4800-device.cfg
    /usr/bin/cat "$BASEDIR"/classes/base/console/cfg/sun-fire-3800-device.cfg | /usr/bin/sed -e "s|##BASEDIR##|$BASEDIR|g" > "$TMP_DIR"/sun-fire-3800-device.cfg
    /usr/bin/cat "$BASEDIR"/classes/base/console/cfg/sun-fire-4810-device.cfg | /usr/bin/sed -e "s|##BASEDIR##|$BASEDIR|g" > "$TMP_DIR"/sun-fire-4810-device.cfg

    "$BASEDIR"/sbin/es-device -d "$TMP_DIR"/sun-fire-6800-device.cfg > /dev/null 2>&1
    "$BASEDIR"/sbin/es-device -d "$TMP_DIR"/sun-fire-4800-device.cfg > /dev/null 2>&1
    "$BASEDIR"/sbin/es-device -d "$TMP_DIR"/sun-fire-3800-device.cfg > /dev/null 2>&1
    "$BASEDIR"/sbin/es-device -d "$TMP_DIR"/sun-fire-4810-device.cfg > /dev/null 2>&1

    /usr/bin/rm -f "$TMP_DIR"/sun-fire-6800-device.cfg
    /usr/bin/rm -f "$TMP_DIR"/sun-fire-4800-device.cfg
    /usr/bin/rm -f "$TMP_DIR"/sun-fire-3800-device.cfg
    /usr/bin/rm -f "$TMP_DIR"/sun-fire-4810-device.cfg

    # Remove details
    $BASEDIR/sbin/es-details -u -n sun-Sun-Fire-3800-platform > /dev/null 2>&1
    $BASEDIR/sbin/es-details -u -n sun-Sun-Fire-4800-platform > /dev/null 2>&1
    $BASEDIR/sbin/es-details -u -n sun-Sun-Fire-4810-platform > /dev/null 2>&1
    $BASEDIR/sbin/es-details -u -n sun-Sun-Fire-6800-platform > /dev/null 2>&1

  fi
}


remove_module () 
{

    module_name=${1}
    #module_args=${3}
    module_file=${2}
    module_file_name=`/usr/bin/basename $module_file`
    tmp_file=${TMP_DIR}/$module_file_name.${PID}

    if [ ! -r ${module_file} ] ; then
        echolog '$2 does not exist' "$module_file"
        return 1;
    fi

    if [ -r ${tmp_file} ] ; then
        /usr/bin/rm -f ${tmp_file}
    fi

    /usr/bin/egrep -v "^[       ]*${module_name}[       ]*=" ${module_file} > ${tmp_file}

    #echo "${module_args}" >> ${tmp_file} 

    if [ -r ${tmp_file} ] ; then
        /usr/bin/mv ${module_file} ${module_file}.old 
        /usr/bin/mv ${tmp_file} ${module_file} 
        echolog 'Removed module $2 from $3.' "$module_name" "$module_file"
        return 0
    else
        echolog '$2 is not readable, Could not remove the module $3' "$tmp_file" "$module_name"
        return 1
    fi
}


undo_previous_setup ()
{
  $BASEDIR/sbin/es-stop -a >/dev/null 2>&1

  remove_serengeti_device

  # Remove em_slm module
  if [ -f "/usr/lib/sysevent/modules/em_slm.so" ] ; then
    /usr/bin/rm -f /usr/lib/sysevent/modules/em_slm.so
    kill_all_processes "/usr/lib/sysevent/syseventd" "HUP"
  fi

  remove_module em $VARDIR/base-modules-d.dat
  remove_module Config-Reader-Serengeti $VARDIR/base-modules-d.dat
  remove_module serengeti-rules $VARDIR/base-modules-d.dat
}


print_usage ()
{
  echo ""
  eval echo `/usr/bin/gettext 'Usage: $PROGNAME [ -u ]'`
  /usr/bin/gettext '       Where the options represent:\n'
  /usr/bin/gettext ' Default : Setup addon\n'
  /usr/bin/gettext '  u : Use this option to undo the previous setup.\n'
}

#
#Starting Main Of The Script
#

PID=$$
TMP_DIR=/tmp
PROGNAME=$0; export PROGNAME
BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
if [ -z "${BASEDIR}" ]; then
    echo "No Components are installed..."
    exit 1
fi

. ${BASEDIR}/SUNWsymon/sbin/es-common.sh
set_basedir

check_root
check_logfile setup
check_osver
set_xput

# changed text domain name to fix bug 4796473
# setup_textdomain ESSERENGETI_SCRIPTS
setup_textdomain ESSERENGETIDOM_SCRIPTS

undo_flag=0

while getopts u OPT
do
  case $OPT in
    u)
       undo_flag=1
       ;;
    *)  print_usage
       ;;
  esac
done

# 
#Find out if the host is serengeti domain, If yes then
#Do domain setup else do nothing.
#

check_serengeti_domain_platform
if [ $? -ne 0 ] ; then
    #not a serengeti domain. But it is in a server layer
    
    # bug 4819277
    # Not in a domain but in a server, only need to do device setup.
    # in case user only need to undo the setup on server side, we need
    # remove the serengeti device modeling. This is to clean up the system
    if [ $undo_flag -eq 1 ] ; then
      remove_serengeti_device
      exit 0
    fi

    serengeti_device_model_setup=`/usr/bin/dirname $0`/serengeti-device-model.sh
    if [ -x "$serengeti_device_model_setup" ] ; then
        $serengeti_device_model_setup
    fi
 
    exit 0
fi

if [ $undo_flag -eq 1 ] ; then
    undo_previous_setup
    exit 0
fi

do_domain_setup
if [ $? -ne 0 ] ; then
    exit 1
fi

# call serengeti-modelling device script.
serengeti_device_model_setup=`/usr/bin/dirname $0`/serengeti-device-model.sh

if [ -x "$serengeti_device_model_setup" ] ; then
    $serengeti_device_model_setup
fi

exit 0
