;;;                 Sun Public License Notice
;;;
;;; The contents of this file are subject to the Sun Public License
;;; Version 1.0 (the "License"). You may not use this file except in
;;; compliance with the License. A copy of the License is available at
;;; http://www.sun.com/
;;;
;;; The Original Code is NetBeans. The Initial Developer of the Original
;;; Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
;;; Microsystems, Inc. All Rights Reserved.

;; add hooks for startup initialization

(defun netbeans-emacs-startup-hook (&optional ARGS)
"Check if the init files need to be migrated. If yes, don't load the init files on startup.
This solves the problem with a file getting loaded into active minibuffer during xemacs startup.
See `maybe-migrate-user-init-file' for more info."
(netbeans-debug "in netbeans-emacs-startup-hook")
(if (and (boundp 'load-user-init-file-p)
	 (boundp 'load-home-init-file)
	 (fboundp 'find-user-init-directory-init-file)
	 (not load-home-init-file)
	 (not (find-user-init-directory-init-file user-init-directory))
	 (stringp user-init-file)
	 (file-readable-p user-init-file))
    (progn
      (netbeans-debug "Setting load-user-init-file-p to nil")
      (setq load-user-init-file-p nil))))

(add-hook 'emacs-startup-hook 'netbeans-emacs-startup-hook nil)



;;branding related variables

(if (not(boundp '*ide-name*))
    (progn
      (defvar *ide-name* "NetBeans"
	"The branding of the IDE.")
      ))

(if (not(boundp '*ide-invocation-cmd*))
    (progn
      (defvar *ide-invocation-cmd* "runide.sh"
	"The command to run the IDE.")
      ))

(if (not(boundp '*ide-invocation-args*))
    (progn
      (defvar *ide-invocation-args* ""
	"The arguments to `*ide-invocation-cmd*'  to run the IDE.")
      ))


;;check XEmacs version
(when (not (and (string-match "XEmacs" emacs-version)
		(if (boundp 'emacs-patch-level)
		    (emacs-version>= 21 1 9)
		  nil)))
  (let ((error-msg (format "The Emacs version you are currently using (%s) is not supported. %s currently supports only integration with XEmacs version 21.1.9 and above." 
			    (if (fboundp 'construct-emacs-version-name)
				(construct-emacs-version-name )
			      (emacs-version)) *ide-name*)))
    (when (fboundp 'display-warning)
      (display-warning 'netbeans error-msg))
    (error error-msg)))



(require 'netbeans-vars)
(require 'netbeans-common)
(require 'netbeans-invocation)
(require 'netbeans-annotations)
(require 'netbeans-ballooneval)
(require 'netbeans-protocol)
(require 'netbeans-handler)
(require 'netbeans-events)
(require 'netbeans-menus)

(provide 'netbeans)
