;;;                 Sun Public License Notice
;;;
;;; The contents of this file are subject to the Sun Public License
;;; Version 1.0 (the "License"). You may not use this file except in
;;; compliance with the License. A copy of the License is available at
;;; http://www.sun.com/
;;;
;;; The Original Code is NetBeans. The Initial Developer of the Original
;;; Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
;;; Microsystems, Inc. All Rights Reserved.

(defgroup netbeans-ide nil
  "Customization for %*ide-name*% compatibility package."
  :prefix "netbeans-"
  :tag (format "%s IDE" *ide-name*)
  :group 'applications)

;;; XXX the type editor does not work right now...why?
(defcustom netbeans-modes-by-mime-type
;;; XXX add more here--properties, IDL, ...
  '(("text/x-java" . java-mode)
    ("text/plain" . text-mode)
    ("text/html" . html-mode))
  "*Mapping of MIME types to Emacs major modes.
Should be used to supply a major mode to use for a file (or
fragment of text) when the filename or contents do not suffice
for Emacs to guess."
  :type '(list (cons string function))
  :group 'netbeans-ide)

(defcustom netbeans-auto-open-files nil
;;; XXX add more contents here as below
;;;  '(".*\\.java" ".*\\.cc" ".*\\.f77")
  "*List of files which are opened inside of the IDE and their directories are mounted automatically when the user opens them in XEmacs.The default value is nil.
Example:
  Setting the value to '(\".*\\\\.java\" \".\*\\\\.cc\" \".\*\\\\.f77\") will tell the IDE to mount and open all of the files ending with java, cc and f77 extensions when they are opened in XEmacs."
  :type 'list 
  :tag "Auto-open Files"
  :group 'netbeans-ide)
  
; (defcustom netbeans-frame-x-adjust 0
;   "*Adjustment in pixels to make for the x position of a window."
;   :type 'integer
;   :group 'netbeans-ide)

; (defcustom netbeans-frame-y-adjust 30
;   "*Adjustment in pixels to make for the y position of a window."
;   :type 'integer
;   :group 'netbeans-ide)

; (defcustom netbeans-frame-width-adjust -20
;   "*Adjustment in pixels to make for the width of a window."
;   :type 'integer
;   :group 'netbeans-ide)

; (defcustom netbeans-frame-height-adjust -5
;   "*Adjustment in pixels to make for the height of a window."
;   :type 'integer
;   :group 'netbeans-ide)

(defcustom netbeans-debugging nil
  "*Whether to generate debug messages for %*ide-name*% code."
  :type 'boolean
  :group 'netbeans-ide)

(defcustom netbeans-debugging-logfile nil
  "*When debugging, if this is non-nil then log messages will also be appended to the specified filename."
  :type '(choice file (const nil :tag "Disable"))
  :group 'netbeans-ide)

(defface netbeans-guarded-face
  '((((class grayscale) (background light)) (:inverse-video t))
    (((class grayscale) (background dark)) (:inverse-video t))
    (((class color) (background light)) (:background "light blue"))
    (((class color) (background dark)) (:background "dark blue"))
    (t (:inverse-video t)))
  "Face to use for read-only areas."
  :group 'netbeans-ide)

(defface netbeans-current-face
  '((((class grayscale) (background light)) (:bold t))
    (((class grayscale) (background dark)) (:bold t))
    (((class color) (background light)) (:background "magenta"))
    (((class color) (background dark)) (:background "magenta"))
    (t (:bold t)))
  "Face to use for lines current in the debugger."
  :group 'netbeans-ide)

(defface netbeans-error-face
  '((((class grayscale) (background light)) (:bold t))
    (((class grayscale) (background dark)) (:bold t))
    (((class color) (background light)) (:background "red"))
    (((class color) (background dark)) (:background "red"))
    (t (:bold t)))
  "Face to use for lines marked erroneous by the compiler."
  :group 'netbeans-ide)

(defface netbeans-breakpoint-face
  '((((class grayscale) (background light)) (:italic t))
    (((class grayscale) (background dark)) (:italic t))
    (((class color) (background light)) (:background "medium slate blue"))
    (((class color) (background dark)) (:background "medium slate blue"))
    (t (:italic t)))
  "Face to use for lines broken by the debugger."
  :group 'netbeans-ide)



(defvar *netbeans-network-connection* nil
  "Current %*ide-name*% connection process, if any.")

(defvar *netbeans-buffers* nil
  "Alist from buffer numbers to the actual buffers.")

(defvar *netbeans-positions* nil
  "Alist from position numbers to the actual markers.")

(defvar *netbeans-filter-buffer* nil
  "Buffer of stored strings to process as incoming.")

(defvar *netbeans-sequence-number* nil
  "Last-seen sequence number.")

(defvar *netbeans-doc-timer* nil
  "Idle timer to send insert/delete events from.")

(defvar *netbeans-caret-timer* nil
  "Idle timer to send caret movement events from.")

(defvar netbeans-nofire nil
  "When true (dynamic scope), do not fire changes.")

;; XXX this could also just be an integer (stack depth), ignore all
;; non-top-level changes
(defvar netbeans-change-stack nil
  "Stack of pending change texts, as strings (no text properties).")

(defvar netbeans-atomic-level 0
  "Number of outstanding atomic-runnable requests (possibly in different documents).")

(defvar netbeans-suppress-killhooks nil
  "When true (dynamic scope), do not fire kill events when a buffer is killed.")

(defvar netbeans-leave-xemacs-on-after-exit nil
  "When nil and if %*ide-name*% has not started from XEmacs, prompt the user to exit the current XEmacs by calling `save-buffers-kill-emacs' when %*ide-name*% is exited.")

(defvar netbeans-buffer-number nil
  "Number of this buffer.")
(make-variable-buffer-local 'netbeans-buffer-number)
(put 'netbeans-buffer-number 'permanent-local t)

(defvar netbeans-nonide-fileId nil
  "The ID for each non-IDE owned file for communicating with %*ide-name*%.
This ID is normally the same as the `buffer-file-name'. For IDE owned
files, this ID is nil.")
(make-variable-buffer-local 'netbeans-nonide-fileId)
(put 'netbeans-nonide-fileId 'permanent-local t)

(defvar netbeans-mime-type nil
  "MIME type of this buffer, if specified.")
(make-variable-buffer-local 'netbeans-mime-type)
(put 'netbeans-mime-type 'permanent-local t)

(defvar netbeans-doc-listen nil
  "Whether to fire doc changes in this buffer.")
(make-variable-buffer-local 'netbeans-doc-listen)
(put 'netbeans-doc-listen 'permanent-local t)

(defvar netbeans-caret-listen nil
  "Whether to fire caret changes in this buffer.")
(make-variable-buffer-local 'netbeans-caret-listen)
(put 'netbeans-caret-listen 'permanent-local t)

(defvar netbeans-doc-pending nil
  "Pending document event, as a cons.
Car is position; cdr is a string for an insert, an integer (length) for a remove.
Nil if none pending.")
(make-variable-buffer-local 'netbeans-doc-pending)
(put 'netbeans-doc-pending 'permanent-local t)

(defvar netbeans-caret-last nil
  "Last established caret position, as cons of point and mark.
Nil if never specified.")
(make-variable-buffer-local 'netbeans-caret-last)
(put 'netbeans-caret-last 'permanent-local t)

(defvar netbeans-is-modified nil
  "Whether a buffer should be considered modified.
Only changed as instructed remotely.")
(make-variable-buffer-local 'netbeans-is-modified)
(put 'netbeans-is-modified 'permanent-local t)

(defvar netbeans-as-user nil
  "Locally turned on when in run-as-user mode.")
(make-variable-buffer-local 'netbeans-as-user)
(put 'netbeans-as-user 'permanent-local t)

(defvar netbeans-init-done nil
  "If t, the initial opening of the buffer is done.")
(make-variable-buffer-local 'netbeans-init-done)
(put 'netbeans-init-done 'permanent-local t)

(put 'netbeans-guarded-error 'error-conditions '(netbeans-guarded-error buffer-read-only error))
(put 'netbeans-guarded-error 'error-message "You cannot type in this region, it is protected")
(put 'netbeans-nobuffer-error 'error-conditions '(netbeans-nobuffer-error error))
(put 'netbeans-nobuffer-error 'error-message "Buffer not found")

(defvar netbeans-keymap (make-sparse-keymap))
(define-key netbeans-keymap [pause] 'netbeans-keyboard-pause-event)

(pushnew '(netbeans-buffer-number " Remote-Buffer") minor-mode-alist :test 'equal)
(pushnew (cons 'netbeans-buffer-number netbeans-keymap) minor-mode-map-alist :test 'equal)

;;; XXX give options to use before-string/after-string instead of faces
;; Common
(put 'netbeans-guarded 'face 'netbeans-guarded-face)
(put 'netbeans-guarded 'priority 0)
(put 'netbeans-current-style 'face 'netbeans-current-face)
(put 'netbeans-current-style 'priority 1)
(put 'netbeans-error-style 'face 'netbeans-error-face)
(put 'netbeans-error-style 'priority 1)
(put 'netbeans-breakpoint-style 'face 'netbeans-breakpoint-face)
(put 'netbeans-breakpoint-style 'priority 1)
;; FSF Emacs
(put 'netbeans-guarded 'modification-hooks '(netbeans-check-guard))
(put 'netbeans-guarded 'insert-in-front-hooks '(netbeans-check-guard))
(put 'netbeans-guarded 'evaporate t)
(put 'netbeans-current-style 'evaporate t)
(put 'netbeans-error-style 'evaporate t)
(put 'netbeans-breakpoint-style 'evaporate t)
;; XEmacs
(put 'netbeans-guarded 'read-only t)
(put 'netbeans-guarded 'detachable t)
(put 'netbeans-guarded 'start-open t)
(put 'netbeans-guarded 'end-open t)
(put 'netbeans-current-style 'detachable t)
(put 'netbeans-current-style 'start-closed t)
(put 'netbeans-current-style 'end-open t)
(put 'netbeans-current-style 'style t)
(put 'netbeans-error-style 'detachable t)
(put 'netbeans-error-style 'start-closed t)
(put 'netbeans-error-style 'end-open t)
(put 'netbeans-error-style 'style t)
(put 'netbeans-breakpoint-style 'detachable t)
(put 'netbeans-breakpoint-style 'start-closed t)
(put 'netbeans-breakpoint-style 'end-open t)
(put 'netbeans-breakpoint-style 'style t)


;;;
;;;NetBeans app invocation variables
;;;
(defvar netbeans-app-process nil
  "Process object for %*ide-name*% application")
(defvar netbeans-app-started nil
  "Indicates whether %*ide-name*% has been started by XEmacs")
(defvar netbeans-startup-file nil
  "File containing code to connect XEmacs to %*ide-name*%, when %*ide-name*% is launched from  XEmacs")

(defcustom netbeans-app-invocation-cmd  (list *ide-invocation-cmd* *ide-invocation-args*)
  "Indicates the command and arguments to launch the %*ide-name*% IDE.
   Additional to these arguments, the value of `netbeans-startup-file'
   is also passed to %*ide-name*%."
  :group 'netbeans-ide
  :type '(list (string :tag "Command")  (string :tag "Arguments")))

(defcustom netbeans-show-app-process-output t
  "*Whether to show the output of `netbeans-app-process' in a buffer."
  :type 'boolean
  :group 'netbeans-ide)

(defvar netbeans-output-buffer nil
  "Indicates the buffer where the output of `netbeans-app-process' is displayed, if any." )

(defvar netbeans-nsf-timer nil
  "Indicates the timer  waiting for `netbeans-startup-file'[nsf] to be created" )
(defvar netbeans-nsf-timer-aborted nil
  "Indicates if `netbeans-nsf-timer' is aborted")
(defvar netbeans-nsf-timer-duration 5
  "Indicates how long it takes to timeout the `netbeans-nsf-timer'")
(defvar netbeans-nsf-timer-max 300
  "Indicates the maximum time to wait for `netbeans-startup-file' to be created")
(defvar netbeans-nsf-timer-total 0
  "Indicates the total time elapsed waiting for `netbeans-startup-file'to be created ")
;;;
;;;END NetBeans app invocation variables
;;;

 
(provide 'netbeans-vars)
