;;;                 Sun Public License Notice
;;;
;;; The contents of this file are subject to the Sun Public License
;;; Version 1.0 (the "License"). You may not use this file except in
;;; compliance with the License. A copy of the License is available at
;;; http://www.sun.com/
;;;
;;; The Original Code is NetBeans. The Initial Developer of the Original
;;; Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
;;; Microsystems, Inc. All Rights Reserved.

(require 'cl)
(require 'netbeans-vars)
(require 'netbeans-common)
(require 'netbeans-openfile)

(defun netbeans-connect (host port auth)
  (netbeans-debug "In protocol:connect")
  (netbeans-disconnect)
  (let ((proc (open-network-stream "connect" nil host port)))
    (setq *netbeans-filter-buffer* nil)
    (set-process-filter proc 'netbeans-filter)
    (set-process-sentinel proc 'netbeans-sentinel)
    (netbeans-debug "Sending auth %S" auth)
    (process-send-string proc (concat "AUTH " auth "\n"))
    ;;;XXX set-process-coding-system
    (setq *netbeans-network-connection* proc))
  (netbeans-menu-reinit t)
  (setq *netbeans-sequence-number* 0)
  (setq *netbeans-doc-timer* (netbeans-make-idle-timer "NetBeans Doc Timer" 0.5 'netbeans-doc-idle-flush))
  (setq *netbeans-caret-timer* (netbeans-make-idle-timer "NetBeans Caret Timer" 1.5 'netbeans-caret-idle-flush))
  nil)

(defun netbeans-connect-secure (init-filename)
"Load the `init-filename' to initialize the connection. This file usually has commands to call `netbeans-connect'"
  (netbeans-debug "In protocol:connect2")
  (when (and init-filename
	     (stringp init-filename)
	     (> (length init-filename) 0)
	     (file-exists-p init-filename))
    (load init-filename nil t)
    (delete-file init-filename)))

(defun netbeans-disconnect ()
  (netbeans-debug "In protocol:disconnect")
  (let (ask-for-exit)
    (when *netbeans-network-connection*
      (setq ask-for-exit t)
      (delete-process *netbeans-network-connection*)
      (setq *netbeans-network-connection* nil)
      (netbeans-menu-reinit nil))
    (setq *netbeans-sequence-number* nil)
    (when *netbeans-doc-timer*
      (netbeans-cancel-timer *netbeans-doc-timer*)
      (setq *netbeans-doc-timer* nil))
    (when *netbeans-caret-timer*
      (netbeans-cancel-timer *netbeans-caret-timer*)
      (setq *netbeans-caret-timer* nil))
    (netbeans-reset-openfiles)
    (cond (netbeans-leave-xemacs-on-after-exit t)
	  ((and (not netbeans-app-started) ask-for-exit)
	   (if (yes-or-no-p-dialog-box (format "Do you want to exit XEmacs? "))
	       (save-buffers-kill-emacs))))
    (setq netbeans-leave-xemacs-on-after-exit nil) ;reinit the value 
    nil))

(defun netbeans-filter (proc string)
  (netbeans-debug "In protocol:filter")
  (netbeans-debug "Got string %S" string)
  (let ((newlines (count ?\n string)))
    (netbeans-debug "Newlines: %S" newlines)
    (if (and (not *netbeans-filter-buffer*) (= newlines 1) (= (aref string (1- (length string))) ?\n))
        ;; Simple case.
        (netbeans-handle-line proc string)
      (progn
        (netbeans-debug "Old buffer: %S" *netbeans-filter-buffer*)
        (setq *netbeans-filter-buffer* (if *netbeans-filter-buffer* (concat *netbeans-filter-buffer* string) string))
        (netbeans-debug "New buffer: %S" *netbeans-filter-buffer*)
;;; XXX could be more efficient
        (let (pos)
          (while (and *netbeans-filter-buffer* (setq pos (position ?\n *netbeans-filter-buffer*)))
            (netbeans-debug "Current buffer: %S" *netbeans-filter-buffer*)
            (netbeans-debug "Current pos: %S" pos)
            (let ((to-handle (substring *netbeans-filter-buffer* 0 (1+ pos))))
              (setq *netbeans-filter-buffer* (if (= pos (1- (length *netbeans-filter-buffer*)))
                                                  nil
                                                (substring *netbeans-filter-buffer* (1+ pos))))
              (netbeans-debug "Trimmed buffer: %S" *netbeans-filter-buffer*)
              ;; In case of error in the handler, buffer will still have been trimmed.
              (netbeans-handle-line proc to-handle)))))))
  ;; XXX is this really safe to do within a filter function?
  (when (> netbeans-atomic-level 0)
    (unless (accept-process-output *netbeans-network-connection* 5)
      (netbeans-debug "WARNING--more than five seconds elapsed in atomic mode without news!"))))

(defun netbeans-send (string)
  (netbeans-debug "In protocol:send")
  (netbeans-debug "Sending: `%s'" string)
  (process-send-string *netbeans-network-connection* string)
)

(defun netbeans-handle-line (proc string)
  (netbeans-debug "In protocol:handle-line")
  (netbeans-debug "Handling: %S" string)
  (if (string-equal string "DISCONNECT\n")
      (netbeans-disconnect)
    (let ((request (netbeans-parse-request string)))
      (let ((bufnum (car request))
            (cmd (cadr request))
            (isfun (caddr request))
            (seq (cadddr request))
            (args (cddddr request)))
        (setq *netbeans-sequence-number* seq)
        (if isfun
            (let ((sym (intern (concat "netbeans-fun-" cmd))))
              (let ((result (condition-case err
                                (apply sym bufnum args)
                              (error (let ((msg (error-message-string err)))
                                       (netbeans-debug "ERROR during function call: %s" msg)
                                       (list '! msg))))))
                (netbeans-debug "Will send %S %S" seq result)
;maybe fluch buffer here
                (netbeans-send (netbeans-create-response seq result))))
          (let ((sym (intern (concat "netbeans-cmd-" cmd))))
            (condition-case err
                (apply sym bufnum args)
              (error (netbeans-debug "ERROR during command call: %s" (error-message-string err))))))))))

(defun netbeans-parse-request (string)
(netbeans-debug "In protocol:parse-request")
  (unless (string-match "^\\([0-9]+\\):\\([a-zA-z_]+\\)\\([/!]\\)\\([0-9]+\\)\\(\\( \\(T\\|F\\|none\\|-[0-9]+\\|[0-9]+\\|\"\\([^\\\\\"\n]\\|\\\\\\\\\\|\\\\\"\\|\\\\n\\|\\\\r\\)*\"\\)\\)*\\)\n" string)
    (setq *netbeans-filter-buffer* nil)
    (netbeans-debug "MISPARSE: %S" string)
    (error "Malformed request: %S" string))
  (let ((res (list (string-to-number (match-string 1 string))
                   (match-string 2 string)
                   (string-equal "/" (match-string 3 string))
                   (string-to-number (match-string 4 string)))))
    (let ((args (match-string 5 string)))
      (let ((quickie (read (concat "(" args ")"))))
        (let ((filtered (substitute t 'T (substitute nil 'F quickie))))
          (nconc res filtered)
          res)))))

(defun netbeans-create-response (seq args)
(netbeans-debug "In protocol:create-response")
  (concat (number-to-string seq) (netbeans-create-arguments args) "\n"))

(defun netbeans-create-event (bufnum cmd args)
(netbeans-debug "In protocol:create-event")
  (concat (number-to-string bufnum) ":" cmd "="
          (number-to-string *netbeans-sequence-number*) (netbeans-create-arguments args) "\n"))

(defun* netbeans-create-arguments (args)
  (netbeans-debug "In protocol:create-arguments")
  (netbeans-debug "netbeans-create-arguments %S" args)
  (if args
      (let ((filtered (substitute 'T t (substitute 'F nil args))))
        (let ((almost (prin1-to-string filtered)))
          (setq almost (substring almost 1 (1- (length almost))))
          (let ((result "")
;                (end (length almost))
                (pos 0))
            (while t
              (let* ((uptonl (position ?\n almost :start pos))
                     (uptocr (position ?\r almost :start pos))
                     (upto (cond
                            ((and (not uptonl) (not uptocr)) nil)
                            ((and uptonl (not uptocr)) (cons uptonl t))
                            ((and (not uptonl) uptocr) (cons uptocr nil))
                            ((and uptonl uptocr) (if (< uptonl uptocr) (cons uptonl t) (cons uptocr nil))))))
                (if upto
                    (progn
                      (setq result (concat result (substring almost pos (car upto)) (if (cdr upto) "\\n" "\\r")))
                      (setq pos (1+ (car upto))))
                    (return-from netbeans-create-arguments (concat " " result (substring almost pos)))))))))
    ""))

(defun netbeans-sentinel (process event)
(netbeans-debug "In protocol:sentinel")
  (netbeans-debug "Process %S received event %S" process event)
  (netbeans-disconnect))

(defun* netbeans-event-no-flush (bufnum cmd &rest args)
(netbeans-debug "In protocol:event-no-flush")
  (netbeans-debug "Event %S %S %S" bufnum cmd args)
  (when  *netbeans-network-connection*
    ;;if bufnum is nil, return nil
    (if (not bufnum)
	nil
      ;; Check to see if the args list contains a list,
      ;; in which case, there is an extra set of parenthesis when the
      ;; string is sent. therefore, we need to only send the inner list.
      (if (equal 1 (length args))
	  (setq args (car args)))
      (netbeans-debug "Event %S %S %S" bufnum cmd args)
      (netbeans-send (netbeans-create-event bufnum cmd args)))))

(defun* netbeans-event (bufnum cmd &rest args)
(netbeans-debug "In protocol:event")
  (netbeans-debug "Event %S %S %S" bufnum cmd args)
  (when  *netbeans-network-connection*
    ;;if bufnum is nil, return nil
    (if (not bufnum)
	nil
      (netbeans-doc-idle-flush)
      (netbeans-event-no-flush bufnum cmd args))))

(defun netbeans-init-openfiles ()
"Initially, this function lets the IDE know about which files are already open in Emacs"
(netbeans-debug "In protocol: netbeans-init-openfiles")
(let ( (buffers (buffer-list)))
    (netbeans-debug "buffers = %s" buffers)
    (save-excursion
      (while buffers
        (let* ( (buffer (car buffers))
                (name (buffer-name buffer)))
          (setq buffers (cdr buffers))
          (cond ((null name)
                 (netbeans-debug "FAIL: null = <%s>" name));deleted buffer
                ((and (/= 0 (length name))
		      (= (aref name 0) ?\ ))
		      ;;don't mention if starts with " "
                  (netbeans-debug "FAIL: starts with \" \"  = <%s>" name)
		 nil)
                 ((not (buffer-file-name buffer))
                  (netbeans-debug "FAIL: not file   <%s>" name)
                  nil)
                (t
                  (netbeans-debug "PASS:  <%s>" name)
                  (netbeans-notify-fileOpened buffer)
		  (netbeans-process-guarded-text buffer)
                )
                
))))))

(defun netbeans-reset-openfiles ()
  "This function removes all of the hooks and stuff set by the IDE from all of the opened files in XEmacs."
  (netbeans-debug "In protocol: netbeans-reset-openfiles")
  (let ( (buffers (buffer-list)))
    (netbeans-debug "buffers = %s" buffers)
    (while buffers
      (let* ( (buffer (car buffers))
	      (name (buffer-name buffer)))
	(setq buffers (cdr buffers))
	(save-excursion
	  (set-buffer name)
	  (netbeans-remove-hooks-and-stuff)))))
  (setq *netbeans-buffers* nil))

(provide 'netbeans-protocol)
