;;;                 Sun Public License Notice
;;;
;;; The contents of this file are subject to the Sun Public License
;;; Version 1.0 (the "License"). You may not use this file except in
;;; compliance with the License. A copy of the License is available at
;;; http://www.sun.com/
;;;
;;; The Original Code is NetBeans. The Initial Developer of the Original
;;; Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
;;; Microsystems, Inc. All Rights Reserved.

(require 'cl)
(require 'netbeans-vars)
(require 'netbeans-common)

;;;opening a file
;;;EVT_fileOpened
(defun netbeans-notify-fileOpened (buffer)
"Notifies the IDE that BUFFER is opened in Emacs.
If any regexp defined in `netbeans-auto-open-files'
matches the filename, the IDE mounts and  opens the file of the BUFFER
and the function returns true. Otherwise it adds hooks to BUFFER to detect whenever it is modified and returns false."
 (netbeans-debug "in openfile:netbeans-notify-fileOpened")
 (block func
  (save-excursion
    (set-buffer buffer) 
    (let ((mylist netbeans-auto-open-files)
          (filename (buffer-file-name buffer))
          (buffnum netbeans-buffer-number))
        (netbeans-debug "buffernum = %s filename = %s" buffnum filename)
	(if (not filename)
	    (return-from func nil))
        (if (not buffnum)
            (setq buffnum 0)
          (netbeans-debug "The file %s is already opened by the IDE" filename)
          (message "The file %s is already opened by the IDE" filename)
          (return-from func t))
	(when  *netbeans-network-connection*
	  (while mylist
	    (let ((regexp (car mylist)))
	      (if (string-match regexp filename)
		  (progn
		    (netbeans-debug "matched %s with %s" regexp filename)
		    (netbeans-debug "IDE file: %s %s ..." filename buffnum)
		    (netbeans-event buffnum  "fileOpened" filename t (buffer-modified-p))
		    (set 'mylist nil)
		    (return-from func t))
		(set 'mylist (cdr mylist)))))
	  (netbeans-debug "Emacs file: %s..." filename)
	  (netbeans-event buffnum  "fileOpened" filename nil (buffer-modified-p))
	  (netbeans-add-nonide-hooks-and-stuff)
	  nil)))))



(defun netbeans-mount-and-open-file ()
"Tells the IDE to mount and open the file."
(interactive)
 (message "Mounting the file in %s..." *ide-name*)
 (if (not netbeans-buffer-number)
   (progn 
     (netbeans-remove-hooks-and-stuff )
     (netbeans-event 0  "fileOpened" (buffer-file-name) t (buffer-modified-p)))))

; (define-key global-map "\C-x\C-m" 'netbeans-mount-and-open-file)

;;; overriding find-file  function
;;;

(defvar netbeans-orig-find-file-noselect nil)
(fset 'netbeans-orig-find-file-noselect (symbol-function 'find-file-noselect))

(defun netbeans-find-file-noselect-dispatch (filename &optional nowarn rawfile)
  "Dispatches the find-file-noselect function to call `netbeans-notify-fileOpened' function."
  (netbeans-debug "in openfile:netbeans-find-file-noselect-dispatch")
  (let ((buf (netbeans-orig-find-file-noselect filename nowarn rawfile)))
    (when filename
      (netbeans-notify-fileOpened buf )
      (netbeans-process-guarded-text buf)
      (netbeans-menu-create buf))
   buf))

(fset 'find-file-noselect (symbol-function 'netbeans-find-file-noselect-dispatch))
;;;DONE dispatching find-file


(provide 'netbeans-openfile) 
