;;;                 Sun Public License Notice
;;;
;;; The contents of this file are subject to the Sun Public License
;;; Version 1.0 (the "License"). You may not use this file except in
;;; compliance with the License. A copy of the License is available at
;;; http://www.sun.com/
;;;
;;; The Original Code is NetBeans. The Initial Developer of the Original
;;; Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
;;; Microsystems, Inc. All Rights Reserved.

(require 'cl)
(require 'netbeans-vars)
(require 'netbeans-protocol)
(require 'netbeans-common)

(defun netbeans-kill-hook ()
 (netbeans-debug "In events:kill-hook")
  ;;if bufnum is nil and there is a netbeans-nonide-fileId, send "fileClosed" event.
  (netbeans-debug "netbeans-kill-hook on %S" netbeans-buffer-number)
  (if (not netbeans-buffer-number)
     (when netbeans-nonide-fileId
       (netbeans-event 0  "fileClosed" netbeans-nonide-fileId)
       (netbeans-debug "fileClosed event sent..."))
    (unless netbeans-suppress-killhooks
      (netbeans-event netbeans-buffer-number "killed")
      (setq *netbeans-buffers*
	    (delq (assq netbeans-buffer-number *netbeans-buffers*)
		  *netbeans-buffers*)))))

(defun netbeans-before-change (beg end)
 (netbeans-debug "In events:before-change")
  (let ((old-chg-text (if (= beg end) nil (buffer-substring-no-properties beg end))))
    (netbeans-debug "netbeans-before-change %s %s %S" beg end old-chg-text)
;;; XXX this is not too good...if netbeans-check-guards signals an error,
;;; the stack will grow needlessly and never be cleared
    (push old-chg-text netbeans-change-stack)))

(defun netbeans-after-change (beg end prevlen)
 (netbeans-debug "In events:after-change")
 (if netbeans-nofire
     (set-buffer-modified-p netbeans-is-modified)
   (netbeans-debug "netbeans-after-change %s %s %s" beg end prevlen)
   (let ((new-chg-text (if (= beg end) nil (buffer-substring-no-properties beg end))))
     (netbeans-debug "new-chg-text=%S" new-chg-text)
     (if (equal new-chg-text (pop netbeans-change-stack))
	 (netbeans-debug "ignoring textprops-only change")
       (progn
	 (when (not (zerop prevlen))
	   (netbeans-append-change (cons (1- beg) prevlen)))
	 (when new-chg-text
	   (netbeans-append-change (cons (1- beg) new-chg-text))))))))

(defun netbeans-append-change (chg)
 (netbeans-debug "In events:append-change")
  (let ((merged (netbeans-merge-changes netbeans-doc-pending chg)))
    (netbeans-debug "netbeans-append-change: merging %S + %S = %S" netbeans-doc-pending chg merged)
    (if merged
        (progn
          (setq netbeans-doc-pending merged))
      (progn
        (netbeans-send-chg netbeans-doc-pending)
        (setq netbeans-doc-pending chg)))))

(defun netbeans-merge-changes (chg1 chg2)
 (netbeans-debug "In events:merge-change")
  (if (not chg1)
      chg2
    (if (not chg2)
        chg1
      (let ((is-r-1 (numberp (cdr chg1)))
            (is-r-2 (numberp (cdr chg2)))
            (pos-1 (car chg1))
            (pos-2 (car chg2)))
        ;; XXX many more merges are possible, focussing here only on
        ;; common case of user typing continuously -> many 1-char
        ;; inserts
        (if (and (not is-r-1) (not is-r-2)
                 (= pos-2 (+ pos-1 (length (cdr chg1)))))
            (cons pos-1 (concat (cdr chg1) (cdr chg2)))
          nil)))))

(defun netbeans-send-chg (chg)
 (netbeans-debug "In events:send-chg")
;  (netbeans-debug "netbeans-send-chg chg=%S netbeans-doc-listen=%S" chg netbeans-doc-listen)
  (when (and netbeans-doc-listen chg)
    (netbeans-event-no-flush netbeans-buffer-number (if (numberp (cdr chg)) "remove" "insert") (car chg) (cdr chg))))

(defun netbeans-doc-idle-flush ()
  (netbeans-debug "In events:doc-idle-flush")
  (save-excursion
;    (netbeans-debug "netbeans-doc-idle-flush: *netbeans-buffers*=%S" *netbeans-buffers*)
    (dolist (pair *netbeans-buffers*)
      (set-buffer (cdr pair))
;      (netbeans-debug "netbeans-doc-idle-flush: pair=%S netbeans-doc-pending=%S" pair netbeans-doc-pending)
      (when netbeans-doc-pending
;        (netbeans-debug "netbeans-doc-idle-flush: have changes to send")
        (netbeans-send-chg netbeans-doc-pending)
        (setq netbeans-doc-pending nil)))))
;    (netbeans-debug "netbeans-doc-idle-flush (done)")))

(defun netbeans-caret-idle-flush ()
 (netbeans-debug "In events:caret-idle-flush")
  (let ((curr-buf (current-buffer))
	tokill)
    (save-excursion
      (dolist (pair *netbeans-buffers*)
        (let ((buffer (cdr pair)))
	  (netbeans-debug "isCurrentBuffer = %s buffer = %s current=%s" (eq buffer curr-buf) buffer curr-buf)
          (if (buffer-name buffer) 
              (progn
		(set-buffer buffer)
		(if (not netbeans-init-done)
		    (netbeans-debug "Skipping uninitialized buffer %s" (buffer-name buffer)) 
		  (let ((caret (cons (1- (point)) (1- (if (netbeans-the-mark) (mark) (point))))))
		    (when (and netbeans-caret-listen 
			       (or
				(not (equal caret netbeans-caret-last))
				(eq buffer curr-buf)))
					;(netbeans-debug "netbeans-caret-idle-flush %S -> %S" netbeans-caret-last caret)
		      (netbeans-event netbeans-buffer-number "newDotAndMark" (car caret) (cdr caret))
		      (setq netbeans-caret-last caret)))))
            (push pair tokill)))))
    (dolist (kill tokill)
      (netbeans-debug "Removing dead buffer from *netbeans-buffers*: %S" kill)
      (setq *netbeans-buffers* (delq kill *netbeans-buffers*)))))

;;;EVT_keyCommand 
(defun netbeans-keyboard-event (&optional ev)
"Captures the keybinding from EV and delivers it to the IDE.
If EV is not specified, it gets the event from this-command-keys"
  (interactive)
  (netbeans-debug "In events:keyboard-event")
  (let ((caret (cons (1- (point)) (1- (if (netbeans-the-mark) (mark) (point))))))
    (when netbeans-caret-listen
      (netbeans-event netbeans-buffer-number "newDotAndMark" (car caret) (cdr caret))
      (setq netbeans-caret-last caret)))
  (if (not ev)
      (setq ev (aref (this-command-keys) 0 )))
  (let  ((mods (event-modifiers ev))
	 (type (if (boundp 'running-xemacs)
		 (event-key ev)
	       (event-basic-type ev))))
    (netbeans-debug "mods is %s type is %s" mods type)
    (netbeans-event netbeans-buffer-number "keyCommand" (netbeans-encode-key type mods))))

(defun netbeans-keyboard-pause-event ()
"Callback function for the pause key. Gets the event from the next command and
calls netbeans-keyboard-event"
  (netbeans-debug "In events:keyboard-pause-event")
  (interactive)
  (let* ((prompt "Key to send to remote application: ")
         (ev (if (boundp 'running-xemacs)
                 (next-command-event nil prompt)
               (read-event prompt))))
         (netbeans-keyboard-event  ev)))
;;;EVT_keyCommand END

;;;EVT_save
(defun netbeans-save-buffer (&optional ARGS)
"If the buffer is IDE owned, it lets the IDE save the buffer. Otherwise Emacs saves the buffer"
  (netbeans-debug "in events:netbeans-save-buffer")
  (let ((pair (assq netbeans-buffer-number *netbeans-buffers*)))
      (if pair
       (progn 
         (netbeans-debug "Calling IDE  Save...")
         (netbeans-event netbeans-buffer-number  "save")
         (set-buffer-modified-p nil)
	 (message "%s wrote file %s !" *ide-name* buffer-file-name)
         t)
       (progn
        (netbeans-debug "Calling Emacs Save...")
        nil)))) 

(add-hook 'write-contents-hooks 'netbeans-save-buffer)  
;;; EVT_save done

;;;save as
(defun netbeans-before-save-as ()
  "The hook to be called  before saving the buffer in a new file."
  (netbeans-debug "in events:netbeans-before-save-as")
  (set-buffer-modified-p nil)
  (netbeans-unset-modified-flag)
  (netbeans-kill-hook)
  (netbeans-remove-hooks-and-stuff)
  (make-local-hook 'after-save-hook)
  (add-hook 'after-save-hook 'netbeans-after-save-as nil t))

(defun netbeans-after-save-as ()
  "The hook to be called  after saving the buffer in a new file."
  (netbeans-debug "in events:netbeans-after-save-as")
  (remove-hook 'after-save-hook 'netbeans-after-save-as t)
  (netbeans-notify-fileOpened (current-buffer))
  ;;reinit the Tools menu items
  (netbeans-clean-tools-menu)
  (when  *netbeans-network-connection*
    (netbeans-create-import-class-menuItem)))

(add-hook 'after-set-visited-file-name-hooks 'netbeans-before-save-as)
;;;end save as

;;;EVT_filemodified
(defun netbeans-add-fileModified-hooks ()
  "Add hooks for tracking down when the buffer is modified. (only for non-IDE-owned files)"
  (netbeans-debug "in events:netbeans-add-fileModified-hooks")
  (if (buffer-modified-p)
      (netbeans-set-modified-flag))
  (make-local-hook 'first-change-hook)
  (add-hook 'first-change-hook 'netbeans-set-modified-flag nil t)
  (make-local-hook 'after-save-hook)
  (add-hook 'after-save-hook   'netbeans-unset-modified-flag nil t)
  (make-local-hook 'post-command-hook)
  (add-hook 'post-command-hook 'netbeans-undo-hook nil t)
  (make-local-hook 'after-revert-hook)
  (add-hook 'after-revert-hook 'netbeans-after-revert-nonide-hook nil t)
)

(defun netbeans-remove-fileModified-hooks ()
   "Remove hooks for tracking down when the buffer is modified. (only for non-IDE-owned files)"
  (netbeans-debug "in events:netbeans-remove-fileModified-hooks")
  (remove-hook 'first-change-hook 'netbeans-set-modified-flag  t)
  (remove-hook 'after-save-hook   'netbeans-unset-modified-flag t)
  (remove-hook 'post-command-hook 'netbeans-undo-hook t)
  (remove-hook 'after-revert-hook 'netbeans-after-revert-nonide-hook t)
)

(defun netbeans-after-revert-nonide-hook ()
  "Notify client that a non-IDE owned file has been reverted."
  (netbeans-debug "in events:netbeans-after-revert-nonide-hook")
  (netbeans-unset-modified-flag)
   ;;;initialize the hooks again
  (netbeans-remove-fileModified-hooks)
  (netbeans-add-fileModified-hooks))

(defun netbeans-undo-hook ()
  "Notify client that a file has been unmodified by Undo action."
  ;;;(netbeans-debug "in events:netbeans-undo-hook")
  ;;;(netbeans-debug "modified = %s " (buffer-modified-p))
  ;;;(netbeans-debug "command  = %s %s " this-command (eq this-command 'undo))
  ;;;(netbeans-debug "filename  = %s " buffer-file-name )
  (when (and  (not (buffer-modified-p))
	      (eq this-command 'undo))
    (netbeans-debug "unmodified by Undo")
    (netbeans-unset-modified-flag)))

(defun netbeans-unset-modified-flag ()
  "Notify client that the current buffer has been unmodified.
   The `netbeans-nonide-fileId' is used to send `fileModified' event for a non-IDE owned file"
  (netbeans-debug "in events:netbeans-unset-modified-flag")
  (if (not netbeans-buffer-number)
      (when netbeans-nonide-fileId
	  (netbeans-event 0  "fileModified" netbeans-nonide-fileId  nil))
    (netbeans-doc-idle-flush)
    (netbeans-event netbeans-buffer-number  "unmodified"))
  (setq buffer-undo-list nil))

(defun netbeans-set-modified-flag ()
  "Notify client that a non-IDE owned file has been modified."
  (netbeans-debug "in events:netbeans-set-modified-flag")
  (when netbeans-nonide-fileId
    (netbeans-event 0  "fileModified" netbeans-nonide-fileId  t)))

;;; EVT_revert
(defun netbeans-revert-ide-buffer (ignore-auto noconfirm)
  "Notify client to revert the IDE file."
  (netbeans-debug "in events:netbeans-revert-ide-buffer")
  (if (yes-or-no-p (format "Revert buffer from file %s? "
				      buffer-file-name))
      (progn
	(netbeans-debug "Reverting buffer")
	(netbeans-event netbeans-buffer-number  "revert"))
    (netbeans-debug "Cancel reverting the  buffer")))
;;;END EVT_revert

;;;EVT_quit
(defun netbeans-quit ()
  "Quit %*ide-name*% application and close all of the windows."
  (interactive)
  (netbeans-debug "in events:netbeans-quit")
  (setq netbeans-leave-xemacs-on-after-exit t)
  (netbeans-event 0  "quit"))
;;; END EVT_quit

;;;EVT_geometry
(defun netbeans-frame-selected ()
  "Notify client of the current frame position"
  (netbeans-debug "in events:netbeans-frame-selected")
  (let ((the-frame (window-frame)))
    (netbeans-event 0  "geometry"
		    (frame-property the-frame 'width)
		    (frame-property the-frame 'height )
		    (frame-property the-frame 'left )
		    (frame-property the-frame 'top))))

(make-local-hook 'select-frame-hook)
(add-hook 'select-frame-hook 'netbeans-frame-selected)
;;; END EVT_geometry

;; XXX make customizable?
(defconst netbeans-key-encoding-mapping
  '(
    (?& . ampersand)
    (?* . asterisk)
    (?@ . at)
    (?` . back_quote)
    (?\\ . back_slash)
    (?{ . brace_left)
    (?} . brace_right)
    (?^ . circumflex)
    (?] . close_bracket)
    (?: . colon)
    (?, . comma)
    ;; delete
    (?/ . divide)
    (?$ . dollar)
    ;; down
    ;; end
    (return . enter)
    (?= . equals)
    ;; escape
    (?! . exclamation_mark)
    ;; f1, etc.
    (?> . greater)
    ;; home
    ;; insert
    ;; left
    (?( . left_parenthesis)
    (?< . less)
    (?- . minus)
    (?# . number_sign)
    (?[ . open_bracket)
    (next . page_down)
    (prior . page_up)
    ;; pause
    (?. . period)
    (?+ . plus)
    (?' . quote)
    (34 . quotedbl) ; ?"
    (?) . right_parenthesis)
    (59 . semicolon) ; ?;
    (?/ . slash)
    (?  . space)
    ;; tab
    (?_ . underscore)
    ;; up
    ;; XXX tilde, percent-sign, pipe, question-mark all send shift-something
    ;; and thus will need to be specially handled
    ;; XXX have not bothered with e.g. kp_down and so on
    ;; XXX backspace vs. delete...
    )
  "Bindings from ASCII characters or Emacs key event symbols, to the proper Java VK_* suffixes.
Not necessary if the symbol/char already stands for itself.
Everything is automatically upcased as is required.")

(defun netbeans-encode-key (type mods)
 (netbeans-debug "In events:encode-key")
  (netbeans-debug "netbeans-encode-key %S %S" type mods)
  (let ((modstring (mapconcat (lambda (mod)
                                (cdr (assq mod '((meta . "M") (control . "C") (shift . "S") (alt . "A")))))
                              mods nil)))
    (concat modstring (if (string-equal modstring "") nil "-")
            (let ((basekey (or (cdr (assq type netbeans-key-encoding-mapping)) type)))
              (if (or (numberp basekey) (characterp basekey))
                  (char-to-string (upcase basekey))
                (upcase (symbol-name basekey)))))))

(provide 'netbeans-events)
