#
# Copyright (c) 1999 Sun Microsystems Inc.,
# All rights reserved.
#
#
#ident       "@(#) sspStatus-d.x        1.4     03/07/15 SMI"

_services = { [ use SERVICE ]
	sh = {
		command = "pipe://localhost//bin/sh;transport=shell"
		max = 2
	}
}

_filters = { [ use PROC ]
    [ source sspStatus-d.flt ]
}

[ use MANAGED-MODULE ]
[ load sspStatus-m.x ]
[ requires template sspStatus-models-d ]

# log the module oid at load
activateActions(post)	= logoid
activateService(logoid) = .iso*sspStatus
activateCommand(logoid) = ddl print info "sspStatus oid [ilookup internal fulloid]"

status = { [ use templates.sspStatus-models-d.status  ]

	status = { [ use templates.sspStatus-models-d.status.status _filters ]
		type		= active
		refreshMode	= async
		refreshInterval	= 120
		refreshService	= _services.sh
		refreshCommand  = ps -e
		refreshFilter   = checkStatus
	}
	hostname = { [ use templates.sspStatus-models-d.status.hostname ]
		type		= active
		refreshMode	= sync
	        timeoutInterval = 60
		refreshInterval	= 0
		refreshService	= _internal
		refreshCommand  = toe_send [locate .config.platform] {slookup value platformServer}
	}
}

[ load sspStatus-d.def ]

