package Thread;
use Util;
use strict;

# Thread->new({     TO      => 60
#               device_list => [dev1,dev2,...] 
#                 max       => 5,
#                displayFunction => \&printit(),
#             });

sub new {
  my($class, $arg) = @_;
  my $th = {};
  my ($x, @buckets);
  $th->{TO}          = $arg->{TO} || 60;
  $th->{device_list} = $arg->{device_list}; 
  $th->{max}         = $arg->{max} || 1; # max threads at the same time.
  $th->{debugLevel}  = $arg->{debugLevel} || "1";
  $th->{_last}       = 0;
  $th->{_display}    = $arg->{displayFunction};
  $th->{_buckets}    = [];
  my $D = System->get_home() . "/DATA/Thread";
  mkdir $D,0777 if (!-d $D);

  opendir(O, $D); my @F = readdir(O); closedir(O);
  foreach my $f (@F) {
     next if (substr($f,0,1) eq ".");
     if ($f =~ /(\d+).\w+\.pid$/) {
        if (open(O, "$D/$f")) {
           my $pid = <O>; close(O);
           kill 9, $pid if ($pid =~ /\d+/) ;
        }
     }
     unlink "$D/$f";
  }

  bless($th, 'Thread');
  return $th;
}

sub INSTRUMENTATION {
  my($th, $device) = @_;
  my $tt    = uc($device->{type}) ;
  require     "Agent/$tt.pm";
  my $agent = "Agent::$tt";
  my $report = $agent->INSTRUMENTATION($device);
  return $report;
}


sub run {
  my($th) = @_;
  my $dev_list = $th->{device_list};
  my $TO       = $th->{TO};
  my $last     = $th->{_last};
  my $B        = $th->{_buckets};
  my $disp     = $th->{_display};

  return [] if ($#$dev_list < 0);

  if ($th->{max} == 1 || $#$dev_list == 0) {
     return [] if ($last > $#$dev_list);
     $th->{_last} = $last+1;
     &$disp($dev_list->[$last]) if ($disp);
     return [ [ $dev_list->[$last], $th->INSTRUMENTATION($dev_list->[$last]) ] ];
  }

  my $cnt = 0;
  my $pid = $$;
  my $start = time;
  my (@LIST, $x);
  my $DIR = System->get_home() . "/DATA/Thread";
  chdir System->get_home();

  while (1) {
    my $running;
    for ($x=0; $x < $th->{max}; $x++) {
       my $b = $B->[$x] || [];
       if (!$b->[1] && $last <= $#$dev_list) {      # AVAILABLE SPOT
          my $dev = $dev_list->[$last];
          my $pid2;
          my $key  = $dev->{key};
          my $type = $dev->{type};
          my $prgm = "bin/ras_thread -k \"$type:$key\" -p $pid -l $th->{debugLevel} ";
          Debug->print3("   Thread: $prgm");
          unlink "$DIR/$pid.$key";
          system("$prgm&");
          &$disp($dev) if ($disp);
          $B->[$x] = [time, $key, $dev];
          $last++; $th->{_last} = $last;  $running++;
  
       } elsif ($b->[1]) {
          my $t_file = "$DIR/$pid.$b->[1]";
          if ( -f $t_file ) {                  # DONE
            my $report = Util->deserialize("Thread/$pid.$b->[1]");
            unlink $t_file;
            push(@LIST, [$b->[2], $report, time - $b->[0]]);
            $B->[$x] = [];

          } elsif (time - $b->[0] >= $TO) {    # TIMEOUT
            if (open(OO, "$t_file.pid")) {
               my $pid2 = <OO>; close(OO);
               print "Thread: Trying to kill $pid2: $t_file\n";
               kill 9, $pid2;
               unlink "$t_file.pid";
               unlink $t_file;
               my $report = { "rc.error" => "timeout error ($TO secs)", wwn => $b->[1] };
               push(@LIST, [$b->[2], $report, $TO]);
            }
            $B->[$x] = [];
          } else {
            $running++;
          }
       }
    }
    last if ($#LIST >= 0 || !$running);
    sleep(2);
  }
  return \@LIST;
}
  

1;
