package TO::9900;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
sub type { '9900'}
sub leaf { 1 }

sub portLabel {
  my($class, $port) = @_;
  return "port-$port";
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}


sub new {
  my($class, $to, $host, $dev) = @_;

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key       = $dev->{key};
  my $type      = $dev->{type};

  my $obj = {};
  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = "$type:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "oob";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "Sun $type";
  $DB::single= 1;

  $obj->{port}     = [];
  $obj->{portInfo} = [];

  bless($obj, "TO::$type");
  $syns->{$key} = "$type:$key";
  $storages->{"$type:$key"} = $obj;
  return $obj;
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne $class->type());
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     return if ($topo->nodeByName($k));

     $class->new($topo, $renv->{hostname}, $dev);
  }
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components();
  my $i       = $Comp->value("$name:e");
  my $iIB     = $Comp->value("$name:ib");

  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my $port;
  my $portInfo;
  #Power/Fan/Processor/Battery/Others
  my ($other, $otherInfo) = $Comp->summary($name, 
                  ["controller.PS|disk.PS",
                   "controller.Fan|disk.Fan",
                   "controller.Processor",
                   "controller.Battery", 
                   ]);

  my($disk, $diskInfo, $d);

  my $i1 = $Comp->value("$name:disk*",0);
  $disk     .= "$i1,";
  $diskInfo .= $Comp->value("$name:disk.Drive",1) . ",";

  return ($enc, $port, $disk, $other, $encInfo, $portInfo, $diskInfo, $otherInfo);
}




sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);
  my $rows =  4;
  my ($x, $dd);
  for ($x=1; $x <= $rows; $x++) {
    $dd .= "$x/";
  }
  chop($dd) if ($dd);
  my $ports = 4;

  $cat = "a,SE9900,$ports/   ,10/slot,$dd,PFRBO,Power/Fan/Processor/Battery/Others,E0D0F0/9900.gif";

  $label2 = $obj->{info}{LGroup};
  $ses = 1;

  return ($cat, $label2, $ses);
}

# "a,$t3,2/12,-$dt,$dd,LMPVA,Loop/Midplane/Power/Volumes/Alerts,D0D0F0/t3pg.gif";

1;
